/* rygel-media-container.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-media-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaContainerSearchData RygelMediaContainerSearchData;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelMediaContainerFindObjectData RygelMediaContainerFindObjectData;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaContainerSearchInChildrenData RygelMediaContainerSearchInChildrenData;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*search) (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* _result_;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* children;
	guint limit;
	gboolean _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* _child_list;
	gint _tmp4_;
	gint _child_size;
	gint _child_index;
	gpointer _tmp5_;
	RygelMediaObject* child;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gint _tmp9_;
	gboolean _tmp10_;
	gint _tmp11_;
	guint _tmp12_;
	gint _tmp13_;
	guint child_limit;
	RygelMediaObjects* _tmp14_;
	RygelMediaObjects* child_results;
	gboolean _tmp15_;
	gint _tmp16_;
	guint start;
	guint stop;
	gint _tmp17_;
	guint _tmp18_;
	gboolean _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GeeList* _tmp22_;
	GeeList* _tmp23_;
	gint _tmp24_;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelMediaContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelRelationalExpression* _tmp0_;
	RygelRelationalExpression* expression;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	guint total_matches;
	guint _tmp5_;
	RygelMediaObjects* _tmp6_;
	RygelMediaObjects* results;
	gint _tmp7_;
	gpointer _tmp8_;
	GError * _inner_error_;
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelMediaContainerSearchInChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	RygelSearchExpression* expression;
	RygelMediaObjects* children;
	guint limit;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* _result_;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* _child_list;
	gint _tmp2_;
	gint _child_size;
	gint _child_index;
	gpointer _tmp3_;
	RygelMediaObject* child;
	RygelMediaObject* _tmp4_;
	RygelMediaContainer* _tmp5_;
	RygelMediaContainer* container;
	guint tmp;
	guint _tmp6_;
	RygelMediaObjects* _tmp7_;
	RygelMediaObjects* child_result;
	gboolean _tmp8_;
	gint _tmp9_;
	GError * _inner_error_;
};


static gpointer rygel_media_container_parent_class = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY,
	RYGEL_MEDIA_CONTAINER_OCM_FLAGS
};
#define RYGEL_MEDIA_CONTAINER_UPNP_CLASS "object.container"
#define RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".storageFolder"
#define RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".album.musicAlbum"
#define RYGEL_MEDIA_CONTAINER_MUSIC_ARTIST RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".person.musicArtist"
#define RYGEL_MEDIA_CONTAINER_MUSIC_GENRE RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".genre.musicGenre"
RygelMediaContainer* rygel_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value);
static void rygel_media_container_on_container_updated (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaContainer* updated_container);
static void _rygel_media_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
RygelMediaContainer* rygel_media_container_construct_root (GType object_type, const gchar* title, gint child_count);
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_media_container_real_search_data_free (gpointer _data);
static void rygel_media_container_real_search (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_search (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_search_finish (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_media_container_real_search_co (RygelMediaContainerSearchData* data);
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
gboolean rygel_search_expression_satisfied_by (RygelSearchExpression* self, RygelMediaObject* media_object);
static void rygel_media_container_search_in_children (RygelMediaContainer* self, RygelSearchExpression* expression, RygelMediaObjects* children, guint limit, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObjects* rygel_media_container_search_in_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_media_container_real_find_object_data_free (gpointer _data);
static void rygel_media_container_real_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_container_real_find_object_co (RygelMediaContainerFindObjectData* data);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
void rygel_media_container_updated (RygelMediaContainer* self);
static GUPnPDIDLLiteObject* rygel_media_container_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self);
static void rygel_media_container_search_in_children_data_free (gpointer _data);
static void rygel_media_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_media_container_search_in_children_co (RygelMediaContainerSearchInChildrenData* data);
static void rygel_media_container_finalize (GObject* obj);
static void _vala_rygel_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _rygel_media_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
	rygel_media_container_on_container_updated (self, _sender, container);
}


RygelMediaContainer* rygel_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count) {
	RygelMediaContainer * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
	_tmp0_ = g_strdup (id);
	_tmp1_ = _tmp0_;
	_g_free0 (((RygelMediaObject*) self)->id);
	((RygelMediaObject*) self)->id = _tmp1_;
	((RygelMediaObject*) self)->parent = parent;
	rygel_media_object_set_title ((RygelMediaObject*) self, title);
	self->child_count = child_count;
	self->update_id = (guint32) 0;
	_tmp2_ = g_strdup (RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER);
	_tmp3_ = _tmp2_;
	_g_free0 (((RygelMediaObject*) self)->upnp_class);
	((RygelMediaObject*) self)->upnp_class = _tmp3_;
	g_signal_connect_object (self, "container-updated", (GCallback) _rygel_media_container_on_container_updated_rygel_media_container_container_updated, self, 0);
	return self;
}


RygelMediaContainer* rygel_media_container_construct_root (GType object_type, const gchar* title, gint child_count) {
	RygelMediaContainer * self = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelMediaContainer*) rygel_media_container_construct (object_type, "0", NULL, title, child_count);
	return self;
}


void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->get_children (self, offset, max_count, cancellable, _callback_, _user_data_);
}


RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->get_children_finish (self, _res_, error);
}


static void rygel_media_container_real_search_data_free (gpointer _data) {
	RygelMediaContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaContainerSearchData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_media_container_real_search (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerSearchData* _data_;
	_data_ = g_slice_new0 (RygelMediaContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_media_container_real_search_finish (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelMediaContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaContainerSearchData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_media_container_real_search_co (data);
}


/**
     * Recursively searches for all media objects the satisfy the given search
     * expression in this container.
     *
     * @param expression the search expression or `null` for wildcard
     * @param offet zero-based index of the first object to return
     * @param max_count maximum number of objects to return
     * @param total_matches sets it to the actual number of objects that satisfy
     *                      the given search expression. If it is not possible
     *                      to compute this value (in a timely mannger), it is
     *                      set to '0'.
     * @param cancellable optional cancellable for this operation
     *
     * return A list of media objects.
     */
static gboolean rygel_media_container_real_search_co (RygelMediaContainerSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_media_objects_new ();
	data->_result_ = data->_tmp0_;
	data->_state_ = 1;
	rygel_media_container_get_children (data->self, (guint) 0, (guint) data->self->child_count, data->cancellable, rygel_media_container_search_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_media_container_get_children_finish (data->self, data->_res_, &data->_inner_error_);
	data->children = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->_result_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->offset > 0) {
		data->_tmp2_ = TRUE;
	} else {
		data->_tmp2_ = data->max_count > 0;
	}
	if (data->_tmp2_) {
		data->limit = data->offset + data->max_count;
	} else {
		data->limit = (guint) 0;
	}
	{
		data->_tmp3_ = _g_object_ref0 (data->children);
		data->_child_list = data->_tmp3_;
		data->_tmp4_ = gee_collection_get_size ((GeeCollection*) data->_child_list);
		data->_child_size = data->_tmp4_;
		data->_child_index = -1;
		while (TRUE) {
			data->_child_index = data->_child_index + 1;
			if (!(data->_child_index < data->_child_size)) {
				break;
			}
			data->_tmp5_ = NULL;
			data->_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) data->_child_list, data->_child_index);
			data->child = (RygelMediaObject*) data->_tmp5_;
			if (data->expression == NULL) {
				data->_tmp6_ = TRUE;
			} else {
				data->_tmp7_ = rygel_search_expression_satisfied_by (data->expression, data->child);
				data->_tmp6_ = data->_tmp7_;
			}
			if (data->_tmp6_) {
				gee_abstract_collection_add ((GeeAbstractCollection*) data->_result_, data->child);
			}
			if (data->limit > 0) {
				data->_tmp9_ = gee_collection_get_size ((GeeCollection*) data->_result_);
				data->_tmp8_ = data->_tmp9_ >= data->limit;
			} else {
				data->_tmp8_ = FALSE;
			}
			if (data->_tmp8_) {
				_g_object_unref0 (data->child);
				break;
			}
			_g_object_unref0 (data->child);
		}
		_g_object_unref0 (data->_child_list);
	}
	if (data->limit == 0) {
		data->_tmp10_ = TRUE;
	} else {
		data->_tmp11_ = gee_collection_get_size ((GeeCollection*) data->_result_);
		data->_tmp10_ = data->_tmp11_ < data->limit;
	}
	if (data->_tmp10_) {
		if (data->limit == 0) {
			data->_tmp12_ = (guint) 0;
		} else {
			data->_tmp13_ = gee_collection_get_size ((GeeCollection*) data->_result_);
			data->_tmp12_ = data->limit - data->_tmp13_;
		}
		data->child_limit = data->_tmp12_;
		data->_state_ = 2;
		rygel_media_container_search_in_children (data->self, data->expression, data->children, data->child_limit, data->cancellable, rygel_media_container_search_ready, data);
		return FALSE;
		_state_2:
		data->_tmp14_ = NULL;
		data->_tmp14_ = rygel_media_container_search_in_children_finish (data->self, data->_res_, &data->_inner_error_);
		data->child_results = data->_tmp14_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->children);
			_g_object_unref0 (data->_result_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		gee_abstract_collection_add_all ((GeeAbstractCollection*) data->_result_, (GeeCollection*) data->child_results);
		_g_object_unref0 (data->child_results);
	}
	data->_tmp16_ = gee_collection_get_size ((GeeCollection*) data->_result_);
	if (data->_tmp16_ > 0) {
		data->_tmp15_ = data->limit > 0;
	} else {
		data->_tmp15_ = FALSE;
	}
	if (data->_tmp15_) {
		data->_tmp17_ = gee_collection_get_size ((GeeCollection*) data->_result_);
		data->_tmp18_ = CLAMP (data->offset, (guint) 0, (guint) (data->_tmp17_ - 1));
		data->start = data->_tmp18_;
		if (data->max_count != 0) {
			data->_tmp20_ = gee_collection_get_size ((GeeCollection*) data->_result_);
			data->_tmp19_ = (data->start + data->max_count) <= data->_tmp20_;
		} else {
			data->_tmp19_ = FALSE;
		}
		if (data->_tmp19_) {
			data->stop = data->start + data->max_count;
		} else {
			data->_tmp21_ = gee_collection_get_size ((GeeCollection*) data->_result_);
			data->stop = (guint) data->_tmp21_;
		}
		data->total_matches = (guint) 0;
		data->_tmp22_ = NULL;
		data->_tmp22_ = gee_abstract_list_slice ((GeeAbstractList*) data->_result_, (gint) data->start, (gint) data->stop);
		data->result = (data->_tmp23_ = data->_tmp22_, RYGEL_IS_MEDIA_OBJECTS (data->_tmp23_) ? ((RygelMediaObjects*) data->_tmp23_) : NULL);
		_g_object_unref0 (data->children);
		_g_object_unref0 (data->_result_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->_tmp24_ = gee_collection_get_size ((GeeCollection*) data->_result_);
		data->total_matches = (guint) data->_tmp24_;
		data->result = data->_result_;
		_g_object_unref0 (data->children);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->children);
	_g_object_unref0 (data->_result_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void rygel_media_container_search (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->search (self, expression, offset, max_count, cancellable, _callback_, _user_data_);
}


RygelMediaObjects* rygel_media_container_search_finish (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->search_finish (self, _res_, total_matches, error);
}


static void rygel_media_container_real_find_object_data_free (gpointer _data) {
	RygelMediaContainerFindObjectData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaContainerFindObjectData, data);
}


static void rygel_media_container_real_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* _data_;
	_data_ = g_slice_new0 (RygelMediaContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_real_find_object_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->id = g_strdup (id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_media_container_real_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_media_container_real_find_object_co (data);
}


/**
     * Recursively searches for media object with the given id in this
     * container.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     * @param callback function to call when result is ready
     *
     * return the found media object.
     */
static gboolean rygel_media_container_real_find_object_co (RygelMediaContainerFindObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_relational_expression_new ();
	data->expression = data->_tmp0_;
	((RygelSearchExpression*) data->expression)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
	data->_tmp1_ = g_strdup ("@id");
	data->_tmp2_ = data->_tmp1_;
	_g_free0 (((RygelSearchExpression*) data->expression)->operand1);
	((RygelSearchExpression*) data->expression)->operand1 = data->_tmp2_;
	data->_tmp3_ = g_strdup (data->id);
	data->_tmp4_ = data->_tmp3_;
	_g_free0 (((RygelSearchExpression*) data->expression)->operand2);
	((RygelSearchExpression*) data->expression)->operand2 = data->_tmp4_;
	data->_state_ = 1;
	rygel_media_container_search (data->self, (RygelSearchExpression*) data->expression, (guint) 0, (guint) 1, data->cancellable, rygel_media_container_find_object_ready, data);
	return FALSE;
	_state_1:
	data->_tmp6_ = NULL;
	data->_tmp6_ = rygel_media_container_search_finish (data->self, data->_res_, &data->_tmp5_, &data->_inner_error_);
	data->total_matches = data->_tmp5_;
	data->results = data->_tmp6_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_rygel_search_expression_unref0 (data->expression);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp7_ = gee_collection_get_size ((GeeCollection*) data->results);
	if (data->_tmp7_ > 0) {
		data->_tmp8_ = NULL;
		data->_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) data->results, 0);
		data->result = (RygelMediaObject*) data->_tmp8_;
		_g_object_unref0 (data->results);
		_rygel_search_expression_unref0 (data->expression);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->result = NULL;
		_g_object_unref0 (data->results);
		_rygel_search_expression_unref0 (data->expression);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->results);
	_rygel_search_expression_unref0 (data->expression);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->find_object (self, id, cancellable, _callback_, _user_data_);
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->find_object_finish (self, _res_, error);
}


/**
     * Method to be be called each time this container is updated (metadata
     * changes for this container, items under it gets removed/added or their
     * metadata changes etc).
     *
     * @param container the container that just got updated.
     */
void rygel_media_container_updated (RygelMediaContainer* self) {
	g_return_if_fail (self != NULL);
	self->update_id++;
	g_signal_emit_by_name (self, "container-updated", self);
}


static GUPnPDIDLLiteObject* rygel_media_container_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
	RygelMediaContainer * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteContainer* _tmp0_ = NULL;
	GUPnPDIDLLiteContainer* didl_container;
	const gchar* _tmp1_ = NULL;
	GUPnPOCMFlags _tmp2_;
	gboolean _tmp3_;
	self = (RygelMediaContainer*) base;
	g_return_val_if_fail (writer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = gupnp_didl_lite_writer_add_container (writer);
	didl_container = _tmp0_;
	if (((RygelMediaObject*) self)->parent != NULL) {
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) didl_container, ((RygelMediaObject*) ((RygelMediaObject*) self)->parent)->id);
	} else {
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) didl_container, "-1");
	}
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) didl_container, ((RygelMediaObject*) self)->id);
	_tmp1_ = rygel_media_object_get_title ((RygelMediaObject*) self);
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) didl_container, _tmp1_);
	gupnp_didl_lite_container_set_child_count (didl_container, self->child_count);
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) didl_container, ((RygelMediaObject*) self)->upnp_class);
	gupnp_didl_lite_container_set_searchable (didl_container, TRUE);
	_tmp2_ = rygel_media_object_get_ocm_flags ((RygelMediaObject*) self);
	gupnp_didl_lite_object_set_dlna_managed ((GUPnPDIDLLiteObject*) didl_container, _tmp2_);
	_tmp3_ = rygel_media_object_get_restricted ((RygelMediaObject*) self);
	if (!_tmp3_) {
		RygelMediaContainer* _tmp4_;
		RygelWritableContainer* _tmp5_;
		RygelWritableContainer* writable;
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) didl_container, FALSE);
		_tmp5_ = _g_object_ref0 ((_tmp4_ = self, RYGEL_IS_WRITABLE_CONTAINER (_tmp4_) ? ((RygelWritableContainer*) _tmp4_) : NULL));
		writable = _tmp5_;
		{
			GeeArrayList* _tmp6_ = NULL;
			GeeArrayList* _tmp7_;
			GeeArrayList* _create_class_list;
			gint _tmp8_;
			gint _create_class_size;
			gint _create_class_index;
			_tmp6_ = rygel_writable_container_get_create_classes (writable);
			_tmp7_ = _g_object_ref0 (_tmp6_);
			_create_class_list = _tmp7_;
			_tmp8_ = gee_collection_get_size ((GeeCollection*) _create_class_list);
			_create_class_size = _tmp8_;
			_create_class_index = -1;
			while (TRUE) {
				gpointer _tmp9_ = NULL;
				gchar* create_class;
				_create_class_index = _create_class_index + 1;
				if (!(_create_class_index < _create_class_size)) {
					break;
				}
				_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _create_class_list, _create_class_index);
				create_class = (gchar*) _tmp9_;
				gupnp_didl_lite_container_add_create_class (didl_container, create_class);
				_g_free0 (create_class);
			}
			_g_object_unref0 (_create_class_list);
		}
		_g_object_unref0 (writable);
	} else {
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) didl_container, TRUE);
	}
	result = (GUPnPDIDLLiteObject*) didl_container;
	return result;
}


static void rygel_media_container_search_in_children_data_free (gpointer _data) {
	RygelMediaContainerSearchInChildrenData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->children);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaContainerSearchInChildrenData, data);
}


static void rygel_media_container_search_in_children (RygelMediaContainer* self, RygelSearchExpression* expression, RygelMediaObjects* children, guint limit, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerSearchInChildrenData* _data_;
	_data_ = g_slice_new0 (RygelMediaContainerSearchInChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_container_search_in_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_search_in_children_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->children = _g_object_ref0 (children);
	_data_->limit = limit;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_container_search_in_children_co (_data_);
}


static RygelMediaObjects* rygel_media_container_search_in_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelMediaContainerSearchInChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaContainerSearchInChildrenData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_media_container_search_in_children_co (data);
}


static gboolean rygel_media_container_search_in_children_co (RygelMediaContainerSearchInChildrenData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_media_objects_new ();
	data->_result_ = data->_tmp0_;
	{
		data->_tmp1_ = _g_object_ref0 (data->children);
		data->_child_list = data->_tmp1_;
		data->_tmp2_ = gee_collection_get_size ((GeeCollection*) data->_child_list);
		data->_child_size = data->_tmp2_;
		data->_child_index = -1;
		while (TRUE) {
			data->_child_index = data->_child_index + 1;
			if (!(data->_child_index < data->_child_size)) {
				break;
			}
			data->_tmp3_ = NULL;
			data->_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) data->_child_list, data->_child_index);
			data->child = (RygelMediaObject*) data->_tmp3_;
			if (RYGEL_IS_MEDIA_CONTAINER (data->child)) {
				data->_tmp5_ = _g_object_ref0 ((data->_tmp4_ = data->child, RYGEL_IS_MEDIA_CONTAINER (data->_tmp4_) ? ((RygelMediaContainer*) data->_tmp4_) : NULL));
				data->container = data->_tmp5_;
				data->_state_ = 1;
				rygel_media_container_search (data->container, data->expression, (guint) 0, data->limit, data->cancellable, rygel_media_container_search_in_children_ready, data);
				return FALSE;
				_state_1:
				data->_tmp7_ = NULL;
				data->_tmp7_ = rygel_media_container_search_finish (data->container, data->_res_, &data->_tmp6_, &data->_inner_error_);
				data->tmp = data->_tmp6_;
				data->child_result = data->_tmp7_;
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->container);
					_g_object_unref0 (data->child);
					_g_object_unref0 (data->_child_list);
					_g_object_unref0 (data->_result_);
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				gee_abstract_collection_add_all ((GeeAbstractCollection*) data->_result_, (GeeCollection*) data->child_result);
				_g_object_unref0 (data->child_result);
				_g_object_unref0 (data->container);
			}
			if (data->limit > 0) {
				data->_tmp9_ = gee_collection_get_size ((GeeCollection*) data->_result_);
				data->_tmp8_ = data->_tmp9_ >= data->limit;
			} else {
				data->_tmp8_ = FALSE;
			}
			if (data->_tmp8_) {
				_g_object_unref0 (data->child);
				break;
			}
			_g_object_unref0 (data->child);
		}
		_g_object_unref0 (data->_child_list);
	}
	data->result = data->_result_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->_result_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


/**
     * handler for container_updated signal on this container. We only forward
     * it to the parent, hoping someone will get it from the root container
     * and act upon it.
     *
     * @param container the container that emitted the signal
     * @param updated_container the container that just got updated
     */
static void rygel_media_container_on_container_updated (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaContainer* updated_container) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (updated_container != NULL);
	if (((RygelMediaObject*) self)->parent != NULL) {
		g_signal_emit_by_name (((RygelMediaObject*) self)->parent, "container-updated", updated_container);
	}
}


static GUPnPOCMFlags rygel_media_container_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaContainer* self;
	gboolean _tmp0_ = FALSE;
	self = (RygelMediaContainer*) base;
	if (RYGEL_IS_WRITABLE_CONTAINER (self)) {
		gint _tmp1_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) ((RygelMediaObject*) self)->uris);
		_tmp0_ = _tmp1_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = (GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_DESTROYABLE) | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE;
		return result;
	} else {
		result = GUPNP_OCM_FLAGS_NONE;
		return result;
	}
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search = rygel_media_container_real_search;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search_finish = rygel_media_container_real_search_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_media_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_media_container_real_find_object_finish;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_container_real_serialize;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_container_real_get_ocm_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_container_get_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_container_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_OCM_FLAGS, "ocm-flags");
	/**
	     * container_updated signal that is emitted if a child container under the
	     * tree of this container gets updated.
	     *
	     * @param container the container that just got updated.
	     */
	g_signal_new ("container_updated", RYGEL_TYPE_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_CONTAINER);
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


static void rygel_media_container_finalize (GObject* obj) {
	RygelMediaContainer * self;
	self = RYGEL_MEDIA_CONTAINER (obj);
	G_OBJECT_CLASS (rygel_media_container_parent_class)->finalize (obj);
}


/**
 * Represents a container (folder) for media items and containers. Provides
 * basic serialization (to DIDLLiteWriter) implementation. Deriving classes
 * are supposed to provide working implementations of get_children.
 */
GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


static void _vala_rygel_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaContainer * self;
	self = RYGEL_MEDIA_CONTAINER (object);
	switch (property_id) {
		case RYGEL_MEDIA_CONTAINER_OCM_FLAGS:
		g_value_set_flags (value, rygel_media_object_get_ocm_flags ((RygelMediaObject*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



