/* rygel-root-device-factory.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-root-device-factory.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2007 OpenedHand Ltd.
 *
 * Authors: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                                <zeeshan.ali@nokia.com>
 *          Jorn Baayen <jorn@openedhand.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <config.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <libgssdp/gssdp.h>
#include <stdio.h>
#include <gio/gio.h>
#include <libxml/parser.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;
typedef struct _RygelRootDeviceFactoryPrivate RygelRootDeviceFactoryPrivate;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;
#define _rygel_root_device_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_root_device_factory_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _RygelParamSpecRootDeviceFactory RygelParamSpecRootDeviceFactory;

typedef enum  {
	ROOT_DEVICE_FACTORY_ERROR_XML_PARSE
} RootDeviceFactoryError;
#define ROOT_DEVICE_FACTORY_ERROR root_device_factory_error_quark ()
struct _RygelRootDeviceFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelRootDeviceFactoryPrivate * priv;
	GUPnPContext* context;
};

struct _RygelRootDeviceFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelRootDeviceFactory *self);
};

typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	char* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	RygelLogLevel (*get_log_level) (RygelConfiguration* self, GError** error);
	char* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_title) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_string) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const char* section, const char* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const char* section, const char* key, GError** error);
};

struct _RygelRootDeviceFactoryPrivate {
	RygelConfiguration* config;
	char* desc_dir;
};

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
	char* name;
	char* title;
	char* description;
	char* desc_path;
	GeeArrayList* resource_infos;
	GeeArrayList* icon_infos;
	GeeArrayList* default_icons;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
};

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	char* upnp_type;
	char* upnp_id;
	char* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	char* mime_type;
	char* uri;
	char* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

struct _RygelParamSpecRootDeviceFactory {
	GParamSpec parent_instance;
};


static gpointer rygel_root_device_factory_parent_class = NULL;

void uuid_generate (guchar* uuid);
void uuid_unparse (guchar* uuid, guchar* output);
GQuark root_device_factory_error_quark (void);
gpointer rygel_root_device_factory_ref (gpointer instance);
void rygel_root_device_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_root_device_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_root_device_factory (GValue* value, gpointer v_object);
void rygel_value_take_root_device_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_root_device_factory (const GValue* value);
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
GType rygel_log_level_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
#define RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryPrivate))
enum  {
	RYGEL_ROOT_DEVICE_FACTORY_DUMMY_PROPERTY
};
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const char* dir_path, GError** error);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const char* desc_path, const char* template_path, GError** error);
RygelRootDevice* rygel_root_device_new (GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const char* description_path, const char* description_dir);
RygelRootDevice* rygel_root_device_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const char* description_path, const char* description_dir);
RygelXBoxHacks* rygel_xbox_hacks_new (void);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type);
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const char* template_path, GError** error);
static gboolean rygel_root_device_factory_check_path_exist (RygelRootDeviceFactory* self, const char* path);
static void rygel_root_device_factory_prepare_desc_for_plugin (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, RygelPlugin* plugin);
static void rygel_root_device_factory_save_modified_desc (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, const char* desc_path, GError** error);
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
static void rygel_root_device_factory_set_friendly_name_and_udn (RygelRootDeviceFactory* self, xmlNode* device_element, const char* plugin_name, const char* plugin_title);
static void rygel_root_device_factory_set_description (RygelRootDeviceFactory* self, xmlNode* device_element, const char* description);
static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin);
static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin);
char* rygel_configuration_get_title (RygelConfiguration* self, const char* section, GError** error);
static char* rygel_root_device_factory_generate_random_udn (RygelRootDeviceFactory* self);
static void rygel_root_device_factory_add_service_to_desc (RygelRootDeviceFactory* self, xmlNode* service_list_node, const char* plugin_name, RygelResourceInfo* resource_info);
static void rygel_root_device_factory_add_icon_to_desc (RygelRootDeviceFactory* self, xmlNode* icon_list_node, RygelIconInfo* icon_info, RygelPlugin* plugin);
static void rygel_root_device_factory_finalize (RygelRootDeviceFactory* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark root_device_factory_error_quark (void) {
	return g_quark_from_static_string ("root_device_factory_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 53 "rygel-root-device-factory.vala"
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error) {
#line 322 "rygel-root-device-factory.c"
	RygelRootDeviceFactory* self;
	RygelConfiguration* _tmp0_;
	GUPnPContext* _tmp1_;
	char* config_dir;
	char* _tmp2_;
	GError * _inner_error_ = NULL;
#line 53 "rygel-root-device-factory.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 331 "rygel-root-device-factory.c"
	self = (RygelRootDeviceFactory*) g_type_create_instance (object_type);
#line 54 "rygel-root-device-factory.vala"
	self->priv->config = (_tmp0_ = (RygelConfiguration*) rygel_meta_config_get_default (), _g_object_unref0 (self->priv->config), _tmp0_);
#line 55 "rygel-root-device-factory.vala"
	self->context = (_tmp1_ = _g_object_ref0 (context), _g_object_unref0 (self->context), _tmp1_);
#line 58 "rygel-root-device-factory.vala"
	config_dir = g_strdup (g_get_user_config_dir ());
#line 59 "rygel-root-device-factory.vala"
	rygel_root_device_factory_ensure_dir_exists (self, config_dir, &_inner_error_);
#line 341 "rygel-root-device-factory.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (config_dir);
		_rygel_root_device_factory_unref0 (self);
		return NULL;
	}
#line 60 "rygel-root-device-factory.vala"
	self->priv->desc_dir = (_tmp2_ = g_build_filename (config_dir, "Rygel", NULL), _g_free0 (self->priv->desc_dir), _tmp2_);
#line 61 "rygel-root-device-factory.vala"
	rygel_root_device_factory_ensure_dir_exists (self, self->priv->desc_dir, &_inner_error_);
#line 352 "rygel-root-device-factory.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (config_dir);
		_rygel_root_device_factory_unref0 (self);
		return NULL;
	}
	_g_free0 (config_dir);
	return self;
}


#line 53 "rygel-root-device-factory.vala"
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error) {
#line 53 "rygel-root-device-factory.vala"
	return rygel_root_device_factory_construct (RYGEL_TYPE_ROOT_DEVICE_FACTORY, context, error);
#line 368 "rygel-root-device-factory.c"
}


#line 64 "rygel-root-device-factory.vala"
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error) {
#line 374 "rygel-root-device-factory.c"
	RygelRootDevice* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	char* desc_path;
	char* template_path;
	GUPnPXMLDoc* doc;
	RygelRootDevice* device;
	RygelXBoxHacks* xbox_hacks;
	GError * _inner_error_ = NULL;
#line 64 "rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "rygel-root-device-factory.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 65 "rygel-root-device-factory.vala"
	desc_path = (_tmp1_ = g_build_filename (self->priv->desc_dir, _tmp0_ = g_strconcat (plugin->name, ".xml", NULL), NULL), _g_free0 (_tmp0_), _tmp1_);
#line 67 "rygel-root-device-factory.vala"
	template_path = g_strdup (plugin->desc_path);
#line 70 "rygel-root-device-factory.vala"
	doc = rygel_root_device_factory_create_desc (self, plugin, desc_path, template_path, &_inner_error_);
#line 394 "rygel-root-device-factory.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (template_path);
		_g_free0 (desc_path);
		return NULL;
	}
#line 72 "rygel-root-device-factory.vala"
	device = rygel_root_device_new (self->context, plugin, doc, desc_path, DATA_DIR);
#line 79 "rygel-root-device-factory.vala"
	xbox_hacks = rygel_xbox_hacks_new ();
#line 80 "rygel-root-device-factory.vala"
	rygel_xbox_hacks_apply_on_device (xbox_hacks, device, desc_path, &_inner_error_);
#line 407 "rygel-root-device-factory.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (xbox_hacks);
		_g_object_unref0 (device);
		_g_object_unref0 (doc);
		_g_free0 (template_path);
		_g_free0 (desc_path);
		return NULL;
	}
	result = device;
	_g_object_unref0 (xbox_hacks);
	_g_object_unref0 (doc);
	_g_free0 (template_path);
	_g_free0 (desc_path);
#line 82 "rygel-root-device-factory.vala"
	return result;
#line 424 "rygel-root-device-factory.c"
}


#line 85 "rygel-root-device-factory.vala"
static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const char* desc_path, const char* template_path, GError** error) {
#line 430 "rygel-root-device-factory.c"
	GUPnPXMLDoc* result = NULL;
	GUPnPXMLDoc* doc;
	GError * _inner_error_ = NULL;
#line 85 "rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 85 "rygel-root-device-factory.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 85 "rygel-root-device-factory.vala"
	g_return_val_if_fail (desc_path != NULL, NULL);
#line 85 "rygel-root-device-factory.vala"
	g_return_val_if_fail (template_path != NULL, NULL);
#line 442 "rygel-root-device-factory.c"
	doc = NULL;
#line 90 "rygel-root-device-factory.vala"
	if (rygel_root_device_factory_check_path_exist (self, desc_path)) {
#line 446 "rygel-root-device-factory.c"
		GUPnPXMLDoc* _tmp0_;
		GUPnPXMLDoc* _tmp1_;
#line 91 "rygel-root-device-factory.vala"
		_tmp0_ = gupnp_xml_doc_new_from_path (desc_path, &_inner_error_);
#line 451 "rygel-root-device-factory.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (doc);
			return NULL;
		}
#line 91 "rygel-root-device-factory.vala"
		doc = (_tmp1_ = _tmp0_, _g_object_unref0 (doc), _tmp1_);
#line 459 "rygel-root-device-factory.c"
	} else {
		GUPnPXMLDoc* _tmp2_;
		GUPnPXMLDoc* _tmp3_;
#line 94 "rygel-root-device-factory.vala"
		_tmp2_ = gupnp_xml_doc_new_from_path (template_path, &_inner_error_);
#line 465 "rygel-root-device-factory.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (doc);
			return NULL;
		}
#line 94 "rygel-root-device-factory.vala"
		doc = (_tmp3_ = _tmp2_, _g_object_unref0 (doc), _tmp3_);
#line 473 "rygel-root-device-factory.c"
	}
#line 98 "rygel-root-device-factory.vala"
	rygel_root_device_factory_prepare_desc_for_plugin (self, doc, plugin);
#line 100 "rygel-root-device-factory.vala"
	rygel_root_device_factory_save_modified_desc (self, doc, desc_path, &_inner_error_);
#line 479 "rygel-root-device-factory.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (doc);
		return NULL;
	}
	result = doc;
#line 102 "rygel-root-device-factory.vala"
	return result;
#line 488 "rygel-root-device-factory.c"
}


#line 105 "rygel-root-device-factory.vala"
static void rygel_root_device_factory_prepare_desc_for_plugin (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, RygelPlugin* plugin) {
#line 494 "rygel-root-device-factory.c"
	xmlNode* device_element = NULL;
#line 105 "rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 105 "rygel-root-device-factory.vala"
	g_return_if_fail (doc != NULL);
#line 105 "rygel-root-device-factory.vala"
	g_return_if_fail (plugin != NULL);
#line 108 "rygel-root-device-factory.vala"
	device_element = rygel_xml_utils_get_element ((xmlNode*) doc->doc, "root", "device", NULL, NULL);
#line 112 "rygel-root-device-factory.vala"
	if (device_element == NULL) {
#line 113 "rygel-root-device-factory.vala"
		g_warning (_ ("XML node '%s' not found."), "/root/device");
#line 115 "rygel-root-device-factory.vala"
		return;
#line 510 "rygel-root-device-factory.c"
	}
#line 119 "rygel-root-device-factory.vala"
	rygel_root_device_factory_set_friendly_name_and_udn (self, device_element, plugin->name, plugin->title);
#line 123 "rygel-root-device-factory.vala"
	if (plugin->description != NULL) {
#line 124 "rygel-root-device-factory.vala"
		rygel_root_device_factory_set_description (self, device_element, plugin->description);
#line 518 "rygel-root-device-factory.c"
	}
#line 128 "rygel-root-device-factory.vala"
	rygel_root_device_factory_add_icons_to_desc (self, device_element, plugin);
#line 131 "rygel-root-device-factory.vala"
	rygel_root_device_factory_add_services_to_desc (self, device_element, plugin);
#line 524 "rygel-root-device-factory.c"
}


/**
     * Fills the description doc @doc with a friendly name, and UDN from gconf.
     * If these keys are not present in gconf, they are set with default values.
     */
#line 1177 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 534 "rygel-root-device-factory.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 543 "rygel-root-device-factory.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1179 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 551 "rygel-root-device-factory.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch58_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1180 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 562 "rygel-root-device-factory.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch58_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1180 "glib-2.0.vapi"
		return result;
#line 577 "rygel-root-device-factory.c"
	}
	goto __finally58;
	__catch58_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1182 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 588 "rygel-root-device-factory.c"
			_g_error_free0 (e);
		}
	}
	__finally58:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 138 "rygel-root-device-factory.vala"
static void rygel_root_device_factory_set_friendly_name_and_udn (RygelRootDeviceFactory* self, xmlNode* device_element, const char* plugin_name, const char* plugin_title) {
#line 603 "rygel-root-device-factory.c"
	xmlNode* element;
	char* title;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* udn;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
#line 138 "rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 138 "rygel-root-device-factory.vala"
	g_return_if_fail (plugin_name != NULL);
#line 138 "rygel-root-device-factory.vala"
	g_return_if_fail (plugin_title != NULL);
#line 142 "rygel-root-device-factory.vala"
	element = rygel_xml_utils_get_element (device_element, "friendlyName", NULL, NULL);
#line 145 "rygel-root-device-factory.vala"
	if (element == NULL) {
#line 146 "rygel-root-device-factory.vala"
		g_warning (_ ("XML node '%s' not found."), "/root/device/friendlyName");
#line 149 "rygel-root-device-factory.vala"
		return;
#line 626 "rygel-root-device-factory.c"
	}
	title = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
#line 154 "rygel-root-device-factory.vala"
		_tmp0_ = rygel_configuration_get_title (self->priv->config, plugin_name, &_inner_error_);
#line 634 "rygel-root-device-factory.c"
		if (_inner_error_ != NULL) {
			goto __catch57_g_error;
		}
#line 154 "rygel-root-device-factory.vala"
		title = (_tmp1_ = _tmp0_, _g_free0 (title), _tmp1_);
#line 640 "rygel-root-device-factory.c"
	}
	goto __finally57;
	__catch57_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp2_;
#line 156 "rygel-root-device-factory.vala"
			title = (_tmp2_ = g_strdup (plugin_title), _g_free0 (title), _tmp2_);
#line 652 "rygel-root-device-factory.c"
			_g_error_free0 (err);
		}
	}
	__finally57:
	if (_inner_error_ != NULL) {
		_g_free0 (title);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 159 "rygel-root-device-factory.vala"
	title = (_tmp3_ = string_replace (title, "@REALNAME@", g_get_real_name ()), _g_free0 (title), _tmp3_);
#line 160 "rygel-root-device-factory.vala"
	title = (_tmp4_ = string_replace (title, "@USERNAME@", g_get_user_name ()), _g_free0 (title), _tmp4_);
#line 161 "rygel-root-device-factory.vala"
	title = (_tmp5_ = string_replace (title, "@HOSTNAME@", g_get_host_name ()), _g_free0 (title), _tmp5_);
#line 163 "rygel-root-device-factory.vala"
	xmlNodeSetContent (element, title);
#line 166 "rygel-root-device-factory.vala"
	element = rygel_xml_utils_get_element (device_element, "UDN", NULL);
#line 167 "rygel-root-device-factory.vala"
	if (element == NULL) {
#line 168 "rygel-root-device-factory.vala"
		g_warning (_ ("XML node '%s' not found."), "/root/device/UDN");
#line 677 "rygel-root-device-factory.c"
		_g_free0 (title);
#line 170 "rygel-root-device-factory.vala"
		return;
#line 681 "rygel-root-device-factory.c"
	}
#line 173 "rygel-root-device-factory.vala"
	udn = xmlNodeGetContent (element);
#line 174 "rygel-root-device-factory.vala"
	if (udn == NULL) {
#line 174 "rygel-root-device-factory.vala"
		_tmp6_ = TRUE;
#line 689 "rygel-root-device-factory.c"
	} else {
#line 174 "rygel-root-device-factory.vala"
		_tmp6_ = _vala_strcmp0 (udn, "") == 0;
#line 693 "rygel-root-device-factory.c"
	}
#line 174 "rygel-root-device-factory.vala"
	if (_tmp6_) {
#line 697 "rygel-root-device-factory.c"
		char* _tmp7_;
#line 175 "rygel-root-device-factory.vala"
		udn = (_tmp7_ = rygel_root_device_factory_generate_random_udn (self), _g_free0 (udn), _tmp7_);
#line 177 "rygel-root-device-factory.vala"
		xmlNodeSetContent (element, udn);
#line 703 "rygel-root-device-factory.c"
	}
	_g_free0 (udn);
	_g_free0 (title);
}


#line 181 "rygel-root-device-factory.vala"
static void rygel_root_device_factory_set_description (RygelRootDeviceFactory* self, xmlNode* device_element, const char* description) {
#line 712 "rygel-root-device-factory.c"
	xmlNode* element;
#line 181 "rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 181 "rygel-root-device-factory.vala"
	g_return_if_fail (description != NULL);
#line 183 "rygel-root-device-factory.vala"
	element = rygel_xml_utils_get_element (device_element, "modelDescription", NULL, NULL);
#line 186 "rygel-root-device-factory.vala"
	if (element == NULL) {
#line 187 "rygel-root-device-factory.vala"
		xmlNewChild (device_element, NULL, "modelDescription", description);
#line 724 "rygel-root-device-factory.c"
	}
#line 190 "rygel-root-device-factory.vala"
	xmlNodeSetContent (element, description);
#line 728 "rygel-root-device-factory.c"
}


#line 193 "rygel-root-device-factory.vala"
static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin) {
#line 734 "rygel-root-device-factory.c"
	xmlNode* service_list_node;
#line 193 "rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 193 "rygel-root-device-factory.vala"
	g_return_if_fail (plugin != NULL);
#line 195 "rygel-root-device-factory.vala"
	service_list_node = rygel_xml_utils_get_element (device_element, "serviceList", NULL, NULL);
#line 198 "rygel-root-device-factory.vala"
	if (service_list_node == NULL) {
#line 199 "rygel-root-device-factory.vala"
		g_warning (_ ("XML node '%s' not found."), "/root/device/serviceList");
#line 201 "rygel-root-device-factory.vala"
		return;
#line 748 "rygel-root-device-factory.c"
	}
#line 205 "rygel-root-device-factory.vala"
	xmlNodeSetContent (service_list_node, "");
#line 752 "rygel-root-device-factory.c"
	{
		GeeIterator* _resource_info_it;
#line 207 "rygel-root-device-factory.vala"
		_resource_info_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) plugin->resource_infos);
#line 207 "rygel-root-device-factory.vala"
		while (TRUE) {
#line 759 "rygel-root-device-factory.c"
			RygelResourceInfo* resource_info;
#line 207 "rygel-root-device-factory.vala"
			if (!gee_iterator_next (_resource_info_it)) {
#line 207 "rygel-root-device-factory.vala"
				break;
#line 765 "rygel-root-device-factory.c"
			}
#line 207 "rygel-root-device-factory.vala"
			resource_info = (RygelResourceInfo*) gee_iterator_get (_resource_info_it);
#line 209 "rygel-root-device-factory.vala"
			if (g_type_is_a (resource_info->type, GUPNP_TYPE_SERVICE)) {
#line 210 "rygel-root-device-factory.vala"
				rygel_root_device_factory_add_service_to_desc (self, service_list_node, plugin->name, resource_info);
#line 773 "rygel-root-device-factory.c"
			}
			_rygel_resource_info_unref0 (resource_info);
		}
		_g_object_unref0 (_resource_info_it);
	}
}


#line 217 "rygel-root-device-factory.vala"
static void rygel_root_device_factory_add_service_to_desc (RygelRootDeviceFactory* self, xmlNode* service_list_node, const char* plugin_name, RygelResourceInfo* resource_info) {
#line 784 "rygel-root-device-factory.c"
	xmlNode* service_node;
	char* url;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
#line 217 "rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 217 "rygel-root-device-factory.vala"
	g_return_if_fail (plugin_name != NULL);
#line 217 "rygel-root-device-factory.vala"
	g_return_if_fail (resource_info != NULL);
#line 221 "rygel-root-device-factory.vala"
	service_node = xmlNewChild (service_list_node, NULL, "service", NULL);
#line 223 "rygel-root-device-factory.vala"
	xmlNewChild (service_node, NULL, "serviceType", resource_info->upnp_type);
#line 224 "rygel-root-device-factory.vala"
	xmlNewChild (service_node, NULL, "serviceId", resource_info->upnp_id);
#line 227 "rygel-root-device-factory.vala"
	url = g_strconcat ("/", resource_info->description_path, NULL);
#line 228 "rygel-root-device-factory.vala"
	xmlNewChild (service_node, NULL, "SCPDURL", url);
#line 230 "rygel-root-device-factory.vala"
	url = (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat ("/", plugin_name, NULL), "/", NULL), g_type_name (resource_info->type), NULL), "/Event", NULL), _g_free0 (url), _tmp3_);
#line 813 "rygel-root-device-factory.c"
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
#line 231 "rygel-root-device-factory.vala"
	xmlNewChild (service_node, NULL, "eventSubURL", url);
#line 233 "rygel-root-device-factory.vala"
	url = (_tmp7_ = g_strconcat (_tmp6_ = g_strconcat (_tmp5_ = g_strconcat (_tmp4_ = g_strconcat ("/", plugin_name, NULL), "/", NULL), g_type_name (resource_info->type), NULL), "/Control", NULL), _g_free0 (url), _tmp7_);
#line 821 "rygel-root-device-factory.c"
	_g_free0 (_tmp6_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp4_);
#line 234 "rygel-root-device-factory.vala"
	xmlNewChild (service_node, NULL, "controlURL", url);
#line 827 "rygel-root-device-factory.c"
	_g_free0 (url);
}


#line 237 "rygel-root-device-factory.vala"
static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin) {
#line 834 "rygel-root-device-factory.c"
	GeeArrayList* icons;
	gboolean _tmp0_ = FALSE;
	xmlNode* icon_list_node;
#line 237 "rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 237 "rygel-root-device-factory.vala"
	g_return_if_fail (plugin != NULL);
#line 239 "rygel-root-device-factory.vala"
	icons = _g_object_ref0 (plugin->icon_infos);
#line 241 "rygel-root-device-factory.vala"
	if (icons == NULL) {
#line 241 "rygel-root-device-factory.vala"
		_tmp0_ = TRUE;
#line 848 "rygel-root-device-factory.c"
	} else {
#line 241 "rygel-root-device-factory.vala"
		_tmp0_ = gee_collection_get_size ((GeeCollection*) icons) == 0;
#line 852 "rygel-root-device-factory.c"
	}
#line 241 "rygel-root-device-factory.vala"
	if (_tmp0_) {
#line 856 "rygel-root-device-factory.c"
		GeeArrayList* _tmp1_;
#line 242 "rygel-root-device-factory.vala"
		g_debug ("rygel-root-device-factory.vala:242: No icon provided by plugin '%s'. U" \
"sing Rygel logo.", plugin->name);
#line 245 "rygel-root-device-factory.vala"
		icons = (_tmp1_ = _g_object_ref0 (plugin->default_icons), _g_object_unref0 (icons), _tmp1_);
#line 862 "rygel-root-device-factory.c"
	}
#line 248 "rygel-root-device-factory.vala"
	icon_list_node = rygel_xml_utils_get_element (device_element, "iconList", NULL, NULL);
#line 251 "rygel-root-device-factory.vala"
	if (icon_list_node == NULL) {
#line 252 "rygel-root-device-factory.vala"
		icon_list_node = xmlNewChild (device_element, NULL, "iconList", NULL);
#line 870 "rygel-root-device-factory.c"
	} else {
#line 255 "rygel-root-device-factory.vala"
		xmlNodeSetContent (icon_list_node, "");
#line 874 "rygel-root-device-factory.c"
	}
	{
		GeeIterator* _icon_it;
#line 258 "rygel-root-device-factory.vala"
		_icon_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) icons);
#line 258 "rygel-root-device-factory.vala"
		while (TRUE) {
#line 882 "rygel-root-device-factory.c"
			RygelIconInfo* icon;
#line 258 "rygel-root-device-factory.vala"
			if (!gee_iterator_next (_icon_it)) {
#line 258 "rygel-root-device-factory.vala"
				break;
#line 888 "rygel-root-device-factory.c"
			}
#line 258 "rygel-root-device-factory.vala"
			icon = (RygelIconInfo*) gee_iterator_get (_icon_it);
#line 259 "rygel-root-device-factory.vala"
			rygel_root_device_factory_add_icon_to_desc (self, icon_list_node, icon, plugin);
#line 894 "rygel-root-device-factory.c"
			_rygel_icon_info_unref0 (icon);
		}
		_g_object_unref0 (_icon_it);
	}
	_g_object_unref0 (icons);
}


#line 263 "rygel-root-device-factory.vala"
static void rygel_root_device_factory_add_icon_to_desc (RygelRootDeviceFactory* self, xmlNode* icon_list_node, RygelIconInfo* icon_info, RygelPlugin* plugin) {
#line 905 "rygel-root-device-factory.c"
	xmlNode* icon_node;
	char* width;
	char* height;
	char* depth;
	char* uri;
#line 263 "rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 263 "rygel-root-device-factory.vala"
	g_return_if_fail (icon_info != NULL);
#line 263 "rygel-root-device-factory.vala"
	g_return_if_fail (plugin != NULL);
#line 267 "rygel-root-device-factory.vala"
	icon_node = xmlNewChild (icon_list_node, NULL, "icon", NULL);
#line 269 "rygel-root-device-factory.vala"
	width = g_strdup_printf ("%i", icon_info->width);
#line 270 "rygel-root-device-factory.vala"
	height = g_strdup_printf ("%i", icon_info->height);
#line 271 "rygel-root-device-factory.vala"
	depth = g_strdup_printf ("%i", icon_info->depth);
#line 273 "rygel-root-device-factory.vala"
	xmlNewChild (icon_node, NULL, "mimetype", icon_info->mime_type);
#line 274 "rygel-root-device-factory.vala"
	xmlNewChild (icon_node, NULL, "width", width);
#line 275 "rygel-root-device-factory.vala"
	xmlNewChild (icon_node, NULL, "height", height);
#line 276 "rygel-root-device-factory.vala"
	xmlNewChild (icon_node, NULL, "depth", depth);
#line 278 "rygel-root-device-factory.vala"
	uri = g_strdup (icon_info->uri);
#line 280 "rygel-root-device-factory.vala"
	if (g_str_has_prefix (uri, "file://")) {
#line 937 "rygel-root-device-factory.c"
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		char* _tmp4_;
		char* _tmp5_;
		char* _tmp6_;
		char* _tmp7_;
		char* _tmp8_;
		char* remote_path;
		char* local_path;
#line 282 "rygel-root-device-factory.vala"
		remote_path = (_tmp8_ = g_strconcat (_tmp7_ = g_strconcat (_tmp6_ = g_strconcat (_tmp5_ = g_strconcat (_tmp4_ = g_strconcat (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat ("/", plugin->name, NULL), "-", NULL), width, NULL), "x", NULL), height, NULL), "x", NULL), depth, NULL), ".", NULL), icon_info->file_extension, NULL), _g_free0 (_tmp7_), _g_free0 (_tmp6_), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp8_);
#line 286 "rygel-root-device-factory.vala"
		local_path = g_strdup (g_utf8_offset_to_pointer (uri, (glong) 7));
#line 288 "rygel-root-device-factory.vala"
		gupnp_context_host_path (self->context, local_path, remote_path);
#line 289 "rygel-root-device-factory.vala"
		xmlNewChild (icon_node, NULL, "url", remote_path);
#line 957 "rygel-root-device-factory.c"
		_g_free0 (local_path);
		_g_free0 (remote_path);
	} else {
		char* _tmp9_;
#line 291 "rygel-root-device-factory.vala"
		uri = (_tmp9_ = string_replace (uri, "@ADDRESS@", gssdp_client_get_host_ip ((GSSDPClient*) self->context)), _g_free0 (uri), _tmp9_);
#line 292 "rygel-root-device-factory.vala"
		xmlNewChild (icon_node, NULL, "url", uri);
#line 966 "rygel-root-device-factory.c"
	}
	_g_free0 (uri);
	_g_free0 (depth);
	_g_free0 (height);
	_g_free0 (width);
}


#line 296 "rygel-root-device-factory.vala"
static void rygel_root_device_factory_save_modified_desc (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, const char* desc_path, GError** error) {
#line 977 "rygel-root-device-factory.c"
	FILE* file;
	char* mem;
	gint len;
	char* _tmp0_ = NULL;
	char* _tmp1_;
	char* _tmp2_;
	GError * _inner_error_ = NULL;
#line 296 "rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 296 "rygel-root-device-factory.vala"
	g_return_if_fail (doc != NULL);
#line 296 "rygel-root-device-factory.vala"
	g_return_if_fail (desc_path != NULL);
#line 298 "rygel-root-device-factory.vala"
	file = fopen (desc_path, "w+");
#line 300 "rygel-root-device-factory.vala"
	if (G_UNLIKELY (file == NULL)) {
#line 995 "rygel-root-device-factory.c"
		char* message;
#line 301 "rygel-root-device-factory.vala"
		message = g_strdup (_ ("Failed to write modified description to %s"));
#line 999 "rygel-root-device-factory.c"
		_inner_error_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, message, desc_path);
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (message);
			_fclose0 (file);
			return;
		}
		_g_free0 (message);
	}
#line 306 "rygel-root-device-factory.vala"
	mem = NULL;
#line 307 "rygel-root-device-factory.vala"
	len = -1;
#line 308 "rygel-root-device-factory.vala"
	xmlDocDumpFormatMemory (doc->doc, &_tmp0_, &len, FALSE);
#line 308 "rygel-root-device-factory.vala"
	mem = (_tmp1_ = _tmp0_, _g_free0 (mem), _tmp1_);
#line 310 "rygel-root-device-factory.vala"
	if (G_UNLIKELY (len <= 0)) {
#line 1019 "rygel-root-device-factory.c"
		char* message;
#line 311 "rygel-root-device-factory.vala"
		message = g_strdup (_ ("Failed to write modified description to %s"));
#line 1023 "rygel-root-device-factory.c"
		_inner_error_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, message, desc_path);
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (message);
			_g_free0 (mem);
			_fclose0 (file);
			return;
		}
		_g_free0 (message);
	}
#line 317 "rygel-root-device-factory.vala"
	fputs (_tmp2_ = string_replace (mem, "\n", ""), file);
#line 1036 "rygel-root-device-factory.c"
	_g_free0 (_tmp2_);
	_g_free0 (mem);
	_fclose0 (file);
}


#line 320 "rygel-root-device-factory.vala"
static gboolean rygel_root_device_factory_check_path_exist (RygelRootDeviceFactory* self, const char* path) {
#line 1045 "rygel-root-device-factory.c"
	gboolean result = FALSE;
	GFile* file;
#line 320 "rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 320 "rygel-root-device-factory.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 321 "rygel-root-device-factory.vala"
	file = g_file_new_for_path (path);
#line 1054 "rygel-root-device-factory.c"
	result = g_file_query_exists (file, NULL);
	_g_object_unref0 (file);
#line 323 "rygel-root-device-factory.vala"
	return result;
#line 1059 "rygel-root-device-factory.c"
}


#line 326 "rygel-root-device-factory.vala"
static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const char* dir_path, GError** error) {
#line 1065 "rygel-root-device-factory.c"
	GError * _inner_error_ = NULL;
#line 326 "rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 326 "rygel-root-device-factory.vala"
	g_return_if_fail (dir_path != NULL);
#line 327 "rygel-root-device-factory.vala"
	if (!rygel_root_device_factory_check_path_exist (self, dir_path)) {
#line 1073 "rygel-root-device-factory.c"
		GFile* file;
#line 328 "rygel-root-device-factory.vala"
		file = g_file_new_for_path (dir_path);
#line 330 "rygel-root-device-factory.vala"
		g_file_make_directory (file, NULL, &_inner_error_);
#line 1079 "rygel-root-device-factory.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			return;
		}
		_g_object_unref0 (file);
	}
}


#line 334 "rygel-root-device-factory.vala"
static char* rygel_root_device_factory_generate_random_udn (RygelRootDeviceFactory* self) {
#line 1092 "rygel-root-device-factory.c"
	char* result = NULL;
	gint udn_length1;
	gint _udn_size_;
	guchar* _tmp0_;
	guchar* udn;
	gint id_length1;
	gint _id_size_;
	guchar* _tmp1_;
	guchar* id;
#line 334 "rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1104 "rygel-root-device-factory.c"
	udn = (_tmp0_ = g_new0 (guchar, 50), udn_length1 = 50, _udn_size_ = udn_length1, _tmp0_);
	id = (_tmp1_ = g_new0 (guchar, 16), id_length1 = 16, _id_size_ = id_length1, _tmp1_);
#line 339 "rygel-root-device-factory.vala"
	uuid_generate (id);
#line 340 "rygel-root-device-factory.vala"
	uuid_unparse (id, udn);
#line 1111 "rygel-root-device-factory.c"
	result = g_strconcat ("uuid:", (const char*) udn, NULL);
	id = (g_free (id), NULL);
	udn = (g_free (udn), NULL);
#line 342 "rygel-root-device-factory.vala"
	return result;
#line 1117 "rygel-root-device-factory.c"
}


static void rygel_value_root_device_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_root_device_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_root_device_factory_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_root_device_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_root_device_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_root_device_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_root_device_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelRootDeviceFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_root_device_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_root_device_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelRootDeviceFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_root_device_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_root_device_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecRootDeviceFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_ROOT_DEVICE_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_root_device_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_ROOT_DEVICE_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_root_device_factory (GValue* value, gpointer v_object) {
	RygelRootDeviceFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_root_device_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_root_device_factory_unref (old);
	}
}


void rygel_value_take_root_device_factory (GValue* value, gpointer v_object) {
	RygelRootDeviceFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_root_device_factory_unref (old);
	}
}


static void rygel_root_device_factory_class_init (RygelRootDeviceFactoryClass * klass) {
	rygel_root_device_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_ROOT_DEVICE_FACTORY_CLASS (klass)->finalize = rygel_root_device_factory_finalize;
	g_type_class_add_private (klass, sizeof (RygelRootDeviceFactoryPrivate));
}


static void rygel_root_device_factory_instance_init (RygelRootDeviceFactory * self) {
	self->priv = RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void rygel_root_device_factory_finalize (RygelRootDeviceFactory* obj) {
	RygelRootDeviceFactory * self;
	self = RYGEL_ROOT_DEVICE_FACTORY (obj);
	_g_object_unref0 (self->context);
	_g_object_unref0 (self->priv->config);
	_g_free0 (self->priv->desc_dir);
}


/**
 * Factory for RootDevice objects. Give it a plugin and it will create a
 * Root device for that.
 */
GType rygel_root_device_factory_get_type (void) {
	static volatile gsize rygel_root_device_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_root_device_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_root_device_factory_init, rygel_value_root_device_factory_free_value, rygel_value_root_device_factory_copy_value, rygel_value_root_device_factory_peek_pointer, "p", rygel_value_root_device_factory_collect_value, "p", rygel_value_root_device_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelRootDeviceFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_root_device_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRootDeviceFactory), 0, (GInstanceInitFunc) rygel_root_device_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_root_device_factory_type_id;
		rygel_root_device_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelRootDeviceFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_root_device_factory_type_id__volatile, rygel_root_device_factory_type_id);
	}
	return rygel_root_device_factory_type_id__volatile;
}


gpointer rygel_root_device_factory_ref (gpointer instance) {
	RygelRootDeviceFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_root_device_factory_unref (gpointer instance) {
	RygelRootDeviceFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




