/* rygel-subtitle-manager.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-subtitle-manager.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Andreas Henriksson <andreas@fatal.se>.
 *
 * Authors: Andreas Henriksson <andreas@fatal.se>
 *          Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_SUBTITLE_MANAGER (rygel_subtitle_manager_get_type ())
#define RYGEL_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager))
#define RYGEL_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))
#define RYGEL_IS_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_IS_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_SUBTITLE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))

typedef struct _RygelSubtitleManager RygelSubtitleManager;
typedef struct _RygelSubtitleManagerClass RygelSubtitleManagerClass;
typedef struct _RygelSubtitleManagerPrivate RygelSubtitleManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))

typedef enum  {
	SUBTITLE_MANAGER_ERROR_NO_SUBTITLE
} SubtitleManagerError;
#define SUBTITLE_MANAGER_ERROR subtitle_manager_error_quark ()
struct _RygelSubtitleManager {
	GObject parent_instance;
	RygelSubtitleManagerPrivate * priv;
};

struct _RygelSubtitleManagerClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	char* uri;
	char* mime_type;
	char* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};


static RygelSubtitleManager* rygel_subtitle_manager_manager;
static RygelSubtitleManager* rygel_subtitle_manager_manager = NULL;
static gpointer rygel_subtitle_manager_parent_class = NULL;

GQuark subtitle_manager_error_quark (void);
GType rygel_subtitle_manager_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_MANAGER_DUMMY_PROPERTY
};
RygelSubtitleManager* rygel_subtitle_manager_get_default (void);
RygelSubtitleManager* rygel_subtitle_manager_new (void);
RygelSubtitleManager* rygel_subtitle_manager_construct (GType object_type);
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
RygelSubtitle* rygel_subtitle_manager_get_subtitle (RygelSubtitleManager* self, const char* uri, GError** error);
RygelSubtitle* rygel_subtitle_new (const char* mime_type, const char* caption_type);
RygelSubtitle* rygel_subtitle_construct (GType object_type, const char* mime_type, const char* caption_type);
static void rygel_subtitle_manager_finalize (GObject* obj);



GQuark subtitle_manager_error_quark (void) {
	return g_quark_from_static_string ("subtitle_manager_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 35 "rygel-subtitle-manager.vala"
RygelSubtitleManager* rygel_subtitle_manager_get_default (void) {
#line 129 "rygel-subtitle-manager.c"
	RygelSubtitleManager* result = NULL;
#line 36 "rygel-subtitle-manager.vala"
	if (rygel_subtitle_manager_manager == NULL) {
#line 133 "rygel-subtitle-manager.c"
		RygelSubtitleManager* _tmp0_;
#line 37 "rygel-subtitle-manager.vala"
		rygel_subtitle_manager_manager = (_tmp0_ = rygel_subtitle_manager_new (), _g_object_unref0 (rygel_subtitle_manager_manager), _tmp0_);
#line 137 "rygel-subtitle-manager.c"
	}
	result = _g_object_ref0 (rygel_subtitle_manager_manager);
#line 40 "rygel-subtitle-manager.vala"
	return result;
#line 142 "rygel-subtitle-manager.c"
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
#line 1190 "glib-2.0.vapi"
	return result;
#line 152 "rygel-subtitle-manager.c"
}


#line 1106 "glib-2.0.vapi"
static char* string_substring (const char* self, glong offset, glong len) {
#line 158 "rygel-subtitle-manager.c"
	char* result = NULL;
	glong string_length;
	const char* start;
#line 1106 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1107 "glib-2.0.vapi"
	string_length = string_get_length (self);
#line 1108 "glib-2.0.vapi"
	if (offset < 0) {
#line 1109 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1110 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= 0, NULL);
#line 172 "rygel-subtitle-manager.c"
	} else {
#line 1112 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 176 "rygel-subtitle-manager.c"
	}
#line 1114 "glib-2.0.vapi"
	if (len < 0) {
#line 1115 "glib-2.0.vapi"
		len = string_length - offset;
#line 182 "rygel-subtitle-manager.c"
	}
#line 1117 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1118 "glib-2.0.vapi"
	start = g_utf8_offset_to_pointer (self, offset);
#line 188 "rygel-subtitle-manager.c"
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
#line 1119 "glib-2.0.vapi"
	return result;
#line 192 "rygel-subtitle-manager.c"
}


#line 43 "rygel-subtitle-manager.vala"
RygelSubtitle* rygel_subtitle_manager_get_subtitle (RygelSubtitleManager* self, const char* uri, GError** error) {
#line 198 "rygel-subtitle-manager.c"
	RygelSubtitle* result = NULL;
	GFile* video_file;
	GFile* directory;
	char* filename;
	char* extension;
	char* _tmp1_;
	GFile* srt_file;
	GFileInfo* info;
	RygelSubtitle* subtitle;
	char* _tmp2_;
	GError * _inner_error_ = NULL;
#line 43 "rygel-subtitle-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "rygel-subtitle-manager.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 44 "rygel-subtitle-manager.vala"
	video_file = g_file_new_for_uri (uri);
#line 46 "rygel-subtitle-manager.vala"
	directory = g_file_get_parent (video_file);
#line 47 "rygel-subtitle-manager.vala"
	filename = g_file_get_basename (video_file);
#line 48 "rygel-subtitle-manager.vala"
	extension = g_strdup (g_utf8_strrchr (filename, (gssize) (-1), (gunichar) '.'));
#line 49 "rygel-subtitle-manager.vala"
	if (extension != NULL) {
#line 224 "rygel-subtitle-manager.c"
		char* _tmp0_;
#line 50 "rygel-subtitle-manager.vala"
		filename = (_tmp0_ = string_substring (filename, (glong) 0, string_get_length (filename) - string_get_length (extension)), _g_free0 (filename), _tmp0_);
#line 228 "rygel-subtitle-manager.c"
	}
#line 55 "rygel-subtitle-manager.vala"
	filename = (_tmp1_ = g_strconcat (filename, ".srt", NULL), _g_free0 (filename), _tmp1_);
#line 57 "rygel-subtitle-manager.vala"
	srt_file = g_file_get_child (directory, filename);
#line 59 "rygel-subtitle-manager.vala"
	info = g_file_query_info (srt_file, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 236 "rygel-subtitle-manager.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (srt_file);
		_g_free0 (extension);
		_g_free0 (filename);
		_g_object_unref0 (directory);
		_g_object_unref0 (video_file);
		return NULL;
	}
#line 64 "rygel-subtitle-manager.vala"
	if (!g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
#line 248 "rygel-subtitle-manager.c"
		_inner_error_ = g_error_new_literal (SUBTITLE_MANAGER_ERROR, SUBTITLE_MANAGER_ERROR_NO_SUBTITLE, _ ("No subtitle available"));
		{
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_object_unref0 (srt_file);
			_g_free0 (extension);
			_g_free0 (filename);
			_g_object_unref0 (directory);
			_g_object_unref0 (video_file);
			return NULL;
		}
	}
#line 69 "rygel-subtitle-manager.vala"
	subtitle = rygel_subtitle_new ("text/plain", "srt");
#line 70 "rygel-subtitle-manager.vala"
	subtitle->uri = (_tmp2_ = g_file_get_uri (srt_file), _g_free0 (subtitle->uri), _tmp2_);
#line 71 "rygel-subtitle-manager.vala"
	subtitle->size = (gint64) g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_STANDARD_SIZE);
#line 267 "rygel-subtitle-manager.c"
	result = subtitle;
	_g_object_unref0 (info);
	_g_object_unref0 (srt_file);
	_g_free0 (extension);
	_g_free0 (filename);
	_g_object_unref0 (directory);
	_g_object_unref0 (video_file);
#line 74 "rygel-subtitle-manager.vala"
	return result;
#line 277 "rygel-subtitle-manager.c"
}


#line 32 "rygel-subtitle-manager.vala"
RygelSubtitleManager* rygel_subtitle_manager_construct (GType object_type) {
#line 283 "rygel-subtitle-manager.c"
	RygelSubtitleManager * self;
#line 32 "rygel-subtitle-manager.vala"
	self = (RygelSubtitleManager*) g_object_new (object_type, NULL);
#line 287 "rygel-subtitle-manager.c"
	return self;
}


#line 32 "rygel-subtitle-manager.vala"
RygelSubtitleManager* rygel_subtitle_manager_new (void) {
#line 32 "rygel-subtitle-manager.vala"
	return rygel_subtitle_manager_construct (RYGEL_TYPE_SUBTITLE_MANAGER);
#line 296 "rygel-subtitle-manager.c"
}


static void rygel_subtitle_manager_class_init (RygelSubtitleManagerClass * klass) {
	rygel_subtitle_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_subtitle_manager_finalize;
}


static void rygel_subtitle_manager_instance_init (RygelSubtitleManager * self) {
}


static void rygel_subtitle_manager_finalize (GObject* obj) {
	RygelSubtitleManager * self;
	self = RYGEL_SUBTITLE_MANAGER (obj);
	G_OBJECT_CLASS (rygel_subtitle_manager_parent_class)->finalize (obj);
}


/**
 * Provides subtitles for vidoes.
 */
GType rygel_subtitle_manager_get_type (void) {
	static volatile gsize rygel_subtitle_manager_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitleManager), 0, (GInstanceInitFunc) rygel_subtitle_manager_instance_init, NULL };
		GType rygel_subtitle_manager_type_id;
		rygel_subtitle_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitleManager", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_manager_type_id__volatile, rygel_subtitle_manager_type_id);
	}
	return rygel_subtitle_manager_type_id__volatile;
}




