/* rygel-wma-transcoder.c generated by valac 0.9.6, the Vala compiler
 * generated from rygel-wma-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_WMA_TRANSCODER (rygel_wma_transcoder_get_type ())
#define RYGEL_WMA_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMA_TRANSCODER, RygelWMATranscoder))
#define RYGEL_WMA_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMA_TRANSCODER, RygelWMATranscoderClass))
#define RYGEL_IS_WMA_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMA_TRANSCODER))
#define RYGEL_IS_WMA_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMA_TRANSCODER))
#define RYGEL_WMA_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMA_TRANSCODER, RygelWMATranscoderClass))

typedef struct _RygelWMATranscoder RygelWMATranscoder;
typedef struct _RygelWMATranscoderClass RygelWMATranscoderClass;
typedef struct _RygelWMATranscoderPrivate RygelWMATranscoderPrivate;

#define RYGEL_TYPE_WMA_TRANSCODER_BIN (rygel_wma_transcoder_bin_get_type ())
#define RYGEL_WMA_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMA_TRANSCODER_BIN, RygelWMATranscoderBin))
#define RYGEL_WMA_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMA_TRANSCODER_BIN, RygelWMATranscoderBinClass))
#define RYGEL_IS_WMA_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMA_TRANSCODER_BIN))
#define RYGEL_IS_WMA_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMA_TRANSCODER_BIN))
#define RYGEL_WMA_TRANSCODER_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMA_TRANSCODER_BIN, RygelWMATranscoderBinClass))

typedef struct _RygelWMATranscoderBin RygelWMATranscoderBin;
typedef struct _RygelWMATranscoderBinClass RygelWMATranscoderBinClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define TYPE_ENDIANNESS (endianness_get_type ())

#define RYGEL_TYPE_L16_TRANSCODER (rygel_l16_transcoder_get_type ())
#define RYGEL_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16Transcoder))
#define RYGEL_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))
#define RYGEL_IS_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_IS_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_L16_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))

typedef struct _RygelL16Transcoder RygelL16Transcoder;
typedef struct _RygelL16TranscoderClass RygelL16TranscoderClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
	GstElement* (*create_source) (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
	guint (*get_distance) (RygelTranscoder* self, RygelMediaItem* item);
};

struct _RygelWMATranscoder {
	RygelTranscoder parent_instance;
	RygelWMATranscoderPrivate * priv;
};

struct _RygelWMATranscoderClass {
	RygelTranscoderClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* date;
	char* mime_type;
	char* dlna_profile;
	gint64 size;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const char* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const char* uri, const char* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

typedef enum  {
	ENDIANNESS_LITTLE = G_LITTLE_ENDIAN,
	ENDIANNESS_BIG = G_BIG_ENDIAN
} Endianness;


static gpointer rygel_wma_transcoder_parent_class = NULL;

GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_wma_transcoder_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_WMA_TRANSCODER_DUMMY_PROPERTY
};
#define RYGEL_WMA_TRANSCODER_BITRATE 64
#define RYGEL_WMA_TRANSCODER_CONVERT_SINK_PAD "convert-sink-pad"
RygelWMATranscoder* rygel_wma_transcoder_new (void);
RygelWMATranscoder* rygel_wma_transcoder_construct (GType object_type);
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
RygelTranscoder* rygel_transcoder_construct (GType object_type, const char* mime_type, const char* dlna_profile, const char* upnp_class);
static GstElement* rygel_wma_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error);
RygelWMATranscoderBin* rygel_wma_transcoder_bin_new (RygelMediaItem* item, GstElement* src, RygelWMATranscoder* transcoder, GError** error);
RygelWMATranscoderBin* rygel_wma_transcoder_bin_construct (GType object_type, RygelMediaItem* item, GstElement* src, RygelWMATranscoder* transcoder, GError** error);
GType rygel_wma_transcoder_bin_get_type (void) G_GNUC_CONST;
static GUPnPDIDLLiteResource* rygel_wma_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static guint rygel_wma_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GstElement* rygel_wma_transcoder_create_encoder (RygelWMATranscoder* self, RygelMediaItem* item, const char* src_pad_name, const char* sink_pad_name, GError** error);
GType endianness_get_type (void) G_GNUC_CONST;
RygelL16Transcoder* rygel_l16_transcoder_new (Endianness endianness);
RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type, Endianness endianness);
GType rygel_l16_transcoder_get_type (void) G_GNUC_CONST;
GstElement* rygel_l16_transcoder_create_encoder (RygelL16Transcoder* self, RygelMediaItem* item, const char* src_pad_name, const char* sink_pad_name, GError** error);
GstElement* rygel_gst_utils_create_element (const char* factoryname, const char* name, GError** error);
static inline void _dynamic_set_bitrate7 (GstElement* obj, gint value);



#line 30 "rygel-wma-transcoder.vala"
RygelWMATranscoder* rygel_wma_transcoder_construct (GType object_type) {
#line 262 "rygel-wma-transcoder.c"
	RygelWMATranscoder * self;
#line 31 "rygel-wma-transcoder.vala"
	self = (RygelWMATranscoder*) rygel_transcoder_construct (object_type, "audio/x-wma", "WMA", RYGEL_AUDIO_ITEM_UPNP_CLASS);
#line 266 "rygel-wma-transcoder.c"
	return self;
}


#line 30 "rygel-wma-transcoder.vala"
RygelWMATranscoder* rygel_wma_transcoder_new (void) {
#line 30 "rygel-wma-transcoder.vala"
	return rygel_wma_transcoder_construct (RYGEL_TYPE_WMA_TRANSCODER);
#line 275 "rygel-wma-transcoder.c"
}


#line 34 "rygel-wma-transcoder.vala"
static GstElement* rygel_wma_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error) {
#line 281 "rygel-wma-transcoder.c"
	RygelWMATranscoder * self;
	GstElement* result = NULL;
	RygelWMATranscoderBin* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (RygelWMATranscoder*) base;
#line 34 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 34 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 37 "rygel-wma-transcoder.vala"
	_tmp0_ = rygel_wma_transcoder_bin_new (item, src, self, &_inner_error_);
#line 293 "rygel-wma-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = (GstElement*) _tmp0_;
#line 37 "rygel-wma-transcoder.vala"
	return result;
#line 301 "rygel-wma-transcoder.c"
}


#line 40 "rygel-wma-transcoder.vala"
static GUPnPDIDLLiteResource* rygel_wma_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
#line 307 "rygel-wma-transcoder.c"
	RygelWMATranscoder * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* resource;
	GError * _inner_error_ = NULL;
	self = (RygelWMATranscoder*) base;
#line 40 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 40 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 40 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 44 "rygel-wma-transcoder.vala"
	resource = RYGEL_TRANSCODER_CLASS (rygel_wma_transcoder_parent_class)->add_resource (RYGEL_TRANSCODER (self), didl_item, item, manager, &_inner_error_);
#line 321 "rygel-wma-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 45 "rygel-wma-transcoder.vala"
	if (resource == NULL) {
#line 328 "rygel-wma-transcoder.c"
		result = NULL;
		_g_object_unref0 (resource);
#line 46 "rygel-wma-transcoder.vala"
		return result;
#line 333 "rygel-wma-transcoder.c"
	}
#line 49 "rygel-wma-transcoder.vala"
	gupnp_didl_lite_resource_set_bitrate (resource, (RYGEL_WMA_TRANSCODER_BITRATE * 1000) / 8);
#line 337 "rygel-wma-transcoder.c"
	result = resource;
#line 51 "rygel-wma-transcoder.vala"
	return result;
#line 341 "rygel-wma-transcoder.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 54 "rygel-wma-transcoder.vala"
static guint rygel_wma_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item) {
#line 352 "rygel-wma-transcoder.c"
	RygelWMATranscoder * self;
	guint result = 0U;
	RygelMediaItem* _tmp0_;
	RygelAudioItem* audio_item;
	guint distance;
	self = (RygelWMATranscoder*) base;
#line 54 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (item != NULL, 0U);
#line 55 "rygel-wma-transcoder.vala"
	if (!RYGEL_IS_AUDIO_ITEM (item)) {
#line 363 "rygel-wma-transcoder.c"
		result = G_MAXUINT;
#line 56 "rygel-wma-transcoder.vala"
		return result;
#line 367 "rygel-wma-transcoder.c"
	}
#line 59 "rygel-wma-transcoder.vala"
	audio_item = _g_object_ref0 ((_tmp0_ = item, RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL));
#line 60 "rygel-wma-transcoder.vala"
	distance = 0;
#line 62 "rygel-wma-transcoder.vala"
	if (audio_item->bitrate > 0) {
#line 63 "rygel-wma-transcoder.vala"
		distance = distance + ((guint) abs (audio_item->bitrate - RYGEL_WMA_TRANSCODER_BITRATE));
#line 377 "rygel-wma-transcoder.c"
	}
	result = distance;
	_g_object_unref0 (audio_item);
#line 66 "rygel-wma-transcoder.vala"
	return result;
#line 383 "rygel-wma-transcoder.c"
}


static inline void _dynamic_set_bitrate7 (GstElement* obj, gint value) {
	g_object_set (obj, "bitrate", value, NULL);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


#line 69 "rygel-wma-transcoder.vala"
GstElement* rygel_wma_transcoder_create_encoder (RygelWMATranscoder* self, RygelMediaItem* item, const char* src_pad_name, const char* sink_pad_name, GError** error) {
#line 399 "rygel-wma-transcoder.c"
	GstElement* result = NULL;
	RygelL16Transcoder* l16_transcoder;
	GstElement* convert;
	GstElement* encoder;
	GstBin* bin;
	GstPad* pad;
	GstGhostPad* ghost;
	GstPad* _tmp0_;
	GstGhostPad* _tmp1_;
	GError * _inner_error_ = NULL;
#line 69 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 69 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 73 "rygel-wma-transcoder.vala"
	l16_transcoder = rygel_l16_transcoder_new (ENDIANNESS_LITTLE);
#line 74 "rygel-wma-transcoder.vala"
	convert = rygel_l16_transcoder_create_encoder (l16_transcoder, item, NULL, RYGEL_WMA_TRANSCODER_CONVERT_SINK_PAD, &_inner_error_);
#line 418 "rygel-wma-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (l16_transcoder);
		return NULL;
	}
#line 79 "rygel-wma-transcoder.vala"
	encoder = rygel_gst_utils_create_element ("ffenc_wmav2", "ffenc_wmav2", &_inner_error_);
#line 426 "rygel-wma-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_gst_object_unref0 (convert);
		_g_object_unref0 (l16_transcoder);
		return NULL;
	}
#line 81 "rygel-wma-transcoder.vala"
	_dynamic_set_bitrate7 (encoder, RYGEL_WMA_TRANSCODER_BITRATE * 1000);
#line 83 "rygel-wma-transcoder.vala"
	bin = (GstBin*) gst_bin_new ("wma-encoder-bin");
#line 84 "rygel-wma-transcoder.vala"
	gst_bin_add_many (bin, _gst_object_ref0 (convert), _gst_object_ref0 (encoder), NULL);
#line 85 "rygel-wma-transcoder.vala"
	gst_element_link (convert, encoder);
#line 87 "rygel-wma-transcoder.vala"
	pad = gst_element_get_static_pad (convert, RYGEL_WMA_TRANSCODER_CONVERT_SINK_PAD);
#line 88 "rygel-wma-transcoder.vala"
	ghost = (GstGhostPad*) gst_ghost_pad_new (sink_pad_name, pad);
#line 89 "rygel-wma-transcoder.vala"
	gst_element_add_pad ((GstElement*) bin, _gst_object_ref0 ((GstPad*) ghost));
#line 91 "rygel-wma-transcoder.vala"
	pad = (_tmp0_ = gst_element_get_static_pad (encoder, "src"), _gst_object_unref0 (pad), _tmp0_);
#line 92 "rygel-wma-transcoder.vala"
	ghost = (_tmp1_ = (GstGhostPad*) gst_ghost_pad_new (src_pad_name, pad), _gst_object_unref0 (ghost), _tmp1_);
#line 93 "rygel-wma-transcoder.vala"
	gst_element_add_pad ((GstElement*) bin, _gst_object_ref0 ((GstPad*) ghost));
#line 453 "rygel-wma-transcoder.c"
	result = (GstElement*) bin;
	_gst_object_unref0 (ghost);
	_gst_object_unref0 (pad);
	_gst_object_unref0 (encoder);
	_gst_object_unref0 (convert);
	_g_object_unref0 (l16_transcoder);
#line 95 "rygel-wma-transcoder.vala"
	return result;
#line 462 "rygel-wma-transcoder.c"
}


static void rygel_wma_transcoder_class_init (RygelWMATranscoderClass * klass) {
	rygel_wma_transcoder_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRANSCODER_CLASS (klass)->create_source = rygel_wma_transcoder_real_create_source;
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_wma_transcoder_real_add_resource;
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_wma_transcoder_real_get_distance;
}


static void rygel_wma_transcoder_instance_init (RygelWMATranscoder * self) {
}


GType rygel_wma_transcoder_get_type (void) {
	static volatile gsize rygel_wma_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_wma_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelWMATranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_wma_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelWMATranscoder), 0, (GInstanceInitFunc) rygel_wma_transcoder_instance_init, NULL };
		GType rygel_wma_transcoder_type_id;
		rygel_wma_transcoder_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODER, "RygelWMATranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_wma_transcoder_type_id__volatile, rygel_wma_transcoder_type_id);
	}
	return rygel_wma_transcoder_type_id__volatile;
}




