/* rygel-av-transport.c generated by valac 0.9.6, the Vala compiler
 * generated from rygel-av-transport.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_AV_TRANSPORT (rygel_av_transport_get_type ())
#define RYGEL_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport))
#define RYGEL_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))
#define RYGEL_IS_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_IS_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))

typedef struct _RygelAVTransport RygelAVTransport;
typedef struct _RygelAVTransportClass RygelAVTransportClass;
typedef struct _RygelAVTransportPrivate RygelAVTransportPrivate;

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;

struct _RygelAVTransport {
	GUPnPService parent_instance;
	RygelAVTransportPrivate * priv;
};

struct _RygelAVTransportClass {
	GUPnPServiceClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, const char* time);
	char** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	char** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	const char* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const char* value);
	const char* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const char* value);
	double (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, double value);
	char* (*get_duration) (RygelMediaPlayer* self);
	char* (*get_position) (RygelMediaPlayer* self);
};

struct _RygelAVTransportPrivate {
	guint _n_tracks;
	guint _track;
	char* _metadata;
	char* _status;
	char* _speed;
	char* _mode;
	RygelChangeLog* changelog;
	RygelMediaPlayer* player;
};


static gpointer rygel_av_transport_parent_class = NULL;

GType rygel_av_transport_get_type (void) G_GNUC_CONST;
GType rygel_change_log_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
#define RYGEL_AV_TRANSPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportPrivate))
enum  {
	RYGEL_AV_TRANSPORT_DUMMY_PROPERTY,
	RYGEL_AV_TRANSPORT_N_TRACKS,
	RYGEL_AV_TRANSPORT_TRACK,
	RYGEL_AV_TRANSPORT_METADATA,
	RYGEL_AV_TRANSPORT_URI,
	RYGEL_AV_TRANSPORT_STATUS,
	RYGEL_AV_TRANSPORT_SPEED,
	RYGEL_AV_TRANSPORT_MODE
};
#define RYGEL_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
#define RYGEL_AV_TRANSPORT_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/AVT/"
static void rygel_av_transport_real_constructed (GObject* base);
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const char* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const char* service_ns);
static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self);
static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const char* variable, GValue* value);
static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const char* variable, GValue* value, gpointer self);
static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
void rygel_change_log_log (RygelChangeLog* self, const char* variable, const char* value);
const char* rygel_media_player_get_playback_state (RygelMediaPlayer* self);
const char* rygel_av_transport_get_status (RygelAVTransport* self);
const char* rygel_av_transport_get_mode (RygelAVTransport* self);
const char* rygel_av_transport_get_speed (RygelAVTransport* self);
guint rygel_av_transport_get_n_tracks (RygelAVTransport* self);
guint rygel_av_transport_get_track (RygelAVTransport* self);
char* rygel_media_player_get_duration (RygelMediaPlayer* self);
char* rygel_av_transport_get_metadata (RygelAVTransport* self);
char* rygel_av_transport_get_uri (RygelAVTransport* self);
char* rygel_change_log_finish (RygelChangeLog* self);
static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action);
void rygel_av_transport_set_uri (RygelAVTransport* self, const char* value);
void rygel_av_transport_set_metadata (RygelAVTransport* self, const char* value);
char* rygel_media_player_get_position (RygelMediaPlayer* self);
void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const char* value);
gboolean rygel_media_player_seek (RygelMediaPlayer* self, const char* time);
RygelAVTransport* rygel_av_transport_new (void);
RygelAVTransport* rygel_av_transport_construct (GType object_type);
void rygel_av_transport_set_n_tracks (RygelAVTransport* self, guint value);
void rygel_av_transport_set_track (RygelAVTransport* self, guint value);
const char* rygel_media_player_get_uri (RygelMediaPlayer* self);
void rygel_media_player_set_uri (RygelMediaPlayer* self, const char* value);
void rygel_av_transport_set_status (RygelAVTransport* self, const char* value);
void rygel_av_transport_set_speed (RygelAVTransport* self, const char* value);
void rygel_av_transport_set_mode (RygelAVTransport* self, const char* value);
static void rygel_av_transport_finalize (GObject* obj);
static void rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 169 "rygel-av-transport.vala"
static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const char* variable, GValue* value, gpointer self) {
#line 217 "rygel-av-transport.c"
	rygel_av_transport_query_last_change_cb (self, _sender, variable, value);
}


#line 213 "rygel-av-transport.vala"
static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 224 "rygel-av-transport.c"
	rygel_av_transport_set_av_transport_uri_cb (self, _sender, action);
}


#line 234 "rygel-av-transport.vala"
static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 231 "rygel-av-transport.c"
	rygel_av_transport_get_media_info_cb (self, _sender, action);
}


#line 271 "rygel-av-transport.vala"
static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 238 "rygel-av-transport.c"
	rygel_av_transport_get_transport_info_cb (self, _sender, action);
}


#line 290 "rygel-av-transport.vala"
static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 245 "rygel-av-transport.c"
	rygel_av_transport_get_position_info_cb (self, _sender, action);
}


#line 324 "rygel-av-transport.vala"
static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 252 "rygel-av-transport.c"
	rygel_av_transport_get_device_capabilities_cb (self, _sender, action);
}


#line 343 "rygel-av-transport.vala"
static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 259 "rygel-av-transport.c"
	rygel_av_transport_get_transport_settings_cb (self, _sender, action);
}


#line 359 "rygel-av-transport.vala"
static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 266 "rygel-av-transport.c"
	rygel_av_transport_stop_cb (self, _sender, action);
}


#line 369 "rygel-av-transport.vala"
static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 273 "rygel-av-transport.c"
	rygel_av_transport_play_cb (self, _sender, action);
}


#line 388 "rygel-av-transport.vala"
static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 280 "rygel-av-transport.c"
	rygel_av_transport_pause_cb (self, _sender, action);
}


#line 398 "rygel-av-transport.vala"
static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 287 "rygel-av-transport.c"
	rygel_av_transport_seek_cb (self, _sender, action);
}


#line 430 "rygel-av-transport.vala"
static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 294 "rygel-av-transport.c"
	rygel_av_transport_next_cb (self, _sender, action);
}


#line 434 "rygel-av-transport.vala"
static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 301 "rygel-av-transport.c"
	rygel_av_transport_previous_cb (self, _sender, action);
}


#line 438 "rygel-av-transport.vala"
static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 308 "rygel-av-transport.c"
	rygel_av_transport_notify_state_cb (self, _sender, pspec);
}


#line 442 "rygel-av-transport.vala"
static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 315 "rygel-av-transport.c"
	rygel_av_transport_notify_duration_cb (self, _sender, pspec);
}


#line 137 "rygel-av-transport.vala"
static void rygel_av_transport_real_constructed (GObject* base) {
#line 322 "rygel-av-transport.c"
	RygelAVTransport * self;
	RygelChangeLog* _tmp0_;
	RygelMediaPlayer* _tmp1_;
	self = (RygelAVTransport*) base;
#line 138 "rygel-av-transport.vala"
	self->priv->changelog = (_tmp0_ = rygel_change_log_new ((GUPnPService*) self, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS), _g_object_unref0 (self->priv->changelog), _tmp0_);
#line 139 "rygel-av-transport.vala"
	self->priv->player = (_tmp1_ = rygel_av_transport_get_player (self), _g_object_unref0 (self->priv->player), _tmp1_);
#line 141 "rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable, self, 0);
#line 143 "rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetAVTransportURI", (GCallback) _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked, self, 0);
#line 145 "rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo", (GCallback) _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked, self, 0);
#line 146 "rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportInfo", (GCallback) _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked, self, 0);
#line 147 "rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPositionInfo", (GCallback) _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked, self, 0);
#line 148 "rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceCapabilities", (GCallback) _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked, self, 0);
#line 150 "rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportSettings", (GCallback) _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked, self, 0);
#line 152 "rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Stop", (GCallback) _rygel_av_transport_stop_cb_gupnp_service_action_invoked, self, 0);
#line 153 "rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Play", (GCallback) _rygel_av_transport_play_cb_gupnp_service_action_invoked, self, 0);
#line 154 "rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Pause", (GCallback) _rygel_av_transport_pause_cb_gupnp_service_action_invoked, self, 0);
#line 155 "rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Seek", (GCallback) _rygel_av_transport_seek_cb_gupnp_service_action_invoked, self, 0);
#line 156 "rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Next", (GCallback) _rygel_av_transport_next_cb_gupnp_service_action_invoked, self, 0);
#line 157 "rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Previous", (GCallback) _rygel_av_transport_previous_cb_gupnp_service_action_invoked, self, 0);
#line 159 "rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) self->priv->player, "notify::playback-state", (GCallback) _rygel_av_transport_notify_state_cb_g_object_notify, self, 0);
#line 160 "rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) self->priv->player, "notify::duration", (GCallback) _rygel_av_transport_notify_duration_cb_g_object_notify, self, 0);
#line 361 "rygel-av-transport.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 163 "rygel-av-transport.vala"
static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self) {
#line 372 "rygel-av-transport.c"
	RygelMediaPlayer* result = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_;
	GUPnPResourceFactory* _tmp2_;
	RygelMediaRendererPlugin* _tmp3_;
	RygelMediaRendererPlugin* plugin;
#line 163 "rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 164 "rygel-av-transport.vala"
	plugin = (_tmp3_ = _g_object_ref0 ((_tmp2_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) (_tmp1_ = (g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL), _tmp0_))), RYGEL_IS_MEDIA_RENDERER_PLUGIN (_tmp2_) ? ((RygelMediaRendererPlugin*) _tmp2_) : NULL)), _g_object_unref0 (_tmp1_), _tmp3_);
#line 383 "rygel-av-transport.c"
	result = rygel_media_renderer_plugin_get_player (plugin);
	_g_object_unref0 (plugin);
#line 166 "rygel-av-transport.vala"
	return result;
#line 388 "rygel-av-transport.c"
}


#line 169 "rygel-av-transport.vala"
static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const char* variable, GValue* value) {
#line 394 "rygel-av-transport.c"
	RygelChangeLog* log;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
#line 169 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 169 "rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 169 "rygel-av-transport.vala"
	g_return_if_fail (variable != NULL);
#line 173 "rygel-av-transport.vala"
	log = rygel_change_log_new (NULL, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
#line 175 "rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportState", rygel_media_player_get_playback_state (self->priv->player));
#line 176 "rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportStatus", rygel_av_transport_get_status (self));
#line 177 "rygel-av-transport.vala"
	rygel_change_log_log (log, "PlaybackStorageMedium", "NOT_IMPLEMENTED");
#line 178 "rygel-av-transport.vala"
	rygel_change_log_log (log, "RecordStorageMedium", "NOT_IMPLEMENTED");
#line 179 "rygel-av-transport.vala"
	rygel_change_log_log (log, "PossiblePlaybackStorageMedia", "NOT_IMPLEMENTED");
#line 180 "rygel-av-transport.vala"
	rygel_change_log_log (log, "PossibleRecordStorageMedia", "NOT_IMPLEMENTED");
#line 181 "rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentPlayMode", rygel_av_transport_get_mode (self));
#line 182 "rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportPlaySpeed", rygel_av_transport_get_speed (self));
#line 183 "rygel-av-transport.vala"
	rygel_change_log_log (log, "RecordMediumWriteStatus", "NOT_IMPLEMENTED");
#line 184 "rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentRecordQualityMode", "NOT_IMPLEMENTED");
#line 185 "rygel-av-transport.vala"
	rygel_change_log_log (log, "PossibleRecordQualityMode", "NOT_IMPLEMENTED");
#line 186 "rygel-av-transport.vala"
	rygel_change_log_log (log, "NumberOfTracks", _tmp0_ = g_strdup_printf ("%u", rygel_av_transport_get_n_tracks (self)));
#line 436 "rygel-av-transport.c"
	_g_free0 (_tmp0_);
#line 187 "rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrack", _tmp1_ = g_strdup_printf ("%u", rygel_av_transport_get_track (self)));
#line 440 "rygel-av-transport.c"
	_g_free0 (_tmp1_);
#line 188 "rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackDuration", _tmp2_ = rygel_media_player_get_duration (self->priv->player));
#line 444 "rygel-av-transport.c"
	_g_free0 (_tmp2_);
#line 189 "rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentMediaDuration", _tmp3_ = rygel_media_player_get_duration (self->priv->player));
#line 448 "rygel-av-transport.c"
	_g_free0 (_tmp3_);
#line 190 "rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackMetadata", _tmp4_ = rygel_av_transport_get_metadata (self));
#line 452 "rygel-av-transport.c"
	_g_free0 (_tmp4_);
#line 191 "rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackURI", _tmp5_ = rygel_av_transport_get_uri (self));
#line 456 "rygel-av-transport.c"
	_g_free0 (_tmp5_);
#line 192 "rygel-av-transport.vala"
	rygel_change_log_log (log, "AVTransportURI", _tmp6_ = rygel_av_transport_get_uri (self));
#line 460 "rygel-av-transport.c"
	_g_free0 (_tmp6_);
#line 193 "rygel-av-transport.vala"
	rygel_change_log_log (log, "NextAVTransportURI", "NOT_IMPLEMENTED");
#line 195 "rygel-av-transport.vala"
	g_value_init (value, G_TYPE_STRING);
#line 196 "rygel-av-transport.vala"
	g_value_set_string (value, _tmp7_ = rygel_change_log_finish (log));
#line 468 "rygel-av-transport.c"
	_g_free0 (_tmp7_);
	_g_object_unref0 (log);
}


#line 200 "rygel-av-transport.vala"
static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action) {
#line 476 "rygel-av-transport.c"
	gboolean result = FALSE;
	guint instance_id = 0U;
#line 200 "rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 200 "rygel-av-transport.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 203 "rygel-av-transport.vala"
	gupnp_service_action_get (action, "InstanceID", G_TYPE_UINT, &instance_id, NULL);
#line 204 "rygel-av-transport.vala"
	if (instance_id != 0) {
#line 205 "rygel-av-transport.vala"
		gupnp_service_action_return_error (action, (guint) 718, _ ("Invalid InstanceID"));
#line 489 "rygel-av-transport.c"
		result = FALSE;
#line 207 "rygel-av-transport.vala"
		return result;
#line 493 "rygel-av-transport.c"
	}
	result = TRUE;
#line 210 "rygel-av-transport.vala"
	return result;
#line 498 "rygel-av-transport.c"
}


#line 213 "rygel-av-transport.vala"
static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 504 "rygel-av-transport.c"
	char* _uri;
	char* _metadata;
#line 213 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 213 "rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 213 "rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 215 "rygel-av-transport.vala"
	if (!rygel_av_transport_check_instance_id (self, action)) {
#line 216 "rygel-av-transport.vala"
		return;
#line 517 "rygel-av-transport.c"
	}
	_uri = NULL;
	_metadata = NULL;
#line 221 "rygel-av-transport.vala"
	gupnp_service_action_get (action, "CurrentURI", G_TYPE_STRING, &_uri, "CurrentURIMetaData", G_TYPE_STRING, &_metadata, NULL);
#line 228 "rygel-av-transport.vala"
	rygel_av_transport_set_uri (self, _uri);
#line 229 "rygel-av-transport.vala"
	rygel_av_transport_set_metadata (self, _metadata);
#line 231 "rygel-av-transport.vala"
	gupnp_service_action_return (action);
#line 529 "rygel-av-transport.c"
	_g_free0 (_metadata);
	_g_free0 (_uri);
}


#line 234 "rygel-av-transport.vala"
static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 537 "rygel-av-transport.c"
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
#line 234 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 234 "rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 234 "rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 236 "rygel-av-transport.vala"
	if (!rygel_av_transport_check_instance_id (self, action)) {
#line 237 "rygel-av-transport.vala"
		return;
#line 551 "rygel-av-transport.c"
	}
#line 240 "rygel-av-transport.vala"
	gupnp_service_action_set (action, "NrTracks", G_TYPE_UINT, rygel_av_transport_get_n_tracks (self), "MediaDuration", G_TYPE_STRING, _tmp0_ = rygel_media_player_get_duration (self->priv->player), "CurrentURI", G_TYPE_STRING, _tmp1_ = rygel_av_transport_get_uri (self), "CurrentURIMetaData", G_TYPE_STRING, _tmp2_ = rygel_av_transport_get_metadata (self), "NextURI", G_TYPE_STRING, "NOT_IMPLEMENTED", "NextURIMetaData", G_TYPE_STRING, "NOT_IMPLEMENTED", "PlayMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 555 "rygel-av-transport.c"
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
#line 268 "rygel-av-transport.vala"
	gupnp_service_action_return (action);
#line 561 "rygel-av-transport.c"
}


#line 271 "rygel-av-transport.vala"
static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 271 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 271 "rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 271 "rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 273 "rygel-av-transport.vala"
	if (!rygel_av_transport_check_instance_id (self, action)) {
#line 274 "rygel-av-transport.vala"
		return;
#line 577 "rygel-av-transport.c"
	}
#line 277 "rygel-av-transport.vala"
	gupnp_service_action_set (action, "CurrentTransportState", G_TYPE_STRING, rygel_media_player_get_playback_state (self->priv->player), "CurrentTransportStatus", G_TYPE_STRING, rygel_av_transport_get_status (self), "CurrentSpeed", G_TYPE_STRING, rygel_av_transport_get_speed (self), NULL);
#line 287 "rygel-av-transport.vala"
	gupnp_service_action_return (action);
#line 583 "rygel-av-transport.c"
}


#line 290 "rygel-av-transport.vala"
static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 589 "rygel-av-transport.c"
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
#line 290 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 290 "rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 290 "rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 292 "rygel-av-transport.vala"
	if (!rygel_av_transport_check_instance_id (self, action)) {
#line 293 "rygel-av-transport.vala"
		return;
#line 605 "rygel-av-transport.c"
	}
#line 296 "rygel-av-transport.vala"
	gupnp_service_action_set (action, "Track", G_TYPE_UINT, rygel_av_transport_get_track (self), "TrackDuration", G_TYPE_STRING, _tmp0_ = rygel_media_player_get_duration (self->priv->player), "TrackMetaData", G_TYPE_STRING, _tmp1_ = rygel_av_transport_get_metadata (self), "TrackURI", G_TYPE_STRING, _tmp2_ = rygel_av_transport_get_uri (self), "RelTime", G_TYPE_STRING, _tmp3_ = rygel_media_player_get_position (self->priv->player), "AbsTime", G_TYPE_STRING, _tmp4_ = rygel_media_player_get_position (self->priv->player), "RelCount", G_TYPE_INT, G_MAXINT, "AbsCount", G_TYPE_INT, G_MAXINT, NULL);
#line 609 "rygel-av-transport.c"
	_g_free0 (_tmp4_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
#line 321 "rygel-av-transport.vala"
	gupnp_service_action_return (action);
#line 617 "rygel-av-transport.c"
}


#line 324 "rygel-av-transport.vala"
static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 324 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 324 "rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 324 "rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 326 "rygel-av-transport.vala"
	if (!rygel_av_transport_check_instance_id (self, action)) {
#line 327 "rygel-av-transport.vala"
		return;
#line 633 "rygel-av-transport.c"
	}
#line 330 "rygel-av-transport.vala"
	gupnp_service_action_set (action, "PlayMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecQualityModes", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 340 "rygel-av-transport.vala"
	gupnp_service_action_return (action);
#line 639 "rygel-av-transport.c"
}


#line 343 "rygel-av-transport.vala"
static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 343 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 343 "rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 343 "rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 345 "rygel-av-transport.vala"
	if (!rygel_av_transport_check_instance_id (self, action)) {
#line 346 "rygel-av-transport.vala"
		return;
#line 655 "rygel-av-transport.c"
	}
#line 349 "rygel-av-transport.vala"
	gupnp_service_action_set (action, "PlayMode", G_TYPE_STRING, rygel_av_transport_get_mode (self), "RecQualityMode", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 356 "rygel-av-transport.vala"
	gupnp_service_action_return (action);
#line 661 "rygel-av-transport.c"
}


#line 359 "rygel-av-transport.vala"
static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 359 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 359 "rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 359 "rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 360 "rygel-av-transport.vala"
	if (!rygel_av_transport_check_instance_id (self, action)) {
#line 361 "rygel-av-transport.vala"
		return;
#line 677 "rygel-av-transport.c"
	}
#line 364 "rygel-av-transport.vala"
	rygel_media_player_set_playback_state (self->priv->player, "STOPPED");
#line 366 "rygel-av-transport.vala"
	gupnp_service_action_return (action);
#line 683 "rygel-av-transport.c"
}


#line 369 "rygel-av-transport.vala"
static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 689 "rygel-av-transport.c"
	char* speed;
#line 369 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 369 "rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 369 "rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 370 "rygel-av-transport.vala"
	if (!rygel_av_transport_check_instance_id (self, action)) {
#line 371 "rygel-av-transport.vala"
		return;
#line 701 "rygel-av-transport.c"
	}
	speed = NULL;
#line 376 "rygel-av-transport.vala"
	gupnp_service_action_get (action, "Speed", G_TYPE_STRING, &speed, NULL);
#line 377 "rygel-av-transport.vala"
	if (_vala_strcmp0 (speed, "1") != 0) {
#line 378 "rygel-av-transport.vala"
		gupnp_service_action_return_error (action, (guint) 717, _ ("Play speed not supported"));
#line 710 "rygel-av-transport.c"
		_g_free0 (speed);
#line 380 "rygel-av-transport.vala"
		return;
#line 714 "rygel-av-transport.c"
	}
#line 383 "rygel-av-transport.vala"
	rygel_media_player_set_playback_state (self->priv->player, "PLAYING");
#line 385 "rygel-av-transport.vala"
	gupnp_service_action_return (action);
#line 720 "rygel-av-transport.c"
	_g_free0 (speed);
}


#line 388 "rygel-av-transport.vala"
static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 388 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 388 "rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 388 "rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 389 "rygel-av-transport.vala"
	if (!rygel_av_transport_check_instance_id (self, action)) {
#line 390 "rygel-av-transport.vala"
		return;
#line 737 "rygel-av-transport.c"
	}
#line 393 "rygel-av-transport.vala"
	rygel_media_player_set_playback_state (self->priv->player, "PAUSED_PLAYBACK");
#line 395 "rygel-av-transport.vala"
	gupnp_service_action_return (action);
#line 743 "rygel-av-transport.c"
}


#line 398 "rygel-av-transport.vala"
static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 749 "rygel-av-transport.c"
	char* unit;
	char* target;
	const char* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
#line 398 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 398 "rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 398 "rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 399 "rygel-av-transport.vala"
	if (!rygel_av_transport_check_instance_id (self, action)) {
#line 400 "rygel-av-transport.vala"
		return;
#line 766 "rygel-av-transport.c"
	}
	unit = NULL;
	target = NULL;
#line 405 "rygel-av-transport.vala"
	gupnp_service_action_get (action, "Unit", G_TYPE_STRING, &unit, "Target", G_TYPE_STRING, &target, NULL);
#line 772 "rygel-av-transport.c"
	_tmp0_ = unit;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("ABS_TIME")))) || (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("REL_TIME")))))
	switch (0) {
		default:
		{
#line 414 "rygel-av-transport.vala"
			if (!rygel_media_player_seek (self->priv->player, target)) {
#line 415 "rygel-av-transport.vala"
				gupnp_service_action_return_error (action, (guint) 710, _ ("Seek mode not supported"));
#line 783 "rygel-av-transport.c"
				_g_free0 (target);
				_g_free0 (unit);
#line 417 "rygel-av-transport.vala"
				return;
#line 788 "rygel-av-transport.c"
			}
#line 420 "rygel-av-transport.vala"
			gupnp_service_action_return (action);
#line 792 "rygel-av-transport.c"
			_g_free0 (target);
			_g_free0 (unit);
#line 422 "rygel-av-transport.vala"
			return;
#line 797 "rygel-av-transport.c"
		}
	} else
	switch (0) {
		default:
		{
#line 424 "rygel-av-transport.vala"
			gupnp_service_action_return_error (action, (guint) 710, _ ("Seek mode not supported"));
#line 805 "rygel-av-transport.c"
			_g_free0 (target);
			_g_free0 (unit);
#line 426 "rygel-av-transport.vala"
			return;
#line 810 "rygel-av-transport.c"
		}
	}
	_g_free0 (target);
	_g_free0 (unit);
}


#line 430 "rygel-av-transport.vala"
static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 430 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 430 "rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 430 "rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 431 "rygel-av-transport.vala"
	gupnp_service_action_return_error (action, (guint) 701, _ ("Transition not available"));
#line 828 "rygel-av-transport.c"
}


#line 434 "rygel-av-transport.vala"
static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
#line 434 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 434 "rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 434 "rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 435 "rygel-av-transport.vala"
	gupnp_service_action_return_error (action, (guint) 701, _ ("Transition not available"));
#line 842 "rygel-av-transport.c"
}


#line 438 "rygel-av-transport.vala"
static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
#line 438 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 438 "rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 438 "rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 439 "rygel-av-transport.vala"
	rygel_change_log_log (self->priv->changelog, "TransportState", rygel_media_player_get_playback_state (self->priv->player));
#line 856 "rygel-av-transport.c"
}


#line 442 "rygel-av-transport.vala"
static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
#line 862 "rygel-av-transport.c"
	char* _tmp0_;
	char* _tmp1_;
#line 442 "rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 442 "rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 442 "rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 443 "rygel-av-transport.vala"
	rygel_change_log_log (self->priv->changelog, "CurrentTrackDuration", _tmp0_ = rygel_media_player_get_duration (self->priv->player));
#line 873 "rygel-av-transport.c"
	_g_free0 (_tmp0_);
#line 444 "rygel-av-transport.vala"
	rygel_change_log_log (self->priv->changelog, "CurrentMediaDuration", _tmp1_ = rygel_media_player_get_duration (self->priv->player));
#line 877 "rygel-av-transport.c"
	_g_free0 (_tmp1_);
}


#line 26 "rygel-av-transport.vala"
RygelAVTransport* rygel_av_transport_construct (GType object_type) {
#line 884 "rygel-av-transport.c"
	RygelAVTransport * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


#line 26 "rygel-av-transport.vala"
RygelAVTransport* rygel_av_transport_new (void) {
#line 26 "rygel-av-transport.vala"
	return rygel_av_transport_construct (RYGEL_TYPE_AV_TRANSPORT);
#line 895 "rygel-av-transport.c"
}


guint rygel_av_transport_get_n_tracks (RygelAVTransport* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_n_tracks;
#line 38 "rygel-av-transport.vala"
	return result;
#line 905 "rygel-av-transport.c"
}


void rygel_av_transport_set_n_tracks (RygelAVTransport* self, guint value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 42 "rygel-av-transport.vala"
	self->priv->_n_tracks = value;
#line 44 "rygel-av-transport.vala"
	rygel_change_log_log (self->priv->changelog, "NumberOfTracks", _tmp0_ = g_strdup_printf ("%u", self->priv->_n_tracks));
#line 916 "rygel-av-transport.c"
	_g_free0 (_tmp0_);
	g_object_notify ((GObject *) self, "n-tracks");
}


guint rygel_av_transport_get_track (RygelAVTransport* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_track;
#line 51 "rygel-av-transport.vala"
	return result;
#line 928 "rygel-av-transport.c"
}


void rygel_av_transport_set_track (RygelAVTransport* self, guint value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 55 "rygel-av-transport.vala"
	self->priv->_track = value;
#line 57 "rygel-av-transport.vala"
	rygel_change_log_log (self->priv->changelog, "CurrentTrack", _tmp0_ = g_strdup_printf ("%u", self->priv->_track));
#line 939 "rygel-av-transport.c"
	_g_free0 (_tmp0_);
	g_object_notify ((GObject *) self, "track");
}


char* rygel_av_transport_get_metadata (RygelAVTransport* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "rygel-av-transport.vala"
	if (self->priv->_metadata != NULL) {
#line 950 "rygel-av-transport.c"
		result = g_markup_escape_text (self->priv->_metadata, -1);
#line 65 "rygel-av-transport.vala"
		return result;
#line 954 "rygel-av-transport.c"
	} else {
		result = g_strdup ("");
#line 67 "rygel-av-transport.vala"
		return result;
#line 959 "rygel-av-transport.c"
	}
}


void rygel_av_transport_set_metadata (RygelAVTransport* self, const char* value) {
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
#line 72 "rygel-av-transport.vala"
	self->priv->_metadata = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_metadata), _tmp0_);
#line 74 "rygel-av-transport.vala"
	rygel_change_log_log (self->priv->changelog, "CurrentTrackMetadata", _tmp1_ = rygel_av_transport_get_metadata (self));
#line 972 "rygel-av-transport.c"
	_g_free0 (_tmp1_);
	g_object_notify ((GObject *) self, "metadata");
}


char* rygel_av_transport_get_uri (RygelAVTransport* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
#line 80 "rygel-av-transport.vala"
	if (rygel_media_player_get_uri (self->priv->player) != NULL) {
#line 983 "rygel-av-transport.c"
		result = g_markup_escape_text (rygel_media_player_get_uri (self->priv->player), -1);
#line 81 "rygel-av-transport.vala"
		return result;
#line 987 "rygel-av-transport.c"
	} else {
		result = g_strdup ("");
#line 83 "rygel-av-transport.vala"
		return result;
#line 992 "rygel-av-transport.c"
	}
}


void rygel_av_transport_set_uri (RygelAVTransport* self, const char* value) {
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
#line 88 "rygel-av-transport.vala"
	rygel_media_player_set_uri (self->priv->player, value);
#line 90 "rygel-av-transport.vala"
	rygel_change_log_log (self->priv->changelog, "CurrentTrackURI", _tmp0_ = rygel_av_transport_get_uri (self));
#line 1005 "rygel-av-transport.c"
	_g_free0 (_tmp0_);
#line 91 "rygel-av-transport.vala"
	rygel_change_log_log (self->priv->changelog, "AVTransportURI", _tmp1_ = rygel_av_transport_get_uri (self));
#line 1009 "rygel-av-transport.c"
	_g_free0 (_tmp1_);
	g_object_notify ((GObject *) self, "uri");
}


const char* rygel_av_transport_get_status (RygelAVTransport* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_status;
#line 98 "rygel-av-transport.vala"
	return result;
#line 1021 "rygel-av-transport.c"
}


void rygel_av_transport_set_status (RygelAVTransport* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 102 "rygel-av-transport.vala"
	self->priv->_status = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_status), _tmp0_);
#line 104 "rygel-av-transport.vala"
	rygel_change_log_log (self->priv->changelog, "TransportStatus", self->priv->_status);
#line 1032 "rygel-av-transport.c"
	g_object_notify ((GObject *) self, "status");
}


const char* rygel_av_transport_get_speed (RygelAVTransport* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_speed;
#line 111 "rygel-av-transport.vala"
	return result;
#line 1043 "rygel-av-transport.c"
}


void rygel_av_transport_set_speed (RygelAVTransport* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 115 "rygel-av-transport.vala"
	self->priv->_speed = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_speed), _tmp0_);
#line 117 "rygel-av-transport.vala"
	rygel_change_log_log (self->priv->changelog, "TransportPlaySpeed", self->priv->_speed);
#line 1054 "rygel-av-transport.c"
	g_object_notify ((GObject *) self, "speed");
}


const char* rygel_av_transport_get_mode (RygelAVTransport* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_mode;
#line 124 "rygel-av-transport.vala"
	return result;
#line 1065 "rygel-av-transport.c"
}


void rygel_av_transport_set_mode (RygelAVTransport* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
#line 128 "rygel-av-transport.vala"
	self->priv->_mode = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_mode), _tmp0_);
#line 130 "rygel-av-transport.vala"
	rygel_change_log_log (self->priv->changelog, "CurrentPlayMode", self->priv->_mode);
#line 1076 "rygel-av-transport.c"
	g_object_notify ((GObject *) self, "mode");
}


static void rygel_av_transport_class_init (RygelAVTransportClass * klass) {
	rygel_av_transport_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelAVTransportPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_av_transport_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = rygel_av_transport_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_av_transport_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_av_transport_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_N_TRACKS, g_param_spec_uint ("n-tracks", "n-tracks", "n-tracks", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_TRACK, g_param_spec_uint ("track", "track", "track", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_STATUS, g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_SPEED, g_param_spec_string ("speed", "speed", "speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_MODE, g_param_spec_string ("mode", "mode", "mode", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_av_transport_instance_init (RygelAVTransport * self) {
	self->priv = RYGEL_AV_TRANSPORT_GET_PRIVATE (self);
	self->priv->_n_tracks = (guint) 0;
	self->priv->_track = (guint) 0;
	self->priv->_metadata = g_strdup ("");
	self->priv->_status = g_strdup ("OK");
	self->priv->_speed = g_strdup ("1");
	self->priv->_mode = g_strdup ("NORMAL");
}


static void rygel_av_transport_finalize (GObject* obj) {
	RygelAVTransport * self;
	self = RYGEL_AV_TRANSPORT (obj);
	_g_free0 (self->priv->_metadata);
	_g_free0 (self->priv->_status);
	_g_free0 (self->priv->_speed);
	_g_free0 (self->priv->_mode);
	_g_object_unref0 (self->priv->changelog);
	_g_object_unref0 (self->priv->player);
	G_OBJECT_CLASS (rygel_av_transport_parent_class)->finalize (obj);
}


GType rygel_av_transport_get_type (void) {
	static volatile gsize rygel_av_transport_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_av_transport_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAVTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_av_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAVTransport), 0, (GInstanceInitFunc) rygel_av_transport_instance_init, NULL };
		GType rygel_av_transport_type_id;
		rygel_av_transport_type_id = g_type_register_static (GUPNP_TYPE_SERVICE, "RygelAVTransport", &g_define_type_info, 0);
		g_once_init_leave (&rygel_av_transport_type_id__volatile, rygel_av_transport_type_id);
	}
	return rygel_av_transport_type_id__volatile;
}


static void rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = RYGEL_AV_TRANSPORT (object);
	switch (property_id) {
		case RYGEL_AV_TRANSPORT_N_TRACKS:
		g_value_set_uint (value, rygel_av_transport_get_n_tracks (self));
		break;
		case RYGEL_AV_TRANSPORT_TRACK:
		g_value_set_uint (value, rygel_av_transport_get_track (self));
		break;
		case RYGEL_AV_TRANSPORT_METADATA:
		g_value_take_string (value, rygel_av_transport_get_metadata (self));
		break;
		case RYGEL_AV_TRANSPORT_URI:
		g_value_take_string (value, rygel_av_transport_get_uri (self));
		break;
		case RYGEL_AV_TRANSPORT_STATUS:
		g_value_set_string (value, rygel_av_transport_get_status (self));
		break;
		case RYGEL_AV_TRANSPORT_SPEED:
		g_value_set_string (value, rygel_av_transport_get_speed (self));
		break;
		case RYGEL_AV_TRANSPORT_MODE:
		g_value_set_string (value, rygel_av_transport_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = RYGEL_AV_TRANSPORT (object);
	switch (property_id) {
		case RYGEL_AV_TRANSPORT_N_TRACKS:
		rygel_av_transport_set_n_tracks (self, g_value_get_uint (value));
		break;
		case RYGEL_AV_TRANSPORT_TRACK:
		rygel_av_transport_set_track (self, g_value_get_uint (value));
		break;
		case RYGEL_AV_TRANSPORT_METADATA:
		rygel_av_transport_set_metadata (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_URI:
		rygel_av_transport_set_uri (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_STATUS:
		rygel_av_transport_set_status (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_SPEED:
		rygel_av_transport_set_speed (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_MODE:
		rygel_av_transport_set_mode (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




