/* rygel-media-export-harvesting-task.c generated by valac 0.9.6, the Vala compiler
 * generated from rygel-media-export-harvesting-task.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskRunData RygelMediaExportHarvestingTaskRunData;

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER (rygel_media_export_dummy_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainer))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))

typedef struct _RygelMediaExportDummyContainer RygelMediaExportDummyContainer;
typedef struct _RygelMediaExportDummyContainerClass RygelMediaExportDummyContainerClass;
typedef struct _RygelNullContainerPrivate RygelNullContainerPrivate;
typedef struct _RygelMediaExportDummyContainerPrivate RygelMediaExportDummyContainerPrivate;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskEnumerateDirectoryData RygelMediaExportHarvestingTaskEnumerateDirectoryData;

#define RYGEL_MEDIA_EXPORT_TYPE_ITEM (rygel_media_export_item_get_type ())
#define RYGEL_MEDIA_EXPORT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_ITEM, RygelMediaExportItem))
#define RYGEL_MEDIA_EXPORT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_ITEM, RygelMediaExportItemClass))
#define RYGEL_MEDIA_EXPORT_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_ITEM))
#define RYGEL_MEDIA_EXPORT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_ITEM, RygelMediaExportItemClass))

typedef struct _RygelMediaExportItem RygelMediaExportItem;
typedef struct _RygelMediaExportItemClass RygelMediaExportItemClass;

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvestingTaskPrivate {
	RygelMediaExportMetadataExtractor* extractor;
	RygelMediaExportMediaCache* cache;
	GQueue* containers;
	GeeQueue* files;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GRegex* file_filter;
	char* flag;
	RygelMediaContainer* parent;
	GCancellable* _cancellable;
};

struct _RygelMediaExportHarvestingTaskRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportHarvestingTask* self;
	GFileInfo* info;
	char* _tmp0_;
	GError * _error_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelNullContainer {
	RygelMediaContainer parent_instance;
	RygelNullContainerPrivate * priv;
};

struct _RygelNullContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelMediaExportDummyContainer {
	RygelNullContainer parent_instance;
	RygelMediaExportDummyContainerPrivate * priv;
	GFile* file;
	GeeList* children;
};

struct _RygelMediaExportDummyContainerClass {
	RygelNullContainerClass parent_class;
};

struct _RygelMediaExportHarvestingTaskEnumerateDirectoryData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportHarvestingTask* self;
	GFile* directory;
	RygelMediaExportDummyContainer* _tmp0_;
	GFile* _tmp1_;
	GFileEnumerator* enumerator;
	GList* list;
	gboolean _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GError * err;
	GError * _inner_error_;
};


static gpointer rygel_media_export_harvesting_task_parent_class = NULL;
static RygelStateMachineIface* rygel_media_export_harvesting_task_rygel_state_machine_parent_iface = NULL;

GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE
};
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_BATCH_SIZE 256
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_STANDARD_SIZE
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const char* flag);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const char* flag);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
static void rygel_media_export_harvesting_task_on_extracted_cb (RygelMediaExportHarvestingTask* self, GFile* file, GUPnPDLNAInformation* dlna, const char* mime, guint64 size, guint64 mtime);
static void _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender, GFile* file, GUPnPDLNAInformation* info, const char* mime, guint64 size, guint64 mtime, gpointer self);
static void rygel_media_export_harvesting_task_on_extractor_error_cb (RygelMediaExportHarvestingTask* self, GFile* file, GError* _error_);
static void _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender, GFile* file, GError* err, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvesting_task_real_run_data_free (gpointer _data);
static void rygel_media_export_harvesting_task_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_export_harvesting_task_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_media_export_harvesting_task_real_run_co (RygelMediaExportHarvestingTaskRunData* data);
static gboolean rygel_media_export_harvesting_task_process_file (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info, RygelMediaContainer* parent);
static gboolean rygel_media_export_harvesting_task_on_idle (RygelMediaExportHarvestingTask* self);
static gboolean _rygel_media_export_harvesting_task_on_idle_gsource_func (gpointer self);
static gboolean rygel_media_export_harvesting_task_push_if_changed_or_unknown (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info);
GQuark rygel_media_export_database_error_quark (void);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error);
void rygel_media_export_recursive_file_monitor_add (RygelMediaExportRecursiveFileMonitor* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_recursive_file_monitor_add_finish (RygelMediaExportRecursiveFileMonitor* self, GAsyncResult* _res_);
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_new (GFile* file, RygelMediaContainer* parent);
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_construct (GType object_type, GFile* file, RygelMediaContainer* parent);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dummy_container_get_type (void) G_GNUC_CONST;
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
static gboolean rygel_media_export_harvesting_task_process_children (RygelMediaExportHarvestingTask* self, GList* list);
static inline RygelMediaExportDummyContainer* rygel_media_export_harvesting_task_container (RygelMediaExportHarvestingTask* self);
void rygel_media_export_dummy_container_seen (RygelMediaExportDummyContainer* self, GFile* file);
static void rygel_media_export_harvesting_task_enumerate_directory_data_free (gpointer _data);
static void rygel_media_export_harvesting_task_enumerate_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_media_export_harvesting_task_enumerate_directory (RygelMediaExportHarvestingTask* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_export_harvesting_task_enumerate_directory_finish (RygelMediaExportHarvestingTask* self, GAsyncResult* _res_);
static gboolean rygel_media_export_harvesting_task_enumerate_directory_co (RygelMediaExportHarvestingTaskEnumerateDirectoryData* data);
static void _g_list_free_g_object_unref (GList* self);
static void rygel_media_export_harvesting_task_cleanup_database (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvesting_task_do_update (RygelMediaExportHarvestingTask* self);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const char* id, GError** error);
static inline void rygel_media_export_harvesting_task_extract_file (RygelMediaExportHarvestingTask* self);
void rygel_media_export_media_cache_flag_object (RygelMediaExportMediaCache* self, GFile* file, const char* flag, GError** error);
static inline GFile* rygel_media_export_harvesting_task_file (RygelMediaExportHarvestingTask* self);
static inline RygelMediaContainer* rygel_media_export_harvesting_task_current_parent (RygelMediaExportHarvestingTask* self);
RygelMediaExportItem* rygel_media_export_item_new_simple (RygelMediaContainer* parent, GFile* file, const char* mime, guint64 size, guint64 mtime);
RygelMediaExportItem* rygel_media_export_item_construct_simple (GType object_type, RygelMediaContainer* parent, GFile* file, const char* mime, guint64 size, guint64 mtime);
GType rygel_media_export_item_get_type (void) G_GNUC_CONST;
RygelMediaExportItem* rygel_media_export_item_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const char* mime, guint64 size, guint64 mtime);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file);
static void rygel_media_export_harvesting_task_finalize (GObject* obj);
static void rygel_media_export_harvesting_task_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_media_export_harvesting_task_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 272 "rygel-media-export-harvesting-task.vala"
static void _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender, GFile* file, GUPnPDLNAInformation* info, const char* mime, guint64 size, guint64 mtime, gpointer self) {
#line 267 "rygel-media-export-harvesting-task.c"
	rygel_media_export_harvesting_task_on_extracted_cb (self, file, info, mime, size, mtime);
}


#line 317 "rygel-media-export-harvesting-task.vala"
static void _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender, GFile* file, GError* err, gpointer self) {
#line 274 "rygel-media-export-harvesting-task.c"
	rygel_media_export_harvesting_task_on_extractor_error_cb (self, file, err);
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


#line 45 "rygel-media-export-harvesting-task.vala"
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const char* flag) {
#line 286 "rygel-media-export-harvesting-task.c"
	RygelMediaExportHarvestingTask * self;
	RygelMediaExportMetadataExtractor* _tmp0_;
	GFile* _tmp1_;
	RygelMediaContainer* _tmp2_;
	GeeQueue* _tmp5_;
	GQueue* _tmp6_;
	RygelMediaExportRecursiveFileMonitor* _tmp7_;
	char* _tmp8_;
	GRegex* _tmp9_;
	GError * _inner_error_ = NULL;
#line 45 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (extractor != NULL, NULL);
#line 45 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (monitor != NULL, NULL);
#line 45 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 45 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 45 "rygel-media-export-harvesting-task.vala"
	self = (RygelMediaExportHarvestingTask*) g_object_new (object_type, NULL);
#line 51 "rygel-media-export-harvesting-task.vala"
	self->priv->extractor = (_tmp0_ = _g_object_ref0 (extractor), _g_object_unref0 (self->priv->extractor), _tmp0_);
#line 52 "rygel-media-export-harvesting-task.vala"
	self->origin = (_tmp1_ = _g_object_ref0 (file), _g_object_unref0 (self->origin), _tmp1_);
#line 53 "rygel-media-export-harvesting-task.vala"
	self->priv->parent = (_tmp2_ = _g_object_ref0 (parent), _g_object_unref0 (self->priv->parent), _tmp2_);
#line 313 "rygel-media-export-harvesting-task.c"
	{
		RygelMediaExportMediaCache* _tmp3_;
		RygelMediaExportMediaCache* _tmp4_;
#line 56 "rygel-media-export-harvesting-task.vala"
		_tmp3_ = rygel_media_export_media_cache_get_default (&_inner_error_);
#line 319 "rygel-media-export-harvesting-task.c"
		if (_inner_error_ != NULL) {
			goto __catch44_g_error;
		}
#line 56 "rygel-media-export-harvesting-task.vala"
		self->priv->cache = (_tmp4_ = _tmp3_, _g_object_unref0 (self->priv->cache), _tmp4_);
#line 325 "rygel-media-export-harvesting-task.c"
	}
	goto __finally44;
	__catch44_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 61 "rygel-media-export-harvesting-task.vala"
			g_assert_not_reached ();
#line 336 "rygel-media-export-harvesting-task.c"
			_g_error_free0 (_error_);
		}
	}
	__finally44:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 64 "rygel-media-export-harvesting-task.vala"
	g_signal_connect_object (self->priv->extractor, "extraction-done", (GCallback) _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done, self, 0);
#line 65 "rygel-media-export-harvesting-task.vala"
	g_signal_connect_object (self->priv->extractor, "error", (GCallback) _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error, self, 0);
#line 67 "rygel-media-export-harvesting-task.vala"
	self->priv->files = (_tmp5_ = (GeeQueue*) gee_linked_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->files), _tmp5_);
#line 68 "rygel-media-export-harvesting-task.vala"
	self->priv->containers = (_tmp6_ = g_queue_new (), _g_queue_free0 (self->priv->containers), _tmp6_);
#line 69 "rygel-media-export-harvesting-task.vala"
	self->priv->monitor = (_tmp7_ = _g_object_ref0 (monitor), _g_object_unref0 (self->priv->monitor), _tmp7_);
#line 70 "rygel-media-export-harvesting-task.vala"
	self->priv->flag = (_tmp8_ = g_strdup (flag), _g_free0 (self->priv->flag), _tmp8_);
#line 71 "rygel-media-export-harvesting-task.vala"
	self->priv->file_filter = (_tmp9_ = _g_regex_ref0 (file_filter), _g_regex_unref0 (self->priv->file_filter), _tmp9_);
#line 360 "rygel-media-export-harvesting-task.c"
	return self;
}


#line 45 "rygel-media-export-harvesting-task.vala"
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const char* flag) {
#line 45 "rygel-media-export-harvesting-task.vala"
	return rygel_media_export_harvesting_task_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, extractor, monitor, file_filter, file, parent, flag);
#line 369 "rygel-media-export-harvesting-task.c"
}


#line 74 "rygel-media-export-harvesting-task.vala"
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self) {
#line 375 "rygel-media-export-harvesting-task.c"
	GCancellable* _tmp0_;
#line 74 "rygel-media-export-harvesting-task.vala"
	g_return_if_fail (self != NULL);
#line 77 "rygel-media-export-harvesting-task.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp0_ = g_cancellable_new ());
#line 381 "rygel-media-export-harvesting-task.c"
	_g_object_unref0 (_tmp0_);
#line 78 "rygel-media-export-harvesting-task.vala"
	g_cancellable_cancel (rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 385 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_real_run_data_free (gpointer _data) {
	RygelMediaExportHarvestingTaskRunData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelMediaExportHarvestingTaskRunData, data);
}


static void rygel_media_export_harvesting_task_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportHarvestingTask * self;
	RygelMediaExportHarvestingTaskRunData* _data_;
	self = (RygelMediaExportHarvestingTask*) base;
	_data_ = g_slice_new0 (RygelMediaExportHarvestingTaskRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_harvesting_task_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_harvesting_task_real_run_data_free);
	_data_->self = g_object_ref (self);
	rygel_media_export_harvesting_task_real_run_co (_data_);
}


static void rygel_media_export_harvesting_task_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_export_harvesting_task_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_export_harvesting_task_real_run_co (data);
}


/**
     * Extract all metainformation from a given file.
     *
     * What action will be taken depends on the arguments
     * * file is a simple file. Then only information of this
     *   file will be extracted
     * * file is a directory and recursive is false. The children
     *   of the directory (if not directories themselves) will be
     *   enqueued for extraction
     * * file is a directory and recursive is true. ++ All ++ children
     *   of the directory will be enqueued for extraction, even directories
     *
     * No matter how many children are contained within file's hierarchy,
     * only one event is sent when all the children are done.
     */
#line 247 "rygel-media-export-harvesting-task.vala"
static gboolean _rygel_media_export_harvesting_task_on_idle_gsource_func (gpointer self) {
#line 440 "rygel-media-export-harvesting-task.c"
	gboolean result;
	result = rygel_media_export_harvesting_task_on_idle (self);
	return result;
}


static gboolean rygel_media_export_harvesting_task_real_run_co (RygelMediaExportHarvestingTaskRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 9:
		goto _state_9;
	}
	_state_0:
	{
		data->_state_ = 9;
		g_file_query_info_async (data->self->origin, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_media_export_harvesting_task_run_ready, data);
		return FALSE;
		_state_9:
		data->info = g_file_query_info_finish (data->self->origin, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch45_g_error;
		}
#line 104 "rygel-media-export-harvesting-task.vala"
		if (rygel_media_export_harvesting_task_process_file (data->self, data->self->origin, data->info, data->self->priv->parent)) {
#line 105 "rygel-media-export-harvesting-task.vala"
			if (g_file_info_get_file_type (data->info) != G_FILE_TYPE_DIRECTORY) {
#line 106 "rygel-media-export-harvesting-task.vala"
				g_queue_push_tail (data->self->priv->containers, _g_object_ref0 (data->self->priv->parent));
#line 472 "rygel-media-export-harvesting-task.c"
			}
#line 108 "rygel-media-export-harvesting-task.vala"
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_media_export_harvesting_task_on_idle_gsource_func, g_object_ref (data->self), g_object_unref);
#line 476 "rygel-media-export-harvesting-task.c"
		} else {
#line 110 "rygel-media-export-harvesting-task.vala"
			g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
#line 480 "rygel-media-export-harvesting-task.c"
		}
		_g_object_unref0 (data->info);
	}
	goto __finally45;
	__catch45_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
#line 113 "rygel-media-export-harvesting-task.vala"
			g_warning (_ ("Failed to harvest file %s: %s"), data->_tmp0_ = g_file_get_uri (data->self->origin), data->_error_->message);
#line 492 "rygel-media-export-harvesting-task.c"
			_g_free0 (data->_tmp0_);
#line 116 "rygel-media-export-harvesting-task.vala"
			g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
#line 496 "rygel-media-export-harvesting-task.c"
			_g_error_free0 (data->_error_);
		}
	}
	__finally45:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


/**
     * Add a file to the meta-data extraction queue.
     *
     * The file will only be added to the queue if one of the following
     * conditions is met:
     *   - The file is not in the cache
     *   - The current mtime of the file is larger than the cached
     *   - The size has changed
     * @param file to check
     * @param info FileInfo of the file to check
     * @return true, if the file has been queued, false otherwise.
     */
#line 132 "rygel-media-export-harvesting-task.vala"
static gboolean rygel_media_export_harvesting_task_push_if_changed_or_unknown (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info) {
#line 532 "rygel-media-export-harvesting-task.c"
	gboolean result = FALSE;
	gint64 timestamp = 0LL;
	gint64 size = 0LL;
	GError * _inner_error_ = NULL;
#line 132 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 132 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 132 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (info != NULL, FALSE);
#line 543 "rygel-media-export-harvesting-task.c"
	{
		gboolean _tmp0_;
#line 137 "rygel-media-export-harvesting-task.vala"
		_tmp0_ = rygel_media_export_media_cache_exists (self->priv->cache, file, &timestamp, &size, &_inner_error_);
#line 548 "rygel-media-export-harvesting-task.c"
		if (_inner_error_ != NULL) {
			goto __catch46_g_error;
		}
#line 137 "rygel-media-export-harvesting-task.vala"
		if (_tmp0_) {
#line 554 "rygel-media-export-harvesting-task.c"
			gint64 mtime;
			gboolean _tmp1_ = FALSE;
#line 138 "rygel-media-export-harvesting-task.vala"
			mtime = (gint64) g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_TIME_MODIFIED);
#line 141 "rygel-media-export-harvesting-task.vala"
			if (mtime > timestamp) {
#line 141 "rygel-media-export-harvesting-task.vala"
				_tmp1_ = TRUE;
#line 563 "rygel-media-export-harvesting-task.c"
			} else {
#line 142 "rygel-media-export-harvesting-task.vala"
				_tmp1_ = g_file_info_get_size (info) != size;
#line 567 "rygel-media-export-harvesting-task.c"
			}
#line 141 "rygel-media-export-harvesting-task.vala"
			if (_tmp1_) {
#line 143 "rygel-media-export-harvesting-task.vala"
				gee_queue_offer (self->priv->files, file);
#line 573 "rygel-media-export-harvesting-task.c"
				result = TRUE;
#line 145 "rygel-media-export-harvesting-task.vala"
				return result;
#line 577 "rygel-media-export-harvesting-task.c"
			}
		} else {
#line 148 "rygel-media-export-harvesting-task.vala"
			gee_queue_offer (self->priv->files, file);
#line 582 "rygel-media-export-harvesting-task.c"
			result = TRUE;
#line 150 "rygel-media-export-harvesting-task.vala"
			return result;
#line 586 "rygel-media-export-harvesting-task.c"
		}
	}
	goto __finally46;
	__catch46_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 153 "rygel-media-export-harvesting-task.vala"
			g_warning (_ ("Failed to query database: %s"), _error_->message);
#line 598 "rygel-media-export-harvesting-task.c"
			_g_error_free0 (_error_);
		}
	}
	__finally46:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
#line 156 "rygel-media-export-harvesting-task.vala"
	return result;
#line 611 "rygel-media-export-harvesting-task.c"
}


#line 159 "rygel-media-export-harvesting-task.vala"
static gboolean rygel_media_export_harvesting_task_process_file (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info, RygelMediaContainer* parent) {
#line 617 "rygel-media-export-harvesting-task.c"
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 159 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 159 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 159 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (info != NULL, FALSE);
#line 159 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (parent != NULL, FALSE);
#line 162 "rygel-media-export-harvesting-task.vala"
	if (g_utf8_get_char (g_utf8_offset_to_pointer (g_file_info_get_name (info), 0)) == '.') {
#line 630 "rygel-media-export-harvesting-task.c"
		result = FALSE;
#line 163 "rygel-media-export-harvesting-task.vala"
		return result;
#line 634 "rygel-media-export-harvesting-task.c"
	}
#line 166 "rygel-media-export-harvesting-task.vala"
	if (g_file_info_get_file_type (info) == G_FILE_TYPE_DIRECTORY) {
#line 638 "rygel-media-export-harvesting-task.c"
		RygelMediaExportDummyContainer* container;
#line 168 "rygel-media-export-harvesting-task.vala"
		rygel_media_export_recursive_file_monitor_add (self->priv->monitor, file, NULL, NULL);
#line 169 "rygel-media-export-harvesting-task.vala"
		container = rygel_media_export_dummy_container_new (file, parent);
#line 170 "rygel-media-export-harvesting-task.vala"
		g_queue_push_tail (self->priv->containers, _g_object_ref0 ((RygelMediaContainer*) container));
#line 646 "rygel-media-export-harvesting-task.c"
		{
#line 172 "rygel-media-export-harvesting-task.vala"
			rygel_media_export_media_cache_save_container (self->priv->cache, (RygelMediaContainer*) container, &_inner_error_);
#line 650 "rygel-media-export-harvesting-task.c"
			if (_inner_error_ != NULL) {
				goto __catch47_g_error;
			}
		}
		goto __finally47;
		__catch47_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
#line 174 "rygel-media-export-harvesting-task.vala"
				g_warning (_ ("Failed to update database: %s"), err->message);
#line 664 "rygel-media-export-harvesting-task.c"
				result = FALSE;
				_g_error_free0 (err);
				_g_object_unref0 (container);
#line 176 "rygel-media-export-harvesting-task.vala"
				return result;
#line 670 "rygel-media-export-harvesting-task.c"
			}
		}
		__finally47:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (container);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		result = TRUE;
		_g_object_unref0 (container);
#line 179 "rygel-media-export-harvesting-task.vala"
		return result;
#line 684 "rygel-media-export-harvesting-task.c"
	} else {
		gboolean _tmp0_ = FALSE;
#line 183 "rygel-media-export-harvesting-task.vala"
		if (self->priv->file_filter != NULL) {
#line 689 "rygel-media-export-harvesting-task.c"
			char* _tmp1_;
#line 184 "rygel-media-export-harvesting-task.vala"
			_tmp0_ = !g_regex_match (self->priv->file_filter, _tmp1_ = g_file_get_uri (file), 0, NULL);
#line 693 "rygel-media-export-harvesting-task.c"
			_g_free0 (_tmp1_);
		} else {
#line 183 "rygel-media-export-harvesting-task.vala"
			_tmp0_ = FALSE;
#line 698 "rygel-media-export-harvesting-task.c"
		}
#line 183 "rygel-media-export-harvesting-task.vala"
		if (_tmp0_) {
#line 702 "rygel-media-export-harvesting-task.c"
			result = FALSE;
#line 185 "rygel-media-export-harvesting-task.vala"
			return result;
#line 706 "rygel-media-export-harvesting-task.c"
		}
		result = rygel_media_export_harvesting_task_push_if_changed_or_unknown (self, file, info);
#line 188 "rygel-media-export-harvesting-task.vala"
		return result;
#line 711 "rygel-media-export-harvesting-task.c"
	}
}


#line 192 "rygel-media-export-harvesting-task.vala"
static gboolean rygel_media_export_harvesting_task_process_children (RygelMediaExportHarvestingTask* self, GList* list) {
#line 718 "rygel-media-export-harvesting-task.c"
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	RygelMediaExportDummyContainer* _tmp1_;
	GFile* _tmp2_;
	GFile* parent_dir;
#line 192 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 193 "rygel-media-export-harvesting-task.vala"
	if (list == NULL) {
#line 193 "rygel-media-export-harvesting-task.vala"
		_tmp0_ = TRUE;
#line 730 "rygel-media-export-harvesting-task.c"
	} else {
#line 193 "rygel-media-export-harvesting-task.vala"
		_tmp0_ = g_cancellable_is_cancelled (rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 734 "rygel-media-export-harvesting-task.c"
	}
#line 193 "rygel-media-export-harvesting-task.vala"
	if (_tmp0_) {
#line 738 "rygel-media-export-harvesting-task.c"
		result = FALSE;
#line 194 "rygel-media-export-harvesting-task.vala"
		return result;
#line 742 "rygel-media-export-harvesting-task.c"
	}
#line 197 "rygel-media-export-harvesting-task.vala"
	parent_dir = (_tmp2_ = _g_object_ref0 ((_tmp1_ = rygel_media_export_harvesting_task_container (self))->file), _g_object_unref0 (_tmp1_), _tmp2_);
#line 746 "rygel-media-export-harvesting-task.c"
	{
		GList* info_collection;
		GList* info_it;
#line 199 "rygel-media-export-harvesting-task.vala"
		info_collection = list;
#line 752 "rygel-media-export-harvesting-task.c"
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			GFileInfo* info;
#line 199 "rygel-media-export-harvesting-task.vala"
			info = _g_object_ref0 ((GFileInfo*) info_it->data);
#line 757 "rygel-media-export-harvesting-task.c"
			{
				GFile* file;
				RygelMediaExportDummyContainer* _tmp3_;
				RygelMediaExportDummyContainer* _tmp4_;
#line 200 "rygel-media-export-harvesting-task.vala"
				file = g_file_get_child (parent_dir, g_file_info_get_name (info));
#line 201 "rygel-media-export-harvesting-task.vala"
				rygel_media_export_dummy_container_seen (_tmp3_ = rygel_media_export_harvesting_task_container (self), file);
#line 766 "rygel-media-export-harvesting-task.c"
				_g_object_unref0 (_tmp3_);
#line 202 "rygel-media-export-harvesting-task.vala"
				rygel_media_export_harvesting_task_process_file (self, file, info, (RygelMediaContainer*) (_tmp4_ = rygel_media_export_harvesting_task_container (self)));
#line 770 "rygel-media-export-harvesting-task.c"
				_g_object_unref0 (_tmp4_);
				_g_object_unref0 (file);
				_g_object_unref0 (info);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (parent_dir);
#line 205 "rygel-media-export-harvesting-task.vala"
	return result;
#line 781 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_enumerate_directory_data_free (gpointer _data) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelMediaExportHarvestingTaskEnumerateDirectoryData, data);
}


static void rygel_media_export_harvesting_task_enumerate_directory (RygelMediaExportHarvestingTask* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = g_slice_new0 (RygelMediaExportHarvestingTaskEnumerateDirectoryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_harvesting_task_enumerate_directory);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_harvesting_task_enumerate_directory_data_free);
	_data_->self = g_object_ref (self);
	rygel_media_export_harvesting_task_enumerate_directory_co (_data_);
}


static void rygel_media_export_harvesting_task_enumerate_directory_finish (RygelMediaExportHarvestingTask* self, GAsyncResult* _res_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_export_harvesting_task_enumerate_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_export_harvesting_task_enumerate_directory_co (data);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gboolean rygel_media_export_harvesting_task_enumerate_directory_co (RygelMediaExportHarvestingTaskEnumerateDirectoryData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 10:
		goto _state_10;
		case 11:
		goto _state_11;
		case 12:
		goto _state_12;
	}
	_state_0:
	data->directory = (data->_tmp1_ = _g_object_ref0 ((data->_tmp0_ = rygel_media_export_harvesting_task_container (data->self))->file), _g_object_unref0 (data->_tmp0_), data->_tmp1_);
	{
		data->_state_ = 10;
		g_file_enumerate_children_async (data->directory, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_media_export_harvesting_task_enumerate_directory_ready, data);
		return FALSE;
		_state_10:
		data->enumerator = g_file_enumerate_children_finish (data->directory, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch48_g_error;
		}
		data->list = NULL;
		{
			data->_tmp2_ = TRUE;
#line 218 "rygel-media-export-harvesting-task.vala"
			while (TRUE) {
#line 218 "rygel-media-export-harvesting-task.vala"
				if (!data->_tmp2_) {
#line 222 "rygel-media-export-harvesting-task.vala"
					if (!rygel_media_export_harvesting_task_process_children (data->self, data->list)) {
#line 222 "rygel-media-export-harvesting-task.vala"
						break;
#line 858 "rygel-media-export-harvesting-task.c"
					}
				}
#line 218 "rygel-media-export-harvesting-task.vala"
				data->_tmp2_ = FALSE;
#line 863 "rygel-media-export-harvesting-task.c"
				data->_state_ = 11;
				g_file_enumerator_next_files_async (data->enumerator, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_BATCH_SIZE, G_PRIORITY_DEFAULT, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_media_export_harvesting_task_enumerate_directory_ready, data);
				return FALSE;
				_state_11:
				data->_tmp3_ = g_file_enumerator_next_files_finish (data->enumerator, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					__g_list_free_g_object_unref0 (data->list);
					_g_object_unref0 (data->enumerator);
					goto __catch48_g_error;
				}
#line 219 "rygel-media-export-harvesting-task.vala"
				data->list = (data->_tmp4_ = data->_tmp3_, __g_list_free_g_object_unref0 (data->list), data->_tmp4_);
#line 876 "rygel-media-export-harvesting-task.c"
			}
		}
		data->_state_ = 12;
		g_file_enumerator_close_async (data->enumerator, G_PRIORITY_DEFAULT, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_media_export_harvesting_task_enumerate_directory_ready, data);
		return FALSE;
		_state_12:
#line 224 "rygel-media-export-harvesting-task.vala"
		g_file_enumerator_close_finish (data->enumerator, data->_res_, &data->_inner_error_);
#line 885 "rygel-media-export-harvesting-task.c"
		if (data->_inner_error_ != NULL) {
			__g_list_free_g_object_unref0 (data->list);
			_g_object_unref0 (data->enumerator);
			goto __catch48_g_error;
		}
		__g_list_free_g_object_unref0 (data->list);
		_g_object_unref0 (data->enumerator);
	}
	goto __finally48;
	__catch48_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
#line 226 "rygel-media-export-harvesting-task.vala"
			g_warning (_ ("failed to enumerate folder: %s"), data->err->message);
#line 902 "rygel-media-export-harvesting-task.c"
			_g_error_free0 (data->err);
		}
	}
	__finally48:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
#line 229 "rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_cleanup_database (data->self);
#line 230 "rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_do_update (data->self);
#line 917 "rygel-media-export-harvesting-task.c"
	_g_object_unref0 (data->directory);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 233 "rygel-media-export-harvesting-task.vala"
static void rygel_media_export_harvesting_task_cleanup_database (RygelMediaExportHarvestingTask* self) {
#line 933 "rygel-media-export-harvesting-task.c"
	GError * _inner_error_ = NULL;
#line 233 "rygel-media-export-harvesting-task.vala"
	g_return_if_fail (self != NULL);
#line 937 "rygel-media-export-harvesting-task.c"
	{
		{
			RygelMediaExportDummyContainer* _tmp0_;
			GeeIterator* _tmp1_;
			GeeIterator* _child_it;
#line 236 "rygel-media-export-harvesting-task.vala"
			_child_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = rygel_media_export_harvesting_task_container (self))->children), _g_object_unref0 (_tmp0_), _tmp1_);
#line 236 "rygel-media-export-harvesting-task.vala"
			while (TRUE) {
#line 947 "rygel-media-export-harvesting-task.c"
				char* child;
#line 236 "rygel-media-export-harvesting-task.vala"
				if (!gee_iterator_next (_child_it)) {
#line 236 "rygel-media-export-harvesting-task.vala"
					break;
#line 953 "rygel-media-export-harvesting-task.c"
				}
#line 236 "rygel-media-export-harvesting-task.vala"
				child = (char*) gee_iterator_get (_child_it);
#line 237 "rygel-media-export-harvesting-task.vala"
				rygel_media_export_media_cache_remove_by_id (self->priv->cache, child, &_inner_error_);
#line 959 "rygel-media-export-harvesting-task.c"
				if (_inner_error_ != NULL) {
					_g_free0 (child);
					_g_object_unref0 (_child_it);
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch49_rygel_media_export_database_error;
					}
					_g_free0 (child);
					_g_object_unref0 (_child_it);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (child);
			}
			_g_object_unref0 (_child_it);
		}
	}
	goto __finally49;
	__catch49_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			RygelMediaExportDummyContainer* _tmp2_;
#line 240 "rygel-media-export-harvesting-task.vala"
			g_warning (_ ("Failed to get children of container %s: %s"), ((RygelMediaObject*) (_tmp2_ = rygel_media_export_harvesting_task_container (self)))->id, _error_->message);
#line 987 "rygel-media-export-harvesting-task.c"
			_g_object_unref0 (_tmp2_);
			_g_error_free0 (_error_);
		}
	}
	__finally49:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 247 "rygel-media-export-harvesting-task.vala"
static gboolean rygel_media_export_harvesting_task_on_idle (RygelMediaExportHarvestingTask* self) {
#line 1003 "rygel-media-export-harvesting-task.c"
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 247 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 248 "rygel-media-export-harvesting-task.vala"
	if (g_cancellable_is_cancelled (rygel_state_machine_get_cancellable ((RygelStateMachine*) self))) {
#line 249 "rygel-media-export-harvesting-task.vala"
		g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 1012 "rygel-media-export-harvesting-task.c"
		result = FALSE;
#line 251 "rygel-media-export-harvesting-task.vala"
		return result;
#line 1016 "rygel-media-export-harvesting-task.c"
	}
#line 254 "rygel-media-export-harvesting-task.vala"
	if (gee_collection_get_size ((GeeCollection*) self->priv->files) > 0) {
#line 255 "rygel-media-export-harvesting-task.vala"
		rygel_media_export_harvesting_task_extract_file (self);
#line 1022 "rygel-media-export-harvesting-task.c"
	} else {
#line 256 "rygel-media-export-harvesting-task.vala"
		if (g_queue_get_length (self->priv->containers) > 0) {
#line 257 "rygel-media-export-harvesting-task.vala"
			rygel_media_export_harvesting_task_enumerate_directory (self, NULL, NULL);
#line 1028 "rygel-media-export-harvesting-task.c"
		} else {
#line 260 "rygel-media-export-harvesting-task.vala"
			if (self->priv->flag != NULL) {
#line 1032 "rygel-media-export-harvesting-task.c"
				{
#line 262 "rygel-media-export-harvesting-task.vala"
					rygel_media_export_media_cache_flag_object (self->priv->cache, self->origin, self->priv->flag, &_inner_error_);
#line 1036 "rygel-media-export-harvesting-task.c"
					if (_inner_error_ != NULL) {
						goto __catch50_g_error;
					}
				}
				goto __finally50;
				__catch50_g_error:
				{
					GError * _error_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					{
						_g_error_free0 (_error_);
					}
				}
				__finally50:
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				;
			}
#line 266 "rygel-media-export-harvesting-task.vala"
			g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 1061 "rygel-media-export-harvesting-task.c"
		}
	}
	result = FALSE;
#line 269 "rygel-media-export-harvesting-task.vala"
	return result;
#line 1067 "rygel-media-export-harvesting-task.c"
}


#line 272 "rygel-media-export-harvesting-task.vala"
static void rygel_media_export_harvesting_task_on_extracted_cb (RygelMediaExportHarvestingTask* self, GFile* file, GUPnPDLNAInformation* dlna, const char* mime, guint64 size, guint64 mtime) {
#line 1073 "rygel-media-export-harvesting-task.c"
	GFile* entry;
	gboolean _tmp0_ = FALSE;
	RygelMediaItem* item;
	GFile* _tmp6_;
	GError * _inner_error_ = NULL;
#line 272 "rygel-media-export-harvesting-task.vala"
	g_return_if_fail (self != NULL);
#line 272 "rygel-media-export-harvesting-task.vala"
	g_return_if_fail (file != NULL);
#line 272 "rygel-media-export-harvesting-task.vala"
	g_return_if_fail (mime != NULL);
#line 277 "rygel-media-export-harvesting-task.vala"
	if (g_cancellable_is_cancelled (rygel_state_machine_get_cancellable ((RygelStateMachine*) self))) {
#line 278 "rygel-media-export-harvesting-task.vala"
		g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 1089 "rygel-media-export-harvesting-task.c"
	}
#line 281 "rygel-media-export-harvesting-task.vala"
	entry = rygel_media_export_harvesting_task_file (self);
#line 282 "rygel-media-export-harvesting-task.vala"
	if (entry == NULL) {
#line 282 "rygel-media-export-harvesting-task.vala"
		_tmp0_ = TRUE;
#line 1097 "rygel-media-export-harvesting-task.c"
	} else {
#line 282 "rygel-media-export-harvesting-task.vala"
		_tmp0_ = file != entry;
#line 1101 "rygel-media-export-harvesting-task.c"
	}
#line 282 "rygel-media-export-harvesting-task.vala"
	if (_tmp0_) {
#line 1105 "rygel-media-export-harvesting-task.c"
		_g_object_unref0 (entry);
#line 285 "rygel-media-export-harvesting-task.vala"
		return;
#line 1109 "rygel-media-export-harvesting-task.c"
	}
	item = NULL;
#line 289 "rygel-media-export-harvesting-task.vala"
	if (dlna == NULL) {
#line 1114 "rygel-media-export-harvesting-task.c"
		RygelMediaContainer* _tmp1_;
		RygelMediaItem* _tmp2_;
#line 290 "rygel-media-export-harvesting-task.vala"
		item = (_tmp2_ = (RygelMediaItem*) rygel_media_export_item_new_simple (_tmp1_ = rygel_media_export_harvesting_task_current_parent (self), file, mime, size, mtime), _g_object_unref0 (item), _tmp2_);
#line 1119 "rygel-media-export-harvesting-task.c"
		_g_object_unref0 (_tmp1_);
	} else {
		RygelMediaContainer* _tmp3_;
		RygelMediaItem* _tmp4_;
#line 296 "rygel-media-export-harvesting-task.vala"
		item = (_tmp4_ = (RygelMediaItem*) rygel_media_export_item_create_from_info (_tmp3_ = rygel_media_export_harvesting_task_current_parent (self), file, dlna, mime, size, mtime), _g_object_unref0 (item), _tmp4_);
#line 1126 "rygel-media-export-harvesting-task.c"
		_g_object_unref0 (_tmp3_);
	}
#line 304 "rygel-media-export-harvesting-task.vala"
	if (item != NULL) {
#line 1131 "rygel-media-export-harvesting-task.c"
		RygelMediaContainer* _tmp5_;
#line 305 "rygel-media-export-harvesting-task.vala"
		rygel_media_object_set_parent_ref ((RygelMediaObject*) item, _tmp5_ = rygel_media_export_harvesting_task_current_parent (self));
#line 1135 "rygel-media-export-harvesting-task.c"
		_g_object_unref0 (_tmp5_);
		{
#line 307 "rygel-media-export-harvesting-task.vala"
			rygel_media_export_media_cache_save_item (self->priv->cache, item, &_inner_error_);
#line 1140 "rygel-media-export-harvesting-task.c"
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
		}
		goto __finally51;
		__catch51_g_error:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (_error_);
			}
		}
		__finally51:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (item);
			_g_object_unref0 (entry);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 313 "rygel-media-export-harvesting-task.vala"
	_tmp6_ = (GFile*) gee_queue_poll (self->priv->files);
#line 1166 "rygel-media-export-harvesting-task.c"
	_g_object_unref0 (_tmp6_);
#line 314 "rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_do_update (self);
#line 1170 "rygel-media-export-harvesting-task.c"
	_g_object_unref0 (item);
	_g_object_unref0 (entry);
}


#line 317 "rygel-media-export-harvesting-task.vala"
static void rygel_media_export_harvesting_task_on_extractor_error_cb (RygelMediaExportHarvestingTask* self, GFile* file, GError* _error_) {
#line 1178 "rygel-media-export-harvesting-task.c"
	GFile* entry;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
#line 317 "rygel-media-export-harvesting-task.vala"
	g_return_if_fail (self != NULL);
#line 317 "rygel-media-export-harvesting-task.vala"
	g_return_if_fail (file != NULL);
#line 318 "rygel-media-export-harvesting-task.vala"
	entry = rygel_media_export_harvesting_task_file (self);
#line 319 "rygel-media-export-harvesting-task.vala"
	if (entry == NULL) {
#line 319 "rygel-media-export-harvesting-task.vala"
		_tmp0_ = TRUE;
#line 1192 "rygel-media-export-harvesting-task.c"
	} else {
#line 319 "rygel-media-export-harvesting-task.vala"
		_tmp0_ = file != entry;
#line 1196 "rygel-media-export-harvesting-task.c"
	}
#line 319 "rygel-media-export-harvesting-task.vala"
	if (_tmp0_) {
#line 1200 "rygel-media-export-harvesting-task.c"
		_g_object_unref0 (entry);
#line 322 "rygel-media-export-harvesting-task.vala"
		return;
#line 1204 "rygel-media-export-harvesting-task.c"
	}
#line 325 "rygel-media-export-harvesting-task.vala"
	_tmp1_ = (GFile*) gee_queue_poll (self->priv->files);
#line 1208 "rygel-media-export-harvesting-task.c"
	_g_object_unref0 (_tmp1_);
#line 326 "rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_do_update (self);
#line 1212 "rygel-media-export-harvesting-task.c"
	_g_object_unref0 (entry);
}


/**
     * If all files of a container were processed, notify the container
     * about this and set the updating signal.
     * Reschedule the iteration and extraction
     */
#line 334 "rygel-media-export-harvesting-task.vala"
static void rygel_media_export_harvesting_task_do_update (RygelMediaExportHarvestingTask* self) {
#line 1224 "rygel-media-export-harvesting-task.c"
	gboolean _tmp0_ = FALSE;
#line 334 "rygel-media-export-harvesting-task.vala"
	g_return_if_fail (self != NULL);
#line 335 "rygel-media-export-harvesting-task.vala"
	if (gee_collection_get_size ((GeeCollection*) self->priv->files) == 0) {
#line 336 "rygel-media-export-harvesting-task.vala"
		_tmp0_ = g_queue_get_length (self->priv->containers) != 0;
#line 1232 "rygel-media-export-harvesting-task.c"
	} else {
#line 335 "rygel-media-export-harvesting-task.vala"
		_tmp0_ = FALSE;
#line 1236 "rygel-media-export-harvesting-task.c"
	}
#line 335 "rygel-media-export-harvesting-task.vala"
	if (_tmp0_) {
#line 1240 "rygel-media-export-harvesting-task.c"
		RygelMediaContainer* _tmp1_;
		RygelMediaContainer* _tmp2_;
#line 337 "rygel-media-export-harvesting-task.vala"
		rygel_media_container_updated (_tmp1_ = rygel_media_export_harvesting_task_current_parent (self));
#line 1245 "rygel-media-export-harvesting-task.c"
		_g_object_unref0 (_tmp1_);
#line 338 "rygel-media-export-harvesting-task.vala"
		_tmp2_ = (RygelMediaContainer*) g_queue_pop_head (self->priv->containers);
#line 1249 "rygel-media-export-harvesting-task.c"
		_g_object_unref0 (_tmp2_);
	}
#line 341 "rygel-media-export-harvesting-task.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_media_export_harvesting_task_on_idle_gsource_func, g_object_ref (self), g_object_unref);
#line 1254 "rygel-media-export-harvesting-task.c"
}


#line 344 "rygel-media-export-harvesting-task.vala"
static inline void rygel_media_export_harvesting_task_extract_file (RygelMediaExportHarvestingTask* self) {
#line 1260 "rygel-media-export-harvesting-task.c"
	GFile* _tmp0_;
#line 344 "rygel-media-export-harvesting-task.vala"
	g_return_if_fail (self != NULL);
#line 345 "rygel-media-export-harvesting-task.vala"
	rygel_media_export_metadata_extractor_extract (self->priv->extractor, _tmp0_ = rygel_media_export_harvesting_task_file (self));
#line 1266 "rygel-media-export-harvesting-task.c"
	_g_object_unref0 (_tmp0_);
}


#line 348 "rygel-media-export-harvesting-task.vala"
static inline RygelMediaExportDummyContainer* rygel_media_export_harvesting_task_container (RygelMediaExportHarvestingTask* self) {
#line 1273 "rygel-media-export-harvesting-task.c"
	RygelMediaExportDummyContainer* result = NULL;
	RygelMediaContainer* _tmp0_;
#line 348 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1278 "rygel-media-export-harvesting-task.c"
	result = _g_object_ref0 ((_tmp0_ = (RygelMediaContainer*) g_queue_peek_head (self->priv->containers), RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER (_tmp0_) ? ((RygelMediaExportDummyContainer*) _tmp0_) : NULL));
#line 349 "rygel-media-export-harvesting-task.vala"
	return result;
#line 1282 "rygel-media-export-harvesting-task.c"
}


#line 352 "rygel-media-export-harvesting-task.vala"
static inline GFile* rygel_media_export_harvesting_task_file (RygelMediaExportHarvestingTask* self) {
#line 1288 "rygel-media-export-harvesting-task.c"
	GFile* result = NULL;
#line 352 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1292 "rygel-media-export-harvesting-task.c"
	result = (GFile*) gee_queue_peek (self->priv->files);
#line 353 "rygel-media-export-harvesting-task.vala"
	return result;
#line 1296 "rygel-media-export-harvesting-task.c"
}


#line 356 "rygel-media-export-harvesting-task.vala"
static inline RygelMediaContainer* rygel_media_export_harvesting_task_current_parent (RygelMediaExportHarvestingTask* self) {
#line 1302 "rygel-media-export-harvesting-task.c"
	RygelMediaContainer* result = NULL;
#line 356 "rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1306 "rygel-media-export-harvesting-task.c"
	result = _g_object_ref0 ((RygelMediaContainer*) g_queue_peek_head (self->priv->containers));
#line 357 "rygel-media-export-harvesting-task.vala"
	return result;
#line 1310 "rygel-media-export-harvesting-task.c"
}


static GCancellable* rygel_media_export_harvesting_task_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelMediaExportHarvestingTask* self;
	self = (RygelMediaExportHarvestingTask*) base;
	result = self->priv->_cancellable;
#line 36 "rygel-media-export-harvesting-task.vala"
	return result;
#line 1321 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelMediaExportHarvestingTask* self;
	GCancellable* _tmp0_;
	self = (RygelMediaExportHarvestingTask*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_media_export_harvesting_task_class_init (RygelMediaExportHarvestingTaskClass * klass) {
	rygel_media_export_harvesting_task_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvestingTaskPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_media_export_harvesting_task_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_media_export_harvesting_task_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvesting_task_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE, "cancellable");
}


static void rygel_media_export_harvesting_task_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_media_export_harvesting_task_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_media_export_harvesting_task_real_run;
	iface->run_finish = rygel_media_export_harvesting_task_real_run_finish;
	iface->get_cancellable = rygel_media_export_harvesting_task_real_get_cancellable;
	iface->set_cancellable = rygel_media_export_harvesting_task_real_set_cancellable;
}


static void rygel_media_export_harvesting_task_instance_init (RygelMediaExportHarvestingTask * self) {
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_PRIVATE (self);
}


static void rygel_media_export_harvesting_task_finalize (GObject* obj) {
	RygelMediaExportHarvestingTask * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTING_TASK (obj);
	_g_object_unref0 (self->origin);
	_g_object_unref0 (self->priv->extractor);
	_g_object_unref0 (self->priv->cache);
	_g_queue_free0 (self->priv->containers);
	_g_object_unref0 (self->priv->files);
	_g_object_unref0 (self->priv->monitor);
	_g_regex_unref0 (self->priv->file_filter);
	_g_free0 (self->priv->flag);
	_g_object_unref0 (self->priv->parent);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_media_export_harvesting_task_parent_class)->finalize (obj);
}


GType rygel_media_export_harvesting_task_get_type (void) {
	static volatile gsize rygel_media_export_harvesting_task_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvesting_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvestingTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvesting_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvestingTask), 0, (GInstanceInitFunc) rygel_media_export_harvesting_task_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_media_export_harvesting_task_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_export_harvesting_task_type_id;
		rygel_media_export_harvesting_task_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvestingTask", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_media_export_harvesting_task_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_media_export_harvesting_task_type_id__volatile, rygel_media_export_harvesting_task_type_id);
	}
	return rygel_media_export_harvesting_task_type_id__volatile;
}


static void rygel_media_export_harvesting_task_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvestingTask * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTING_TASK (object);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_media_export_harvesting_task_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvestingTask * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTING_TASK (object);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




