/* rygel-media-export-harvester.c generated by valac 0.9.6, the Vala compiler
 * generated from rygel-media-export-harvester.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
typedef struct _RygelMediaExportHarvesterPrivate RygelMediaExportHarvesterPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

struct _RygelMediaExportHarvester {
	GObject parent_instance;
	RygelMediaExportHarvesterPrivate * priv;
};

struct _RygelMediaExportHarvesterClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvesterPrivate {
	GeeHashMap* tasks;
	RygelMediaExportMetadataExtractor* extractor;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GRegex* file_filter;
	GCancellable* cancellable;
};

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()

static gpointer rygel_media_export_harvester_parent_class = NULL;

GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTER_DUMMY_PROPERTY
};
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_construct (GType object_type, GCancellable* cancellable);
static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event);
static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void rygel_media_export_harvester_create_file_filter (RygelMediaExportHarvester* self);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent, const char* flag);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const char* flag);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const char* flag);
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine);
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
char* rygel_media_export_media_cache_get_id (GFile* file);
GQuark rygel_media_export_database_error_quark (void);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const char* object_id, GError** error);
GQuark rygel_media_export_media_cache_error_quark (void);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
static void rygel_media_export_harvester_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



/**
     * Create a new instance of the meta-data extraction manager.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 134 "rygel-media-export-harvester.vala"
static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
#line 181 "rygel-media-export-harvester.c"
	rygel_media_export_harvester_on_file_changed (self, file, other_file, event_type);
}


#line 36 "rygel-media-export-harvester.vala"
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable) {
#line 188 "rygel-media-export-harvester.c"
	RygelMediaExportHarvester * self;
	GCancellable* _tmp0_;
	RygelMediaExportMetadataExtractor* _tmp1_;
	RygelMediaExportRecursiveFileMonitor* _tmp2_;
	GeeHashMap* _tmp3_;
#line 36 "rygel-media-export-harvester.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 36 "rygel-media-export-harvester.vala"
	self = (RygelMediaExportHarvester*) g_object_new (object_type, NULL);
#line 37 "rygel-media-export-harvester.vala"
	self->priv->cancellable = (_tmp0_ = _g_object_ref0 (cancellable), _g_object_unref0 (self->priv->cancellable), _tmp0_);
#line 38 "rygel-media-export-harvester.vala"
	self->priv->extractor = (_tmp1_ = rygel_media_export_metadata_extractor_new (), _g_object_unref0 (self->priv->extractor), _tmp1_);
#line 40 "rygel-media-export-harvester.vala"
	self->priv->monitor = (_tmp2_ = rygel_media_export_recursive_file_monitor_new (cancellable), _g_object_unref0 (self->priv->monitor), _tmp2_);
#line 41 "rygel-media-export-harvester.vala"
	g_signal_connect_object (self->priv->monitor, "changed", (GCallback) _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed, self, 0);
#line 43 "rygel-media-export-harvester.vala"
	self->priv->tasks = (_tmp3_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_file_hash, g_file_equal, NULL), _g_object_unref0 (self->priv->tasks), _tmp3_);
#line 44 "rygel-media-export-harvester.vala"
	rygel_media_export_harvester_create_file_filter (self);
#line 210 "rygel-media-export-harvester.c"
	return self;
}


#line 36 "rygel-media-export-harvester.vala"
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable) {
#line 36 "rygel-media-export-harvester.vala"
	return rygel_media_export_harvester_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, cancellable);
#line 219 "rygel-media-export-harvester.c"
}


/**
     * Put a file on queue for meta-data extraction
     *
     * @param file the file to investigate
     * @param parent container of the filer to be harvested
     * @param flag optional flag for the container to set in the database
     */
#line 98 "rygel-media-export-harvester.vala"
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 232 "rygel-media-export-harvester.c"
	rygel_media_export_harvester_on_file_harvested (self, _sender);
}


#line 54 "rygel-media-export-harvester.vala"
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent, const char* flag) {
#line 239 "rygel-media-export-harvester.c"
	RygelMediaExportHarvestingTask* task;
#line 54 "rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 54 "rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 54 "rygel-media-export-harvester.vala"
	g_return_if_fail (parent != NULL);
#line 57 "rygel-media-export-harvester.vala"
	if (self->priv->extractor == NULL) {
#line 58 "rygel-media-export-harvester.vala"
		g_warning ("rygel-media-export-harvester.vala:58: %s", _ ("No Metadata extractor available. Will not crawl"));
#line 60 "rygel-media-export-harvester.vala"
		return;
#line 253 "rygel-media-export-harvester.c"
	}
#line 64 "rygel-media-export-harvester.vala"
	rygel_media_export_harvester_cancel (self, file);
#line 66 "rygel-media-export-harvester.vala"
	task = rygel_media_export_harvesting_task_new (self->priv->extractor, self->priv->monitor, self->priv->file_filter, file, parent, flag);
#line 72 "rygel-media-export-harvester.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) task, self->priv->cancellable);
#line 73 "rygel-media-export-harvester.vala"
	g_signal_connect_object ((RygelStateMachine*) task, "completed", (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self, 0);
#line 74 "rygel-media-export-harvester.vala"
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->tasks, file, task);
#line 75 "rygel-media-export-harvester.vala"
	rygel_state_machine_run ((RygelStateMachine*) task, NULL, NULL);
#line 267 "rygel-media-export-harvester.c"
	_g_object_unref0 (task);
}


/**
     * Cancel a running meta-data extraction run
     *
     * @param file file cancel the current run for
     */
#line 83 "rygel-media-export-harvester.vala"
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file) {
#line 83 "rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 83 "rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 84 "rygel-media-export-harvester.vala"
	if (gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->tasks, file)) {
#line 285 "rygel-media-export-harvester.c"
		RygelMediaExportHarvestingTask* task;
		guint _tmp0_;
		task = (RygelMediaExportHarvestingTask*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->tasks, file);
#line 86 "rygel-media-export-harvester.vala"
		g_signal_parse_name ("completed", RYGEL_TYPE_STATE_MACHINE, &_tmp0_, NULL, FALSE);
#line 86 "rygel-media-export-harvester.vala"
		g_signal_handlers_disconnect_matched ((RygelStateMachine*) task, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self);
#line 87 "rygel-media-export-harvester.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) self->priv->tasks, file, NULL);
#line 88 "rygel-media-export-harvester.vala"
		rygel_media_export_harvesting_task_cancel (task);
#line 297 "rygel-media-export-harvester.c"
		_g_object_unref0 (task);
	}
}


/**
     * Callback for finished harvester.
     *
     * Updates book-keeping hash.
     * @param state_machine HarvestingTask sending the event
     */
#line 98 "rygel-media-export-harvester.vala"
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine) {
#line 311 "rygel-media-export-harvester.c"
	RygelStateMachine* _tmp0_;
	RygelMediaExportHarvestingTask* task;
	GFile* file;
	char* _tmp1_;
#line 98 "rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 98 "rygel-media-export-harvester.vala"
	g_return_if_fail (state_machine != NULL);
#line 99 "rygel-media-export-harvester.vala"
	task = _g_object_ref0 ((_tmp0_ = state_machine, RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK (_tmp0_) ? ((RygelMediaExportHarvestingTask*) _tmp0_) : NULL));
#line 100 "rygel-media-export-harvester.vala"
	file = _g_object_ref0 (task->origin);
#line 101 "rygel-media-export-harvester.vala"
	g_message (_ ("'%s' harvested"), _tmp1_ = g_file_get_uri (file));
#line 326 "rygel-media-export-harvester.c"
	_g_free0 (_tmp1_);
#line 103 "rygel-media-export-harvester.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->tasks, file, NULL);
#line 330 "rygel-media-export-harvester.c"
	_g_object_unref0 (file);
	_g_object_unref0 (task);
}


/**
     * Construct positive filter from config
     *
     * Takes a list of file extensions from config, escapes them and builds a
     * regular expression to match against the files encountered.
     */
static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


#line 112 "rygel-media-export-harvester.vala"
static void rygel_media_export_harvester_create_file_filter (RygelMediaExportHarvester* self) {
#line 354 "rygel-media-export-harvester.c"
	GError * _inner_error_ = NULL;
#line 112 "rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 358 "rygel-media-export-harvester.c"
	{
		RygelMetaConfig* config;
		GeeArrayList* extensions;
		gint escaped_extensions_length1;
		gint _escaped_extensions_size_;
		char** _tmp0_;
		char** escaped_extensions;
		char* list;
		char* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
#line 114 "rygel-media-export-harvester.vala"
		config = rygel_meta_config_get_default ();
#line 115 "rygel-media-export-harvester.vala"
		extensions = rygel_configuration_get_string_list ((RygelConfiguration*) config, "MediaExport", "include-filter", &_inner_error_);
#line 375 "rygel-media-export-harvester.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (config);
			goto __catch40_g_error;
		}
		escaped_extensions = (_tmp0_ = g_new0 (char*, 0 + 1), escaped_extensions_length1 = 0, _escaped_extensions_size_ = escaped_extensions_length1, _tmp0_);
		{
			GeeIterator* _extension_it;
#line 120 "rygel-media-export-harvester.vala"
			_extension_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) extensions);
#line 120 "rygel-media-export-harvester.vala"
			while (TRUE) {
#line 387 "rygel-media-export-harvester.c"
				char* extension;
#line 120 "rygel-media-export-harvester.vala"
				if (!gee_iterator_next (_extension_it)) {
#line 120 "rygel-media-export-harvester.vala"
					break;
#line 393 "rygel-media-export-harvester.c"
				}
#line 120 "rygel-media-export-harvester.vala"
				extension = (char*) gee_iterator_get (_extension_it);
#line 121 "rygel-media-export-harvester.vala"
				_vala_array_add1 (&escaped_extensions, &escaped_extensions_length1, &_escaped_extensions_size_, g_regex_escape_string (extension, -1));
#line 399 "rygel-media-export-harvester.c"
				_g_free0 (extension);
			}
			_g_object_unref0 (_extension_it);
		}
#line 124 "rygel-media-export-harvester.vala"
		list = g_strjoinv ("|", escaped_extensions);
#line 125 "rygel-media-export-harvester.vala"
		_tmp3_ = (_tmp2_ = g_regex_new (_tmp1_ = g_strdup_printf ("(%s)$", list), G_REGEX_CASELESS | G_REGEX_OPTIMIZE, 0, &_inner_error_), _g_free0 (_tmp1_), _tmp2_);
#line 408 "rygel-media-export-harvester.c"
		if (_inner_error_ != NULL) {
			_g_free0 (list);
			escaped_extensions = (_vala_array_free (escaped_extensions, escaped_extensions_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (extensions);
			_g_object_unref0 (config);
			goto __catch40_g_error;
		}
#line 125 "rygel-media-export-harvester.vala"
		self->priv->file_filter = (_tmp4_ = _tmp3_, _g_regex_unref0 (self->priv->file_filter), _tmp4_);
#line 418 "rygel-media-export-harvester.c"
		_g_free0 (list);
		escaped_extensions = (_vala_array_free (escaped_extensions, escaped_extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (extensions);
		_g_object_unref0 (config);
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			GRegex* _tmp5_;
#line 130 "rygel-media-export-harvester.vala"
			self->priv->file_filter = (_tmp5_ = NULL, _g_regex_unref0 (self->priv->file_filter), _tmp5_);
#line 434 "rygel-media-export-harvester.c"
			_g_error_free0 (_error_);
		}
	}
	__finally40:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 134 "rygel-media-export-harvester.vala"
static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event) {
#line 449 "rygel-media-export-harvester.c"
	GError * _inner_error_ = NULL;
#line 134 "rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 134 "rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 455 "rygel-media-export-harvester.c"
	{
		RygelMediaExportMediaCache* cache;
#line 138 "rygel-media-export-harvester.vala"
		cache = rygel_media_export_media_cache_get_default (&_inner_error_);
#line 460 "rygel-media-export-harvester.c"
		if (_inner_error_ != NULL) {
			goto __catch41_g_error;
		}
#line 139 "rygel-media-export-harvester.vala"
		switch (event) {
#line 466 "rygel-media-export-harvester.c"
			case G_FILE_MONITOR_EVENT_CREATED:
			case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
			{
				char* _tmp0_;
				GFile* _tmp1_;
				char* _tmp2_;
				char* id;
#line 142 "rygel-media-export-harvester.vala"
				g_debug (_ ("Trying to harvest %s because of %d"), _tmp0_ = g_file_get_uri (file), event);
#line 476 "rygel-media-export-harvester.c"
				_g_free0 (_tmp0_);
#line 145 "rygel-media-export-harvester.vala"
				id = (_tmp2_ = rygel_media_export_media_cache_get_id (_tmp1_ = g_file_get_parent (file)), _g_object_unref0 (_tmp1_), _tmp2_);
#line 480 "rygel-media-export-harvester.c"
				{
					RygelMediaObject* _tmp3_;
					RygelMediaObject* _tmp4_;
					RygelMediaContainer* parent_container;
#line 147 "rygel-media-export-harvester.vala"
					_tmp3_ = rygel_media_export_media_cache_get_object (cache, id, &_inner_error_);
#line 487 "rygel-media-export-harvester.c"
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
							goto __catch42_rygel_media_export_database_error;
						}
						_g_free0 (id);
						_g_object_unref0 (cache);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
#line 147 "rygel-media-export-harvester.vala"
					parent_container = (_tmp4_ = _tmp3_, RYGEL_IS_MEDIA_CONTAINER (_tmp4_) ? ((RygelMediaContainer*) _tmp4_) : NULL);
#line 149 "rygel-media-export-harvester.vala"
					g_assert (parent_container != NULL);
#line 151 "rygel-media-export-harvester.vala"
					rygel_media_export_harvester_schedule (self, file, parent_container, NULL);
#line 504 "rygel-media-export-harvester.c"
					_g_object_unref0 (parent_container);
				}
				goto __finally42;
				__catch42_rygel_media_export_database_error:
				{
					GError * _error_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					{
#line 153 "rygel-media-export-harvester.vala"
						g_warning (_ ("Error fetching object '%s' from database: %s"), id, _error_->message);
#line 516 "rygel-media-export-harvester.c"
						_g_error_free0 (_error_);
					}
				}
				__finally42:
				if (_inner_error_ != NULL) {
					_g_free0 (id);
					_g_object_unref0 (cache);
					goto __catch41_g_error;
				}
				_g_free0 (id);
#line 157 "rygel-media-export-harvester.vala"
				break;
#line 529 "rygel-media-export-harvester.c"
			}
			case G_FILE_MONITOR_EVENT_DELETED:
			{
#line 159 "rygel-media-export-harvester.vala"
				rygel_media_export_harvester_cancel (self, file);
#line 535 "rygel-media-export-harvester.c"
				{
					char* id;
					RygelMediaObject* obj;
#line 164 "rygel-media-export-harvester.vala"
					id = rygel_media_export_media_cache_get_id (file);
#line 165 "rygel-media-export-harvester.vala"
					obj = rygel_media_export_media_cache_get_object (cache, id, &_inner_error_);
#line 543 "rygel-media-export-harvester.c"
					if (_inner_error_ != NULL) {
						_g_free0 (id);
						goto __catch43_g_error;
					}
#line 169 "rygel-media-export-harvester.vala"
					if (obj != NULL) {
#line 170 "rygel-media-export-harvester.vala"
						rygel_media_export_media_cache_remove_object (cache, obj, &_inner_error_);
#line 552 "rygel-media-export-harvester.c"
						if (_inner_error_ != NULL) {
							_g_object_unref0 (obj);
							_g_free0 (id);
							goto __catch43_g_error;
						}
#line 171 "rygel-media-export-harvester.vala"
						if (obj->parent != NULL) {
#line 172 "rygel-media-export-harvester.vala"
							rygel_media_container_updated (obj->parent);
#line 562 "rygel-media-export-harvester.c"
						}
					}
					_g_object_unref0 (obj);
					_g_free0 (id);
				}
				goto __finally43;
				__catch43_g_error:
				{
					GError * _error_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					{
#line 176 "rygel-media-export-harvester.vala"
						g_warning (_ ("Error removing object from database: %s"), _error_->message);
#line 577 "rygel-media-export-harvester.c"
						_g_error_free0 (_error_);
					}
				}
				__finally43:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (cache);
					goto __catch41_g_error;
				}
#line 179 "rygel-media-export-harvester.vala"
				break;
#line 588 "rygel-media-export-harvester.c"
			}
			default:
			{
#line 181 "rygel-media-export-harvester.vala"
				break;
#line 594 "rygel-media-export-harvester.c"
			}
		}
		_g_object_unref0 (cache);
	}
	goto __finally41;
	__catch41_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (_error_);
		}
	}
	__finally41:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_harvester_class_init (RygelMediaExportHarvesterClass * klass) {
	rygel_media_export_harvester_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvesterPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvester_finalize;
}


static void rygel_media_export_harvester_instance_init (RygelMediaExportHarvester * self) {
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE (self);
}


static void rygel_media_export_harvester_finalize (GObject* obj) {
	RygelMediaExportHarvester * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTER (obj);
	_g_object_unref0 (self->priv->tasks);
	_g_object_unref0 (self->priv->extractor);
	_g_object_unref0 (self->priv->monitor);
	_g_regex_unref0 (self->priv->file_filter);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (rygel_media_export_harvester_parent_class)->finalize (obj);
}


/**
 * This class takes care of the book-keeping of running and finished
 * extraction tasks running within the media-export plugin
 */
GType rygel_media_export_harvester_get_type (void) {
	static volatile gsize rygel_media_export_harvester_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvester), 0, (GInstanceInitFunc) rygel_media_export_harvester_instance_init, NULL };
		GType rygel_media_export_harvester_type_id;
		rygel_media_export_harvester_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvester", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_harvester_type_id__volatile, rygel_media_export_harvester_type_id);
	}
	return rygel_media_export_harvester_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




