/* rygel-media-art-store.c generated by valac 0.9.5, the Vala compiler
 * generated from rygel-media-art-store.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <gst/gst.h>


#define RYGEL_TYPE_MEDIA_ART_STORE (rygel_media_art_store_get_type ())
#define RYGEL_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore))
#define RYGEL_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))
#define RYGEL_IS_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_IS_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_MEDIA_ART_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))

typedef struct _RygelMediaArtStore RygelMediaArtStore;
typedef struct _RygelMediaArtStoreClass RygelMediaArtStoreClass;
typedef struct _RygelMediaArtStorePrivate RygelMediaArtStorePrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_ALBUM_ART (rygel_album_art_get_type ())
#define RYGEL_ALBUM_ART(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ALBUM_ART, RygelAlbumArt))
#define RYGEL_ALBUM_ART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ALBUM_ART, RygelAlbumArtClass))
#define RYGEL_IS_ALBUM_ART(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ALBUM_ART))
#define RYGEL_IS_ALBUM_ART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ALBUM_ART))
#define RYGEL_ALBUM_ART_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ALBUM_ART, RygelAlbumArtClass))

typedef struct _RygelAlbumArt RygelAlbumArt;
typedef struct _RygelAlbumArtClass RygelAlbumArtClass;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

typedef enum  {
	MEDIA_ART_STORE_ERROR_NO_DIR,
	MEDIA_ART_STORE_ERROR_NO_MEDIA_ART
} MediaArtStoreError;
#define MEDIA_ART_STORE_ERROR media_art_store_error_quark ()
struct _RygelMediaArtStore {
	GObject parent_instance;
	RygelMediaArtStorePrivate * priv;
};

struct _RygelMediaArtStoreClass {
	GObjectClass parent_class;
};

struct _RygelMediaArtStorePrivate {
	GRegex* char_remove_regex;
	GRegex* char_convert_regex;
	GRegex* space_compress_regex;
	GRegex** block_regexes;
	gint block_regexes_length1;
	gint _block_regexes_size_;
	char* directory;
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	char* mime_type;
	char* uri;
	char* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* author;
	char* album;
	char* date;
	char* genre;
	char* mime_type;
	char* dlna_profile;
	gint64 size;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
	gint track_number;
	gint width;
	gint height;
	gint pixel_width;
	gint pixel_height;
	gint color_depth;
	GeeArrayList* thumbnails;
	GeeArrayList* subtitles;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*should_stream) (RygelMediaItem* self);
};


static RygelMediaArtStore* rygel_media_art_store_media_art_store;
static RygelMediaArtStore* rygel_media_art_store_media_art_store = NULL;
static gboolean rygel_media_art_store_first_time;
static gboolean rygel_media_art_store_first_time = TRUE;
static gpointer rygel_media_art_store_parent_class = NULL;

GQuark media_art_store_error_quark (void);
GType rygel_media_art_store_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ART_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStorePrivate))
enum  {
	RYGEL_MEDIA_ART_STORE_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_ART_STORE_PLACEHOLDER_HASH "7215ee9c7d9dc229d2921a40e899ec5f"
#define RYGEL_MEDIA_ART_STORE_invalid_chars "()[]<>{}_!@#$^&*+=|\\/\"'?~"
#define RYGEL_MEDIA_ART_STORE_convert_chars "\t"
#define RYGEL_MEDIA_ART_STORE_block_pattern "%s[^%s]*%s"
static RygelMediaArtStore* rygel_media_art_store_new (GError** error);
static RygelMediaArtStore* rygel_media_art_store_construct (GType object_type, GError** error);
RygelMediaArtStore* rygel_media_art_store_get_default (void);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GFile* rygel_media_art_store_get_media_art_file (RygelMediaArtStore* self, const char* type, RygelMediaItem* item, gboolean simple);
RygelAlbumArt* rygel_album_art_new (void);
RygelAlbumArt* rygel_album_art_construct (GType object_type);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_album_art_get_type (void) G_GNUC_CONST;
RygelThumbnail* rygel_media_art_store_find_media_art (RygelMediaArtStore* self, RygelMediaItem* item, gboolean simple, GError** error);
RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMediaItem* item, GError** error);
static char* rygel_media_art_store_get_simple_hash (RygelMediaArtStore* self, const char* type, RygelMediaItem* item);
static char* rygel_media_art_store_get_hash (RygelMediaArtStore* self, const char* type, RygelMediaItem* item);
static void _vala_array_add1 (GRegex*** array, int* length, int* size, GRegex* value);
static char* rygel_media_art_store_normalize_and_hash (RygelMediaArtStore* self, const char* input, gboolean utf8_only);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
const char* rygel_media_object_get_title (RygelMediaObject* self);
static char* rygel_media_art_store_strip_invalid_entities (RygelMediaArtStore* self, const char* original);
static void rygel_media_art_store_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const char* RYGEL_MEDIA_ART_STORE_blocks[4] = {"()", "{}", "[]", "<>"};


GQuark media_art_store_error_quark (void) {
	return g_quark_from_static_string ("media_art_store_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 43 "rygel-media-art-store.vala"
RygelMediaArtStore* rygel_media_art_store_get_default (void) {
#line 284 "rygel-media-art-store.c"
	RygelMediaArtStore* result = NULL;
	GError * _inner_error_;
	_inner_error_ = NULL;
#line 44 "rygel-media-art-store.vala"
	if (rygel_media_art_store_first_time) {
#line 290 "rygel-media-art-store.c"
		{
			RygelMediaArtStore* _tmp0_;
			RygelMediaArtStore* _tmp1_;
#line 46 "rygel-media-art-store.vala"
			_tmp0_ = rygel_media_art_store_new (&_inner_error_);
#line 296 "rygel-media-art-store.c"
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == MEDIA_ART_STORE_ERROR) {
					goto __catch44_media_art_store_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
#line 46 "rygel-media-art-store.vala"
			rygel_media_art_store_media_art_store = (_tmp1_ = _tmp0_, _g_object_unref0 (rygel_media_art_store_media_art_store), _tmp1_);
#line 307 "rygel-media-art-store.c"
		}
		goto __finally44;
		__catch44_media_art_store_error:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			{
#line 48 "rygel-media-art-store.vala"
				g_warning ("rygel-media-art-store.vala:48: No media art available: %s", _error_->message);
#line 318 "rygel-media-art-store.c"
				_g_error_free0 (_error_);
			}
		}
		__finally44:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 52 "rygel-media-art-store.vala"
	rygel_media_art_store_first_time = FALSE;
#line 331 "rygel-media-art-store.c"
	result = _g_object_ref0 (rygel_media_art_store_media_art_store);
#line 54 "rygel-media-art-store.vala"
	return result;
#line 335 "rygel-media-art-store.c"
}


#line 57 "rygel-media-art-store.vala"
RygelThumbnail* rygel_media_art_store_find_media_art (RygelMediaArtStore* self, RygelMediaItem* item, gboolean simple, GError** error) {
#line 341 "rygel-media-art-store.c"
	RygelThumbnail* result = NULL;
	GError * _inner_error_;
	char** _tmp1_;
	gint _types_size_;
	gint types_length1;
	char** _tmp0_ = NULL;
	char** types;
	GFile* file;
	GFileInfo* info;
	RygelAlbumArt* thumb;
	char* _tmp4_;
#line 57 "rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 57 "rygel-media-art-store.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 357 "rygel-media-art-store.c"
	_inner_error_ = NULL;
	types = (_tmp1_ = (_tmp0_ = g_new0 (char*, 5 + 1), _tmp0_[0] = g_strdup ("track"), _tmp0_[1] = g_strdup ("album"), _tmp0_[2] = g_strdup ("artist"), _tmp0_[3] = g_strdup ("podcast"), _tmp0_[4] = g_strdup ("radio"), _tmp0_), types_length1 = 5, _types_size_ = types_length1, _tmp1_);
#line 60 "rygel-media-art-store.vala"
	file = NULL;
#line 362 "rygel-media-art-store.c"
	{
		char** type_collection;
		int type_collection_length1;
		int type_it;
#line 62 "rygel-media-art-store.vala"
		type_collection = types;
#line 369 "rygel-media-art-store.c"
		type_collection_length1 = types_length1;
		for (type_it = 0; type_it < types_length1; type_it = type_it + 1) {
			char* type;
			type = g_strdup (type_collection[type_it]);
			{
				GFile* _tmp2_;
#line 63 "rygel-media-art-store.vala"
				file = (_tmp2_ = rygel_media_art_store_get_media_art_file (self, type, item, simple), _g_object_unref0 (file), _tmp2_);
#line 64 "rygel-media-art-store.vala"
				if (g_file_query_exists (file, NULL)) {
#line 380 "rygel-media-art-store.c"
					_g_free0 (type);
#line 65 "rygel-media-art-store.vala"
					break;
#line 384 "rygel-media-art-store.c"
				} else {
					GFile* _tmp3_;
#line 67 "rygel-media-art-store.vala"
					file = (_tmp3_ = NULL, _g_object_unref0 (file), _tmp3_);
#line 389 "rygel-media-art-store.c"
				}
				_g_free0 (type);
			}
		}
	}
#line 71 "rygel-media-art-store.vala"
	if (file == NULL) {
#line 397 "rygel-media-art-store.c"
		result = NULL;
		_g_object_unref0 (file);
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
#line 72 "rygel-media-art-store.vala"
		return result;
#line 403 "rygel-media-art-store.c"
	}
#line 75 "rygel-media-art-store.vala"
	info = g_file_query_info (file, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 407 "rygel-media-art-store.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
#line 79 "rygel-media-art-store.vala"
	if (!g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
#line 416 "rygel-media-art-store.c"
		result = NULL;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
#line 80 "rygel-media-art-store.vala"
		return result;
#line 423 "rygel-media-art-store.c"
	}
#line 83 "rygel-media-art-store.vala"
	thumb = rygel_album_art_new ();
#line 84 "rygel-media-art-store.vala"
	((RygelIconInfo*) thumb)->uri = (_tmp4_ = g_file_get_uri (file), _g_free0 (((RygelIconInfo*) thumb)->uri), _tmp4_);
#line 85 "rygel-media-art-store.vala"
	((RygelIconInfo*) thumb)->size = (gint64) g_file_info_get_size (info);
#line 431 "rygel-media-art-store.c"
	result = (RygelThumbnail*) thumb;
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
#line 87 "rygel-media-art-store.vala"
	return result;
#line 438 "rygel-media-art-store.c"
}


#line 90 "rygel-media-art-store.vala"
RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMediaItem* item, GError** error) {
#line 444 "rygel-media-art-store.c"
	RygelThumbnail* result = NULL;
	GError * _inner_error_;
	RygelThumbnail* thumb;
#line 90 "rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 90 "rygel-media-art-store.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 452 "rygel-media-art-store.c"
	_inner_error_ = NULL;
#line 91 "rygel-media-art-store.vala"
	thumb = rygel_media_art_store_find_media_art (self, item, FALSE, &_inner_error_);
#line 456 "rygel-media-art-store.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 92 "rygel-media-art-store.vala"
	if (thumb == NULL) {
#line 463 "rygel-media-art-store.c"
		RygelThumbnail* _tmp0_;
		RygelThumbnail* _tmp1_;
#line 93 "rygel-media-art-store.vala"
		_tmp0_ = rygel_media_art_store_find_media_art (self, item, TRUE, &_inner_error_);
#line 468 "rygel-media-art-store.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_rygel_icon_info_unref0 (thumb);
			return NULL;
		}
#line 93 "rygel-media-art-store.vala"
		thumb = (_tmp1_ = _tmp0_, _rygel_icon_info_unref0 (thumb), _tmp1_);
#line 476 "rygel-media-art-store.c"
	}
	result = thumb;
#line 96 "rygel-media-art-store.vala"
	return result;
#line 481 "rygel-media-art-store.c"
}


#line 99 "rygel-media-art-store.vala"
GFile* rygel_media_art_store_get_media_art_file (RygelMediaArtStore* self, const char* type, RygelMediaItem* item, gboolean simple) {
#line 487 "rygel-media-art-store.c"
	GFile* result = NULL;
	char* hash;
	char* suffix;
	char* file_path;
	char* path;
#line 99 "rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 99 "rygel-media-art-store.vala"
	g_return_val_if_fail (type != NULL, NULL);
#line 99 "rygel-media-art-store.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 499 "rygel-media-art-store.c"
	hash = NULL;
	suffix = NULL;
#line 105 "rygel-media-art-store.vala"
	if (simple) {
#line 504 "rygel-media-art-store.c"
		char* _tmp0_;
		char* _tmp1_;
#line 106 "rygel-media-art-store.vala"
		hash = (_tmp0_ = rygel_media_art_store_get_simple_hash (self, type, item), _g_free0 (hash), _tmp0_);
#line 107 "rygel-media-art-store.vala"
		suffix = (_tmp1_ = g_strdup ("jpg"), _g_free0 (suffix), _tmp1_);
#line 511 "rygel-media-art-store.c"
	} else {
		char* _tmp2_;
		char* _tmp3_;
#line 109 "rygel-media-art-store.vala"
		hash = (_tmp2_ = rygel_media_art_store_get_hash (self, type, item), _g_free0 (hash), _tmp2_);
#line 110 "rygel-media-art-store.vala"
		suffix = (_tmp3_ = g_strdup ("jpeg"), _g_free0 (suffix), _tmp3_);
#line 519 "rygel-media-art-store.c"
	}
#line 112 "rygel-media-art-store.vala"
	file_path = g_strdup_printf ("%s-%s.%s", type, hash, suffix);
#line 114 "rygel-media-art-store.vala"
	path = g_build_filename (self->priv->directory, file_path, NULL);
#line 525 "rygel-media-art-store.c"
	result = g_file_new_for_path (path);
	_g_free0 (path);
	_g_free0 (file_path);
	_g_free0 (suffix);
	_g_free0 (hash);
#line 116 "rygel-media-art-store.vala"
	return result;
#line 533 "rygel-media-art-store.c"
}


static void _vala_array_add1 (GRegex*** array, int* length, int* size, GRegex* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GRegex*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


#line 119 "rygel-media-art-store.vala"
static RygelMediaArtStore* rygel_media_art_store_construct (GType object_type, GError** error) {
#line 549 "rygel-media-art-store.c"
	GError * _inner_error_;
	RygelMediaArtStore * self;
	char* dir;
	GFile* file;
	char* _tmp0_;
	_inner_error_ = NULL;
#line 119 "rygel-media-art-store.vala"
	self = (RygelMediaArtStore*) g_object_new (object_type, NULL);
#line 120 "rygel-media-art-store.vala"
	dir = g_build_filename (g_get_user_cache_dir (), "media-art", NULL);
#line 122 "rygel-media-art-store.vala"
	file = g_file_new_for_path (dir);
#line 124 "rygel-media-art-store.vala"
	if (!g_file_query_exists (file, NULL)) {
#line 125 "rygel-media-art-store.vala"
		g_mkdir_with_parents (dir, 0750);
#line 566 "rygel-media-art-store.c"
	}
#line 128 "rygel-media-art-store.vala"
	self->priv->directory = (_tmp0_ = g_strdup (dir), _g_free0 (self->priv->directory), _tmp0_);
#line 570 "rygel-media-art-store.c"
	{
		char* regex_string;
		char* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		char* _tmp5_;
		char* _tmp6_;
		GRegex* _tmp7_;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		GRegex* _tmp11_;
		GRegex** _tmp12_;
#line 130 "rygel-media-art-store.vala"
		regex_string = g_regex_escape_string (RYGEL_MEDIA_ART_STORE_invalid_chars, -1);
#line 131 "rygel-media-art-store.vala"
		_tmp3_ = (_tmp2_ = g_regex_new (_tmp1_ = g_strdup_printf ("[%s]", regex_string), 0, 0, &_inner_error_), _g_free0 (_tmp1_), _tmp2_);
#line 589 "rygel-media-art-store.c"
		if (_inner_error_ != NULL) {
			_g_free0 (regex_string);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch45_g_regex_error;
			}
			_g_free0 (regex_string);
			_g_object_unref0 (file);
			_g_free0 (dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 131 "rygel-media-art-store.vala"
		self->priv->char_remove_regex = (_tmp4_ = _tmp3_, _g_regex_unref0 (self->priv->char_remove_regex), _tmp4_);
#line 132 "rygel-media-art-store.vala"
		regex_string = (_tmp5_ = g_regex_escape_string (RYGEL_MEDIA_ART_STORE_convert_chars, -1), _g_free0 (regex_string), _tmp5_);
#line 133 "rygel-media-art-store.vala"
		_tmp8_ = (_tmp7_ = g_regex_new (_tmp6_ = g_strdup_printf ("[%s]", regex_string), 0, 0, &_inner_error_), _g_free0 (_tmp6_), _tmp7_);
#line 608 "rygel-media-art-store.c"
		if (_inner_error_ != NULL) {
			_g_free0 (regex_string);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch45_g_regex_error;
			}
			_g_free0 (regex_string);
			_g_object_unref0 (file);
			_g_free0 (dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 133 "rygel-media-art-store.vala"
		self->priv->char_convert_regex = (_tmp9_ = _tmp8_, _g_regex_unref0 (self->priv->char_convert_regex), _tmp9_);
#line 134 "rygel-media-art-store.vala"
		_tmp10_ = g_regex_new ("\\s+", 0, 0, &_inner_error_);
#line 625 "rygel-media-art-store.c"
		if (_inner_error_ != NULL) {
			_g_free0 (regex_string);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch45_g_regex_error;
			}
			_g_free0 (regex_string);
			_g_object_unref0 (file);
			_g_free0 (dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 134 "rygel-media-art-store.vala"
		self->priv->space_compress_regex = (_tmp11_ = _tmp10_, _g_regex_unref0 (self->priv->space_compress_regex), _tmp11_);
#line 135 "rygel-media-art-store.vala"
		self->priv->block_regexes = (_tmp12_ = g_new0 (GRegex*, 0 + 1), self->priv->block_regexes = (_vala_array_free (self->priv->block_regexes, self->priv->block_regexes_length1, (GDestroyNotify) g_regex_unref), NULL), self->priv->block_regexes_length1 = 0, self->priv->_block_regexes_size_ = self->priv->block_regexes_length1, _tmp12_);
#line 642 "rygel-media-art-store.c"
		{
			const char** block_collection;
			int block_collection_length1;
			int block_it;
#line 137 "rygel-media-art-store.vala"
			block_collection = RYGEL_MEDIA_ART_STORE_blocks;
#line 649 "rygel-media-art-store.c"
			block_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_ART_STORE_blocks);
			for (block_it = 0; block_it < G_N_ELEMENTS (RYGEL_MEDIA_ART_STORE_blocks); block_it = block_it + 1) {
				const char* block;
				block = block_collection[block_it];
				{
					char* _tmp18_;
					char* _tmp17_;
					char* _tmp16_;
					char* _tmp15_;
					char* _tmp14_;
					char* _tmp13_;
					char* _tmp19_;
					char* block_re;
					GRegex* _tmp20_;
#line 138 "rygel-media-art-store.vala"
					block_re = (_tmp19_ = g_strdup_printf (RYGEL_MEDIA_ART_STORE_block_pattern, _tmp14_ = g_regex_escape_string (_tmp13_ = g_strdup_printf ("%C", g_utf8_get_char (g_utf8_offset_to_pointer (block, 0))), -1), _tmp16_ = g_regex_escape_string (_tmp15_ = g_strdup_printf ("%C", g_utf8_get_char (g_utf8_offset_to_pointer (block, 1))), -1), _tmp18_ = g_regex_escape_string (_tmp17_ = g_strdup_printf ("%C", g_utf8_get_char (g_utf8_offset_to_pointer (block, 1))), -1)), _g_free0 (_tmp18_), _g_free0 (_tmp17_), _g_free0 (_tmp16_), _g_free0 (_tmp15_), _g_free0 (_tmp14_), _g_free0 (_tmp13_), _tmp19_);
#line 142 "rygel-media-art-store.vala"
					_tmp20_ = g_regex_new (block_re, 0, 0, &_inner_error_);
#line 668 "rygel-media-art-store.c"
					if (_inner_error_ != NULL) {
						_g_free0 (block_re);
						_g_free0 (regex_string);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch45_g_regex_error;
						}
						_g_free0 (block_re);
						_g_free0 (regex_string);
						_g_object_unref0 (file);
						_g_free0 (dir);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
#line 142 "rygel-media-art-store.vala"
					_vala_array_add1 (&self->priv->block_regexes, &self->priv->block_regexes_length1, &self->priv->_block_regexes_size_, _tmp20_);
#line 685 "rygel-media-art-store.c"
					_g_free0 (block_re);
				}
			}
		}
		_g_free0 (regex_string);
	}
	goto __finally45;
	__catch45_g_regex_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 145 "rygel-media-art-store.vala"
			g_assert_not_reached ();
#line 701 "rygel-media-art-store.c"
			_g_error_free0 (_error_);
		}
	}
	__finally45:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == MEDIA_ART_STORE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			_g_free0 (dir);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (file);
			_g_free0 (dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (file);
	_g_free0 (dir);
	return self;
}


#line 119 "rygel-media-art-store.vala"
static RygelMediaArtStore* rygel_media_art_store_new (GError** error) {
#line 119 "rygel-media-art-store.vala"
	return rygel_media_art_store_construct (RYGEL_TYPE_MEDIA_ART_STORE, error);
#line 731 "rygel-media-art-store.c"
}


#line 149 "rygel-media-art-store.vala"
static char* rygel_media_art_store_get_simple_hash (RygelMediaArtStore* self, const char* type, RygelMediaItem* item) {
#line 737 "rygel-media-art-store.c"
	char* result = NULL;
	char* hash;
	GQuark _tmp11_;
	const char* _tmp10_;
	static GQuark _tmp11__label0 = 0;
	static GQuark _tmp11__label1 = 0;
	static GQuark _tmp11__label2 = 0;
	static GQuark _tmp11__label3 = 0;
	static GQuark _tmp11__label4 = 0;
#line 149 "rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 149 "rygel-media-art-store.vala"
	g_return_val_if_fail (type != NULL, NULL);
#line 149 "rygel-media-art-store.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 753 "rygel-media-art-store.c"
	hash = NULL;
	_tmp10_ = type;
	_tmp11_ = (NULL == _tmp10_) ? 0 : g_quark_from_string (_tmp10_);
	if ((_tmp11_ == ((0 != _tmp11__label0) ? _tmp11__label0 : (_tmp11__label0 = g_quark_from_static_string ("artist")))) || (_tmp11_ == ((0 != _tmp11__label1) ? _tmp11__label1 : (_tmp11__label1 = g_quark_from_static_string ("radio")))))
	switch (0) {
		default:
		{
			char* _tmp0_;
#line 154 "rygel-media-art-store.vala"
			hash = (_tmp0_ = rygel_media_art_store_normalize_and_hash (self, item->author, TRUE), _g_free0 (hash), _tmp0_);
#line 155 "rygel-media-art-store.vala"
			break;
#line 766 "rygel-media-art-store.c"
		}
	} else if (_tmp11_ == ((0 != _tmp11__label2) ? _tmp11__label2 : (_tmp11__label2 = g_quark_from_static_string ("podcast"))))
	switch (0) {
		default:
		{
			char* _tmp1_;
#line 157 "rygel-media-art-store.vala"
			hash = (_tmp1_ = rygel_media_art_store_normalize_and_hash (self, rygel_media_object_get_title ((RygelMediaObject*) item), TRUE), _g_free0 (hash), _tmp1_);
#line 158 "rygel-media-art-store.vala"
			break;
#line 777 "rygel-media-art-store.c"
		}
	} else if (_tmp11_ == ((0 != _tmp11__label3) ? _tmp11__label3 : (_tmp11__label3 = g_quark_from_static_string ("album"))))
	switch (0) {
		default:
		{
			char* _tmp4_;
			char* _tmp3_;
			char* _tmp2_;
#line 160 "rygel-media-art-store.vala"
			hash = (_tmp4_ = rygel_media_art_store_normalize_and_hash (self, _tmp3_ = g_strconcat (_tmp2_ = g_strconcat (item->author, "\t", NULL), item->album, NULL), TRUE), _g_free0 (hash), _tmp4_);
#line 788 "rygel-media-art-store.c"
			_g_free0 (_tmp3_);
			_g_free0 (_tmp2_);
#line 162 "rygel-media-art-store.vala"
			break;
#line 793 "rygel-media-art-store.c"
		}
	} else if (_tmp11_ == ((0 != _tmp11__label4) ? _tmp11__label4 : (_tmp11__label4 = g_quark_from_static_string ("track"))))
	switch (0) {
		default:
		{
			char* _tmp9_;
			char* _tmp8_;
			char* _tmp7_;
			char* _tmp6_;
			char* _tmp5_;
#line 164 "rygel-media-art-store.vala"
			hash = (_tmp9_ = rygel_media_art_store_normalize_and_hash (self, _tmp8_ = g_strconcat (_tmp7_ = g_strconcat (_tmp6_ = g_strconcat (_tmp5_ = g_strconcat (item->author, "\t", NULL), item->album, NULL), "\t", NULL), rygel_media_object_get_title ((RygelMediaObject*) item), NULL), TRUE), _g_free0 (hash), _tmp9_);
#line 806 "rygel-media-art-store.c"
			_g_free0 (_tmp8_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp5_);
#line 167 "rygel-media-art-store.vala"
			break;
#line 813 "rygel-media-art-store.c"
		}
	} else
	switch (0) {
		default:
		{
#line 169 "rygel-media-art-store.vala"
			g_assert_not_reached ();
#line 821 "rygel-media-art-store.c"
		}
	}
	result = hash;
#line 172 "rygel-media-art-store.vala"
	return result;
#line 827 "rygel-media-art-store.c"
}


#line 175 "rygel-media-art-store.vala"
static char* rygel_media_art_store_get_hash (RygelMediaArtStore* self, const char* type, RygelMediaItem* item) {
#line 833 "rygel-media-art-store.c"
	char* result = NULL;
	char* b;
	char* c;
	GQuark _tmp10_;
	const char* _tmp9_;
	static GQuark _tmp10__label0 = 0;
	static GQuark _tmp10__label1 = 0;
	static GQuark _tmp10__label2 = 0;
	static GQuark _tmp10__label3 = 0;
	static GQuark _tmp10__label4 = 0;
#line 175 "rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 175 "rygel-media-art-store.vala"
	g_return_val_if_fail (type != NULL, NULL);
#line 175 "rygel-media-art-store.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 176 "rygel-media-art-store.vala"
	b = NULL;
#line 176 "rygel-media-art-store.vala"
	c = NULL;
#line 854 "rygel-media-art-store.c"
	_tmp9_ = type;
	_tmp10_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
	if (_tmp10_ == ((0 != _tmp10__label0) ? _tmp10__label0 : (_tmp10__label0 = g_quark_from_static_string ("track"))))
	switch (0) {
		default:
		{
			char* _tmp3_;
			char* _tmp2_;
			char* _tmp1_;
			char* _tmp0_;
			char* _tmp4_;
#line 179 "rygel-media-art-store.vala"
			b = (_tmp3_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = rygel_media_art_store_normalize_and_hash (self, item->author, FALSE), "-", NULL), _tmp2_ = rygel_media_art_store_normalize_and_hash (self, item->album, FALSE), NULL), _g_free0 (b), _tmp3_);
#line 868 "rygel-media-art-store.c"
			_g_free0 (_tmp2_);
			_g_free0 (_tmp1_);
			_g_free0 (_tmp0_);
#line 181 "rygel-media-art-store.vala"
			c = (_tmp4_ = rygel_media_art_store_normalize_and_hash (self, rygel_media_object_get_title ((RygelMediaObject*) item), FALSE), _g_free0 (c), _tmp4_);
#line 182 "rygel-media-art-store.vala"
			break;
#line 876 "rygel-media-art-store.c"
		}
	} else if ((_tmp10_ == ((0 != _tmp10__label1) ? _tmp10__label1 : (_tmp10__label1 = g_quark_from_static_string ("album")))) || (_tmp10_ == ((0 != _tmp10__label2) ? _tmp10__label2 : (_tmp10__label2 = g_quark_from_static_string ("artist")))))
	switch (0) {
		default:
		{
			char* _tmp5_;
			char* _tmp6_;
#line 185 "rygel-media-art-store.vala"
			b = (_tmp5_ = rygel_media_art_store_normalize_and_hash (self, item->author, FALSE), _g_free0 (b), _tmp5_);
#line 186 "rygel-media-art-store.vala"
			c = (_tmp6_ = rygel_media_art_store_normalize_and_hash (self, item->album, FALSE), _g_free0 (c), _tmp6_);
#line 187 "rygel-media-art-store.vala"
			break;
#line 890 "rygel-media-art-store.c"
		}
	} else if ((_tmp10_ == ((0 != _tmp10__label3) ? _tmp10__label3 : (_tmp10__label3 = g_quark_from_static_string ("radio")))) || (_tmp10_ == ((0 != _tmp10__label4) ? _tmp10__label4 : (_tmp10__label4 = g_quark_from_static_string ("podcast")))))
	switch (0) {
		default:
		{
			char* _tmp7_;
			char* _tmp8_;
#line 190 "rygel-media-art-store.vala"
			b = (_tmp7_ = rygel_media_art_store_normalize_and_hash (self, rygel_media_object_get_title ((RygelMediaObject*) item), FALSE), _g_free0 (b), _tmp7_);
#line 191 "rygel-media-art-store.vala"
			c = (_tmp8_ = g_strdup (RYGEL_MEDIA_ART_STORE_PLACEHOLDER_HASH), _g_free0 (c), _tmp8_);
#line 192 "rygel-media-art-store.vala"
			break;
#line 904 "rygel-media-art-store.c"
		}
	}
	result = g_strdup_printf ("%s-%s", b, c);
	_g_free0 (c);
	_g_free0 (b);
#line 195 "rygel-media-art-store.vala"
	return result;
#line 912 "rygel-media-art-store.c"
}


#line 198 "rygel-media-art-store.vala"
static char* rygel_media_art_store_normalize_and_hash (RygelMediaArtStore* self, const char* input, gboolean utf8_only) {
#line 918 "rygel-media-art-store.c"
	char* result = NULL;
	char* normalized;
	gboolean _tmp0_ = FALSE;
#line 198 "rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 199 "rygel-media-art-store.vala"
	normalized = g_strdup (" ");
#line 200 "rygel-media-art-store.vala"
	if (input != NULL) {
#line 200 "rygel-media-art-store.vala"
		_tmp0_ = _vala_strcmp0 (input, "") != 0;
#line 930 "rygel-media-art-store.c"
	} else {
#line 200 "rygel-media-art-store.vala"
		_tmp0_ = FALSE;
#line 934 "rygel-media-art-store.c"
	}
#line 200 "rygel-media-art-store.vala"
	if (_tmp0_) {
#line 938 "rygel-media-art-store.c"
		char* _tmp4_;
#line 201 "rygel-media-art-store.vala"
		if (utf8_only) {
#line 942 "rygel-media-art-store.c"
			char* _tmp1_;
#line 202 "rygel-media-art-store.vala"
			normalized = (_tmp1_ = g_strdup (input), _g_free0 (normalized), _tmp1_);
#line 946 "rygel-media-art-store.c"
		} else {
			char* _tmp2_;
			char* _tmp3_;
#line 204 "rygel-media-art-store.vala"
			normalized = (_tmp2_ = rygel_media_art_store_strip_invalid_entities (self, input), _g_free0 (normalized), _tmp2_);
#line 205 "rygel-media-art-store.vala"
			normalized = (_tmp3_ = g_utf8_strdown (normalized, -1), _g_free0 (normalized), _tmp3_);
#line 954 "rygel-media-art-store.c"
		}
#line 207 "rygel-media-art-store.vala"
		normalized = (_tmp4_ = g_utf8_normalize (normalized, (gssize) (-1), G_NORMALIZE_ALL), _g_free0 (normalized), _tmp4_);
#line 958 "rygel-media-art-store.c"
	}
	result = g_compute_checksum_for_string (G_CHECKSUM_MD5, normalized, -1);
	_g_free0 (normalized);
#line 210 "rygel-media-art-store.vala"
	return result;
#line 964 "rygel-media-art-store.c"
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


#line 213 "rygel-media-art-store.vala"
static char* rygel_media_art_store_strip_invalid_entities (RygelMediaArtStore* self, const char* original) {
#line 975 "rygel-media-art-store.c"
	char* result = NULL;
	GError * _inner_error_;
	char* p;
	char* _tmp0_;
#line 213 "rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 213 "rygel-media-art-store.vala"
	g_return_val_if_fail (original != NULL, NULL);
#line 984 "rygel-media-art-store.c"
	_inner_error_ = NULL;
	p = NULL;
#line 216 "rygel-media-art-store.vala"
	p = (_tmp0_ = g_strdup (original), _g_free0 (p), _tmp0_);
#line 989 "rygel-media-art-store.c"
	{
		char* _tmp3_;
		char* _tmp4_;
		char* _tmp5_;
		char* _tmp6_;
		char* _tmp7_;
		char* _tmp8_;
		{
			GRegex** re_collection;
			int re_collection_length1;
			int re_it;
#line 219 "rygel-media-art-store.vala"
			re_collection = self->priv->block_regexes;
#line 1003 "rygel-media-art-store.c"
			re_collection_length1 = self->priv->block_regexes_length1;
			for (re_it = 0; re_it < self->priv->block_regexes_length1; re_it = re_it + 1) {
				GRegex* re;
				re = _g_regex_ref0 (re_collection[re_it]);
				{
					char* _tmp1_;
					char* _tmp2_;
#line 220 "rygel-media-art-store.vala"
					_tmp1_ = g_regex_replace_literal (re, p, (gssize) (-1), 0, "", 0, &_inner_error_);
#line 1013 "rygel-media-art-store.c"
					if (_inner_error_ != NULL) {
						_g_regex_unref0 (re);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch46_g_regex_error;
						}
						_g_regex_unref0 (re);
						_g_free0 (p);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
#line 220 "rygel-media-art-store.vala"
					p = (_tmp2_ = _tmp1_, _g_free0 (p), _tmp2_);
#line 1027 "rygel-media-art-store.c"
					_g_regex_unref0 (re);
				}
			}
		}
#line 223 "rygel-media-art-store.vala"
		_tmp3_ = g_regex_replace (self->priv->char_remove_regex, p, (gssize) (-1), 0, "", 0, &_inner_error_);
#line 1034 "rygel-media-art-store.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch46_g_regex_error;
			}
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 223 "rygel-media-art-store.vala"
		p = (_tmp4_ = _tmp3_, _g_free0 (p), _tmp4_);
#line 224 "rygel-media-art-store.vala"
		_tmp5_ = g_regex_replace (self->priv->char_convert_regex, p, (gssize) (-1), 0, " ", 0, &_inner_error_);
#line 1048 "rygel-media-art-store.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch46_g_regex_error;
			}
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 224 "rygel-media-art-store.vala"
		p = (_tmp6_ = _tmp5_, _g_free0 (p), _tmp6_);
#line 225 "rygel-media-art-store.vala"
		_tmp7_ = g_regex_replace (self->priv->space_compress_regex, p, (gssize) (-1), 0, " ", 0, &_inner_error_);
#line 1062 "rygel-media-art-store.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch46_g_regex_error;
			}
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 225 "rygel-media-art-store.vala"
		p = (_tmp8_ = _tmp7_, _g_free0 (p), _tmp8_);
#line 1074 "rygel-media-art-store.c"
		result = p;
#line 227 "rygel-media-art-store.vala"
		return result;
#line 1078 "rygel-media-art-store.c"
	}
	goto __finally46;
	__catch46_g_regex_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 229 "rygel-media-art-store.vala"
			g_assert_not_reached ();
#line 1089 "rygel-media-art-store.c"
			_g_error_free0 (_error_);
		}
	}
	__finally46:
	{
		_g_free0 (p);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (p);
}


static void rygel_media_art_store_class_init (RygelMediaArtStoreClass * klass) {
	rygel_media_art_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaArtStorePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_art_store_finalize;
}


static void rygel_media_art_store_instance_init (RygelMediaArtStore * self) {
	self->priv = RYGEL_MEDIA_ART_STORE_GET_PRIVATE (self);
}


static void rygel_media_art_store_finalize (GObject* obj) {
	RygelMediaArtStore * self;
	self = RYGEL_MEDIA_ART_STORE (obj);
	_g_regex_unref0 (self->priv->char_remove_regex);
	_g_regex_unref0 (self->priv->char_convert_regex);
	_g_regex_unref0 (self->priv->space_compress_regex);
	self->priv->block_regexes = (_vala_array_free (self->priv->block_regexes, self->priv->block_regexes_length1, (GDestroyNotify) g_regex_unref), NULL);
	_g_free0 (self->priv->directory);
	G_OBJECT_CLASS (rygel_media_art_store_parent_class)->finalize (obj);
}


GType rygel_media_art_store_get_type (void) {
	static volatile gsize rygel_media_art_store_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_art_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaArtStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_art_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaArtStore), 0, (GInstanceInitFunc) rygel_media_art_store_instance_init, NULL };
		GType rygel_media_art_store_type_id;
		rygel_media_art_store_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaArtStore", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_art_store_type_id__volatile, rygel_media_art_store_type_id);
	}
	return rygel_media_art_store_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




