/* rygel-http-seek_time-seek.c generated by valac 0.9.5, the Vala compiler
 * generated from rygel-http-seek_time-seek.vala, do not modify */

/*
 * Copyright (C) 2008-2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
typedef struct _RygelHTTPSeekPrivate RygelHTTPSeekPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelHTTPSeek {
	GObject parent_instance;
	RygelHTTPSeekPrivate * priv;
};

struct _RygelHTTPSeekClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPSeek* self);
};

struct _RygelHTTPSeekPrivate {
	SoupMessage* _msg;
	gint64 _start;
	gint64 _stop;
	gint64 _length;
	gint64 _total_length;
};


static gpointer rygel_http_seek_parent_class = NULL;

GQuark rygel_http_seek_error_quark (void);
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_SEEK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekPrivate))
enum  {
	RYGEL_HTTP_SEEK_DUMMY_PROPERTY,
	RYGEL_HTTP_SEEK_MSG,
	RYGEL_HTTP_SEEK_START,
	RYGEL_HTTP_SEEK_STOP,
	RYGEL_HTTP_SEEK_LENGTH,
	RYGEL_HTTP_SEEK_TOTAL_LENGTH
};
static void rygel_http_seek_set_msg (RygelHTTPSeek* self, SoupMessage* value);
static void rygel_http_seek_set_start (RygelHTTPSeek* self, gint64 value);
static void rygel_http_seek_set_stop (RygelHTTPSeek* self, gint64 value);
static void rygel_http_seek_set_total_length (RygelHTTPSeek* self, gint64 value);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
static void rygel_http_seek_set_length (RygelHTTPSeek* self, gint64 value);
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, SoupMessage* msg, gint64 start, gint64 stop, gint64 total_length);
void rygel_http_seek_add_response_headers (RygelHTTPSeek* self);
static void rygel_http_seek_real_add_response_headers (RygelHTTPSeek* self);
SoupMessage* rygel_http_seek_get_msg (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
static void rygel_http_seek_finalize (GObject* obj);
static void rygel_http_seek_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_http_seek_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GQuark rygel_http_seek_error_quark (void) {
	return g_quark_from_static_string ("rygel_http_seek_error-quark");
}


#line 38 "rygel-http-seek_time-seek.vala"
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, SoupMessage* msg, gint64 start, gint64 stop, gint64 total_length) {
#line 108 "rygel-http-seek_time-seek.c"
	RygelHTTPSeek * self;
#line 38 "rygel-http-seek_time-seek.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 38 "rygel-http-seek_time-seek.vala"
	self = (RygelHTTPSeek*) g_object_new (object_type, NULL);
#line 42 "rygel-http-seek_time-seek.vala"
	rygel_http_seek_set_msg (self, msg);
#line 43 "rygel-http-seek_time-seek.vala"
	rygel_http_seek_set_start (self, start);
#line 44 "rygel-http-seek_time-seek.vala"
	rygel_http_seek_set_stop (self, stop);
#line 45 "rygel-http-seek_time-seek.vala"
	rygel_http_seek_set_total_length (self, total_length);
#line 47 "rygel-http-seek_time-seek.vala"
	if (self->priv->_length > 0) {
#line 48 "rygel-http-seek_time-seek.vala"
		rygel_http_seek_set_stop (self, CLAMP (stop, start + 1, self->priv->_length - 1));
#line 126 "rygel-http-seek_time-seek.c"
	}
#line 51 "rygel-http-seek_time-seek.vala"
	rygel_http_seek_set_length (self, (stop + 1) - start);
#line 130 "rygel-http-seek_time-seek.c"
	return self;
}


#line 54 "rygel-http-seek_time-seek.vala"
static void rygel_http_seek_real_add_response_headers (RygelHTTPSeek* self) {
#line 137 "rygel-http-seek_time-seek.c"
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `rygel_http_seek_add_response_headers'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


#line 54 "rygel-http-seek_time-seek.vala"
void rygel_http_seek_add_response_headers (RygelHTTPSeek* self) {
#line 54 "rygel-http-seek_time-seek.vala"
	RYGEL_HTTP_SEEK_GET_CLASS (self)->add_response_headers (self);
#line 148 "rygel-http-seek_time-seek.c"
}


SoupMessage* rygel_http_seek_get_msg (RygelHTTPSeek* self) {
	SoupMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_msg;
#line 30 "rygel-http-seek_time-seek.vala"
	return result;
#line 158 "rygel-http-seek_time-seek.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_http_seek_set_msg (RygelHTTPSeek* self, SoupMessage* value) {
	SoupMessage* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_msg = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_msg), _tmp0_);
	g_object_notify ((GObject *) self, "msg");
}


gint64 rygel_http_seek_get_start (RygelHTTPSeek* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_start;
#line 33 "rygel-http-seek_time-seek.vala"
	return result;
#line 181 "rygel-http-seek_time-seek.c"
}


static void rygel_http_seek_set_start (RygelHTTPSeek* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_start = value;
	g_object_notify ((GObject *) self, "start");
}


gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_stop;
#line 34 "rygel-http-seek_time-seek.vala"
	return result;
#line 198 "rygel-http-seek_time-seek.c"
}


static void rygel_http_seek_set_stop (RygelHTTPSeek* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_stop = value;
	g_object_notify ((GObject *) self, "stop");
}


gint64 rygel_http_seek_get_length (RygelHTTPSeek* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_length;
#line 35 "rygel-http-seek_time-seek.vala"
	return result;
#line 215 "rygel-http-seek_time-seek.c"
}


static void rygel_http_seek_set_length (RygelHTTPSeek* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_length = value;
	g_object_notify ((GObject *) self, "length");
}


gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_total_length;
#line 36 "rygel-http-seek_time-seek.vala"
	return result;
#line 232 "rygel-http-seek_time-seek.c"
}


static void rygel_http_seek_set_total_length (RygelHTTPSeek* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_total_length = value;
	g_object_notify ((GObject *) self, "total-length");
}


static void rygel_http_seek_class_init (RygelHTTPSeekClass * klass) {
	rygel_http_seek_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPSeekPrivate));
	RYGEL_HTTP_SEEK_CLASS (klass)->add_response_headers = rygel_http_seek_real_add_response_headers;
	G_OBJECT_CLASS (klass)->get_property = rygel_http_seek_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_http_seek_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_seek_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_MSG, g_param_spec_object ("msg", "msg", "msg", SOUP_TYPE_MESSAGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_START, g_param_spec_int64 ("start", "start", "start", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_STOP, g_param_spec_int64 ("stop", "stop", "stop", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_LENGTH, g_param_spec_int64 ("length", "length", "length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_TOTAL_LENGTH, g_param_spec_int64 ("total-length", "total-length", "total-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_http_seek_instance_init (RygelHTTPSeek * self) {
	self->priv = RYGEL_HTTP_SEEK_GET_PRIVATE (self);
}


static void rygel_http_seek_finalize (GObject* obj) {
	RygelHTTPSeek * self;
	self = RYGEL_HTTP_SEEK (obj);
	_g_object_unref0 (self->priv->_msg);
	G_OBJECT_CLASS (rygel_http_seek_parent_class)->finalize (obj);
}


GType rygel_http_seek_get_type (void) {
	static volatile gsize rygel_http_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPSeek), 0, (GInstanceInitFunc) rygel_http_seek_instance_init, NULL };
		GType rygel_http_seek_type_id;
		rygel_http_seek_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPSeek", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_http_seek_type_id__volatile, rygel_http_seek_type_id);
	}
	return rygel_http_seek_type_id__volatile;
}


static void rygel_http_seek_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPSeek * self;
	self = RYGEL_HTTP_SEEK (object);
	switch (property_id) {
		case RYGEL_HTTP_SEEK_MSG:
		g_value_set_object (value, rygel_http_seek_get_msg (self));
		break;
		case RYGEL_HTTP_SEEK_START:
		g_value_set_int64 (value, rygel_http_seek_get_start (self));
		break;
		case RYGEL_HTTP_SEEK_STOP:
		g_value_set_int64 (value, rygel_http_seek_get_stop (self));
		break;
		case RYGEL_HTTP_SEEK_LENGTH:
		g_value_set_int64 (value, rygel_http_seek_get_length (self));
		break;
		case RYGEL_HTTP_SEEK_TOTAL_LENGTH:
		g_value_set_int64 (value, rygel_http_seek_get_total_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_http_seek_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPSeek * self;
	self = RYGEL_HTTP_SEEK (object);
	switch (property_id) {
		case RYGEL_HTTP_SEEK_MSG:
		rygel_http_seek_set_msg (self, g_value_get_object (value));
		break;
		case RYGEL_HTTP_SEEK_START:
		rygel_http_seek_set_start (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_SEEK_STOP:
		rygel_http_seek_set_stop (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_SEEK_LENGTH:
		rygel_http_seek_set_length (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_SEEK_TOTAL_LENGTH:
		rygel_http_seek_set_total_length (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




