/* rygel-http-response-test_seekable-response.c generated by valac 0.9.5, the Vala compiler
 * generated from rygel-http-response-test_seekable-response.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
/* This module contains the common code between the test cases for*/
/* HTTPResponse subclasses.*/

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_RESPONSE_TEST (rygel_http_response_test_get_type ())
#define RYGEL_HTTP_RESPONSE_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTest))
#define RYGEL_HTTP_RESPONSE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestClass))
#define RYGEL_IS_HTTP_RESPONSE_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST))
#define RYGEL_IS_HTTP_RESPONSE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_TEST))
#define RYGEL_HTTP_RESPONSE_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestClass))

typedef struct _RygelHTTPResponseTest RygelHTTPResponseTest;
typedef struct _RygelHTTPResponseTestClass RygelHTTPResponseTestClass;
typedef struct _RygelHTTPResponseTestPrivate RygelHTTPResponseTestPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _Block1Data Block1Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPResponseTest {
	GObject parent_instance;
	RygelHTTPResponseTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
	GCancellable* cancellable;
};

struct _RygelHTTPResponseTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPResponseTest* self, GError** error);
	RygelHTTPResponse* (*create_response) (RygelHTTPResponseTest* self, SoupMessage* msg, GError** error);
};

struct _RygelHTTPResponseTestPrivate {
	gboolean server_done;
	gboolean client_done;
	GMainLoop* main_loop;
	GError* error;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	GUPnPContext* context;
	SoupMessage* msg;
	gsize total_bytes;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _RygelHTTPClientPrivate {
	GCancellable* _cancellable;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPClient * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gsize bytes_received;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	GSourceFunc _tmp0_;
	Block1Data* _data1_;
};


static gpointer rygel_http_response_test_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;
static RygelStateMachineIface* rygel_http_client_rygel_state_machine_parent_iface = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_response_test_get_type (void) G_GNUC_CONST;
GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_RESPONSE_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestPrivate))
enum  {
	RYGEL_HTTP_RESPONSE_TEST_DUMMY_PROPERTY
};
#define RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES ((glong) 1024)
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
char* rygel_http_server_get_uri (RygelHTTPServer* self);
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const char* uri, gsize total_bytes, gboolean active);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const char* uri, gsize total_bytes, gboolean active);
RygelHTTPResponseTest* rygel_http_response_test_construct (GType object_type, GCancellable* cancellable, GError** error);
RygelHTTPResponseTest* rygel_http_response_test_construct_complete (GType object_type, GError** error);
RygelHTTPResponseTest* rygel_http_response_test_construct_abort (GType object_type, GError** error);
static gboolean rygel_http_response_test_on_timeout (RygelHTTPResponseTest* self);
static gboolean _rygel_http_response_test_on_timeout_gsource_func (gpointer self);
static void rygel_http_response_test_on_message_received (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_response_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
static void rygel_http_response_test_on_message_aborted (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_response_test_on_message_aborted_rygel_http_server_message_aborted (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
static void rygel_http_response_test_on_client_completed (RygelHTTPResponseTest* self, RygelStateMachine* client);
static void _rygel_http_response_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
void rygel_http_response_test_run (RygelHTTPResponseTest* self, GError** error);
static void rygel_http_response_test_real_run (RygelHTTPResponseTest* self, GError** error);
RygelHTTPResponse* rygel_http_response_test_create_response (RygelHTTPResponseTest* self, SoupMessage* msg, GError** error);
static RygelHTTPResponse* rygel_http_response_test_real_create_response (RygelHTTPResponseTest* self, SoupMessage* msg, GError** error);
static void rygel_http_response_test_on_response_completed (RygelHTTPResponseTest* self, RygelStateMachine* response);
void rygel_http_response_run (RygelHTTPResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_response_run_finish (RygelHTTPResponse* self, GAsyncResult* _res_);
static void _rygel_http_response_test_on_response_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
static void rygel_http_response_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const char* path, GHashTable* query, SoupClientContext* client);
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const char* path, GHashTable* query, SoupClientContext* client, gpointer self);
static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client);
static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
static void rygel_http_server_finalize (GObject* obj);
static void rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientPrivate))
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY,
	RYGEL_HTTP_CLIENT_CANCELLABLE
};
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_http_client_on_cancelled (RygelHTTPClient* self, GCancellable* cancellable);
static void _rygel_http_client_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_client_real_run_data_free (gpointer _data);
static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_client_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self);
static void _lambda0_ (SoupMessage* msg, SoupBuffer* chunk, Block1Data* _data1_);
static void __lambda0__soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void _lambda1_ (SoupSession* session, SoupMessage* msg, Block1Data* _data1_);
static void __lambda1__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* data);
static void rygel_http_client_finalize (GObject* obj);
static void rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 47 "rygel-http-response-test_seekable-response.vala"
RygelHTTPResponseTest* rygel_http_response_test_construct (GType object_type, GCancellable* cancellable, GError** error) {
#line 269 "rygel-http-response-test_seekable-response.c"
	GError * _inner_error_;
	RygelHTTPResponseTest * self;
	GCancellable* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	RygelHTTPClient* _tmp4_;
	char* _tmp3_;
	GMainLoop* _tmp5_;
	_inner_error_ = NULL;
#line 47 "rygel-http-response-test_seekable-response.vala"
	self = (RygelHTTPResponseTest*) g_object_new (object_type, NULL);
#line 48 "rygel-http-response-test_seekable-response.vala"
	self->cancellable = (_tmp0_ = _g_object_ref0 (cancellable), _g_object_unref0 (self->cancellable), _tmp0_);
#line 50 "rygel-http-response-test_seekable-response.vala"
	_tmp1_ = rygel_http_server_new (&_inner_error_);
#line 285 "rygel-http-response-test_seekable-response.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
#line 50 "rygel-http-response-test_seekable-response.vala"
	self->server = (_tmp2_ = _tmp1_, _g_object_unref0 (self->server), _tmp2_);
#line 51 "rygel-http-response-test_seekable-response.vala"
	self->client = (_tmp4_ = rygel_http_client_new (self->server->context, _tmp3_ = rygel_http_server_get_uri (self->server), (gsize) RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES, cancellable != NULL), _g_object_unref0 (self->client), _tmp4_);
#line 295 "rygel-http-response-test_seekable-response.c"
	_g_free0 (_tmp3_);
#line 55 "rygel-http-response-test_seekable-response.vala"
	self->priv->main_loop = (_tmp5_ = g_main_loop_new (NULL, FALSE), _g_main_loop_unref0 (self->priv->main_loop), _tmp5_);
#line 299 "rygel-http-response-test_seekable-response.c"
	return self;
}


#line 58 "rygel-http-response-test_seekable-response.vala"
RygelHTTPResponseTest* rygel_http_response_test_construct_complete (GType object_type, GError** error) {
#line 306 "rygel-http-response-test_seekable-response.c"
	GError * _inner_error_;
	RygelHTTPResponseTest * self;
	_inner_error_ = NULL;
#line 59 "rygel-http-response-test_seekable-response.vala"
	self = (RygelHTTPResponseTest*) rygel_http_response_test_construct (object_type, NULL, &_inner_error_);
#line 312 "rygel-http-response-test_seekable-response.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


#line 62 "rygel-http-response-test_seekable-response.vala"
RygelHTTPResponseTest* rygel_http_response_test_construct_abort (GType object_type, GError** error) {
#line 324 "rygel-http-response-test_seekable-response.c"
	GError * _inner_error_;
	RygelHTTPResponseTest * self;
	GCancellable* _tmp0_;
	_inner_error_ = NULL;
#line 63 "rygel-http-response-test_seekable-response.vala"
	self = (RygelHTTPResponseTest*) rygel_http_response_test_construct (object_type, _tmp0_ = g_cancellable_new (), &_inner_error_);
#line 331 "rygel-http-response-test_seekable-response.c"
	_g_object_unref0 (_tmp0_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


#line 125 "rygel-http-response-test_seekable-response.vala"
static gboolean _rygel_http_response_test_on_timeout_gsource_func (gpointer self) {
#line 344 "rygel-http-response-test_seekable-response.c"
	gboolean result;
	result = rygel_http_response_test_on_timeout (self);
	return result;
}


#line 104 "rygel-http-response-test_seekable-response.vala"
static void _rygel_http_response_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
#line 353 "rygel-http-response-test_seekable-response.c"
	rygel_http_response_test_on_message_received (self, _sender, message);
}


#line 120 "rygel-http-response-test_seekable-response.vala"
static void _rygel_http_response_test_on_message_aborted_rygel_http_server_message_aborted (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
#line 360 "rygel-http-response-test_seekable-response.c"
	rygel_http_response_test_on_message_aborted (self, _sender, message);
}


#line 88 "rygel-http-response-test_seekable-response.vala"
static void _rygel_http_response_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 367 "rygel-http-response-test_seekable-response.c"
	rygel_http_response_test_on_client_completed (self, _sender);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


#line 66 "rygel-http-response-test_seekable-response.vala"
static void rygel_http_response_test_real_run (RygelHTTPResponseTest* self, GError** error) {
#line 379 "rygel-http-response-test_seekable-response.c"
	GError * _inner_error_;
#line 66 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (self != NULL);
#line 383 "rygel-http-response-test_seekable-response.c"
	_inner_error_ = NULL;
#line 67 "rygel-http-response-test_seekable-response.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _rygel_http_response_test_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 68 "rygel-http-response-test_seekable-response.vala"
	g_signal_connect_object (self->server, "message-received", (GCallback) _rygel_http_response_test_on_message_received_rygel_http_server_message_received, self, 0);
#line 69 "rygel-http-response-test_seekable-response.vala"
	g_signal_connect_object (self->server, "message-aborted", (GCallback) _rygel_http_response_test_on_message_aborted_rygel_http_server_message_aborted, self, 0);
#line 70 "rygel-http-response-test_seekable-response.vala"
	if (self->cancellable == NULL) {
#line 71 "rygel-http-response-test_seekable-response.vala"
		g_signal_connect_object ((RygelStateMachine*) self->client, "completed", (GCallback) _rygel_http_response_test_on_client_completed_rygel_state_machine_completed, self, 0);
#line 395 "rygel-http-response-test_seekable-response.c"
	} else {
#line 73 "rygel-http-response-test_seekable-response.vala"
		self->priv->client_done = TRUE;
#line 399 "rygel-http-response-test_seekable-response.c"
	}
#line 76 "rygel-http-response-test_seekable-response.vala"
	rygel_state_machine_run ((RygelStateMachine*) self->client, NULL, NULL);
#line 78 "rygel-http-response-test_seekable-response.vala"
	g_main_loop_run (self->priv->main_loop);
#line 80 "rygel-http-response-test_seekable-response.vala"
	if (self->priv->error != NULL) {
#line 407 "rygel-http-response-test_seekable-response.c"
		_inner_error_ = _g_error_copy0 (self->priv->error);
		{
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


#line 66 "rygel-http-response-test_seekable-response.vala"
void rygel_http_response_test_run (RygelHTTPResponseTest* self, GError** error) {
#line 66 "rygel-http-response-test_seekable-response.vala"
	RYGEL_HTTP_RESPONSE_TEST_GET_CLASS (self)->run (self, error);
#line 421 "rygel-http-response-test_seekable-response.c"
}


#line 85 "rygel-http-response-test_seekable-response.vala"
static RygelHTTPResponse* rygel_http_response_test_real_create_response (RygelHTTPResponseTest* self, SoupMessage* msg, GError** error) {
#line 427 "rygel-http-response-test_seekable-response.c"
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `rygel_http_response_test_create_response'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


#line 85 "rygel-http-response-test_seekable-response.vala"
RygelHTTPResponse* rygel_http_response_test_create_response (RygelHTTPResponseTest* self, SoupMessage* msg, GError** error) {
#line 85 "rygel-http-response-test_seekable-response.vala"
	return RYGEL_HTTP_RESPONSE_TEST_GET_CLASS (self)->create_response (self, msg, error);
#line 438 "rygel-http-response-test_seekable-response.c"
}


#line 88 "rygel-http-response-test_seekable-response.vala"
static void rygel_http_response_test_on_client_completed (RygelHTTPResponseTest* self, RygelStateMachine* client) {
#line 88 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (self != NULL);
#line 88 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (client != NULL);
#line 89 "rygel-http-response-test_seekable-response.vala"
	if (self->priv->server_done) {
#line 90 "rygel-http-response-test_seekable-response.vala"
		g_main_loop_quit (self->priv->main_loop);
#line 452 "rygel-http-response-test_seekable-response.c"
	}
#line 93 "rygel-http-response-test_seekable-response.vala"
	self->priv->client_done = TRUE;
#line 456 "rygel-http-response-test_seekable-response.c"
}


#line 96 "rygel-http-response-test_seekable-response.vala"
static void rygel_http_response_test_on_response_completed (RygelHTTPResponseTest* self, RygelStateMachine* response) {
#line 96 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (self != NULL);
#line 96 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (response != NULL);
#line 97 "rygel-http-response-test_seekable-response.vala"
	if (self->priv->client_done) {
#line 98 "rygel-http-response-test_seekable-response.vala"
		g_main_loop_quit (self->priv->main_loop);
#line 470 "rygel-http-response-test_seekable-response.c"
	}
#line 101 "rygel-http-response-test_seekable-response.vala"
	self->priv->server_done = TRUE;
#line 474 "rygel-http-response-test_seekable-response.c"
}


#line 96 "rygel-http-response-test_seekable-response.vala"
static void _rygel_http_response_test_on_response_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 480 "rygel-http-response-test_seekable-response.c"
	rygel_http_response_test_on_response_completed (self, _sender);
}


#line 104 "rygel-http-response-test_seekable-response.vala"
static void rygel_http_response_test_on_message_received (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg) {
#line 487 "rygel-http-response-test_seekable-response.c"
	GError * _inner_error_;
#line 104 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (self != NULL);
#line 104 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (server != NULL);
#line 104 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (msg != NULL);
#line 495 "rygel-http-response-test_seekable-response.c"
	_inner_error_ = NULL;
	{
		RygelHTTPResponse* response;
#line 107 "rygel-http-response-test_seekable-response.vala"
		response = rygel_http_response_test_create_response (self, msg, &_inner_error_);
#line 501 "rygel-http-response-test_seekable-response.c"
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
#line 109 "rygel-http-response-test_seekable-response.vala"
		rygel_http_response_run (response, NULL, NULL);
#line 111 "rygel-http-response-test_seekable-response.vala"
		g_signal_connect_object ((RygelStateMachine*) response, "completed", (GCallback) _rygel_http_response_test_on_response_completed_rygel_state_machine_completed, self, 0);
#line 509 "rygel-http-response-test_seekable-response.c"
		_g_object_unref0 (response);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			GError* _tmp0_;
#line 113 "rygel-http-response-test_seekable-response.vala"
			self->priv->error = (_tmp0_ = _g_error_copy0 (_error_), _g_error_free0 (self->priv->error), _tmp0_);
#line 114 "rygel-http-response-test_seekable-response.vala"
			g_main_loop_quit (self->priv->main_loop);
#line 524 "rygel-http-response-test_seekable-response.c"
			_g_error_free0 (_error_);
#line 116 "rygel-http-response-test_seekable-response.vala"
			return;
#line 528 "rygel-http-response-test_seekable-response.c"
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 120 "rygel-http-response-test_seekable-response.vala"
static void rygel_http_response_test_on_message_aborted (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg) {
#line 120 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (self != NULL);
#line 120 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (server != NULL);
#line 120 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (msg != NULL);
#line 122 "rygel-http-response-test_seekable-response.vala"
	g_cancellable_cancel (self->cancellable);
#line 550 "rygel-http-response-test_seekable-response.c"
}


#line 125 "rygel-http-response-test_seekable-response.vala"
static gboolean rygel_http_response_test_on_timeout (RygelHTTPResponseTest* self) {
#line 556 "rygel-http-response-test_seekable-response.c"
	gboolean result = FALSE;
	GError* _tmp0_;
#line 125 "rygel-http-response-test_seekable-response.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 126 "rygel-http-response-test_seekable-response.vala"
	self->priv->error = (_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout"), _g_error_free0 (self->priv->error), _tmp0_);
#line 127 "rygel-http-response-test_seekable-response.vala"
	g_main_loop_quit (self->priv->main_loop);
#line 565 "rygel-http-response-test_seekable-response.c"
	result = FALSE;
#line 129 "rygel-http-response-test_seekable-response.vala"
	return result;
#line 569 "rygel-http-response-test_seekable-response.c"
}


static void rygel_http_response_test_class_init (RygelHTTPResponseTestClass * klass) {
	rygel_http_response_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPResponseTestPrivate));
	RYGEL_HTTP_RESPONSE_TEST_CLASS (klass)->run = rygel_http_response_test_real_run;
	RYGEL_HTTP_RESPONSE_TEST_CLASS (klass)->create_response = rygel_http_response_test_real_create_response;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_test_finalize;
}


static void rygel_http_response_test_instance_init (RygelHTTPResponseTest * self) {
	self->priv = RYGEL_HTTP_RESPONSE_TEST_GET_PRIVATE (self);
}


static void rygel_http_response_test_finalize (GObject* obj) {
	RygelHTTPResponseTest * self;
	self = RYGEL_HTTP_RESPONSE_TEST (obj);
	_g_object_unref0 (self->server);
	_g_object_unref0 (self->client);
	_g_main_loop_unref0 (self->priv->main_loop);
	_g_object_unref0 (self->cancellable);
	_g_error_free0 (self->priv->error);
	G_OBJECT_CLASS (rygel_http_response_test_parent_class)->finalize (obj);
}


GType rygel_http_response_test_get_type (void) {
	static volatile gsize rygel_http_response_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponseTest), 0, (GInstanceInitFunc) rygel_http_response_test_instance_init, NULL };
		GType rygel_http_response_test_type_id;
		rygel_http_response_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponseTest", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_http_response_test_type_id__volatile, rygel_http_response_test_type_id);
	}
	return rygel_http_response_test_type_id__volatile;
}


#line 164 "rygel-http-response-test_seekable-response.vala"
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const char* path, GHashTable* query, SoupClientContext* client, gpointer self) {
#line 613 "rygel-http-response-test_seekable-response.c"
	rygel_http_server_server_cb (self, server, msg, path, query, client);
}


#line 173 "rygel-http-response-test_seekable-response.vala"
static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
#line 620 "rygel-http-response-test_seekable-response.c"
	rygel_http_server_on_request_aborted (self, _sender, msg, client);
}


#line 149 "rygel-http-response-test_seekable-response.vala"
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
#line 627 "rygel-http-response-test_seekable-response.c"
	GError * _inner_error_;
	RygelHTTPServer * self;
	_inner_error_ = NULL;
#line 149 "rygel-http-response-test_seekable-response.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 633 "rygel-http-response-test_seekable-response.c"
	{
		GUPnPContext* _tmp0_;
		GUPnPContext* _tmp1_;
#line 151 "rygel-http-response-test_seekable-response.vala"
		_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 639 "rygel-http-response-test_seekable-response.c"
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
#line 151 "rygel-http-response-test_seekable-response.vala"
		self->context = (_tmp1_ = _tmp0_, _g_object_unref0 (self->context), _tmp1_);
#line 645 "rygel-http-response-test_seekable-response.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
			{
				_g_error_free0 (_error_);
				goto __finally6;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 156 "rygel-http-response-test_seekable-response.vala"
	g_assert (self->context != NULL);
#line 157 "rygel-http-response-test_seekable-response.vala"
	g_assert (gssdp_client_get_host_ip ((GSSDPClient*) self->context) != NULL);
#line 158 "rygel-http-response-test_seekable-response.vala"
	g_assert (gupnp_context_get_port (self->context) > 0);
#line 160 "rygel-http-response-test_seekable-response.vala"
	soup_server_add_handler (gupnp_context_get_server (self->context), RYGEL_HTTP_SERVER_SERVER_PATH, _rygel_http_server_server_cb_soup_server_callback, g_object_ref (self), g_object_unref);
#line 161 "rygel-http-response-test_seekable-response.vala"
	g_signal_connect_object (gupnp_context_get_server (self->context), "request-aborted", (GCallback) _rygel_http_server_on_request_aborted_soup_server_request_aborted, self, 0);
#line 684 "rygel-http-response-test_seekable-response.c"
	return self;
}


#line 149 "rygel-http-response-test_seekable-response.vala"
RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 149 "rygel-http-response-test_seekable-response.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 693 "rygel-http-response-test_seekable-response.c"
}


#line 164 "rygel-http-response-test_seekable-response.vala"
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const char* path, GHashTable* query, SoupClientContext* client) {
#line 164 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (self != NULL);
#line 164 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (server != NULL);
#line 164 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (msg != NULL);
#line 164 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (path != NULL);
#line 164 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (client != NULL);
#line 169 "rygel-http-response-test_seekable-response.vala"
	soup_server_pause_message (gupnp_context_get_server (self->context), msg);
#line 170 "rygel-http-response-test_seekable-response.vala"
	g_signal_emit_by_name (self, "message-received", msg);
#line 713 "rygel-http-response-test_seekable-response.c"
}


#line 173 "rygel-http-response-test_seekable-response.vala"
static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client) {
#line 173 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (self != NULL);
#line 173 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (server != NULL);
#line 173 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (message != NULL);
#line 173 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (client != NULL);
#line 176 "rygel-http-response-test_seekable-response.vala"
	g_signal_emit_by_name (self, "message-aborted", message);
#line 729 "rygel-http-response-test_seekable-response.c"
}


char* rygel_http_server_get_uri (RygelHTTPServer* self) {
	char* result;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp4_ = g_strconcat (_tmp3_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat ("http://", gssdp_client_get_host_ip ((GSSDPClient*) self->context), NULL), ":", NULL), _tmp2_ = g_strdup_printf ("%u", gupnp_context_get_port (self->context)), NULL), RYGEL_HTTP_SERVER_SERVER_PATH, NULL), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp4_);
#line 139 "rygel-http-response-test_seekable-response.vala"
	return result;
#line 744 "rygel-http-response-test_seekable-response.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = rygel_http_server_get_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SOUP_TYPE_MESSAGE);
	g_signal_new ("message_aborted", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SOUP_TYPE_MESSAGE);
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (obj);
	_g_object_unref0 (self->context);
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_URI:
		g_value_take_string (value, rygel_http_server_get_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


#line 230 "rygel-http-response-test_seekable-response.vala"
static void _rygel_http_client_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
#line 798 "rygel-http-response-test_seekable-response.c"
	rygel_http_client_on_cancelled (self, _sender);
}


#line 187 "rygel-http-response-test_seekable-response.vala"
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const char* uri, gsize total_bytes, gboolean active) {
#line 805 "rygel-http-response-test_seekable-response.c"
	RygelHTTPClient * self;
	GUPnPContext* _tmp0_;
	SoupMessage* _tmp1_;
#line 187 "rygel-http-response-test_seekable-response.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 187 "rygel-http-response-test_seekable-response.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 187 "rygel-http-response-test_seekable-response.vala"
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
#line 191 "rygel-http-response-test_seekable-response.vala"
	self->context = (_tmp0_ = _g_object_ref0 (context), _g_object_unref0 (self->context), _tmp0_);
#line 192 "rygel-http-response-test_seekable-response.vala"
	self->total_bytes = total_bytes;
#line 194 "rygel-http-response-test_seekable-response.vala"
	self->msg = (_tmp1_ = soup_message_new ("HTTP", uri), _g_object_unref0 (self->msg), _tmp1_);
#line 195 "rygel-http-response-test_seekable-response.vala"
	g_assert (self->msg != NULL);
#line 196 "rygel-http-response-test_seekable-response.vala"
	soup_message_body_set_accumulate (self->msg->response_body, FALSE);
#line 198 "rygel-http-response-test_seekable-response.vala"
	if (active) {
#line 827 "rygel-http-response-test_seekable-response.c"
		GCancellable* _tmp2_;
#line 199 "rygel-http-response-test_seekable-response.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp2_ = g_cancellable_new ());
#line 831 "rygel-http-response-test_seekable-response.c"
		_g_object_unref0 (_tmp2_);
#line 200 "rygel-http-response-test_seekable-response.vala"
		g_signal_connect_object (rygel_state_machine_get_cancellable ((RygelStateMachine*) self), "cancelled", (GCallback) _rygel_http_client_on_cancelled_g_cancellable_cancelled, self, 0);
#line 835 "rygel-http-response-test_seekable-response.c"
	}
	return self;
}


#line 187 "rygel-http-response-test_seekable-response.vala"
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const char* uri, gsize total_bytes, gboolean active) {
#line 187 "rygel-http-response-test_seekable-response.vala"
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context, uri, total_bytes, active);
#line 845 "rygel-http-response-test_seekable-response.c"
}


static void rygel_http_client_real_run_data_free (gpointer _data) {
	RygelHttpClientRunData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelHttpClientRunData, data);
}


static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPClient * self;
	RygelHttpClientRunData* _data_;
	self = (RygelHTTPClient*) base;
	_data_ = g_slice_new0 (RygelHttpClientRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_real_run_data_free);
	_data_->self = g_object_ref (self);
	rygel_http_client_real_run_co (_data_);
}


static void rygel_http_client_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_client_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpClientRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_client_real_run_co (data);
}


#line 204 "rygel-http-response-test_seekable-response.vala"
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self) {
#line 885 "rygel-http-response-test_seekable-response.c"
	gboolean result;
	result = rygel_http_client_real_run_co (self);
	return result;
}


#line 208 "rygel-http-response-test_seekable-response.vala"
static void _lambda0_ (SoupMessage* msg, SoupBuffer* chunk, Block1Data* _data1_) {
#line 894 "rygel-http-response-test_seekable-response.c"
	RygelHTTPClient * self;
	gboolean _tmp0_ = FALSE;
	self = _data1_->self;
#line 208 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (msg != NULL);
#line 208 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (chunk != NULL);
#line 209 "rygel-http-response-test_seekable-response.vala"
	_data1_->bytes_received = _data1_->bytes_received + chunk->length;
#line 211 "rygel-http-response-test_seekable-response.vala"
	if (_data1_->bytes_received >= self->total_bytes) {
#line 212 "rygel-http-response-test_seekable-response.vala"
		_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self) != NULL;
#line 908 "rygel-http-response-test_seekable-response.c"
	} else {
#line 211 "rygel-http-response-test_seekable-response.vala"
		_tmp0_ = FALSE;
#line 912 "rygel-http-response-test_seekable-response.c"
	}
#line 211 "rygel-http-response-test_seekable-response.vala"
	if (_tmp0_) {
#line 213 "rygel-http-response-test_seekable-response.vala"
		_data1_->bytes_received = CLAMP (_data1_->bytes_received, (gsize) 0, self->total_bytes);
#line 215 "rygel-http-response-test_seekable-response.vala"
		g_cancellable_cancel (rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 920 "rygel-http-response-test_seekable-response.c"
	}
}


#line 208 "rygel-http-response-test_seekable-response.vala"
static void __lambda0__soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
#line 927 "rygel-http-response-test_seekable-response.c"
	_lambda0_ (_sender, chunk, self);
}


#line 219 "rygel-http-response-test_seekable-response.vala"
static void _lambda1_ (SoupSession* session, SoupMessage* msg, Block1Data* _data1_) {
#line 934 "rygel-http-response-test_seekable-response.c"
	RygelHTTPClient * self;
	self = _data1_->self;
#line 219 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (session != NULL);
#line 219 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (msg != NULL);
#line 220 "rygel-http-response-test_seekable-response.vala"
	g_assert (_data1_->bytes_received == self->total_bytes);
#line 222 "rygel-http-response-test_seekable-response.vala"
	_data1_->run_continue (_data1_->run_continue_target);
#line 945 "rygel-http-response-test_seekable-response.c"
}


#line 219 "rygel-http-response-test_seekable-response.vala"
static void __lambda1__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
#line 951 "rygel-http-response-test_seekable-response.c"
	_lambda1_ (session, msg, self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		(_data1_->run_continue_target_destroy_notify == NULL) ? NULL : (_data1_->run_continue_target_destroy_notify (_data1_->run_continue_target), NULL);
		_data1_->run_continue = NULL;
		_data1_->run_continue_target = NULL;
		_data1_->run_continue_target_destroy_notify = NULL;
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 10:
		goto _state_10;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_data1_ = g_slice_new0 (Block1Data);
		data->_data1_->_ref_count_ = 1;
		data->_data1_->self = g_object_ref (data->self);
		data->_data1_->_async_data_ = data;
		data->_data1_->run_continue = (data->_tmp0_ = _rygel_http_client_real_run_co_gsource_func, data->_data1_->run_continue_target = data, data->_data1_->run_continue_target_destroy_notify = NULL, data->_tmp0_);
		data->_data1_->bytes_received = (gsize) 0;
#line 208 "rygel-http-response-test_seekable-response.vala"
		g_signal_connect_data (data->self->msg, "got-chunk", (GCallback) __lambda0__soup_message_got_chunk, block1_data_ref (data->_data1_), (GClosureNotify) block1_data_unref, 0);
#line 219 "rygel-http-response-test_seekable-response.vala"
		soup_session_queue_message (gupnp_context_get_session (data->self->context), _g_object_ref0 (data->self->msg), __lambda1__soup_session_callback, data->_data1_);
#line 995 "rygel-http-response-test_seekable-response.c"
		data->_state_ = 10;
		return FALSE;
		_state_10:
		;
#line 227 "rygel-http-response-test_seekable-response.vala"
		g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
#line 1002 "rygel-http-response-test_seekable-response.c"
		block1_data_unref (data->_data1_);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 230 "rygel-http-response-test_seekable-response.vala"
static void rygel_http_client_on_cancelled (RygelHTTPClient* self, GCancellable* cancellable) {
#line 230 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (self != NULL);
#line 230 "rygel-http-response-test_seekable-response.vala"
	g_return_if_fail (cancellable != NULL);
#line 231 "rygel-http-response-test_seekable-response.vala"
	soup_session_cancel_message (gupnp_context_get_session (self->context), self->msg, (guint) SOUP_STATUS_CANCELLED);
#line 233 "rygel-http-response-test_seekable-response.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 1027 "rygel-http-response-test_seekable-response.c"
}


static GCancellable* rygel_http_client_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPClient* self;
	self = (RygelHTTPClient*) base;
	result = self->priv->_cancellable;
#line 185 "rygel-http-response-test_seekable-response.vala"
	return result;
#line 1038 "rygel-http-response-test_seekable-response.c"
}


static void rygel_http_client_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
	self = (RygelHTTPClient*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPClientPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_http_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_http_client_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_CLIENT_CANCELLABLE, "cancellable");
}


static void rygel_http_client_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_client_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_http_client_real_run;
	iface->run_finish = rygel_http_client_real_run_finish;
	iface->get_cancellable = rygel_http_client_real_get_cancellable;
	iface->set_cancellable = rygel_http_client_real_set_cancellable;
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
	self->priv = RYGEL_HTTP_CLIENT_GET_PRIVATE (self);
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (obj);
	_g_object_unref0 (self->context);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_client_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_client_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static void rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
	switch (property_id) {
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
	switch (property_id) {
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




