/* rygel-http-response-test.c generated by valac, the Vala compiler
 * generated from rygel-http-response-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_RESPONSE_TEST (rygel_http_response_test_get_type ())
#define RYGEL_HTTP_RESPONSE_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTest))
#define RYGEL_HTTP_RESPONSE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestClass))
#define RYGEL_IS_HTTP_RESPONSE_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST))
#define RYGEL_IS_HTTP_RESPONSE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_TEST))
#define RYGEL_HTTP_RESPONSE_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestClass))

typedef struct _RygelHTTPResponseTest RygelHTTPResponseTest;
typedef struct _RygelHTTPResponseTestClass RygelHTTPResponseTestClass;
typedef struct _RygelHTTPResponseTestPrivate RygelHTTPResponseTestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_DUMMY_RESPONSE (rygel_http_dummy_response_get_type ())
#define RYGEL_HTTP_DUMMY_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_DUMMY_RESPONSE, RygelHTTPDummyResponse))
#define RYGEL_HTTP_DUMMY_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_DUMMY_RESPONSE, RygelHTTPDummyResponseClass))
#define RYGEL_IS_HTTP_DUMMY_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_DUMMY_RESPONSE))
#define RYGEL_IS_HTTP_DUMMY_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_DUMMY_RESPONSE))
#define RYGEL_HTTP_DUMMY_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_DUMMY_RESPONSE, RygelHTTPDummyResponseClass))

typedef struct _RygelHTTPDummyResponse RygelHTTPDummyResponse;
typedef struct _RygelHTTPDummyResponseClass RygelHTTPDummyResponseClass;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;
typedef struct _RygelHTTPDummyResponsePrivate RygelHTTPDummyResponsePrivate;
typedef struct _Block2Data Block2Data;
typedef struct _RygelHttpDummyResponseRunData RygelHttpDummyResponseRunData;
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _Block3Data Block3Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPResponseTest {
	GObject parent_instance;
	RygelHTTPResponseTestPrivate * priv;
};

struct _RygelHTTPResponseTestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPResponseTestPrivate {
	RygelHTTPServer* server;
	RygelHTTPClient* client;
	GMainLoop* main_loop;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPResponseTest * self;
	GError* _error_;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
	SoupMessage* msg;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelHTTPResponse* self, GAsyncResult* _res_);
	void (*end) (RygelHTTPResponse* self, gboolean aborted, guint status);
};

struct _RygelHTTPDummyResponse {
	RygelHTTPResponse parent_instance;
	RygelHTTPDummyResponsePrivate * priv;
};

struct _RygelHTTPDummyResponseClass {
	RygelHTTPResponseClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	RygelHTTPDummyResponse * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpDummyResponseRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPDummyResponse* self;
	GSourceFunc _tmp0_;
	Block2Data* _data2_;
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	RygelHTTPClient * self;
	SoupMessage* msg;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	char* uri;
	GSourceFunc _tmp0_;
	Block3Data* _data3_;
};


static gpointer rygel_http_response_test_parent_class = NULL;
static gpointer rygel_http_dummy_response_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_response_test_get_type (void);
GType rygel_http_server_get_type (void);
GType rygel_http_client_get_type (void);
#define RYGEL_HTTP_RESPONSE_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestPrivate))
enum  {
	RYGEL_HTTP_RESPONSE_TEST_DUMMY_PROPERTY
};
static RygelHTTPResponseTest* rygel_http_response_test_new (GError** error);
static RygelHTTPResponseTest* rygel_http_response_test_construct (GType object_type, GError** error);
static void rygel_http_response_test_run (RygelHTTPResponseTest* self, GError** error);
gint rygel_http_response_test_main (char** args, int args_length1);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context);
static gboolean _lambda2_ (Block1Data* _data1_);
static gboolean __lambda2__gsource_func (gpointer self);
static void rygel_http_response_test_on_message_received (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_response_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
void rygel_http_client_run (RygelHTTPClient* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_client_run_finish (RygelHTTPClient* self, GAsyncResult* _res_);
char* rygel_http_server_get_uri (RygelHTTPServer* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
RygelHTTPDummyResponse* rygel_http_dummy_response_new (SoupServer* server, SoupMessage* msg, gboolean partial, GCancellable* cancellable);
RygelHTTPDummyResponse* rygel_http_dummy_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, gboolean partial, GCancellable* cancellable);
GType rygel_http_response_get_type (void);
GType rygel_http_dummy_response_get_type (void);
GType rygel_state_machine_get_type (void);
static void _lambda3_ (RygelHTTPResponseTest* self);
static void __lambda3__rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_http_response_run (RygelHTTPResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_response_run_finish (RygelHTTPResponse* self, GAsyncResult* _res_);
static void rygel_http_response_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_DUMMY_RESPONSE_DUMMY_PROPERTY
};
#define RYGEL_HTTP_DUMMY_RESPONSE_RESPONSE_DATA "THIS IS VALA!"
RygelHTTPResponse* rygel_http_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, gboolean partial, GCancellable* cancellable);
static void rygel_http_dummy_response_real_run_data_free (gpointer _data);
static void rygel_http_dummy_response_real_run (RygelHTTPResponse* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_dummy_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
SoupServer* rygel_http_response_get_server (RygelHTTPResponse* self);
static gboolean _rygel_http_dummy_response_real_run_co_gsource_func (gpointer self);
static gboolean _lambda1_ (Block2Data* _data2_);
static gboolean __lambda1__gsource_func (gpointer self);
void rygel_http_response_push_data (RygelHTTPResponse* self, void* data, gsize length);
void rygel_http_response_end (RygelHTTPResponse* self, gboolean aborted, guint status);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean rygel_http_dummy_response_real_run_co (RygelHttpDummyResponseRunData* data);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const char* path, GHashTable* query, SoupClientContext* client);
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const char* path, GHashTable* query, SoupClientContext* client, gpointer self);
static void rygel_http_server_finalize (GObject* obj);
static void rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY
};
static void rygel_http_client_run_data_free (gpointer _data);
static void rygel_http_client_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _rygel_http_client_run_co_gsource_func (gpointer self);
static void _lambda0_ (SoupSession* m, Block3Data* _data3_);
static void __lambda0__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean rygel_http_client_run_co (RygelHttpClientRunData* data);
static void rygel_http_client_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


#line 37 "rygel-http-response-test.vala"
gint rygel_http_response_test_main (char** args, int args_length1) {
#line 314 "rygel-http-response-test.c"
	gint result = 0;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		RygelHTTPResponseTest* test;
#line 39 "rygel-http-response-test.vala"
		test = rygel_http_response_test_new (&_inner_error_);
#line 322 "rygel-http-response-test.c"
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 41 "rygel-http-response-test.vala"
		rygel_http_response_test_run (test, &_inner_error_);
#line 331 "rygel-http-response-test.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (test);
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (test);
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			result = _error_->code;
			_g_error_free0 (_error_);
#line 43 "rygel-http-response-test.vala"
			return result;
#line 352 "rygel-http-response-test.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 45 "rygel-http-response-test.vala"
			g_critical ("rygel-http-response-test.vala:45: %s", _error_->message);
#line 364 "rygel-http-response-test.c"
			result = -1;
			_g_error_free0 (_error_);
#line 47 "rygel-http-response-test.vala"
			return result;
#line 369 "rygel-http-response-test.c"
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
#line 50 "rygel-http-response-test.vala"
	return result;
#line 381 "rygel-http-response-test.c"
}


#line 37 "rygel-http-response-test.vala"
int main (int argc, char ** argv) {
#line 387 "rygel-http-response-test.c"
	g_thread_init (NULL);
#line 37 "rygel-http-response-test.vala"
	g_type_init ();
#line 37 "rygel-http-response-test.vala"
	return rygel_http_response_test_main (argv, argc);
#line 393 "rygel-http-response-test.c"
}


#line 53 "rygel-http-response-test.vala"
static RygelHTTPResponseTest* rygel_http_response_test_construct (GType object_type, GError** error) {
#line 399 "rygel-http-response-test.c"
	GError * _inner_error_;
	RygelHTTPResponseTest * self;
	RygelHTTPServer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPClient* _tmp2_;
	GMainLoop* _tmp3_;
	_inner_error_ = NULL;
#line 53 "rygel-http-response-test.vala"
	self = (RygelHTTPResponseTest*) g_object_new (object_type, NULL);
#line 54 "rygel-http-response-test.vala"
	_tmp0_ = rygel_http_server_new (&_inner_error_);
#line 411 "rygel-http-response-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			g_object_unref (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 54 "rygel-http-response-test.vala"
	self->priv->server = (_tmp1_ = _tmp0_, _g_object_unref0 (self->priv->server), _tmp1_);
#line 55 "rygel-http-response-test.vala"
	self->priv->client = (_tmp2_ = rygel_http_client_new (self->priv->server->context), _g_object_unref0 (self->priv->client), _tmp2_);
#line 56 "rygel-http-response-test.vala"
	self->priv->main_loop = (_tmp3_ = g_main_loop_new (NULL, FALSE), _g_main_loop_unref0 (self->priv->main_loop), _tmp3_);
#line 429 "rygel-http-response-test.c"
	return self;
}


#line 53 "rygel-http-response-test.vala"
static RygelHTTPResponseTest* rygel_http_response_test_new (GError** error) {
#line 53 "rygel-http-response-test.vala"
	return rygel_http_response_test_construct (RYGEL_TYPE_HTTP_RESPONSE_TEST, error);
#line 438 "rygel-http-response-test.c"
}


#line 62 "rygel-http-response-test.vala"
static gboolean _lambda2_ (Block1Data* _data1_) {
#line 444 "rygel-http-response-test.c"
	RygelHTTPResponseTest * self;
	gboolean result = FALSE;
	GError* _tmp0_;
	self = _data1_->self;
#line 63 "rygel-http-response-test.vala"
	_data1_->_error_ = (_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout"), _g_error_free0 (_data1_->_error_), _tmp0_);
#line 64 "rygel-http-response-test.vala"
	g_main_loop_quit (self->priv->main_loop);
#line 453 "rygel-http-response-test.c"
	result = FALSE;
#line 66 "rygel-http-response-test.vala"
	return result;
#line 457 "rygel-http-response-test.c"
}


#line 62 "rygel-http-response-test.vala"
static gboolean __lambda2__gsource_func (gpointer self) {
#line 463 "rygel-http-response-test.c"
	return _lambda2_ (self);
}


#line 80 "rygel-http-response-test.vala"
static void _rygel_http_response_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
#line 470 "rygel-http-response-test.c"
	rygel_http_response_test_on_message_received (self, _sender, message);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	++_data1_->_ref_count_;
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if ((--_data1_->_ref_count_) == 0) {
		_g_object_unref0 (_data1_->self);
		_g_error_free0 (_data1_->_error_);
		g_slice_free (Block1Data, _data1_);
	}
}


#line 59 "rygel-http-response-test.vala"
static void rygel_http_response_test_run (RygelHTTPResponseTest* self, GError** error) {
#line 497 "rygel-http-response-test.c"
	GError * _inner_error_;
	Block1Data* _data1_;
	char* _tmp0_;
#line 59 "rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 503 "rygel-http-response-test.c"
	_inner_error_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->_error_ = NULL;
#line 62 "rygel-http-response-test.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, __lambda2__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 69 "rygel-http-response-test.vala"
	g_signal_connect_object (self->priv->server, "message-received", (GCallback) _rygel_http_response_test_on_message_received_rygel_http_server_message_received, self, 0);
#line 71 "rygel-http-response-test.vala"
	rygel_http_client_run (self->priv->client, _tmp0_ = rygel_http_server_get_uri (self->priv->server), NULL, NULL);
#line 515 "rygel-http-response-test.c"
	_g_free0 (_tmp0_);
#line 73 "rygel-http-response-test.vala"
	g_main_loop_run (self->priv->main_loop);
#line 75 "rygel-http-response-test.vala"
	if (_data1_->_error_ != NULL) {
#line 521 "rygel-http-response-test.c"
		_inner_error_ = _g_error_copy0 (_data1_->_error_);
		{
			g_propagate_error (error, _inner_error_);
			block1_data_unref (_data1_);
			return;
		}
	}
	block1_data_unref (_data1_);
}


#line 87 "rygel-http-response-test.vala"
static void _lambda3_ (RygelHTTPResponseTest* self) {
#line 88 "rygel-http-response-test.vala"
	g_main_loop_quit (self->priv->main_loop);
#line 537 "rygel-http-response-test.c"
}


#line 87 "rygel-http-response-test.vala"
static void __lambda3__rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 543 "rygel-http-response-test.c"
	_lambda3_ (self);
}


#line 80 "rygel-http-response-test.vala"
static void rygel_http_response_test_on_message_received (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg) {
#line 550 "rygel-http-response-test.c"
	RygelHTTPDummyResponse* response;
#line 80 "rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 80 "rygel-http-response-test.vala"
	g_return_if_fail (server != NULL);
#line 80 "rygel-http-response-test.vala"
	g_return_if_fail (msg != NULL);
#line 82 "rygel-http-response-test.vala"
	response = rygel_http_dummy_response_new (gupnp_context_get_server (self->priv->server->context), msg, FALSE, NULL);
#line 87 "rygel-http-response-test.vala"
	g_signal_connect_object ((RygelStateMachine*) response, "completed", (GCallback) __lambda3__rygel_state_machine_completed, self, 0);
#line 91 "rygel-http-response-test.vala"
	rygel_http_response_run ((RygelHTTPResponse*) response, NULL, NULL);
#line 564 "rygel-http-response-test.c"
	_g_object_unref0 (response);
}


static void rygel_http_response_test_class_init (RygelHTTPResponseTestClass * klass) {
	rygel_http_response_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPResponseTestPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_test_finalize;
}


static void rygel_http_response_test_instance_init (RygelHTTPResponseTest * self) {
	self->priv = RYGEL_HTTP_RESPONSE_TEST_GET_PRIVATE (self);
}


static void rygel_http_response_test_finalize (GObject* obj) {
	RygelHTTPResponseTest * self;
	self = RYGEL_HTTP_RESPONSE_TEST (obj);
	_g_object_unref0 (self->priv->server);
	_g_object_unref0 (self->priv->client);
	_g_main_loop_unref0 (self->priv->main_loop);
	G_OBJECT_CLASS (rygel_http_response_test_parent_class)->finalize (obj);
}


GType rygel_http_response_test_get_type (void) {
	static volatile gsize rygel_http_response_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponseTest), 0, (GInstanceInitFunc) rygel_http_response_test_instance_init, NULL };
		GType rygel_http_response_test_type_id;
		rygel_http_response_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponseTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_response_test_type_id__volatile, rygel_http_response_test_type_id);
	}
	return rygel_http_response_test_type_id__volatile;
}


#line 98 "rygel-http-response-test.vala"
RygelHTTPDummyResponse* rygel_http_dummy_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, gboolean partial, GCancellable* cancellable) {
#line 605 "rygel-http-response-test.c"
	RygelHTTPDummyResponse * self;
#line 98 "rygel-http-response-test.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 98 "rygel-http-response-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 102 "rygel-http-response-test.vala"
	self = (RygelHTTPDummyResponse*) rygel_http_response_construct (object_type, server, msg, partial, cancellable);
#line 613 "rygel-http-response-test.c"
	return self;
}


#line 98 "rygel-http-response-test.vala"
RygelHTTPDummyResponse* rygel_http_dummy_response_new (SoupServer* server, SoupMessage* msg, gboolean partial, GCancellable* cancellable) {
#line 98 "rygel-http-response-test.vala"
	return rygel_http_dummy_response_construct (RYGEL_TYPE_HTTP_DUMMY_RESPONSE, server, msg, partial, cancellable);
#line 622 "rygel-http-response-test.c"
}


static void rygel_http_dummy_response_real_run_data_free (gpointer _data) {
	RygelHttpDummyResponseRunData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelHttpDummyResponseRunData, data);
}


static void rygel_http_dummy_response_real_run (RygelHTTPResponse* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPDummyResponse * self;
	RygelHttpDummyResponseRunData* _data_;
	self = (RygelHTTPDummyResponse*) base;
	_data_ = g_slice_new0 (RygelHttpDummyResponseRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_dummy_response_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_dummy_response_real_run_data_free);
	_data_->self = g_object_ref (self);
	rygel_http_dummy_response_real_run_co (_data_);
}


static void rygel_http_dummy_response_real_run_finish (RygelHTTPResponse* base, GAsyncResult* _res_) {
	RygelHttpDummyResponseRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_dummy_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpDummyResponseRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_dummy_response_real_run_co (data);
}


#line 105 "rygel-http-response-test.vala"
static gboolean _rygel_http_dummy_response_real_run_co_gsource_func (gpointer self) {
#line 662 "rygel-http-response-test.c"
	return rygel_http_dummy_response_real_run_co (self);
}


#line 110 "rygel-http-response-test.vala"
static gboolean _lambda1_ (Block2Data* _data2_) {
#line 669 "rygel-http-response-test.c"
	RygelHTTPDummyResponse * self;
	gboolean result = FALSE;
	self = _data2_->self;
#line 111 "rygel-http-response-test.vala"
	_data2_->run_continue (_data2_->run_continue_target);
#line 675 "rygel-http-response-test.c"
	result = FALSE;
#line 113 "rygel-http-response-test.vala"
	return result;
#line 679 "rygel-http-response-test.c"
}


#line 110 "rygel-http-response-test.vala"
static gboolean __lambda1__gsource_func (gpointer self) {
#line 685 "rygel-http-response-test.c"
	return _lambda1_ (self);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
#line 1062 "glib-2.0.vapi"
	return result;
#line 696 "rygel-http-response-test.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	++_data2_->_ref_count_;
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if ((--_data2_->_ref_count_) == 0) {
		_g_object_unref0 (_data2_->self);
		(_data2_->run_continue_target_destroy_notify == NULL) ? NULL : _data2_->run_continue_target_destroy_notify (_data2_->run_continue_target);
		_data2_->run_continue = NULL;
		_data2_->run_continue_target = NULL;
		_data2_->run_continue_target_destroy_notify = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean rygel_http_dummy_response_real_run_co (RygelHttpDummyResponseRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_data2_ = g_slice_new0 (Block2Data);
		data->_data2_->_ref_count_ = 1;
		data->_data2_->self = g_object_ref (data->self);
		data->_data2_->_async_data_ = data;
#line 106 "rygel-http-response-test.vala"
		soup_server_pause_message (rygel_http_response_get_server ((RygelHTTPResponse*) data->self), ((RygelHTTPResponse*) data->self)->msg);
#line 735 "rygel-http-response-test.c"
		data->_data2_->run_continue = (data->_tmp0_ = _rygel_http_dummy_response_real_run_co_gsource_func, data->_data2_->run_continue_target = data, data->_data2_->run_continue_target_destroy_notify = NULL, data->_tmp0_);
#line 110 "rygel-http-response-test.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda1__gsource_func, block2_data_ref (data->_data2_), block2_data_unref);
#line 739 "rygel-http-response-test.c"
		data->_state_ = 1;
		return FALSE;
		_state_1:
		;
#line 118 "rygel-http-response-test.vala"
		rygel_http_response_push_data ((RygelHTTPResponse*) data->self, RYGEL_HTTP_DUMMY_RESPONSE_RESPONSE_DATA, (gsize) string_get_length (RYGEL_HTTP_DUMMY_RESPONSE_RESPONSE_DATA));
#line 120 "rygel-http-response-test.vala"
		rygel_http_response_end ((RygelHTTPResponse*) data->self, FALSE, (guint) SOUP_STATUS_NONE);
#line 748 "rygel-http-response-test.c"
		block2_data_unref (data->_data2_);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_http_dummy_response_class_init (RygelHTTPDummyResponseClass * klass) {
	rygel_http_dummy_response_parent_class = g_type_class_peek_parent (klass);
	RYGEL_HTTP_RESPONSE_CLASS (klass)->run = rygel_http_dummy_response_real_run;
	RYGEL_HTTP_RESPONSE_CLASS (klass)->run_finish = rygel_http_dummy_response_real_run_finish;
}


static void rygel_http_dummy_response_instance_init (RygelHTTPDummyResponse * self) {
}


GType rygel_http_dummy_response_get_type (void) {
	static volatile gsize rygel_http_dummy_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_dummy_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPDummyResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_dummy_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPDummyResponse), 0, (GInstanceInitFunc) rygel_http_dummy_response_instance_init, NULL };
		GType rygel_http_dummy_response_type_id;
		rygel_http_dummy_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE, "RygelHTTPDummyResponse", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_dummy_response_type_id__volatile, rygel_http_dummy_response_type_id);
	}
	return rygel_http_dummy_response_type_id__volatile;
}


#line 153 "rygel-http-response-test.vala"
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const char* path, GHashTable* query, SoupClientContext* client, gpointer self) {
#line 788 "rygel-http-response-test.c"
	rygel_http_server_server_cb (self, server, msg, path, query, client);
}


#line 139 "rygel-http-response-test.vala"
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
#line 795 "rygel-http-response-test.c"
	GError * _inner_error_;
	RygelHTTPServer * self;
	_inner_error_ = NULL;
#line 139 "rygel-http-response-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 801 "rygel-http-response-test.c"
	{
		GUPnPContext* _tmp0_;
		GUPnPContext* _tmp1_;
#line 141 "rygel-http-response-test.vala"
		_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 807 "rygel-http-response-test.c"
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
#line 141 "rygel-http-response-test.vala"
		self->context = (_tmp1_ = _tmp0_, _g_object_unref0 (self->context), _tmp1_);
#line 813 "rygel-http-response-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
			{
				_g_error_free0 (_error_);
				goto __finally1;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			g_object_unref (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 146 "rygel-http-response-test.vala"
	g_assert (self->context != NULL);
#line 147 "rygel-http-response-test.vala"
	g_assert (gssdp_client_get_host_ip ((GSSDPClient*) self->context) != NULL);
#line 148 "rygel-http-response-test.vala"
	g_assert (gupnp_context_get_port (self->context) > 0);
#line 150 "rygel-http-response-test.vala"
	soup_server_add_handler (gupnp_context_get_server (self->context), RYGEL_HTTP_SERVER_SERVER_PATH, _rygel_http_server_server_cb_soup_server_callback, g_object_ref (self), g_object_unref);
#line 850 "rygel-http-response-test.c"
	return self;
}


#line 139 "rygel-http-response-test.vala"
RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 139 "rygel-http-response-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 859 "rygel-http-response-test.c"
}


#line 153 "rygel-http-response-test.vala"
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const char* path, GHashTable* query, SoupClientContext* client) {
#line 153 "rygel-http-response-test.vala"
	g_return_if_fail (self != NULL);
#line 153 "rygel-http-response-test.vala"
	g_return_if_fail (server != NULL);
#line 153 "rygel-http-response-test.vala"
	g_return_if_fail (msg != NULL);
#line 153 "rygel-http-response-test.vala"
	g_return_if_fail (path != NULL);
#line 153 "rygel-http-response-test.vala"
	g_return_if_fail (client != NULL);
#line 158 "rygel-http-response-test.vala"
	g_signal_emit_by_name (self, "message-received", msg);
#line 877 "rygel-http-response-test.c"
}


char* rygel_http_server_get_uri (RygelHTTPServer* self) {
	char* result;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp4_ = g_strconcat (_tmp3_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat ("http://", gssdp_client_get_host_ip ((GSSDPClient*) self->context), NULL), ":", NULL), _tmp2_ = g_strdup_printf ("%u", gupnp_context_get_port (self->context)), NULL), RYGEL_HTTP_SERVER_SERVER_PATH, NULL), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp4_);
#line 130 "rygel-http-response-test.vala"
	return result;
#line 892 "rygel-http-response-test.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = rygel_http_server_get_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SOUP_TYPE_MESSAGE);
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (obj);
	_g_object_unref0 (self->context);
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_URI:
		g_value_take_string (value, rygel_http_server_get_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 165 "rygel-http-response-test.vala"
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context) {
#line 950 "rygel-http-response-test.c"
	RygelHTTPClient * self;
	GUPnPContext* _tmp0_;
#line 165 "rygel-http-response-test.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 165 "rygel-http-response-test.vala"
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
#line 166 "rygel-http-response-test.vala"
	self->context = (_tmp0_ = _g_object_ref0 (context), _g_object_unref0 (self->context), _tmp0_);
#line 959 "rygel-http-response-test.c"
	return self;
}


#line 165 "rygel-http-response-test.vala"
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context) {
#line 165 "rygel-http-response-test.vala"
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context);
#line 968 "rygel-http-response-test.c"
}


static void rygel_http_client_run_data_free (gpointer _data) {
	RygelHttpClientRunData* data;
	data = _data;
	_g_free0 (data->uri);
	g_object_unref (data->self);
	g_slice_free (RygelHttpClientRunData, data);
}


void rygel_http_client_run (RygelHTTPClient* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpClientRunData* _data_;
	_data_ = g_slice_new0 (RygelHttpClientRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_run_data_free);
	_data_->self = g_object_ref (self);
	_data_->uri = g_strdup (uri);
	rygel_http_client_run_co (_data_);
}


void rygel_http_client_run_finish (RygelHTTPClient* self, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_client_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpClientRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_client_run_co (data);
}


#line 169 "rygel-http-response-test.vala"
static gboolean _rygel_http_client_run_co_gsource_func (gpointer self) {
#line 1008 "rygel-http-response-test.c"
	return rygel_http_client_run_co (self);
}


#line 175 "rygel-http-response-test.vala"
static void _lambda0_ (SoupSession* m, Block3Data* _data3_) {
#line 1015 "rygel-http-response-test.c"
	RygelHTTPClient * self;
	self = _data3_->self;
#line 175 "rygel-http-response-test.vala"
	g_return_if_fail (m != NULL);
#line 176 "rygel-http-response-test.vala"
	g_assert (_data3_->msg->response_body->length == string_get_length (RYGEL_HTTP_DUMMY_RESPONSE_RESPONSE_DATA));
#line 178 "rygel-http-response-test.vala"
	g_assert (_vala_strcmp0 ((const char*) _data3_->msg->response_body, RYGEL_HTTP_DUMMY_RESPONSE_RESPONSE_DATA) == 0);
#line 181 "rygel-http-response-test.vala"
	_data3_->run_continue (_data3_->run_continue_target);
#line 1026 "rygel-http-response-test.c"
}


#line 175 "rygel-http-response-test.vala"
static void __lambda0__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
#line 1032 "rygel-http-response-test.c"
	_lambda0_ (session, self);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	++_data3_->_ref_count_;
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if ((--_data3_->_ref_count_) == 0) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->msg);
		(_data3_->run_continue_target_destroy_notify == NULL) ? NULL : _data3_->run_continue_target_destroy_notify (_data3_->run_continue_target);
		_data3_->run_continue = NULL;
		_data3_->run_continue_target = NULL;
		_data3_->run_continue_target_destroy_notify = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean rygel_http_client_run_co (RygelHttpClientRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_data3_ = g_slice_new0 (Block3Data);
		data->_data3_->_ref_count_ = 1;
		data->_data3_->self = g_object_ref (data->self);
		data->_data3_->_async_data_ = data;
		data->_data3_->msg = soup_message_new ("HTTP", data->uri);
#line 171 "rygel-http-response-test.vala"
		g_assert (data->_data3_->msg != NULL);
#line 1074 "rygel-http-response-test.c"
		data->_data3_->run_continue = (data->_tmp0_ = _rygel_http_client_run_co_gsource_func, data->_data3_->run_continue_target = data, data->_data3_->run_continue_target_destroy_notify = NULL, data->_tmp0_);
#line 175 "rygel-http-response-test.vala"
		soup_session_queue_message (gupnp_context_get_session (data->self->context), _g_object_ref0 (data->_data3_->msg), __lambda0__soup_session_callback, data->_data3_);
#line 1078 "rygel-http-response-test.c"
		data->_state_ = 2;
		return FALSE;
		_state_2:
		;
		block3_data_unref (data->_data3_);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (obj);
	_g_object_unref0 (self->context);
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




