/* rygel-user-config.c generated by valac, the Vala compiler
 * generated from rygel-user-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <glib/gstdio.h>
#include <gio/gio.h>


#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())

#define RYGEL_TYPE_USER_CONFIG (rygel_user_config_get_type ())
#define RYGEL_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfig))
#define RYGEL_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))
#define RYGEL_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))

typedef struct _RygelUserConfig RygelUserConfig;
typedef struct _RygelUserConfigClass RygelUserConfigClass;
typedef struct _RygelUserConfigPrivate RygelUserConfigPrivate;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	char* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	RygelLogLevel (*get_log_level) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_title) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_string) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const char* section, const char* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const char* section, const char* key, GError** error);
};

struct _RygelUserConfig {
	GObject parent_instance;
	RygelUserConfigPrivate * priv;
	GKeyFile* key_file;
};

struct _RygelUserConfigClass {
	GObjectClass parent_class;
};

struct _RygelUserConfigPrivate {
	gboolean read_only;
	DBusGProxy* dbus_obj;
	DBusGProxy* rygel_obj;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()

static RygelUserConfig* rygel_user_config_config;
static RygelUserConfig* rygel_user_config_config = NULL;
static gpointer rygel_user_config_parent_class = NULL;
static RygelConfigurationIface* rygel_user_config_rygel_configuration_parent_iface = NULL;

GType rygel_log_level_get_type (void);
GType rygel_configuration_get_type (void);
GType rygel_user_config_get_type (void);
#define RYGEL_USER_CONFIG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_USER_CONFIG, RygelUserConfigPrivate))
enum  {
	RYGEL_USER_CONFIG_DUMMY_PROPERTY
};
#define RYGEL_USER_CONFIG_CONFIG_FILE "rygel.conf"
#define RYGEL_USER_CONFIG_IFACE_KEY "interface"
#define RYGEL_USER_CONFIG_PORT_KEY "port"
#define RYGEL_USER_CONFIG_ENABLED_KEY "enabled"
#define RYGEL_USER_CONFIG_TITLE_KEY "title"
#define RYGEL_USER_CONFIG_TRANSCODING_KEY "enable-transcoding"
#define RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY "enable-mp3-transcoder"
#define RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY "enable-mp2ts-transcoder"
#define RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY "enable-lpcm-transcoder"
#define RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY "enable-wmv-transcoder"
#define RYGEL_USER_CONFIG_LOG_LEVEL_KEY "log-level"
#define RYGEL_USER_CONFIG_DBUS_SERVICE "org.freedesktop.DBus"
#define RYGEL_USER_CONFIG_DBUS_PATH "/org/freedesktop/DBus"
#define RYGEL_USER_CONFIG_DBUS_INTERFACE "org.freedesktop.DBus"
#define RYGEL_USER_CONFIG_RYGEL_SERVICE "org.gnome.Rygel1"
#define RYGEL_USER_CONFIG_RYGEL_PATH "/org/gnome/Rygel1"
#define RYGEL_USER_CONFIG_RYGEL_INTERFACE "org.gnome.Rygel1"
gboolean rygel_configuration_get_bool (RygelConfiguration* self, const char* section, const char* key, GError** error);
static gboolean rygel_user_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_upnp_enabled (RygelConfiguration* self, GError** error);
static void rygel_user_config_enable_upnp (RygelUserConfig* self, gboolean enable);
void rygel_user_config_set_upnp_enabled (RygelUserConfig* self, gboolean value);
char* rygel_configuration_get_string (RygelConfiguration* self, const char* section, const char* key, GError** error);
static char* rygel_user_config_real_get_interface (RygelConfiguration* base, GError** error);
void rygel_user_config_set_string (RygelUserConfig* self, const char* section, const char* key, const char* value);
void rygel_user_config_set_interface (RygelUserConfig* self, const char* value);
gint rygel_configuration_get_int (RygelConfiguration* self, const char* section, const char* key, gint min, gint max, GError** error);
static gint rygel_user_config_real_get_port (RygelConfiguration* base, GError** error);
void rygel_user_config_set_int (RygelUserConfig* self, const char* section, const char* key, gint value);
void rygel_user_config_set_port (RygelUserConfig* self, gint value);
static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base, GError** error);
void rygel_user_config_set_bool (RygelUserConfig* self, const char* section, const char* key, gboolean value);
void rygel_user_config_set_transcoding (RygelUserConfig* self, gboolean value);
static gboolean rygel_user_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error);
void rygel_user_config_set_mp3_transcoder (RygelUserConfig* self, gboolean value);
static gboolean rygel_user_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error);
void rygel_user_config_set_mp2ts_transcoder (RygelUserConfig* self, gboolean value);
static gboolean rygel_user_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error);
void rygel_user_config_set_lpcm_transcoder (RygelUserConfig* self, gboolean value);
static gboolean rygel_user_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error);
void rygel_user_config_set_wmv_transcoder (RygelUserConfig* self, gboolean value);
static RygelLogLevel rygel_user_config_real_get_log_level (RygelConfiguration* base, GError** error);
RygelUserConfig* rygel_user_config_new (gboolean read_only, GError** error);
RygelUserConfig* rygel_user_config_construct (GType object_type, gboolean read_only, GError** error);
RygelUserConfig* rygel_user_config_get_default (GError** error);
void rygel_user_config_save (RygelUserConfig* self);
static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base, const char* section, GError** error);
static char* rygel_user_config_real_get_title (RygelConfiguration* base, const char* section, GError** error);
GQuark rygel_configuration_error_quark (void);
static char* rygel_user_config_real_get_string (RygelConfiguration* base, const char* section, const char* key, GError** error);
static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base, const char* section, const char* key, GError** error);
static gint rygel_user_config_real_get_int (RygelConfiguration* base, const char* section, const char* key, gint min, gint max, GError** error);
static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base, const char* section, const char* key, GError** error);
static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base, const char* section, const char* key, GError** error);
void rygel_user_config_set_string_list (RygelUserConfig* self, const char* section, const char* key, GeeArrayList* str_list);
static void rygel_user_config_ensure_dir_exists (RygelUserConfig* self, const char* dir_path, GError** error);
static void _dynamic_StartServiceByName0 (DBusGProxy* self, const char* param1, guint32 param2, guint32* param3, GError** error);
static void _dynamic_Shutdown1 (DBusGProxy* self, GError** error);
static void rygel_user_config_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 62 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error) {
#line 197 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 63 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_ENABLED_KEY, &_inner_error_);
#line 206 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 63 "rygel-user-config.vala"
	return result;
#line 214 "rygel-user-config.c"
}


#line 66 "rygel-user-config.vala"
void rygel_user_config_set_upnp_enabled (RygelUserConfig* self, gboolean value) {
#line 220 "rygel-user-config.c"
	GError * _inner_error_;
	gboolean enabled;
#line 66 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 225 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 67 "rygel-user-config.vala"
	enabled = FALSE;
#line 229 "rygel-user-config.c"
	{
		gboolean _tmp0_;
#line 70 "rygel-user-config.vala"
		_tmp0_ = rygel_configuration_get_upnp_enabled ((RygelConfiguration*) self, &_inner_error_);
#line 234 "rygel-user-config.c"
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
#line 70 "rygel-user-config.vala"
		enabled = _tmp0_;
#line 240 "rygel-user-config.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 73 "rygel-user-config.vala"
	if (value != enabled) {
#line 74 "rygel-user-config.vala"
		rygel_user_config_enable_upnp (self, value);
#line 262 "rygel-user-config.c"
	}
}


#line 78 "rygel-user-config.vala"
static char* rygel_user_config_real_get_interface (RygelConfiguration* base, GError** error) {
#line 269 "rygel-user-config.c"
	RygelUserConfig * self;
	char* result = NULL;
	GError * _inner_error_;
	char* _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 79 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_IFACE_KEY, &_inner_error_);
#line 278 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
#line 79 "rygel-user-config.vala"
	return result;
#line 286 "rygel-user-config.c"
}


#line 82 "rygel-user-config.vala"
void rygel_user_config_set_interface (RygelUserConfig* self, const char* value) {
#line 82 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 82 "rygel-user-config.vala"
	g_return_if_fail (value != NULL);
#line 83 "rygel-user-config.vala"
	rygel_user_config_set_string (self, "general", RYGEL_USER_CONFIG_IFACE_KEY, value);
#line 298 "rygel-user-config.c"
}


#line 86 "rygel-user-config.vala"
static gint rygel_user_config_real_get_port (RygelConfiguration* base, GError** error) {
#line 304 "rygel-user-config.c"
	RygelUserConfig * self;
	gint result = 0;
	GError * _inner_error_;
	gint _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 87 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_int ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_PORT_KEY, (gint) 0U, (gint) G_MAXUINT16, &_inner_error_);
#line 313 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = _tmp0_;
#line 87 "rygel-user-config.vala"
	return result;
#line 321 "rygel-user-config.c"
}


#line 90 "rygel-user-config.vala"
void rygel_user_config_set_port (RygelUserConfig* self, gint value) {
#line 90 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 91 "rygel-user-config.vala"
	rygel_user_config_set_int (self, "general", RYGEL_USER_CONFIG_PORT_KEY, value);
#line 331 "rygel-user-config.c"
}


#line 94 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
#line 337 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 95 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_TRANSCODING_KEY, &_inner_error_);
#line 346 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 95 "rygel-user-config.vala"
	return result;
#line 354 "rygel-user-config.c"
}


#line 98 "rygel-user-config.vala"
void rygel_user_config_set_transcoding (RygelUserConfig* self, gboolean value) {
#line 98 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 99 "rygel-user-config.vala"
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_TRANSCODING_KEY, value);
#line 364 "rygel-user-config.c"
}


#line 102 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error) {
#line 370 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 103 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY, &_inner_error_);
#line 379 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 103 "rygel-user-config.vala"
	return result;
#line 387 "rygel-user-config.c"
}


#line 106 "rygel-user-config.vala"
void rygel_user_config_set_mp3_transcoder (RygelUserConfig* self, gboolean value) {
#line 106 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 107 "rygel-user-config.vala"
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY, value);
#line 397 "rygel-user-config.c"
}


#line 110 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error) {
#line 403 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 111 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY, &_inner_error_);
#line 412 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 111 "rygel-user-config.vala"
	return result;
#line 420 "rygel-user-config.c"
}


#line 114 "rygel-user-config.vala"
void rygel_user_config_set_mp2ts_transcoder (RygelUserConfig* self, gboolean value) {
#line 114 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 115 "rygel-user-config.vala"
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY, value);
#line 430 "rygel-user-config.c"
}


#line 118 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error) {
#line 436 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 119 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY, &_inner_error_);
#line 445 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 119 "rygel-user-config.vala"
	return result;
#line 453 "rygel-user-config.c"
}


#line 122 "rygel-user-config.vala"
void rygel_user_config_set_lpcm_transcoder (RygelUserConfig* self, gboolean value) {
#line 122 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 123 "rygel-user-config.vala"
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY, value);
#line 463 "rygel-user-config.c"
}


#line 126 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error) {
#line 469 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 127 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY, &_inner_error_);
#line 478 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 127 "rygel-user-config.vala"
	return result;
#line 486 "rygel-user-config.c"
}


#line 130 "rygel-user-config.vala"
void rygel_user_config_set_wmv_transcoder (RygelUserConfig* self, gboolean value) {
#line 130 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 131 "rygel-user-config.vala"
	rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY, value);
#line 496 "rygel-user-config.c"
}


#line 134 "rygel-user-config.vala"
static RygelLogLevel rygel_user_config_real_get_log_level (RygelConfiguration* base, GError** error) {
#line 502 "rygel-user-config.c"
	RygelUserConfig * self;
	RygelLogLevel result = 0;
	GError * _inner_error_;
	gint _tmp0_;
	self = (RygelUserConfig*) base;
	_inner_error_ = NULL;
#line 135 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_int ((RygelConfiguration*) self, "general", RYGEL_USER_CONFIG_LOG_LEVEL_KEY, (gint) RYGEL_LOG_LEVEL_INVALID, (gint) RYGEL_LOG_LEVEL_DEBUG, &_inner_error_);
#line 511 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = (RygelLogLevel) _tmp0_;
#line 135 "rygel-user-config.vala"
	return result;
#line 519 "rygel-user-config.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 141 "rygel-user-config.vala"
RygelUserConfig* rygel_user_config_get_default (GError** error) {
#line 530 "rygel-user-config.c"
	RygelUserConfig* result = NULL;
	GError * _inner_error_;
	_inner_error_ = NULL;
#line 142 "rygel-user-config.vala"
	if (rygel_user_config_config == NULL) {
#line 536 "rygel-user-config.c"
		RygelUserConfig* _tmp0_;
		RygelUserConfig* _tmp1_;
#line 143 "rygel-user-config.vala"
		_tmp0_ = rygel_user_config_new (TRUE, &_inner_error_);
#line 541 "rygel-user-config.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
#line 143 "rygel-user-config.vala"
		rygel_user_config_config = (_tmp1_ = _tmp0_, _g_object_unref0 (rygel_user_config_config), _tmp1_);
#line 548 "rygel-user-config.c"
	}
	result = _g_object_ref0 (rygel_user_config_config);
#line 146 "rygel-user-config.vala"
	return result;
#line 553 "rygel-user-config.c"
}


#line 149 "rygel-user-config.vala"
RygelUserConfig* rygel_user_config_construct (GType object_type, gboolean read_only, GError** error) {
#line 559 "rygel-user-config.c"
	GError * _inner_error_;
	RygelUserConfig * self;
	GKeyFile* _tmp0_;
	char** _tmp1_;
	gint _dirs_size_;
	gint dirs_length1;
	char** dirs;
	char* _tmp2_;
	char* _tmp3_;
	char* path;
	char* _tmp5_;
	char* _tmp4_ = NULL;
	_inner_error_ = NULL;
#line 149 "rygel-user-config.vala"
	self = (RygelUserConfig*) g_object_new (object_type, NULL);
#line 150 "rygel-user-config.vala"
	self->priv->read_only = read_only;
#line 151 "rygel-user-config.vala"
	self->key_file = (_tmp0_ = g_key_file_new (), _g_key_file_free0 (self->key_file), _tmp0_);
#line 579 "rygel-user-config.c"
	dirs = (_tmp1_ = g_new0 (char*, 2 + 1), dirs_length1 = 2, _dirs_size_ = dirs_length1, _tmp1_);
#line 154 "rygel-user-config.vala"
	dirs[0] = (_tmp2_ = g_strdup (g_get_user_config_dir ()), _g_free0 (dirs[0]), _tmp2_);
#line 155 "rygel-user-config.vala"
	dirs[1] = (_tmp3_ = g_strdup (SYS_CONFIG_DIR), _g_free0 (dirs[1]), _tmp3_);
#line 585 "rygel-user-config.c"
	path = NULL;
#line 158 "rygel-user-config.vala"
	g_key_file_load_from_dirs (self->key_file, RYGEL_USER_CONFIG_CONFIG_FILE, dirs, &_tmp4_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
#line 158 "rygel-user-config.vala"
	path = (_tmp5_ = _tmp4_, _g_free0 (path), _tmp5_);
#line 591 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (path);
		g_object_unref (self);
		return NULL;
	}
#line 163 "rygel-user-config.vala"
	g_debug ("rygel-user-config.vala:163: Loaded user configuration from file '%s'", path);
#line 601 "rygel-user-config.c"
	{
		DBusGConnection* connection;
		DBusGProxy* _tmp6_;
		DBusGProxy* _tmp7_;
#line 166 "rygel-user-config.vala"
		connection = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
#line 608 "rygel-user-config.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch1_dbus_gerror;
			}
			dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 169 "rygel-user-config.vala"
		self->priv->rygel_obj = (_tmp6_ = dbus_g_proxy_new_for_name (connection, RYGEL_USER_CONFIG_RYGEL_SERVICE, RYGEL_USER_CONFIG_RYGEL_PATH, RYGEL_USER_CONFIG_RYGEL_INTERFACE), _g_object_unref0 (self->priv->rygel_obj), _tmp6_);
#line 173 "rygel-user-config.vala"
		self->priv->dbus_obj = (_tmp7_ = dbus_g_proxy_new_for_name (connection, RYGEL_USER_CONFIG_DBUS_SERVICE, RYGEL_USER_CONFIG_DBUS_PATH, RYGEL_USER_CONFIG_DBUS_INTERFACE), _g_object_unref0 (self->priv->dbus_obj), _tmp7_);
#line 623 "rygel-user-config.c"
		_dbus_g_connection_unref0 (connection);
	}
	goto __finally1;
	__catch1_dbus_gerror:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 177 "rygel-user-config.vala"
			g_debug ("rygel-user-config.vala:177: Failed to connect to session bus: %s", err->message);
#line 635 "rygel-user-config.c"
			_g_error_free0 (err);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (path);
		g_object_unref (self);
		return NULL;
	}
	dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (path);
	return self;
}


#line 149 "rygel-user-config.vala"
RygelUserConfig* rygel_user_config_new (gboolean read_only, GError** error) {
#line 149 "rygel-user-config.vala"
	return rygel_user_config_construct (RYGEL_TYPE_USER_CONFIG, read_only, error);
#line 657 "rygel-user-config.c"
}


#line 181 "rygel-user-config.vala"
void rygel_user_config_save (RygelUserConfig* self) {
#line 663 "rygel-user-config.c"
	GError * _inner_error_;
	char* path;
	gsize length = 0UL;
	char* data;
#line 181 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 670 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 182 "rygel-user-config.vala"
	g_return_if_fail (!self->priv->read_only);
#line 185 "rygel-user-config.vala"
	path = g_build_filename (g_get_user_config_dir (), RYGEL_USER_CONFIG_CONFIG_FILE, NULL);
#line 189 "rygel-user-config.vala"
	data = g_key_file_to_data (self->key_file, &length, NULL);
#line 678 "rygel-user-config.c"
	{
#line 192 "rygel-user-config.vala"
		g_file_set_contents (path, data, (gssize) ((glong) length), &_inner_error_);
#line 682 "rygel-user-config.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			_g_free0 (path);
			_g_free0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 194 "rygel-user-config.vala"
			g_critical ("rygel-user-config.vala:194: Failed to save configuration data to file " \
"'%s': %s", path, err->message);
#line 703 "rygel-user-config.c"
			_g_error_free0 (err);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (path);
	_g_free0 (data);
}


#line 200 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_enabled (RygelConfiguration* base, const char* section, GError** error) {
#line 722 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
#line 200 "rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 730 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 201 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, section, RYGEL_USER_CONFIG_ENABLED_KEY, &_inner_error_);
#line 734 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 201 "rygel-user-config.vala"
	return result;
#line 742 "rygel-user-config.c"
}


#line 204 "rygel-user-config.vala"
static char* rygel_user_config_real_get_title (RygelConfiguration* base, const char* section, GError** error) {
#line 748 "rygel-user-config.c"
	RygelUserConfig * self;
	char* result = NULL;
	GError * _inner_error_;
	char* _tmp0_;
	self = (RygelUserConfig*) base;
#line 204 "rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 756 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 205 "rygel-user-config.vala"
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, section, RYGEL_USER_CONFIG_TITLE_KEY, &_inner_error_);
#line 760 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
#line 205 "rygel-user-config.vala"
	return result;
#line 768 "rygel-user-config.c"
}


#line 208 "rygel-user-config.vala"
static char* rygel_user_config_real_get_string (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 774 "rygel-user-config.c"
	RygelUserConfig * self;
	char* result = NULL;
	GError * _inner_error_;
	char* val;
	gboolean _tmp0_ = FALSE;
	self = (RygelUserConfig*) base;
#line 208 "rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 208 "rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 785 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 210 "rygel-user-config.vala"
	val = g_key_file_get_string (self->key_file, section, key, &_inner_error_);
#line 789 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 212 "rygel-user-config.vala"
	if (val == NULL) {
#line 212 "rygel-user-config.vala"
		_tmp0_ = TRUE;
#line 798 "rygel-user-config.c"
	} else {
#line 212 "rygel-user-config.vala"
		_tmp0_ = _vala_strcmp0 (val, "") == 0;
#line 802 "rygel-user-config.c"
	}
#line 212 "rygel-user-config.vala"
	if (_tmp0_) {
#line 806 "rygel-user-config.c"
		_inner_error_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available for '%s'", key);
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (val);
			return NULL;
		}
	}
	result = val;
#line 217 "rygel-user-config.vala"
	return result;
#line 817 "rygel-user-config.c"
}


#line 220 "rygel-user-config.vala"
static GeeArrayList* rygel_user_config_real_get_string_list (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 823 "rygel-user-config.c"
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	GeeArrayList* str_list;
	char** _tmp1_;
	gint _strings_size_;
	gint strings_length1;
	gsize _tmp0_;
	char** strings;
	self = (RygelUserConfig*) base;
#line 220 "rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 220 "rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 838 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 223 "rygel-user-config.vala"
	str_list = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 842 "rygel-user-config.c"
	strings = (_tmp1_ = g_key_file_get_string_list (self->key_file, section, key, &_tmp0_, &_inner_error_), strings_length1 = _tmp0_, _strings_size_ = strings_length1, _tmp1_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (str_list);
		return NULL;
	}
	{
		char** str_collection;
		int str_collection_length1;
		int str_it;
#line 226 "rygel-user-config.vala"
		str_collection = strings;
#line 855 "rygel-user-config.c"
		str_collection_length1 = strings_length1;
		for (str_it = 0; str_it < strings_length1; str_it = str_it + 1) {
			char* str;
			str = g_strdup (str_collection[str_it]);
			{
#line 227 "rygel-user-config.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) str_list, str);
#line 863 "rygel-user-config.c"
				_g_free0 (str);
			}
		}
	}
	result = str_list;
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
#line 230 "rygel-user-config.vala"
	return result;
#line 872 "rygel-user-config.c"
}


#line 233 "rygel-user-config.vala"
static gint rygel_user_config_real_get_int (RygelConfiguration* base, const char* section, const char* key, gint min, gint max, GError** error) {
#line 878 "rygel-user-config.c"
	RygelUserConfig * self;
	gint result = 0;
	GError * _inner_error_;
	gint val;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (RygelUserConfig*) base;
#line 233 "rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, 0);
#line 233 "rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 890 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 238 "rygel-user-config.vala"
	val = g_key_file_get_integer (self->key_file, section, key, &_inner_error_);
#line 894 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
#line 240 "rygel-user-config.vala"
	if (val == 0) {
#line 240 "rygel-user-config.vala"
		_tmp1_ = TRUE;
#line 903 "rygel-user-config.c"
	} else {
#line 240 "rygel-user-config.vala"
		_tmp1_ = val < min;
#line 907 "rygel-user-config.c"
	}
#line 240 "rygel-user-config.vala"
	if (_tmp1_) {
#line 240 "rygel-user-config.vala"
		_tmp0_ = TRUE;
#line 913 "rygel-user-config.c"
	} else {
#line 240 "rygel-user-config.vala"
		_tmp0_ = val > max;
#line 917 "rygel-user-config.c"
	}
#line 240 "rygel-user-config.vala"
	if (_tmp0_) {
#line 921 "rygel-user-config.c"
		_inner_error_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE, "Value of '%s' out of range", key);
		{
			g_propagate_error (error, _inner_error_);
			return 0;
		}
	}
	result = val;
#line 245 "rygel-user-config.vala"
	return result;
#line 931 "rygel-user-config.c"
}


#line 248 "rygel-user-config.vala"
static GeeArrayList* rygel_user_config_real_get_int_list (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 937 "rygel-user-config.c"
	RygelUserConfig * self;
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	GeeArrayList* int_list;
	gint* _tmp1_;
	gint _ints_size_;
	gint ints_length1;
	gsize _tmp0_;
	gint* ints;
	self = (RygelUserConfig*) base;
#line 248 "rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 248 "rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 952 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 251 "rygel-user-config.vala"
	int_list = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
#line 956 "rygel-user-config.c"
	ints = (_tmp1_ = g_key_file_get_integer_list (self->key_file, section, key, &_tmp0_, &_inner_error_), ints_length1 = _tmp0_, _ints_size_ = ints_length1, _tmp1_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (int_list);
		return NULL;
	}
	{
		gint* num_collection;
		int num_collection_length1;
		int num_it;
#line 254 "rygel-user-config.vala"
		num_collection = ints;
#line 969 "rygel-user-config.c"
		num_collection_length1 = ints_length1;
		for (num_it = 0; num_it < ints_length1; num_it = num_it + 1) {
			gint num;
			num = num_collection[num_it];
			{
#line 255 "rygel-user-config.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) int_list, GINT_TO_POINTER (num));
#line 977 "rygel-user-config.c"
			}
		}
	}
	result = int_list;
	ints = (g_free (ints), NULL);
#line 258 "rygel-user-config.vala"
	return result;
#line 985 "rygel-user-config.c"
}


#line 261 "rygel-user-config.vala"
static gboolean rygel_user_config_real_get_bool (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 991 "rygel-user-config.c"
	RygelUserConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (RygelUserConfig*) base;
#line 261 "rygel-user-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 261 "rygel-user-config.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 1001 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 264 "rygel-user-config.vala"
	_tmp0_ = g_key_file_get_boolean (self->key_file, section, key, &_inner_error_);
#line 1005 "rygel-user-config.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
#line 264 "rygel-user-config.vala"
	return result;
#line 1013 "rygel-user-config.c"
}


#line 267 "rygel-user-config.vala"
void rygel_user_config_set_string (RygelUserConfig* self, const char* section, const char* key, const char* value) {
#line 267 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 267 "rygel-user-config.vala"
	g_return_if_fail (section != NULL);
#line 267 "rygel-user-config.vala"
	g_return_if_fail (key != NULL);
#line 267 "rygel-user-config.vala"
	g_return_if_fail (value != NULL);
#line 270 "rygel-user-config.vala"
	g_key_file_set_string (self->key_file, section, key, value);
#line 1029 "rygel-user-config.c"
}


#line 273 "rygel-user-config.vala"
void rygel_user_config_set_string_list (RygelUserConfig* self, const char* section, const char* key, GeeArrayList* str_list) {
#line 1035 "rygel-user-config.c"
	char** _tmp1_;
	gint _strings_size_;
	gint strings_length1;
	gint _tmp0_;
	char** strings;
	gint i;
#line 273 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 273 "rygel-user-config.vala"
	g_return_if_fail (section != NULL);
#line 273 "rygel-user-config.vala"
	g_return_if_fail (key != NULL);
#line 273 "rygel-user-config.vala"
	g_return_if_fail (str_list != NULL);
#line 1050 "rygel-user-config.c"
	strings = (_tmp1_ = g_new0 (char*, (_tmp0_ = gee_collection_get_size ((GeeCollection*) str_list)) + 1), strings_length1 = _tmp0_, _strings_size_ = strings_length1, _tmp1_);
#line 278 "rygel-user-config.vala"
	i = 0;
#line 1054 "rygel-user-config.c"
	{
		GeeIterator* _str_it;
		_str_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) str_list);
#line 280 "rygel-user-config.vala"
		while (TRUE) {
#line 1060 "rygel-user-config.c"
			char* str;
#line 280 "rygel-user-config.vala"
			if (!gee_iterator_next (_str_it)) {
#line 280 "rygel-user-config.vala"
				break;
#line 1066 "rygel-user-config.c"
			}
#line 280 "rygel-user-config.vala"
			str = (char*) gee_iterator_get (_str_it);
#line 281 "rygel-user-config.vala"
			if (_vala_strcmp0 (str, "") != 0) {
#line 1072 "rygel-user-config.c"
				char* _tmp3_;
				char* *_tmp2_;
#line 282 "rygel-user-config.vala"
				_tmp2_ = &strings[i++];
#line 282 "rygel-user-config.vala"
				(*_tmp2_) = (_tmp3_ = g_strdup (str), _g_free0 ((*_tmp2_)), _tmp3_);
#line 1079 "rygel-user-config.c"
			}
			_g_free0 (str);
		}
		_g_object_unref0 (_str_it);
	}
#line 286 "rygel-user-config.vala"
	g_key_file_set_string_list (self->key_file, section, key, strings, strings_length1);
#line 1087 "rygel-user-config.c"
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
}


#line 289 "rygel-user-config.vala"
void rygel_user_config_set_int (RygelUserConfig* self, const char* section, const char* key, gint value) {
#line 289 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 289 "rygel-user-config.vala"
	g_return_if_fail (section != NULL);
#line 289 "rygel-user-config.vala"
	g_return_if_fail (key != NULL);
#line 292 "rygel-user-config.vala"
	g_key_file_set_integer (self->key_file, section, key, value);
#line 1102 "rygel-user-config.c"
}


#line 295 "rygel-user-config.vala"
void rygel_user_config_set_bool (RygelUserConfig* self, const char* section, const char* key, gboolean value) {
#line 295 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 295 "rygel-user-config.vala"
	g_return_if_fail (section != NULL);
#line 295 "rygel-user-config.vala"
	g_return_if_fail (key != NULL);
#line 298 "rygel-user-config.vala"
	g_key_file_set_boolean (self->key_file, section, key, value);
#line 1116 "rygel-user-config.c"
}


static void _dynamic_StartServiceByName0 (DBusGProxy* self, const char* param1, guint32 param2, guint32* param3, GError** error) {
	dbus_g_proxy_call (self, "StartServiceByName", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_INVALID, G_TYPE_UINT, param3, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


static void _dynamic_Shutdown1 (DBusGProxy* self, GError** error) {
	dbus_g_proxy_call (self, "Shutdown", error, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


#line 301 "rygel-user-config.vala"
static void rygel_user_config_enable_upnp (RygelUserConfig* self, gboolean enable) {
#line 1138 "rygel-user-config.c"
	GError * _inner_error_;
	char* dest_dir;
#line 301 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 1143 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 302 "rygel-user-config.vala"
	dest_dir = g_build_filename (g_get_user_config_dir (), "autostart", NULL);
#line 1147 "rygel-user-config.c"
	{
		char* dest_path;
		GFile* dest;
#line 305 "rygel-user-config.vala"
		rygel_user_config_ensure_dir_exists (self, dest_dir, &_inner_error_);
#line 1153 "rygel-user-config.c"
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
#line 307 "rygel-user-config.vala"
		dest_path = g_build_filename (dest_dir, "rygel.desktop", NULL);
#line 308 "rygel-user-config.vala"
		dest = g_file_new_for_path (dest_path);
#line 310 "rygel-user-config.vala"
		if (enable) {
#line 1163 "rygel-user-config.c"
			guint32 res = 0U;
			char* source_path;
#line 314 "rygel-user-config.vala"
			if (self->priv->dbus_obj != NULL) {
#line 315 "rygel-user-config.vala"
				_dynamic_StartServiceByName0 (self->priv->dbus_obj, RYGEL_USER_CONFIG_RYGEL_SERVICE, (guint32) 0, &res, &_inner_error_);
#line 1170 "rygel-user-config.c"
				if (_inner_error_ != NULL) {
					_g_free0 (dest_path);
					_g_object_unref0 (dest);
					goto __catch3_g_error;
				}
			}
#line 321 "rygel-user-config.vala"
			source_path = g_build_filename (DESKTOP_DIR, "rygel.desktop", NULL);
#line 1179 "rygel-user-config.c"
			{
#line 324 "rygel-user-config.vala"
				g_file_make_symbolic_link (dest, source_path, NULL, &_inner_error_);
#line 1183 "rygel-user-config.c"
				if (_inner_error_ != NULL) {
					if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
						goto __catch4_g_io_error_exists;
					}
					goto __finally4;
				}
			}
			goto __finally4;
			__catch4_g_io_error_exists:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally4:
			if (_inner_error_ != NULL) {
				_g_free0 (source_path);
				_g_free0 (dest_path);
				_g_object_unref0 (dest);
				goto __catch3_g_error;
			}
#line 327 "rygel-user-config.vala"
			rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_ENABLED_KEY, TRUE);
#line 1210 "rygel-user-config.c"
			_g_free0 (source_path);
		} else {
#line 330 "rygel-user-config.vala"
			if (self->priv->rygel_obj != NULL) {
#line 331 "rygel-user-config.vala"
				_dynamic_Shutdown1 (self->priv->rygel_obj, &_inner_error_);
#line 1217 "rygel-user-config.c"
				if (_inner_error_ != NULL) {
					_g_free0 (dest_path);
					_g_object_unref0 (dest);
					goto __catch3_g_error;
				}
			}
			{
#line 336 "rygel-user-config.vala"
				g_file_delete (dest, NULL, &_inner_error_);
#line 1227 "rygel-user-config.c"
				if (_inner_error_ != NULL) {
					if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
						goto __catch5_g_io_error_not_found;
					}
					goto __finally5;
				}
			}
			goto __finally5;
			__catch5_g_io_error_not_found:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally5:
			if (_inner_error_ != NULL) {
				_g_free0 (dest_path);
				_g_object_unref0 (dest);
				goto __catch3_g_error;
			}
#line 339 "rygel-user-config.vala"
			rygel_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_ENABLED_KEY, FALSE);
#line 1253 "rygel-user-config.c"
		}
		_g_free0 (dest_path);
		_g_object_unref0 (dest);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			const char* _tmp0_;
			_tmp0_ = NULL;
#line 343 "rygel-user-config.vala"
			if (enable) {
#line 343 "rygel-user-config.vala"
				_tmp0_ = "start";
#line 1271 "rygel-user-config.c"
			} else {
#line 343 "rygel-user-config.vala"
				_tmp0_ = "stop";
#line 1275 "rygel-user-config.c"
			}
#line 342 "rygel-user-config.vala"
			g_warning ("rygel-user-config.vala:342: Failed to %s Rygel service: %s\n", _tmp0_, err->message);
#line 1279 "rygel-user-config.c"
			_g_error_free0 (err);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (dest_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (dest_dir);
}


#line 348 "rygel-user-config.vala"
static void rygel_user_config_ensure_dir_exists (RygelUserConfig* self, const char* dir_path, GError** error) {
#line 1296 "rygel-user-config.c"
	GError * _inner_error_;
	GFile* dir;
#line 348 "rygel-user-config.vala"
	g_return_if_fail (self != NULL);
#line 348 "rygel-user-config.vala"
	g_return_if_fail (dir_path != NULL);
#line 1303 "rygel-user-config.c"
	_inner_error_ = NULL;
#line 349 "rygel-user-config.vala"
	dir = g_file_new_for_path (dir_path);
#line 1307 "rygel-user-config.c"
	{
#line 352 "rygel-user-config.vala"
		g_file_make_directory (dir, NULL, &_inner_error_);
#line 1311 "rygel-user-config.c"
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch6_g_io_error_exists;
			}
			goto __finally6;
		}
	}
	goto __finally6;
	__catch6_g_io_error_exists:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (err);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (dir);
		return;
	}
	_g_object_unref0 (dir);
}


static void rygel_user_config_class_init (RygelUserConfigClass * klass) {
	rygel_user_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelUserConfigPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_user_config_finalize;
}


static void rygel_user_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
	rygel_user_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_upnp_enabled = rygel_user_config_real_get_upnp_enabled;
	iface->get_interface = rygel_user_config_real_get_interface;
	iface->get_port = rygel_user_config_real_get_port;
	iface->get_transcoding = rygel_user_config_real_get_transcoding;
	iface->get_mp3_transcoder = rygel_user_config_real_get_mp3_transcoder;
	iface->get_mp2ts_transcoder = rygel_user_config_real_get_mp2ts_transcoder;
	iface->get_lpcm_transcoder = rygel_user_config_real_get_lpcm_transcoder;
	iface->get_wmv_transcoder = rygel_user_config_real_get_wmv_transcoder;
	iface->get_log_level = rygel_user_config_real_get_log_level;
	iface->get_enabled = rygel_user_config_real_get_enabled;
	iface->get_title = rygel_user_config_real_get_title;
	iface->get_string = rygel_user_config_real_get_string;
	iface->get_string_list = rygel_user_config_real_get_string_list;
	iface->get_int = rygel_user_config_real_get_int;
	iface->get_int_list = rygel_user_config_real_get_int_list;
	iface->get_bool = rygel_user_config_real_get_bool;
}


static void rygel_user_config_instance_init (RygelUserConfig * self) {
	self->priv = RYGEL_USER_CONFIG_GET_PRIVATE (self);
}


static void rygel_user_config_finalize (GObject* obj) {
	RygelUserConfig * self;
	self = RYGEL_USER_CONFIG (obj);
	_g_key_file_free0 (self->key_file);
	_g_object_unref0 (self->priv->dbus_obj);
	_g_object_unref0 (self->priv->rygel_obj);
	G_OBJECT_CLASS (rygel_user_config_parent_class)->finalize (obj);
}


GType rygel_user_config_get_type (void) {
	static volatile gsize rygel_user_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_user_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelUserConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_user_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelUserConfig), 0, (GInstanceInitFunc) rygel_user_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_user_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_user_config_type_id;
		rygel_user_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelUserConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_user_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_user_config_type_id__volatile, rygel_user_config_type_id);
	}
	return rygel_user_config_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




