/* rygel-tracker-search-container.c generated by valac, the Vala compiler
 * generated from rygel-tracker-search-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_TRACKER_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_IS_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER))
#define RYGEL_IS_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;
typedef struct _RygelTrackerSearchContainerPrivate RygelTrackerSearchContainerPrivate;

#define RYGEL_TYPE_TRACKER_SEARCH_IFACE (rygel_tracker_search_iface_get_type ())
#define RYGEL_TRACKER_SEARCH_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_SEARCH_IFACE, RygelTrackerSearchIface))
#define RYGEL_IS_TRACKER_SEARCH_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_SEARCH_IFACE))
#define RYGEL_TRACKER_SEARCH_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKER_SEARCH_IFACE, RygelTrackerSearchIfaceIface))

typedef struct _RygelTrackerSearchIface RygelTrackerSearchIface;
typedef struct _RygelTrackerSearchIfaceIface RygelTrackerSearchIfaceIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelTrackerSearchContainerGetChildrenCountData RygelTrackerSearchContainerGetChildrenCountData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelTrackerSearchContainerGetChildrenData RygelTrackerSearchContainerGetChildrenData;
typedef struct _RygelTrackerSearchContainerSearchData RygelTrackerSearchContainerSearchData;

#define RYGEL_TYPE_TRACKER_ITEM (rygel_tracker_item_get_type ())
#define RYGEL_TRACKER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_ITEM, RygelTrackerItem))
#define RYGEL_TRACKER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_ITEM, RygelTrackerItemClass))
#define RYGEL_IS_TRACKER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_ITEM))
#define RYGEL_IS_TRACKER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_ITEM))
#define RYGEL_TRACKER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_ITEM, RygelTrackerItemClass))

typedef struct _RygelTrackerItem RygelTrackerItem;
typedef struct _RygelTrackerItemClass RygelTrackerItemClass;

#define RYGEL_TYPE_TRACKER_VIDEO_ITEM (rygel_tracker_video_item_get_type ())
#define RYGEL_TRACKER_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_VIDEO_ITEM, RygelTrackerVideoItem))
#define RYGEL_TRACKER_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_VIDEO_ITEM, RygelTrackerVideoItemClass))
#define RYGEL_IS_TRACKER_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_VIDEO_ITEM))
#define RYGEL_IS_TRACKER_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_VIDEO_ITEM))
#define RYGEL_TRACKER_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_VIDEO_ITEM, RygelTrackerVideoItemClass))

typedef struct _RygelTrackerVideoItem RygelTrackerVideoItem;
typedef struct _RygelTrackerVideoItemClass RygelTrackerVideoItemClass;

#define RYGEL_TYPE_TRACKER_IMAGE_ITEM (rygel_tracker_image_item_get_type ())
#define RYGEL_TRACKER_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_IMAGE_ITEM, RygelTrackerImageItem))
#define RYGEL_TRACKER_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_IMAGE_ITEM, RygelTrackerImageItemClass))
#define RYGEL_IS_TRACKER_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_IMAGE_ITEM))
#define RYGEL_IS_TRACKER_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_IMAGE_ITEM))
#define RYGEL_TRACKER_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_IMAGE_ITEM, RygelTrackerImageItemClass))

typedef struct _RygelTrackerImageItem RygelTrackerImageItem;
typedef struct _RygelTrackerImageItemClass RygelTrackerImageItemClass;

#define RYGEL_TYPE_TRACKER_MUSIC_ITEM (rygel_tracker_music_item_get_type ())
#define RYGEL_TRACKER_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_MUSIC_ITEM, RygelTrackerMusicItem))
#define RYGEL_TRACKER_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_MUSIC_ITEM, RygelTrackerMusicItemClass))
#define RYGEL_IS_TRACKER_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_MUSIC_ITEM))
#define RYGEL_IS_TRACKER_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_MUSIC_ITEM))
#define RYGEL_TRACKER_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_MUSIC_ITEM, RygelTrackerMusicItemClass))

typedef struct _RygelTrackerMusicItem RygelTrackerMusicItem;
typedef struct _RygelTrackerMusicItemClass RygelTrackerMusicItemClass;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

struct _RygelTrackerSearchIfaceIface {
	GTypeInterface parent_iface;
	void (*query) (RygelTrackerSearchIface* self, gint live_query_id, const char* service, char** fields, int fields_length1, const char* search_text, char** keywords, int keywords_length1, const char* query_condition, gboolean sort_by_service, char** sort_fields, int sort_fields_length1, gboolean sort_descending, gint offset, gint max_hits, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*query_finish) (RygelTrackerSearchIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerSearchContainer {
	RygelMediaContainer parent_instance;
	RygelTrackerSearchContainerPrivate * priv;
	RygelTrackerSearchIface* search_proxy;
	char* service;
	char* query_condition;
	char** keywords;
	gint keywords_length1;
};

struct _RygelTrackerSearchContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelTrackerSearchContainerGetChildrenCountData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	char* query;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	char** search_result;
	gint _tmp6_;
	gint _tmp5_;
	gint _tmp4__length1;
	char** _tmp4_;
	gint _tmp3__length1;
	char** _tmp3_;
	char** _tmp7_;
	char** _tmp8_;
	gint search_result_length2;
	gint search_result_length1;
	GError * _error_;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerGetChildrenData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	GeeList* result;
	RygelRelationalExpression* expression;
	char* _tmp0_;
	char* _tmp1_;
	guint total_matches;
	GeeList* _tmp2_;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	GeeList* result;
	char* query;
	GeeArrayList* results;
	char** keys;
	gint _tmp0_;
	char** _tmp1_;
	gint keys_size;
	gint keys_length1;
	char** search_result;
	gint _tmp4_;
	gint _tmp3_;
	gint _tmp2__length1;
	char** _tmp2_;
	char** _tmp5_;
	char** _tmp6_;
	gint search_result_length2;
	gint search_result_length1;
	guint i;
	gboolean _tmp7_;
	char* path;
	char* service;
	char** metadata;
	gint _tmp8_;
	char** _tmp9_;
	gint metadata_size;
	gint metadata_length1;
	RygelMediaItem* item;
	GError * _inner_error_;
};


static gpointer rygel_tracker_search_container_parent_class = NULL;

GType rygel_tracker_search_container_get_type (void);
GType rygel_tracker_search_iface_get_type (void);
enum  {
	RYGEL_TRACKER_SEARCH_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_SEARCH_CONTAINER_TRACKER_SERVICE "org.freedesktop.Tracker"
#define RYGEL_TRACKER_SEARCH_CONTAINER_TRACKER_PATH "/org/freedesktop/Tracker"
#define RYGEL_TRACKER_SEARCH_CONTAINER_SEARCH_PATH "/org/freedesktop/Tracker/Search"
#define RYGEL_TRACKER_SEARCH_CONTAINER_METADATA_PATH "/org/freedesktop/Tracker/Metadata"
static char** _vala_array_dup1 (char** self, int length);
static void rygel_tracker_search_container_create_proxies (RygelTrackerSearchContainer* self, GError** error);
static void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_);
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const char* id, RygelMediaContainer* parent, const char* title, const char* service, const char* query_condition, char** keywords, int keywords_length1);
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* service, const char* query_condition, char** keywords, int keywords_length1);
static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data);
static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_tracker_search_iface_query (RygelTrackerSearchIface* self, gint live_query_id, const char* service, char** fields, int fields_length1, const char* search_text, char** keywords, int keywords_length1, const char* query_condition, gboolean sort_by_service, char** sort_fields, int sort_fields_length1, gboolean sort_descending, gint offset, gint max_hits, GAsyncReadyCallback _callback_, gpointer _user_data_);
char** rygel_tracker_search_iface_query_finish (RygelTrackerSearchIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* data);
static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data);
static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_search_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* data);
static void rygel_tracker_search_container_real_search_data_free (gpointer _data);
static void rygel_tracker_search_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_search_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static char* rygel_tracker_search_container_create_query_from_expression (RygelTrackerSearchContainer* self, RygelSearchExpression* expression);
char** rygel_tracker_item_get_metadata_keys (int* result_length1);
static char** rygel_tracker_search_container_slice_strvv_tail (RygelTrackerSearchContainer* self, char** strvv, int strvv_length1, int strvv_length2, guint row, guint index, int* result_length1);
static RygelMediaItem* rygel_tracker_search_container_create_item (RygelTrackerSearchContainer* self, const char* service, const char* path, char** metadata, int metadata_length1, GError** error);
static gboolean rygel_tracker_search_container_real_search_co (RygelTrackerSearchContainerSearchData* data);
static char* rygel_tracker_search_container_get_op_for_expression (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression);
static char* rygel_tracker_search_container_create_query_for_id (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression, const char* query_op);
static char* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const char* item_id, char** parent_id, char** service);
#define RYGEL_TRACKER_VIDEO_ITEM_SERVICE "Videos"
RygelTrackerVideoItem* rygel_tracker_video_item_new (const char* id, const char* path, RygelTrackerSearchContainer* parent, char** metadata, int metadata_length1, GError** error);
RygelTrackerVideoItem* rygel_tracker_video_item_construct (GType object_type, const char* id, const char* path, RygelTrackerSearchContainer* parent, char** metadata, int metadata_length1, GError** error);
GType rygel_tracker_item_get_type (void);
GType rygel_tracker_video_item_get_type (void);
#define RYGEL_TRACKER_IMAGE_ITEM_SERVICE "Images"
RygelTrackerImageItem* rygel_tracker_image_item_new (const char* id, const char* path, RygelTrackerSearchContainer* parent, char** metadata, int metadata_length1, GError** error);
RygelTrackerImageItem* rygel_tracker_image_item_construct (GType object_type, const char* id, const char* path, RygelTrackerSearchContainer* parent, char** metadata, int metadata_length1, GError** error);
GType rygel_tracker_image_item_get_type (void);
#define RYGEL_TRACKER_MUSIC_ITEM_SERVICE "Music"
RygelTrackerMusicItem* rygel_tracker_music_item_new (const char* id, const char* path, RygelTrackerSearchContainer* parent, char** metadata, int metadata_length1, GError** error);
RygelTrackerMusicItem* rygel_tracker_music_item_construct (GType object_type, const char* id, const char* path, RygelTrackerSearchContainer* parent, char** metadata, int metadata_length1, GError** error);
GType rygel_tracker_music_item_get_type (void);
static void rygel_tracker_search_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* service, const char* query_condition, char** keywords, int keywords_length1) {
	GError * _inner_error_;
	RygelTrackerSearchContainer * self;
	char* _tmp0_;
	char** _tmp2_;
	char** _tmp1_;
	char* _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (service != NULL, NULL);
	g_return_val_if_fail (query_condition != NULL, NULL);
	_inner_error_ = NULL;
	self = (RygelTrackerSearchContainer*) rygel_media_container_construct (object_type, id, parent, title, (guint) 0);
	self->service = (_tmp0_ = g_strdup (service), _g_free0 (self->service), _tmp0_);
	self->keywords = (_tmp2_ = (_tmp1_ = keywords, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup1 (_tmp1_, keywords_length1)), self->keywords = (_vala_array_free (self->keywords, self->keywords_length1, (GDestroyNotify) g_free), NULL), self->keywords_length1 = keywords_length1, _tmp2_);
	self->query_condition = (_tmp3_ = g_strdup (query_condition), _g_free0 (self->query_condition), _tmp3_);
	{
		rygel_tracker_search_container_create_proxies (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch4_dbus_gerror;
			}
			goto __finally4;
		}
		rygel_tracker_search_container_get_children_count (self, NULL, NULL);
	}
	goto __finally4;
	__catch4_dbus_gerror:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("rygel-tracker-search-container.vala:66: Failed to connect to session bus: %s\n", _error_->message);
			_g_error_free0 (_error_);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


RygelTrackerSearchContainer* rygel_tracker_search_container_new (const char* id, RygelMediaContainer* parent, const char* title, const char* service, const char* query_condition, char** keywords, int keywords_length1) {
	return rygel_tracker_search_container_construct (RYGEL_TYPE_TRACKER_SEARCH_CONTAINER, id, parent, title, service, query_condition, keywords, keywords_length1);
}


static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data) {
	RygelTrackerSearchContainerGetChildrenCountData* data;
	data = _data;
	g_slice_free (RygelTrackerSearchContainerGetChildrenCountData, data);
}


static void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenCountData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_get_children_count);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_get_children_count_data_free);
	_data_->self = self;
	rygel_tracker_search_container_get_children_count_co (_data_);
}


static void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenCountData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_search_container_get_children_count_co (data);
}


static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			{
				if (_vala_strcmp0 (data->self->query_condition, "") != 0) {
					data->query = (data->_tmp1_ = g_strconcat (data->_tmp0_ = g_strconcat ("<rdfq:Condition>\n", data->self->query_condition, NULL), "</rdfq:Condition>", NULL), _g_free0 (data->query), data->_tmp1_);
					_g_free0 (data->_tmp0_);
				} else {
					data->query = (data->_tmp2_ = g_strdup (""), _g_free0 (data->query), data->_tmp2_);
				}
				rygel_tracker_search_iface_query (data->self->search_proxy, 0, data->self->service, (data->_tmp3_ = g_new0 (char*, 0 + 1), data->_tmp3__length1 = 0, data->_tmp3_), 0, "", data->self->keywords, data->self->keywords_length1, data->query, FALSE, (data->_tmp4_ = g_new0 (char*, 0 + 1), data->_tmp4__length1 = 0, data->_tmp4_), 0, FALSE, 0, -1, rygel_tracker_search_container_get_children_count_ready, data);
				data->_state_ = 3;
				return FALSE;
				case 3:
				data->search_result = (data->_tmp8_ = (data->_tmp7_ = rygel_tracker_search_iface_query_finish (data->self->search_proxy, data->_res_, &data->_tmp5_, &data->_tmp6_, &data->_inner_error_), data->_tmp4_ = (_vala_array_free (data->_tmp4_, data->_tmp4__length1, (GDestroyNotify) g_free), NULL), data->_tmp3_ = (_vala_array_free (data->_tmp3_, data->_tmp3__length1, (GDestroyNotify) g_free), NULL), data->_tmp7_), data->search_result_length1 = data->_tmp5_, data->search_result_length2 = data->_tmp6_, data->_tmp8_);
				if (data->_inner_error_ != NULL) {
					_g_free0 (data->query);
					goto __catch5_g_error;
					goto __finally5;
				}
				((RygelMediaContainer*) data->self)->child_count = (guint) data->search_result_length1;
				rygel_media_container_updated ((RygelMediaContainer*) data->self);
				_g_free0 (data->query);
				data->search_result = (_vala_array_free (data->search_result, data->search_result_length1 * data->search_result_length2, (GDestroyNotify) g_free), NULL);
			}
			goto __finally5;
			__catch5_g_error:
			{
				data->_error_ = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
					g_critical ("rygel-tracker-search-container.vala:101: error getting items under service '%s': %s", data->self->service, data->_error_->message);
					_g_error_free0 (data->_error_);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
					_g_error_free0 (data->_error_);
				}
			}
			__finally5:
			if (data->_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, data->_inner_error_->message);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data) {
	RygelTrackerSearchContainerGetChildrenData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (RygelTrackerSearchContainerGetChildrenData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerGetChildrenData* _data_;
	self = (RygelTrackerSearchContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_get_children_data_free);
	_data_->self = self;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_tracker_search_container_real_get_children_co (_data_);
}


static GeeList* rygel_tracker_search_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	GeeList* result;
	RygelTrackerSearchContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_search_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_search_container_real_get_children_co (data);
}


static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->expression = rygel_relational_expression_new ();
			((RygelSearchExpression*) data->expression)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
			((RygelSearchExpression*) data->expression)->operand1 = (data->_tmp0_ = g_strdup ("@parentID"), _g_free0 (((RygelSearchExpression*) data->expression)->operand1), data->_tmp0_);
			((RygelSearchExpression*) data->expression)->operand2 = (data->_tmp1_ = g_strdup (((RygelMediaObject*) data->self)->id), _g_free0 (((RygelSearchExpression*) data->expression)->operand2), data->_tmp1_);
			rygel_media_container_search ((RygelMediaContainer*) data->self, (RygelSearchExpression*) data->expression, data->offset, data->max_count, data->cancellable, rygel_tracker_search_container_get_children_ready, data);
			data->_state_ = 4;
			return FALSE;
			case 4:
			data->_tmp2_ = rygel_media_container_search_finish ((RygelMediaContainer*) data->self, data->_res_, &data->total_matches, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_rygel_search_expression_unref0 (data->expression);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->result = data->_tmp2_;
			_rygel_search_expression_unref0 (data->expression);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_rygel_search_expression_unref0 (data->expression);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_tracker_search_container_real_search_data_free (gpointer _data) {
	RygelTrackerSearchContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (RygelTrackerSearchContainerSearchData, data);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_tracker_search_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerSearchData* _data_;
	self = (RygelTrackerSearchContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerSearchContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_search_data_free);
	_data_->self = self;
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_tracker_search_container_real_search_co (_data_);
}


static GeeList* rygel_tracker_search_container_real_search_finish (RygelMediaContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	GeeList* result;
	RygelTrackerSearchContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	_data_->total_matches = NULL;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_search_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_tracker_search_container_real_search_co (data);
}


static gboolean rygel_tracker_search_container_real_search_co (RygelTrackerSearchContainerSearchData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->query = rygel_tracker_search_container_create_query_from_expression (data->self, data->expression);
			data->results = gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
			if (data->query == NULL) {
				data->result = (GeeList*) data->results;
				_g_free0 (data->query);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->keys = (data->_tmp1_ = rygel_tracker_item_get_metadata_keys (&data->_tmp0_), data->keys_length1 = data->_tmp0_, data->keys_size = data->keys_length1, data->_tmp1_);
			rygel_tracker_search_iface_query (data->self->search_proxy, 0, data->self->service, data->keys, data->keys_length1, "", data->self->keywords, data->self->keywords_length1, data->query, FALSE, (data->_tmp2_ = g_new0 (char*, 0 + 1), data->_tmp2__length1 = 0, data->_tmp2_), 0, FALSE, (gint) data->offset, (gint) data->max_count, rygel_tracker_search_container_search_ready, data);
			data->_state_ = 5;
			return FALSE;
			case 5:
			data->search_result = (data->_tmp6_ = (data->_tmp5_ = rygel_tracker_search_iface_query_finish (data->self->search_proxy, data->_res_, &data->_tmp3_, &data->_tmp4_, &data->_inner_error_), data->_tmp2_ = (_vala_array_free (data->_tmp2_, data->_tmp2__length1, (GDestroyNotify) g_free), NULL), data->_tmp5_), data->search_result_length1 = data->_tmp3_, data->search_result_length2 = data->_tmp4_, data->_tmp6_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_free0 (data->query);
				_g_object_unref0 (data->results);
				data->keys = (_vala_array_free (data->keys, data->keys_length1, (GDestroyNotify) g_free), NULL);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			{
				data->i = (guint) 0;
				{
					data->_tmp7_ = TRUE;
					while (TRUE) {
						if (!data->_tmp7_) {
							data->i++;
						}
						data->_tmp7_ = FALSE;
						if (!(data->i < data->search_result_length1)) {
							break;
						}
						data->path = g_strdup (data->search_result[(data->i * data->search_result_length2) + 0]);
						data->service = g_strdup (data->search_result[(data->i * data->search_result_length2) + 1]);
						data->metadata = (data->_tmp9_ = rygel_tracker_search_container_slice_strvv_tail (data->self, data->search_result, data->search_result_length1, data->search_result_length2, data->i, (guint) 2, &data->_tmp8_), data->metadata_length1 = data->_tmp8_, data->metadata_size = data->metadata_length1, data->_tmp9_);
						data->item = rygel_tracker_search_container_create_item (data->self, data->service, data->path, data->metadata, data->metadata_length1, &data->_inner_error_);
						if (data->_inner_error_ != NULL) {
							g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
							g_error_free (data->_inner_error_);
							_g_free0 (data->path);
							_g_free0 (data->service);
							data->metadata = (_vala_array_free (data->metadata, data->metadata_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (data->query);
							_g_object_unref0 (data->results);
							data->keys = (_vala_array_free (data->keys, data->keys_length1, (GDestroyNotify) g_free), NULL);
							data->search_result = (_vala_array_free (data->search_result, data->search_result_length1 * data->search_result_length2, (GDestroyNotify) g_free), NULL);
							{
								if (data->_state_ == 0) {
									g_simple_async_result_complete_in_idle (data->_async_result);
								} else {
									g_simple_async_result_complete (data->_async_result);
								}
								g_object_unref (data->_async_result);
								return FALSE;
							}
						}
						gee_abstract_collection_add ((GeeAbstractCollection*) data->results, (RygelMediaObject*) data->item);
						_g_free0 (data->path);
						_g_free0 (data->service);
						data->metadata = (_vala_array_free (data->metadata, data->metadata_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (data->item);
					}
				}
			}
			data->total_matches = (guint) gee_collection_get_size ((GeeCollection*) data->results);
			data->result = (GeeList*) data->results;
			_g_free0 (data->query);
			data->keys = (_vala_array_free (data->keys, data->keys_length1, (GDestroyNotify) g_free), NULL);
			data->search_result = (_vala_array_free (data->search_result, data->search_result_length1 * data->search_result_length2, (GDestroyNotify) g_free), NULL);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_free0 (data->query);
			_g_object_unref0 (data->results);
			data->keys = (_vala_array_free (data->keys, data->keys_length1, (GDestroyNotify) g_free), NULL);
			data->search_result = (_vala_array_free (data->search_result, data->search_result_length1 * data->search_result_length2, (GDestroyNotify) g_free), NULL);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static char* rygel_tracker_search_container_create_query_from_expression (RygelTrackerSearchContainer* self, RygelSearchExpression* expression) {
	char* result;
	char* query;
	gboolean _tmp0_ = FALSE;
	RygelSearchExpression* _tmp1_;
	RygelRelationalExpression* rel_expression;
	char* query_op;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	query = NULL;
	if (expression == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !RYGEL_IS_RELATIONAL_EXPRESSION (expression);
	}
	if (_tmp0_) {
		result = query;
		return result;
	}
	rel_expression = _rygel_search_expression_ref0 ((_tmp1_ = expression, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp1_) ? ((RygelRelationalExpression*) _tmp1_) : NULL));
	query_op = rygel_tracker_search_container_get_op_for_expression (self, rel_expression);
	if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) rel_expression)->operand1, "@id") == 0) {
		_tmp2_ = query_op != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		char* _tmp3_;
		query = (_tmp3_ = rygel_tracker_search_container_create_query_for_id (self, rel_expression, query_op), _g_free0 (query), _tmp3_);
	} else {
		gboolean _tmp4_ = FALSE;
		if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) rel_expression)->operand1, "@parentID") == 0) {
			_tmp4_ = rygel_relational_expression_compare_string (rel_expression, ((RygelMediaObject*) self)->id);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			if (_vala_strcmp0 (self->query_condition, "") != 0) {
				char* _tmp6_;
				char* _tmp5_;
				query = (_tmp6_ = g_strconcat (_tmp5_ = g_strconcat ("<rdfq:Condition>\n", self->query_condition, NULL), "</rdfq:Condition>", NULL), _g_free0 (query), _tmp6_);
				_g_free0 (_tmp5_);
			} else {
				char* _tmp7_;
				query = (_tmp7_ = g_strdup (""), _g_free0 (query), _tmp7_);
			}
		}
	}
	result = query;
	_rygel_search_expression_unref0 (rel_expression);
	_g_free0 (query_op);
	return result;
}


static char* rygel_tracker_search_container_create_query_for_id (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression, const char* query_op) {
	char* result;
	char* query;
	char* parent_id;
	char* service;
	char* _tmp5_;
	char* _tmp4_;
	char* _tmp3_ = NULL;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_ = NULL;
	char* path;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	g_return_val_if_fail (query_op != NULL, NULL);
	query = NULL;
	parent_id = NULL;
	service = NULL;
	path = (_tmp4_ = (_tmp1_ = rygel_tracker_search_container_get_item_info (self, (const char*) ((RygelSearchExpression*) expression)->operand2, &_tmp0_, &_tmp3_), parent_id = (_tmp2_ = _tmp0_, _g_free0 (parent_id), _tmp2_), _tmp1_), service = (_tmp5_ = _tmp3_, _g_free0 (service), _tmp5_), _tmp4_);
	if (path != NULL) {
		_tmp7_ = parent_id != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = _vala_strcmp0 (parent_id, ((RygelMediaObject*) self)->id) == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		char* dir;
		char* basename;
		char* _tmp28_;
		char* _tmp27_;
		char* _tmp26_;
		char* _tmp25_;
		char* _tmp24_;
		char* _tmp23_;
		char* _tmp22_;
		char* _tmp21_;
		char* _tmp20_;
		char* _tmp19_;
		char* _tmp18_;
		char* _tmp17_;
		char* _tmp16_;
		char* _tmp15_;
		char* _tmp14_;
		char* _tmp13_;
		char* _tmp12_;
		char* _tmp11_;
		char* _tmp10_;
		char* _tmp9_;
		char* _tmp8_;
		char* _tmp29_;
		char* search_condition;
		dir = g_path_get_dirname (path);
		basename = g_path_get_basename (path);
		search_condition = (_tmp29_ = g_strconcat (_tmp28_ = g_strconcat (_tmp27_ = g_strconcat (_tmp26_ = g_strconcat (_tmp25_ = g_strconcat (_tmp24_ = g_strconcat (_tmp23_ = g_strconcat (_tmp22_ = g_strconcat (_tmp21_ = g_strconcat (_tmp20_ = g_strconcat (_tmp19_ = g_strconcat (_tmp18_ = g_strconcat (_tmp17_ = g_strconcat (_tmp16_ = g_strconcat (_tmp15_ = g_strconcat (_tmp14_ = g_strconcat (_tmp13_ = g_strconcat (_tmp12_ = g_strconcat (_tmp11_ = g_strconcat (_tmp10_ = g_strconcat (_tmp9_ = g_strconcat (_tmp8_ = g_strconcat ("<rdfq:and>\n" "<", query_op, NULL), ">\n", NULL), "<rdfq:Property ", NULL), "name=\"File:Path\" />\n", NULL), "<rdf:String>", NULL), dir, NULL), "</rdf:String>\n", NULL), "</", NULL), query_op, NULL), ">\n", NULL), "<", NULL), query_op, NULL), ">\n", NULL), "<rdfq:Property ", NULL), "name=\"File:Name\" />\n", NULL), "<rdf:String>", NULL), basename, NULL), "</rdf:String>\n", NULL), "</", NULL), query_op, NULL), ">\n", NULL), "</rdfq:and>\n", NULL), _g_free0 (_tmp28_), _g_free0 (_tmp27_), _g_free0 (_tmp26_), _g_free0 (_tmp25_), _g_free0 (_tmp24_), _g_free0 (_tmp23_), _g_free0 (_tmp22_), _g_free0 (_tmp21_), _g_free0 (_tmp20_), _g_free0 (_tmp19_), _g_free0 (_tmp18_), _g_free0 (_tmp17_), _g_free0 (_tmp16_), _g_free0 (_tmp15_), _g_free0 (_tmp14_), _g_free0 (_tmp13_), _g_free0 (_tmp12_), _g_free0 (_tmp11_), _g_free0 (_tmp10_), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _tmp29_);
		if (_vala_strcmp0 (self->query_condition, "") != 0) {
			char* _tmp33_;
			char* _tmp32_;
			char* _tmp31_;
			char* _tmp30_;
			query = (_tmp33_ = g_strconcat (_tmp32_ = g_strconcat (_tmp31_ = g_strconcat (_tmp30_ = g_strconcat ("<rdfq:Condition>\n" "<rdfq:and>\n", search_condition, NULL), self->query_condition, NULL), "</rdfq:and>\n", NULL), "</rdfq:Condition>", NULL), _g_free0 (query), _tmp33_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp31_);
			_g_free0 (_tmp30_);
		} else {
			char* _tmp35_;
			char* _tmp34_;
			query = (_tmp35_ = g_strconcat (_tmp34_ = g_strconcat ("<rdfq:Condition>\n", search_condition, NULL), "</rdfq:Condition>", NULL), _g_free0 (query), _tmp35_);
			_g_free0 (_tmp34_);
		}
		_g_free0 (dir);
		_g_free0 (basename);
		_g_free0 (search_condition);
	}
	result = query;
	_g_free0 (parent_id);
	_g_free0 (service);
	_g_free0 (path);
	return result;
}


static char* rygel_tracker_search_container_get_op_for_expression (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	switch (GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op)) {
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			result = g_strdup ("rdfq:equals");
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			result = g_strdup ("rdfq:contains");
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}


static RygelMediaItem* rygel_tracker_search_container_create_item (RygelTrackerSearchContainer* self, const char* service, const char* path, char** metadata, int metadata_length1, GError** error) {
	RygelMediaItem* result;
	GError * _inner_error_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp3_;
	char* id;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (service != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_inner_error_ = NULL;
	id = (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (service, ":", NULL), ((RygelMediaObject*) self)->id, NULL), ":", NULL), path, NULL), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp3_);
	if (_vala_strcmp0 (service, RYGEL_TRACKER_VIDEO_ITEM_SERVICE) == 0) {
		RygelTrackerVideoItem* _tmp4_;
		_tmp4_ = rygel_tracker_video_item_new (id, path, self, metadata, metadata_length1, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (id);
			return NULL;
		}
		result = (RygelMediaItem*) _tmp4_;
		_g_free0 (id);
		return result;
	} else {
		if (_vala_strcmp0 (service, RYGEL_TRACKER_IMAGE_ITEM_SERVICE) == 0) {
			RygelTrackerImageItem* _tmp5_;
			_tmp5_ = rygel_tracker_image_item_new (id, path, self, metadata, metadata_length1, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (id);
				return NULL;
			}
			result = (RygelMediaItem*) _tmp5_;
			_g_free0 (id);
			return result;
		} else {
			if (_vala_strcmp0 (service, RYGEL_TRACKER_MUSIC_ITEM_SERVICE) == 0) {
				RygelTrackerMusicItem* _tmp6_;
				_tmp6_ = rygel_tracker_music_item_new (id, path, self, metadata, metadata_length1, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (id);
					return NULL;
				}
				result = (RygelMediaItem*) _tmp6_;
				_g_free0 (id);
				return result;
			} else {
				result = NULL;
				_g_free0 (id);
				return result;
			}
		}
	}
	_g_free0 (id);
}


static char* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const char* item_id, char** parent_id, char** service) {
	char* result;
	char** _tmp1_;
	gint tokens_size;
	gint tokens_length1;
	char** _tmp0_;
	char** tokens;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_id != NULL, NULL);
	if (parent_id != NULL) {
		*parent_id = NULL;
	}
	if (service != NULL) {
		*service = NULL;
	}
	tokens = (_tmp1_ = _tmp0_ = g_strsplit (item_id, ":", 3), tokens_length1 = _vala_array_length (_tmp0_), tokens_size = tokens_length1, _tmp1_);
	if (tokens[0] != NULL) {
		_tmp3_ = tokens[1] != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = tokens[2] != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		char* _tmp4_;
		char* _tmp5_;
		*service = (_tmp4_ = g_strdup (tokens[0]), _g_free0 (*service), _tmp4_);
		*parent_id = (_tmp5_ = g_strdup (tokens[1]), _g_free0 (*parent_id), _tmp5_);
		result = g_strdup (tokens[2]);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		result = NULL;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
}


static void rygel_tracker_search_container_create_proxies (RygelTrackerSearchContainer* self, GError** error) {
	GError * _inner_error_;
	DBusGConnection* connection;
	RygelTrackerSearchIface* _tmp0_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	connection = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->search_proxy = (_tmp0_ = rygel_tracker_search_iface_dbus_proxy_new (connection, RYGEL_TRACKER_SEARCH_CONTAINER_TRACKER_SERVICE, RYGEL_TRACKER_SEARCH_CONTAINER_SEARCH_PATH), _g_object_unref0 (self->search_proxy), _tmp0_);
	_dbus_g_connection_unref0 (connection);
}


static char** rygel_tracker_search_container_slice_strvv_tail (RygelTrackerSearchContainer* self, char** strvv, int strvv_length1, int strvv_length2, guint row, guint index, int* result_length1) {
	char** result;
	char** _tmp1_;
	gint slice_size;
	gint slice_length1;
	gint _tmp0_;
	char** slice;
	char** _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	slice = (_tmp1_ = g_new0 (char*, (_tmp0_ = strvv_length2 - index) + 1), slice_length1 = _tmp0_, slice_size = slice_length1, _tmp1_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				char* _tmp3_;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				if (!(i < slice_length1)) {
					break;
				}
				slice[i] = (_tmp3_ = g_strdup (strvv[(row * strvv_length2) + (i + index)]), _g_free0 (slice[i]), _tmp3_);
			}
		}
	}
	result = (_tmp4_ = slice, *result_length1 = slice_length1, _tmp4_);
	return result;
	slice = (_vala_array_free (slice, slice_length1, (GDestroyNotify) g_free), NULL);
}


static void rygel_tracker_search_container_class_init (RygelTrackerSearchContainerClass * klass) {
	rygel_tracker_search_container_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_tracker_search_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_tracker_search_container_real_get_children_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search = rygel_tracker_search_container_real_search;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search_finish = rygel_tracker_search_container_real_search_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_search_container_finalize;
}


static void rygel_tracker_search_container_instance_init (RygelTrackerSearchContainer * self) {
}


static void rygel_tracker_search_container_finalize (GObject* obj) {
	RygelTrackerSearchContainer * self;
	self = RYGEL_TRACKER_SEARCH_CONTAINER (obj);
	_g_object_unref0 (self->search_proxy);
	_g_free0 (self->service);
	_g_free0 (self->query_condition);
	self->keywords = (_vala_array_free (self->keywords, self->keywords_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (rygel_tracker_search_container_parent_class)->finalize (obj);
}


GType rygel_tracker_search_container_get_type (void) {
	static GType rygel_tracker_search_container_type_id = 0;
	if (rygel_tracker_search_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerSearchContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_search_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerSearchContainer), 0, (GInstanceInitFunc) rygel_tracker_search_container_instance_init, NULL };
		rygel_tracker_search_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelTrackerSearchContainer", &g_define_type_info, 0);
	}
	return rygel_tracker_search_container_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




