/* rygel-external-item-factory.c generated by valac, the Vala compiler
 * generated from rygel-external-item-factory.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rygel.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_EXTERNAL_ITEM_FACTORY (rygel_external_item_factory_get_type ())
#define RYGEL_EXTERNAL_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY, RygelExternalItemFactory))
#define RYGEL_EXTERNAL_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY, RygelExternalItemFactoryClass))
#define RYGEL_IS_EXTERNAL_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY))
#define RYGEL_IS_EXTERNAL_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY))
#define RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY, RygelExternalItemFactoryClass))

typedef struct _RygelExternalItemFactory RygelExternalItemFactory;
typedef struct _RygelExternalItemFactoryClass RygelExternalItemFactoryClass;
typedef struct _RygelExternalItemFactoryPrivate RygelExternalItemFactoryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_EXTERNAL_CONTAINER (rygel_external_container_get_type ())
#define RYGEL_EXTERNAL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_CONTAINER, RygelExternalContainer))
#define RYGEL_EXTERNAL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_EXTERNAL_CONTAINER, RygelExternalContainerClass))
#define RYGEL_IS_EXTERNAL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_CONTAINER))
#define RYGEL_IS_EXTERNAL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_EXTERNAL_CONTAINER))
#define RYGEL_EXTERNAL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_EXTERNAL_CONTAINER, RygelExternalContainerClass))

typedef struct _RygelExternalContainer RygelExternalContainer;
typedef struct _RygelExternalContainerClass RygelExternalContainerClass;
typedef struct _RygelExternalItemFactoryCreateForPathData RygelExternalItemFactoryCreateForPathData;
typedef struct _RygelExternalItemFactoryCreateForIdData RygelExternalItemFactoryCreateForIdData;
typedef struct _RygelExternalContainerPrivate RygelExternalContainerPrivate;

#define RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT (rygel_external_media_object_get_type ())
#define RYGEL_EXTERNAL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT, RygelExternalMediaObject))
#define RYGEL_IS_EXTERNAL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT))
#define RYGEL_EXTERNAL_MEDIA_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT, RygelExternalMediaObjectIface))

typedef struct _RygelExternalMediaObject RygelExternalMediaObject;
typedef struct _RygelExternalMediaObjectIface RygelExternalMediaObjectIface;

#define RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER (rygel_external_media_container_get_type ())
#define RYGEL_EXTERNAL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER, RygelExternalMediaContainer))
#define RYGEL_IS_EXTERNAL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER))
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER, RygelExternalMediaContainerIface))

typedef struct _RygelExternalMediaContainer RygelExternalMediaContainer;
typedef struct _RygelExternalMediaContainerIface RygelExternalMediaContainerIface;

#define FREE_DESKTOP_TYPE_PROPERTIES (free_desktop_properties_get_type ())
#define FREE_DESKTOP_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FREE_DESKTOP_TYPE_PROPERTIES, FreeDesktopProperties))
#define FREE_DESKTOP_IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FREE_DESKTOP_TYPE_PROPERTIES))
#define FREE_DESKTOP_PROPERTIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FREE_DESKTOP_TYPE_PROPERTIES, FreeDesktopPropertiesIface))

typedef struct _FreeDesktopProperties FreeDesktopProperties;
typedef struct _FreeDesktopPropertiesIface FreeDesktopPropertiesIface;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define RYGEL_TYPE_EXTERNAL_MEDIA_ITEM (rygel_external_media_item_get_type ())
#define RYGEL_EXTERNAL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_ITEM, RygelExternalMediaItem))
#define RYGEL_IS_EXTERNAL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_ITEM))
#define RYGEL_EXTERNAL_MEDIA_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_ITEM, RygelExternalMediaItemIface))

typedef struct _RygelExternalMediaItem RygelExternalMediaItem;
typedef struct _RygelExternalMediaItemIface RygelExternalMediaItemIface;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_EXTERNAL_THUMBNAIL_FACTORY (rygel_external_thumbnail_factory_get_type ())
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_THUMBNAIL_FACTORY, RygelExternalThumbnailFactory))
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_EXTERNAL_THUMBNAIL_FACTORY, RygelExternalThumbnailFactoryClass))
#define RYGEL_IS_EXTERNAL_THUMBNAIL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_THUMBNAIL_FACTORY))
#define RYGEL_IS_EXTERNAL_THUMBNAIL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_EXTERNAL_THUMBNAIL_FACTORY))
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_EXTERNAL_THUMBNAIL_FACTORY, RygelExternalThumbnailFactoryClass))

typedef struct _RygelExternalThumbnailFactory RygelExternalThumbnailFactory;
typedef struct _RygelExternalThumbnailFactoryClass RygelExternalThumbnailFactoryClass;
#define _rygel_external_thumbnail_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_thumbnail_factory_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelExternalItemFactoryCreateData RygelExternalItemFactoryCreateData;
typedef struct _RygelParamSpecExternalItemFactory RygelParamSpecExternalItemFactory;

struct _RygelExternalItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelExternalItemFactoryPrivate * priv;
};

struct _RygelExternalItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelExternalItemFactory *self);
};

struct _RygelExternalItemFactoryCreateForPathData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalItemFactory* self;
	char* object_path;
	RygelExternalContainer* parent;
	RygelMediaItem* result;
	RygelMediaItem* _tmp2_;
	char* _tmp0_;
	RygelMediaItem* _tmp1_;
	GError * _inner_error_;
};

struct _RygelExternalItemFactoryCreateForIdData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalItemFactory* self;
	char* id;
	RygelExternalContainer* parent;
	RygelMediaItem* result;
	char* object_path;
	RygelMediaItem* _tmp0_;
	GError * _inner_error_;
};

struct _RygelExternalMediaObjectIface {
	GTypeInterface parent_iface;
	char* (*get_parent) (RygelExternalMediaObject* self);
	void (*set_parent) (RygelExternalMediaObject* self, const char* value);
	char* (*get_display_name) (RygelExternalMediaObject* self);
	void (*set_display_name) (RygelExternalMediaObject* self, const char* value);
};

struct _RygelExternalMediaContainerIface {
	GTypeInterface parent_iface;
	char** (*get_items) (RygelExternalMediaContainer* self, int* result_length1);
	void (*set_items) (RygelExternalMediaContainer* self, char** value, int value_length1);
	char** (*get_containers) (RygelExternalMediaContainer* self, int* result_length1);
	void (*set_containers) (RygelExternalMediaContainer* self, char** value, int value_length1);
	guint (*get_item_count) (RygelExternalMediaContainer* self);
	void (*set_item_count) (RygelExternalMediaContainer* self, guint value);
	guint (*get_container_count) (RygelExternalMediaContainer* self);
	void (*set_container_count) (RygelExternalMediaContainer* self, guint value);
	char* (*get_icon) (RygelExternalMediaContainer* self);
	void (*set_icon) (RygelExternalMediaContainer* self, const char* value);
};

struct _RygelExternalContainer {
	RygelMediaContainer parent_instance;
	RygelExternalContainerPrivate * priv;
	RygelExternalMediaContainer* actual_container;
	char* host_ip;
	char* service_name;
};

struct _RygelExternalContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _FreeDesktopPropertiesIface {
	GTypeInterface parent_iface;
	void (*get_all) (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*get_all_finish) (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
};

struct _RygelExternalMediaItemIface {
	GTypeInterface parent_iface;
	char** (*get_urls) (RygelExternalMediaItem* self, int* result_length1);
	void (*set_urls) (RygelExternalMediaItem* self, char** value, int value_length1);
	char* (*get_mime_type) (RygelExternalMediaItem* self);
	void (*set_mime_type) (RygelExternalMediaItem* self, const char* value);
	char* (*get_media_type) (RygelExternalMediaItem* self);
	void (*set_media_type) (RygelExternalMediaItem* self, const char* value);
	gint (*get_size) (RygelExternalMediaItem* self);
	void (*set_size) (RygelExternalMediaItem* self, gint value);
	char* (*get_artist) (RygelExternalMediaItem* self);
	void (*set_artist) (RygelExternalMediaItem* self, const char* value);
	char* (*get_album) (RygelExternalMediaItem* self);
	void (*set_album) (RygelExternalMediaItem* self, const char* value);
	char* (*get_date) (RygelExternalMediaItem* self);
	void (*set_date) (RygelExternalMediaItem* self, const char* value);
	char* (*get_genre) (RygelExternalMediaItem* self);
	void (*set_genre) (RygelExternalMediaItem* self, const char* value);
	char* (*get_dlna_profile) (RygelExternalMediaItem* self);
	void (*set_dlna_profile) (RygelExternalMediaItem* self, const char* value);
	gint (*get_duration) (RygelExternalMediaItem* self);
	void (*set_duration) (RygelExternalMediaItem* self, gint value);
	gint (*get_bitrate) (RygelExternalMediaItem* self);
	void (*set_bitrate) (RygelExternalMediaItem* self, gint value);
	gint (*get_sample_rate) (RygelExternalMediaItem* self);
	void (*set_sample_rate) (RygelExternalMediaItem* self, gint value);
	gint (*get_bits_per_sample) (RygelExternalMediaItem* self);
	void (*set_bits_per_sample) (RygelExternalMediaItem* self, gint value);
	gint (*get_width) (RygelExternalMediaItem* self);
	void (*set_width) (RygelExternalMediaItem* self, gint value);
	gint (*get_height) (RygelExternalMediaItem* self);
	void (*set_height) (RygelExternalMediaItem* self, gint value);
	gint (*get_color_depth) (RygelExternalMediaItem* self);
	void (*set_color_depth) (RygelExternalMediaItem* self, gint value);
	char* (*get_thumbnail) (RygelExternalMediaItem* self);
	void (*set_thumbnail) (RygelExternalMediaItem* self, const char* value);
	char* (*get_album_art) (RygelExternalMediaItem* self);
	void (*set_album_art) (RygelExternalMediaItem* self, const char* value);
};

struct _RygelExternalItemFactoryCreateData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalItemFactory* self;
	char* id;
	char* object_path;
	RygelExternalContainer* parent;
	RygelMediaItem* result;
	DBusGConnection* connection;
	FreeDesktopProperties* props;
	GHashTable* object_props;
	GHashTable* item_props;
	RygelMediaItem* item;
	GValue* value;
	GValue* _tmp0_;
	char* type;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	GValue* _tmp5_;
	char* _tmp6_;
	RygelExternalMediaItem* item_iface;
	char** uris;
	gint _tmp7_;
	char** _tmp8_;
	gint uris_size;
	gint uris_length1;
	gint i;
	gboolean _tmp9_;
	char* tmp;
	GValue* _tmp10_;
	char* _tmp11_;
	GValue* _tmp12_;
	GValue* _tmp13_;
	char* _tmp14_;
	GValue* _tmp15_;
	char* _tmp16_;
	GValue* _tmp17_;
	char* _tmp18_;
	GValue* _tmp19_;
	GValue* _tmp20_;
	GValue* _tmp21_;
	GValue* _tmp22_;
	GValue* _tmp23_;
	GValue* _tmp24_;
	GValue* _tmp25_;
	GValue* _tmp26_;
	GValue* _tmp27_;
	GValue* _tmp28_;
	RygelExternalThumbnailFactory* factory;
	RygelThumbnail* thumbnail;
	GError * _inner_error_;
};

struct _RygelParamSpecExternalItemFactory {
	GParamSpec parent_instance;
};


static char* rygel_external_item_factory_OBJECT_IFACE;
static char* rygel_external_item_factory_OBJECT_IFACE = NULL;
static char* rygel_external_item_factory_ITEM_IFACE;
static char* rygel_external_item_factory_ITEM_IFACE = NULL;
static gpointer rygel_external_item_factory_parent_class = NULL;

gpointer rygel_external_item_factory_ref (gpointer instance);
void rygel_external_item_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_external_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_external_item_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_external_item_factory (const GValue* value);
GType rygel_external_item_factory_get_type (void);
enum  {
	RYGEL_EXTERNAL_ITEM_FACTORY_DUMMY_PROPERTY
};
static void rygel_external_item_factory_create_for_path_data_free (gpointer _data);
GType rygel_external_container_get_type (void);
static void rygel_external_item_factory_create_for_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_external_item_factory_create (RygelExternalItemFactory* self, const char* id, const char* object_path, RygelExternalContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaItem* rygel_external_item_factory_create_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
void rygel_external_item_factory_create_for_path (RygelExternalItemFactory* self, const char* object_path, RygelExternalContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaItem* rygel_external_item_factory_create_for_path_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_external_item_factory_create_for_path_co (RygelExternalItemFactoryCreateForPathData* data);
static void rygel_external_item_factory_create_for_id_data_free (gpointer _data);
static void rygel_external_item_factory_create_for_id_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_external_item_factory_create_for_id (RygelExternalItemFactory* self, const char* id, RygelExternalContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaItem* rygel_external_item_factory_create_for_id_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_external_item_factory_create_for_id_co (RygelExternalItemFactoryCreateForIdData* data);
static void rygel_external_item_factory_create_data_free (gpointer _data);
static void rygel_external_item_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_external_media_object_get_type (void);
GType rygel_external_media_container_get_type (void);
GType free_desktop_properties_get_type (void);
void free_desktop_properties_get_all (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* free_desktop_properties_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
static GValue* _g_value_dup (GValue* self);
GType rygel_external_media_item_get_type (void);
char** rygel_external_media_item_get_urls (RygelExternalMediaItem* self, int* result_length1);
RygelExternalThumbnailFactory* rygel_external_thumbnail_factory_new (void);
RygelExternalThumbnailFactory* rygel_external_thumbnail_factory_construct (GType object_type);
gpointer rygel_external_thumbnail_factory_ref (gpointer instance);
void rygel_external_thumbnail_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_external_thumbnail_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_external_thumbnail_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_external_thumbnail_factory (const GValue* value);
GType rygel_external_thumbnail_factory_get_type (void);
void rygel_external_thumbnail_factory_create (RygelExternalThumbnailFactory* self, const char* service_name, const char* object_path, const char* host_ip, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelThumbnail* rygel_external_thumbnail_factory_create_finish (RygelExternalThumbnailFactory* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_external_item_factory_create_co (RygelExternalItemFactoryCreateData* data);
gboolean rygel_external_item_factory_id_valid (const char* id);
RygelExternalItemFactory* rygel_external_item_factory_new (void);
RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type);
static void rygel_external_item_factory_finalize (RygelExternalItemFactory* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void rygel_external_item_factory_create_for_path_data_free (gpointer _data) {
	RygelExternalItemFactoryCreateForPathData* data;
	data = _data;
	_g_free0 (data->object_path);
	_g_object_unref0 (data->parent);
	_g_object_unref0 (data->result);
	g_slice_free (RygelExternalItemFactoryCreateForPathData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_external_item_factory_create_for_path (RygelExternalItemFactory* self, const char* object_path, RygelExternalContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalItemFactoryCreateForPathData* _data_;
	_data_ = g_slice_new0 (RygelExternalItemFactoryCreateForPathData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_external_item_factory_create_for_path);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_item_factory_create_for_path_data_free);
	_data_->self = self;
	_data_->object_path = g_strdup (object_path);
	_data_->parent = _g_object_ref0 (parent);
	rygel_external_item_factory_create_for_path_co (_data_);
}


RygelMediaItem* rygel_external_item_factory_create_for_path_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error) {
	RygelMediaItem* result;
	RygelExternalItemFactoryCreateForPathData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_item_factory_create_for_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalItemFactoryCreateForPathData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_item_factory_create_for_path_co (data);
}


static gboolean rygel_external_item_factory_create_for_path_co (RygelExternalItemFactoryCreateForPathData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			rygel_external_item_factory_create (data->self, data->_tmp0_ = g_strconcat ("item:", data->object_path, NULL), data->object_path, data->parent, rygel_external_item_factory_create_for_path_ready, data);
			data->_state_ = 5;
			return FALSE;
			case 5:
			data->_tmp2_ = (data->_tmp1_ = rygel_external_item_factory_create_finish (data->self, data->_res_, &data->_inner_error_), _g_free0 (data->_tmp0_), data->_tmp1_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->result = data->_tmp2_;
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_external_item_factory_create_for_id_data_free (gpointer _data) {
	RygelExternalItemFactoryCreateForIdData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->parent);
	_g_object_unref0 (data->result);
	g_slice_free (RygelExternalItemFactoryCreateForIdData, data);
}


void rygel_external_item_factory_create_for_id (RygelExternalItemFactory* self, const char* id, RygelExternalContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalItemFactoryCreateForIdData* _data_;
	_data_ = g_slice_new0 (RygelExternalItemFactoryCreateForIdData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_external_item_factory_create_for_id);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_item_factory_create_for_id_data_free);
	_data_->self = self;
	_data_->id = g_strdup (id);
	_data_->parent = _g_object_ref0 (parent);
	rygel_external_item_factory_create_for_id_co (_data_);
}


RygelMediaItem* rygel_external_item_factory_create_for_id_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error) {
	RygelMediaItem* result;
	RygelExternalItemFactoryCreateForIdData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_item_factory_create_for_id_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalItemFactoryCreateForIdData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_item_factory_create_for_id_co (data);
}


static gboolean rygel_external_item_factory_create_for_id_co (RygelExternalItemFactoryCreateForIdData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->object_path = g_strdup (strstr (data->id, "/"));
			g_assert (data->object_path != NULL);
			rygel_external_item_factory_create (data->self, data->id, data->object_path, data->parent, rygel_external_item_factory_create_for_id_ready, data);
			data->_state_ = 6;
			return FALSE;
			case 6:
			data->_tmp0_ = rygel_external_item_factory_create_finish (data->self, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_free0 (data->object_path);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->result = data->_tmp0_;
			_g_free0 (data->object_path);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_free0 (data->object_path);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_external_item_factory_create_data_free (gpointer _data) {
	RygelExternalItemFactoryCreateData* data;
	data = _data;
	_g_free0 (data->id);
	_g_free0 (data->object_path);
	_g_object_unref0 (data->parent);
	_g_object_unref0 (data->result);
	g_slice_free (RygelExternalItemFactoryCreateData, data);
}


static void rygel_external_item_factory_create (RygelExternalItemFactory* self, const char* id, const char* object_path, RygelExternalContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalItemFactoryCreateData* _data_;
	_data_ = g_slice_new0 (RygelExternalItemFactoryCreateData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_external_item_factory_create);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_item_factory_create_data_free);
	_data_->self = self;
	_data_->id = g_strdup (id);
	_data_->object_path = g_strdup (object_path);
	_data_->parent = _g_object_ref0 (parent);
	rygel_external_item_factory_create_co (_data_);
}


static RygelMediaItem* rygel_external_item_factory_create_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error) {
	RygelMediaItem* result;
	RygelExternalItemFactoryCreateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_item_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalItemFactoryCreateData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_item_factory_create_co (data);
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			goto __finally3;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			goto __finally3;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean rygel_external_item_factory_create_co (RygelExternalItemFactoryCreateData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->connection = dbus_g_bus_get (DBUS_BUS_SESSION, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->props = free_desktop_properties_dbus_proxy_new (data->connection, data->parent->service_name, data->object_path);
			free_desktop_properties_get_all (data->props, rygel_external_item_factory_OBJECT_IFACE, rygel_external_item_factory_create_ready, data);
			data->_state_ = 7;
			return FALSE;
			case 7:
			data->object_props = free_desktop_properties_get_all_finish (data->props, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_dbus_g_connection_unref0 (data->connection);
				_g_object_unref0 (data->props);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			free_desktop_properties_get_all (data->props, rygel_external_item_factory_ITEM_IFACE, rygel_external_item_factory_create_ready, data);
			data->_state_ = 8;
			return FALSE;
			case 8:
			data->item_props = free_desktop_properties_get_all_finish (data->props, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_dbus_g_connection_unref0 (data->connection);
				_g_object_unref0 (data->props);
				_g_hash_table_unref0 (data->object_props);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->item = rygel_media_item_new (data->id, (RygelMediaContainer*) data->parent, "Unknown", "Unknown");
			data->value = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->object_props, "DisplayName"));
			rygel_media_object_set_title ((RygelMediaObject*) data->item, g_value_get_string (data->value));
			data->value = (data->_tmp0_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "Type")), _g_free0 (data->value), data->_tmp0_);
			data->type = g_strdup (g_value_get_string (data->value));
			if (_vala_strcmp0 (data->type, "audio") == 0) {
				((RygelMediaObject*) data->item)->upnp_class = (data->_tmp1_ = g_strdup (RYGEL_MEDIA_ITEM_AUDIO_CLASS), _g_free0 (((RygelMediaObject*) data->item)->upnp_class), data->_tmp1_);
			} else {
				if (_vala_strcmp0 (data->type, "music") == 0) {
					((RygelMediaObject*) data->item)->upnp_class = (data->_tmp2_ = g_strdup (RYGEL_MEDIA_ITEM_MUSIC_CLASS), _g_free0 (((RygelMediaObject*) data->item)->upnp_class), data->_tmp2_);
				} else {
					if (_vala_strcmp0 (data->type, "video") == 0) {
						((RygelMediaObject*) data->item)->upnp_class = (data->_tmp3_ = g_strdup (RYGEL_MEDIA_ITEM_VIDEO_CLASS), _g_free0 (((RygelMediaObject*) data->item)->upnp_class), data->_tmp3_);
					} else {
						((RygelMediaObject*) data->item)->upnp_class = (data->_tmp4_ = g_strdup (RYGEL_MEDIA_ITEM_IMAGE_CLASS), _g_free0 (((RygelMediaObject*) data->item)->upnp_class), data->_tmp4_);
					}
				}
			}
			data->value = (data->_tmp5_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "MIMEType")), _g_free0 (data->value), data->_tmp5_);
			data->item->mime_type = (data->_tmp6_ = g_strdup (g_value_get_string (data->value)), _g_free0 (data->item->mime_type), data->_tmp6_);
			data->item_iface = rygel_external_media_item_dbus_proxy_new (data->connection, data->parent->service_name, data->object_path);
			data->uris = (data->_tmp8_ = rygel_external_media_item_get_urls (data->item_iface, &data->_tmp7_), data->uris_length1 = data->_tmp7_, data->uris_size = data->uris_length1, data->_tmp8_);
			{
				data->i = 0;
				{
					data->_tmp9_ = TRUE;
					while (TRUE) {
						if (!data->_tmp9_) {
							data->i++;
						}
						data->_tmp9_ = FALSE;
						if (!(data->uris[data->i] != NULL)) {
							break;
						}
						data->tmp = string_replace (data->uris[data->i], "@ADDRESS@", data->parent->host_ip);
						rygel_media_item_add_uri (data->item, data->tmp, NULL);
						_g_free0 (data->tmp);
					}
				}
			}
			data->value = (data->_tmp10_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "DLNAProfile")), _g_free0 (data->value), data->_tmp10_);
			if (data->value != NULL) {
				data->item->dlna_profile = (data->_tmp11_ = g_strdup (g_value_get_string (data->value)), _g_free0 (data->item->dlna_profile), data->_tmp11_);
			}
			data->value = (data->_tmp12_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "Size")), _g_free0 (data->value), data->_tmp12_);
			if (data->value != NULL) {
				data->item->size = (glong) g_value_get_int (data->value);
			}
			data->value = (data->_tmp13_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "Artist")), _g_free0 (data->value), data->_tmp13_);
			if (data->value != NULL) {
				data->item->author = (data->_tmp14_ = g_strdup (g_value_get_string (data->value)), _g_free0 (data->item->author), data->_tmp14_);
			}
			data->value = (data->_tmp15_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "Album")), _g_free0 (data->value), data->_tmp15_);
			if (data->value != NULL) {
				data->item->album = (data->_tmp16_ = g_strdup (g_value_get_string (data->value)), _g_free0 (data->item->album), data->_tmp16_);
			}
			data->value = (data->_tmp17_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "Date")), _g_free0 (data->value), data->_tmp17_);
			if (data->value != NULL) {
				data->item->date = (data->_tmp18_ = g_strdup (g_value_get_string (data->value)), _g_free0 (data->item->date), data->_tmp18_);
			}
			data->value = (data->_tmp19_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "Duration")), _g_free0 (data->value), data->_tmp19_);
			if (data->value != NULL) {
				data->item->duration = (glong) g_value_get_int (data->value);
			}
			data->value = (data->_tmp20_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "Bitrate")), _g_free0 (data->value), data->_tmp20_);
			if (data->value != NULL) {
				data->item->bitrate = g_value_get_int (data->value);
			}
			data->value = (data->_tmp21_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "SampleRate")), _g_free0 (data->value), data->_tmp21_);
			if (data->value != NULL) {
				data->item->sample_freq = g_value_get_int (data->value);
			}
			data->value = (data->_tmp22_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "BitsPerSample")), _g_free0 (data->value), data->_tmp22_);
			if (data->value != NULL) {
				data->item->bits_per_sample = g_value_get_int (data->value);
			}
			data->value = (data->_tmp23_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "Width")), _g_free0 (data->value), data->_tmp23_);
			if (data->value != NULL) {
				data->item->width = g_value_get_int (data->value);
			}
			data->value = (data->_tmp24_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "Height")), _g_free0 (data->value), data->_tmp24_);
			if (data->value != NULL) {
				data->item->height = g_value_get_int (data->value);
			}
			data->value = (data->_tmp25_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "ColorDepth")), _g_free0 (data->value), data->_tmp25_);
			if (data->value != NULL) {
				data->item->color_depth = g_value_get_int (data->value);
			}
			data->value = (data->_tmp26_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "PixelWidth")), _g_free0 (data->value), data->_tmp26_);
			if (data->value != NULL) {
				data->item->pixel_width = g_value_get_int (data->value);
			}
			data->value = (data->_tmp27_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "PixelHeight")), _g_free0 (data->value), data->_tmp27_);
			if (data->value != NULL) {
				data->item->pixel_height = g_value_get_int (data->value);
			}
			data->value = (data->_tmp28_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "Thumbnail")), _g_free0 (data->value), data->_tmp28_);
			if (data->value != NULL) {
				data->factory = rygel_external_thumbnail_factory_new ();
				rygel_external_thumbnail_factory_create (data->factory, g_value_get_string (data->value), data->parent->service_name, data->parent->host_ip, rygel_external_item_factory_create_ready, data);
				data->_state_ = 9;
				return FALSE;
				case 9:
				data->thumbnail = rygel_external_thumbnail_factory_create_finish (data->factory, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_rygel_external_thumbnail_factory_unref0 (data->factory);
					_dbus_g_connection_unref0 (data->connection);
					_g_object_unref0 (data->props);
					_g_hash_table_unref0 (data->object_props);
					_g_hash_table_unref0 (data->item_props);
					_g_object_unref0 (data->item);
					_g_free0 (data->value);
					_g_free0 (data->type);
					_g_object_unref0 (data->item_iface);
					data->uris = (_vala_array_free (data->uris, data->uris_length1, (GDestroyNotify) g_free), NULL);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) data->item->thumbnails, data->thumbnail);
				_rygel_external_thumbnail_factory_unref0 (data->factory);
				_rygel_icon_info_unref0 (data->thumbnail);
			}
			data->result = data->item;
			_dbus_g_connection_unref0 (data->connection);
			_g_object_unref0 (data->props);
			_g_hash_table_unref0 (data->object_props);
			_g_hash_table_unref0 (data->item_props);
			_g_free0 (data->value);
			_g_free0 (data->type);
			_g_object_unref0 (data->item_iface);
			data->uris = (_vala_array_free (data->uris, data->uris_length1, (GDestroyNotify) g_free), NULL);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_dbus_g_connection_unref0 (data->connection);
			_g_object_unref0 (data->props);
			_g_hash_table_unref0 (data->object_props);
			_g_hash_table_unref0 (data->item_props);
			_g_object_unref0 (data->item);
			_g_free0 (data->value);
			_g_free0 (data->type);
			_g_object_unref0 (data->item_iface);
			data->uris = (_vala_array_free (data->uris, data->uris_length1, (GDestroyNotify) g_free), NULL);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


gboolean rygel_external_item_factory_id_valid (const char* id) {
	gboolean result;
	g_return_val_if_fail (id != NULL, FALSE);
	result = g_str_has_prefix (id, "item:/");
	return result;
}


RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type) {
	RygelExternalItemFactory* self;
	self = (RygelExternalItemFactory*) g_type_create_instance (object_type);
	return self;
}


RygelExternalItemFactory* rygel_external_item_factory_new (void) {
	return rygel_external_item_factory_construct (RYGEL_TYPE_EXTERNAL_ITEM_FACTORY);
}


static void rygel_value_external_item_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_external_item_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_external_item_factory_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_external_item_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_external_item_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_external_item_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_external_item_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelExternalItemFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_external_item_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_external_item_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelExternalItemFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_external_item_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_external_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecExternalItemFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_EXTERNAL_ITEM_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_external_item_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_EXTERNAL_ITEM_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_external_item_factory (GValue* value, gpointer v_object) {
	RygelExternalItemFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_EXTERNAL_ITEM_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_EXTERNAL_ITEM_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_external_item_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_item_factory_unref (old);
	}
}


static void rygel_external_item_factory_class_init (RygelExternalItemFactoryClass * klass) {
	rygel_external_item_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_EXTERNAL_ITEM_FACTORY_CLASS (klass)->finalize = rygel_external_item_factory_finalize;
	rygel_external_item_factory_OBJECT_IFACE = g_strdup ("org.gnome.UPnP.MediaObject1");
	rygel_external_item_factory_ITEM_IFACE = g_strdup ("org.gnome.UPnP.MediaItem1");
}


static void rygel_external_item_factory_instance_init (RygelExternalItemFactory * self) {
	self->ref_count = 1;
}


static void rygel_external_item_factory_finalize (RygelExternalItemFactory* obj) {
	RygelExternalItemFactory * self;
	self = RYGEL_EXTERNAL_ITEM_FACTORY (obj);
}


GType rygel_external_item_factory_get_type (void) {
	static GType rygel_external_item_factory_type_id = 0;
	if (rygel_external_item_factory_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_external_item_factory_init, rygel_value_external_item_factory_free_value, rygel_value_external_item_factory_copy_value, rygel_value_external_item_factory_peek_pointer, "p", rygel_value_external_item_factory_collect_value, "p", rygel_value_external_item_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalItemFactory), 0, (GInstanceInitFunc) rygel_external_item_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		rygel_external_item_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelExternalItemFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return rygel_external_item_factory_type_id;
}


gpointer rygel_external_item_factory_ref (gpointer instance) {
	RygelExternalItemFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_external_item_factory_unref (gpointer instance) {
	RygelExternalItemFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




