/* rygel-external-container.c generated by valac, the Vala compiler
 * generated from rygel-external-container.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_EXTERNAL_CONTAINER (rygel_external_container_get_type ())
#define RYGEL_EXTERNAL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_CONTAINER, RygelExternalContainer))
#define RYGEL_EXTERNAL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_EXTERNAL_CONTAINER, RygelExternalContainerClass))
#define RYGEL_IS_EXTERNAL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_CONTAINER))
#define RYGEL_IS_EXTERNAL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_EXTERNAL_CONTAINER))
#define RYGEL_EXTERNAL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_EXTERNAL_CONTAINER, RygelExternalContainerClass))

typedef struct _RygelExternalContainer RygelExternalContainer;
typedef struct _RygelExternalContainerClass RygelExternalContainerClass;
typedef struct _RygelExternalContainerPrivate RygelExternalContainerPrivate;

#define RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT (rygel_external_media_object_get_type ())
#define RYGEL_EXTERNAL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT, RygelExternalMediaObject))
#define RYGEL_IS_EXTERNAL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT))
#define RYGEL_EXTERNAL_MEDIA_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_OBJECT, RygelExternalMediaObjectIface))

typedef struct _RygelExternalMediaObject RygelExternalMediaObject;
typedef struct _RygelExternalMediaObjectIface RygelExternalMediaObjectIface;

#define RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER (rygel_external_media_container_get_type ())
#define RYGEL_EXTERNAL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER, RygelExternalMediaContainer))
#define RYGEL_IS_EXTERNAL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER))
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_EXTERNAL_MEDIA_CONTAINER, RygelExternalMediaContainerIface))

typedef struct _RygelExternalMediaContainer RygelExternalMediaContainer;
typedef struct _RygelExternalMediaContainerIface RygelExternalMediaContainerIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_EXTERNAL_ITEM_FACTORY (rygel_external_item_factory_get_type ())
#define RYGEL_EXTERNAL_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY, RygelExternalItemFactory))
#define RYGEL_EXTERNAL_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY, RygelExternalItemFactoryClass))
#define RYGEL_IS_EXTERNAL_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY))
#define RYGEL_IS_EXTERNAL_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY))
#define RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_EXTERNAL_ITEM_FACTORY, RygelExternalItemFactoryClass))

typedef struct _RygelExternalItemFactory RygelExternalItemFactory;
typedef struct _RygelExternalItemFactoryClass RygelExternalItemFactoryClass;
#define _rygel_external_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_item_factory_unref (var), NULL)))
typedef struct _RygelExternalContainerGetChildrenData RygelExternalContainerGetChildrenData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelExternalContainerSearchData RygelExternalContainerSearchData;

struct _RygelExternalMediaObjectIface {
	GTypeInterface parent_iface;
	char* (*get_parent) (RygelExternalMediaObject* self);
	void (*set_parent) (RygelExternalMediaObject* self, const char* value);
	char* (*get_display_name) (RygelExternalMediaObject* self);
	void (*set_display_name) (RygelExternalMediaObject* self, const char* value);
};

struct _RygelExternalMediaContainerIface {
	GTypeInterface parent_iface;
	char** (*get_items) (RygelExternalMediaContainer* self, int* result_length1);
	void (*set_items) (RygelExternalMediaContainer* self, char** value, int value_length1);
	char** (*get_containers) (RygelExternalMediaContainer* self, int* result_length1);
	void (*set_containers) (RygelExternalMediaContainer* self, char** value, int value_length1);
	guint (*get_item_count) (RygelExternalMediaContainer* self);
	void (*set_item_count) (RygelExternalMediaContainer* self, guint value);
	guint (*get_container_count) (RygelExternalMediaContainer* self);
	void (*set_container_count) (RygelExternalMediaContainer* self, guint value);
	char* (*get_icon) (RygelExternalMediaContainer* self);
	void (*set_icon) (RygelExternalMediaContainer* self, const char* value);
};

struct _RygelExternalContainer {
	RygelMediaContainer parent_instance;
	RygelExternalContainerPrivate * priv;
	RygelExternalMediaContainer* actual_container;
	char* host_ip;
	char* service_name;
};

struct _RygelExternalContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelExternalContainerPrivate {
	char* object_path;
	GeeArrayList* containers;
};

struct _RygelExternalContainerGetChildrenData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	GeeList* result;
	GeeArrayList* media_objects;
	char** obj_paths;
	gint _tmp0_;
	char** _tmp1_;
	gint obj_paths_size;
	gint obj_paths_length1;
	RygelExternalItemFactory* factory;
	RygelMediaItem* item;
	GError * err;
	char** obj_path_collection;
	int obj_path_collection_length1;
	int obj_path_it;
	char* obj_path;
	guint stop;
	GError * _inner_error_;
};

struct _RygelExternalContainerSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	GeeList* result;
	GeeArrayList* results;
	gboolean _tmp0_;
	GeeList* _tmp1_;
	RygelRelationalExpression* rel_expression;
	RygelSearchExpression* _tmp2_;
	char* id;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GeeList* _tmp5_;
	RygelExternalItemFactory* factory;
	RygelMediaItem* media_object;
	GeeIterator* _container_it;
	RygelExternalContainer* container;
	GError * _inner_error_;
};


static gpointer rygel_external_container_parent_class = NULL;

GType rygel_external_container_get_type (void);
GType rygel_external_media_object_get_type (void);
GType rygel_external_media_container_get_type (void);
#define RYGEL_EXTERNAL_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_EXTERNAL_CONTAINER, RygelExternalContainerPrivate))
enum  {
	RYGEL_EXTERNAL_CONTAINER_DUMMY_PROPERTY
};
char* rygel_external_media_object_get_display_name (RygelExternalMediaObject* self);
static void rygel_external_container_update_container (RygelExternalContainer* self, GError** error);
static void rygel_external_container_on_updated (RygelExternalContainer* self, RygelExternalMediaContainer* actual_container);
static void _rygel_external_container_on_updated_rygel_external_media_container_updated (RygelExternalMediaContainer* _sender, gpointer self);
RygelExternalContainer* rygel_external_container_new (const char* id, const char* service_name, const char* object_path, const char* host_ip, RygelExternalContainer* parent);
RygelExternalContainer* rygel_external_container_construct (GType object_type, const char* id, const char* service_name, const char* object_path, const char* host_ip, RygelExternalContainer* parent);
static void rygel_external_container_real_get_children_data_free (gpointer _data);
static void rygel_external_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
char** rygel_external_media_container_get_items (RygelExternalMediaContainer* self, int* result_length1);
RygelExternalItemFactory* rygel_external_item_factory_new (void);
RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type);
gpointer rygel_external_item_factory_ref (gpointer instance);
void rygel_external_item_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_external_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_external_item_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_external_item_factory (const GValue* value);
GType rygel_external_item_factory_get_type (void);
void rygel_external_item_factory_create_for_path (RygelExternalItemFactory* self, const char* object_path, RygelExternalContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaItem* rygel_external_item_factory_create_for_path_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_external_container_real_get_children_co (RygelExternalContainerGetChildrenData* data);
static void rygel_external_container_real_search_data_free (gpointer _data);
static void rygel_external_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_external_container_is_direct_child (RygelExternalContainer* self, const char* id);
gboolean rygel_external_item_factory_id_valid (const char* id);
void rygel_external_item_factory_create_for_id (RygelExternalItemFactory* self, const char* id, RygelExternalContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaItem* rygel_external_item_factory_create_for_id_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_external_container_real_search_co (RygelExternalContainerSearchData* data);
char** rygel_external_media_container_get_containers (RygelExternalMediaContainer* self, int* result_length1);
guint rygel_external_media_container_get_item_count (RygelExternalMediaContainer* self);
static void rygel_external_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 188 "rygel-external-container.vala"
static void _rygel_external_container_on_updated_rygel_external_media_container_updated (RygelExternalMediaContainer* _sender, gpointer self) {
#line 228 "rygel-external-container.c"
	rygel_external_container_on_updated (self, _sender);
}


#line 42 "rygel-external-container.vala"
RygelExternalContainer* rygel_external_container_construct (GType object_type, const char* id, const char* service_name, const char* object_path, const char* host_ip, RygelExternalContainer* parent) {
#line 235 "rygel-external-container.c"
	GError * _inner_error_;
	RygelExternalContainer * self;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	GeeArrayList* _tmp3_;
#line 42 "rygel-external-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 42 "rygel-external-container.vala"
	g_return_val_if_fail (service_name != NULL, NULL);
#line 42 "rygel-external-container.vala"
	g_return_val_if_fail (object_path != NULL, NULL);
#line 42 "rygel-external-container.vala"
	g_return_val_if_fail (host_ip != NULL, NULL);
#line 250 "rygel-external-container.c"
	_inner_error_ = NULL;
#line 47 "rygel-external-container.vala"
	self = (RygelExternalContainer*) rygel_media_container_construct (object_type, id, (RygelMediaContainer*) parent, "Uknown", (guint) 0);
#line 49 "rygel-external-container.vala"
	self->service_name = (_tmp0_ = g_strdup (service_name), _g_free0 (self->service_name), _tmp0_);
#line 50 "rygel-external-container.vala"
	self->priv->object_path = (_tmp1_ = g_strdup (object_path), _g_free0 (self->priv->object_path), _tmp1_);
#line 51 "rygel-external-container.vala"
	self->host_ip = (_tmp2_ = g_strdup (host_ip), _g_free0 (self->host_ip), _tmp2_);
#line 53 "rygel-external-container.vala"
	self->priv->containers = (_tmp3_ = gee_array_list_new (RYGEL_TYPE_EXTERNAL_CONTAINER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->containers), _tmp3_);
#line 262 "rygel-external-container.c"
	{
		DBusGConnection* connection;
		RygelExternalMediaContainer* _tmp4_;
		char* _tmp5_;
#line 56 "rygel-external-container.vala"
		connection = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
#line 269 "rygel-external-container.c"
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
			goto __finally0;
		}
#line 59 "rygel-external-container.vala"
		self->actual_container = (_tmp4_ = rygel_external_media_container_dbus_proxy_new (connection, service_name, object_path), _g_object_unref0 (self->actual_container), _tmp4_);
#line 63 "rygel-external-container.vala"
		rygel_media_object_set_title ((RygelMediaObject*) self, _tmp5_ = rygel_external_media_object_get_display_name ((RygelExternalMediaObject*) self->actual_container));
#line 278 "rygel-external-container.c"
		_g_free0 (_tmp5_);
#line 65 "rygel-external-container.vala"
		rygel_external_container_update_container (self, &_inner_error_);
#line 282 "rygel-external-container.c"
		if (_inner_error_ != NULL) {
			_dbus_g_connection_unref0 (connection);
			goto __catch0_g_error;
			goto __finally0;
		}
#line 67 "rygel-external-container.vala"
		g_signal_connect_object (self->actual_container, "updated", (GCallback) _rygel_external_container_on_updated_rygel_external_media_container_updated, self, 0);
#line 290 "rygel-external-container.c"
		_dbus_g_connection_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 69 "rygel-external-container.vala"
			g_critical ("rygel-external-container.vala:69: Failed to fetch information about container '%s': %s\n", ((RygelMediaObject*) self)->id, err->message);
#line 302 "rygel-external-container.c"
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


#line 42 "rygel-external-container.vala"
RygelExternalContainer* rygel_external_container_new (const char* id, const char* service_name, const char* object_path, const char* host_ip, RygelExternalContainer* parent) {
#line 42 "rygel-external-container.vala"
	return rygel_external_container_construct (RYGEL_TYPE_EXTERNAL_CONTAINER, id, service_name, object_path, host_ip, parent);
#line 320 "rygel-external-container.c"
}


static void rygel_external_container_real_get_children_data_free (gpointer _data) {
	RygelExternalContainerGetChildrenData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (RygelExternalContainerGetChildrenData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_external_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainer * self;
	RygelExternalContainerGetChildrenData* _data_;
	self = (RygelExternalContainer*) base;
	_data_ = g_slice_new0 (RygelExternalContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_real_get_children_data_free);
	_data_->self = self;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_external_container_real_get_children_co (_data_);
}


static GeeList* rygel_external_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	GeeList* result;
	RygelExternalContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerGetChildrenData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_container_real_get_children_co (data);
}


static gboolean rygel_external_container_real_get_children_co (RygelExternalContainerGetChildrenData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->media_objects = gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 83 "rygel-external-container.vala"
			gee_abstract_collection_add_all ((GeeAbstractCollection*) data->media_objects, (GeeCollection*) data->self->priv->containers);
#line 383 "rygel-external-container.c"
			data->obj_paths = (data->_tmp1_ = rygel_external_media_container_get_items (data->self->actual_container, &data->_tmp0_), data->obj_paths_length1 = data->_tmp0_, data->obj_paths_size = data->obj_paths_length1, data->_tmp1_);
			data->factory = rygel_external_item_factory_new ();
			{
				data->obj_path_collection = data->obj_paths;
				data->obj_path_collection_length1 = data->obj_paths_length1;
				for (data->obj_path_it = 0; data->obj_path_it < data->obj_paths_length1; data->obj_path_it = data->obj_path_it + 1) {
					data->obj_path = g_strdup (data->obj_path_collection[data->obj_path_it]);
					{
						{
							rygel_external_item_factory_create_for_path (data->factory, data->obj_path, data->self, rygel_external_container_get_children_ready, data);
							data->_state_ = 1;
							return FALSE;
							case 1:
							data->item = rygel_external_item_factory_create_for_path_finish (data->factory, data->_res_, &data->_inner_error_);
							if (data->_inner_error_ != NULL) {
								goto __catch1_g_error;
								goto __finally1;
							}
#line 92 "rygel-external-container.vala"
							gee_abstract_collection_add ((GeeAbstractCollection*) data->media_objects, (RygelMediaObject*) data->item);
#line 404 "rygel-external-container.c"
							_g_object_unref0 (data->item);
						}
						goto __finally1;
						__catch1_g_error:
						{
							data->err = data->_inner_error_;
							data->_inner_error_ = NULL;
							{
#line 94 "rygel-external-container.vala"
								g_warning ("rygel-external-container.vala:94: Error initializable item at '%s': %s. Ignoring..", data->obj_path, data->err->message);
#line 415 "rygel-external-container.c"
								_g_error_free0 (data->err);
							}
						}
						__finally1:
						if (data->_inner_error_ != NULL) {
							g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
							g_error_free (data->_inner_error_);
							_g_free0 (data->obj_path);
							_g_object_unref0 (data->media_objects);
							data->obj_paths = (_vala_array_free (data->obj_paths, data->obj_paths_length1, (GDestroyNotify) g_free), NULL);
							_rygel_external_item_factory_unref0 (data->factory);
							{
								if (data->_state_ == 0) {
									g_simple_async_result_complete_in_idle (data->_async_result);
								} else {
									g_simple_async_result_complete (data->_async_result);
								}
								g_object_unref (data->_async_result);
								return FALSE;
							}
						}
						_g_free0 (data->obj_path);
					}
				}
			}
			data->stop = data->offset + data->max_count;
#line 101 "rygel-external-container.vala"
			data->stop = CLAMP (data->stop, (guint) 0, (guint) gee_collection_get_size ((GeeCollection*) data->media_objects));
#line 444 "rygel-external-container.c"
			data->result = gee_abstract_list_slice ((GeeAbstractList*) data->media_objects, (gint) data->offset, (gint) data->stop);
			_g_object_unref0 (data->media_objects);
			data->obj_paths = (_vala_array_free (data->obj_paths, data->obj_paths_length1, (GDestroyNotify) g_free), NULL);
			_rygel_external_item_factory_unref0 (data->factory);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->media_objects);
			data->obj_paths = (_vala_array_free (data->obj_paths, data->obj_paths_length1, (GDestroyNotify) g_free), NULL);
			_rygel_external_item_factory_unref0 (data->factory);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_external_container_real_search_data_free (gpointer _data) {
	RygelExternalContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (RygelExternalContainerSearchData, data);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_external_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainer * self;
	RygelExternalContainerSearchData* _data_;
	self = (RygelExternalContainer*) base;
	_data_ = g_slice_new0 (RygelExternalContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_real_search_data_free);
	_data_->self = self;
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_external_container_real_search_co (_data_);
}


static GeeList* rygel_external_container_real_search_finish (RygelMediaContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	GeeList* result;
	RygelExternalContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	_data_->total_matches = NULL;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_container_real_search_co (data);
}


static gboolean rygel_external_container_real_search_co (RygelExternalContainerSearchData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->results = gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 116 "rygel-external-container.vala"
			if (data->expression == NULL) {
#line 116 "rygel-external-container.vala"
				data->_tmp0_ = TRUE;
#line 540 "rygel-external-container.c"
			} else {
#line 116 "rygel-external-container.vala"
				data->_tmp0_ = !RYGEL_IS_RELATIONAL_EXPRESSION (data->expression);
#line 544 "rygel-external-container.c"
			}
#line 116 "rygel-external-container.vala"
			if (data->_tmp0_) {
#line 548 "rygel-external-container.c"
				RYGEL_MEDIA_CONTAINER_CLASS (rygel_external_container_parent_class)->search (RYGEL_MEDIA_CONTAINER (data->self), data->expression, data->offset, data->max_count, data->cancellable, rygel_external_container_search_ready, data);
				data->_state_ = 2;
				return FALSE;
				case 2:
				data->_tmp1_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_external_container_parent_class)->search_finish (RYGEL_MEDIA_CONTAINER (data->self), data->_res_, &data->total_matches, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->results);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
				data->result = data->_tmp1_;
				_g_object_unref0 (data->results);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->rel_expression = _rygel_search_expression_ref0 ((data->_tmp2_ = data->expression, RYGEL_IS_RELATIONAL_EXPRESSION (data->_tmp2_) ? ((RygelRelationalExpression*) data->_tmp2_) : NULL));
			data->id = g_strdup ((const char*) ((RygelSearchExpression*) data->rel_expression)->operand2);
#line 128 "rygel-external-container.vala"
			if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) data->rel_expression)->operand1, "@id") != 0) {
#line 128 "rygel-external-container.vala"
				data->_tmp4_ = TRUE;
#line 586 "rygel-external-container.c"
			} else {
#line 129 "rygel-external-container.vala"
				data->_tmp4_ = GPOINTER_TO_INT (((RygelSearchExpression*) data->rel_expression)->op) != GUPNP_SEARCH_CRITERIA_OP_EQ;
#line 590 "rygel-external-container.c"
			}
#line 128 "rygel-external-container.vala"
			if (data->_tmp4_) {
#line 128 "rygel-external-container.vala"
				data->_tmp3_ = TRUE;
#line 596 "rygel-external-container.c"
			} else {
#line 130 "rygel-external-container.vala"
				data->_tmp3_ = !rygel_external_container_is_direct_child (data->self, data->id);
#line 600 "rygel-external-container.c"
			}
#line 128 "rygel-external-container.vala"
			if (data->_tmp3_) {
#line 604 "rygel-external-container.c"
				RYGEL_MEDIA_CONTAINER_CLASS (rygel_external_container_parent_class)->search (RYGEL_MEDIA_CONTAINER (data->self), data->expression, data->offset, data->max_count, data->cancellable, rygel_external_container_search_ready, data);
				data->_state_ = 3;
				return FALSE;
				case 3:
				data->_tmp5_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_external_container_parent_class)->search_finish (RYGEL_MEDIA_CONTAINER (data->self), data->_res_, &data->total_matches, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->results);
					_rygel_search_expression_unref0 (data->rel_expression);
					_g_free0 (data->id);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
				data->result = data->_tmp5_;
				_g_object_unref0 (data->results);
				_rygel_search_expression_unref0 (data->rel_expression);
				_g_free0 (data->id);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->factory = rygel_external_item_factory_new ();
#line 140 "rygel-external-container.vala"
			if (rygel_external_item_factory_id_valid (data->id)) {
#line 643 "rygel-external-container.c"
				rygel_external_item_factory_create_for_id (data->factory, data->id, data->self, rygel_external_container_search_ready, data);
				data->_state_ = 4;
				return FALSE;
				case 4:
				data->media_object = rygel_external_item_factory_create_for_id_finish (data->factory, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->results);
					_rygel_search_expression_unref0 (data->rel_expression);
					_g_free0 (data->id);
					_rygel_external_item_factory_unref0 (data->factory);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
#line 142 "rygel-external-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) data->results, (RygelMediaObject*) data->media_object);
#line 668 "rygel-external-container.c"
				_g_object_unref0 (data->media_object);
			} else {
				{
					data->_container_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->self->priv->containers);
#line 144 "rygel-external-container.vala"
					while (TRUE) {
#line 144 "rygel-external-container.vala"
						if (!gee_iterator_next (data->_container_it)) {
#line 144 "rygel-external-container.vala"
							break;
#line 679 "rygel-external-container.c"
						}
						data->container = (RygelExternalContainer*) gee_iterator_get (data->_container_it);
#line 145 "rygel-external-container.vala"
						if (_vala_strcmp0 (((RygelMediaObject*) data->container)->id, data->id) == 0) {
#line 146 "rygel-external-container.vala"
							gee_abstract_collection_add ((GeeAbstractCollection*) data->results, (RygelMediaObject*) data->container);
#line 686 "rygel-external-container.c"
						}
						_g_object_unref0 (data->container);
					}
					_g_object_unref0 (data->_container_it);
				}
			}
#line 151 "rygel-external-container.vala"
			data->total_matches = (guint) gee_collection_get_size ((GeeCollection*) data->results);
#line 695 "rygel-external-container.c"
			data->result = (GeeList*) data->results;
			_rygel_search_expression_unref0 (data->rel_expression);
			_g_free0 (data->id);
			_rygel_external_item_factory_unref0 (data->factory);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->results);
			_rygel_search_expression_unref0 (data->rel_expression);
			_g_free0 (data->id);
			_rygel_external_item_factory_unref0 (data->factory);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


#line 156 "rygel-external-container.vala"
static gboolean rygel_external_container_is_direct_child (RygelExternalContainer* self, const char* id) {
#line 729 "rygel-external-container.c"
	gboolean result;
#line 156 "rygel-external-container.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 156 "rygel-external-container.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 157 "rygel-external-container.vala"
	if (rygel_external_item_factory_id_valid (id)) {
#line 737 "rygel-external-container.c"
		result = TRUE;
#line 158 "rygel-external-container.vala"
		return result;
#line 741 "rygel-external-container.c"
	} else {
		{
			GeeIterator* _container_it;
			_container_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->containers);
#line 160 "rygel-external-container.vala"
			while (TRUE) {
#line 748 "rygel-external-container.c"
				RygelExternalContainer* container;
#line 160 "rygel-external-container.vala"
				if (!gee_iterator_next (_container_it)) {
#line 160 "rygel-external-container.vala"
					break;
#line 754 "rygel-external-container.c"
				}
#line 160 "rygel-external-container.vala"
				container = (RygelExternalContainer*) gee_iterator_get (_container_it);
#line 161 "rygel-external-container.vala"
				if (_vala_strcmp0 (((RygelMediaObject*) container)->id, id) == 0) {
#line 760 "rygel-external-container.c"
					result = TRUE;
					_g_object_unref0 (container);
					_g_object_unref0 (_container_it);
#line 162 "rygel-external-container.vala"
					return result;
#line 766 "rygel-external-container.c"
				}
				_g_object_unref0 (container);
			}
			_g_object_unref0 (_container_it);
		}
		result = FALSE;
#line 166 "rygel-external-container.vala"
		return result;
#line 775 "rygel-external-container.c"
	}
}


#line 170 "rygel-external-container.vala"
static void rygel_external_container_update_container (RygelExternalContainer* self, GError** error) {
#line 782 "rygel-external-container.c"
	char** _tmp1_;
	gint obj_paths_size;
	gint obj_paths_length1;
	gint _tmp0_;
	char** obj_paths;
#line 170 "rygel-external-container.vala"
	g_return_if_fail (self != NULL);
#line 171 "rygel-external-container.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->containers);
#line 792 "rygel-external-container.c"
	obj_paths = (_tmp1_ = rygel_external_media_container_get_containers (self->actual_container, &_tmp0_), obj_paths_length1 = _tmp0_, obj_paths_size = obj_paths_length1, _tmp1_);
	{
		char** obj_path_collection;
		int obj_path_collection_length1;
		int obj_path_it;
#line 174 "rygel-external-container.vala"
		obj_path_collection = obj_paths;
#line 800 "rygel-external-container.c"
		obj_path_collection_length1 = obj_paths_length1;
		for (obj_path_it = 0; obj_path_it < obj_paths_length1; obj_path_it = obj_path_it + 1) {
			char* obj_path;
			obj_path = g_strdup (obj_path_collection[obj_path_it]);
			{
				char* _tmp2_;
				RygelExternalContainer* _tmp3_;
				RygelExternalContainer* container;
#line 175 "rygel-external-container.vala"
				container = (_tmp3_ = rygel_external_container_new (_tmp2_ = g_strconcat ("container:", (const char*) obj_path, NULL), self->service_name, obj_path, self->host_ip, self), _g_free0 (_tmp2_), _tmp3_);
#line 181 "rygel-external-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->containers, container);
#line 813 "rygel-external-container.c"
				_g_free0 (obj_path);
				_g_object_unref0 (container);
			}
		}
	}
#line 184 "rygel-external-container.vala"
	((RygelMediaContainer*) self)->child_count = gee_collection_get_size ((GeeCollection*) self->priv->containers) + rygel_external_media_container_get_item_count (self->actual_container);
#line 821 "rygel-external-container.c"
	obj_paths = (_vala_array_free (obj_paths, obj_paths_length1, (GDestroyNotify) g_free), NULL);
}


#line 188 "rygel-external-container.vala"
static void rygel_external_container_on_updated (RygelExternalContainer* self, RygelExternalMediaContainer* actual_container) {
#line 828 "rygel-external-container.c"
	GError * _inner_error_;
#line 188 "rygel-external-container.vala"
	g_return_if_fail (self != NULL);
#line 188 "rygel-external-container.vala"
	g_return_if_fail (actual_container != NULL);
#line 834 "rygel-external-container.c"
	_inner_error_ = NULL;
	{
#line 191 "rygel-external-container.vala"
		rygel_external_container_update_container (self, &_inner_error_);
#line 839 "rygel-external-container.c"
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 193 "rygel-external-container.vala"
			g_warning ("rygel-external-container.vala:193: Failed to update information about container '%s': %s\n", ((RygelMediaObject*) self)->id, err->message);
#line 854 "rygel-external-container.c"
			_g_error_free0 (err);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 199 "rygel-external-container.vala"
	rygel_media_container_updated ((RygelMediaContainer*) self);
#line 866 "rygel-external-container.c"
}


static void rygel_external_container_class_init (RygelExternalContainerClass * klass) {
	rygel_external_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelExternalContainerPrivate));
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_external_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_external_container_real_get_children_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search = rygel_external_container_real_search;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search_finish = rygel_external_container_real_search_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_external_container_finalize;
}


static void rygel_external_container_instance_init (RygelExternalContainer * self) {
	self->priv = RYGEL_EXTERNAL_CONTAINER_GET_PRIVATE (self);
}


static void rygel_external_container_finalize (GObject* obj) {
	RygelExternalContainer * self;
	self = RYGEL_EXTERNAL_CONTAINER (obj);
	_g_object_unref0 (self->actual_container);
	_g_free0 (self->host_ip);
	_g_free0 (self->service_name);
	_g_free0 (self->priv->object_path);
	_g_object_unref0 (self->priv->containers);
	G_OBJECT_CLASS (rygel_external_container_parent_class)->finalize (obj);
}


GType rygel_external_container_get_type (void) {
	static GType rygel_external_container_type_id = 0;
	if (rygel_external_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalContainer), 0, (GInstanceInitFunc) rygel_external_container_instance_init, NULL };
		rygel_external_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelExternalContainer", &g_define_type_info, 0);
	}
	return rygel_external_container_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




