/* rygel-visual-item.c generated by valac 0.44.9, the Vala compiler
 * generated from rygel-visual-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_THUMBNAILER (rygel_thumbnailer_get_type ())
#define RYGEL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailer))
#define RYGEL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))
#define RYGEL_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))

typedef struct _RygelThumbnailer RygelThumbnailer;
typedef struct _RygelThumbnailerClass RygelThumbnailerClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

GType rygel_media_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaObject, g_object_unref)
GType rygel_media_item_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaItem, g_object_unref)
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaFileItem, g_object_unref)
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelThumbnail, rygel_icon_info_unref)
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self,
                                              const gchar* uri);
GType rygel_thumbnailer_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelThumbnailer, g_object_unref)
RygelThumbnailer* rygel_thumbnailer_get_default (void);
const gchar* rygel_media_file_item_get_mime_type (RygelMediaFileItem* self);
RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self,
                                                 const gchar* uri,
                                                 const gchar* mime_type,
                                                 GError** error);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaResource, g_object_unref)
void rygel_visual_item_set_visual_resource_properties (RygelVisualItem* self,
                                                       RygelMediaResource* res);
gint rygel_visual_item_get_width (RygelVisualItem* self);
void rygel_media_resource_set_width (RygelMediaResource* self,
                                     gint value);
gint rygel_visual_item_get_height (RygelVisualItem* self);
void rygel_media_resource_set_height (RygelMediaResource* self,
                                      gint value);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
void rygel_media_resource_set_color_depth (RygelMediaResource* self,
                                           gint value);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPServer, g_object_unref)
void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self,
                                                RygelHTTPServer* http_server);
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self,
                                                const gchar* uri,
                                                GError** error);
RygelMediaResource* rygel_thumbnail_get_resource (RygelThumbnail* self,
                                                  const gchar* protocol,
                                                  gint index);
void rygel_media_resource_set_uri (RygelMediaResource* self,
                                   const gchar* value);
GeeList* rygel_media_object_get_resource_list (RygelMediaObject* self);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self,
                                       const gchar* uri);
gchar* rygel_http_server_get_protocol (RygelHTTPServer* self);
gchar* rygel_http_server_create_uri_for_object (RygelHTTPServer* self,
                                                RygelMediaObject* object,
                                                gint thumbnail_index,
                                                gint subtitle_index,
                                                const gchar* resource_name);
void rygel_visual_item_set_width (RygelVisualItem* self,
                                  gint value);
void rygel_visual_item_set_height (RygelVisualItem* self,
                                   gint value);
void rygel_visual_item_set_color_depth (RygelVisualItem* self,
                                        gint value);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self,
                                       GeeArrayList* value);

void
rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self,
                                         const gchar* uri)
{
	RygelThumbnailer* thumbnailer = NULL;
	RygelThumbnailer* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelThumbnailer* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (uri != NULL);
	_tmp0_ = rygel_thumbnailer_get_default ();
	thumbnailer = _tmp0_;
	_tmp2_ = thumbnailer;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = rygel_media_file_item_get_mime_type ((RygelMediaFileItem*) self);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			RygelThumbnail* thumb = NULL;
			RygelThumbnailer* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			RygelThumbnail* _tmp8_;
			GeeArrayList* _tmp9_;
			GeeArrayList* _tmp10_;
			RygelThumbnail* _tmp11_;
			_tmp5_ = thumbnailer;
			_tmp6_ = rygel_media_file_item_get_mime_type ((RygelMediaFileItem*) self);
			_tmp7_ = _tmp6_;
			_tmp8_ = rygel_thumbnailer_get_thumbnail (_tmp5_, uri, _tmp7_, &_inner_error0_);
			thumb = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch22_g_error;
			}
			_tmp9_ = rygel_visual_item_get_thumbnails (self);
			_tmp10_ = _tmp9_;
			_tmp11_ = thumb;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			_rygel_icon_info_unref0 (thumb);
		}
		goto __finally22;
		__catch22_g_error:
		{
			GError* err = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp12_ = err;
			_tmp13_ = _tmp12_->message;
			g_debug ("rygel-visual-item.vala:69: Failed to get thumbnail: %s", _tmp13_);
			_g_error_free0 (err);
		}
		__finally22:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (thumbnailer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (thumbnailer);
}

void
rygel_visual_item_set_visual_resource_properties (RygelVisualItem* self,
                                                  RygelMediaResource* res)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (res != NULL);
	_tmp0_ = rygel_visual_item_get_width (self);
	_tmp1_ = _tmp0_;
	rygel_media_resource_set_width (res, _tmp1_);
	_tmp2_ = rygel_visual_item_get_height (self);
	_tmp3_ = _tmp2_;
	rygel_media_resource_set_height (res, _tmp3_);
	_tmp4_ = rygel_visual_item_get_color_depth (self);
	_tmp5_ = _tmp4_;
	rygel_media_resource_set_color_depth (res, _tmp5_);
}

void
rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self,
                                           RygelHTTPServer* http_server)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (http_server != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp2_;
				GeeArrayList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = rygel_visual_item_get_thumbnails (self);
				_tmp3_ = _tmp2_;
				_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = rygel_media_file_item_get_place_holder ((RygelMediaFileItem*) self);
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					RygelThumbnail* thumbnail = NULL;
					GeeArrayList* _tmp8_;
					GeeArrayList* _tmp9_;
					gpointer _tmp10_;
					gchar* protocol = NULL;
					RygelMediaResource* thumb_res = NULL;
					RygelThumbnail* _tmp18_;
					const gchar* _tmp19_;
					RygelMediaResource* _tmp20_;
					RygelMediaResource* _tmp21_;
					RygelThumbnail* _tmp22_;
					const gchar* _tmp23_;
					GeeList* _tmp24_;
					GeeList* _tmp25_;
					RygelMediaResource* _tmp26_;
					RygelThumbnail* _tmp27_;
					const gchar* _tmp28_;
					_tmp8_ = rygel_visual_item_get_thumbnails (self);
					_tmp9_ = _tmp8_;
					_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, i);
					thumbnail = (RygelThumbnail*) _tmp10_;
					{
						gchar* _tmp11_ = NULL;
						RygelThumbnail* _tmp12_;
						const gchar* _tmp13_;
						gchar* _tmp14_;
						gchar* _tmp15_;
						_tmp12_ = thumbnail;
						_tmp13_ = ((RygelIconInfo*) _tmp12_)->uri;
						_tmp14_ = rygel_media_object_get_protocol_for_uri ((RygelMediaObject*) self, _tmp13_, &_inner_error0_);
						_tmp11_ = _tmp14_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch23_g_error;
						}
						_tmp15_ = _tmp11_;
						_tmp11_ = NULL;
						_g_free0 (protocol);
						protocol = _tmp15_;
						_g_free0 (_tmp11_);
					}
					goto __finally23;
					__catch23_g_error:
					{
						GError* e = NULL;
						RygelThumbnail* _tmp16_;
						const gchar* _tmp17_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp16_ = thumbnail;
						_tmp17_ = ((RygelIconInfo*) _tmp16_)->uri;
						g_message ("rygel-visual-item.vala:90: Could not determine protocol for URI %s", _tmp17_);
						_g_error_free0 (e);
						_g_free0 (protocol);
						_rygel_icon_info_unref0 (thumbnail);
						continue;
					}
					__finally23:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (protocol);
						_rygel_icon_info_unref0 (thumbnail);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp18_ = thumbnail;
					_tmp19_ = protocol;
					_tmp20_ = rygel_thumbnail_get_resource (_tmp18_, _tmp19_, i);
					thumb_res = _tmp20_;
					_tmp21_ = thumb_res;
					_tmp22_ = thumbnail;
					_tmp23_ = ((RygelIconInfo*) _tmp22_)->uri;
					rygel_media_resource_set_uri (_tmp21_, _tmp23_);
					_tmp24_ = rygel_media_object_get_resource_list ((RygelMediaObject*) self);
					_tmp25_ = _tmp24_;
					_tmp26_ = thumb_res;
					gee_collection_add ((GeeCollection*) _tmp25_, _tmp26_);
					_g_object_unref0 (_tmp25_);
					_tmp27_ = thumbnail;
					_tmp28_ = ((RygelIconInfo*) _tmp27_)->uri;
					if (rygel_http_server_need_proxy (http_server, _tmp28_)) {
						RygelMediaResource* http_thumb_res = NULL;
						RygelThumbnail* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						RygelMediaResource* _tmp32_;
						RygelMediaResource* _tmp33_;
						gint index = 0;
						GeeArrayList* _tmp34_;
						GeeArrayList* _tmp35_;
						RygelThumbnail* _tmp36_;
						RygelMediaResource* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						GeeList* _tmp40_;
						GeeList* _tmp41_;
						RygelMediaResource* _tmp42_;
						_tmp29_ = thumbnail;
						_tmp30_ = rygel_http_server_get_protocol (http_server);
						_tmp31_ = _tmp30_;
						_tmp32_ = rygel_thumbnail_get_resource (_tmp29_, _tmp31_, i);
						_tmp33_ = _tmp32_;
						_g_free0 (_tmp31_);
						http_thumb_res = _tmp33_;
						_tmp34_ = rygel_visual_item_get_thumbnails (self);
						_tmp35_ = _tmp34_;
						_tmp36_ = thumbnail;
						index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp35_, _tmp36_);
						_tmp37_ = http_thumb_res;
						_tmp38_ = rygel_http_server_create_uri_for_object (http_server, (RygelMediaObject*) self, index, -1, NULL);
						_tmp39_ = _tmp38_;
						rygel_media_resource_set_uri (_tmp37_, _tmp39_);
						_g_free0 (_tmp39_);
						_tmp40_ = rygel_media_object_get_resource_list ((RygelMediaObject*) self);
						_tmp41_ = _tmp40_;
						_tmp42_ = http_thumb_res;
						gee_collection_add ((GeeCollection*) _tmp41_, _tmp42_);
						_g_object_unref0 (_tmp41_);
						_g_object_unref0 (http_thumb_res);
					}
					_g_object_unref0 (thumb_res);
					_g_free0 (protocol);
					_rygel_icon_info_unref0 (thumbnail);
				}
			}
		}
	}
}

gint
rygel_visual_item_get_width (RygelVisualItem* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_width (self);
}

void
rygel_visual_item_set_width (RygelVisualItem* self,
                             gint value)
{
	g_return_if_fail (self != NULL);
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_width (self, value);
}

gint
rygel_visual_item_get_height (RygelVisualItem* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_height (self);
}

void
rygel_visual_item_set_height (RygelVisualItem* self,
                              gint value)
{
	g_return_if_fail (self != NULL);
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_height (self, value);
}

gint
rygel_visual_item_get_color_depth (RygelVisualItem* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_color_depth (self);
}

void
rygel_visual_item_set_color_depth (RygelVisualItem* self,
                                   gint value)
{
	g_return_if_fail (self != NULL);
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_color_depth (self, value);
}

GeeArrayList*
rygel_visual_item_get_thumbnails (RygelVisualItem* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_thumbnails (self);
}

void
rygel_visual_item_set_thumbnails (RygelVisualItem* self,
                                  GeeArrayList* value)
{
	g_return_if_fail (self != NULL);
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_thumbnails (self, value);
}

static void
rygel_visual_item_default_init (RygelVisualItemIface * iface,
                                gpointer iface_data)
{
	/**
	     * The width of the source content (this.uri) in pixels.
	     * A value of -1 means that the width is unknown
	     */
	g_object_interface_install_property (iface, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The height of the source content (this.uri) in pixels.
	     * A value of -1 means that the height is unknown
	     */
	g_object_interface_install_property (iface, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The number of bits per pixel in the video or image resource (this.uri).
	     * A value of -1 means that the color depth is unknown
	     */
	g_object_interface_install_property (iface, g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Thumbnail pictures to represent the video or image resource.
	     */
	g_object_interface_install_property (iface, g_param_spec_object ("thumbnails", "thumbnails", "thumbnails", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

/**
 * An interface representing visual properties of an item stored in a file.
 */
GType
rygel_visual_item_get_type (void)
{
	static volatile gsize rygel_visual_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_visual_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVisualItemIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_visual_item_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_visual_item_type_id;
		rygel_visual_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelVisualItem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_visual_item_type_id, RYGEL_TYPE_MEDIA_FILE_ITEM);
		g_once_init_leave (&rygel_visual_item_type_id__volatile, rygel_visual_item_type_id);
	}
	return rygel_visual_item_type_id__volatile;
}

