/* test.c generated by valac 0.44.3, the Vala compiler
 * generated from test.vala, do not modify */

/*
 * Copyright (C) 2012 Jens Georg.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>

#define TYPE_SEARCH_EXPRESSION (search_expression_get_type ())
#define SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_EXPRESSION, SearchExpression))
#define SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))
#define IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_EXPRESSION))
#define IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_EXPRESSION))
#define SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))

typedef struct _SearchExpression SearchExpression;
typedef struct _SearchExpressionClass SearchExpressionClass;
typedef struct _SearchExpressionPrivate SearchExpressionPrivate;

#define TYPE_RELATIONAL_EXPRESSION (relational_expression_get_type ())
#define RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpression))
#define RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))
#define IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RELATIONAL_EXPRESSION))
#define IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RELATIONAL_EXPRESSION))
#define RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))

typedef struct _RelationalExpression RelationalExpression;
typedef struct _RelationalExpressionClass RelationalExpressionClass;
typedef struct _RelationalExpressionPrivate RelationalExpressionPrivate;
enum  {
	RELATIONAL_EXPRESSION_0_PROPERTY,
	RELATIONAL_EXPRESSION_NUM_PROPERTIES
};
static GParamSpec* relational_expression_properties[RELATIONAL_EXPRESSION_NUM_PROPERTIES];
enum  {
	SEARCH_EXPRESSION_0_PROPERTY,
	SEARCH_EXPRESSION_NUM_PROPERTIES
};
static GParamSpec* search_expression_properties[SEARCH_EXPRESSION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MEDIA_OBJECT (media_object_get_type ())
#define MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT, MediaObject))
#define MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECT, MediaObjectClass))
#define IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT))
#define IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECT))
#define MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECT, MediaObjectClass))

typedef struct _MediaObject MediaObject;
typedef struct _MediaObjectClass MediaObjectClass;
typedef struct _MediaObjectPrivate MediaObjectPrivate;
enum  {
	MEDIA_OBJECT_0_PROPERTY,
	MEDIA_OBJECT_NUM_PROPERTIES
};
static GParamSpec* media_object_properties[MEDIA_OBJECT_NUM_PROPERTIES];

#define TYPE_MEDIA_CONTAINER (media_container_get_type ())
#define MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER, MediaContainer))
#define MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_CONTAINER, MediaContainerClass))
#define IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER))
#define IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_CONTAINER))
#define MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_CONTAINER, MediaContainerClass))

typedef struct _MediaContainer MediaContainer;
typedef struct _MediaContainerClass MediaContainerClass;
typedef struct _MediaContainerPrivate MediaContainerPrivate;
enum  {
	MEDIA_CONTAINER_0_PROPERTY,
	MEDIA_CONTAINER_ALL_CHILD_COUNT_PROPERTY,
	MEDIA_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* media_container_properties[MEDIA_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MEDIA_OBJECTS (media_objects_get_type ())
#define MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECTS, MediaObjects))
#define MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECTS, MediaObjectsClass))
#define IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECTS))
#define IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECTS))
#define MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECTS, MediaObjectsClass))

typedef struct _MediaObjects MediaObjects;
typedef struct _MediaObjectsClass MediaObjectsClass;
typedef struct _Block1Data Block1Data;
typedef struct _MediaContainerGetChildrenData MediaContainerGetChildrenData;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define TYPE_TEST_CONTAINER (test_container_get_type ())
#define TEST_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_CONTAINER, TestContainer))
#define TEST_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_CONTAINER, TestContainerClass))
#define IS_TEST_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_CONTAINER))
#define IS_TEST_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_CONTAINER))
#define TEST_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_CONTAINER, TestContainerClass))

typedef struct _TestContainer TestContainer;
typedef struct _TestContainerClass TestContainerClass;
typedef struct _TestContainerPrivate TestContainerPrivate;
enum  {
	TEST_CONTAINER_0_PROPERTY,
	TEST_CONTAINER_SEARCH_CLASSES_PROPERTY,
	TEST_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* test_container_properties[TEST_CONTAINER_NUM_PROPERTIES];
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TestContainerTestSearchNoLimitData TestContainerTestSearchNoLimitData;
typedef struct _TestContainerTestSearchWithLimitData TestContainerTestSearchWithLimitData;
typedef struct _TestContainerSearchData TestContainerSearchData;
typedef struct _MediaObjectsPrivate MediaObjectsPrivate;
enum  {
	MEDIA_OBJECTS_0_PROPERTY,
	MEDIA_OBJECTS_NUM_PROPERTIES
};
static GParamSpec* media_objects_properties[MEDIA_OBJECTS_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SearchExpression {
	GObject parent_instance;
	SearchExpressionPrivate * priv;
	gchar* operand1;
	gchar* operand2;
	gchar* op;
};

struct _SearchExpressionClass {
	GObjectClass parent_class;
};

struct _RelationalExpression {
	SearchExpression parent_instance;
	RelationalExpressionPrivate * priv;
};

struct _RelationalExpressionClass {
	SearchExpressionClass parent_class;
};

struct _MediaObject {
	GObject parent_instance;
	MediaObjectPrivate * priv;
};

struct _MediaObjectClass {
	GObjectClass parent_class;
};

struct _MediaContainer {
	MediaObject parent_instance;
	MediaContainerPrivate * priv;
	gchar* sort_criteria;
	gint child_count;
	gboolean create_mode_enabled;
};

struct _MediaContainerClass {
	MediaObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	MediaContainer* self;
	gpointer _async_data_;
};

struct _MediaContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MediaContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	MediaObjects* result;
	Block1Data* _data1_;
	MediaObjects* _result_;
	MediaObjects* _tmp0_;
	gint i;
	gboolean _tmp1_;
	MediaObjects* _tmp2_;
	MediaObject* _tmp3_;
	MediaObject* _tmp4_;
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	MediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _TestContainer {
	MediaContainer parent_instance;
	TestContainerPrivate * priv;
	GMainLoop* loop;
};

struct _TestContainerClass {
	MediaContainerClass parent_class;
};

struct _TestContainerPrivate {
	GeeArrayList* _search_classes;
};

struct _TestContainerTestSearchNoLimitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TestContainer* self;
	guint total_matches;
	MediaObjects* _result_;
	guint _tmp0_;
	MediaObjects* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GError* _error_;
	MediaObjects* _vala1__result_;
	guint _tmp4_;
	MediaObjects* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GError* _vala1__error_;
	gint i;
	gboolean _tmp8_;
	MediaObjects* _vala2__result_;
	guint _tmp9_;
	MediaObjects* _tmp10_;
	MediaObjects* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GError* _vala2__error_;
	GMainLoop* _tmp14_;
	GError* _inner_error0_;
};

struct _TestContainerTestSearchWithLimitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TestContainer* self;
	guint total_matches;
	MediaObjects* _result_;
	guint _tmp0_;
	MediaObjects* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GError* _error_;
	MediaObjects* _vala1__result_;
	guint _tmp4_;
	MediaObjects* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GError* _vala1__error_;
	gint i;
	gboolean _tmp8_;
	MediaObjects* _vala2__result_;
	guint _tmp9_;
	MediaObjects* _tmp10_;
	MediaObjects* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GError* _vala2__error_;
	GMainLoop* _tmp14_;
	GError* _inner_error0_;
};

struct _TestContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TestContainer* self;
	SearchExpression* expression;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	guint total_matches;
	MediaObjects* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	MediaObjects* _tmp2_;
	guint _tmp3_;
	MediaObjects* _tmp4_;
	MediaObjects* _tmp5_;
	GError* _inner_error0_;
};

struct _MediaObjects {
	GeeArrayList parent_instance;
	MediaObjectsPrivate * priv;
};

struct _MediaObjectsClass {
	GeeArrayListClass parent_class;
};

static gpointer relational_expression_parent_class = NULL;
static gpointer search_expression_parent_class = NULL;
static gpointer media_object_parent_class = NULL;
static gpointer media_container_parent_class = NULL;
static gint TestContainer_private_offset;
static gpointer test_container_parent_class = NULL;
static RygelSearchableContainerIface * test_container_rygel_searchable_container_parent_iface = NULL;
static gpointer media_objects_parent_class = NULL;

GType search_expression_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchExpression, g_object_unref)
GType relational_expression_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RelationalExpression, g_object_unref)
RelationalExpression* relational_expression_new (void);
RelationalExpression* relational_expression_construct (GType object_type);
SearchExpression* search_expression_new (void);
SearchExpression* search_expression_construct (GType object_type);
#define SEARCH_CRITERIA_OP_EQ "="
GType media_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaObject, g_object_unref)
gboolean search_expression_satisfied_by (SearchExpression* self,
                                         MediaObject* object);
static void search_expression_finalize (GObject * obj);
MediaObject* media_object_new (void);
MediaObject* media_object_construct (GType object_type);
GType media_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaContainer, g_object_unref)
static void media_container_get_children_data_free (gpointer _data);
GType media_objects_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaObjects, g_object_unref)
void media_container_get_children (MediaContainer* self,
                                   guint offset,
                                   guint max_count,
                                   const gchar* sort_criteria,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
MediaObjects* media_container_get_children_finish (MediaContainer* self,
                                                   GAsyncResult* _res_,
                                                   GError** error);
static gboolean media_container_get_children_co (MediaContainerGetChildrenData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block1Data* _data1_);
static gboolean ___lambda4__gsource_func (gpointer self);
MediaObjects* media_objects_new (void);
MediaObjects* media_objects_construct (GType object_type);
void media_container_check_search_expression (MediaContainer* self,
                                              SearchExpression* expression);
MediaContainer* media_container_new (void);
MediaContainer* media_container_construct (GType object_type);
gint media_container_get_all_child_count (MediaContainer* self);
static void media_container_finalize (GObject * obj);
static void _vala_media_container_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType test_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TestContainer, g_object_unref)
static void test_container_test_search_no_limit_data_free (gpointer _data);
void test_container_test_search_no_limit (TestContainer* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
void test_container_test_search_no_limit_finish (TestContainer* self,
                                                 GAsyncResult* _res_);
static gboolean test_container_test_search_no_limit_co (TestContainerTestSearchNoLimitData* _data_);
void rygel_searchable_container_search (RygelSearchableContainer* self,
                                        SearchExpression* expression,
                                        guint offset,
                                        guint max_count,
                                        const gchar* sort_criteria,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
MediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self,
                                                        GAsyncResult* _res_,
                                                        guint* total_matches,
                                                        GError** error);
static void test_container_test_search_no_limit_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void test_container_test_search_with_limit_data_free (gpointer _data);
void test_container_test_search_with_limit (TestContainer* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
void test_container_test_search_with_limit_finish (TestContainer* self,
                                                   GAsyncResult* _res_);
static gboolean test_container_test_search_with_limit_co (TestContainerTestSearchWithLimitData* _data_);
static void test_container_test_search_with_limit_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
void test_container_test_serialization (TestContainer* self);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self,
                                                             GUPnPDIDLLiteContainer* didl_container);
static void test_container_real_search_data_free (gpointer _data);
static void test_container_real_search (RygelSearchableContainer* base,
                                 SearchExpression* expression,
                                 guint offset,
                                 guint max_count,
                                 const gchar* sort_criteria,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static gboolean test_container_real_search_co (TestContainerSearchData* _data_);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self,
                                               SearchExpression* expression,
                                               guint offset,
                                               guint max_count,
                                               const gchar* sort_criteria,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
MediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self,
                                                               GAsyncResult* _res_,
                                                               guint* total_matches,
                                                               GError** error);
static void test_container_search_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_);
TestContainer* test_container_new (void);
TestContainer* test_container_construct (GType object_type);
static void test_container_finalize (GObject * obj);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
static void _vala_test_container_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self,
                                                    GeeArrayList* value);
static void _vala_test_container_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static GeeList* media_objects_real_slice (GeeAbstractList* base,
                                   gint start,
                                   gint stop);
gint _vala_main (void);

RelationalExpression*
relational_expression_construct (GType object_type)
{
	RelationalExpression * self = NULL;
	self = (RelationalExpression*) search_expression_construct (object_type);
	return self;
}

RelationalExpression*
relational_expression_new (void)
{
	return relational_expression_construct (TYPE_RELATIONAL_EXPRESSION);
}

static void
relational_expression_class_init (RelationalExpressionClass * klass,
                                  gpointer klass_data)
{
	relational_expression_parent_class = g_type_class_peek_parent (klass);
}

static void
relational_expression_instance_init (RelationalExpression * self,
                                     gpointer klass)
{
}

GType
relational_expression_get_type (void)
{
	static volatile gsize relational_expression_type_id__volatile = 0;
	if (g_once_init_enter (&relational_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RelationalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) relational_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RelationalExpression), 0, (GInstanceInitFunc) relational_expression_instance_init, NULL };
		GType relational_expression_type_id;
		relational_expression_type_id = g_type_register_static (TYPE_SEARCH_EXPRESSION, "RelationalExpression", &g_define_type_info, 0);
		g_once_init_leave (&relational_expression_type_id__volatile, relational_expression_type_id);
	}
	return relational_expression_type_id__volatile;
}

gboolean
search_expression_satisfied_by (SearchExpression* self,
                                MediaObject* object)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	result = TRUE;
	return result;
}

SearchExpression*
search_expression_construct (GType object_type)
{
	SearchExpression * self = NULL;
	self = (SearchExpression*) g_object_new (object_type, NULL);
	return self;
}

SearchExpression*
search_expression_new (void)
{
	return search_expression_construct (TYPE_SEARCH_EXPRESSION);
}

static void
search_expression_class_init (SearchExpressionClass * klass,
                              gpointer klass_data)
{
	search_expression_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = search_expression_finalize;
}

static void
search_expression_instance_init (SearchExpression * self,
                                 gpointer klass)
{
}

static void
search_expression_finalize (GObject * obj)
{
	SearchExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_EXPRESSION, SearchExpression);
	_g_free0 (self->operand1);
	_g_free0 (self->operand2);
	_g_free0 (self->op);
	G_OBJECT_CLASS (search_expression_parent_class)->finalize (obj);
}

GType
search_expression_get_type (void)
{
	static volatile gsize search_expression_type_id__volatile = 0;
	if (g_once_init_enter (&search_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchExpression), 0, (GInstanceInitFunc) search_expression_instance_init, NULL };
		GType search_expression_type_id;
		search_expression_type_id = g_type_register_static (G_TYPE_OBJECT, "SearchExpression", &g_define_type_info, 0);
		g_once_init_leave (&search_expression_type_id__volatile, search_expression_type_id);
	}
	return search_expression_type_id__volatile;
}

MediaObject*
media_object_construct (GType object_type)
{
	MediaObject * self = NULL;
	self = (MediaObject*) g_object_new (object_type, NULL);
	return self;
}

MediaObject*
media_object_new (void)
{
	return media_object_construct (TYPE_MEDIA_OBJECT);
}

static void
media_object_class_init (MediaObjectClass * klass,
                         gpointer klass_data)
{
	media_object_parent_class = g_type_class_peek_parent (klass);
}

static void
media_object_instance_init (MediaObject * self,
                            gpointer klass)
{
}

GType
media_object_get_type (void)
{
	static volatile gsize media_object_type_id__volatile = 0;
	if (g_once_init_enter (&media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaObject), 0, (GInstanceInitFunc) media_object_instance_init, NULL };
		GType media_object_type_id;
		media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "MediaObject", &g_define_type_info, 0);
		g_once_init_leave (&media_object_type_id__volatile, media_object_type_id);
	}
	return media_object_type_id__volatile;
}

static void
media_container_get_children_data_free (gpointer _data)
{
	MediaContainerGetChildrenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (MediaContainerGetChildrenData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
media_container_get_children (MediaContainer* self,
                              guint offset,
                              guint max_count,
                              const gchar* sort_criteria,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	MediaContainerGetChildrenData* _data_;
	MediaContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (MediaContainerGetChildrenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, media_container_get_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp1_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	media_container_get_children_co (_data_);
}

MediaObjects*
media_container_get_children_finish (MediaContainer* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	MediaObjects* result;
	MediaContainerGetChildrenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		MediaContainer* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda4_ (Block1Data* _data1_)
{
	MediaContainer* self;
	gboolean result = FALSE;
	self = _data1_->self;
	media_container_get_children_co (_data1_->_async_data_);
	result = FALSE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ (self);
	return result;
}

static gboolean
media_container_get_children_co (MediaContainerGetChildrenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp0_ = media_objects_new ();
	_data_->_result_ = _data_->_tmp0_;
	{
		_data_->i = 0;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp1_) {
					_data_->i = _data_->i + 1;
				}
				_data_->_tmp1_ = FALSE;
				if (!(_data_->i < 10)) {
					break;
				}
				_data_->_tmp2_ = _data_->_result_;
				_data_->_tmp3_ = media_object_new ();
				_data_->_tmp4_ = _data_->_tmp3_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp2_, _data_->_tmp4_);
				_g_object_unref0 (_data_->_tmp4_);
			}
		}
	}
	_data_->result = _data_->_result_;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
media_container_check_search_expression (MediaContainer* self,
                                         SearchExpression* expression)
{
	g_return_if_fail (self != NULL);
}

MediaContainer*
media_container_construct (GType object_type)
{
	MediaContainer * self = NULL;
	self = (MediaContainer*) media_object_construct (object_type);
	return self;
}

MediaContainer*
media_container_new (void)
{
	return media_container_construct (TYPE_MEDIA_CONTAINER);
}

gint
media_container_get_all_child_count (MediaContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->child_count;
	return result;
}

static void
media_container_class_init (MediaContainerClass * klass,
                            gpointer klass_data)
{
	media_container_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_media_container_get_property;
	G_OBJECT_CLASS (klass)->finalize = media_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MEDIA_CONTAINER_ALL_CHILD_COUNT_PROPERTY, media_container_properties[MEDIA_CONTAINER_ALL_CHILD_COUNT_PROPERTY] = g_param_spec_int ("all-child-count", "all-child-count", "all-child-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
media_container_instance_init (MediaContainer * self,
                               gpointer klass)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("+dc:title");
	self->sort_criteria = _tmp0_;
	self->child_count = 10;
	self->create_mode_enabled = FALSE;
}

static void
media_container_finalize (GObject * obj)
{
	MediaContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_CONTAINER, MediaContainer);
	_g_free0 (self->sort_criteria);
	G_OBJECT_CLASS (media_container_parent_class)->finalize (obj);
}

GType
media_container_get_type (void)
{
	static volatile gsize media_container_type_id__volatile = 0;
	if (g_once_init_enter (&media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaContainer), 0, (GInstanceInitFunc) media_container_instance_init, NULL };
		GType media_container_type_id;
		media_container_type_id = g_type_register_static (TYPE_MEDIA_OBJECT, "MediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&media_container_type_id__volatile, media_container_type_id);
	}
	return media_container_type_id__volatile;
}

static void
_vala_media_container_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	MediaContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MEDIA_CONTAINER, MediaContainer);
	switch (property_id) {
		case MEDIA_CONTAINER_ALL_CHILD_COUNT_PROPERTY:
		g_value_set_int (value, media_container_get_all_child_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
test_container_get_instance_private (TestContainer* self)
{
	return G_STRUCT_MEMBER_P (self, TestContainer_private_offset);
}

static void
test_container_test_search_no_limit_data_free (gpointer _data)
{
	TestContainerTestSearchNoLimitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TestContainerTestSearchNoLimitData, _data_);
}

void
test_container_test_search_no_limit (TestContainer* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	TestContainerTestSearchNoLimitData* _data_;
	TestContainer* _tmp0_;
	_data_ = g_slice_new0 (TestContainerTestSearchNoLimitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, test_container_test_search_no_limit_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	test_container_test_search_no_limit_co (_data_);
}

void
test_container_test_search_no_limit_finish (TestContainer* self,
                                            GAsyncResult* _res_)
{
	TestContainerTestSearchNoLimitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
test_container_test_search_no_limit_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	TestContainerTestSearchNoLimitData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	test_container_test_search_no_limit_co (_data_);
}

static gboolean
test_container_test_search_no_limit_co (TestContainerTestSearchNoLimitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->total_matches = (guint) 0;
	{
		_data_->_tmp0_ = 0U;
		_data_->_state_ = 1;
		rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) 0, (guint) 0, "", NULL, test_container_test_search_no_limit_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp0_, &_data_->_inner_error0_);
		_data_->total_matches = _data_->_tmp0_;
		_data_->_result_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_vala_assert (_data_->total_matches == ((guint) 10), "total_matches == 10");
		_data_->_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_result_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_vala_assert (_data_->_tmp3_ == 10, "result.size == 10");
		_g_object_unref0 (_data_->_result_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp4_ = 0U;
		_data_->_state_ = 2;
		rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) 10, (guint) 0, "", NULL, test_container_test_search_no_limit_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp5_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp4_, &_data_->_inner_error0_);
		_data_->total_matches = _data_->_tmp4_;
		_data_->_vala1__result_ = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_vala_assert (_data_->total_matches == ((guint) 10), "total_matches == 10");
		_data_->_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_vala1__result_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_vala_assert (_data_->_tmp7_ == 0, "result.size == 0");
		_g_object_unref0 (_data_->_vala1__result_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1__error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_data_->_vala1__error_);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->i = 1;
		{
			_data_->_tmp8_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp8_) {
					_data_->i = _data_->i + 1;
				}
				_data_->_tmp8_ = FALSE;
				if (!(_data_->i < 10)) {
					break;
				}
				{
					_data_->_tmp9_ = 0U;
					_data_->_state_ = 3;
					rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) _data_->i, (guint) 0, "", NULL, test_container_test_search_no_limit_ready, _data_);
					return FALSE;
					_state_3:
					_data_->_tmp10_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp9_, &_data_->_inner_error0_);
					_data_->total_matches = _data_->_tmp9_;
					_data_->_vala2__result_ = _data_->_tmp10_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch2_g_error;
					}
					_vala_assert (_data_->total_matches == ((guint) 10), "total_matches == 10");
					_data_->_tmp11_ = _data_->_vala2__result_;
					_data_->_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp11_);
					_data_->_tmp13_ = _data_->_tmp12_;
					_vala_assert (_data_->_tmp13_ == (10 - _data_->i), "result.size == 10 - i");
					_g_object_unref0 (_data_->_vala2__result_);
				}
				goto __finally2;
				__catch2_g_error:
				{
					_data_->_vala2__error_ = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					g_assert_not_reached ();
					_g_error_free0 (_data_->_vala2__error_);
				}
				__finally2:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
		}
	}
	_data_->_tmp14_ = _data_->self->loop;
	g_main_loop_quit (_data_->_tmp14_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
test_container_test_search_with_limit_data_free (gpointer _data)
{
	TestContainerTestSearchWithLimitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TestContainerTestSearchWithLimitData, _data_);
}

void
test_container_test_search_with_limit (TestContainer* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	TestContainerTestSearchWithLimitData* _data_;
	TestContainer* _tmp0_;
	_data_ = g_slice_new0 (TestContainerTestSearchWithLimitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, test_container_test_search_with_limit_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	test_container_test_search_with_limit_co (_data_);
}

void
test_container_test_search_with_limit_finish (TestContainer* self,
                                              GAsyncResult* _res_)
{
	TestContainerTestSearchWithLimitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
test_container_test_search_with_limit_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	TestContainerTestSearchWithLimitData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	test_container_test_search_with_limit_co (_data_);
}

static gboolean
test_container_test_search_with_limit_co (TestContainerTestSearchWithLimitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = 0U;
		_data_->_state_ = 1;
		rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) 0, (guint) 4, "", NULL, test_container_test_search_with_limit_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp0_, &_data_->_inner_error0_);
		_data_->total_matches = _data_->_tmp0_;
		_data_->_result_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch3_g_error;
		}
		_vala_assert (_data_->total_matches == ((guint) 0), "total_matches == 0");
		_data_->_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_result_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_vala_assert (_data_->_tmp3_ == 4, "result.size == 4");
		_g_object_unref0 (_data_->_result_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_data_->_error_);
	}
	__finally3:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp4_ = 0U;
		_data_->_state_ = 2;
		rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) 10, (guint) 4, "", NULL, test_container_test_search_with_limit_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp5_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp4_, &_data_->_inner_error0_);
		_data_->total_matches = _data_->_tmp4_;
		_data_->_vala1__result_ = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch4_g_error;
		}
		_vala_assert (_data_->total_matches == ((guint) 0), "total_matches == 0");
		_data_->_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_vala1__result_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_vala_assert (_data_->_tmp7_ == 0, "result.size == 0");
		_g_object_unref0 (_data_->_vala1__result_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		_data_->_vala1__error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_data_->_vala1__error_);
	}
	__finally4:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->i = 1;
		{
			_data_->_tmp8_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp8_) {
					_data_->i = _data_->i + 1;
				}
				_data_->_tmp8_ = FALSE;
				if (!(_data_->i < 10)) {
					break;
				}
				{
					_data_->_tmp9_ = 0U;
					_data_->_state_ = 3;
					rygel_searchable_container_search ((RygelSearchableContainer*) _data_->self, NULL, (guint) _data_->i, (guint) 3, "", NULL, test_container_test_search_with_limit_ready, _data_);
					return FALSE;
					_state_3:
					_data_->_tmp10_ = rygel_searchable_container_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp9_, &_data_->_inner_error0_);
					_data_->total_matches = _data_->_tmp9_;
					_data_->_vala2__result_ = _data_->_tmp10_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch5_g_error;
					}
					_vala_assert (_data_->total_matches == ((guint) 0), "total_matches == 0");
					_data_->_tmp11_ = _data_->_vala2__result_;
					_data_->_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp11_);
					_data_->_tmp13_ = _data_->_tmp12_;
					_vala_assert (_data_->_tmp13_ == MIN (10 - _data_->i, 3), "result.size == int.min (10 - i, 3)");
					_g_object_unref0 (_data_->_vala2__result_);
				}
				goto __finally5;
				__catch5_g_error:
				{
					_data_->_vala2__error_ = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					g_assert_not_reached ();
					_g_error_free0 (_data_->_vala2__error_);
				}
				__finally5:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
		}
	}
	_data_->_tmp14_ = _data_->self->loop;
	g_main_loop_quit (_data_->_tmp14_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
test_container_test_serialization (TestContainer* self)
{
	GUPnPDIDLLiteWriter* writer = NULL;
	GUPnPDIDLLiteWriter* _tmp0_;
	GUPnPDIDLLiteContainer* didl_container = NULL;
	GUPnPDIDLLiteContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gupnp_didl_lite_writer_new (NULL);
	writer = _tmp0_;
	_tmp1_ = gupnp_didl_lite_writer_add_container (writer);
	didl_container = _tmp1_;
	rygel_searchable_container_serialize_search_parameters ((RygelSearchableContainer*) self, didl_container);
	_g_object_unref0 (didl_container);
	_g_object_unref0 (writer);
}

static void
test_container_real_search_data_free (gpointer _data)
{
	TestContainerSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TestContainerSearchData, _data_);
}

static void
test_container_real_search (RygelSearchableContainer* base,
                            SearchExpression* expression,
                            guint offset,
                            guint max_count,
                            const gchar* sort_criteria,
                            GCancellable* cancellable,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	TestContainer * self;
	TestContainerSearchData* _data_;
	TestContainer* _tmp0_;
	SearchExpression* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	self = (TestContainer*) base;
	_data_ = g_slice_new0 (TestContainerSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, test_container_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (expression);
	_g_object_unref0 (_data_->expression);
	_data_->expression = _tmp1_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp2_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	test_container_real_search_co (_data_);
}

static MediaObjects*
test_container_search_finish (RygelSearchableContainer* base,
                              GAsyncResult* _res_,
                              guint* total_matches,
                              GError** error)
{
	MediaObjects* result;
	TestContainerSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
test_container_search_ready (GObject* source_object,
                             GAsyncResult* _res_,
                             gpointer _user_data_)
{
	TestContainerSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	test_container_real_search_co (_data_);
}

static gboolean
test_container_real_search_co (TestContainerSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->sort_criteria;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = ((MediaContainer*) _data_->self)->sort_criteria;
		_data_->_tmp0_ = _data_->_tmp1_;
	}
	_data_->_tmp3_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->expression, _data_->offset, _data_->max_count, _data_->_tmp0_, _data_->cancellable, test_container_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error0_);
	_data_->total_matches = _data_->_tmp3_;
	_data_->_tmp2_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->_tmp2_;
	_data_->_tmp2_ = NULL;
	_data_->result = _data_->_tmp5_;
	_g_object_unref0 (_data_->_tmp2_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

TestContainer*
test_container_construct (GType object_type)
{
	TestContainer * self = NULL;
	self = (TestContainer*) media_container_construct (object_type);
	return self;
}

TestContainer*
test_container_new (void)
{
	return test_container_construct (TYPE_TEST_CONTAINER);
}

static GeeArrayList*
test_container_real_get_search_classes (RygelSearchableContainer* base)
{
	GeeArrayList* result;
	TestContainer* self;
	GeeArrayList* _tmp0_;
	self = (TestContainer*) base;
	_tmp0_ = self->priv->_search_classes;
	result = _tmp0_;
	return result;
}

static void
test_container_real_set_search_classes (RygelSearchableContainer* base,
                                        GeeArrayList* value)
{
	TestContainer* self;
	self = (TestContainer*) base;
	if (test_container_real_get_search_classes (base) != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_search_classes);
		self->priv->_search_classes = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, test_container_properties[TEST_CONTAINER_SEARCH_CLASSES_PROPERTY]);
	}
}

static void
test_container_class_init (TestContainerClass * klass,
                           gpointer klass_data)
{
	test_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TestContainer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_test_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_test_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = test_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEST_CONTAINER_SEARCH_CLASSES_PROPERTY, test_container_properties[TEST_CONTAINER_SEARCH_CLASSES_PROPERTY] = g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
test_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface,
                                                          gpointer iface_data)
{
	test_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*) (RygelSearchableContainer*, SearchExpression*, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) test_container_real_search;
	iface->search_finish = (MediaObjects* (*) (RygelSearchableContainer*, GAsyncResult*, guint*, GError**)) test_container_search_finish;
	iface->get_search_classes = test_container_real_get_search_classes;
	iface->set_search_classes = test_container_real_set_search_classes;
}

static void
test_container_instance_init (TestContainer * self,
                              gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = test_container_get_instance_private (self);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->priv->_search_classes = _tmp0_;
}

static void
test_container_finalize (GObject * obj)
{
	TestContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEST_CONTAINER, TestContainer);
	_g_main_loop_unref0 (self->loop);
	_g_object_unref0 (self->priv->_search_classes);
	G_OBJECT_CLASS (test_container_parent_class)->finalize (obj);
}

GType
test_container_get_type (void)
{
	static volatile gsize test_container_type_id__volatile = 0;
	if (g_once_init_enter (&test_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TestContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestContainer), 0, (GInstanceInitFunc) test_container_instance_init, NULL };
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) test_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType test_container_type_id;
		test_container_type_id = g_type_register_static (TYPE_MEDIA_CONTAINER, "TestContainer", &g_define_type_info, 0);
		g_type_add_interface_static (test_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		TestContainer_private_offset = g_type_add_instance_private (test_container_type_id, sizeof (TestContainerPrivate));
		g_once_init_leave (&test_container_type_id__volatile, test_container_type_id);
	}
	return test_container_type_id__volatile;
}

static void
_vala_test_container_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	TestContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TEST_CONTAINER, TestContainer);
	switch (property_id) {
		case TEST_CONTAINER_SEARCH_CLASSES_PROPERTY:
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_test_container_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	TestContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TEST_CONTAINER, TestContainer);
	switch (property_id) {
		case TEST_CONTAINER_SEARCH_CLASSES_PROPERTY:
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GeeList*
media_objects_real_slice (GeeAbstractList* base,
                          gint start,
                          gint stop)
{
	MediaObjects * self;
	GeeList* result = NULL;
	GeeList* slice = NULL;
	GeeList* _tmp0_;
	MediaObjects* ret = NULL;
	MediaObjects* _tmp1_;
	self = (MediaObjects*) base;
	_tmp0_ = GEE_ABSTRACT_LIST_CLASS (media_objects_parent_class)->slice ((GeeAbstractList*) G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ARRAY_LIST, GeeArrayList), start, stop);
	slice = _tmp0_;
	_tmp1_ = media_objects_new ();
	ret = _tmp1_;
	gee_array_list_add_all ((GeeArrayList*) ret, (GeeCollection*) slice);
	result = (GeeList*) ret;
	_g_object_unref0 (slice);
	return result;
}

MediaObjects*
media_objects_construct (GType object_type)
{
	MediaObjects * self = NULL;
	self = (MediaObjects*) gee_array_list_construct (object_type, TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	return self;
}

MediaObjects*
media_objects_new (void)
{
	return media_objects_construct (TYPE_MEDIA_OBJECTS);
}

static void
media_objects_class_init (MediaObjectsClass * klass,
                          gpointer klass_data)
{
	media_objects_parent_class = g_type_class_peek_parent (klass);
	((GeeAbstractListClass *) klass)->slice = (GeeList* (*) (GeeAbstractList*, gint, gint)) media_objects_real_slice;
}

static void
media_objects_instance_init (MediaObjects * self,
                             gpointer klass)
{
}

GType
media_objects_get_type (void)
{
	static volatile gsize media_objects_type_id__volatile = 0;
	if (g_once_init_enter (&media_objects_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaObjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_objects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaObjects), 0, (GInstanceInitFunc) media_objects_instance_init, NULL };
		GType media_objects_type_id;
		media_objects_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "MediaObjects", &g_define_type_info, 0);
		g_once_init_leave (&media_objects_type_id__volatile, media_objects_type_id);
	}
	return media_objects_type_id__volatile;
}

gint
_vala_main (void)
{
	gint result = 0;
	TestContainer* c = NULL;
	TestContainer* _tmp0_;
	GMainLoop* _tmp1_;
	GMainLoop* _tmp2_;
	GMainLoop* _tmp3_;
	_tmp0_ = test_container_new ();
	c = _tmp0_;
	_tmp1_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (c->loop);
	c->loop = _tmp1_;
	test_container_test_search_no_limit (c, NULL, NULL);
	_tmp2_ = c->loop;
	g_main_loop_run (_tmp2_);
	test_container_test_search_with_limit (c, NULL, NULL);
	_tmp3_ = c->loop;
	g_main_loop_run (_tmp3_);
	result = 0;
	_g_object_unref0 (c);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main ();
}

