/* rygel-mpris-plugin-factory.c generated by valac 0.44.3, the Vala compiler
 * generated from rygel-mpris-plugin-factory.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <rygel-renderer.h>
#include <gobject/gvaluecollector.h>

#define RYGEL_MPRIS_TYPE_PLUGIN_FACTORY (rygel_mpris_plugin_factory_get_type ())
#define RYGEL_MPRIS_PLUGIN_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_PLUGIN_FACTORY, RygelMPRISPluginFactory))
#define RYGEL_MPRIS_PLUGIN_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MPRIS_TYPE_PLUGIN_FACTORY, RygelMPRISPluginFactoryClass))
#define RYGEL_MPRIS_IS_PLUGIN_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_PLUGIN_FACTORY))
#define RYGEL_MPRIS_IS_PLUGIN_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MPRIS_TYPE_PLUGIN_FACTORY))
#define RYGEL_MPRIS_PLUGIN_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MPRIS_TYPE_PLUGIN_FACTORY, RygelMPRISPluginFactoryClass))

typedef struct _RygelMPRISPluginFactory RygelMPRISPluginFactory;
typedef struct _RygelMPRISPluginFactoryClass RygelMPRISPluginFactoryClass;
#define _rygel_mpris_plugin_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_mpris_plugin_factory_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMPRISPluginFactoryPrivate RygelMPRISPluginFactoryPrivate;

#define RYGEL_MPRIS_FREE_DESKTOP_TYPE_DBUS_OBJECT (rygel_mpris_free_desktop_dbus_object_get_type ())
#define RYGEL_MPRIS_FREE_DESKTOP_DBUS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_FREE_DESKTOP_TYPE_DBUS_OBJECT, RygelMPRISFreeDesktopDBusObject))
#define RYGEL_MPRIS_FREE_DESKTOP_IS_DBUS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_FREE_DESKTOP_TYPE_DBUS_OBJECT))
#define RYGEL_MPRIS_FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MPRIS_FREE_DESKTOP_TYPE_DBUS_OBJECT, RygelMPRISFreeDesktopDBusObjectIface))

typedef struct _RygelMPRISFreeDesktopDBusObject RygelMPRISFreeDesktopDBusObject;
typedef struct _RygelMPRISFreeDesktopDBusObjectIface RygelMPRISFreeDesktopDBusObjectIface;

#define RYGEL_MPRIS_FREE_DESKTOP_TYPE_DBUS_OBJECT_PROXY (rygel_mpris_free_desktop_dbus_object_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelMprisPluginFactoryLoadPluginsData RygelMprisPluginFactoryLoadPluginsData;
typedef struct _RygelMprisPluginFactoryLoadActivatablePluginsData RygelMprisPluginFactoryLoadActivatablePluginsData;
typedef struct _RygelMprisPluginFactoryLoadPluginNHandleErrorData RygelMprisPluginFactoryLoadPluginNHandleErrorData;

#define RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY (rygel_mpris_media_player_player_proxy_get_type ())
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, RygelMPRISMediaPlayerPlayerProxy))
#define RYGEL_MPRIS_MEDIA_PLAYER_IS_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY))
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, RygelMPRISMediaPlayerPlayerProxyIface))

typedef struct _RygelMPRISMediaPlayerPlayerProxy RygelMPRISMediaPlayerPlayerProxy;
typedef struct _RygelMPRISMediaPlayerPlayerProxyIface RygelMPRISMediaPlayerPlayerProxyIface;

#define RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY (rygel_mpris_media_player_proxy_get_type ())
#define RYGEL_MPRIS_MEDIA_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY, RygelMPRISMediaPlayerProxy))
#define RYGEL_MPRIS_IS_MEDIA_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY))
#define RYGEL_MPRIS_MEDIA_PLAYER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY, RygelMPRISMediaPlayerProxyIface))

typedef struct _RygelMPRISMediaPlayerProxy RygelMPRISMediaPlayerProxy;
typedef struct _RygelMPRISMediaPlayerProxyIface RygelMPRISMediaPlayerProxyIface;

#define RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY_PROXY (rygel_mpris_media_player_proxy_proxy_get_type ())

#define RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY_PROXY (rygel_mpris_media_player_player_proxy_proxy_get_type ())

#define RYGEL_MPRIS_TYPE_PLUGIN (rygel_mpris_plugin_get_type ())
#define RYGEL_MPRIS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPlugin))
#define RYGEL_MPRIS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginClass))
#define RYGEL_MPRIS_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_PLUGIN))
#define RYGEL_MPRIS_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MPRIS_TYPE_PLUGIN))
#define RYGEL_MPRIS_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MPRIS_TYPE_PLUGIN, RygelMPRISPluginClass))

typedef struct _RygelMPRISPlugin RygelMPRISPlugin;
typedef struct _RygelMPRISPluginClass RygelMPRISPluginClass;
typedef struct _RygelMprisPluginFactoryLoadPluginData RygelMprisPluginFactoryLoadPluginData;
typedef struct _RygelMPRISParamSpecPluginFactory RygelMPRISParamSpecPluginFactory;

struct _RygelMPRISPluginFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMPRISPluginFactoryPrivate * priv;
};

struct _RygelMPRISPluginFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMPRISPluginFactory *self);
};

struct _RygelMPRISFreeDesktopDBusObjectIface {
	GTypeInterface parent_iface;
	void (*list_names) (RygelMPRISFreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (RygelMPRISFreeDesktopDBusObject* self, GAsyncResult* _res_, gint* result_length1, GError** error);
	void (*list_activatable_names) (RygelMPRISFreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_activatable_names_finish) (RygelMPRISFreeDesktopDBusObject* self, GAsyncResult* _res_, gint* result_length1, GError** error);
};

struct _RygelMPRISPluginFactoryPrivate {
	RygelMPRISFreeDesktopDBusObject* dbus_obj;
	RygelPluginLoader* loader;
};

struct _RygelMprisPluginFactoryLoadPluginsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMPRISPluginFactory* self;
	gchar** services;
	RygelMPRISFreeDesktopDBusObject* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint services_length1;
	gint _services_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** service_collection;
	gint service_collection_length1;
	gint _service_collection_size_;
	gint service_it;
	gchar* _tmp4_;
	gchar* service;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	RygelPluginLoader* _tmp7_;
	const gchar* _tmp8_;
	RygelPlugin* _tmp9_;
	RygelPlugin* _tmp10_;
	const gchar* _tmp11_;
	GError* _inner_error0_;
};

struct _RygelMprisPluginFactoryLoadActivatablePluginsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMPRISPluginFactory* self;
	gchar** services;
	RygelMPRISFreeDesktopDBusObject* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint services_length1;
	gint _services_size_;
	gchar** service_collection;
	gint service_collection_length1;
	gint _service_collection_size_;
	gint service_it;
	gchar* _tmp3_;
	gchar* service;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	RygelPluginLoader* _tmp6_;
	const gchar* _tmp7_;
	RygelPlugin* _tmp8_;
	RygelPlugin* _tmp9_;
	const gchar* _tmp10_;
	RygelMPRISFreeDesktopDBusObject* _tmp11_;
	GError* _inner_error0_;
};

struct _RygelMprisPluginFactoryLoadPluginNHandleErrorData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMPRISPluginFactory* self;
	gchar* service_name;
	RygelPluginLoader* _tmp0_;
	GError* _error_;
	GError* _tmp1_;
	const gchar* _tmp2_;
	GError* _inner_error0_;
};

struct _RygelMPRISMediaPlayerProxyIface {
	GTypeInterface parent_iface;
	gchar* (*get_identity) (RygelMPRISMediaPlayerProxy* self);
	gchar** (*get_supported_uri_schemes) (RygelMPRISMediaPlayerProxy* self, gint* result_length1);
	gchar** (*get_supported_mime_types) (RygelMPRISMediaPlayerProxy* self, gint* result_length1);
};

struct _RygelMPRISMediaPlayerPlayerProxyIface {
	GTypeInterface parent_iface;
	void (*pause) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*play_pause) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*stop) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*play) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*seek) (RygelMPRISMediaPlayerPlayerProxy* self, gint64 offset, GError** error);
	void (*open_uri) (RygelMPRISMediaPlayerPlayerProxy* self, const gchar* uri, GError** error);
	gchar* (*get_playback_status) (RygelMPRISMediaPlayerPlayerProxy* self);
	gdouble (*get_rate) (RygelMPRISMediaPlayerPlayerProxy* self);
	void (*set_rate) (RygelMPRISMediaPlayerPlayerProxy* self, gdouble value);
	gdouble (*get_minimum_rate) (RygelMPRISMediaPlayerPlayerProxy* self);
	gdouble (*get_maximum_rate) (RygelMPRISMediaPlayerPlayerProxy* self);
	gdouble (*get_volume) (RygelMPRISMediaPlayerPlayerProxy* self);
	void (*set_volume) (RygelMPRISMediaPlayerPlayerProxy* self, gdouble value);
	gint64 (*get_position) (RygelMPRISMediaPlayerPlayerProxy* self);
	gboolean (*get_can_seek) (RygelMPRISMediaPlayerPlayerProxy* self);
	gboolean (*get_can_control) (RygelMPRISMediaPlayerPlayerProxy* self);
	GHashTable* (*get_metadata) (RygelMPRISMediaPlayerPlayerProxy* self);
};

struct _RygelMprisPluginFactoryLoadPluginData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMPRISPluginFactory* self;
	gchar* service_name;
	RygelMPRISMediaPlayerPlayerProxy* player;
	RygelMPRISMediaPlayerPlayerProxy* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	RygelMPRISPlugin* plugin;
	RygelMPRISPlugin* _tmp3_;
	RygelPluginLoader* _tmp4_;
	RygelMPRISPlugin* _tmp5_;
	GError* _inner_error0_;
};

struct _RygelMPRISParamSpecPluginFactory {
	GParamSpec parent_instance;
};

extern RygelMPRISPluginFactory* plugin_factory;
RygelMPRISPluginFactory* plugin_factory = NULL;
static gint RygelMPRISPluginFactory_private_offset;
static gpointer rygel_mpris_plugin_factory_parent_class = NULL;

gpointer rygel_mpris_plugin_factory_ref (gpointer instance);
void rygel_mpris_plugin_factory_unref (gpointer instance);
GParamSpec* rygel_mpris_param_spec_plugin_factory (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
void rygel_mpris_value_set_plugin_factory (GValue* value,
                                           gpointer v_object);
void rygel_mpris_value_take_plugin_factory (GValue* value,
                                            gpointer v_object);
gpointer rygel_mpris_value_get_plugin_factory (const GValue* value);
GType rygel_mpris_plugin_factory_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMPRISPluginFactory, rygel_mpris_plugin_factory_unref)
void module_init (RygelPluginLoader* loader);
RygelMPRISPluginFactory* rygel_mpris_plugin_factory_new (RygelPluginLoader* loader,
                                                         GError** error);
RygelMPRISPluginFactory* rygel_mpris_plugin_factory_construct (GType object_type,
                                                               RygelPluginLoader* loader,
                                                               GError** error);
#define RYGEL_MPRIS_PLUGIN_MODULE_NAME "MPRIS"
GType rygel_mpris_free_desktop_dbus_object_proxy_get_type (void) G_GNUC_CONST;
guint rygel_mpris_free_desktop_dbus_object_register_object (void* object,
                                                            GDBusConnection* connection,
                                                            const gchar* path,
                                                            GError** error);
GType rygel_mpris_free_desktop_dbus_object_get_type (void) G_GNUC_CONST;
#define RYGEL_MPRIS_PLUGIN_FACTORY_DBUS_SERVICE "org.freedesktop.DBus"
#define RYGEL_MPRIS_PLUGIN_FACTORY_DBUS_OBJECT "/org/freedesktop/DBus"
#define RYGEL_MPRIS_PLUGIN_FACTORY_SERVICE_PREFIX "org.mpris.MediaPlayer2."
#define RYGEL_MPRIS_PLUGIN_FACTORY_MEDIA_PLAYER_PATH "/org/mpris/MediaPlayer2"
static void rygel_mpris_plugin_factory_load_plugins (RygelMPRISPluginFactory* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void rygel_mpris_plugin_factory_load_plugins_finish (RygelMPRISPluginFactory* self,
                                                     GAsyncResult* _res_,
                                                     GError** error);
static void rygel_mpris_plugin_factory_load_plugins_data_free (gpointer _data);
static gboolean rygel_mpris_plugin_factory_load_plugins_co (RygelMprisPluginFactoryLoadPluginsData* _data_);
void rygel_mpris_free_desktop_dbus_object_list_names (RygelMPRISFreeDesktopDBusObject* self,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
gchar** rygel_mpris_free_desktop_dbus_object_list_names_finish (RygelMPRISFreeDesktopDBusObject* self,
                                                                GAsyncResult* _res_,
                                                                gint* result_length1,
                                                                GError** error);
static void rygel_mpris_plugin_factory_load_plugins_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void rygel_mpris_plugin_factory_load_plugin_n_handle_error (RygelMPRISPluginFactory* self,
                                                            const gchar* service_name,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
static void rygel_mpris_plugin_factory_load_plugin_n_handle_error_finish (RygelMPRISPluginFactory* self,
                                                                   GAsyncResult* _res_);
static void rygel_mpris_plugin_factory_load_activatable_plugins (RygelMPRISPluginFactory* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static void rygel_mpris_plugin_factory_load_activatable_plugins_finish (RygelMPRISPluginFactory* self,
                                                                 GAsyncResult* _res_,
                                                                 GError** error);
static void rygel_mpris_plugin_factory_load_activatable_plugins_data_free (gpointer _data);
static gboolean rygel_mpris_plugin_factory_load_activatable_plugins_co (RygelMprisPluginFactoryLoadActivatablePluginsData* _data_);
void rygel_mpris_free_desktop_dbus_object_list_activatable_names (RygelMPRISFreeDesktopDBusObject* self,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_);
gchar** rygel_mpris_free_desktop_dbus_object_list_activatable_names_finish (RygelMPRISFreeDesktopDBusObject* self,
                                                                            GAsyncResult* _res_,
                                                                            gint* result_length1,
                                                                            GError** error);
static void rygel_mpris_plugin_factory_load_activatable_plugins_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static void rygel_mpris_plugin_factory_name_owner_changed (RygelMPRISPluginFactory* self,
                                                    RygelMPRISFreeDesktopDBusObject* dbus_obj,
                                                    const gchar* name,
                                                    const gchar* old_owner,
                                                    const gchar* new_owner);
static void _rygel_mpris_plugin_factory_name_owner_changed_rygel_mpris_free_desktop_dbus_object_name_owner_changed (RygelMPRISFreeDesktopDBusObject* _sender,
                                                                                                             const gchar* name,
                                                                                                             const gchar* old_owner,
                                                                                                             const gchar* new_owner,
                                                                                                             gpointer self);
static void rygel_mpris_plugin_factory_load_plugin_n_handle_error_data_free (gpointer _data);
static gboolean rygel_mpris_plugin_factory_load_plugin_n_handle_error_co (RygelMprisPluginFactoryLoadPluginNHandleErrorData* _data_);
static void rygel_mpris_plugin_factory_load_plugin (RygelMPRISPluginFactory* self,
                                             const gchar* service_name,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void rygel_mpris_plugin_factory_load_plugin_finish (RygelMPRISPluginFactory* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static void rygel_mpris_plugin_factory_load_plugin_n_handle_error_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_);
static void rygel_mpris_plugin_factory_load_plugin_data_free (gpointer _data);
static gboolean rygel_mpris_plugin_factory_load_plugin_co (RygelMprisPluginFactoryLoadPluginData* _data_);
GType rygel_mpris_media_player_proxy_get_type (void) G_GNUC_CONST;
GType rygel_mpris_media_player_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_mpris_media_player_proxy_register_object (void* object,
                                                      GDBusConnection* connection,
                                                      const gchar* path,
                                                      GError** error);
GType rygel_mpris_media_player_player_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_mpris_media_player_player_proxy_register_object (void* object,
                                                             GDBusConnection* connection,
                                                             const gchar* path,
                                                             GError** error);
GType rygel_mpris_media_player_player_proxy_get_type (void) G_GNUC_CONST;
static void rygel_mpris_plugin_factory_load_plugin_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
gboolean rygel_mpris_media_player_player_proxy_get_can_control (RygelMPRISMediaPlayerPlayerProxy* self);
GType rygel_mpris_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMPRISPlugin, g_object_unref)
RygelMPRISPlugin* rygel_mpris_plugin_new (const gchar* service_name,
                                          RygelMPRISMediaPlayerPlayerProxy* actual_player);
RygelMPRISPlugin* rygel_mpris_plugin_construct (GType object_type,
                                                const gchar* service_name,
                                                RygelMPRISMediaPlayerPlayerProxy* actual_player);
static void rygel_mpris_plugin_factory_finalize (RygelMPRISPluginFactory * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

void
module_init (RygelPluginLoader* loader)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (loader != NULL);
	{
		RygelMPRISPluginFactory* _tmp0_ = NULL;
		RygelMPRISPluginFactory* _tmp1_;
		RygelMPRISPluginFactory* _tmp2_;
		_tmp1_ = rygel_mpris_plugin_factory_new (loader, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch5_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_rygel_mpris_plugin_factory_unref0 (plugin_factory);
		plugin_factory = _tmp2_;
		_rygel_mpris_plugin_factory_unref0 (_tmp0_);
	}
	goto __finally5;
	__catch5_g_io_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		g_message (_ ("Module “%s” could not connect to D-Bus session bus. " "Ignoring…"), RYGEL_MPRIS_PLUGIN_MODULE_NAME);
		_g_error_free0 (_error_);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static inline gpointer
rygel_mpris_plugin_factory_get_instance_private (RygelMPRISPluginFactory* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMPRISPluginFactory_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelMPRISPluginFactory*
rygel_mpris_plugin_factory_construct (GType object_type,
                                      RygelPluginLoader* loader,
                                      GError** error)
{
	RygelMPRISPluginFactory* self = NULL;
	RygelMPRISFreeDesktopDBusObject* _tmp0_ = NULL;
	RygelMPRISFreeDesktopDBusObject* _tmp1_;
	RygelMPRISFreeDesktopDBusObject* _tmp2_;
	RygelPluginLoader* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (loader != NULL, NULL);
	self = (RygelMPRISPluginFactory*) g_type_create_instance (object_type);
	_tmp1_ = (RygelMPRISFreeDesktopDBusObject*) g_initable_new (RYGEL_MPRIS_FREE_DESKTOP_TYPE_DBUS_OBJECT_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", RYGEL_MPRIS_PLUGIN_FACTORY_DBUS_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_MPRIS_PLUGIN_FACTORY_DBUS_OBJECT, "g-interface-name", "org.freedesktop.DBus", "g-interface-info", g_type_get_qdata (RYGEL_MPRIS_FREE_DESKTOP_TYPE_DBUS_OBJECT, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	_tmp0_ = (RygelMPRISFreeDesktopDBusObject*) _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_rygel_mpris_plugin_factory_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->dbus_obj);
	self->priv->dbus_obj = _tmp2_;
	_tmp3_ = _g_object_ref0 (loader);
	_g_object_unref0 (self->priv->loader);
	self->priv->loader = _tmp3_;
	rygel_mpris_plugin_factory_load_plugins (self, NULL, NULL);
	_g_object_unref0 (_tmp0_);
	return self;
}

RygelMPRISPluginFactory*
rygel_mpris_plugin_factory_new (RygelPluginLoader* loader,
                                GError** error)
{
	return rygel_mpris_plugin_factory_construct (RYGEL_MPRIS_TYPE_PLUGIN_FACTORY, loader, error);
}

static void
rygel_mpris_plugin_factory_load_plugins_data_free (gpointer _data)
{
	RygelMprisPluginFactoryLoadPluginsData* _data_;
	_data_ = _data;
	_rygel_mpris_plugin_factory_unref0 (_data_->self);
	g_slice_free (RygelMprisPluginFactoryLoadPluginsData, _data_);
}

static gpointer
_rygel_mpris_plugin_factory_ref0 (gpointer self)
{
	return self ? rygel_mpris_plugin_factory_ref (self) : NULL;
}

static void
rygel_mpris_plugin_factory_load_plugins (RygelMPRISPluginFactory* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	RygelMprisPluginFactoryLoadPluginsData* _data_;
	RygelMPRISPluginFactory* _tmp0_;
	_data_ = g_slice_new0 (RygelMprisPluginFactoryLoadPluginsData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_mpris_plugin_factory_load_plugins_data_free);
	_tmp0_ = _rygel_mpris_plugin_factory_ref0 (self);
	_data_->self = _tmp0_;
	rygel_mpris_plugin_factory_load_plugins_co (_data_);
}

static void
rygel_mpris_plugin_factory_load_plugins_finish (RygelMPRISPluginFactory* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	RygelMprisPluginFactoryLoadPluginsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_mpris_plugin_factory_load_plugins_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	RygelMprisPluginFactoryLoadPluginsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_mpris_plugin_factory_load_plugins_co (_data_);
}

static gboolean
rygel_mpris_plugin_factory_load_plugins_co (RygelMprisPluginFactoryLoadPluginsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->dbus_obj;
	_data_->_tmp1_ = 0;
	_data_->_state_ = 1;
	rygel_mpris_free_desktop_dbus_object_list_names (_data_->_tmp0_, rygel_mpris_plugin_factory_load_plugins_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = rygel_mpris_free_desktop_dbus_object_list_names_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error0_);
	_data_->services = _data_->_tmp2_;
	_data_->services_length1 = _data_->_tmp1_;
	_data_->_services_size_ = _data_->services_length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp3_ = _data_->services;
	_data_->_tmp3__length1 = _data_->services_length1;
	{
		_data_->service_collection_length1 = 0;
		_data_->_service_collection_size_ = 0;
		_data_->service_collection = _data_->_tmp3_;
		_data_->service_collection_length1 = _data_->_tmp3__length1;
		for (_data_->service_it = 0; _data_->service_it < _data_->_tmp3__length1; _data_->service_it = _data_->service_it + 1) {
			_data_->_tmp4_ = g_strdup (_data_->service_collection[_data_->service_it]);
			_data_->service = _data_->_tmp4_;
			{
				_data_->_tmp6_ = _data_->service;
				if (g_str_has_prefix (_data_->_tmp6_, RYGEL_MPRIS_PLUGIN_FACTORY_SERVICE_PREFIX)) {
					_data_->_tmp7_ = _data_->self->priv->loader;
					_data_->_tmp8_ = _data_->service;
					_data_->_tmp9_ = rygel_plugin_loader_get_plugin_by_name (_data_->_tmp7_, _data_->_tmp8_);
					_data_->_tmp10_ = _data_->_tmp9_;
					_data_->_tmp5_ = _data_->_tmp10_ == NULL;
					_g_object_unref0 (_data_->_tmp10_);
				} else {
					_data_->_tmp5_ = FALSE;
				}
				if (_data_->_tmp5_) {
					_data_->_tmp11_ = _data_->service;
					_data_->_state_ = 2;
					rygel_mpris_plugin_factory_load_plugin_n_handle_error (_data_->self, _data_->_tmp11_, rygel_mpris_plugin_factory_load_plugins_ready, _data_);
					return FALSE;
					_state_2:
					rygel_mpris_plugin_factory_load_plugin_n_handle_error_finish (_data_->self, _data_->_res_);
				}
				_g_free0 (_data_->service);
			}
		}
	}
	_data_->_state_ = 3;
	rygel_mpris_plugin_factory_load_activatable_plugins (_data_->self, rygel_mpris_plugin_factory_load_plugins_ready, _data_);
	return FALSE;
	_state_3:
	rygel_mpris_plugin_factory_load_activatable_plugins_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_data_->services = (_vala_array_free (_data_->services, _data_->services_length1, (GDestroyNotify) g_free), NULL);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->services = (_vala_array_free (_data_->services, _data_->services_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->services = (_vala_array_free (_data_->services, _data_->services_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_mpris_plugin_factory_load_activatable_plugins_data_free (gpointer _data)
{
	RygelMprisPluginFactoryLoadActivatablePluginsData* _data_;
	_data_ = _data;
	_rygel_mpris_plugin_factory_unref0 (_data_->self);
	g_slice_free (RygelMprisPluginFactoryLoadActivatablePluginsData, _data_);
}

static void
rygel_mpris_plugin_factory_load_activatable_plugins (RygelMPRISPluginFactory* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	RygelMprisPluginFactoryLoadActivatablePluginsData* _data_;
	RygelMPRISPluginFactory* _tmp0_;
	_data_ = g_slice_new0 (RygelMprisPluginFactoryLoadActivatablePluginsData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_mpris_plugin_factory_load_activatable_plugins_data_free);
	_tmp0_ = _rygel_mpris_plugin_factory_ref0 (self);
	_data_->self = _tmp0_;
	rygel_mpris_plugin_factory_load_activatable_plugins_co (_data_);
}

static void
rygel_mpris_plugin_factory_load_activatable_plugins_finish (RygelMPRISPluginFactory* self,
                                                            GAsyncResult* _res_,
                                                            GError** error)
{
	RygelMprisPluginFactoryLoadActivatablePluginsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_mpris_plugin_factory_load_activatable_plugins_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	RygelMprisPluginFactoryLoadActivatablePluginsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_mpris_plugin_factory_load_activatable_plugins_co (_data_);
}

static void
_rygel_mpris_plugin_factory_name_owner_changed_rygel_mpris_free_desktop_dbus_object_name_owner_changed (RygelMPRISFreeDesktopDBusObject* _sender,
                                                                                                        const gchar* name,
                                                                                                        const gchar* old_owner,
                                                                                                        const gchar* new_owner,
                                                                                                        gpointer self)
{
	rygel_mpris_plugin_factory_name_owner_changed ((RygelMPRISPluginFactory*) self, _sender, name, old_owner, new_owner);
}

static gboolean
rygel_mpris_plugin_factory_load_activatable_plugins_co (RygelMprisPluginFactoryLoadActivatablePluginsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->dbus_obj;
	_data_->_tmp1_ = 0;
	_data_->_state_ = 1;
	rygel_mpris_free_desktop_dbus_object_list_activatable_names (_data_->_tmp0_, rygel_mpris_plugin_factory_load_activatable_plugins_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = rygel_mpris_free_desktop_dbus_object_list_activatable_names_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error0_);
	_data_->services = _data_->_tmp2_;
	_data_->services_length1 = _data_->_tmp1_;
	_data_->_services_size_ = _data_->services_length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	{
		_data_->service_collection_length1 = 0;
		_data_->_service_collection_size_ = 0;
		_data_->service_collection = _data_->services;
		_data_->service_collection_length1 = _data_->services_length1;
		for (_data_->service_it = 0; _data_->service_it < _data_->services_length1; _data_->service_it = _data_->service_it + 1) {
			_data_->_tmp3_ = g_strdup (_data_->service_collection[_data_->service_it]);
			_data_->service = _data_->_tmp3_;
			{
				_data_->_tmp5_ = _data_->service;
				if (g_str_has_prefix (_data_->_tmp5_, RYGEL_MPRIS_PLUGIN_FACTORY_SERVICE_PREFIX)) {
					_data_->_tmp6_ = _data_->self->priv->loader;
					_data_->_tmp7_ = _data_->service;
					_data_->_tmp8_ = rygel_plugin_loader_get_plugin_by_name (_data_->_tmp6_, _data_->_tmp7_);
					_data_->_tmp9_ = _data_->_tmp8_;
					_data_->_tmp4_ = _data_->_tmp9_ == NULL;
					_g_object_unref0 (_data_->_tmp9_);
				} else {
					_data_->_tmp4_ = FALSE;
				}
				if (_data_->_tmp4_) {
					_data_->_tmp10_ = _data_->service;
					_data_->_state_ = 2;
					rygel_mpris_plugin_factory_load_plugin_n_handle_error (_data_->self, _data_->_tmp10_, rygel_mpris_plugin_factory_load_activatable_plugins_ready, _data_);
					return FALSE;
					_state_2:
					rygel_mpris_plugin_factory_load_plugin_n_handle_error_finish (_data_->self, _data_->_res_);
				}
				_g_free0 (_data_->service);
			}
		}
	}
	_data_->_tmp11_ = _data_->self->priv->dbus_obj;
	g_signal_connect (_data_->_tmp11_, "name-owner-changed", (GCallback) _rygel_mpris_plugin_factory_name_owner_changed_rygel_mpris_free_desktop_dbus_object_name_owner_changed, _data_->self);
	_data_->services = (_vala_array_free (_data_->services, _data_->services_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_mpris_plugin_factory_name_owner_changed (RygelMPRISPluginFactory* self,
                                               RygelMPRISFreeDesktopDBusObject* dbus_obj,
                                               const gchar* name,
                                               const gchar* old_owner,
                                               const gchar* new_owner)
{
	RygelPlugin* plugin = NULL;
	RygelPluginLoader* _tmp0_;
	RygelPlugin* _tmp1_;
	RygelPlugin* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_obj != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (old_owner != NULL);
	g_return_if_fail (new_owner != NULL);
	_tmp0_ = self->priv->loader;
	_tmp1_ = rygel_plugin_loader_get_plugin_by_name (_tmp0_, name);
	plugin = _tmp1_;
	_tmp2_ = plugin;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		if (g_strcmp0 (old_owner, "") != 0) {
			_tmp3_ = g_strcmp0 (new_owner, "") == 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			RygelPlugin* _tmp4_;
			g_debug ("rygel-mpris-plugin-factory.vala:95: Service '%s' going down, Deactivat" \
"ing it", name);
			_tmp4_ = plugin;
			rygel_plugin_set_active (_tmp4_, FALSE);
		} else {
			gboolean _tmp5_ = FALSE;
			if (g_strcmp0 (old_owner, "") == 0) {
				_tmp5_ = g_strcmp0 (new_owner, "") != 0;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				RygelPlugin* _tmp6_;
				g_debug ("rygel-mpris-plugin-factory.vala:99: Service '%s' up again, activating " \
"it", name);
				_tmp6_ = plugin;
				rygel_plugin_set_active (_tmp6_, TRUE);
			}
		}
	} else {
		if (g_str_has_prefix (name, RYGEL_MPRIS_PLUGIN_FACTORY_SERVICE_PREFIX)) {
			rygel_mpris_plugin_factory_load_plugin_n_handle_error (self, name, NULL, NULL);
		}
	}
	_g_object_unref0 (plugin);
}

static void
rygel_mpris_plugin_factory_load_plugin_n_handle_error_data_free (gpointer _data)
{
	RygelMprisPluginFactoryLoadPluginNHandleErrorData* _data_;
	_data_ = _data;
	_g_free0 (_data_->service_name);
	_rygel_mpris_plugin_factory_unref0 (_data_->self);
	g_slice_free (RygelMprisPluginFactoryLoadPluginNHandleErrorData, _data_);
}

static void
rygel_mpris_plugin_factory_load_plugin_n_handle_error (RygelMPRISPluginFactory* self,
                                                       const gchar* service_name,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	RygelMprisPluginFactoryLoadPluginNHandleErrorData* _data_;
	RygelMPRISPluginFactory* _tmp0_;
	gchar* _tmp1_;
	_data_ = g_slice_new0 (RygelMprisPluginFactoryLoadPluginNHandleErrorData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_mpris_plugin_factory_load_plugin_n_handle_error_data_free);
	_tmp0_ = _rygel_mpris_plugin_factory_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (service_name);
	_g_free0 (_data_->service_name);
	_data_->service_name = _tmp1_;
	rygel_mpris_plugin_factory_load_plugin_n_handle_error_co (_data_);
}

static void
rygel_mpris_plugin_factory_load_plugin_n_handle_error_finish (RygelMPRISPluginFactory* self,
                                                              GAsyncResult* _res_)
{
	RygelMprisPluginFactoryLoadPluginNHandleErrorData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_mpris_plugin_factory_load_plugin_n_handle_error_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_)
{
	RygelMprisPluginFactoryLoadPluginNHandleErrorData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_mpris_plugin_factory_load_plugin_n_handle_error_co (_data_);
}

static gboolean
rygel_mpris_plugin_factory_load_plugin_n_handle_error_co (RygelMprisPluginFactoryLoadPluginNHandleErrorData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->loader;
	if (rygel_plugin_loader_plugin_disabled (_data_->_tmp0_, _data_->service_name)) {
		g_message ("rygel-mpris-plugin-factory.vala:110: Plugin '%s' disabled by user, ign" \
"oring..", _data_->service_name);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 1;
		rygel_mpris_plugin_factory_load_plugin (_data_->self, _data_->service_name, rygel_mpris_plugin_factory_load_plugin_n_handle_error_ready, _data_);
		return FALSE;
		_state_1:
		rygel_mpris_plugin_factory_load_plugin_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == G_IO_ERROR) {
				goto __catch6_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	goto __finally6;
	__catch6_g_io_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp1_ = _data_->_error_;
		_data_->_tmp2_ = _data_->_tmp1_->message;
		g_warning ("rygel-mpris-plugin-factory.vala:118: Failed to load MPRIS2 plugin '%s'" \
": %s", _data_->service_name, _data_->_tmp2_);
		_g_error_free0 (_data_->_error_);
	}
	__finally6:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_mpris_plugin_factory_load_plugin_data_free (gpointer _data)
{
	RygelMprisPluginFactoryLoadPluginData* _data_;
	_data_ = _data;
	_g_free0 (_data_->service_name);
	_rygel_mpris_plugin_factory_unref0 (_data_->self);
	g_slice_free (RygelMprisPluginFactoryLoadPluginData, _data_);
}

static void
rygel_mpris_plugin_factory_load_plugin (RygelMPRISPluginFactory* self,
                                        const gchar* service_name,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	RygelMprisPluginFactoryLoadPluginData* _data_;
	RygelMPRISPluginFactory* _tmp0_;
	gchar* _tmp1_;
	_data_ = g_slice_new0 (RygelMprisPluginFactoryLoadPluginData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_mpris_plugin_factory_load_plugin_data_free);
	_tmp0_ = _rygel_mpris_plugin_factory_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (service_name);
	_g_free0 (_data_->service_name);
	_data_->service_name = _tmp1_;
	rygel_mpris_plugin_factory_load_plugin_co (_data_);
}

static void
rygel_mpris_plugin_factory_load_plugin_finish (RygelMPRISPluginFactory* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	RygelMprisPluginFactoryLoadPluginData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_mpris_plugin_factory_load_plugin_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	RygelMprisPluginFactoryLoadPluginData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_mpris_plugin_factory_load_plugin_co (_data_);
}

static gboolean
rygel_mpris_plugin_factory_load_plugin_co (RygelMprisPluginFactoryLoadPluginData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	g_async_initable_new_async (RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY_PROXY, 0, NULL, rygel_mpris_plugin_factory_load_plugin_ready, _data_, "g-flags", 0, "g-name", _data_->service_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_MPRIS_PLUGIN_FACTORY_MEDIA_PLAYER_PATH, "g-interface-name", "org.mpris.MediaPlayer2.Player", "g-interface-info", g_type_get_qdata (RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = (RygelMPRISMediaPlayerPlayerProxy*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
	_data_->player = (RygelMPRISMediaPlayerPlayerProxy*) _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == G_IO_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp1_ = rygel_mpris_media_player_player_proxy_get_can_control (_data_->player);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (!_data_->_tmp2_) {
		g_message (_ ("MPRIS interface at %s is read-only. Ignoring."), _data_->service_name);
		_g_object_unref0 (_data_->player);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = rygel_mpris_plugin_new (_data_->service_name, _data_->player);
	_data_->plugin = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->self->priv->loader;
	_data_->_tmp5_ = _data_->plugin;
	rygel_plugin_loader_add_plugin (_data_->_tmp4_, (RygelPlugin*) _data_->_tmp5_);
	_g_object_unref0 (_data_->plugin);
	_g_object_unref0 (_data_->player);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_mpris_value_plugin_factory_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
rygel_mpris_value_plugin_factory_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rygel_mpris_plugin_factory_unref (value->data[0].v_pointer);
	}
}

static void
rygel_mpris_value_plugin_factory_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_mpris_plugin_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
rygel_mpris_value_plugin_factory_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
rygel_mpris_value_plugin_factory_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RygelMPRISPluginFactory * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_mpris_plugin_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
rygel_mpris_value_plugin_factory_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	RygelMPRISPluginFactory ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_mpris_plugin_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
rygel_mpris_param_spec_plugin_factory (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	RygelMPRISParamSpecPluginFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_MPRIS_TYPE_PLUGIN_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
rygel_mpris_value_get_plugin_factory (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MPRIS_TYPE_PLUGIN_FACTORY), NULL);
	return value->data[0].v_pointer;
}

void
rygel_mpris_value_set_plugin_factory (GValue* value,
                                      gpointer v_object)
{
	RygelMPRISPluginFactory * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MPRIS_TYPE_PLUGIN_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_MPRIS_TYPE_PLUGIN_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_mpris_plugin_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_mpris_plugin_factory_unref (old);
	}
}

void
rygel_mpris_value_take_plugin_factory (GValue* value,
                                       gpointer v_object)
{
	RygelMPRISPluginFactory * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MPRIS_TYPE_PLUGIN_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_MPRIS_TYPE_PLUGIN_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_mpris_plugin_factory_unref (old);
	}
}

static void
rygel_mpris_plugin_factory_class_init (RygelMPRISPluginFactoryClass * klass,
                                       gpointer klass_data)
{
	rygel_mpris_plugin_factory_parent_class = g_type_class_peek_parent (klass);
	((RygelMPRISPluginFactoryClass *) klass)->finalize = rygel_mpris_plugin_factory_finalize;
	g_type_class_adjust_private_offset (klass, &RygelMPRISPluginFactory_private_offset);
}

static void
rygel_mpris_plugin_factory_instance_init (RygelMPRISPluginFactory * self,
                                          gpointer klass)
{
	self->priv = rygel_mpris_plugin_factory_get_instance_private (self);
	self->ref_count = 1;
}

static void
rygel_mpris_plugin_factory_finalize (RygelMPRISPluginFactory * obj)
{
	RygelMPRISPluginFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MPRIS_TYPE_PLUGIN_FACTORY, RygelMPRISPluginFactory);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->dbus_obj);
	_g_object_unref0 (self->priv->loader);
}

GType
rygel_mpris_plugin_factory_get_type (void)
{
	static volatile gsize rygel_mpris_plugin_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mpris_plugin_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_mpris_value_plugin_factory_init, rygel_mpris_value_plugin_factory_free_value, rygel_mpris_value_plugin_factory_copy_value, rygel_mpris_value_plugin_factory_peek_pointer, "p", rygel_mpris_value_plugin_factory_collect_value, "p", rygel_mpris_value_plugin_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMPRISPluginFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mpris_plugin_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMPRISPluginFactory), 0, (GInstanceInitFunc) rygel_mpris_plugin_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_mpris_plugin_factory_type_id;
		rygel_mpris_plugin_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMPRISPluginFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		RygelMPRISPluginFactory_private_offset = g_type_add_instance_private (rygel_mpris_plugin_factory_type_id, sizeof (RygelMPRISPluginFactoryPrivate));
		g_once_init_leave (&rygel_mpris_plugin_factory_type_id__volatile, rygel_mpris_plugin_factory_type_id);
	}
	return rygel_mpris_plugin_factory_type_id__volatile;
}

gpointer
rygel_mpris_plugin_factory_ref (gpointer instance)
{
	RygelMPRISPluginFactory * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
rygel_mpris_plugin_factory_unref (gpointer instance)
{
	RygelMPRISPluginFactory * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_MPRIS_PLUGIN_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

