/* rygel-playspeed-response.c generated by valac 0.44.3, the Vala compiler
 * generated from rygel-playspeed-response.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libsoup/soup.h>
#include <rygel-core.h>
#include <gio/gio.h>

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
typedef struct _RygelHTTPResponseElementPrivate RygelHTTPResponseElementPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_RESPONSE (rygel_play_speed_response_get_type ())
#define RYGEL_PLAY_SPEED_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_RESPONSE, RygelPlaySpeedResponse))
#define RYGEL_PLAY_SPEED_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_RESPONSE, RygelPlaySpeedResponseClass))
#define RYGEL_IS_PLAY_SPEED_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_RESPONSE))
#define RYGEL_IS_PLAY_SPEED_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_RESPONSE))
#define RYGEL_PLAY_SPEED_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_RESPONSE, RygelPlaySpeedResponseClass))

typedef struct _RygelPlaySpeedResponse RygelPlaySpeedResponse;
typedef struct _RygelPlaySpeedResponseClass RygelPlaySpeedResponseClass;
typedef struct _RygelPlaySpeedResponsePrivate RygelPlaySpeedResponsePrivate;

#define RYGEL_TYPE_PLAY_SPEED (rygel_play_speed_get_type ())
#define RYGEL_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeed))
#define RYGEL_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))
#define RYGEL_IS_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_IS_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_PLAY_SPEED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))

typedef struct _RygelPlaySpeed RygelPlaySpeed;
typedef struct _RygelPlaySpeedClass RygelPlaySpeedClass;
enum  {
	RYGEL_PLAY_SPEED_RESPONSE_0_PROPERTY,
	RYGEL_PLAY_SPEED_RESPONSE_NUM_PROPERTIES
};
static GParamSpec* rygel_play_speed_response_properties[RYGEL_PLAY_SPEED_RESPONSE_NUM_PROPERTIES];
#define _rygel_play_speed_unref0(var) ((var == NULL) ? NULL : (var = (rygel_play_speed_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_SoupMessageHeaders_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMessageHeaders_free (var), NULL)))

struct _RygelHTTPResponseElement {
	GObject parent_instance;
	RygelHTTPResponseElementPrivate * priv;
};

struct _RygelHTTPResponseElementClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPResponseElement* self, RygelHTTPRequest* request);
	gchar* (*to_string) (RygelHTTPResponseElement* self);
};

struct _RygelPlaySpeedResponse {
	RygelHTTPResponseElement parent_instance;
	RygelPlaySpeedResponsePrivate * priv;
	gint framerate;
};

struct _RygelPlaySpeedResponseClass {
	RygelHTTPResponseElementClass parent_class;
};

struct _RygelPlaySpeedResponsePrivate {
	RygelPlaySpeed* speed;
};

typedef enum  {
	RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT,
	RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT
} RygelPlaySpeedError;
#define RYGEL_PLAY_SPEED_ERROR rygel_play_speed_error_quark ()
struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

static gint RygelPlaySpeedResponse_private_offset;
static gpointer rygel_play_speed_response_parent_class = NULL;

GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPResponseElement, g_object_unref)
GType rygel_http_request_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPRequest, g_object_unref)
GType rygel_play_speed_response_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelPlaySpeedResponse, g_object_unref)
gpointer rygel_play_speed_ref (gpointer instance);
void rygel_play_speed_unref (gpointer instance);
GParamSpec* rygel_param_spec_play_speed (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void rygel_value_set_play_speed (GValue* value,
                                 gpointer v_object);
void rygel_value_take_play_speed (GValue* value,
                                  gpointer v_object);
gpointer rygel_value_get_play_speed (const GValue* value);
GType rygel_play_speed_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelPlaySpeed, rygel_play_speed_unref)
#define RYGEL_PLAY_SPEED_RESPONSE_FRAMERATE_HEADER "FrameRateInTrickMode.dlna.org"
#define RYGEL_PLAY_SPEED_RESPONSE_NO_FRAMERATE -1
RygelPlaySpeedResponse* rygel_play_speed_response_new (gint numerator,
                                                       guint denominator,
                                                       gint framerate);
RygelPlaySpeedResponse* rygel_play_speed_response_construct (GType object_type,
                                                             gint numerator,
                                                             guint denominator,
                                                             gint framerate);
RygelHTTPResponseElement* rygel_http_response_element_construct (GType object_type);
RygelPlaySpeed* rygel_play_speed_new (gint numerator,
                                      guint denominator);
RygelPlaySpeed* rygel_play_speed_construct (GType object_type,
                                            gint numerator,
                                            guint denominator);
GQuark rygel_play_speed_error_quark (void);
RygelPlaySpeedResponse* rygel_play_speed_response_new_from_speed (RygelPlaySpeed* speed,
                                                                  gint framerate,
                                                                  GError** error);
RygelPlaySpeedResponse* rygel_play_speed_response_construct_from_speed (GType object_type,
                                                                        RygelPlaySpeed* speed,
                                                                        gint framerate,
                                                                        GError** error);
RygelPlaySpeedResponse* rygel_play_speed_response_new_from_string (const gchar* speed,
                                                                   gint framerate,
                                                                   GError** error);
RygelPlaySpeedResponse* rygel_play_speed_response_construct_from_string (GType object_type,
                                                                         const gchar* speed,
                                                                         gint framerate,
                                                                         GError** error);
RygelPlaySpeed* rygel_play_speed_new_from_string (const gchar* speed,
                                                  GError** error);
RygelPlaySpeed* rygel_play_speed_construct_from_string (GType object_type,
                                                        const gchar* speed,
                                                        GError** error);
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelPlaySpeedRequest, g_object_unref)
gboolean rygel_play_speed_response_equals (RygelPlaySpeedResponse* self,
                                           RygelPlaySpeedRequest* that);
gboolean rygel_play_speed_equals (RygelPlaySpeed* self,
                                  RygelPlaySpeed* that);
RygelPlaySpeed* rygel_play_speed_request_get_speed (RygelPlaySpeedRequest* self);
static void rygel_play_speed_response_real_add_response_headers (RygelHTTPResponseElement* base,
                                                          RygelHTTPRequest* request);
gboolean rygel_play_speed_is_normal_rate (RygelPlaySpeed* self);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPServer, g_object_unref)
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPItemURI, g_object_unref)
GType rygel_media_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaObject, g_object_unref)
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelClientHacks, g_object_unref)
static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self);
#define RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER "PlaySpeed.dlna.org"
gchar* rygel_play_speed_to_string (RygelPlaySpeed* self);
static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self);
static gchar* rygel_play_speed_response_real_to_string (RygelHTTPResponseElement* base);
static void rygel_play_speed_response_finalize (GObject * obj);

static inline gpointer
rygel_play_speed_response_get_instance_private (RygelPlaySpeedResponse* self)
{
	return G_STRUCT_MEMBER_P (self, RygelPlaySpeedResponse_private_offset);
}

RygelPlaySpeedResponse*
rygel_play_speed_response_construct (GType object_type,
                                     gint numerator,
                                     guint denominator,
                                     gint framerate)
{
	RygelPlaySpeedResponse * self = NULL;
	RygelPlaySpeed* _tmp0_;
	self = (RygelPlaySpeedResponse*) rygel_http_response_element_construct (object_type);
	_tmp0_ = rygel_play_speed_new (numerator, denominator);
	_rygel_play_speed_unref0 (self->priv->speed);
	self->priv->speed = _tmp0_;
	self->framerate = framerate;
	return self;
}

RygelPlaySpeedResponse*
rygel_play_speed_response_new (gint numerator,
                               guint denominator,
                               gint framerate)
{
	return rygel_play_speed_response_construct (RYGEL_TYPE_PLAY_SPEED_RESPONSE, numerator, denominator, framerate);
}

static gpointer
_rygel_play_speed_ref0 (gpointer self)
{
	return self ? rygel_play_speed_ref (self) : NULL;
}

RygelPlaySpeedResponse*
rygel_play_speed_response_construct_from_speed (GType object_type,
                                                RygelPlaySpeed* speed,
                                                gint framerate,
                                                GError** error)
{
	RygelPlaySpeedResponse * self = NULL;
	RygelPlaySpeed* _tmp0_;
	g_return_val_if_fail (speed != NULL, NULL);
	self = (RygelPlaySpeedResponse*) rygel_http_response_element_construct (object_type);
	_tmp0_ = _rygel_play_speed_ref0 (speed);
	_rygel_play_speed_unref0 (self->priv->speed);
	self->priv->speed = _tmp0_;
	self->framerate = framerate;
	return self;
}

RygelPlaySpeedResponse*
rygel_play_speed_response_new_from_speed (RygelPlaySpeed* speed,
                                          gint framerate,
                                          GError** error)
{
	return rygel_play_speed_response_construct_from_speed (RYGEL_TYPE_PLAY_SPEED_RESPONSE, speed, framerate, error);
}

RygelPlaySpeedResponse*
rygel_play_speed_response_construct_from_string (GType object_type,
                                                 const gchar* speed,
                                                 gint framerate,
                                                 GError** error)
{
	RygelPlaySpeedResponse * self = NULL;
	RygelPlaySpeed* _tmp0_ = NULL;
	RygelPlaySpeed* _tmp1_;
	RygelPlaySpeed* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (speed != NULL, NULL);
	self = (RygelPlaySpeedResponse*) rygel_http_response_element_construct (object_type);
	_tmp1_ = rygel_play_speed_new_from_string (speed, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_PLAY_SPEED_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_rygel_play_speed_unref0 (self->priv->speed);
	self->priv->speed = _tmp2_;
	self->framerate = framerate;
	_rygel_play_speed_unref0 (_tmp0_);
	return self;
}

RygelPlaySpeedResponse*
rygel_play_speed_response_new_from_string (const gchar* speed,
                                           gint framerate,
                                           GError** error)
{
	return rygel_play_speed_response_construct_from_string (RYGEL_TYPE_PLAY_SPEED_RESPONSE, speed, framerate, error);
}

gboolean
rygel_play_speed_response_equals (RygelPlaySpeedResponse* self,
                                  RygelPlaySpeedRequest* that)
{
	gboolean result = FALSE;
	RygelPlaySpeed* _tmp0_;
	RygelPlaySpeed* _tmp1_;
	RygelPlaySpeed* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (that != NULL, FALSE);
	if (that == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->speed;
	_tmp1_ = rygel_play_speed_request_get_speed (that);
	_tmp2_ = _tmp1_;
	result = rygel_play_speed_equals (_tmp0_, _tmp2_);
	return result;
}

static SoupMessageHeaders*
_vala_SoupMessageHeaders_copy (SoupMessageHeaders* self)
{
	return g_boxed_copy (soup_message_headers_get_type (), self);
}

static gpointer
__vala_SoupMessageHeaders_copy0 (gpointer self)
{
	return self ? _vala_SoupMessageHeaders_copy (self) : NULL;
}

static void
_vala_SoupMessageHeaders_free (SoupMessageHeaders* self)
{
	g_boxed_free (soup_message_headers_get_type (), self);
}

static void
rygel_play_speed_response_real_add_response_headers (RygelHTTPResponseElement* base,
                                                     RygelHTTPRequest* request)
{
	RygelPlaySpeedResponse * self;
	RygelPlaySpeed* _tmp0_;
	self = (RygelPlaySpeedResponse*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = self->priv->speed;
	if (!rygel_play_speed_is_normal_rate (_tmp0_)) {
		SoupMessageHeaders* headers = NULL;
		SoupMessage* _tmp1_;
		SoupMessageHeaders* _tmp2_;
		SoupMessageHeaders* _tmp3_;
		SoupMessageHeaders* _tmp4_;
		RygelPlaySpeed* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		SoupMessage* _tmp13_;
		_tmp1_ = request->msg;
		_tmp2_ = _tmp1_->response_headers;
		_tmp3_ = __vala_SoupMessageHeaders_copy0 (_tmp2_);
		headers = _tmp3_;
		_tmp4_ = headers;
		_tmp5_ = self->priv->speed;
		_tmp6_ = rygel_play_speed_to_string (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("speed=", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		soup_message_headers_append (_tmp4_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER, _tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		if (self->framerate > 0) {
			gchar* framerate_val = NULL;
			gchar* _tmp10_;
			SoupMessageHeaders* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = g_strdup_printf ("rate=%02d", self->framerate);
			framerate_val = _tmp10_;
			_tmp11_ = headers;
			_tmp12_ = framerate_val;
			soup_message_headers_append (_tmp11_, RYGEL_PLAY_SPEED_RESPONSE_FRAMERATE_HEADER, _tmp12_);
			_g_free0 (framerate_val);
		}
		_tmp13_ = request->msg;
		if (soup_message_get_http_version (_tmp13_) == SOUP_HTTP_1_0) {
			SoupMessageHeaders* _tmp14_;
			_tmp14_ = headers;
			soup_message_headers_replace (_tmp14_, "Pragma", "no-cache");
		}
		__vala_SoupMessageHeaders_free0 (headers);
	}
}

static gchar*
rygel_play_speed_response_real_to_string (RygelHTTPResponseElement* base)
{
	RygelPlaySpeedResponse * self;
	gchar* result = NULL;
	RygelPlaySpeed* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self = (RygelPlaySpeedResponse*) base;
	_tmp0_ = self->priv->speed;
	_tmp1_ = rygel_play_speed_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("PlaySpeedResponse(speed=%s, framerate=%d)", _tmp2_, self->framerate);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static void
rygel_play_speed_response_class_init (RygelPlaySpeedResponseClass * klass,
                                      gpointer klass_data)
{
	rygel_play_speed_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelPlaySpeedResponse_private_offset);
	((RygelHTTPResponseElementClass *) klass)->add_response_headers = (void (*) (RygelHTTPResponseElement*, RygelHTTPRequest*)) rygel_play_speed_response_real_add_response_headers;
	((RygelHTTPResponseElementClass *) klass)->to_string = (gchar* (*) (RygelHTTPResponseElement*)) rygel_play_speed_response_real_to_string;
	G_OBJECT_CLASS (klass)->finalize = rygel_play_speed_response_finalize;
}

static void
rygel_play_speed_response_instance_init (RygelPlaySpeedResponse * self,
                                         gpointer klass)
{
	self->priv = rygel_play_speed_response_get_instance_private (self);
}

static void
rygel_play_speed_response_finalize (GObject * obj)
{
	RygelPlaySpeedResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLAY_SPEED_RESPONSE, RygelPlaySpeedResponse);
	_rygel_play_speed_unref0 (self->priv->speed);
	G_OBJECT_CLASS (rygel_play_speed_response_parent_class)->finalize (obj);
}

/**
 * This class represents a DLNA PlaySpeed response (PlaySpeed.dlna.org)
 */
GType
rygel_play_speed_response_get_type (void)
{
	static volatile gsize rygel_play_speed_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_play_speed_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaySpeedResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_play_speed_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaySpeedResponse), 0, (GInstanceInitFunc) rygel_play_speed_response_instance_init, NULL };
		GType rygel_play_speed_response_type_id;
		rygel_play_speed_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, "RygelPlaySpeedResponse", &g_define_type_info, 0);
		RygelPlaySpeedResponse_private_offset = g_type_add_instance_private (rygel_play_speed_response_type_id, sizeof (RygelPlaySpeedResponsePrivate));
		g_once_init_leave (&rygel_play_speed_response_type_id__volatile, rygel_play_speed_response_type_id);
	}
	return rygel_play_speed_response_type_id__volatile;
}

