/* rygel-media-server-plugin.c generated by valac 0.44.3, the Vala compiler
 * generated from rygel-media-server-plugin.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <rygel-core.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <config.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>

#define RYGEL_TYPE_MEDIA_SERVER_PLUGIN (rygel_media_server_plugin_get_type ())
#define RYGEL_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin))
#define RYGEL_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))

typedef struct _RygelMediaServerPlugin RygelMediaServerPlugin;
typedef struct _RygelMediaServerPluginClass RygelMediaServerPluginClass;
typedef struct _RygelMediaServerPluginPrivate RygelMediaServerPluginPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
enum  {
	RYGEL_MEDIA_SERVER_PLUGIN_0_PROPERTY,
	RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER_PROPERTY,
	RYGEL_MEDIA_SERVER_PLUGIN_SEARCH_CAPS_PROPERTY,
	RYGEL_MEDIA_SERVER_PLUGIN_UPLOAD_PROFILES_PROPERTY,
	RYGEL_MEDIA_SERVER_PLUGIN_SUPPORTED_PROFILES_PROPERTY,
	RYGEL_MEDIA_SERVER_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* rygel_media_server_plugin_properties[RYGEL_MEDIA_SERVER_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;

#define RYGEL_TYPE_SOURCE_CONNECTION_MANAGER (rygel_source_connection_manager_get_type ())
#define RYGEL_SOURCE_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManager))
#define RYGEL_SOURCE_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManagerClass))
#define RYGEL_IS_SOURCE_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER))
#define RYGEL_IS_SOURCE_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER))
#define RYGEL_SOURCE_CONNECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManagerClass))

typedef struct _RygelSourceConnectionManager RygelSourceConnectionManager;
typedef struct _RygelSourceConnectionManagerClass RygelSourceConnectionManagerClass;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR (rygel_media_receiver_registrar_get_type ())
#define RYGEL_MEDIA_RECEIVER_REGISTRAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrar))
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrarClass))
#define RYGEL_IS_MEDIA_RECEIVER_REGISTRAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR))
#define RYGEL_IS_MEDIA_RECEIVER_REGISTRAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR))
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrarClass))

typedef struct _RygelMediaReceiverRegistrar RygelMediaReceiverRegistrar;
typedef struct _RygelMediaReceiverRegistrarClass RygelMediaReceiverRegistrarClass;
typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
#define _rygel_dlna_profile_unref0(var) ((var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;

struct _RygelMediaServerPlugin {
	RygelPlugin parent_instance;
	RygelMediaServerPluginPrivate * priv;
};

struct _RygelMediaServerPluginClass {
	RygelPluginClass parent_class;
	const gchar* (*get_search_caps) (RygelMediaServerPlugin* self);
};

struct _RygelMediaServerPluginPrivate {
	RygelMediaContainer* _root_container;
	gchar* _search_caps;
	GList* _upload_profiles;
	GList* _supported_profiles;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gint RygelMediaServerPlugin_private_offset;
static gpointer rygel_media_server_plugin_parent_class = NULL;

GType rygel_media_server_plugin_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaServerPlugin, g_object_unref)
GType rygel_media_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaObject, g_object_unref)
GType rygel_media_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaContainer, g_object_unref)
static void _rygel_dlna_profile_unref0_ (gpointer var);
static inline void _g_list_free__rygel_dlna_profile_unref0_ (GList* self);
#define RYGEL_MEDIA_SERVER_PLUGIN_DMS "urn:schemas-upnp-org:device:MediaServer"
#define RYGEL_MEDIA_SERVER_PLUGIN_MEDIA_SERVER_DESC_PATH DATA_DIR "/xml/MediaServer3.xml"
RygelMediaServerPlugin* rygel_media_server_plugin_construct (GType object_type,
                                                             RygelMediaContainer* root_container,
                                                             const gchar* name,
                                                             const gchar* description,
                                                             RygelPluginCapabilities capabilities);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
static void rygel_media_server_plugin_real_constructed (GObject* base);
void rygel_media_engine_init (GError** error);
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH_NO_TRACK "xml/ContentDirectory-NoTrack.xml"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH "xml/ContentDirectory.xml"
#define RYGEL_CONTENT_DIRECTORY_UPNP_ID "urn:upnp-org:serviceId:ContentDirectory"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:3"
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelContentDirectory, g_object_unref)
GType rygel_source_connection_manager_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelSourceConnectionManager, g_object_unref)
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_ID "urn:microsoft-com:serviceId:X_MS_MediaReceiverRegistrar"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE "urn:microsoft-com:service:X_MS_MediaReceiverRegistrar:1"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_DESCRIPTION_PATH "xml/X_MS_MediaReceiverRegistrar1.xml"
GType rygel_media_receiver_registrar_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaReceiverRegistrar, g_object_unref)
RygelMediaContainer* rygel_media_server_plugin_get_root_container (RygelMediaServerPlugin* self);
gint rygel_media_container_get_child_count (RygelMediaContainer* self);
GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
static void rygel_media_server_plugin_on_container_updated (RygelMediaServerPlugin* self,
                                                     RygelMediaContainer* root_container,
                                                     RygelMediaContainer* updated,
                                                     RygelMediaObject* object,
                                                     RygelObjectEventType event_type,
                                                     gboolean sub_tree_update);
static void _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender,
                                                                                              RygelMediaContainer* container,
                                                                                              RygelMediaObject* object,
                                                                                              RygelObjectEventType event_type,
                                                                                              gboolean sub_tree_update,
                                                                                              gpointer self);
static void rygel_media_server_plugin_real_apply_hacks (RygelPlugin* base,
                                                 RygelRootDevice* device,
                                                 const gchar* description_path,
                                                 GError** error);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelClientHacks, g_object_unref)
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelXBoxHacks, g_object_unref)
GQuark rygel_client_hacks_error_quark (void);
RygelXBoxHacks* rygel_xbox_hacks_new (SoupMessage* message,
                                      GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type,
                                            SoupMessage* message,
                                            GError** error);
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self,
                                       RygelRootDevice* device,
                                       const gchar* template_path,
                                       GError** error);
static void rygel_media_server_plugin_set_root_container (RygelMediaServerPlugin* self,
                                                   RygelMediaContainer* value);
const gchar* rygel_media_server_plugin_get_search_caps (RygelMediaServerPlugin* self);
#define RYGEL_RELATIONAL_EXPRESSION_CAPS "@id,@parentID,@refID,upnp:class," "dc:title,upnp:artist,upnp:album," "dc:creator,upnp:createClass,@childCount"
GList* rygel_media_server_plugin_get_upload_profiles (RygelMediaServerPlugin* self);
GList* rygel_media_server_plugin_get_supported_profiles (RygelMediaServerPlugin* self);
void rygel_media_server_plugin_set_upload_profiles (RygelMediaServerPlugin* self,
                                                    GList* value);
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaEngine, g_object_unref)
RygelMediaEngine* rygel_media_engine_get_default (void);
GList* rygel_media_engine_get_dlna_profiles (RygelMediaEngine* self);
void rygel_media_server_plugin_set_supported_profiles (RygelMediaServerPlugin* self,
                                                       GList* value);
static void rygel_media_server_plugin_finalize (GObject * obj);
static void _vala_rygel_media_server_plugin_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_rygel_media_server_plugin_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
rygel_media_server_plugin_get_instance_private (RygelMediaServerPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaServerPlugin_private_offset);
}

static void
_rygel_dlna_profile_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL));
}

static inline void
_g_list_free__rygel_dlna_profile_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _rygel_dlna_profile_unref0_);
}

/**
     * Create an instance of the plugin.
     * The plugin's service will have the same title as its root container.
     *
     * @param root_container The container that should be served by this plugin's service.
     * @param name The non-human-readable name for the plugin and its service, used in UPnP messages and in the Rygel configuration file.
     * @param description An optional human-readable description (modelDescription) of the UPnP service provided by the plugin.
     */
RygelMediaServerPlugin*
rygel_media_server_plugin_construct (GType object_type,
                                     RygelMediaContainer* root_container,
                                     const gchar* name,
                                     const gchar* description,
                                     RygelPluginCapabilities capabilities)
{
	RygelMediaServerPlugin * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (root_container != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = rygel_media_object_get_title ((RygelMediaObject*) root_container);
	_tmp1_ = _tmp0_;
	self = (RygelMediaServerPlugin*) g_object_new (object_type, "desc-path", RYGEL_MEDIA_SERVER_PLUGIN_MEDIA_SERVER_DESC_PATH, "name", name, "title", _tmp1_, "description", description, "capabilities", capabilities, "root-container", root_container, NULL);
	return self;
}

static void
_rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender,
                                                                                         RygelMediaContainer* container,
                                                                                         RygelMediaObject* object,
                                                                                         RygelObjectEventType event_type,
                                                                                         gboolean sub_tree_update,
                                                                                         gpointer self)
{
	rygel_media_server_plugin_on_container_updated ((RygelMediaServerPlugin*) self, _sender, container, object, event_type, sub_tree_update);
}

static void
rygel_media_server_plugin_real_constructed (GObject* base)
{
	RygelMediaServerPlugin * self;
	gchar* path = NULL;
	gchar* _tmp1_;
	RygelPluginCapabilities _tmp2_;
	RygelPluginCapabilities _tmp3_;
	RygelResourceInfo* info = NULL;
	const gchar* _tmp5_;
	RygelResourceInfo* _tmp6_;
	RygelResourceInfo* _tmp7_;
	RygelResourceInfo* _tmp8_;
	RygelResourceInfo* _tmp9_;
	RygelResourceInfo* _tmp10_;
	RygelResourceInfo* _tmp11_;
	RygelMediaContainer* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GError* _inner_error0_ = NULL;
	self = (RygelMediaServerPlugin*) base;
	G_OBJECT_CLASS (rygel_media_server_plugin_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_PLUGIN, RygelPlugin));
	{
		rygel_media_engine_init (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp0_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e->message;
		g_error ("rygel-media-server-plugin.vala:147: Failed to initialize media engine:" \
" %s", _tmp0_);
		_g_error_free0 (e);
	}
	__finally20:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp1_ = g_strdup (RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH_NO_TRACK);
	path = _tmp1_;
	_tmp2_ = rygel_plugin_get_capabilities ((RygelPlugin*) self);
	_tmp3_ = _tmp2_;
	if ((_tmp3_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH);
		_g_free0 (path);
		path = _tmp4_;
	}
	_tmp5_ = path;
	_tmp6_ = rygel_resource_info_new (RYGEL_CONTENT_DIRECTORY_UPNP_ID, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE, _tmp5_, RYGEL_TYPE_CONTENT_DIRECTORY);
	info = _tmp6_;
	_tmp7_ = info;
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp7_);
	_tmp8_ = rygel_resource_info_new (RYGEL_CONNECTION_MANAGER_UPNP_ID, RYGEL_CONNECTION_MANAGER_UPNP_TYPE, RYGEL_CONNECTION_MANAGER_DESCRIPTION_PATH, RYGEL_TYPE_SOURCE_CONNECTION_MANAGER);
	_rygel_resource_info_unref0 (info);
	info = _tmp8_;
	_tmp9_ = info;
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp9_);
	_tmp10_ = rygel_resource_info_new (RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_ID, RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE, RYGEL_MEDIA_RECEIVER_REGISTRAR_DESCRIPTION_PATH, RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR);
	_rygel_resource_info_unref0 (info);
	info = _tmp10_;
	_tmp11_ = info;
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp11_);
	_tmp12_ = self->priv->_root_container;
	_tmp13_ = rygel_media_container_get_child_count (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ == 0) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		RygelMediaContainer* _tmp17_;
		_tmp15_ = rygel_plugin_get_name ((RygelPlugin*) self);
		_tmp16_ = _tmp15_;
		g_debug ("rygel-media-server-plugin.vala:177: Deactivating plugin '%s' until it " \
"provides content.", _tmp16_);
		rygel_plugin_set_active ((RygelPlugin*) self, FALSE);
		_tmp17_ = self->priv->_root_container;
		g_signal_connect_object (_tmp17_, "container-updated", (GCallback) _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated, self, 0);
	}
	_rygel_resource_info_unref0 (info);
	_g_free0 (path);
}

static void
rygel_media_server_plugin_real_apply_hacks (RygelPlugin* base,
                                            RygelRootDevice* device,
                                            const gchar* description_path,
                                            GError** error)
{
	RygelMediaServerPlugin * self;
	gchar** services = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint services_length1;
	gint _services_size_;
	RygelV1Hacks* v1_hacks = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	RygelV1Hacks* _tmp4_;
	RygelV1Hacks* _tmp5_;
	RygelXBoxHacks* xbox_hacks = NULL;
	RygelXBoxHacks* _tmp6_;
	RygelXBoxHacks* _tmp7_;
	RygelV1Hacks* _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	self = (RygelMediaServerPlugin*) base;
	g_return_if_fail (device != NULL);
	g_return_if_fail (description_path != NULL);
	_tmp0_ = g_strdup (RYGEL_CONTENT_DIRECTORY_UPNP_TYPE);
	_tmp1_ = g_strdup (RYGEL_CONNECTION_MANAGER_UPNP_TYPE);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	services = _tmp2_;
	services_length1 = 2;
	_services_size_ = services_length1;
	_tmp3_ = services;
	_tmp3__length1 = services_length1;
	_tmp4_ = rygel_v1_hacks_new (RYGEL_MEDIA_SERVER_PLUGIN_DMS, _tmp3_, _tmp3__length1);
	v1_hacks = _tmp4_;
	_tmp5_ = v1_hacks;
	rygel_v1_hacks_apply_on_device (_tmp5_, device, description_path, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (v1_hacks);
		services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp6_ = rygel_xbox_hacks_new (NULL, &_inner_error0_);
	xbox_hacks = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (v1_hacks);
		services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp7_ = xbox_hacks;
	_tmp8_ = v1_hacks;
	_tmp9_ = _tmp8_->description_path;
	rygel_xbox_hacks_apply_on_device (_tmp7_, device, _tmp9_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (xbox_hacks);
		_g_object_unref0 (v1_hacks);
		services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_g_object_unref0 (xbox_hacks);
	_g_object_unref0 (v1_hacks);
	services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
}

static void
rygel_media_server_plugin_on_container_updated (RygelMediaServerPlugin* self,
                                                RygelMediaContainer* root_container,
                                                RygelMediaContainer* updated,
                                                RygelMediaObject* object,
                                                RygelObjectEventType event_type,
                                                gboolean sub_tree_update)
{
	gboolean _tmp0_ = FALSE;
	guint _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_container != NULL);
	g_return_if_fail (updated != NULL);
	g_return_if_fail (object != NULL);
	if (updated != root_container) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = rygel_media_container_get_child_count (updated);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 0;
	}
	if (_tmp0_) {
		return;
	}
	g_signal_parse_name ("container-updated", RYGEL_TYPE_MEDIA_CONTAINER, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (root_container, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated, self);
	_tmp4_ = rygel_plugin_get_name ((RygelPlugin*) self);
	_tmp5_ = _tmp4_;
	g_debug ("rygel-media-server-plugin.vala:214: Activating plugin '%s' since it no" \
"w provides content.", _tmp5_);
	rygel_plugin_set_active ((RygelPlugin*) self, TRUE);
}

RygelMediaContainer*
rygel_media_server_plugin_get_root_container (RygelMediaServerPlugin* self)
{
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_root_container;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_media_server_plugin_set_root_container (RygelMediaServerPlugin* self,
                                              RygelMediaContainer* value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_server_plugin_get_root_container (self) != value) {
		RygelMediaContainer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_root_container);
		self->priv->_root_container = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_server_plugin_properties[RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER_PROPERTY]);
	}
}

const gchar*
rygel_media_server_plugin_get_search_caps (RygelMediaServerPlugin* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS (self)->get_search_caps (self);
}

static const gchar*
rygel_media_server_plugin_real_get_search_caps (RygelMediaServerPlugin* base)
{
	const gchar* result;
	RygelMediaServerPlugin* self;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	self = base;
	_tmp0_ = self->priv->_search_caps;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		RygelPluginCapabilities _tmp2_;
		RygelPluginCapabilities _tmp3_;
		_tmp1_ = g_strdup (RYGEL_RELATIONAL_EXPRESSION_CAPS);
		_g_free0 (self->priv->_search_caps);
		self->priv->_search_caps = _tmp1_;
		_tmp2_ = rygel_plugin_get_capabilities ((RygelPlugin*) self);
		_tmp3_ = _tmp2_;
		if ((_tmp3_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = self->priv->_search_caps;
			_tmp5_ = g_strconcat (_tmp4_, ",upnp:objectUpdateID,upnp:containerUpdateID", NULL);
			_g_free0 (self->priv->_search_caps);
			self->priv->_search_caps = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_search_caps;
	result = _tmp6_;
	return result;
}

GList*
rygel_media_server_plugin_get_upload_profiles (RygelMediaServerPlugin* self)
{
	GList* result;
	GList* _tmp0_;
	GList* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_upload_profiles;
	if (_tmp0_ == NULL) {
		GList* _tmp1_;
		GList* _tmp2_;
		_tmp1_ = rygel_media_server_plugin_get_supported_profiles (self);
		_tmp2_ = _tmp1_;
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->_upload_profiles;
	result = _tmp3_;
	return result;
}

static gpointer
_rygel_dlna_profile_ref0 (gpointer self)
{
	return self ? rygel_dlna_profile_ref (self) : NULL;
}

void
rygel_media_server_plugin_set_upload_profiles (RygelMediaServerPlugin* self,
                                               GList* value)
{
	g_return_if_fail (self != NULL);
	(self->priv->_upload_profiles == NULL) ? NULL : (self->priv->_upload_profiles = (_g_list_free__rygel_dlna_profile_unref0_ (self->priv->_upload_profiles), NULL));
	self->priv->_upload_profiles = NULL;
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
		profile_collection = value;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			RygelDLNAProfile* _tmp0_;
			RygelDLNAProfile* profile = NULL;
			_tmp0_ = _rygel_dlna_profile_ref0 ((RygelDLNAProfile*) profile_it->data);
			profile = _tmp0_;
			{
				RygelDLNAProfile* _tmp1_;
				RygelDLNAProfile* _tmp2_;
				_tmp1_ = profile;
				_tmp2_ = _rygel_dlna_profile_ref0 (_tmp1_);
				self->priv->_upload_profiles = g_list_append (self->priv->_upload_profiles, _tmp2_);
				_rygel_dlna_profile_unref0 (profile);
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_media_server_plugin_properties[RYGEL_MEDIA_SERVER_PLUGIN_UPLOAD_PROFILES_PROPERTY]);
}

GList*
rygel_media_server_plugin_get_supported_profiles (RygelMediaServerPlugin* self)
{
	GList* result;
	GList* _tmp0_;
	GList* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_supported_profiles;
	if (_tmp0_ == NULL) {
		RygelMediaEngine* _tmp1_;
		RygelMediaEngine* _tmp2_;
		GList* _tmp3_;
		GList* _tmp4_;
		_tmp1_ = rygel_media_engine_get_default ();
		_tmp2_ = _tmp1_;
		_tmp3_ = rygel_media_engine_get_dlna_profiles (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = self->priv->_supported_profiles;
	result = _tmp5_;
	return result;
}

void
rygel_media_server_plugin_set_supported_profiles (RygelMediaServerPlugin* self,
                                                  GList* value)
{
	g_return_if_fail (self != NULL);
	(self->priv->_supported_profiles == NULL) ? NULL : (self->priv->_supported_profiles = (_g_list_free__rygel_dlna_profile_unref0_ (self->priv->_supported_profiles), NULL));
	self->priv->_supported_profiles = NULL;
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
		profile_collection = value;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			RygelDLNAProfile* _tmp0_;
			RygelDLNAProfile* profile = NULL;
			_tmp0_ = _rygel_dlna_profile_ref0 ((RygelDLNAProfile*) profile_it->data);
			profile = _tmp0_;
			{
				RygelDLNAProfile* _tmp1_;
				RygelDLNAProfile* _tmp2_;
				_tmp1_ = profile;
				_tmp2_ = _rygel_dlna_profile_ref0 (_tmp1_);
				self->priv->_supported_profiles = g_list_append (self->priv->_supported_profiles, _tmp2_);
				_rygel_dlna_profile_unref0 (profile);
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_media_server_plugin_properties[RYGEL_MEDIA_SERVER_PLUGIN_SUPPORTED_PROFILES_PROPERTY]);
}

static void
rygel_media_server_plugin_class_init (RygelMediaServerPluginClass * klass,
                                      gpointer klass_data)
{
	rygel_media_server_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaServerPlugin_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_media_server_plugin_real_constructed;
	((RygelPluginClass *) klass)->apply_hacks = (void (*) (RygelPlugin*, RygelRootDevice*, const gchar*, GError**)) rygel_media_server_plugin_real_apply_hacks;
	RYGEL_MEDIA_SERVER_PLUGIN_CLASS (klass)->get_search_caps = rygel_media_server_plugin_real_get_search_caps;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_server_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_server_plugin_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_server_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER_PROPERTY, rygel_media_server_plugin_properties[RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER_PROPERTY] = g_param_spec_object ("root-container", "root-container", "root-container", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The SearchCapabilities this MediaServer plugin supports.
	     *
	     * Implementations can override this to match their capabilities. If they do,
	     * they should take care to include the change tracking capabilities
	     * (upnp:objectUpdateID, upnp:containerUpdateID) based on
	     * PluginCapabilities.TRACK_CHANGES.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_SERVER_PLUGIN_SEARCH_CAPS_PROPERTY, rygel_media_server_plugin_properties[RYGEL_MEDIA_SERVER_PLUGIN_SEARCH_CAPS_PROPERTY] = g_param_spec_string ("search-caps", "search-caps", "search-caps", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The list of DLNA profiles the MediaServer in this plugin will accept
	     * files as upload.
	     *
	     * Can be a subset of :supported_profiles. If set to %NULL, it will be
	     * reset to :supported_profiles.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_SERVER_PLUGIN_UPLOAD_PROFILES_PROPERTY, rygel_media_server_plugin_properties[RYGEL_MEDIA_SERVER_PLUGIN_UPLOAD_PROFILES_PROPERTY] = g_param_spec_pointer ("upload-profiles", "upload-profiles", "upload-profiles", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * The list of DLNA profiles the MediaServer in this plugin will be able
	     * to serve.
	     *
	     * If it does not accept all formats it can serve for uploading,
	     * :upload_profiles needs to be set to the supported subset.
	     *
	     * By default it will be the supported profiles of the #RygelMediaEngine.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_SERVER_PLUGIN_SUPPORTED_PROFILES_PROPERTY, rygel_media_server_plugin_properties[RYGEL_MEDIA_SERVER_PLUGIN_SUPPORTED_PROFILES_PROPERTY] = g_param_spec_pointer ("supported-profiles", "supported-profiles", "supported-profiles", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
rygel_media_server_plugin_instance_init (RygelMediaServerPlugin * self,
                                         gpointer klass)
{
	self->priv = rygel_media_server_plugin_get_instance_private (self);
}

static void
rygel_media_server_plugin_finalize (GObject * obj)
{
	RygelMediaServerPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin);
	_g_object_unref0 (self->priv->_root_container);
	_g_free0 (self->priv->_search_caps);
	(self->priv->_upload_profiles == NULL) ? NULL : (self->priv->_upload_profiles = (_g_list_free__rygel_dlna_profile_unref0_ (self->priv->_upload_profiles), NULL));
	(self->priv->_supported_profiles == NULL) ? NULL : (self->priv->_supported_profiles = (_g_list_free__rygel_dlna_profile_unref0_ (self->priv->_supported_profiles), NULL));
	G_OBJECT_CLASS (rygel_media_server_plugin_parent_class)->finalize (obj);
}

/**
 * This is the base class for every Rygel implementation of a UPnP media
 * server. It should be used either for a real plug-in for the Rygel process or used
 * in-process via the librygel-server API.
 *
 * The plugin instance should have a #RygelMediaContainer instance as its
 * root container, which may be provided to the constructor.
 *
 * See the
 * <link linkend="implementing-server-plugins">Implementing Server Plugins</link> section.
 */
GType
rygel_media_server_plugin_get_type (void)
{
	static volatile gsize rygel_media_server_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_server_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaServerPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_server_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaServerPlugin), 0, (GInstanceInitFunc) rygel_media_server_plugin_instance_init, NULL };
		GType rygel_media_server_plugin_type_id;
		rygel_media_server_plugin_type_id = g_type_register_static (RYGEL_TYPE_PLUGIN, "RygelMediaServerPlugin", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		RygelMediaServerPlugin_private_offset = g_type_add_instance_private (rygel_media_server_plugin_type_id, sizeof (RygelMediaServerPluginPrivate));
		g_once_init_leave (&rygel_media_server_plugin_type_id__volatile, rygel_media_server_plugin_type_id);
	}
	return rygel_media_server_plugin_type_id__volatile;
}

static void
_vala_rygel_media_server_plugin_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	RygelMediaServerPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin);
	switch (property_id) {
		case RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER_PROPERTY:
		g_value_set_object (value, rygel_media_server_plugin_get_root_container (self));
		break;
		case RYGEL_MEDIA_SERVER_PLUGIN_SEARCH_CAPS_PROPERTY:
		g_value_set_string (value, rygel_media_server_plugin_get_search_caps (self));
		break;
		case RYGEL_MEDIA_SERVER_PLUGIN_UPLOAD_PROFILES_PROPERTY:
		g_value_set_pointer (value, rygel_media_server_plugin_get_upload_profiles (self));
		break;
		case RYGEL_MEDIA_SERVER_PLUGIN_SUPPORTED_PROFILES_PROPERTY:
		g_value_set_pointer (value, rygel_media_server_plugin_get_supported_profiles (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_media_server_plugin_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	RygelMediaServerPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin);
	switch (property_id) {
		case RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER_PROPERTY:
		rygel_media_server_plugin_set_root_container (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIA_SERVER_PLUGIN_UPLOAD_PROFILES_PROPERTY:
		rygel_media_server_plugin_set_upload_profiles (self, g_value_get_pointer (value));
		break;
		case RYGEL_MEDIA_SERVER_PLUGIN_SUPPORTED_PROFILES_PROPERTY:
		rygel_media_server_plugin_set_supported_profiles (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

