/* rygel-media-objects.c generated by valac 0.44.3, the Vala compiler
 * generated from rygel-media-objects.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
typedef struct _RygelMediaObjectsPrivate RygelMediaObjectsPrivate;
enum  {
	RYGEL_MEDIA_OBJECTS_0_PROPERTY,
	RYGEL_MEDIA_OBJECTS_NUM_PROPERTIES
};
static GParamSpec* rygel_media_objects_properties[RYGEL_MEDIA_OBJECTS_NUM_PROPERTIES];

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelMediaObjects {
	GeeArrayList parent_instance;
	RygelMediaObjectsPrivate * priv;
};

struct _RygelMediaObjectsClass {
	GeeArrayListClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	RygelMediaObjects* self;
	gchar** sort_props;
	gint sort_props_length1;
	gint _sort_props_size_;
};

static gpointer rygel_media_objects_parent_class = NULL;

GType rygel_media_objects_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaObjects, g_object_unref)
#define RYGEL_MEDIA_OBJECTS_SORT_CAPS "@id,@parentID,dc:title,upnp:class," "upnp:artist,upnp:author,upnp:album," "dc:date,upnp:originalTrackNumber"
GType rygel_media_object_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaObject, g_object_unref)
static GeeList* rygel_media_objects_real_slice (GeeAbstractList* base,
                                         gint start,
                                         gint stop);
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
void rygel_media_objects_sort_by_criteria (RygelMediaObjects* self,
                                           const gchar* sort_criteria);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gint __lambda5_ (Block1Data* _data1_,
                 RygelMediaObject* a,
                 RygelMediaObject* b);
static gint rygel_media_objects_compare_media_objects (RygelMediaObjects* self,
                                                RygelMediaObject* a,
                                                RygelMediaObject* b,
                                                gchar** sort_props,
                                                gint sort_props_length1);
static gint ___lambda5__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
GType rygel_serializer_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelSerializer, g_object_unref)
GType rygel_http_server_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelHTTPServer, g_object_unref)
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelClientHacks, g_object_unref)
void rygel_media_objects_serialize (RygelMediaObjects* self,
                                    RygelSerializer* serializer,
                                    RygelHTTPServer* http_server,
                                    RygelClientHacks* hacks,
                                    GError** error);
void rygel_client_hacks_apply (RygelClientHacks* self,
                               RygelMediaObject* object);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self,
                                                   RygelSerializer* serializer,
                                                   RygelHTTPServer* http_server,
                                                   GError** error);
gint rygel_media_object_compare_by_property (RygelMediaObject* self,
                                             RygelMediaObject* media_object,
                                             const gchar* property);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static GeeList*
rygel_media_objects_real_slice (GeeAbstractList* base,
                                gint start,
                                gint stop)
{
	RygelMediaObjects * self;
	GeeList* result = NULL;
	GeeList* slice = NULL;
	GeeList* _tmp0_;
	RygelMediaObjects* ret = NULL;
	RygelMediaObjects* _tmp1_;
	self = (RygelMediaObjects*) base;
	_tmp0_ = GEE_ABSTRACT_LIST_CLASS (rygel_media_objects_parent_class)->slice ((GeeAbstractList*) G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ARRAY_LIST, GeeArrayList), start, stop);
	slice = _tmp0_;
	_tmp1_ = rygel_media_objects_new ();
	ret = _tmp1_;
	gee_array_list_add_all ((GeeArrayList*) ret, (GeeCollection*) slice);
	result = (GeeList*) ret;
	_g_object_unref0 (slice);
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelMediaObjects* self;
		self = _data1_->self;
		_data1_->sort_props = (_vala_array_free (_data1_->sort_props, _data1_->sort_props_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
__lambda5_ (Block1Data* _data1_,
            RygelMediaObject* a,
            RygelMediaObject* b)
{
	RygelMediaObjects* self;
	gint result = 0;
	RygelMediaObject* object_a = NULL;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* object_b = NULL;
	RygelMediaObject* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = _data1_->self;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (a, RYGEL_TYPE_MEDIA_OBJECT) ? ((RygelMediaObject*) a) : NULL);
	object_a = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (b, RYGEL_TYPE_MEDIA_OBJECT) ? ((RygelMediaObject*) b) : NULL);
	object_b = _tmp1_;
	_tmp2_ = _data1_->sort_props;
	_tmp2__length1 = _data1_->sort_props_length1;
	result = rygel_media_objects_compare_media_objects (self, object_a, object_b, _tmp2_, (gint) _tmp2__length1);
	_g_object_unref0 (object_b);
	_g_object_unref0 (object_a);
	return result;
}

static gint
___lambda5__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda5_ (self, (RygelMediaObject*) a, (RygelMediaObject*) b);
	return result;
}

void
rygel_media_objects_sort_by_criteria (RygelMediaObjects* self,
                                      const gchar* sort_criteria)
{
	Block1Data* _data1_;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sort_criteria != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp1_ = _tmp0_ = g_strsplit (sort_criteria, ",", 0);
	_data1_->sort_props = _tmp1_;
	_data1_->sort_props_length1 = _vala_array_length (_tmp0_);
	_data1_->_sort_props_size_ = _data1_->sort_props_length1;
	_tmp2_ = _data1_->sort_props;
	_tmp2__length1 = _data1_->sort_props_length1;
	if (_tmp2__length1 == 0) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	gee_list_sort ((GeeList*) self, ___lambda5__gcompare_data_func, block1_data_ref (_data1_), block1_data_unref);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

void
rygel_media_objects_serialize (RygelMediaObjects* self,
                               RygelSerializer* serializer,
                               RygelHTTPServer* http_server,
                               RygelClientHacks* hacks,
                               GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (serializer != NULL);
	g_return_if_fail (http_server != NULL);
	{
		RygelMediaObjects* _result_list = NULL;
		RygelMediaObjects* _tmp0_;
		gint _result_size = 0;
		RygelMediaObjects* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _result_index = 0;
		_tmp0_ = _g_object_ref0 (self);
		_result_list = _tmp0_;
		_tmp1_ = _result_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_result_size = _tmp3_;
		_result_index = -1;
		while (TRUE) {
			RygelMediaObject* _result_ = NULL;
			RygelMediaObjects* _tmp4_;
			gpointer _tmp5_;
			RygelMediaObject* _tmp7_;
			GUPnPDIDLLiteObject* _tmp8_;
			GUPnPDIDLLiteObject* _tmp9_;
			_result_index = _result_index + 1;
			if (!(_result_index < _result_size)) {
				break;
			}
			_tmp4_ = _result_list;
			_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, _result_index);
			_result_ = (RygelMediaObject*) _tmp5_;
			if (hacks != NULL) {
				RygelMediaObject* _tmp6_;
				_tmp6_ = _result_;
				rygel_client_hacks_apply (hacks, _tmp6_);
			}
			_tmp7_ = _result_;
			_tmp8_ = rygel_media_object_serialize (_tmp7_, serializer, http_server, &_inner_error0_);
			_tmp9_ = _tmp8_;
			_g_object_unref0 (_tmp9_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_result_);
				_g_object_unref0 (_result_list);
				return;
			}
			_g_object_unref0 (_result_);
		}
		_g_object_unref0 (_result_list);
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gint
rygel_media_objects_compare_media_objects (RygelMediaObjects* self,
                                           RygelMediaObject* a,
                                           RygelMediaObject* b,
                                           gchar** sort_props,
                                           gint sort_props_length1)
{
	gint result = 0;
	gint i = 0;
	gint ret = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	ret = 0;
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gchar* property = NULL;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			if (ret == 0) {
				_tmp2_ = i < sort_props_length1;
			} else {
				_tmp2_ = FALSE;
			}
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = sort_props[i];
			_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) -1);
			property = _tmp4_;
			_tmp5_ = property;
			ret = rygel_media_object_compare_by_property (a, b, _tmp5_);
			_tmp6_ = sort_props[i];
			if (string_get (_tmp6_, (glong) 0) == '-') {
				ret = 0 - ret;
			}
			_g_free0 (property);
		}
	}
	result = ret;
	return result;
}

RygelMediaObjects*
rygel_media_objects_construct (GType object_type)
{
	RygelMediaObjects * self = NULL;
	self = (RygelMediaObjects*) gee_array_list_construct (object_type, RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	return self;
}

RygelMediaObjects*
rygel_media_objects_new (void)
{
	return rygel_media_objects_construct (RYGEL_TYPE_MEDIA_OBJECTS);
}

static void
rygel_media_objects_class_init (RygelMediaObjectsClass * klass,
                                gpointer klass_data)
{
	rygel_media_objects_parent_class = g_type_class_peek_parent (klass);
	((GeeAbstractListClass *) klass)->slice = (GeeList* (*) (GeeAbstractList*, gint, gint)) rygel_media_objects_real_slice;
}

static void
rygel_media_objects_instance_init (RygelMediaObjects * self,
                                   gpointer klass)
{
}

/**
 * An array list that keeps media objects.
 */
GType
rygel_media_objects_get_type (void)
{
	static volatile gsize rygel_media_objects_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_objects_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_objects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObjects), 0, (GInstanceInitFunc) rygel_media_objects_instance_init, NULL };
		GType rygel_media_objects_type_id;
		rygel_media_objects_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "RygelMediaObjects", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_objects_type_id__volatile, rygel_media_objects_type_id);
	}
	return rygel_media_objects_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

