/* rygel-basic-management-test-nslookup.c generated by valac 0.44.3, the Vala compiler
 * generated from rygel-basic-management-test-nslookup.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Christophe Guiraud,
 *         Jussi Kukkonen
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST (rygel_basic_management_test_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest))
#define RYGEL_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))

typedef struct _RygelBasicManagementTest RygelBasicManagementTest;
typedef struct _RygelBasicManagementTestClass RygelBasicManagementTestClass;
typedef struct _RygelBasicManagementTestPrivate RygelBasicManagementTestPrivate;
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER
} RygelBasicManagementTestInitState;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_INIT_STATE (rygel_basic_management_test_init_state_get_type ())

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP (rygel_basic_management_test_ns_lookup_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup))
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP))
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupClass))

typedef struct _RygelBasicManagementTestNSLookup RygelBasicManagementTestNSLookup;
typedef struct _RygelBasicManagementTestNSLookupClass RygelBasicManagementTestNSLookupClass;
typedef struct _RygelBasicManagementTestNSLookupPrivate RygelBasicManagementTestNSLookupPrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_RESULT (rygel_basic_management_test_ns_lookup_result_get_type ())
typedef struct _RygelBasicManagementTestNSLookupResult RygelBasicManagementTestNSLookupResult;
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME
} RygelBasicManagementTestNSLookupProcessState;

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_PROCESS_STATE (rygel_basic_management_test_ns_lookup_process_state_get_type ())
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_TIMEOUT,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER
} RygelBasicManagementTestNSLookupResultStatus;

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_RESULT_STATUS (rygel_basic_management_test_ns_lookup_result_status_get_type ())
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE
} RygelBasicManagementTestNSLookupAnswerType;

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_ANSWER_TYPE (rygel_basic_management_test_ns_lookup_answer_type_get_type ())
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER
} RygelBasicManagementTestNSLookupGenericStatus;

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_GENERIC_STATUS (rygel_basic_management_test_ns_lookup_generic_status_get_type ())
enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_0_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HOST_NAME_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NAME_SERVER_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_INTERVAL_TIME_OUT_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_REPETITIONS_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_METHOD_TYPE_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULTS_TYPE_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NUM_PROPERTIES
};
static GParamSpec* rygel_basic_management_test_ns_lookup_properties[RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_CANCELED
} RygelBasicManagementTestExecutionState;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_EXECUTION_STATE (rygel_basic_management_test_execution_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelBasicManagementTest {
	GObject parent_instance;
	RygelBasicManagementTestPrivate * priv;
	GCancellable* _cancellable;
	RygelBasicManagementTestInitState init_state;
	gchar* id;
	guint iterations;
	GSpawnFlags flags;
	gchar** command;
	gint command_length1;
	gint _command_size_;
};

struct _RygelBasicManagementTestClass {
	GObjectClass parent_class;
	void (*init_iteration) (RygelBasicManagementTest* self);
	void (*handle_output) (RygelBasicManagementTest* self, const gchar* line);
	void (*handle_error) (RygelBasicManagementTest* self, const gchar* line);
	gboolean (*finish_iteration) (RygelBasicManagementTest* self);
	void (*run) (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelBasicManagementTest* self, GAsyncResult* _res_);
	const gchar* (*get_method_type) (RygelBasicManagementTest* self);
	const gchar* (*get_results_type) (RygelBasicManagementTest* self);
};

struct _RygelBasicManagementTestNSLookup {
	RygelBasicManagementTest parent_instance;
	RygelBasicManagementTestNSLookupPrivate * priv;
};

struct _RygelBasicManagementTestNSLookupClass {
	RygelBasicManagementTestClass parent_class;
};

struct _RygelBasicManagementTestNSLookupResult {
	RygelBasicManagementTestNSLookupProcessState state;
	gchar* name_server_address;
	gchar* returned_host_name;
	gchar** addresses;
	gint addresses_length1;
	gint _addresses_size_;
	RygelBasicManagementTestNSLookupResultStatus status;
	RygelBasicManagementTestNSLookupAnswerType answer_type;
	guint execution_time;
};

struct _RygelBasicManagementTestNSLookupPrivate {
	gchar* _host_name;
	gchar* _name_server;
	guint _interval_time_out;
	guint _repetitions;
	RygelBasicManagementTestNSLookupResult* results;
	gint results_length1;
	gint _results_size_;
	RygelBasicManagementTestNSLookupGenericStatus generic_status;
	gchar* additional_info;
	GTimer* timer;
};

static gint RygelBasicManagementTestNSLookup_private_offset;
static gpointer rygel_basic_management_test_ns_lookup_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelBasicManagementTest, g_object_unref)
GType rygel_basic_management_test_init_state_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_ns_lookup_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelBasicManagementTestNSLookup, g_object_unref)
static GType rygel_basic_management_test_ns_lookup_result_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType rygel_basic_management_test_ns_lookup_process_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType rygel_basic_management_test_ns_lookup_result_status_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType rygel_basic_management_test_ns_lookup_answer_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static RygelBasicManagementTestNSLookupResult* rygel_basic_management_test_ns_lookup_result_dup (const RygelBasicManagementTestNSLookupResult* self);
static void rygel_basic_management_test_ns_lookup_result_free (RygelBasicManagementTestNSLookupResult* self);
static void rygel_basic_management_test_ns_lookup_result_copy (const RygelBasicManagementTestNSLookupResult* self,
                                                        RygelBasicManagementTestNSLookupResult* dest);
static void rygel_basic_management_test_ns_lookup_result_destroy (RygelBasicManagementTestNSLookupResult* self);
static GType rygel_basic_management_test_ns_lookup_generic_status_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gchar* rygel_basic_management_test_ns_lookup_generic_status_to_string (RygelBasicManagementTestNSLookupGenericStatus self);
static gchar* rygel_basic_management_test_ns_lookup_result_status_to_string (RygelBasicManagementTestNSLookupResultStatus self);
static gchar* rygel_basic_management_test_ns_lookup_answer_type_to_string (RygelBasicManagementTestNSLookupAnswerType self);
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_INTERVAL_TIMEOUT ((guint) 1000)
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_REPETITIONS ((guint) 1)
static void _vala_RygelBasicManagementTestNSLookupResult_array_free (RygelBasicManagementTestNSLookupResult * array,
                                                              gint array_length);
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HEADER "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" "<bms:NSLookupResult " "xmlns:bms=\"urn:schemas-upnp-org:dm:bms\" " "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " "xsi:schemaLocation=\"" "urn:schemas-upnp-org:dm:bms " "http://www.upnp.org/schemas/dm/bms.xsd\">\n"
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_FOOTER "</bms:NSLookupResult>\n"
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_REPETITIONS ((guint) 100)
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MIN_INTERVAL_TIMEOUT ((guint) 1000)
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_INTERVAL_TIMEOUT ((guint) 30000)
RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_new (const gchar* host_name,
                                                                             const gchar* name_server,
                                                                             guint repetitions,
                                                                             guint32 interval_time_out);
RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_construct (GType object_type,
                                                                                   const gchar* host_name,
                                                                                   const gchar* name_server,
                                                                                   guint repetitions,
                                                                                   guint32 interval_time_out);
static void rygel_basic_management_test_ns_lookup_real_constructed (GObject* base);
static guint rygel_basic_management_test_ns_lookup_get_interval_time_out (RygelBasicManagementTestNSLookup* self);
static guint rygel_basic_management_test_ns_lookup_get_repetitions (RygelBasicManagementTestNSLookup* self);
static const gchar* rygel_basic_management_test_ns_lookup_get_host_name (RygelBasicManagementTestNSLookup* self);
static const gchar* rygel_basic_management_test_ns_lookup_get_name_server (RygelBasicManagementTestNSLookup* self);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void rygel_basic_management_test_ns_lookup_real_init_iteration (RygelBasicManagementTest* base);
void rygel_basic_management_test_init_iteration (RygelBasicManagementTest* self);
static void _vala_array_add2 (RygelBasicManagementTestNSLookupResult* * array,
                       int* length,
                       int* size,
                       const RygelBasicManagementTestNSLookupResult* value);
static gboolean rygel_basic_management_test_ns_lookup_real_finish_iteration (RygelBasicManagementTest* base);
gboolean rygel_basic_management_test_finish_iteration (RygelBasicManagementTest* self);
static void rygel_basic_management_test_ns_lookup_real_handle_error (RygelBasicManagementTest* base,
                                                              const gchar* line);
GType rygel_basic_management_test_execution_state_get_type (void) G_GNUC_CONST;
void rygel_basic_management_test_set_execution_state (RygelBasicManagementTest* self,
                                                      RygelBasicManagementTestExecutionState value);
static void rygel_basic_management_test_ns_lookup_real_handle_output (RygelBasicManagementTest* base,
                                                               const gchar* line);
static void _vala_array_add3 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
void rygel_basic_management_test_ns_lookup_get_results (RygelBasicManagementTestNSLookup* self,
                                                        gchar* * status,
                                                        gchar* * additional_info,
                                                        guint* success_count,
                                                        gchar* * result_string);
static gchar* rygel_basic_management_test_ns_lookup_result_to_xml_fragment (RygelBasicManagementTestNSLookupResult *self);
static void rygel_basic_management_test_ns_lookup_set_host_name (RygelBasicManagementTestNSLookup* self,
                                                          const gchar* value);
static void rygel_basic_management_test_ns_lookup_set_name_server (RygelBasicManagementTestNSLookup* self,
                                                            const gchar* value);
static void rygel_basic_management_test_ns_lookup_set_interval_time_out (RygelBasicManagementTestNSLookup* self,
                                                                  guint value);
static void rygel_basic_management_test_ns_lookup_set_repetitions (RygelBasicManagementTestNSLookup* self,
                                                            guint value);
static gchar* rygel_basic_management_test_ns_lookup_result_get_addresses_csv (RygelBasicManagementTestNSLookupResult *self);
static gchar** _vala_array_dup1 (gchar** self,
                          int length);
static void rygel_basic_management_test_ns_lookup_finalize (GObject * obj);
const gchar* rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self);
const gchar* rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self);
static void _vala_rygel_basic_management_test_ns_lookup_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_rygel_basic_management_test_ns_lookup_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
rygel_basic_management_test_ns_lookup_get_instance_private (RygelBasicManagementTestNSLookup* self)
{
	return G_STRUCT_MEMBER_P (self, RygelBasicManagementTestNSLookup_private_offset);
}

static GType
rygel_basic_management_test_ns_lookup_process_state_get_type (void)
{
	static volatile gsize rygel_basic_management_test_ns_lookup_process_state_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_process_state_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT", "init"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER", "server"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME", "name"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ns_lookup_process_state_type_id;
		rygel_basic_management_test_ns_lookup_process_state_type_id = g_enum_register_static ("RygelBasicManagementTestNSLookupProcessState", values);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_process_state_type_id__volatile, rygel_basic_management_test_ns_lookup_process_state_type_id);
	}
	return rygel_basic_management_test_ns_lookup_process_state_type_id__volatile;
}

static gchar*
rygel_basic_management_test_ns_lookup_generic_status_to_string (RygelBasicManagementTestNSLookupGenericStatus self)
{
	gchar* result = NULL;
	switch (self) {
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("Success");
			result = _tmp0_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Error_DNSServerNotResolved");
			result = _tmp1_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("Error_Internal");
			result = _tmp2_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Error_Other");
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
rygel_basic_management_test_ns_lookup_generic_status_get_type (void)
{
	static volatile gsize rygel_basic_management_test_ns_lookup_generic_status_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_generic_status_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS", "success"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED", "error-dns-server-not-resolved"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL", "error-internal"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER", "error-other"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ns_lookup_generic_status_type_id;
		rygel_basic_management_test_ns_lookup_generic_status_type_id = g_enum_register_static ("RygelBasicManagementTestNSLookupGenericStatus", values);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_generic_status_type_id__volatile, rygel_basic_management_test_ns_lookup_generic_status_type_id);
	}
	return rygel_basic_management_test_ns_lookup_generic_status_type_id__volatile;
}

static gchar*
rygel_basic_management_test_ns_lookup_result_status_to_string (RygelBasicManagementTestNSLookupResultStatus self)
{
	gchar* result = NULL;
	switch (self) {
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("Success");
			result = _tmp0_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Error_DNSServerNotAvailable");
			result = _tmp1_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("Error_HostNameNotResolved");
			result = _tmp2_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_TIMEOUT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Error_Timeout");
			result = _tmp3_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("Error_Other");
			result = _tmp4_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
rygel_basic_management_test_ns_lookup_result_status_get_type (void)
{
	static volatile gsize rygel_basic_management_test_ns_lookup_result_status_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_result_status_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS", "success"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE", "error-dns-server-not-available"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED", "error-hostname-not-resolved"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_TIMEOUT, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_TIMEOUT", "error-timeout"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER", "error-other"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ns_lookup_result_status_type_id;
		rygel_basic_management_test_ns_lookup_result_status_type_id = g_enum_register_static ("RygelBasicManagementTestNSLookupResultStatus", values);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_result_status_type_id__volatile, rygel_basic_management_test_ns_lookup_result_status_type_id);
	}
	return rygel_basic_management_test_ns_lookup_result_status_type_id__volatile;
}

static gchar*
rygel_basic_management_test_ns_lookup_answer_type_to_string (RygelBasicManagementTestNSLookupAnswerType self)
{
	gchar* result = NULL;
	switch (self) {
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("None");
			result = _tmp0_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Authoritative");
			result = _tmp1_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("NonAuthoritative");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
rygel_basic_management_test_ns_lookup_answer_type_get_type (void)
{
	static volatile gsize rygel_basic_management_test_ns_lookup_answer_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_answer_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE", "none"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE", "authoritative"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE", "non-authoritative"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ns_lookup_answer_type_type_id;
		rygel_basic_management_test_ns_lookup_answer_type_type_id = g_enum_register_static ("RygelBasicManagementTestNSLookupAnswerType", values);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_answer_type_type_id__volatile, rygel_basic_management_test_ns_lookup_answer_type_type_id);
	}
	return rygel_basic_management_test_ns_lookup_answer_type_type_id__volatile;
}

static void
_vala_RygelBasicManagementTestNSLookupResult_array_free (RygelBasicManagementTestNSLookupResult * array,
                                                         gint array_length)
{
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			rygel_basic_management_test_ns_lookup_result_destroy (&array[i]);
		}
	}
	g_free (array);
}

RygelBasicManagementTestNSLookup*
rygel_basic_management_test_ns_lookup_construct (GType object_type,
                                                 const gchar* host_name,
                                                 const gchar* name_server,
                                                 guint repetitions,
                                                 guint32 interval_time_out)
{
	RygelBasicManagementTestNSLookup * self = NULL;
	g_return_val_if_fail (host_name != NULL, NULL);
	self = (RygelBasicManagementTestNSLookup*) g_object_new (object_type, "host-name", host_name, "name-server", name_server, "repetitions", repetitions, "interval-time-out", interval_time_out, NULL);
	return self;
}

RygelBasicManagementTestNSLookup*
rygel_basic_management_test_ns_lookup_new (const gchar* host_name,
                                           const gchar* name_server,
                                           guint repetitions,
                                           guint32 interval_time_out)
{
	return rygel_basic_management_test_ns_lookup_construct (RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, host_name, name_server, repetitions, interval_time_out);
}

static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
rygel_basic_management_test_ns_lookup_real_constructed (GObject* base)
{
	RygelBasicManagementTestNSLookup * self;
	gchar* _tmp0_;
	RygelBasicManagementTestNSLookupResult* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gchar* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	guint _tmp20_;
	guint _tmp21_;
	self = (RygelBasicManagementTestNSLookup*) base;
	G_OBJECT_CLASS (rygel_basic_management_test_ns_lookup_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
	self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL;
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->additional_info);
	self->priv->additional_info = _tmp0_;
	_tmp1_ = g_new0 (RygelBasicManagementTestNSLookupResult, 0);
	self->priv->results = (_vala_RygelBasicManagementTestNSLookupResult_array_free (self->priv->results, self->priv->results_length1), NULL);
	self->priv->results = _tmp1_;
	self->priv->results_length1 = 0;
	self->priv->_results_size_ = self->priv->results_length1;
	_tmp2_ = g_strdup ("nslookup");
	_tmp3_ = rygel_basic_management_test_ns_lookup_get_interval_time_out (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("-timeout=%u", _tmp4_ / 1000);
	_tmp6_ = rygel_basic_management_test_ns_lookup_get_repetitions (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("-retry=%u", _tmp7_);
	_tmp9_ = self->priv->_host_name;
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = g_new0 (gchar*, 4 + 1);
	_tmp11_[0] = _tmp2_;
	_tmp11_[1] = _tmp5_;
	_tmp11_[2] = _tmp8_;
	_tmp11_[3] = _tmp10_;
	((RygelBasicManagementTest*) self)->command = (_vala_array_free (((RygelBasicManagementTest*) self)->command, ((RygelBasicManagementTest*) self)->command_length1, (GDestroyNotify) g_free), NULL);
	((RygelBasicManagementTest*) self)->command = _tmp11_;
	((RygelBasicManagementTest*) self)->command_length1 = 4;
	((RygelBasicManagementTest*) self)->_command_size_ = ((RygelBasicManagementTest*) self)->command_length1;
	_tmp13_ = self->priv->_name_server;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp14_ = self->priv->_name_server;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp12_ = _tmp16_ > 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp17_ = ((RygelBasicManagementTest*) self)->command;
		_tmp17__length1 = ((RygelBasicManagementTest*) self)->command_length1;
		_tmp18_ = self->priv->_name_server;
		_tmp19_ = g_strdup (_tmp18_);
		_vala_array_add1 (&((RygelBasicManagementTest*) self)->command, &((RygelBasicManagementTest*) self)->command_length1, &((RygelBasicManagementTest*) self)->_command_size_, _tmp19_);
	}
	_tmp20_ = rygel_basic_management_test_ns_lookup_get_repetitions (self);
	_tmp21_ = _tmp20_;
	if (_tmp21_ > RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_REPETITIONS) {
		gchar* msg = NULL;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		guint _tmp24_;
		guint _tmp25_;
		gchar* _tmp26_;
		((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
		_tmp22_ = g_strdup ("NumberOfRepetitions %u is not in allowed range [0, %u]");
		msg = _tmp22_;
		_tmp23_ = msg;
		_tmp24_ = rygel_basic_management_test_ns_lookup_get_repetitions (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strdup_printf (_tmp23_, _tmp25_, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_REPETITIONS);
		_g_free0 (self->priv->additional_info);
		self->priv->additional_info = _tmp26_;
		_g_free0 (msg);
	} else {
		gboolean _tmp27_ = FALSE;
		guint _tmp28_;
		guint _tmp29_;
		_tmp28_ = rygel_basic_management_test_ns_lookup_get_interval_time_out (self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ < RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MIN_INTERVAL_TIMEOUT) {
			_tmp27_ = TRUE;
		} else {
			guint _tmp30_;
			guint _tmp31_;
			_tmp30_ = rygel_basic_management_test_ns_lookup_get_interval_time_out (self);
			_tmp31_ = _tmp30_;
			_tmp27_ = _tmp31_ > RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_INTERVAL_TIMEOUT;
		}
		if (_tmp27_) {
			gchar* msg = NULL;
			gchar* _tmp32_;
			const gchar* _tmp33_;
			guint _tmp34_;
			guint _tmp35_;
			gchar* _tmp36_;
			((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
			_tmp32_ = g_strdup ("Timeout %u is not in allowed range [%u, %u]");
			msg = _tmp32_;
			_tmp33_ = msg;
			_tmp34_ = rygel_basic_management_test_ns_lookup_get_interval_time_out (self);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strdup_printf (_tmp33_, _tmp35_, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MIN_INTERVAL_TIMEOUT, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_INTERVAL_TIMEOUT);
			_g_free0 (self->priv->additional_info);
			self->priv->additional_info = _tmp36_;
			_g_free0 (msg);
		}
	}
}

static void
_vala_array_add2 (RygelBasicManagementTestNSLookupResult* * array,
                  int* length,
                  int* size,
                  const RygelBasicManagementTestNSLookupResult* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (RygelBasicManagementTestNSLookupResult, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
rygel_basic_management_test_ns_lookup_real_init_iteration (RygelBasicManagementTest* base)
{
	RygelBasicManagementTestNSLookup * self;
	RygelBasicManagementTestNSLookupResult _result_ = {0};
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	RygelBasicManagementTestNSLookupResult _tmp3_ = {0};
	RygelBasicManagementTestNSLookupResult* _tmp4_;
	gint _tmp4__length1;
	RygelBasicManagementTestNSLookupResult _tmp5_;
	RygelBasicManagementTestNSLookupResult _tmp6_ = {0};
	GTimer* _tmp7_;
	self = (RygelBasicManagementTestNSLookup*) base;
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (rygel_basic_management_test_ns_lookup_parent_class)->init_iteration (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
	_tmp0_ = g_strdup ("");
	_tmp1_ = g_strdup ("");
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	memset (&_tmp3_, 0, sizeof (RygelBasicManagementTestNSLookupResult));
	_tmp3_.state = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT;
	_g_free0 (_tmp3_.name_server_address);
	_tmp3_.name_server_address = _tmp0_;
	_g_free0 (_tmp3_.returned_host_name);
	_tmp3_.returned_host_name = _tmp1_;
	_tmp3_.addresses = (_vala_array_free (_tmp3_.addresses, _tmp3_.addresses_length1, (GDestroyNotify) g_free), NULL);
	_tmp3_.addresses = _tmp2_;
	_tmp3_.addresses_length1 = 0;
	_tmp3_._addresses_size_ = _tmp3_.addresses_length1;
	_tmp3_.status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER;
	_tmp3_.answer_type = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE;
	_tmp3_.execution_time = (guint) 0;
	_result_ = _tmp3_;
	_tmp4_ = self->priv->results;
	_tmp4__length1 = self->priv->results_length1;
	_tmp5_ = _result_;
	rygel_basic_management_test_ns_lookup_result_copy (&_tmp5_, &_tmp6_);
	_vala_array_add2 (&self->priv->results, &self->priv->results_length1, &self->priv->_results_size_, &_tmp6_);
	_tmp7_ = self->priv->timer;
	g_timer_start (_tmp7_);
	rygel_basic_management_test_ns_lookup_result_destroy (&_result_);
}

static gboolean
rygel_basic_management_test_ns_lookup_real_finish_iteration (RygelBasicManagementTest* base)
{
	RygelBasicManagementTestNSLookup * self;
	gboolean result = FALSE;
	RygelBasicManagementTestInitState _tmp0_;
	self = (RygelBasicManagementTestNSLookup*) base;
	_tmp0_ = ((RygelBasicManagementTest*) self)->init_state;
	switch (_tmp0_) {
		case RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED:
		{
			gchar* _tmp1_;
			RygelBasicManagementTestNSLookupResult* _tmp2_;
			gint _tmp2__length1;
			RygelBasicManagementTestNSLookupResult* _tmp3_;
			gint _tmp3__length1;
			self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL;
			_tmp1_ = g_strdup ("Failed to spawn nslookup");
			_g_free0 (self->priv->additional_info);
			self->priv->additional_info = _tmp1_;
			_tmp2_ = self->priv->results;
			_tmp2__length1 = self->priv->results_length1;
			_tmp3_ = self->priv->results;
			_tmp3__length1 = self->priv->results_length1;
			_tmp2_[_tmp3__length1 - 1].status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER;
			break;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER:
		{
			RygelBasicManagementTestNSLookupResult* _tmp4_;
			gint _tmp4__length1;
			RygelBasicManagementTestNSLookupResult* _tmp5_;
			gint _tmp5__length1;
			self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER;
			_tmp4_ = self->priv->results;
			_tmp4__length1 = self->priv->results_length1;
			_tmp5_ = self->priv->results;
			_tmp5__length1 = self->priv->results_length1;
			_tmp4_[_tmp5__length1 - 1].status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER;
			break;
		}
		default:
		{
			gdouble elapsed_msec = 0.0;
			GTimer* _tmp6_;
			guint exec_time = 0U;
			RygelBasicManagementTestNSLookupResult* _tmp7_;
			gint _tmp7__length1;
			RygelBasicManagementTestNSLookupResult* _tmp8_;
			gint _tmp8__length1;
			_tmp6_ = self->priv->timer;
			elapsed_msec = g_timer_elapsed (_tmp6_, NULL) * 1000;
			exec_time = (guint) round (elapsed_msec);
			_tmp7_ = self->priv->results;
			_tmp7__length1 = self->priv->results_length1;
			_tmp8_ = self->priv->results;
			_tmp8__length1 = self->priv->results_length1;
			_tmp7_[_tmp8__length1 - 1].execution_time = exec_time;
			break;
		}
	}
	result = RYGEL_BASIC_MANAGEMENT_TEST_CLASS (rygel_basic_management_test_ns_lookup_parent_class)->finish_iteration (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
rygel_basic_management_test_ns_lookup_real_handle_error (RygelBasicManagementTest* base,
                                                         const gchar* line)
{
	RygelBasicManagementTestNSLookup * self;
	RygelBasicManagementTestNSLookupResult* _result_ = NULL;
	RygelBasicManagementTestNSLookupResult* _tmp0_;
	gint _tmp0__length1;
	RygelBasicManagementTestNSLookupResult* _tmp1_;
	gint _tmp1__length1;
	self = (RygelBasicManagementTestNSLookup*) base;
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->results;
	_tmp0__length1 = self->priv->results_length1;
	_tmp1_ = self->priv->results;
	_tmp1__length1 = self->priv->results_length1;
	_result_ = &_tmp0_[_tmp1__length1 - 1];
	if (string_contains (line, "couldn't get address for")) {
		self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED;
		rygel_basic_management_test_set_execution_state ((RygelBasicManagementTest*) self, RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED);
		(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE;
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
_vala_array_add3 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
rygel_basic_management_test_ns_lookup_real_handle_output (RygelBasicManagementTest* base,
                                                          const gchar* line)
{
	RygelBasicManagementTestNSLookup * self;
	RygelBasicManagementTestNSLookupResult* _result_ = NULL;
	RygelBasicManagementTestNSLookupResult* _tmp0_;
	gint _tmp0__length1;
	RygelBasicManagementTestNSLookupResult* _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = (RygelBasicManagementTestNSLookup*) base;
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->results;
	_tmp0__length1 = self->priv->results_length1;
	_tmp1_ = self->priv->results;
	_tmp1__length1 = self->priv->results_length1;
	_result_ = &_tmp0_[_tmp1__length1 - 1];
	_tmp2_ = string_strip (line);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp3_);
	if (g_str_has_prefix (line, "Server:")) {
		RygelBasicManagementTestNSLookupResult* _tmp4_;
		RygelBasicManagementTestNSLookupProcessState _tmp5_;
		_tmp4_ = _result_;
		_tmp5_ = (*_tmp4_).state;
		if (_tmp5_ != RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT) {
			g_debug ("rygel-basic-management-test-nslookup.vala:303: nslookup parser: Unexpe" \
"cted 'Server:' line.\n");
		}
		(*_result_).state = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER;
	} else {
		if (g_str_has_prefix (line, "Name:")) {
			RygelBasicManagementTestNSLookupResult* _tmp6_;
			RygelBasicManagementTestNSLookupProcessState _tmp7_;
			_tmp6_ = _result_;
			_tmp7_ = (*_tmp6_).state;
			if (_tmp7_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT) {
				g_debug ("rygel-basic-management-test-nslookup.vala:308: nslookup parser: Unexpe" \
"cted 'Name:' line");
			} else {
				RygelBasicManagementTestNSLookupResult* _tmp8_;
				RygelBasicManagementTestNSLookupProcessState _tmp9_;
				_tmp8_ = _result_;
				_tmp9_ = (*_tmp8_).state;
				if (_tmp9_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER) {
					gchar* name = NULL;
					gint _tmp10_;
					gint _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp10_ = strlen ("Name:");
					_tmp11_ = _tmp10_;
					_tmp12_ = string_substring (line, (glong) _tmp11_, (glong) -1);
					_tmp13_ = _tmp12_;
					_tmp14_ = string_strip (_tmp13_);
					_tmp15_ = _tmp14_;
					_g_free0 (_tmp13_);
					name = _tmp15_;
					_tmp16_ = name;
					_tmp17_ = g_strdup (_tmp16_);
					_g_free0 ((*_result_).returned_host_name);
					(*_result_).returned_host_name = _tmp17_;
					_g_free0 (name);
				}
			}
			(*_result_).state = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME;
		} else {
			if (g_str_has_prefix (line, "Address:")) {
				RygelBasicManagementTestNSLookupResult* _tmp18_;
				RygelBasicManagementTestNSLookupProcessState _tmp19_;
				_tmp18_ = _result_;
				_tmp19_ = (*_tmp18_).state;
				if (_tmp19_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER) {
					gchar* address = NULL;
					gint _tmp20_;
					gint _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					const gchar* _tmp26_;
					gchar** _tmp27_;
					gchar** _tmp28_;
					gchar** _tmp29_;
					gint _tmp29__length1;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp20_ = strlen ("Address:");
					_tmp21_ = _tmp20_;
					_tmp22_ = string_substring (line, (glong) _tmp21_, (glong) -1);
					_tmp23_ = _tmp22_;
					_tmp24_ = string_strip (_tmp23_);
					_tmp25_ = _tmp24_;
					_g_free0 (_tmp23_);
					address = _tmp25_;
					_tmp26_ = address;
					_tmp28_ = _tmp27_ = g_strsplit (_tmp26_, "#", 2);
					_tmp29_ = _tmp28_;
					_tmp29__length1 = _vala_array_length (_tmp27_);
					_tmp30_ = _tmp29_[0];
					_tmp31_ = g_strdup (_tmp30_);
					_g_free0 ((*_result_).name_server_address);
					(*_result_).name_server_address = _tmp31_;
					_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
					self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS;
					_g_free0 (address);
				} else {
					RygelBasicManagementTestNSLookupResult* _tmp32_;
					RygelBasicManagementTestNSLookupProcessState _tmp33_;
					_tmp32_ = _result_;
					_tmp33_ = (*_tmp32_).state;
					if (_tmp33_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME) {
						gchar** _tmp34_;
						gint _tmp34__length1;
						gint _tmp35_;
						gint _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						RygelBasicManagementTestNSLookupResult* _tmp40_;
						RygelBasicManagementTestNSLookupAnswerType _tmp41_;
						_tmp34_ = (*_result_).addresses;
						_tmp34__length1 = (*_result_).addresses_length1;
						_tmp35_ = strlen ("Address:");
						_tmp36_ = _tmp35_;
						_tmp37_ = string_substring (line, (glong) _tmp36_, (glong) -1);
						_tmp38_ = _tmp37_;
						_tmp39_ = string_strip (_tmp38_);
						_vala_array_add3 (&(*_result_).addresses, &(*_result_).addresses_length1, &(*_result_)._addresses_size_, _tmp39_);
						_g_free0 (_tmp38_);
						(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS;
						_tmp40_ = _result_;
						_tmp41_ = (*_tmp40_).answer_type;
						if (_tmp41_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE) {
							(*_result_).answer_type = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE;
						}
					} else {
						g_debug ("rygel-basic-management-test-nslookup.vala:326: nslookup parser: Unexpe" \
"cted 'Address:' line");
					}
				}
			} else {
				if (g_str_has_prefix (line, "Non-authoritative answer:")) {
					(*_result_).answer_type = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE;
				} else {
					if (string_contains (line, "server can't find")) {
						(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED;
					} else {
						if (string_contains (line, "couldn't get address for")) {
							self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED;
							(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE;
							rygel_basic_management_test_set_execution_state ((RygelBasicManagementTest*) self, RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED);
						} else {
							if (string_contains (line, "no servers could be reached")) {
								(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE;
							}
						}
					}
				}
			}
		}
	}
}

void
rygel_basic_management_test_ns_lookup_get_results (RygelBasicManagementTestNSLookup* self,
                                                   gchar* * status,
                                                   gchar* * additional_info,
                                                   guint* success_count,
                                                   gchar* * result_string)
{
	gchar* _vala_status = NULL;
	gchar* _vala_additional_info = NULL;
	guint _vala_success_count = 0U;
	gchar* _vala_result_string = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	RygelBasicManagementTestNSLookupResult* _tmp1_;
	gint _tmp1__length1;
	GString* _tmp9_;
	GString* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	RygelBasicManagementTestNSLookupGenericStatus _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	_vala_success_count = (guint) 0;
	_tmp0_ = g_string_new (RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HEADER);
	builder = _tmp0_;
	_tmp1_ = self->priv->results;
	_tmp1__length1 = self->priv->results_length1;
	{
		RygelBasicManagementTestNSLookupResult* result_collection = NULL;
		gint result_collection_length1 = 0;
		gint _result_collection_size_ = 0;
		gint result_it = 0;
		result_collection = _tmp1_;
		result_collection_length1 = _tmp1__length1;
		for (result_it = 0; result_it < _tmp1__length1; result_it = result_it + 1) {
			RygelBasicManagementTestNSLookupResult _tmp2_ = {0};
			RygelBasicManagementTestNSLookupResult _result_ = {0};
			rygel_basic_management_test_ns_lookup_result_copy (&result_collection[result_it], &_tmp2_);
			_result_ = _tmp2_;
			{
				GString* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				RygelBasicManagementTestNSLookupResult _tmp6_;
				RygelBasicManagementTestNSLookupResultStatus _tmp7_;
				_tmp3_ = builder;
				_tmp4_ = rygel_basic_management_test_ns_lookup_result_to_xml_fragment (&_result_);
				_tmp5_ = _tmp4_;
				g_string_append (_tmp3_, _tmp5_);
				_g_free0 (_tmp5_);
				_tmp6_ = _result_;
				_tmp7_ = _tmp6_.status;
				if (_tmp7_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS) {
					guint _tmp8_;
					_tmp8_ = _vala_success_count;
					_vala_success_count = _tmp8_ + 1;
				}
				rygel_basic_management_test_ns_lookup_result_destroy (&_result_);
			}
		}
	}
	_tmp9_ = builder;
	g_string_append (_tmp9_, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_FOOTER);
	_tmp10_ = builder;
	_tmp11_ = _tmp10_->str;
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (_vala_result_string);
	_vala_result_string = _tmp12_;
	_tmp13_ = self->priv->generic_status;
	_tmp14_ = rygel_basic_management_test_ns_lookup_generic_status_to_string (_tmp13_);
	_g_free0 (_vala_status);
	_vala_status = _tmp14_;
	_tmp15_ = self->priv->additional_info;
	_tmp16_ = g_strdup (_tmp15_);
	_g_free0 (_vala_additional_info);
	_vala_additional_info = _tmp16_;
	_g_string_free0 (builder);
	if (status) {
		*status = _vala_status;
	} else {
		_g_free0 (_vala_status);
	}
	if (additional_info) {
		*additional_info = _vala_additional_info;
	} else {
		_g_free0 (_vala_additional_info);
	}
	if (success_count) {
		*success_count = _vala_success_count;
	}
	if (result_string) {
		*result_string = _vala_result_string;
	} else {
		_g_free0 (_vala_result_string);
	}
}

static const gchar*
rygel_basic_management_test_ns_lookup_get_host_name (RygelBasicManagementTestNSLookup* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_host_name;
	result = _tmp0_;
	return result;
}

static void
rygel_basic_management_test_ns_lookup_set_host_name (RygelBasicManagementTestNSLookup* self,
                                                     const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_basic_management_test_ns_lookup_get_host_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_host_name);
		self->priv->_host_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_ns_lookup_properties[RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HOST_NAME_PROPERTY]);
	}
}

static const gchar*
rygel_basic_management_test_ns_lookup_get_name_server (RygelBasicManagementTestNSLookup* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name_server;
	result = _tmp0_;
	return result;
}

static void
rygel_basic_management_test_ns_lookup_set_name_server (RygelBasicManagementTestNSLookup* self,
                                                       const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_basic_management_test_ns_lookup_get_name_server (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name_server);
		self->priv->_name_server = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_ns_lookup_properties[RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NAME_SERVER_PROPERTY]);
	}
}

static guint
rygel_basic_management_test_ns_lookup_get_interval_time_out (RygelBasicManagementTestNSLookup* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_interval_time_out;
	return result;
}

static void
rygel_basic_management_test_ns_lookup_set_interval_time_out (RygelBasicManagementTestNSLookup* self,
                                                             guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_interval_time_out = value;
	if (self->priv->_interval_time_out == ((guint) 0)) {
		self->priv->_interval_time_out = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_INTERVAL_TIMEOUT;
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_ns_lookup_properties[RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_INTERVAL_TIME_OUT_PROPERTY]);
}

static guint
rygel_basic_management_test_ns_lookup_get_repetitions (RygelBasicManagementTestNSLookup* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_repetitions;
	return result;
}

static void
rygel_basic_management_test_ns_lookup_set_repetitions (RygelBasicManagementTestNSLookup* self,
                                                       guint value)
{
	g_return_if_fail (self != NULL);
	((RygelBasicManagementTest*) self)->iterations = (guint) 1;
	self->priv->_repetitions = value;
	if (self->priv->_repetitions == ((guint) 0)) {
		self->priv->_repetitions = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_REPETITIONS;
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_ns_lookup_properties[RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_REPETITIONS_PROPERTY]);
}

static const gchar*
rygel_basic_management_test_ns_lookup_real_get_method_type (RygelBasicManagementTest* base)
{
	const gchar* result;
	RygelBasicManagementTestNSLookup* self;
	self = (RygelBasicManagementTestNSLookup*) base;
	result = "NSLookup";
	return result;
}

static const gchar*
rygel_basic_management_test_ns_lookup_real_get_results_type (RygelBasicManagementTest* base)
{
	const gchar* result;
	RygelBasicManagementTestNSLookup* self;
	self = (RygelBasicManagementTestNSLookup*) base;
	result = "GetNSLookupResult";
	return result;
}

static gchar*
rygel_basic_management_test_ns_lookup_result_get_addresses_csv (RygelBasicManagementTestNSLookupResult *self)
{
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	GString* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = (*self).addresses;
	_tmp1__length1 = (*self).addresses_length1;
	{
		gchar** address_collection = NULL;
		gint address_collection_length1 = 0;
		gint _address_collection_size_ = 0;
		gint address_it = 0;
		address_collection = _tmp1_;
		address_collection_length1 = _tmp1__length1;
		for (address_it = 0; address_it < _tmp1__length1; address_it = address_it + 1) {
			gchar* _tmp2_;
			gchar* address = NULL;
			_tmp2_ = g_strdup (address_collection[address_it]);
			address = _tmp2_;
			{
				GString* _tmp3_;
				GString* _tmp5_;
				const gchar* _tmp6_;
				_tmp3_ = builder;
				if (_tmp3_->len != ((gssize) 0)) {
					GString* _tmp4_;
					_tmp4_ = builder;
					g_string_append (_tmp4_, ",");
				}
				_tmp5_ = builder;
				_tmp6_ = address;
				g_string_append (_tmp5_, _tmp6_);
				_g_free0 (address);
			}
		}
	}
	_tmp7_ = builder;
	_tmp8_ = _tmp7_->str;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	_g_string_free0 (builder);
	return result;
}

static gchar*
rygel_basic_management_test_ns_lookup_result_to_xml_fragment (RygelBasicManagementTestNSLookupResult *self)
{
	gchar* result = NULL;
	RygelBasicManagementTestNSLookupResultStatus _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	RygelBasicManagementTestNSLookupAnswerType _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	_tmp0_ = (*self).status;
	_tmp1_ = rygel_basic_management_test_ns_lookup_result_status_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (*self).answer_type;
	_tmp4_ = rygel_basic_management_test_ns_lookup_answer_type_to_string (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = (*self).returned_host_name;
	_tmp7_ = rygel_basic_management_test_ns_lookup_result_get_addresses_csv (&(*self));
	_tmp8_ = _tmp7_;
	_tmp9_ = (*self).name_server_address;
	_tmp10_ = g_strdup_printf ("<Result>\n" "<Status>%s</Status>\n" "<AnswerType>%s</AnswerType>\n" "<HostNameReturned>%s</HostNameReturned>\n" "<IPAddresses>%s</IPAddresses>\n" "<DNSServerIP>%s</DNSServerIP>\n" "<ResponseTime>%u</ResponseTime>\n" "</Result>\n", _tmp2_, _tmp5_, _tmp6_, _tmp8_, _tmp9_, (*self).execution_time);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp11_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

static void
rygel_basic_management_test_ns_lookup_result_copy (const RygelBasicManagementTestNSLookupResult* self,
                                                   RygelBasicManagementTestNSLookupResult* dest)
{
	RygelBasicManagementTestNSLookupProcessState _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	RygelBasicManagementTestNSLookupResultStatus _tmp7_;
	RygelBasicManagementTestNSLookupAnswerType _tmp8_;
	_tmp0_ = (*self).state;
	(*dest).state = _tmp0_;
	_tmp1_ = (*self).name_server_address;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).name_server_address);
	(*dest).name_server_address = _tmp2_;
	_tmp3_ = (*self).returned_host_name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).returned_host_name);
	(*dest).returned_host_name = _tmp4_;
	_tmp5_ = (*self).addresses;
	_tmp5__length1 = (*self).addresses_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup1 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	(*dest).addresses = (_vala_array_free ((*dest).addresses, (*dest).addresses_length1, (GDestroyNotify) g_free), NULL);
	(*dest).addresses = _tmp6_;
	(*dest).addresses_length1 = _tmp6__length1;
	(*dest)._addresses_size_ = (*dest).addresses_length1;
	_tmp7_ = (*self).status;
	(*dest).status = _tmp7_;
	_tmp8_ = (*self).answer_type;
	(*dest).answer_type = _tmp8_;
	(*dest).execution_time = (*self).execution_time;
}

static void
rygel_basic_management_test_ns_lookup_result_destroy (RygelBasicManagementTestNSLookupResult* self)
{
	_g_free0 ((*self).name_server_address);
	_g_free0 ((*self).returned_host_name);
	(*self).addresses = (_vala_array_free ((*self).addresses, (*self).addresses_length1, (GDestroyNotify) g_free), NULL);
}

static RygelBasicManagementTestNSLookupResult*
rygel_basic_management_test_ns_lookup_result_dup (const RygelBasicManagementTestNSLookupResult* self)
{
	RygelBasicManagementTestNSLookupResult* dup;
	dup = g_new0 (RygelBasicManagementTestNSLookupResult, 1);
	rygel_basic_management_test_ns_lookup_result_copy (self, dup);
	return dup;
}

static void
rygel_basic_management_test_ns_lookup_result_free (RygelBasicManagementTestNSLookupResult* self)
{
	rygel_basic_management_test_ns_lookup_result_destroy (self);
	g_free (self);
}

static GType
rygel_basic_management_test_ns_lookup_result_get_type (void)
{
	static volatile gsize rygel_basic_management_test_ns_lookup_result_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_result_type_id__volatile)) {
		GType rygel_basic_management_test_ns_lookup_result_type_id;
		rygel_basic_management_test_ns_lookup_result_type_id = g_boxed_type_register_static ("RygelBasicManagementTestNSLookupResult", (GBoxedCopyFunc) rygel_basic_management_test_ns_lookup_result_dup, (GBoxedFreeFunc) rygel_basic_management_test_ns_lookup_result_free);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_result_type_id__volatile, rygel_basic_management_test_ns_lookup_result_type_id);
	}
	return rygel_basic_management_test_ns_lookup_result_type_id__volatile;
}

static void
rygel_basic_management_test_ns_lookup_class_init (RygelBasicManagementTestNSLookupClass * klass,
                                                  gpointer klass_data)
{
	rygel_basic_management_test_ns_lookup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelBasicManagementTestNSLookup_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_basic_management_test_ns_lookup_real_constructed;
	((RygelBasicManagementTestClass *) klass)->init_iteration = (void (*) (RygelBasicManagementTest*)) rygel_basic_management_test_ns_lookup_real_init_iteration;
	((RygelBasicManagementTestClass *) klass)->finish_iteration = (gboolean (*) (RygelBasicManagementTest*)) rygel_basic_management_test_ns_lookup_real_finish_iteration;
	((RygelBasicManagementTestClass *) klass)->handle_error = (void (*) (RygelBasicManagementTest*, const gchar*)) rygel_basic_management_test_ns_lookup_real_handle_error;
	((RygelBasicManagementTestClass *) klass)->handle_output = (void (*) (RygelBasicManagementTest*, const gchar*)) rygel_basic_management_test_ns_lookup_real_handle_output;
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_method_type = rygel_basic_management_test_ns_lookup_real_get_method_type;
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_results_type = rygel_basic_management_test_ns_lookup_real_get_results_type;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_basic_management_test_ns_lookup_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_basic_management_test_ns_lookup_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_basic_management_test_ns_lookup_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HOST_NAME_PROPERTY, rygel_basic_management_test_ns_lookup_properties[RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HOST_NAME_PROPERTY] = g_param_spec_string ("host-name", "host-name", "host-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NAME_SERVER_PROPERTY, rygel_basic_management_test_ns_lookup_properties[RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NAME_SERVER_PROPERTY] = g_param_spec_string ("name-server", "name-server", "name-server", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_INTERVAL_TIME_OUT_PROPERTY, rygel_basic_management_test_ns_lookup_properties[RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_INTERVAL_TIME_OUT_PROPERTY] = g_param_spec_uint ("interval-time-out", "interval-time-out", "interval-time-out", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_REPETITIONS_PROPERTY, rygel_basic_management_test_ns_lookup_properties[RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_REPETITIONS_PROPERTY] = g_param_spec_uint ("repetitions", "repetitions", "repetitions", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_METHOD_TYPE_PROPERTY, rygel_basic_management_test_ns_lookup_properties[RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_METHOD_TYPE_PROPERTY] = g_param_spec_string ("method-type", "method-type", "method-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULTS_TYPE_PROPERTY, rygel_basic_management_test_ns_lookup_properties[RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULTS_TYPE_PROPERTY] = g_param_spec_string ("results-type", "results-type", "results-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rygel_basic_management_test_ns_lookup_instance_init (RygelBasicManagementTestNSLookup * self,
                                                     gpointer klass)
{
	gchar* _tmp0_;
	GTimer* _tmp1_;
	self->priv = rygel_basic_management_test_ns_lookup_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_host_name = _tmp0_;
	self->priv->_name_server = NULL;
	self->priv->_interval_time_out = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_INTERVAL_TIMEOUT;
	self->priv->_repetitions = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_REPETITIONS;
	_tmp1_ = g_timer_new ();
	self->priv->timer = _tmp1_;
}

static void
rygel_basic_management_test_ns_lookup_finalize (GObject * obj)
{
	RygelBasicManagementTestNSLookup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup);
	_g_free0 (self->priv->_host_name);
	_g_free0 (self->priv->_name_server);
	self->priv->results = (_vala_RygelBasicManagementTestNSLookupResult_array_free (self->priv->results, self->priv->results_length1), NULL);
	_g_free0 (self->priv->additional_info);
	_g_timer_destroy0 (self->priv->timer);
	G_OBJECT_CLASS (rygel_basic_management_test_ns_lookup_parent_class)->finalize (obj);
}

GType
rygel_basic_management_test_ns_lookup_get_type (void)
{
	static volatile gsize rygel_basic_management_test_ns_lookup_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBasicManagementTestNSLookupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_basic_management_test_ns_lookup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBasicManagementTestNSLookup), 0, (GInstanceInitFunc) rygel_basic_management_test_ns_lookup_instance_init, NULL };
		GType rygel_basic_management_test_ns_lookup_type_id;
		rygel_basic_management_test_ns_lookup_type_id = g_type_register_static (RYGEL_TYPE_BASIC_MANAGEMENT_TEST, "RygelBasicManagementTestNSLookup", &g_define_type_info, 0);
		RygelBasicManagementTestNSLookup_private_offset = g_type_add_instance_private (rygel_basic_management_test_ns_lookup_type_id, sizeof (RygelBasicManagementTestNSLookupPrivate));
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_type_id__volatile, rygel_basic_management_test_ns_lookup_type_id);
	}
	return rygel_basic_management_test_ns_lookup_type_id__volatile;
}

static void
_vala_rygel_basic_management_test_ns_lookup_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	RygelBasicManagementTestNSLookup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HOST_NAME_PROPERTY:
		g_value_set_string (value, rygel_basic_management_test_ns_lookup_get_host_name (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NAME_SERVER_PROPERTY:
		g_value_set_string (value, rygel_basic_management_test_ns_lookup_get_name_server (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_INTERVAL_TIME_OUT_PROPERTY:
		g_value_set_uint (value, rygel_basic_management_test_ns_lookup_get_interval_time_out (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_REPETITIONS_PROPERTY:
		g_value_set_uint (value, rygel_basic_management_test_ns_lookup_get_repetitions (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_METHOD_TYPE_PROPERTY:
		g_value_set_string (value, rygel_basic_management_test_get_method_type ((RygelBasicManagementTest*) self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULTS_TYPE_PROPERTY:
		g_value_set_string (value, rygel_basic_management_test_get_results_type ((RygelBasicManagementTest*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_basic_management_test_ns_lookup_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	RygelBasicManagementTestNSLookup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HOST_NAME_PROPERTY:
		rygel_basic_management_test_ns_lookup_set_host_name (self, g_value_get_string (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NAME_SERVER_PROPERTY:
		rygel_basic_management_test_ns_lookup_set_name_server (self, g_value_get_string (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_INTERVAL_TIME_OUT_PROPERTY:
		rygel_basic_management_test_ns_lookup_set_interval_time_out (self, g_value_get_uint (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_REPETITIONS_PROPERTY:
		rygel_basic_management_test_ns_lookup_set_repetitions (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

