/* rygel-tracker-selection-query.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-tracker-selection-query.vala, do not modify */

/*
 * Copyright (C) 2010-2012 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rygel-core.h>

#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;
typedef struct _RygelTrackerSelectionQueryPrivate RygelTrackerSelectionQueryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
typedef struct _RygelTrackerSelectionQueryExecuteData RygelTrackerSelectionQueryExecuteData;

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerSelectionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerSelectionQueryPrivate * priv;
	GeeArrayList* variables;
	GeeArrayList* filters;
	gchar* order_by;
	gint offset;
	gint max_count;
	TrackerSparqlCursor* result;
};

struct _RygelTrackerSelectionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerSelectionQueryPrivate {
	gchar* uri_filter;
};

struct _RygelTrackerSelectionQueryExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelTrackerSelectionQuery* self;
	TrackerSparqlConnection* resources;
	gchar* str;
	gchar* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlCursor* _tmp3_;
	GError * _inner_error_;
};

static gint RygelTrackerSelectionQuery_private_offset;
static gpointer rygel_tracker_selection_query_parent_class = NULL;

gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value,
                                    gpointer v_object);
void rygel_tracker_value_take_query (GValue* value,
                                     gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE "?item"
#define RYGEL_TRACKER_SELECTION_QUERY_SHARED_FILTER "(!BOUND(nmm:uPnPShared(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ")) ||" " nmm:uPnPShared(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ") = true) && " "(BOUND(nie:url(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ")))"
#define RYGEL_TRACKER_SELECTION_QUERY_STRICT_SHARED_FILTER "(BOUND(nmm:dlnaProfile(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ")))"
#define RYGEL_TRACKER_SELECTION_QUERY_AVAILABLE_FILTER "(tracker:available(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ") = true)"
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables,
                                                               RygelTrackerQueryTriplets* triplets,
                                                               GeeArrayList* filters,
                                                               const gchar* order_by,
                                                               gint offset,
                                                               gint max_count);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type,
                                                                     GeeArrayList* variables,
                                                                     RygelTrackerQueryTriplets* triplets,
                                                                     GeeArrayList* filters,
                                                                     const gchar* order_by,
                                                                     gint offset,
                                                                     gint max_count);
RygelTrackerQuery* rygel_tracker_query_construct (GType object_type,
                                                  RygelTrackerQueryTriplets* triplets);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new_clone (RygelTrackerSelectionQuery* query);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct_clone (GType object_type,
                                                                           RygelTrackerSelectionQuery* query);
static GeeArrayList* rygel_tracker_selection_query_copy_str_list (GeeList* str_list);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new_clone (RygelTrackerQueryTriplets* triplets);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct_clone (GType object_type,
                                                                         RygelTrackerQueryTriplets* triplets);
static void rygel_tracker_selection_query_real_execute_data_free (gpointer _data);
static void rygel_tracker_selection_query_real_execute_async_ready_wrapper (GObject *source_object,
                                                                     GAsyncResult *res,
                                                                     void *user_data);
static void rygel_tracker_selection_query_real_execute (RygelTrackerQuery* base,
                                                 TrackerSparqlConnection* resources,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean rygel_tracker_selection_query_real_execute_co (RygelTrackerSelectionQueryExecuteData* _data_);
gchar* rygel_tracker_query_to_string (RygelTrackerQuery* self);
static void rygel_tracker_selection_query_execute_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static gchar* rygel_tracker_selection_query_real_to_string (RygelTrackerQuery* base);
static void rygel_tracker_selection_query_finalize (RygelTrackerQuery * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
rygel_tracker_selection_query_get_instance_private (RygelTrackerSelectionQuery* self)
{
	return G_STRUCT_MEMBER_P (self, RygelTrackerSelectionQuery_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally10;
	__catch10_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

RygelTrackerSelectionQuery*
rygel_tracker_selection_query_construct (GType object_type,
                                         GeeArrayList* variables,
                                         RygelTrackerQueryTriplets* triplets,
                                         GeeArrayList* filters,
                                         const gchar* order_by,
                                         gint offset,
                                         gint max_count)
{
	RygelTrackerSelectionQuery* self = NULL;
	GeeArrayList* _tmp2_;
	gchar* _tmp3_;
	GeeArrayList* uris = NULL;
	gchar** uri_filters = NULL;
	gchar** _tmp4_;
	gint uri_filters_length1;
	gint _uri_filters_size_;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp5_;
	GFile* home_dir = NULL;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	const gchar* pictures_dir = NULL;
	const gchar* _tmp13_;
	const gchar* videos_dir = NULL;
	const gchar* _tmp14_;
	const gchar* music_dir = NULL;
	const gchar* _tmp15_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (variables != NULL, NULL);
	g_return_val_if_fail (triplets != NULL, NULL);
	self = (RygelTrackerSelectionQuery*) rygel_tracker_query_construct (object_type, triplets);
	if (filters != NULL) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (filters);
		_g_object_unref0 (self->filters);
		self->filters = _tmp0_;
	} else {
		GeeArrayList* _tmp1_;
		_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (self->filters);
		self->filters = _tmp1_;
	}
	_tmp2_ = _g_object_ref0 (variables);
	_g_object_unref0 (self->variables);
	self->variables = _tmp2_;
	_tmp3_ = g_strdup (order_by);
	_g_free0 (self->order_by);
	self->order_by = _tmp3_;
	self->offset = offset;
	self->max_count = max_count;
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	uri_filters = _tmp4_;
	uri_filters_length1 = 0;
	_uri_filters_size_ = uri_filters_length1;
	_tmp5_ = rygel_meta_config_get_default ();
	config = _tmp5_;
	{
		GeeArrayList* _tmp6_ = NULL;
		RygelMetaConfig* _tmp7_;
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
		_tmp7_ = config;
		_tmp8_ = rygel_configuration_get_string_list ((RygelConfiguration*) _tmp7_, "Tracker", "only-export-from", &_inner_error_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
		_tmp9_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (uris);
		uris = _tmp9_;
		_g_object_unref0 (_tmp6_);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* _error_ = NULL;
		GeeArrayList* _tmp10_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (uris);
		uris = _tmp10_;
		_g_error_free0 (_error_);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (config);
		uri_filters = (_vala_array_free (uri_filters, uri_filters_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (uris);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp11_ = g_get_home_dir ();
	_tmp12_ = g_file_new_for_path (_tmp11_);
	home_dir = _tmp12_;
	_tmp13_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	pictures_dir = _tmp13_;
	_tmp14_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	videos_dir = _tmp14_;
	_tmp15_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	music_dir = _tmp15_;
	{
		GeeArrayList* _uri_list = NULL;
		GeeArrayList* _tmp16_;
		GeeArrayList* _tmp17_;
		gint _uri_size = 0;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _uri_index = 0;
		_tmp16_ = uris;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		_uri_list = _tmp17_;
		_tmp18_ = _uri_list;
		_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_uri_size = _tmp20_;
		_uri_index = -1;
		while (TRUE) {
			gchar* uri = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			GFile* file = NULL;
			const gchar* _tmp23_;
			GFile* _tmp24_;
			GFile* _tmp25_;
			GFile* _tmp26_;
			_uri_index = _uri_index + 1;
			if (!(_uri_index < _uri_size)) {
				break;
			}
			_tmp21_ = _uri_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _uri_index);
			uri = (gchar*) _tmp22_;
			_tmp23_ = uri;
			_tmp24_ = g_file_new_for_commandline_arg (_tmp23_);
			file = _tmp24_;
			_tmp25_ = file;
			_tmp26_ = home_dir;
			if (!g_file_equal (_tmp25_, _tmp26_)) {
				gchar* actual_uri = NULL;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp33_;
				const gchar* _tmp37_;
				gboolean _tmp41_ = FALSE;
				gboolean _tmp42_ = FALSE;
				const gchar* _tmp43_;
				const gchar* _tmp46_;
				GFile* _tmp47_;
				GFile* _tmp48_;
				GFile* _tmp49_;
				gchar** _tmp50_;
				gint _tmp50__length1;
				GFile* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp27_ = uri;
				_tmp28_ = g_strdup (_tmp27_);
				actual_uri = _tmp28_;
				_tmp29_ = pictures_dir;
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					_tmp30_ = actual_uri;
					_tmp31_ = pictures_dir;
					_tmp32_ = string_replace (_tmp30_, "@PICTURES@", _tmp31_);
					_g_free0 (actual_uri);
					actual_uri = _tmp32_;
				}
				_tmp33_ = videos_dir;
				if (_tmp33_ != NULL) {
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp34_ = actual_uri;
					_tmp35_ = videos_dir;
					_tmp36_ = string_replace (_tmp34_, "@VIDEOS@", _tmp35_);
					_g_free0 (actual_uri);
					actual_uri = _tmp36_;
				}
				_tmp37_ = music_dir;
				if (_tmp37_ != NULL) {
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					gchar* _tmp40_;
					_tmp38_ = actual_uri;
					_tmp39_ = music_dir;
					_tmp40_ = string_replace (_tmp38_, "@MUSIC@", _tmp39_);
					_g_free0 (actual_uri);
					actual_uri = _tmp40_;
				}
				_tmp43_ = actual_uri;
				if (string_contains (_tmp43_, "@PICTURES@")) {
					_tmp42_ = TRUE;
				} else {
					const gchar* _tmp44_;
					_tmp44_ = actual_uri;
					_tmp42_ = string_contains (_tmp44_, "@VIDEOS@");
				}
				if (_tmp42_) {
					_tmp41_ = TRUE;
				} else {
					const gchar* _tmp45_;
					_tmp45_ = actual_uri;
					_tmp41_ = string_contains (_tmp45_, "@MUSIC@");
				}
				if (_tmp41_) {
					_g_free0 (actual_uri);
					_g_object_unref0 (file);
					_g_free0 (uri);
					continue;
				}
				_tmp46_ = actual_uri;
				_tmp47_ = g_file_new_for_commandline_arg (_tmp46_);
				_g_object_unref0 (file);
				file = _tmp47_;
				_tmp48_ = file;
				_tmp49_ = home_dir;
				if (g_file_equal (_tmp48_, _tmp49_)) {
					_g_free0 (actual_uri);
					_g_object_unref0 (file);
					_g_free0 (uri);
					continue;
				}
				_tmp50_ = uri_filters;
				_tmp50__length1 = uri_filters_length1;
				_tmp51_ = file;
				_tmp52_ = g_file_get_uri (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = g_strdup_printf ("tracker:uri-is-descendant(\"%s\", nie:url(%s))", _tmp53_, RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE);
				_vala_array_add1 (&uri_filters, &uri_filters_length1, &_uri_filters_size_, _tmp54_);
				_g_free0 (_tmp53_);
				_g_free0 (actual_uri);
			}
			_g_object_unref0 (file);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_list);
	}
	_tmp55_ = uri_filters;
	_tmp55__length1 = uri_filters_length1;
	if (_tmp55__length1 != 0) {
		gchar** _tmp56_;
		gint _tmp56__length1;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		_tmp56_ = uri_filters;
		_tmp56__length1 = uri_filters_length1;
		_tmp57_ = _vala_g_strjoinv ("||", _tmp56_, (gint) _tmp56__length1);
		_tmp58_ = _tmp57_;
		_tmp59_ = g_strdup_printf ("(%s)", _tmp58_);
		_g_free0 (self->priv->uri_filter);
		self->priv->uri_filter = _tmp59_;
		_g_free0 (_tmp58_);
	} else {
		_g_free0 (self->priv->uri_filter);
		self->priv->uri_filter = NULL;
	}
	_g_object_unref0 (home_dir);
	_g_object_unref0 (config);
	uri_filters = (_vala_array_free (uri_filters, uri_filters_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (uris);
	return self;
}

RygelTrackerSelectionQuery*
rygel_tracker_selection_query_new (GeeArrayList* variables,
                                   RygelTrackerQueryTriplets* triplets,
                                   GeeArrayList* filters,
                                   const gchar* order_by,
                                   gint offset,
                                   gint max_count)
{
	return rygel_tracker_selection_query_construct (RYGEL_TRACKER_TYPE_SELECTION_QUERY, variables, triplets, filters, order_by, offset, max_count);
}

RygelTrackerSelectionQuery*
rygel_tracker_selection_query_construct_clone (GType object_type,
                                               RygelTrackerSelectionQuery* query)
{
	RygelTrackerSelectionQuery* self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	RygelTrackerQueryTriplets* _tmp3_;
	RygelTrackerQueryTriplets* _tmp4_;
	RygelTrackerQueryTriplets* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	const gchar* _tmp9_;
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = query->variables;
	_tmp1_ = rygel_tracker_selection_query_copy_str_list ((GeeList*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ((RygelTrackerQuery*) query)->triplets;
	_tmp4_ = rygel_tracker_query_triplets_new_clone (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = query->filters;
	_tmp7_ = rygel_tracker_selection_query_copy_str_list ((GeeList*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = query->order_by;
	self = (RygelTrackerSelectionQuery*) rygel_tracker_selection_query_construct (object_type, _tmp2_, _tmp5_, _tmp8_, _tmp9_, query->offset, query->max_count);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp2_);
	return self;
}

RygelTrackerSelectionQuery*
rygel_tracker_selection_query_new_clone (RygelTrackerSelectionQuery* query)
{
	return rygel_tracker_selection_query_construct_clone (RYGEL_TRACKER_TYPE_SELECTION_QUERY, query);
}

static void
rygel_tracker_selection_query_real_execute_data_free (gpointer _data)
{
	RygelTrackerSelectionQueryExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->resources);
	_rygel_tracker_query_unref0 (_data_->self);
	g_slice_free (RygelTrackerSelectionQueryExecuteData, _data_);
}

static void
rygel_tracker_selection_query_real_execute_async_ready_wrapper (GObject *source_object,
                                                                GAsyncResult *res,
                                                                void *user_data)
{
	RygelTrackerSelectionQueryExecuteData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static gpointer
_rygel_tracker_query_ref0 (gpointer self)
{
	return self ? rygel_tracker_query_ref (self) : NULL;
}

static void
rygel_tracker_selection_query_real_execute (RygelTrackerQuery* base,
                                            TrackerSparqlConnection* resources,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	RygelTrackerSelectionQuery * self;
	RygelTrackerSelectionQueryExecuteData* _data_;
	RygelTrackerSelectionQuery* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	self = (RygelTrackerSelectionQuery*) base;
	_data_ = g_slice_new0 (RygelTrackerSelectionQueryExecuteData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, NULL, rygel_tracker_selection_query_real_execute_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_selection_query_real_execute_data_free);
	_tmp0_ = _rygel_tracker_query_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (resources);
	_g_object_unref0 (_data_->resources);
	_data_->resources = _tmp1_;
	rygel_tracker_selection_query_real_execute_co (_data_);
}

static void
rygel_tracker_selection_query_real_execute_finish (RygelTrackerQuery* base,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	RygelTrackerSelectionQueryExecuteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_tracker_selection_query_execute_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	RygelTrackerSelectionQueryExecuteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_tracker_selection_query_real_execute_co (_data_);
}

static gboolean
rygel_tracker_selection_query_real_execute_co (RygelTrackerSelectionQueryExecuteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_tracker_query_to_string ((RygelTrackerQuery*) _data_->self);
	_data_->str = _data_->_tmp0_;
	g_debug ("rygel-tracker-selection-query.vala:148: Executing SPARQL query: %s", _data_->str);
	_data_->_state_ = 1;
	tracker_sparql_connection_query_async (_data_->resources, _data_->str, NULL, rygel_tracker_selection_query_execute_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = tracker_sparql_connection_query_finish (_data_->resources, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp1_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_free0 (_data_->str);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->_tmp1_;
	_data_->_tmp1_ = NULL;
	_g_object_unref0 (_data_->self->result);
	_data_->self->result = _data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp1_);
	_g_free0 (_data_->str);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
rygel_tracker_selection_query_real_to_string (RygelTrackerQuery* base)
{
	RygelTrackerSelectionQuery * self;
	gchar* result = NULL;
	gchar* query = NULL;
	gchar* _tmp0_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GeeArrayList* filters = NULL;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	const gchar* _tmp23_;
	gint _tmp25_;
	gint _tmp26_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	const gchar* _tmp45_;
	GError * _inner_error_ = NULL;
	self = (RygelTrackerSelectionQuery*) base;
	_tmp0_ = g_strdup ("SELECT ");
	query = _tmp0_;
	{
		GeeArrayList* _variable_list = NULL;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _variable_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _variable_index = 0;
		_tmp1_ = self->variables;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_variable_list = _tmp2_;
		_tmp3_ = _variable_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_variable_size = _tmp5_;
		_variable_index = -1;
		while (TRUE) {
			gchar* variable = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_variable_index = _variable_index + 1;
			if (!(_variable_index < _variable_size)) {
				break;
			}
			_tmp6_ = _variable_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _variable_index);
			variable = (gchar*) _tmp7_;
			_tmp8_ = query;
			_tmp9_ = variable;
			_tmp10_ = g_strconcat (" ", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strconcat (_tmp8_, _tmp11_, NULL);
			_g_free0 (query);
			query = _tmp12_;
			_g_free0 (_tmp11_);
			_g_free0 (variable);
		}
		_g_object_unref0 (_variable_list);
	}
	_tmp13_ = query;
	_tmp14_ = RYGEL_TRACKER_QUERY_CLASS (rygel_tracker_selection_query_parent_class)->to_string (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery));
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (" WHERE { ", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp13_, _tmp17_, NULL);
	_g_free0 (query);
	query = _tmp18_;
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_tmp19_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	filters = _tmp19_;
	_tmp20_ = self->filters;
	gee_array_list_add_all (filters, (GeeCollection*) _tmp20_);
	gee_abstract_collection_add ((GeeAbstractCollection*) filters, RYGEL_TRACKER_SELECTION_QUERY_SHARED_FILTER);
	gee_abstract_collection_add ((GeeAbstractCollection*) filters, RYGEL_TRACKER_SELECTION_QUERY_AVAILABLE_FILTER);
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp21_;
		gboolean _tmp22_ = FALSE;
		_tmp21_ = rygel_meta_config_get_default ();
		config = _tmp21_;
		_tmp22_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "Tracker", "strict-sharing", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch11_g_error;
		}
		if (_tmp22_) {
			gee_abstract_collection_add ((GeeAbstractCollection*) filters, RYGEL_TRACKER_SELECTION_QUERY_STRICT_SHARED_FILTER);
		}
		_g_object_unref0 (config);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (filters);
		_g_free0 (query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp23_ = self->priv->uri_filter;
	if (_tmp23_ != NULL) {
		const gchar* _tmp24_;
		_tmp24_ = self->priv->uri_filter;
		gee_abstract_collection_add ((GeeAbstractCollection*) filters, _tmp24_);
	}
	_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) filters);
	_tmp26_ = _tmp25_;
	if (_tmp26_ > 0) {
		const gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp27_ = query;
		_tmp28_ = g_strconcat (_tmp27_, " FILTER (", NULL);
		_g_free0 (query);
		query = _tmp28_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp29_ = FALSE;
				_tmp29_ = TRUE;
				while (TRUE) {
					gint _tmp31_;
					gint _tmp32_;
					const gchar* _tmp33_;
					gpointer _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					if (!_tmp29_) {
						gint _tmp30_;
						_tmp30_ = i;
						i = _tmp30_ + 1;
					}
					_tmp29_ = FALSE;
					_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) filters);
					_tmp32_ = _tmp31_;
					if (!(i < _tmp32_)) {
						break;
					}
					_tmp33_ = query;
					_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) filters, i);
					_tmp35_ = (gchar*) _tmp34_;
					_tmp36_ = g_strconcat (_tmp33_, _tmp35_, NULL);
					_g_free0 (query);
					query = _tmp36_;
					_g_free0 (_tmp35_);
					_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) filters);
					_tmp38_ = _tmp37_;
					if (i < (_tmp38_ - 1)) {
						const gchar* _tmp39_;
						gchar* _tmp40_;
						_tmp39_ = query;
						_tmp40_ = g_strconcat (_tmp39_, " && ", NULL);
						_g_free0 (query);
						query = _tmp40_;
					}
				}
			}
		}
		_tmp41_ = query;
		_tmp42_ = g_strconcat (_tmp41_, ")", NULL);
		_g_free0 (query);
		query = _tmp42_;
	}
	_tmp43_ = query;
	_tmp44_ = g_strconcat (_tmp43_, " }", NULL);
	_g_free0 (query);
	query = _tmp44_;
	_tmp45_ = self->order_by;
	if (_tmp45_ != NULL) {
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		_tmp46_ = query;
		_tmp47_ = self->order_by;
		_tmp48_ = g_strconcat (" ORDER BY ", _tmp47_, NULL);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_strconcat (_tmp46_, _tmp49_, NULL);
		_g_free0 (query);
		query = _tmp50_;
		_g_free0 (_tmp49_);
	}
	if (self->offset > 0) {
		const gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		_tmp51_ = query;
		_tmp52_ = g_strdup_printf ("%i", self->offset);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strconcat (" OFFSET ", _tmp53_, NULL);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_strconcat (_tmp51_, _tmp55_, NULL);
		_g_free0 (query);
		query = _tmp56_;
		_g_free0 (_tmp55_);
		_g_free0 (_tmp53_);
	}
	if (self->max_count > 0) {
		const gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		_tmp57_ = query;
		_tmp58_ = g_strdup_printf ("%i", self->max_count);
		_tmp59_ = _tmp58_;
		_tmp60_ = g_strconcat (" LIMIT ", _tmp59_, NULL);
		_tmp61_ = _tmp60_;
		_tmp62_ = g_strconcat (_tmp57_, _tmp61_, NULL);
		_g_free0 (query);
		query = _tmp62_;
		_g_free0 (_tmp61_);
		_g_free0 (_tmp59_);
	}
	result = query;
	_g_object_unref0 (filters);
	return result;
}

static GeeArrayList*
rygel_tracker_selection_query_copy_str_list (GeeList* str_list)
{
	GeeArrayList* result = NULL;
	GeeArrayList* copy = NULL;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (str_list != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	copy = _tmp0_;
	gee_array_list_add_all (copy, (GeeCollection*) str_list);
	result = copy;
	return result;
}

static void
rygel_tracker_selection_query_class_init (RygelTrackerSelectionQueryClass * klass)
{
	rygel_tracker_selection_query_parent_class = g_type_class_peek_parent (klass);
	((RygelTrackerQueryClass *) klass)->finalize = rygel_tracker_selection_query_finalize;
	g_type_class_adjust_private_offset (klass, &RygelTrackerSelectionQuery_private_offset);
	((RygelTrackerQueryClass *) klass)->execute = (void (*) (RygelTrackerQuery*, TrackerSparqlConnection*, GAsyncReadyCallback, gpointer)) rygel_tracker_selection_query_real_execute;
	((RygelTrackerQueryClass *) klass)->execute_finish = (void (*) (RygelTrackerQuery*, GAsyncResult*, GError**)) rygel_tracker_selection_query_real_execute_finish;
	((RygelTrackerQueryClass *) klass)->to_string = (gchar* (*) (RygelTrackerQuery*)) rygel_tracker_selection_query_real_to_string;
}

static void
rygel_tracker_selection_query_instance_init (RygelTrackerSelectionQuery * self)
{
	self->priv = rygel_tracker_selection_query_get_instance_private (self);
}

static void
rygel_tracker_selection_query_finalize (RygelTrackerQuery * obj)
{
	RygelTrackerSelectionQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery);
	_g_free0 (self->priv->uri_filter);
	_g_object_unref0 (self->variables);
	_g_object_unref0 (self->filters);
	_g_free0 (self->order_by);
	_g_object_unref0 (self->result);
	RYGEL_TRACKER_QUERY_CLASS (rygel_tracker_selection_query_parent_class)->finalize (obj);
}

/**
 * Represents Tracker SPARQL Selection query
 */
GType
rygel_tracker_selection_query_get_type (void)
{
	static volatile gsize rygel_tracker_selection_query_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_selection_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerSelectionQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_selection_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerSelectionQuery), 0, (GInstanceInitFunc) rygel_tracker_selection_query_instance_init, NULL };
		GType rygel_tracker_selection_query_type_id;
		rygel_tracker_selection_query_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_QUERY, "RygelTrackerSelectionQuery", &g_define_type_info, 0);
		RygelTrackerSelectionQuery_private_offset = g_type_add_instance_private (rygel_tracker_selection_query_type_id, sizeof (RygelTrackerSelectionQueryPrivate));
		g_once_init_leave (&rygel_tracker_selection_query_type_id__volatile, rygel_tracker_selection_query_type_id);
	}
	return rygel_tracker_selection_query_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

