/* rygel-media-export-object-factory.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-media-export-object-factory.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <rygel-server.h>
#include <gio/gio.h>
#include <rygel-core.h>
#include <libxml/tree.h>

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;
typedef struct _RygelMediaExportObjectFactoryPrivate RygelMediaExportObjectFactoryPrivate;
enum  {
	RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_object_factory_properties[RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_NUM_PROPERTIES];

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER (rygel_media_export_trackable_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))

typedef struct _RygelMediaExportTrackableDbContainer RygelMediaExportTrackableDbContainer;
typedef struct _RygelMediaExportTrackableDbContainerClass RygelMediaExportTrackableDbContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER (rygel_media_export_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainer))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))

typedef struct _RygelMediaExportRootContainer RygelMediaExportRootContainer;
typedef struct _RygelMediaExportRootContainerClass RygelMediaExportRootContainerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY (rygel_media_export_query_container_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactory))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))

typedef struct _RygelMediaExportQueryContainerFactory RygelMediaExportQueryContainerFactory;
typedef struct _RygelMediaExportQueryContainerFactoryClass RygelMediaExportQueryContainerFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER (rygel_media_export_playlist_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainer))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ROOT_CONTAINER, RygelMediaExportPlaylistRootContainerClass))

typedef struct _RygelMediaExportPlaylistRootContainer RygelMediaExportPlaylistRootContainer;
typedef struct _RygelMediaExportPlaylistRootContainerClass RygelMediaExportPlaylistRootContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER (rygel_media_export_dvd_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainer))
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DVD_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DVD_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DVD_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_CONTAINER, RygelMediaExportDVDContainerClass))

typedef struct _RygelMediaExportDVDContainer RygelMediaExportDVDContainer;
typedef struct _RygelMediaExportDVDContainerClass RygelMediaExportDVDContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_CONTAINER (rygel_media_export_playlist_container_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_CONTAINER, RygelMediaExportPlaylistContainer))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_CONTAINER, RygelMediaExportPlaylistContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_CONTAINER))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_CONTAINER, RygelMediaExportPlaylistContainerClass))

typedef struct _RygelMediaExportPlaylistContainer RygelMediaExportPlaylistContainer;
typedef struct _RygelMediaExportPlaylistContainerClass RygelMediaExportPlaylistContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER (rygel_media_export_writable_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainer))
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_WRITABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_WRITABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainerClass))

typedef struct _RygelMediaExportWritableDbContainer RygelMediaExportWritableDbContainer;
typedef struct _RygelMediaExportWritableDbContainerClass RygelMediaExportWritableDbContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DVD_TRACK (rygel_media_export_dvd_track_get_type ())
#define RYGEL_MEDIA_EXPORT_DVD_TRACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_TRACK, RygelMediaExportDVDTrack))
#define RYGEL_MEDIA_EXPORT_DVD_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_TRACK, RygelMediaExportDVDTrackClass))
#define RYGEL_MEDIA_EXPORT_IS_DVD_TRACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_TRACK))
#define RYGEL_MEDIA_EXPORT_IS_DVD_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_TRACK))
#define RYGEL_MEDIA_EXPORT_DVD_TRACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_TRACK, RygelMediaExportDVDTrackClass))

typedef struct _RygelMediaExportDVDTrack RygelMediaExportDVDTrack;
typedef struct _RygelMediaExportDVDTrackClass RygelMediaExportDVDTrackClass;

#define RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM (rygel_media_export_photo_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItem))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))

typedef struct _RygelMediaExportPhotoItem RygelMediaExportPhotoItem;
typedef struct _RygelMediaExportPhotoItemClass RygelMediaExportPhotoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;

struct _RygelMediaExportObjectFactory {
	GObject parent_instance;
	RygelMediaExportObjectFactoryPrivate * priv;
};

struct _RygelMediaExportObjectFactoryClass {
	GObjectClass parent_class;
	RygelMediaContainer* (*get_container) (RygelMediaExportObjectFactory* self, const gchar* id, const gchar* title, guint child_count, const gchar* uri);
	RygelMediaFileItem* (*get_item) (RygelMediaExportObjectFactory* self, RygelMediaContainer* parent, const gchar* id, const gchar* title, const gchar* upnp_class);
};

static gpointer rygel_media_export_object_factory_parent_class = NULL;

GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self,
                                                                      const gchar* id,
                                                                      const gchar* title,
                                                                      guint child_count,
                                                                      const gchar* uri);
static RygelMediaContainer* rygel_media_export_object_factory_real_get_container (RygelMediaExportObjectFactory* self,
                                                                           const gchar* id,
                                                                           const gchar* title,
                                                                           guint child_count,
                                                                           const gchar* uri);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_trackable_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_root_container_get_type (void) G_GNUC_CONST;
RygelMediaExportRootContainer* rygel_media_export_root_container_get_instance (void);
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
RygelMediaExportDBContainer* rygel_media_export_root_container_get_filesystem_container (RygelMediaExportRootContainer* self);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
GType rygel_media_export_query_container_factory_get_type (void) G_GNUC_CONST;
RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_get_default (void);
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_hashed_id (RygelMediaExportQueryContainerFactory* self,
                                                                                                  const gchar* id,
                                                                                                  const gchar* name);
RygelMediaExportPlaylistRootContainer* rygel_media_export_playlist_root_container_new (void);
RygelMediaExportPlaylistRootContainer* rygel_media_export_playlist_root_container_construct (GType object_type);
GType rygel_media_export_playlist_root_container_get_type (void) G_GNUC_CONST;
RygelMediaExportDBContainer* rygel_media_export_db_container_new (const gchar* id,
                                                                  const gchar* title);
RygelMediaExportDBContainer* rygel_media_export_db_container_construct (GType object_type,
                                                                        const gchar* id,
                                                                        const gchar* title);
RygelMediaExportTrackableDbContainer* rygel_media_export_trackable_db_container_new (const gchar* id,
                                                                                     const gchar* title);
RygelMediaExportTrackableDbContainer* rygel_media_export_trackable_db_container_construct (GType object_type,
                                                                                           const gchar* id,
                                                                                           const gchar* title);
RygelMediaExportDVDContainer* rygel_media_export_dvd_container_new (const gchar* id,
                                                                    RygelMediaContainer* parent,
                                                                    const gchar* title,
                                                                    const gchar* path);
RygelMediaExportDVDContainer* rygel_media_export_dvd_container_construct (GType object_type,
                                                                          const gchar* id,
                                                                          RygelMediaContainer* parent,
                                                                          const gchar* title,
                                                                          const gchar* path);
GType rygel_media_export_dvd_container_get_type (void) G_GNUC_CONST;
RygelMediaExportPlaylistContainer* rygel_media_export_playlist_container_new (const gchar* id,
                                                                              const gchar* title);
RygelMediaExportPlaylistContainer* rygel_media_export_playlist_container_construct (GType object_type,
                                                                                    const gchar* id,
                                                                                    const gchar* title);
GType rygel_media_export_playlist_container_get_type (void) G_GNUC_CONST;
RygelMediaExportWritableDbContainer* rygel_media_export_writable_db_container_new (const gchar* id,
                                                                                   const gchar* title);
RygelMediaExportWritableDbContainer* rygel_media_export_writable_db_container_construct (GType object_type,
                                                                                         const gchar* id,
                                                                                         const gchar* title);
GType rygel_media_export_writable_db_container_get_type (void) G_GNUC_CONST;
RygelMediaFileItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self,
                                                                RygelMediaContainer* parent,
                                                                const gchar* id,
                                                                const gchar* title,
                                                                const gchar* upnp_class);
static RygelMediaFileItem* rygel_media_export_object_factory_real_get_item (RygelMediaExportObjectFactory* self,
                                                                     RygelMediaContainer* parent,
                                                                     const gchar* id,
                                                                     const gchar* title,
                                                                     const gchar* upnp_class);
RygelMediaExportMusicItem* rygel_media_export_music_item_new (const gchar* id,
                                                              RygelMediaContainer* parent,
                                                              const gchar* title,
                                                              const gchar* upnp_class);
RygelMediaExportMusicItem* rygel_media_export_music_item_construct (GType object_type,
                                                                    const gchar* id,
                                                                    RygelMediaContainer* parent,
                                                                    const gchar* title,
                                                                    const gchar* upnp_class);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
RygelMediaExportDVDTrack* rygel_media_export_dvd_track_new (const gchar* id,
                                                            RygelMediaContainer* parent,
                                                            const gchar* title,
                                                            gint track,
                                                            xmlNode* node);
RygelMediaExportDVDTrack* rygel_media_export_dvd_track_construct (GType object_type,
                                                                  const gchar* id,
                                                                  RygelMediaContainer* parent,
                                                                  const gchar* title,
                                                                  gint track,
                                                                  xmlNode* node);
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dvd_track_get_type (void) G_GNUC_CONST;
RygelMediaExportVideoItem* rygel_media_export_video_item_new (const gchar* id,
                                                              RygelMediaContainer* parent,
                                                              const gchar* title,
                                                              const gchar* upnp_class);
RygelMediaExportVideoItem* rygel_media_export_video_item_construct (GType object_type,
                                                                    const gchar* id,
                                                                    RygelMediaContainer* parent,
                                                                    const gchar* title,
                                                                    const gchar* upnp_class);
RygelMediaExportPhotoItem* rygel_media_export_photo_item_new (const gchar* id,
                                                              RygelMediaContainer* parent,
                                                              const gchar* title,
                                                              const gchar* upnp_class);
RygelMediaExportPhotoItem* rygel_media_export_photo_item_construct (GType object_type,
                                                                    const gchar* id,
                                                                    RygelMediaContainer* parent,
                                                                    const gchar* title,
                                                                    const gchar* upnp_class);
GType rygel_media_export_photo_item_get_type (void) G_GNUC_CONST;
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_new (const gchar* id,
                                                                    RygelMediaContainer* parent,
                                                                    const gchar* title,
                                                                    const gchar* upnp_class);
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_construct (GType object_type,
                                                                          const gchar* id,
                                                                          RygelMediaContainer* parent,
                                                                          const gchar* title,
                                                                          const gchar* upnp_class);
GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST;
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);

/**
     * Return a new instance of DBContainer.
     *
     * @param media_db instance of MediaDB
     * @param title title of the container
     * @param child_count number of children in the container
     */
static RygelMediaContainer*
rygel_media_export_object_factory_real_get_container (RygelMediaExportObjectFactory* self,
                                                      const gchar* id,
                                                      const gchar* title,
                                                      guint child_count,
                                                      const gchar* uri)
{
	RygelMediaContainer* result = NULL;
	gboolean allow_upload = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	if (g_strcmp0 (id, "0") == 0) {
		RygelMediaExportRootContainer* _tmp0_;
		_tmp0_ = rygel_media_export_root_container_get_instance ();
		result = (RygelMediaContainer*) _tmp0_;
		return result;
	} else {
		if (g_strcmp0 (id, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID) == 0) {
			RygelMediaExportRootContainer* root_container = NULL;
			RygelMediaExportRootContainer* _tmp1_;
			RygelMediaExportRootContainer* _tmp2_;
			RygelMediaExportDBContainer* _tmp3_;
			_tmp1_ = rygel_media_export_root_container_get_instance ();
			root_container = _tmp1_;
			_tmp2_ = root_container;
			_tmp3_ = rygel_media_export_root_container_get_filesystem_container (_tmp2_);
			result = (RygelMediaContainer*) _tmp3_;
			_g_object_unref0 (root_container);
			return result;
		}
	}
	if (g_str_has_prefix (id, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX)) {
		RygelMediaExportQueryContainerFactory* factory = NULL;
		RygelMediaExportQueryContainerFactory* _tmp4_;
		RygelMediaExportQueryContainerFactory* _tmp5_;
		RygelMediaExportQueryContainer* _tmp6_;
		_tmp4_ = rygel_media_export_query_container_factory_get_default ();
		factory = _tmp4_;
		_tmp5_ = factory;
		_tmp6_ = rygel_media_export_query_container_factory_create_from_hashed_id (_tmp5_, id, title);
		result = (RygelMediaContainer*) _tmp6_;
		_g_object_unref0 (factory);
		return result;
	}
	if (g_str_has_prefix (id, "virtual-parent:" RYGEL_PLAYLIST_ITEM_UPNP_CLASS)) {
		RygelMediaExportPlaylistRootContainer* _tmp7_;
		_tmp7_ = rygel_media_export_playlist_root_container_new ();
		result = (RygelMediaContainer*) _tmp7_;
		return result;
	}
	if (g_str_has_prefix (id, "virtual-parent:")) {
		RygelMediaExportDBContainer* _tmp8_;
		_tmp8_ = rygel_media_export_db_container_new (id, title);
		result = (RygelMediaContainer*) _tmp8_;
		return result;
	}
	if (uri == NULL) {
		RygelMediaExportTrackableDbContainer* _tmp9_;
		_tmp9_ = rygel_media_export_trackable_db_container_new (id, title);
		result = (RygelMediaContainer*) _tmp9_;
		return result;
	}
	if (g_str_has_prefix (id, "dvd:")) {
		GFile* file = NULL;
		GFile* _tmp10_;
		GFile* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		RygelMediaExportDVDContainer* _tmp14_;
		RygelMediaContainer* _tmp15_;
		_tmp10_ = g_file_new_for_uri (uri);
		file = _tmp10_;
		_tmp11_ = file;
		_tmp12_ = g_file_get_path (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = rygel_media_export_dvd_container_new (id, NULL, title, _tmp13_);
		_tmp15_ = (RygelMediaContainer*) _tmp14_;
		_g_free0 (_tmp13_);
		result = _tmp15_;
		_g_object_unref0 (file);
		return result;
	}
	if (g_str_has_prefix (id, "playlist:")) {
		RygelMediaExportPlaylistContainer* _tmp16_;
		_tmp16_ = rygel_media_export_playlist_container_new (id, title);
		result = (RygelMediaContainer*) _tmp16_;
		return result;
	}
	allow_upload = FALSE;
	{
		gboolean _tmp17_ = FALSE;
		RygelMetaConfig* _tmp18_;
		RygelMetaConfig* _tmp19_;
		gboolean _tmp20_;
		_tmp18_ = rygel_meta_config_get_default ();
		_tmp19_ = _tmp18_;
		_tmp20_ = rygel_configuration_get_allow_upload ((RygelConfiguration*) _tmp19_, &_inner_error_);
		_g_object_unref0 (_tmp19_);
		_tmp17_ = _tmp20_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch62_g_error;
		}
		allow_upload = _tmp17_;
	}
	goto __finally62;
	__catch62_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally62:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (allow_upload) {
		RygelMediaExportWritableDbContainer* _tmp21_;
		_tmp21_ = rygel_media_export_writable_db_container_new (id, title);
		result = (RygelMediaContainer*) _tmp21_;
		return result;
	} else {
		RygelMediaExportTrackableDbContainer* _tmp22_;
		_tmp22_ = rygel_media_export_trackable_db_container_new (id, title);
		result = (RygelMediaContainer*) _tmp22_;
		return result;
	}
}

RygelMediaContainer*
rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self,
                                                 const gchar* id,
                                                 const gchar* title,
                                                 guint child_count,
                                                 const gchar* uri)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS (self)->get_container (self, id, title, child_count, uri);
}

/**
     * Return a new instance of MediaFileItem
     *
     * @param media_db instance of MediaDB
     * @param id id of the item
     * @param title title of the item
     * @param upnp_class upnp_class of the item
     */
static RygelMediaFileItem*
rygel_media_export_object_factory_real_get_item (RygelMediaExportObjectFactory* self,
                                                 RygelMediaContainer* parent,
                                                 const gchar* id,
                                                 const gchar* title,
                                                 const gchar* upnp_class)
{
	RygelMediaFileItem* result = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	_tmp0_ = upnp_class;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((_tmp2_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) || (_tmp2_ == g_quark_from_string (RYGEL_AUDIO_ITEM_UPNP_CLASS))) {
		switch (0) {
			default:
			{
				RygelMediaExportMusicItem* _tmp3_;
				_tmp3_ = rygel_media_export_music_item_new (id, parent, title, RYGEL_MUSIC_ITEM_UPNP_CLASS);
				result = (RygelMediaFileItem*) _tmp3_;
				return result;
			}
		}
	} else if (_tmp2_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				RygelMediaExportVideoItem* _tmp5_;
				if (g_str_has_prefix (id, "dvd-track")) {
					RygelMediaExportDVDTrack* _tmp4_;
					_tmp4_ = rygel_media_export_dvd_track_new (id, parent, title, 0, NULL);
					result = (RygelMediaFileItem*) _tmp4_;
					return result;
				}
				_tmp5_ = rygel_media_export_video_item_new (id, parent, title, RYGEL_VIDEO_ITEM_UPNP_CLASS);
				result = (RygelMediaFileItem*) _tmp5_;
				return result;
			}
		}
	} else if ((_tmp2_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) || (_tmp2_ == g_quark_from_string (RYGEL_IMAGE_ITEM_UPNP_CLASS))) {
		switch (0) {
			default:
			{
				RygelMediaExportPhotoItem* _tmp6_;
				_tmp6_ = rygel_media_export_photo_item_new (id, parent, title, RYGEL_PHOTO_ITEM_UPNP_CLASS);
				result = (RygelMediaFileItem*) _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == g_quark_from_string (RYGEL_PLAYLIST_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				RygelMediaExportPlaylistItem* _tmp7_;
				_tmp7_ = rygel_media_export_playlist_item_new (id, parent, title, RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
				result = (RygelMediaFileItem*) _tmp7_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}

RygelMediaFileItem*
rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self,
                                            RygelMediaContainer* parent,
                                            const gchar* id,
                                            const gchar* title,
                                            const gchar* upnp_class)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS (self)->get_item (self, parent, id, title, upnp_class);
}

RygelMediaExportObjectFactory*
rygel_media_export_object_factory_construct (GType object_type)
{
	RygelMediaExportObjectFactory * self = NULL;
	self = (RygelMediaExportObjectFactory*) g_object_new (object_type, NULL);
	return self;
}

RygelMediaExportObjectFactory*
rygel_media_export_object_factory_new (void)
{
	return rygel_media_export_object_factory_construct (RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY);
}

static void
rygel_media_export_object_factory_class_init (RygelMediaExportObjectFactoryClass * klass)
{
	rygel_media_export_object_factory_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaExportObjectFactoryClass *) klass)->get_container = (RygelMediaContainer* (*) (RygelMediaExportObjectFactory*, const gchar*, const gchar*, guint, const gchar*)) rygel_media_export_object_factory_real_get_container;
	((RygelMediaExportObjectFactoryClass *) klass)->get_item = (RygelMediaFileItem* (*) (RygelMediaExportObjectFactory*, RygelMediaContainer*, const gchar*, const gchar*, const gchar*)) rygel_media_export_object_factory_real_get_item;
}

static void
rygel_media_export_object_factory_instance_init (RygelMediaExportObjectFactory * self)
{
}

/**
 * A helper class to create container and item
 * instances based on media-export object IDs,
 * sometimes delegating to the QueryContainerFactory.
 */
GType
rygel_media_export_object_factory_get_type (void)
{
	static volatile gsize rygel_media_export_object_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_object_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportObjectFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_object_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportObjectFactory), 0, (GInstanceInitFunc) rygel_media_export_object_factory_instance_init, NULL };
		GType rygel_media_export_object_factory_type_id;
		rygel_media_export_object_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportObjectFactory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_object_factory_type_id__volatile, rygel_media_export_object_factory_type_id);
	}
	return rygel_media_export_object_factory_type_id__volatile;
}

