/* rygel-media-export-harvesting-task.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-media-export-harvesting-task.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <rygel-server.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <rygel-db.h>
#include <gobject/gvaluecollector.h>

#define TYPE_FILE_QUEUE_ENTRY (file_queue_entry_get_type ())
#define FILE_QUEUE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_QUEUE_ENTRY, FileQueueEntry))
#define FILE_QUEUE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_QUEUE_ENTRY, FileQueueEntryClass))
#define IS_FILE_QUEUE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_QUEUE_ENTRY))
#define IS_FILE_QUEUE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_QUEUE_ENTRY))
#define FILE_QUEUE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_QUEUE_ENTRY, FileQueueEntryClass))

typedef struct _FileQueueEntry FileQueueEntry;
typedef struct _FileQueueEntryClass FileQueueEntryClass;
typedef struct _FileQueueEntryPrivate FileQueueEntryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecFileQueueEntry ParamSpecFileQueueEntry;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_harvesting_task_properties[RYGEL_MEDIA_EXPORT_HARVESTING_TASK_NUM_PROPERTIES];
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskRunData RygelMediaExportHarvestingTaskRunData;
#define _file_queue_entry_unref0(var) ((var == NULL) ? NULL : (var = (file_queue_entry_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER (rygel_media_export_trackable_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))

typedef struct _RygelMediaExportTrackableDbContainer RygelMediaExportTrackableDbContainer;
typedef struct _RygelMediaExportTrackableDbContainerClass RygelMediaExportTrackableDbContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER (rygel_media_export_dummy_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainer))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))

typedef struct _RygelMediaExportDummyContainer RygelMediaExportDummyContainer;
typedef struct _RygelMediaExportDummyContainerClass RygelMediaExportDummyContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;
typedef struct _RygelMediaExportTrackableDbContainerPrivate RygelMediaExportTrackableDbContainerPrivate;
typedef struct _RygelMediaExportDummyContainerPrivate RygelMediaExportDummyContainerPrivate;
typedef struct _RygelMediaExportHarvestingTaskEnumerateDirectoryData RygelMediaExportHarvestingTaskEnumerateDirectoryData;

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;

struct _FileQueueEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FileQueueEntryPrivate * priv;
	GFile* file;
	gboolean known;
	gchar* content_type;
};

struct _FileQueueEntryClass {
	GTypeClass parent_class;
	void (*finalize) (FileQueueEntry *self);
};

struct _ParamSpecFileQueueEntry {
	GParamSpec parent_instance;
};

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvestingTaskPrivate {
	GTimer* timer;
	RygelMediaExportMetadataExtractor* extractor;
	RygelMediaExportMediaCache* cache;
	GQueue* containers;
	GeeQueue* files;
	RygelMediaExportRecursiveFileMonitor* monitor;
	RygelMediaContainer* parent;
	GCancellable* _cancellable;
};

struct _RygelMediaExportHarvestingTaskRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelMediaExportHarvestingTask* self;
	GTimer* _tmp0_;
	RygelMediaExportMetadataExtractor* _tmp1_;
	GFileInfo* info;
	GFile* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	GFileInfo* _tmp5_;
	GFile* _tmp6_;
	RygelMediaContainer* _tmp7_;
	GQueue* _tmp8_;
	RygelMediaContainer* _tmp9_;
	RygelMediaContainer* _tmp10_;
	GError* _error_;
	RygelMediaExportMetadataExtractor* _tmp11_;
	GError* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError * _inner_error_;
};

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
	gint (*count_children) (RygelMediaExportDBContainer* self);
	void (*search) (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelMediaExportTrackableDbContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportTrackableDbContainerPrivate * priv;
};

struct _RygelMediaExportTrackableDbContainerClass {
	RygelMediaExportDBContainerClass parent_class;
	void (*remove_child) (RygelMediaExportTrackableDbContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelMediaExportTrackableDbContainer* self, GAsyncResult* _res_);
	gchar* (*get_service_reset_token) (RygelMediaExportTrackableDbContainer* self);
	void (*set_service_reset_token) (RygelMediaExportTrackableDbContainer* self, const gchar* token);
	guint32 (*get_system_update_id) (RygelMediaExportTrackableDbContainer* self);
};

struct _RygelMediaExportDummyContainer {
	RygelMediaExportTrackableDbContainer parent_instance;
	RygelMediaExportDummyContainerPrivate * priv;
	GFile* file;
	GeeList* children;
};

struct _RygelMediaExportDummyContainerClass {
	RygelMediaExportTrackableDbContainerClass parent_class;
};

struct _RygelMediaExportHarvestingTaskEnumerateDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelMediaExportHarvestingTask* self;
	GFile* directory;
	GQueue* _tmp0_;
	gconstpointer _tmp1_;
	RygelMediaContainer* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFileEnumerator* enumerator;
	GFile* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	GFileEnumerator* _tmp8_;
	GList* list;
	gboolean _tmp9_;
	GList* _tmp10_;
	GList* _tmp11_;
	GFileEnumerator* _tmp12_;
	GCancellable* _tmp13_;
	GCancellable* _tmp14_;
	GList* _tmp15_;
	GList* _tmp16_;
	GFileEnumerator* _tmp17_;
	GCancellable* _tmp18_;
	GCancellable* _tmp19_;
	GError* err;
	GFile* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GError* _tmp23_;
	const gchar* _tmp24_;
	GError * _inner_error_;
};

struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

static gpointer file_queue_entry_parent_class = NULL;
static gint RygelMediaExportHarvestingTask_private_offset;
static gpointer rygel_media_export_harvesting_task_parent_class = NULL;
static RygelStateMachineIface * rygel_media_export_harvesting_task_rygel_state_machine_parent_iface = NULL;

gpointer file_queue_entry_ref (gpointer instance);
void file_queue_entry_unref (gpointer instance);
GParamSpec* param_spec_file_queue_entry (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void value_set_file_queue_entry (GValue* value,
                                 gpointer v_object);
void value_take_file_queue_entry (GValue* value,
                                  gpointer v_object);
gpointer value_get_file_queue_entry (const GValue* value);
GType file_queue_entry_get_type (void) G_GNUC_CONST;
FileQueueEntry* file_queue_entry_new (GFile* file,
                                      gboolean known,
                                      const gchar* content_type);
FileQueueEntry* file_queue_entry_construct (GType object_type,
                                            GFile* file,
                                            gboolean known,
                                            const gchar* content_type);
static void file_queue_entry_finalize (FileQueueEntry * obj);
GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
void rygel_media_export_metadata_extractor_stop (RygelMediaExportMetadataExtractor* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_queue_free__g_object_unref0_ (GQueue* self);
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_BATCH_SIZE 256
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_MIME_TYPE_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportRecursiveFileMonitor* monitor,
                                                                        GFile* file,
                                                                        RygelMediaContainer* parent);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type,
                                                                              RygelMediaExportRecursiveFileMonitor* monitor,
                                                                              GFile* file,
                                                                              RygelMediaContainer* parent);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void);
static void rygel_media_export_harvesting_task_on_extracted_cb (RygelMediaExportHarvestingTask* self,
                                                         GFile* file,
                                                         GVariant* info);
static void _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender,
                                                                                                                GFile* file,
                                                                                                                GVariant* info,
                                                                                                                gpointer self);
static void rygel_media_export_harvesting_task_on_extractor_error_cb (RygelMediaExportHarvestingTask* self,
                                                               GFile* file,
                                                               GError* _error_);
static void _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender,
                                                                                                            GFile* file,
                                                                                                            GError* err,
                                                                                                            gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvesting_task_real_run_data_free (gpointer _data);
static void rygel_media_export_harvesting_task_real_run_async_ready_wrapper (GObject *source_object,
                                                                      GAsyncResult *res,
                                                                      void *user_data);
static void rygel_media_export_harvesting_task_real_run (RygelStateMachine* base,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static gboolean rygel_media_export_harvesting_task_real_run_co (RygelMediaExportHarvestingTaskRunData* _data_);
void rygel_media_export_metadata_extractor_run (RygelMediaExportMetadataExtractor* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
void rygel_media_export_metadata_extractor_run_finish (RygelMediaExportMetadataExtractor* self,
                                                       GAsyncResult* _res_);
static void rygel_media_export_harvesting_task_run_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static gboolean rygel_media_export_harvesting_task_process_file (RygelMediaExportHarvestingTask* self,
                                                          GFile* file,
                                                          GFileInfo* info,
                                                          RygelMediaContainer* parent);
static gboolean rygel_media_export_harvesting_task_on_idle (RygelMediaExportHarvestingTask* self);
static gboolean rygel_media_export_harvesting_task_push_if_changed_or_unknown (RygelMediaExportHarvestingTask* self,
                                                                        GFile* file,
                                                                        GFileInfo* info);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self,
                                                GFile* file,
                                                gint64* timestamp,
                                                gint64* size,
                                                gchar* * mime_type,
                                                GError** error);
gboolean rygel_media_export_harvester_is_eligible (GFile* file,
                                                   GFileInfo* info);
void rygel_media_export_recursive_file_monitor_add (RygelMediaExportRecursiveFileMonitor* self,
                                                    GFile* file,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
void rygel_media_export_recursive_file_monitor_add_finish (RygelMediaExportRecursiveFileMonitor* self,
                                                           GAsyncResult* _res_);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_trackable_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dummy_container_get_type (void) G_GNUC_CONST;
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_new (GFile* file,
                                                                        RygelMediaContainer* parent);
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_construct (GType object_type,
                                                                              GFile* file,
                                                                              RygelMediaContainer* parent);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
static gboolean rygel_media_export_harvesting_task_process_children (RygelMediaExportHarvestingTask* self,
                                                              GList* list);
void rygel_media_export_dummy_container_seen (RygelMediaExportDummyContainer* self,
                                              GFile* file);
static void rygel_media_export_harvesting_task_enumerate_directory_data_free (gpointer _data);
static void rygel_media_export_harvesting_task_enumerate_directory_async_ready_wrapper (GObject *source_object,
                                                                                 GAsyncResult *res,
                                                                                 void *user_data);
static void rygel_media_export_harvesting_task_enumerate_directory (RygelMediaExportHarvestingTask* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static void rygel_media_export_harvesting_task_enumerate_directory_finish (RygelMediaExportHarvestingTask* self,
                                                                    GAsyncResult* _res_);
static gboolean rygel_media_export_harvesting_task_enumerate_directory_co (RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_);
static void rygel_media_export_harvesting_task_enumerate_directory_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_media_export_harvesting_task_cleanup_database (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvesting_task_do_update (RygelMediaExportHarvestingTask* self);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self,
                                                  const gchar* id,
                                                  GError** error);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self,
                                                    GFile* file,
                                                    const gchar* content_type);
RygelMediaObject* rygel_media_export_item_factory_create_from_variant (RygelMediaContainer* parent,
                                                                       GFile* file,
                                                                       GVariant* v,
                                                                       GError** error);
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
void rygel_media_export_updatable_object_non_overriding_commit (RygelMediaExportUpdatableObject* self,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
void rygel_media_export_updatable_object_non_overriding_commit_finish (RygelMediaExportUpdatableObject* self,
                                                                       GAsyncResult* _res_,
                                                                       GError** error);
void rygel_media_export_media_cache_blacklist (RygelMediaExportMediaCache* self,
                                               GFile* file);
static void rygel_media_export_harvesting_task_finalize (GObject * obj);
static void _vala_rygel_media_export_harvesting_task_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_rygel_media_export_harvesting_task_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FileQueueEntry*
file_queue_entry_construct (GType object_type,
                            GFile* file,
                            gboolean known,
                            const gchar* content_type)
{
	FileQueueEntry* self = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (content_type != NULL, NULL);
	self = (FileQueueEntry*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp0_;
	self->known = known;
	_tmp1_ = g_strdup (content_type);
	_g_free0 (self->content_type);
	self->content_type = _tmp1_;
	return self;
}

FileQueueEntry*
file_queue_entry_new (GFile* file,
                      gboolean known,
                      const gchar* content_type)
{
	return file_queue_entry_construct (TYPE_FILE_QUEUE_ENTRY, file, known, content_type);
}

static void
value_file_queue_entry_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_file_queue_entry_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		file_queue_entry_unref (value->data[0].v_pointer);
	}
}

static void
value_file_queue_entry_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = file_queue_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_file_queue_entry_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_file_queue_entry_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FileQueueEntry * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = file_queue_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_file_queue_entry_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	FileQueueEntry ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = file_queue_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_file_queue_entry (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecFileQueueEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_FILE_QUEUE_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_file_queue_entry (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FILE_QUEUE_ENTRY), NULL);
	return value->data[0].v_pointer;
}

void
value_set_file_queue_entry (GValue* value,
                            gpointer v_object)
{
	FileQueueEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FILE_QUEUE_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FILE_QUEUE_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		file_queue_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		file_queue_entry_unref (old);
	}
}

void
value_take_file_queue_entry (GValue* value,
                             gpointer v_object)
{
	FileQueueEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FILE_QUEUE_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FILE_QUEUE_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		file_queue_entry_unref (old);
	}
}

static void
file_queue_entry_class_init (FileQueueEntryClass * klass)
{
	file_queue_entry_parent_class = g_type_class_peek_parent (klass);
	((FileQueueEntryClass *) klass)->finalize = file_queue_entry_finalize;
}

static void
file_queue_entry_instance_init (FileQueueEntry * self)
{
	self->ref_count = 1;
}

static void
file_queue_entry_finalize (FileQueueEntry * obj)
{
	FileQueueEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_QUEUE_ENTRY, FileQueueEntry);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->file);
	_g_free0 (self->content_type);
}

GType
file_queue_entry_get_type (void)
{
	static volatile gsize file_queue_entry_type_id__volatile = 0;
	if (g_once_init_enter (&file_queue_entry_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_file_queue_entry_init, value_file_queue_entry_free_value, value_file_queue_entry_copy_value, value_file_queue_entry_peek_pointer, "p", value_file_queue_entry_collect_value, "p", value_file_queue_entry_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FileQueueEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_queue_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileQueueEntry), 0, (GInstanceInitFunc) file_queue_entry_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType file_queue_entry_type_id;
		file_queue_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FileQueueEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&file_queue_entry_type_id__volatile, file_queue_entry_type_id);
	}
	return file_queue_entry_type_id__volatile;
}

gpointer
file_queue_entry_ref (gpointer instance)
{
	FileQueueEntry * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
file_queue_entry_unref (gpointer instance)
{
	FileQueueEntry * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FILE_QUEUE_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
rygel_media_export_harvesting_task_get_instance_private (RygelMediaExportHarvestingTask* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaExportHarvestingTask_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_queue_free__g_object_unref0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender,
                                                                                                           GFile* file,
                                                                                                           GVariant* info,
                                                                                                           gpointer self)
{
	rygel_media_export_harvesting_task_on_extracted_cb ((RygelMediaExportHarvestingTask*) self, file, info);
}

static void
_rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender,
                                                                                                       GFile* file,
                                                                                                       GError* err,
                                                                                                       gpointer self)
{
	rygel_media_export_harvesting_task_on_extractor_error_cb ((RygelMediaExportHarvestingTask*) self, file, err);
}

RygelMediaExportHarvestingTask*
rygel_media_export_harvesting_task_construct (GType object_type,
                                              RygelMediaExportRecursiveFileMonitor* monitor,
                                              GFile* file,
                                              RygelMediaContainer* parent)
{
	RygelMediaExportHarvestingTask * self = NULL;
	RygelMediaExportMetadataExtractor* _tmp0_;
	GFile* _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelMediaExportMediaCache* _tmp3_;
	RygelMediaExportMetadataExtractor* _tmp4_;
	RygelMediaExportMetadataExtractor* _tmp5_;
	GeeLinkedList* _tmp6_;
	GQueue* _tmp7_;
	RygelMediaExportRecursiveFileMonitor* _tmp8_;
	GTimer* _tmp9_;
	g_return_val_if_fail (monitor != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (RygelMediaExportHarvestingTask*) g_object_new (object_type, NULL);
	_tmp0_ = rygel_media_export_metadata_extractor_new ();
	_g_object_unref0 (self->priv->extractor);
	self->priv->extractor = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (self->origin);
	self->origin = _tmp1_;
	_tmp2_ = _g_object_ref0 (parent);
	_g_object_unref0 (self->priv->parent);
	self->priv->parent = _tmp2_;
	_tmp3_ = rygel_media_export_media_cache_get_default ();
	_g_object_unref0 (self->priv->cache);
	self->priv->cache = _tmp3_;
	_tmp4_ = self->priv->extractor;
	g_signal_connect_object (_tmp4_, "extraction-done", (GCallback) _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done, self, 0);
	_tmp5_ = self->priv->extractor;
	g_signal_connect_object (_tmp5_, "error", (GCallback) _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error, self, 0);
	_tmp6_ = gee_linked_list_new (TYPE_FILE_QUEUE_ENTRY, (GBoxedCopyFunc) file_queue_entry_ref, (GDestroyNotify) file_queue_entry_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->files);
	self->priv->files = (GeeQueue*) _tmp6_;
	_tmp7_ = g_queue_new ();
	(self->priv->containers == NULL) ? NULL : (self->priv->containers = (_g_queue_free__g_object_unref0_ (self->priv->containers), NULL));
	self->priv->containers = _tmp7_;
	_tmp8_ = _g_object_ref0 (monitor);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp8_;
	_tmp9_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp9_;
	return self;
}

RygelMediaExportHarvestingTask*
rygel_media_export_harvesting_task_new (RygelMediaExportRecursiveFileMonitor* monitor,
                                        GFile* file,
                                        RygelMediaContainer* parent)
{
	return rygel_media_export_harvesting_task_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, monitor, file, parent);
}

void
rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self)
{
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	RygelMediaExportMetadataExtractor* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_cancellable_new ();
	_tmp1_ = _tmp0_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp3_ = _tmp2_;
	g_cancellable_cancel (_tmp3_);
	_tmp4_ = self->priv->extractor;
	rygel_media_export_metadata_extractor_stop (_tmp4_);
}

static void
rygel_media_export_harvesting_task_real_run_data_free (gpointer _data)
{
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportHarvestingTaskRunData, _data_);
}

static void
rygel_media_export_harvesting_task_real_run_async_ready_wrapper (GObject *source_object,
                                                                 GAsyncResult *res,
                                                                 void *user_data)
{
	RygelMediaExportHarvestingTaskRunData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static void
rygel_media_export_harvesting_task_real_run (RygelStateMachine* base,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	RygelMediaExportHarvestingTask * self;
	RygelMediaExportHarvestingTaskRunData* _data_;
	RygelMediaExportHarvestingTask* _tmp0_;
	self = (RygelMediaExportHarvestingTask*) base;
	_data_ = g_slice_new0 (RygelMediaExportHarvestingTaskRunData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_media_export_harvesting_task_real_run_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_harvesting_task_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_harvesting_task_real_run_co (_data_);
}

static void
rygel_media_export_harvesting_task_real_run_finish (RygelStateMachine* base,
                                                    GAsyncResult* _res_)
{
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Extract all metainformation from a given file.
     *
     * What action will be taken depends on the arguments
     * * file is a simple file. Then only information of this
     *   file will be extracted
     * * file is a directory and recursive is false. The children
     *   of the directory (if not directories themselves) will be
     *   enqueued for extraction
     * * file is a directory and recursive is true. ++ All ++ children
     *   of the directory will be enqueued for extraction, even directories
     *
     * No matter how many children are contained within file's hierarchy,
     * only one event is sent when all the children are done.
     */
static void
rygel_media_export_harvesting_task_run_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_media_export_harvesting_task_real_run_co (_data_);
}

static gboolean
rygel_media_export_harvesting_task_real_run_co (RygelMediaExportHarvestingTaskRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->timer;
	g_timer_reset (_data_->_tmp0_);
	{
		_data_->_tmp1_ = _data_->self->priv->extractor;
		rygel_media_export_metadata_extractor_run (_data_->_tmp1_, NULL, NULL);
		_data_->_tmp2_ = _data_->self->origin;
		_data_->_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp2_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp4_, rygel_media_export_harvesting_task_run_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = g_file_query_info_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
		_data_->info = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch57_g_error;
		}
		_data_->_tmp6_ = _data_->self->origin;
		_data_->_tmp7_ = _data_->self->priv->parent;
		if (rygel_media_export_harvesting_task_process_file (_data_->self, _data_->_tmp6_, _data_->info, _data_->_tmp7_)) {
			if (g_file_info_get_file_type (_data_->info) != G_FILE_TYPE_DIRECTORY) {
				_data_->_tmp8_ = _data_->self->priv->containers;
				_data_->_tmp9_ = _data_->self->priv->parent;
				_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
				g_queue_push_tail (_data_->_tmp8_, _data_->_tmp10_);
			}
			rygel_media_export_harvesting_task_on_idle (_data_->self);
		} else {
			g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
		}
		_g_object_unref0 (_data_->info);
	}
	goto __finally57;
	__catch57_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp11_ = _data_->self->priv->extractor;
		rygel_media_export_metadata_extractor_stop (_data_->_tmp11_);
		_data_->_tmp12_ = _data_->_error_;
		if (!g_error_matches (_data_->_tmp12_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_data_->_tmp13_ = _data_->self->origin;
			_data_->_tmp14_ = g_file_get_uri (_data_->_tmp13_);
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp16_ = _data_->_error_;
			_data_->_tmp17_ = _data_->_tmp16_->message;
			g_warning (_ ("Failed to harvest file %s: %s"), _data_->_tmp15_, _data_->_tmp17_);
			_g_free0 (_data_->_tmp15_);
		} else {
			_data_->_tmp18_ = _data_->self->origin;
			_data_->_tmp19_ = g_file_get_uri (_data_->_tmp18_);
			_data_->_tmp20_ = _data_->_tmp19_;
			g_debug ("rygel-media-export-harvesting-task.vala:131: Harvesting of uri %s was " \
"cancelled", _data_->_tmp20_);
			_g_free0 (_data_->_tmp20_);
		}
		g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
		_g_error_free0 (_data_->_error_);
	}
	__finally57:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Add a file to the meta-data extraction queue.
     *
     * The file will only be added to the queue if one of the following
     * conditions is met:
     *   - The file is not in the cache
     *   - The current mtime of the file is larger than the cached
     *   - The size has changed
     * @param file to check
     * @param info FileInfo of the file to check, containing at
     *             least size, mtime and type (but not necessarily
     *             mime type)
     * @return true, if the file has been queued, false otherwise.
     */
static gboolean
rygel_media_export_harvesting_task_push_if_changed_or_unknown (RygelMediaExportHarvestingTask* self,
                                                               GFile* file,
                                                               GFileInfo* info)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	{
		gint64 timestamp = 0LL;
		gint64 size = 0LL;
		gchar* mime_type = NULL;
		gboolean is_cached = FALSE;
		RygelMediaExportMediaCache* _tmp0_;
		gint64 _tmp1_ = 0LL;
		gint64 _tmp2_ = 0LL;
		gchar* _tmp3_ = NULL;
		gboolean _tmp4_;
		const gchar* _tmp7_;
		FileQueueEntry* entry = NULL;
		const gchar* _tmp11_;
		FileQueueEntry* _tmp12_;
		GeeQueue* _tmp13_;
		FileQueueEntry* _tmp14_;
		_tmp0_ = self->priv->cache;
		_tmp4_ = rygel_media_export_media_cache_exists (_tmp0_, file, &_tmp1_, &_tmp2_, &_tmp3_, &_inner_error_);
		timestamp = _tmp1_;
		size = _tmp2_;
		_g_free0 (mime_type);
		mime_type = _tmp3_;
		is_cached = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (mime_type);
			goto __catch58_g_error;
		}
		if (is_cached) {
			gint64 mtime = 0LL;
			gboolean _tmp5_ = FALSE;
			const gchar* _tmp6_;
			mtime = (gint64) g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_TIME_MODIFIED);
			if (mtime <= timestamp) {
				_tmp5_ = g_file_info_get_size (info) == size;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				result = FALSE;
				_g_free0 (mime_type);
				return result;
			}
			_tmp6_ = mime_type;
			g_file_info_set_content_type (info, _tmp6_);
		}
		_tmp7_ = g_file_info_get_content_type (info);
		if (_tmp7_ == NULL) {
			GFileInfo* extended_info = NULL;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = g_file_query_info (file, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_MIME_TYPE_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
			extended_info = _tmp8_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (mime_type);
				goto __catch58_g_error;
			}
			_tmp9_ = extended_info;
			_tmp10_ = g_file_info_get_content_type (_tmp9_);
			g_file_info_set_content_type (info, _tmp10_);
			_g_object_unref0 (extended_info);
		}
		if (!rygel_media_export_harvester_is_eligible (file, info)) {
			result = FALSE;
			_g_free0 (mime_type);
			return result;
		}
		_tmp11_ = g_file_info_get_content_type (info);
		_tmp12_ = file_queue_entry_new (file, is_cached, _tmp11_);
		entry = _tmp12_;
		_tmp13_ = self->priv->files;
		_tmp14_ = entry;
		gee_queue_offer (_tmp13_, _tmp14_);
		result = TRUE;
		_file_queue_entry_unref0 (entry);
		_g_free0 (mime_type);
		return result;
	}
	goto __finally58;
	__catch58_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = _error_;
		_tmp16_ = _tmp15_->message;
		g_warning (_ ("Failed to query database: %s"), _tmp16_);
		_g_error_free0 (_error_);
	}
	__finally58:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp17_;
	}
	result = FALSE;
	return result;
}

static gboolean
rygel_media_export_harvesting_task_process_file (RygelMediaExportHarvestingTask* self,
                                                 GFile* file,
                                                 GFileInfo* info,
                                                 RygelMediaContainer* parent)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	g_return_val_if_fail (parent != NULL, FALSE);
	if (g_file_info_get_is_hidden (info)) {
		result = FALSE;
		return result;
	}
	if (g_file_info_get_file_type (info) == G_FILE_TYPE_DIRECTORY) {
		GFile* _tmp0_;
		GFile* _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = g_file_get_child (file, "VIDEO_TS");
		_tmp1_ = _tmp0_;
		_tmp2_ = g_file_query_exists (_tmp1_, NULL);
		_g_object_unref0 (_tmp1_);
		if (_tmp2_) {
			g_file_info_set_file_type (info, G_FILE_TYPE_REGULAR);
			g_file_info_set_content_type (info, "application/x-cd-image");
		}
	}
	if (g_file_info_get_file_type (info) == G_FILE_TYPE_DIRECTORY) {
		RygelMediaExportRecursiveFileMonitor* _tmp3_;
		RygelMediaExportDummyContainer* container = NULL;
		RygelMediaExportDummyContainer* _tmp4_;
		GQueue* _tmp5_;
		RygelMediaExportDummyContainer* _tmp6_;
		RygelMediaContainer* _tmp7_;
		RygelMediaExportDummyContainer* dummy_parent = NULL;
		RygelMediaExportDummyContainer* _tmp8_;
		gboolean _tmp9_ = FALSE;
		RygelMediaExportDummyContainer* _tmp10_;
		_tmp3_ = self->priv->monitor;
		rygel_media_export_recursive_file_monitor_add (_tmp3_, file, NULL, NULL);
		_tmp4_ = rygel_media_export_dummy_container_new (file, parent);
		container = _tmp4_;
		_tmp5_ = self->priv->containers;
		_tmp6_ = container;
		_tmp7_ = _g_object_ref0 ((RygelMediaContainer*) _tmp6_);
		g_queue_push_tail (_tmp5_, _tmp7_);
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (parent, RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER) ? ((RygelMediaExportDummyContainer*) parent) : NULL);
		dummy_parent = _tmp8_;
		_tmp10_ = dummy_parent;
		if (_tmp10_ == NULL) {
			_tmp9_ = TRUE;
		} else {
			RygelMediaExportDummyContainer* _tmp11_;
			GeeList* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp11_ = dummy_parent;
			_tmp12_ = _tmp11_->children;
			_tmp13_ = rygel_media_export_media_cache_get_id (file);
			_tmp14_ = _tmp13_;
			_tmp9_ = !gee_collection_contains ((GeeCollection*) _tmp12_, _tmp14_);
			_g_free0 (_tmp14_);
		}
		if (_tmp9_) {
			RygelMediaExportDummyContainer* _tmp15_;
			_tmp15_ = container;
			rygel_trackable_container_add_child_tracked (G_TYPE_CHECK_INSTANCE_TYPE (parent, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) parent) : NULL, (RygelMediaObject*) _tmp15_, NULL, NULL);
		}
		result = TRUE;
		_g_object_unref0 (dummy_parent);
		_g_object_unref0 (container);
		return result;
	} else {
		result = rygel_media_export_harvesting_task_push_if_changed_or_unknown (self, file, info);
		return result;
	}
}

static gboolean
rygel_media_export_harvesting_task_process_children (RygelMediaExportHarvestingTask* self,
                                                     GList* list)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	RygelMediaExportDummyContainer* container = NULL;
	GQueue* _tmp3_;
	gconstpointer _tmp4_;
	RygelMediaContainer* _tmp5_;
	RygelMediaExportDummyContainer* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (list == NULL) {
		_tmp0_ = TRUE;
	} else {
		GCancellable* _tmp1_;
		GCancellable* _tmp2_;
		_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp2_ = _tmp1_;
		_tmp0_ = g_cancellable_is_cancelled (_tmp2_);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->containers;
	_tmp4_ = g_queue_peek_head (_tmp3_);
	_tmp5_ = (RygelMediaContainer*) _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER) ? ((RygelMediaExportDummyContainer*) _tmp5_) : NULL);
	container = _tmp6_;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = list;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			GFileInfo* _tmp7_;
			GFileInfo* info = NULL;
			_tmp7_ = _g_object_ref0 ((GFileInfo*) info_it->data);
			info = _tmp7_;
			{
				GFile* file = NULL;
				RygelMediaExportDummyContainer* _tmp8_;
				GFile* _tmp9_;
				GFileInfo* _tmp10_;
				const gchar* _tmp11_;
				GFile* _tmp12_;
				GFile* _tmp13_;
				GFileInfo* _tmp14_;
				RygelMediaExportDummyContainer* _tmp15_;
				RygelMediaExportDummyContainer* _tmp16_;
				GFile* _tmp17_;
				_tmp8_ = container;
				_tmp9_ = _tmp8_->file;
				_tmp10_ = info;
				_tmp11_ = g_file_info_get_name (_tmp10_);
				_tmp12_ = g_file_get_child (_tmp9_, _tmp11_);
				file = _tmp12_;
				_tmp13_ = file;
				_tmp14_ = info;
				_tmp15_ = container;
				rygel_media_export_harvesting_task_process_file (self, _tmp13_, _tmp14_, (RygelMediaContainer*) _tmp15_);
				_tmp16_ = container;
				_tmp17_ = file;
				rygel_media_export_dummy_container_seen (_tmp16_, _tmp17_);
				_g_object_unref0 (file);
				_g_object_unref0 (info);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (container);
	return result;
}

static void
rygel_media_export_harvesting_task_enumerate_directory_data_free (gpointer _data)
{
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportHarvestingTaskEnumerateDirectoryData, _data_);
}

static void
rygel_media_export_harvesting_task_enumerate_directory_async_ready_wrapper (GObject *source_object,
                                                                            GAsyncResult *res,
                                                                            void *user_data)
{
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static void
rygel_media_export_harvesting_task_enumerate_directory (RygelMediaExportHarvestingTask* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	RygelMediaExportHarvestingTask* _tmp0_;
	_data_ = g_slice_new0 (RygelMediaExportHarvestingTaskEnumerateDirectoryData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_media_export_harvesting_task_enumerate_directory_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_harvesting_task_enumerate_directory_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_harvesting_task_enumerate_directory_co (_data_);
}

static void
rygel_media_export_harvesting_task_enumerate_directory_finish (RygelMediaExportHarvestingTask* self,
                                                               GAsyncResult* _res_)
{
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_media_export_harvesting_task_enumerate_directory_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_media_export_harvesting_task_enumerate_directory_co (_data_);
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
rygel_media_export_harvesting_task_enumerate_directory_co (RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->containers;
	_data_->_tmp1_ = g_queue_peek_head (_data_->_tmp0_);
	_data_->_tmp2_ = (RygelMediaContainer*) _data_->_tmp1_;
	_data_->_tmp3_ = (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp2_, RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER) ? ((RygelMediaExportDummyContainer*) _data_->_tmp2_) : NULL)->file;
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	_data_->directory = _data_->_tmp4_;
	{
		_data_->_tmp5_ = _data_->directory;
		_data_->_tmp6_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp5_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp7_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = g_file_enumerate_children_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
		_data_->enumerator = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch59_g_error;
		}
		_data_->list = NULL;
		{
			_data_->_tmp9_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp9_) {
					_data_->_tmp10_ = _data_->list;
					if (!rygel_media_export_harvesting_task_process_children (_data_->self, _data_->_tmp10_)) {
						break;
					}
				}
				_data_->_tmp9_ = FALSE;
				_data_->_tmp12_ = _data_->enumerator;
				_data_->_tmp13_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
				_data_->_tmp14_ = _data_->_tmp13_;
				_data_->_state_ = 2;
				g_file_enumerator_next_files_async (_data_->_tmp12_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_BATCH_SIZE, G_PRIORITY_DEFAULT, _data_->_tmp14_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp15_ = g_file_enumerator_next_files_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error_);
				_data_->_tmp11_ = _data_->_tmp15_;
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					(_data_->list == NULL) ? NULL : (_data_->list = (_g_list_free__g_object_unref0_ (_data_->list), NULL));
					_g_object_unref0 (_data_->enumerator);
					goto __catch59_g_error;
				}
				_data_->_tmp16_ = _data_->_tmp11_;
				_data_->_tmp11_ = NULL;
				(_data_->list == NULL) ? NULL : (_data_->list = (_g_list_free__g_object_unref0_ (_data_->list), NULL));
				_data_->list = _data_->_tmp16_;
				(_data_->_tmp11_ == NULL) ? NULL : (_data_->_tmp11_ = (_g_list_free__g_object_unref0_ (_data_->_tmp11_), NULL));
			}
		}
		_data_->_tmp17_ = _data_->enumerator;
		_data_->_tmp18_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_state_ = 3;
		g_file_enumerator_close_async (_data_->_tmp17_, G_PRIORITY_DEFAULT, _data_->_tmp19_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
		return FALSE;
		_state_3:
		g_file_enumerator_close_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			(_data_->list == NULL) ? NULL : (_data_->list = (_g_list_free__g_object_unref0_ (_data_->list), NULL));
			_g_object_unref0 (_data_->enumerator);
			goto __catch59_g_error;
		}
		(_data_->list == NULL) ? NULL : (_data_->list = (_g_list_free__g_object_unref0_ (_data_->list), NULL));
		_g_object_unref0 (_data_->enumerator);
	}
	goto __finally59;
	__catch59_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp20_ = _data_->directory;
		_data_->_tmp21_ = g_file_get_path (_data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = _data_->err;
		_data_->_tmp24_ = _data_->_tmp23_->message;
		g_warning (_ ("Failed to enumerate folder “%s”: %s"), _data_->_tmp22_, _data_->_tmp24_);
		_g_free0 (_data_->_tmp22_);
		_g_error_free0 (_data_->err);
	}
	__finally59:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	rygel_media_export_harvesting_task_cleanup_database (_data_->self);
	rygel_media_export_harvesting_task_do_update (_data_->self);
	_g_object_unref0 (_data_->directory);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_media_export_harvesting_task_cleanup_database (RygelMediaExportHarvestingTask* self)
{
	RygelMediaExportDummyContainer* container = NULL;
	GQueue* _tmp0_;
	gconstpointer _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelMediaExportDummyContainer* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->containers;
	_tmp1_ = g_queue_peek_head (_tmp0_);
	_tmp2_ = (RygelMediaContainer*) _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER) ? ((RygelMediaExportDummyContainer*) _tmp2_) : NULL);
	container = _tmp3_;
	{
		{
			GeeList* _child_list = NULL;
			RygelMediaExportDummyContainer* _tmp4_;
			GeeList* _tmp5_;
			GeeList* _tmp6_;
			gint _child_size = 0;
			GeeList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _child_index = 0;
			_tmp4_ = container;
			_tmp5_ = _tmp4_->children;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_child_list = _tmp6_;
			_tmp7_ = _child_list;
			_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_child_size = _tmp9_;
			_child_index = -1;
			while (TRUE) {
				gchar* child = NULL;
				GeeList* _tmp10_;
				gpointer _tmp11_;
				RygelMediaExportMediaCache* _tmp12_;
				const gchar* _tmp13_;
				_child_index = _child_index + 1;
				if (!(_child_index < _child_size)) {
					break;
				}
				_tmp10_ = _child_list;
				_tmp11_ = gee_list_get (_tmp10_, _child_index);
				child = (gchar*) _tmp11_;
				_tmp12_ = self->priv->cache;
				_tmp13_ = child;
				rygel_media_export_media_cache_remove_by_id (_tmp12_, _tmp13_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (child);
					_g_object_unref0 (_child_list);
					if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch60_rygel_database_database_error;
					}
					_g_free0 (child);
					_g_object_unref0 (_child_list);
					_g_object_unref0 (container);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (child);
			}
			_g_object_unref0 (_child_list);
		}
	}
	goto __finally60;
	__catch60_rygel_database_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaExportDummyContainer* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = container;
		_tmp15_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _error_;
		_tmp18_ = _tmp17_->message;
		g_warning (_ ("Failed to get children of container %s: %s"), _tmp16_, _tmp18_);
		_g_error_free0 (_error_);
	}
	__finally60:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (container);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (container);
}

static gboolean
rygel_media_export_harvesting_task_on_idle (RygelMediaExportHarvestingTask* self)
{
	gboolean result = FALSE;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GeeQueue* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = _tmp0_;
	if (g_cancellable_is_cancelled (_tmp1_)) {
		g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->files;
	_tmp3_ = gee_collection_get_is_empty ((GeeCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		GeeQueue* _tmp5_;
		gpointer _tmp6_;
		FileQueueEntry* _tmp7_;
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		RygelMediaExportMetadataExtractor* _tmp11_;
		GeeQueue* _tmp12_;
		gpointer _tmp13_;
		FileQueueEntry* _tmp14_;
		GFile* _tmp15_;
		GeeQueue* _tmp16_;
		gpointer _tmp17_;
		FileQueueEntry* _tmp18_;
		const gchar* _tmp19_;
		_tmp5_ = self->priv->files;
		_tmp6_ = gee_queue_peek (_tmp5_);
		_tmp7_ = (FileQueueEntry*) _tmp6_;
		_tmp8_ = _tmp7_->file;
		_tmp9_ = g_file_get_uri (_tmp8_);
		_tmp10_ = _tmp9_;
		g_debug ("rygel-media-export-harvesting-task.vala:300: Scheduling file %s for me" \
"ta-data extraction…", _tmp10_);
		_g_free0 (_tmp10_);
		_file_queue_entry_unref0 (_tmp7_);
		_tmp11_ = self->priv->extractor;
		_tmp12_ = self->priv->files;
		_tmp13_ = gee_queue_peek (_tmp12_);
		_tmp14_ = (FileQueueEntry*) _tmp13_;
		_tmp15_ = _tmp14_->file;
		_tmp16_ = self->priv->files;
		_tmp17_ = gee_queue_peek (_tmp16_);
		_tmp18_ = (FileQueueEntry*) _tmp17_;
		_tmp19_ = _tmp18_->content_type;
		rygel_media_export_metadata_extractor_extract (_tmp11_, _tmp15_, _tmp19_);
		_file_queue_entry_unref0 (_tmp18_);
		_file_queue_entry_unref0 (_tmp14_);
	} else {
		GQueue* _tmp20_;
		_tmp20_ = self->priv->containers;
		if (!g_queue_is_empty (_tmp20_)) {
			rygel_media_export_harvesting_task_enumerate_directory (self, NULL, NULL);
		} else {
			GFile* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			GTimer* _tmp24_;
			gdouble _tmp25_;
			g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
			_tmp21_ = self->origin;
			_tmp22_ = g_file_get_uri (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = self->priv->timer;
			_tmp25_ = g_timer_elapsed (_tmp24_, NULL);
			g_message ("rygel-media-export-harvesting-task.vala:309: Harvesting of %s done in " \
"%f", _tmp23_, _tmp25_);
			_g_free0 (_tmp23_);
		}
	}
	result = FALSE;
	return result;
}

static void
rygel_media_export_harvesting_task_on_extracted_cb (RygelMediaExportHarvestingTask* self,
                                                    GFile* file,
                                                    GVariant* info)
{
	GeeQueue* _tmp0_;
	gpointer _tmp1_;
	FileQueueEntry* _tmp2_;
	GFile* _tmp3_;
	gboolean _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GeeQueue* _tmp21_;
	gpointer _tmp22_;
	FileQueueEntry* _tmp23_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->files;
	_tmp1_ = gee_queue_peek (_tmp0_);
	_tmp2_ = (FileQueueEntry*) _tmp1_;
	_tmp3_ = _tmp2_->file;
	_tmp4_ = !g_file_equal (file, _tmp3_);
	_file_queue_entry_unref0 (_tmp2_);
	if (_tmp4_) {
		g_debug ("rygel-media-export-harvesting-task.vala:320: Not for us, ignoring");
	}
	_tmp5_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp6_ = _tmp5_;
	if (g_cancellable_is_cancelled (_tmp6_)) {
		g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	}
	{
		RygelMediaContainer* parent = NULL;
		GQueue* _tmp7_;
		gconstpointer _tmp8_;
		RygelMediaContainer* _tmp9_;
		RygelMediaObject* item = NULL;
		RygelMediaObject* _tmp10_;
		_tmp7_ = self->priv->containers;
		_tmp8_ = g_queue_peek_head (_tmp7_);
		_tmp9_ = _g_object_ref0 ((RygelMediaContainer*) _tmp8_);
		parent = _tmp9_;
		_tmp10_ = rygel_media_export_item_factory_create_from_variant (parent, file, info, &_inner_error_);
		item = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (parent);
			goto __catch61_g_error;
		}
		if (item != NULL) {
			GeeQueue* _tmp11_;
			gpointer _tmp12_;
			FileQueueEntry* _tmp13_;
			gboolean _tmp14_;
			rygel_media_object_set_parent_ref (item, parent);
			_tmp11_ = self->priv->files;
			_tmp12_ = gee_queue_peek (_tmp11_);
			_tmp13_ = (FileQueueEntry*) _tmp12_;
			_tmp14_ = _tmp13_->known;
			_file_queue_entry_unref0 (_tmp13_);
			if (_tmp14_) {
				rygel_media_export_updatable_object_non_overriding_commit (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT) ? ((RygelMediaExportUpdatableObject*) item) : NULL, NULL, NULL);
			} else {
				RygelTrackableContainer* container = NULL;
				RygelMediaContainer* _tmp15_;
				RygelMediaContainer* _tmp16_;
				RygelTrackableContainer* _tmp17_;
				RygelTrackableContainer* _tmp18_;
				_tmp15_ = rygel_media_object_get_parent (item);
				_tmp16_ = _tmp15_;
				_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _tmp16_) : NULL);
				container = _tmp17_;
				_tmp18_ = container;
				rygel_trackable_container_add_child_tracked (_tmp18_, item, NULL, NULL);
				_g_object_unref0 (container);
			}
		}
		_g_object_unref0 (item);
		_g_object_unref0 (parent);
	}
	goto __finally61;
	__catch61_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = _error_;
		_tmp20_ = _tmp19_->message;
		g_warning ("rygel-media-export-harvesting-task.vala:345: Failed to extract meta-da" \
"ta for file %s", _tmp20_);
		_g_error_free0 (_error_);
	}
	__finally61:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp21_ = self->priv->files;
	_tmp22_ = gee_queue_poll (_tmp21_);
	_tmp23_ = (FileQueueEntry*) _tmp22_;
	_file_queue_entry_unref0 (_tmp23_);
	rygel_media_export_harvesting_task_do_update (self);
}

static void
rygel_media_export_harvesting_task_on_extractor_error_cb (RygelMediaExportHarvestingTask* self,
                                                          GFile* file,
                                                          GError* _error_)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	RygelMediaExportMediaCache* _tmp3_;
	GeeQueue* _tmp4_;
	gpointer _tmp5_;
	FileQueueEntry* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = _error_->message;
	g_warning (_ ("Skipping URI %s; extraction completely failed: %s"), _tmp1_, _tmp2_);
	_g_free0 (_tmp1_);
	_tmp3_ = self->priv->cache;
	rygel_media_export_media_cache_blacklist (_tmp3_, file);
	_tmp4_ = self->priv->files;
	_tmp5_ = gee_queue_poll (_tmp4_);
	_tmp6_ = (FileQueueEntry*) _tmp5_;
	_file_queue_entry_unref0 (_tmp6_);
	rygel_media_export_harvesting_task_do_update (self);
}

/**
     * If all files of a container were processed, notify the container
     * about this and set the updating signal.
     * Reschedule the iteration and extraction
     */
static void
rygel_media_export_harvesting_task_do_update (RygelMediaExportHarvestingTask* self)
{
	gboolean _tmp0_ = FALSE;
	GeeQueue* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->files;
	_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GQueue* _tmp4_;
		_tmp4_ = self->priv->containers;
		_tmp0_ = !g_queue_is_empty (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GQueue* _tmp5_;
		gpointer _tmp6_;
		RygelMediaContainer* _tmp7_;
		_tmp5_ = self->priv->containers;
		_tmp6_ = g_queue_pop_head (_tmp5_);
		_tmp7_ = (RygelMediaContainer*) _tmp6_;
		_g_object_unref0 (_tmp7_);
	}
	rygel_media_export_harvesting_task_on_idle (self);
}

static GCancellable*
rygel_media_export_harvesting_task_real_get_cancellable (RygelStateMachine* base)
{
	GCancellable* result;
	RygelMediaExportHarvestingTask* self;
	GCancellable* _tmp0_;
	self = (RygelMediaExportHarvestingTask*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}

static void
rygel_media_export_harvesting_task_real_set_cancellable (RygelStateMachine* base,
                                                         GCancellable* value)
{
	RygelMediaExportHarvestingTask* self;
	self = (RygelMediaExportHarvestingTask*) base;
	if (rygel_media_export_harvesting_task_real_get_cancellable (base) != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cancellable);
		self->priv->_cancellable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_export_harvesting_task_properties[RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE_PROPERTY]);
	}
}

static void
rygel_media_export_harvesting_task_class_init (RygelMediaExportHarvestingTaskClass * klass)
{
	rygel_media_export_harvesting_task_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaExportHarvestingTask_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_harvesting_task_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_harvesting_task_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvesting_task_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE_PROPERTY, rygel_media_export_harvesting_task_properties[RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_media_export_harvesting_task_rygel_state_machine_interface_init (RygelStateMachineIface * iface)
{
	rygel_media_export_harvesting_task_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*) (RygelStateMachine*, GAsyncReadyCallback, gpointer)) rygel_media_export_harvesting_task_real_run;
	iface->run_finish = (void (*) (RygelStateMachine*, GAsyncResult*)) rygel_media_export_harvesting_task_real_run_finish;
	iface->get_cancellable = rygel_media_export_harvesting_task_real_get_cancellable;
	iface->set_cancellable = rygel_media_export_harvesting_task_real_set_cancellable;
}

static void
rygel_media_export_harvesting_task_instance_init (RygelMediaExportHarvestingTask * self)
{
	self->priv = rygel_media_export_harvesting_task_get_instance_private (self);
}

static void
rygel_media_export_harvesting_task_finalize (GObject * obj)
{
	RygelMediaExportHarvestingTask * self;
	RygelMediaExportMetadataExtractor* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask);
	_tmp0_ = self->priv->extractor;
	rygel_media_export_metadata_extractor_stop (_tmp0_);
	_g_object_unref0 (self->origin);
	_g_timer_destroy0 (self->priv->timer);
	_g_object_unref0 (self->priv->extractor);
	_g_object_unref0 (self->priv->cache);
	(self->priv->containers == NULL) ? NULL : (self->priv->containers = (_g_queue_free__g_object_unref0_ (self->priv->containers), NULL));
	_g_object_unref0 (self->priv->files);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->parent);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_media_export_harvesting_task_parent_class)->finalize (obj);
}

GType
rygel_media_export_harvesting_task_get_type (void)
{
	static volatile gsize rygel_media_export_harvesting_task_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvesting_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvestingTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvesting_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvestingTask), 0, (GInstanceInitFunc) rygel_media_export_harvesting_task_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_media_export_harvesting_task_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_export_harvesting_task_type_id;
		rygel_media_export_harvesting_task_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvestingTask", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_media_export_harvesting_task_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		RygelMediaExportHarvestingTask_private_offset = g_type_add_instance_private (rygel_media_export_harvesting_task_type_id, sizeof (RygelMediaExportHarvestingTaskPrivate));
		g_once_init_leave (&rygel_media_export_harvesting_task_type_id__volatile, rygel_media_export_harvesting_task_type_id);
	}
	return rygel_media_export_harvesting_task_type_id__volatile;
}

static void
_vala_rygel_media_export_harvesting_task_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	RygelMediaExportHarvestingTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE_PROPERTY:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_media_export_harvesting_task_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	RygelMediaExportHarvestingTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE_PROPERTY:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

