/* rygel-http-subtitle-handler.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-http-subtitle-handler.vala, do not modify */

/*
 * Copyright (C) 2008, 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <glib.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <rygel-core.h>
#include <libgupnp-av/gupnp-av.h>

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_SUBTITLE_HANDLER (rygel_http_subtitle_handler_get_type ())
#define RYGEL_HTTP_SUBTITLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandler))
#define RYGEL_HTTP_SUBTITLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandlerClass))
#define RYGEL_IS_HTTP_SUBTITLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER))
#define RYGEL_IS_HTTP_SUBTITLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER))
#define RYGEL_HTTP_SUBTITLE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandlerClass))

typedef struct _RygelHTTPSubtitleHandler RygelHTTPSubtitleHandler;
typedef struct _RygelHTTPSubtitleHandlerClass RygelHTTPSubtitleHandlerClass;
typedef struct _RygelHTTPSubtitleHandlerPrivate RygelHTTPSubtitleHandlerPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;
enum  {
	RYGEL_HTTP_SUBTITLE_HANDLER_0_PROPERTY,
	RYGEL_HTTP_SUBTITLE_HANDLER_NUM_PROPERTIES
};
static GParamSpec* rygel_http_subtitle_handler_properties[RYGEL_HTTP_SUBTITLE_HANDLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gchar* (*get_default_transfer_mode) (RygelHTTPGetHandler* self);
	gboolean (*supports_transfer_mode) (RygelHTTPGetHandler* self, const gchar* mode);
	gint64 (*get_resource_size) (RygelHTTPGetHandler* self);
	gint64 (*get_resource_duration) (RygelHTTPGetHandler* self);
	gboolean (*supports_byte_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_time_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_playspeed) (RygelHTTPGetHandler* self);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPSubtitleHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPSubtitleHandlerPrivate * priv;
	RygelSubtitle* subtitle;
};

struct _RygelHTTPSubtitleHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPSubtitleHandlerPrivate {
	RygelMediaFileItem* media_item;
	gint subtitle_index;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

static gint RygelHTTPSubtitleHandler_private_offset;
static gpointer rygel_http_subtitle_handler_parent_class = NULL;

GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_http_subtitle_handler_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void rygel_value_set_subtitle (GValue* value,
                               gpointer v_object);
void rygel_value_take_subtitle (GValue* value,
                                gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
RygelHTTPSubtitleHandler* rygel_http_subtitle_handler_new (RygelMediaFileItem* media_item,
                                                           gint subtitle_index,
                                                           GCancellable* cancellable,
                                                           GError** error);
RygelHTTPSubtitleHandler* rygel_http_subtitle_handler_construct (GType object_type,
                                                                 RygelMediaFileItem* media_item,
                                                                 gint subtitle_index,
                                                                 GCancellable* cancellable,
                                                                 GError** error);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
void rygel_http_get_handler_set_cancellable (RygelHTTPGetHandler* self,
                                             GCancellable* value);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_video_item_get_subtitles (RygelVideoItem* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
static gboolean rygel_http_subtitle_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base,
                                                                  const gchar* mode);
#define RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_STREAMING "Streaming"
static void rygel_http_subtitle_handler_real_add_response_headers (RygelHTTPGetHandler* base,
                                                            RygelHTTPGet* request,
                                                            GError** error);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GeeList* rygel_media_object_get_resource_list (RygelMediaObject* self);
GUPnPProtocolInfo* rygel_media_resource_get_protocol_info (RygelMediaResource* self,
                                                           GHashTable* replacements);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self,
                                                  RygelHTTPGet* request,
                                                  GError** error);
static RygelHTTPResponse* rygel_http_subtitle_handler_real_render_body (RygelHTTPGetHandler* base,
                                                                 RygelHTTPGet* request,
                                                                 GError** error);
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
RygelMediaEngine* rygel_media_engine_get_default (void);
RygelDataSource* rygel_media_engine_create_data_source_for_uri (RygelMediaEngine* self,
                                                                const gchar* uri,
                                                                GError** error);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request,
                                            RygelHTTPGetHandler* request_handler,
                                            RygelDataSource* src,
                                            GError** error);
RygelHTTPResponse* rygel_http_response_construct (GType object_type,
                                                  RygelHTTPGet* request,
                                                  RygelHTTPGetHandler* request_handler,
                                                  RygelDataSource* src,
                                                  GError** error);
static gint64 rygel_http_subtitle_handler_real_get_resource_size (RygelHTTPGetHandler* base);
static gboolean rygel_http_subtitle_handler_real_supports_byte_seek (RygelHTTPGetHandler* base);
static void rygel_http_subtitle_handler_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
rygel_http_subtitle_handler_get_instance_private (RygelHTTPSubtitleHandler* self)
{
	return G_STRUCT_MEMBER_P (self, RygelHTTPSubtitleHandler_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelHTTPSubtitleHandler*
rygel_http_subtitle_handler_construct (GType object_type,
                                       RygelMediaFileItem* media_item,
                                       gint subtitle_index,
                                       GCancellable* cancellable,
                                       GError** error)
{
	RygelHTTPSubtitleHandler * self = NULL;
	RygelMediaFileItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelSubtitle* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (media_item != NULL, NULL);
	self = (RygelHTTPSubtitleHandler*) rygel_http_get_handler_construct (object_type);
	_tmp0_ = _g_object_ref0 (media_item);
	_g_object_unref0 (self->priv->media_item);
	self->priv->media_item = _tmp0_;
	self->priv->subtitle_index = subtitle_index;
	rygel_http_get_handler_set_cancellable ((RygelHTTPGetHandler*) self, cancellable);
	if (subtitle_index >= 0) {
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (media_item, RYGEL_TYPE_VIDEO_ITEM);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		RygelVideoItem* video_item = NULL;
		RygelVideoItem* _tmp2_;
		RygelVideoItem* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (media_item, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) media_item) : NULL);
		video_item = _tmp2_;
		_tmp3_ = video_item;
		_tmp4_ = rygel_video_item_get_subtitles (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (subtitle_index < _tmp7_) {
			RygelVideoItem* _tmp8_;
			GeeArrayList* _tmp9_;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			_tmp8_ = video_item;
			_tmp9_ = rygel_video_item_get_subtitles (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, subtitle_index);
			_rygel_subtitle_unref0 (self->subtitle);
			self->subtitle = (RygelSubtitle*) _tmp11_;
		}
		_g_object_unref0 (video_item);
	}
	_tmp12_ = self->subtitle;
	if (_tmp12_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		GError* _tmp17_;
		_tmp13_ = g_strdup ("Subtitle index %d not found for item '%s");
		msg = _tmp13_;
		_tmp14_ = msg;
		_tmp15_ = rygel_media_object_get_id ((RygelMediaObject*) media_item);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp14_, subtitle_index, _tmp16_);
		_inner_error_ = _tmp17_;
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	return self;
}

RygelHTTPSubtitleHandler*
rygel_http_subtitle_handler_new (RygelMediaFileItem* media_item,
                                 gint subtitle_index,
                                 GCancellable* cancellable,
                                 GError** error)
{
	return rygel_http_subtitle_handler_construct (RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, media_item, subtitle_index, cancellable, error);
}

static gboolean
rygel_http_subtitle_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base,
                                                         const gchar* mode)
{
	RygelHTTPSubtitleHandler * self;
	gboolean result = FALSE;
	self = (RygelHTTPSubtitleHandler*) base;
	g_return_val_if_fail (mode != NULL, FALSE);
	result = g_strcmp0 (mode, RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_STREAMING) != 0;
	return result;
}

static void
rygel_http_subtitle_handler_real_add_response_headers (RygelHTTPGetHandler* base,
                                                       RygelHTTPGet* request,
                                                       GError** error)
{
	RygelHTTPSubtitleHandler * self;
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	RygelSubtitle* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaResource* res = NULL;
	RygelMediaFileItem* _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	gpointer _tmp7_;
	RygelMediaResource* _tmp8_;
	gchar* protocol_info = NULL;
	GUPnPProtocolInfo* _tmp9_;
	GUPnPProtocolInfo* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** pi_fields = NULL;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint pi_fields_length1;
	gint _pi_fields_size_;
	SoupMessage* _tmp15_;
	SoupMessageHeaders* _tmp16_;
	const gchar* _tmp17_;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPSubtitleHandler*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = ((RygelHTTPRequest*) request)->msg;
	_tmp1_ = _tmp0_->response_headers;
	_tmp2_ = self->subtitle;
	_tmp3_ = _tmp2_->mime_type;
	soup_message_headers_append (_tmp1_, "Content-Type", _tmp3_);
	_tmp4_ = self->priv->media_item;
	_tmp5_ = rygel_media_object_get_resource_list ((RygelMediaObject*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_list_get (_tmp6_, 0);
	_tmp8_ = (RygelMediaResource*) _tmp7_;
	_g_object_unref0 (_tmp6_);
	res = _tmp8_;
	_tmp9_ = rygel_media_resource_get_protocol_info (res, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = gupnp_protocol_info_to_string (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	protocol_info = _tmp12_;
	_tmp14_ = _tmp13_ = g_strsplit (protocol_info, ":", 4);
	pi_fields = _tmp14_;
	pi_fields_length1 = _vala_array_length (_tmp13_);
	_pi_fields_size_ = pi_fields_length1;
	_tmp15_ = ((RygelHTTPRequest*) request)->msg;
	_tmp16_ = _tmp15_->response_headers;
	_tmp17_ = pi_fields[3];
	soup_message_headers_append (_tmp16_, "contentFeatures.dlna.org", _tmp17_);
	RYGEL_HTTP_GET_HANDLER_CLASS (rygel_http_subtitle_handler_parent_class)->add_response_headers (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler), request, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (protocol_info);
			_g_object_unref0 (res);
			return;
		} else {
			pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (protocol_info);
			_g_object_unref0 (res);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (protocol_info);
	_g_object_unref0 (res);
}

static RygelHTTPResponse*
rygel_http_subtitle_handler_real_render_body (RygelHTTPGetHandler* base,
                                              RygelHTTPGet* request,
                                              GError** error)
{
	RygelHTTPSubtitleHandler * self;
	RygelHTTPResponse* result = NULL;
	RygelDataSource* src = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPSubtitleHandler*) base;
	g_return_val_if_fail (request != NULL, NULL);
	{
		RygelMediaEngine* engine = NULL;
		RygelMediaEngine* _tmp0_;
		RygelDataSource* _tmp1_ = NULL;
		RygelMediaEngine* _tmp2_;
		RygelSubtitle* _tmp3_;
		const gchar* _tmp4_;
		RygelDataSource* _tmp5_;
		RygelDataSource* _tmp6_;
		RygelHTTPResponse* _tmp7_ = NULL;
		RygelDataSource* _tmp8_;
		RygelHTTPResponse* _tmp9_;
		RygelHTTPResponse* _tmp10_;
		_tmp0_ = rygel_media_engine_get_default ();
		engine = _tmp0_;
		_tmp2_ = engine;
		_tmp3_ = self->subtitle;
		_tmp4_ = _tmp3_->uri;
		_tmp5_ = rygel_media_engine_create_data_source_for_uri (_tmp2_, _tmp4_, &_inner_error_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (engine);
			goto __catch44_g_error;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (src);
		src = _tmp6_;
		_tmp8_ = src;
		_tmp9_ = rygel_http_response_new (request, (RygelHTTPGetHandler*) self, _tmp8_, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (engine);
			goto __catch44_g_error;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (engine);
		_g_object_unref0 (src);
		return result;
	}
	goto __finally44;
	__catch44_g_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp13_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = err;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp12_);
		_inner_error_ = _tmp13_;
		_g_error_free0 (err);
		goto __finally44;
	}
	__finally44:
	if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (src);
		return NULL;
	} else {
		_g_object_unref0 (src);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (src);
}

static gint64
rygel_http_subtitle_handler_real_get_resource_size (RygelHTTPGetHandler* base)
{
	RygelHTTPSubtitleHandler * self;
	gint64 result = 0LL;
	RygelSubtitle* _tmp0_;
	self = (RygelHTTPSubtitleHandler*) base;
	_tmp0_ = self->subtitle;
	result = _tmp0_->size;
	return result;
}

static gboolean
rygel_http_subtitle_handler_real_supports_byte_seek (RygelHTTPGetHandler* base)
{
	RygelHTTPSubtitleHandler * self;
	gboolean result = FALSE;
	self = (RygelHTTPSubtitleHandler*) base;
	result = TRUE;
	return result;
}

static void
rygel_http_subtitle_handler_class_init (RygelHTTPSubtitleHandlerClass * klass)
{
	rygel_http_subtitle_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelHTTPSubtitleHandler_private_offset);
	((RygelHTTPGetHandlerClass *) klass)->supports_transfer_mode = (gboolean (*) (RygelHTTPGetHandler*, const gchar*)) rygel_http_subtitle_handler_real_supports_transfer_mode;
	((RygelHTTPGetHandlerClass *) klass)->add_response_headers = (void (*) (RygelHTTPGetHandler*, RygelHTTPGet*, GError**)) rygel_http_subtitle_handler_real_add_response_headers;
	((RygelHTTPGetHandlerClass *) klass)->render_body = (RygelHTTPResponse* (*) (RygelHTTPGetHandler*, RygelHTTPGet*, GError**)) rygel_http_subtitle_handler_real_render_body;
	((RygelHTTPGetHandlerClass *) klass)->get_resource_size = (gint64 (*) (RygelHTTPGetHandler*)) rygel_http_subtitle_handler_real_get_resource_size;
	((RygelHTTPGetHandlerClass *) klass)->supports_byte_seek = (gboolean (*) (RygelHTTPGetHandler*)) rygel_http_subtitle_handler_real_supports_byte_seek;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_subtitle_handler_finalize;
}

static void
rygel_http_subtitle_handler_instance_init (RygelHTTPSubtitleHandler * self)
{
	self->priv = rygel_http_subtitle_handler_get_instance_private (self);
}

static void
rygel_http_subtitle_handler_finalize (GObject * obj)
{
	RygelHTTPSubtitleHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandler);
	_g_object_unref0 (self->priv->media_item);
	_rygel_subtitle_unref0 (self->subtitle);
	G_OBJECT_CLASS (rygel_http_subtitle_handler_parent_class)->finalize (obj);
}

GType
rygel_http_subtitle_handler_get_type (void)
{
	static volatile gsize rygel_http_subtitle_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_subtitle_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPSubtitleHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_subtitle_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPSubtitleHandler), 0, (GInstanceInitFunc) rygel_http_subtitle_handler_instance_init, NULL };
		GType rygel_http_subtitle_handler_type_id;
		rygel_http_subtitle_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPSubtitleHandler", &g_define_type_info, 0);
		RygelHTTPSubtitleHandler_private_offset = g_type_add_instance_private (rygel_http_subtitle_handler_type_id, sizeof (RygelHTTPSubtitleHandlerPrivate));
		g_once_init_leave (&rygel_http_subtitle_handler_type_id__volatile, rygel_http_subtitle_handler_type_id);
	}
	return rygel_http_subtitle_handler_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

