/* rygel-basic-management-test.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-basic-management-test.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Christophe Guiraud,
 *         Jussi Kukkonen
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <unistd.h>
#include <sys/types.h>
#include <glib/gi18n-lib.h>
#include <signal.h>

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST (rygel_basic_management_test_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest))
#define RYGEL_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))

typedef struct _RygelBasicManagementTest RygelBasicManagementTest;
typedef struct _RygelBasicManagementTestClass RygelBasicManagementTestClass;
typedef struct _RygelBasicManagementTestPrivate RygelBasicManagementTestPrivate;
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER
} RygelBasicManagementTestInitState;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_INIT_STATE (rygel_basic_management_test_init_state_get_type ())
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_CANCELED
} RygelBasicManagementTestExecutionState;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_EXECUTION_STATE (rygel_basic_management_test_execution_state_get_type ())
enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_0_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_CANCELLABLE_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_METHOD_TYPE_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_RESULTS_TYPE_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_NUM_PROPERTIES
};
static GParamSpec* rygel_basic_management_test_properties[RYGEL_BASIC_MANAGEMENT_TEST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelBasicManagementTestRunData RygelBasicManagementTestRunData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelBasicManagementTest {
	GObject parent_instance;
	RygelBasicManagementTestPrivate * priv;
	GCancellable* _cancellable;
	RygelBasicManagementTestInitState init_state;
	gchar* id;
	guint iterations;
	GSpawnFlags flags;
	gchar** command;
	gint command_length1;
	gint _command_size_;
};

struct _RygelBasicManagementTestClass {
	GObjectClass parent_class;
	void (*init_iteration) (RygelBasicManagementTest* self);
	void (*handle_output) (RygelBasicManagementTest* self, const gchar* line);
	void (*handle_error) (RygelBasicManagementTest* self, const gchar* line);
	gboolean (*finish_iteration) (RygelBasicManagementTest* self);
	void (*run) (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelBasicManagementTest* self, GAsyncResult* _res_);
	const gchar* (*get_method_type) (RygelBasicManagementTest* self);
	const gchar* (*get_results_type) (RygelBasicManagementTest* self);
};

struct _RygelBasicManagementTestPrivate {
	RygelBasicManagementTestExecutionState _execution_state;
	guint eof_count;
	gint std_out;
	gint std_err;
	GPid child_pid;
	GSourceFunc async_callback;
	gpointer async_callback_target;
	GDestroyNotify async_callback_target_destroy_notify;
	guint current_iteration;
};

struct _RygelBasicManagementTestRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelBasicManagementTest* self;
	RygelBasicManagementTestExecutionState _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
};

static gint RygelBasicManagementTest_private_offset;
static gpointer rygel_basic_management_test_parent_class = NULL;
static RygelStateMachineIface * rygel_basic_management_test_rygel_state_machine_parent_iface = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_init_state_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_execution_state_get_type (void) G_GNUC_CONST;
gchar* rygel_basic_management_test_execution_state_to_string (RygelBasicManagementTestExecutionState self);
void rygel_basic_management_test_init_iteration (RygelBasicManagementTest* self);
static void rygel_basic_management_test_real_init_iteration (RygelBasicManagementTest* self);
void rygel_basic_management_test_handle_output (RygelBasicManagementTest* self,
                                                const gchar* line);
static void rygel_basic_management_test_real_handle_output (RygelBasicManagementTest* self,
                                                     const gchar* line);
void rygel_basic_management_test_handle_error (RygelBasicManagementTest* self,
                                               const gchar* line);
static void rygel_basic_management_test_real_handle_error (RygelBasicManagementTest* self,
                                                    const gchar* line);
gboolean rygel_basic_management_test_finish_iteration (RygelBasicManagementTest* self);
static gboolean rygel_basic_management_test_real_finish_iteration (RygelBasicManagementTest* self);
RygelBasicManagementTestExecutionState rygel_basic_management_test_get_execution_state (RygelBasicManagementTest* self);
void rygel_basic_management_test_set_execution_state (RygelBasicManagementTest* self,
                                                      RygelBasicManagementTestExecutionState value);
static void rygel_basic_management_test_run_iteration (RygelBasicManagementTest* self);
static void rygel_basic_management_test_child_setup (RygelBasicManagementTest* self);
static gboolean _rygel_basic_management_test_finish_iteration_gsource_func (gpointer self);
static void _rygel_basic_management_test_child_setup_gspawn_child_setup_func (gpointer self);
static gboolean rygel_basic_management_test_out_watch (RygelBasicManagementTest* self,
                                                GIOChannel* channel,
                                                GIOCondition condition);
static gboolean _rygel_basic_management_test_out_watch_gio_func (GIOChannel* source,
                                                          GIOCondition condition,
                                                          gpointer self);
static gboolean rygel_basic_management_test_err_watch (RygelBasicManagementTest* self,
                                                GIOChannel* channel,
                                                GIOCondition condition);
static gboolean _rygel_basic_management_test_err_watch_gio_func (GIOChannel* source,
                                                          GIOCondition condition,
                                                          gpointer self);
const gchar* rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self);
gboolean rygel_basic_management_test_is_active (RygelBasicManagementTest* self);
static void rygel_basic_management_test_real_run_data_free (gpointer _data);
static void rygel_basic_management_test_real_run_async_ready_wrapper (GObject *source_object,
                                                               GAsyncResult *res,
                                                               void *user_data);
static void rygel_basic_management_test_real_run (RygelBasicManagementTest* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
void rygel_basic_management_test_run (RygelBasicManagementTest* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
void rygel_basic_management_test_run_finish (RygelBasicManagementTest* self,
                                             GAsyncResult* _res_);
static gboolean rygel_basic_management_test_real_run_co (RygelBasicManagementTestRunData* _data_);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
void rygel_state_machine_set_cancellable (RygelStateMachine* self,
                                          GCancellable* value);
static gboolean _rygel_basic_management_test_real_run_co_gsource_func (gpointer self);
RygelBasicManagementTest* rygel_basic_management_test_construct (GType object_type);
static void _rygel_basic_management_test_cancellable___lambda4_ (RygelBasicManagementTest* self);
static void __rygel_basic_management_test_cancellable___lambda4__g_cancellable_cancelled (GCancellable* _sender,
                                                                                   gpointer self);
const gchar* rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self);
static void rygel_basic_management_test_finalize (GObject * obj);
static void _vala_rygel_basic_management_test_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_rygel_basic_management_test_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
rygel_basic_management_test_get_instance_private (RygelBasicManagementTest* self)
{
	return G_STRUCT_MEMBER_P (self, RygelBasicManagementTest_private_offset);
}

GType
rygel_basic_management_test_init_state_get_type (void)
{
	static volatile gsize rygel_basic_management_test_init_state_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_init_state_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK, "RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK", "ok"}, {RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED, "RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED", "spawn-failed"}, {RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER, "RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER", "invalid-parameter"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_init_state_type_id;
		rygel_basic_management_test_init_state_type_id = g_enum_register_static ("RygelBasicManagementTestInitState", values);
		g_once_init_leave (&rygel_basic_management_test_init_state_type_id__volatile, rygel_basic_management_test_init_state_type_id);
	}
	return rygel_basic_management_test_init_state_type_id__volatile;
}

gchar*
rygel_basic_management_test_execution_state_to_string (RygelBasicManagementTestExecutionState self)
{
	gchar* result = NULL;
	switch (self) {
		case RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("Requested");
			result = _tmp0_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("InProgress");
			result = _tmp1_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("Completed");
			result = _tmp2_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_CANCELED:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Canceled");
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GType
rygel_basic_management_test_execution_state_get_type (void)
{
	static volatile gsize rygel_basic_management_test_execution_state_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_execution_state_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED, "RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED", "requested"}, {RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS, "RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS", "in-progress"}, {RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED, "RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED", "completed"}, {RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_CANCELED, "RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_CANCELED", "canceled"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_execution_state_type_id;
		rygel_basic_management_test_execution_state_type_id = g_enum_register_static ("RygelBasicManagementTestExecutionState", values);
		g_once_init_leave (&rygel_basic_management_test_execution_state_type_id__volatile, rygel_basic_management_test_execution_state_type_id);
	}
	return rygel_basic_management_test_execution_state_type_id__volatile;
}

static void
rygel_basic_management_test_real_init_iteration (RygelBasicManagementTest* self)
{
}

void
rygel_basic_management_test_init_iteration (RygelBasicManagementTest* self)
{
	g_return_if_fail (self != NULL);
	RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS (self)->init_iteration (self);
}

static void
rygel_basic_management_test_real_handle_output (RygelBasicManagementTest* self,
                                                const gchar* line)
{
	g_return_if_fail (line != NULL);
}

void
rygel_basic_management_test_handle_output (RygelBasicManagementTest* self,
                                           const gchar* line)
{
	g_return_if_fail (self != NULL);
	RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS (self)->handle_output (self, line);
}

static void
rygel_basic_management_test_real_handle_error (RygelBasicManagementTest* self,
                                               const gchar* line)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	g_return_if_fail (line != NULL);
	_tmp0_ = self->command;
	_tmp0__length1 = self->command_length1;
	_tmp1_ = _tmp0_[0];
	g_debug ("rygel-basic-management-test.vala:106: %s stderr: %s", _tmp1_, line);
}

void
rygel_basic_management_test_handle_error (RygelBasicManagementTest* self,
                                          const gchar* line)
{
	g_return_if_fail (self != NULL);
	RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS (self)->handle_error (self, line);
}

static gboolean
rygel_basic_management_test_real_finish_iteration (RygelBasicManagementTest* self)
{
	gboolean result = FALSE;
	guint _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelBasicManagementTestInitState _tmp2_;
	RygelBasicManagementTestExecutionState _tmp5_;
	_tmp0_ = self->priv->current_iteration;
	self->priv->current_iteration = _tmp0_ + 1;
	_tmp2_ = self->init_state;
	if (_tmp2_ != RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (self->priv->current_iteration >= self->iterations) {
			RygelBasicManagementTestExecutionState _tmp4_;
			_tmp4_ = self->priv->_execution_state;
			_tmp3_ = _tmp4_ == RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		rygel_basic_management_test_set_execution_state (self, RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED);
	}
	_tmp5_ = self->priv->_execution_state;
	if (_tmp5_ != RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS) {
		GSourceFunc _tmp6_;
		gpointer _tmp6__target;
		_tmp6_ = self->priv->async_callback;
		_tmp6__target = self->priv->async_callback_target;
		_tmp6_ (_tmp6__target);
	} else {
		rygel_basic_management_test_run_iteration (self);
	}
	result = FALSE;
	return result;
}

gboolean
rygel_basic_management_test_finish_iteration (RygelBasicManagementTest* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS (self)->finish_iteration (self);
}

static void
rygel_basic_management_test_child_setup (RygelBasicManagementTest* self)
{
	g_return_if_fail (self != NULL);
	g_setenv ("LC_MESSAGES", "C", TRUE);
	setsid ();
	setpgid ((pid_t) 0, (pid_t) 0);
}

static gboolean
_rygel_basic_management_test_finish_iteration_gsource_func (gpointer self)
{
	gboolean result;
	result = rygel_basic_management_test_finish_iteration ((RygelBasicManagementTest*) self);
	return result;
}

static void
_rygel_basic_management_test_child_setup_gspawn_child_setup_func (gpointer self)
{
	rygel_basic_management_test_child_setup ((RygelBasicManagementTest*) self);
}

static gboolean
_rygel_basic_management_test_out_watch_gio_func (GIOChannel* source,
                                                 GIOCondition condition,
                                                 gpointer self)
{
	gboolean result;
	result = rygel_basic_management_test_out_watch ((RygelBasicManagementTest*) self, source, condition);
	return result;
}

static gboolean
_rygel_basic_management_test_err_watch_gio_func (GIOChannel* source,
                                                 GIOCondition condition,
                                                 gpointer self)
{
	gboolean result;
	result = rygel_basic_management_test_err_watch ((RygelBasicManagementTest*) self, source, condition);
	return result;
}

static void
rygel_basic_management_test_run_iteration (RygelBasicManagementTest* self)
{
	RygelBasicManagementTestInitState _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_basic_management_test_init_iteration (self);
	_tmp0_ = self->init_state;
	if (_tmp0_ != RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_basic_management_test_finish_iteration_gsource_func, g_object_ref (self), g_object_unref);
		return;
	}
	{
		gchar** _tmp1_;
		gint _tmp1__length1;
		GSpawnFlags _tmp2_;
		GPid _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		GIOChannel* out_channel = NULL;
		GIOChannel* _tmp6_;
		GIOChannel* _tmp7_;
		GIOChannel* err_channel = NULL;
		GIOChannel* _tmp8_;
		GIOChannel* _tmp9_;
		self->priv->eof_count = (guint) 0;
		_tmp1_ = self->command;
		_tmp1__length1 = self->command_length1;
		_tmp2_ = self->flags;
		g_spawn_async_with_pipes (NULL, _tmp1_, NULL, _tmp2_, _rygel_basic_management_test_child_setup_gspawn_child_setup_func, self, &_tmp3_, NULL, &_tmp4_, &_tmp5_, &_inner_error_);
		self->priv->child_pid = _tmp3_;
		self->priv->std_out = _tmp4_;
		self->priv->std_err = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = g_io_channel_unix_new (self->priv->std_out);
		out_channel = _tmp6_;
		_tmp7_ = out_channel;
		g_io_add_watch (_tmp7_, G_IO_OUT | G_IO_HUP, _rygel_basic_management_test_out_watch_gio_func, self);
		_tmp8_ = g_io_channel_unix_new (self->priv->std_err);
		err_channel = _tmp8_;
		_tmp9_ = err_channel;
		g_io_add_watch (_tmp9_, G_IO_OUT | G_IO_HUP, _rygel_basic_management_test_err_watch_gio_func, self);
		_g_io_channel_unref0 (err_channel);
		_g_io_channel_unref0 (out_channel);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		self->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_basic_management_test_finish_iteration_gsource_func, g_object_ref (self), g_object_unref);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}

static gboolean
rygel_basic_management_test_out_watch (RygelBasicManagementTest* self,
                                       GIOChannel* channel,
                                       GIOCondition condition)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	{
		gchar* line = NULL;
		GIOStatus status = 0;
		gchar* _tmp0_ = NULL;
		GIOStatus _tmp1_;
		_tmp1_ = g_io_channel_read_line (channel, &_tmp0_, NULL, NULL, &_inner_error_);
		_g_free0 (line);
		line = _tmp0_;
		status = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (line);
			goto __catch1_g_error;
		}
		if (line != NULL) {
			rygel_basic_management_test_handle_output (self, line);
		}
		if (status == G_IO_STATUS_EOF) {
			guint _tmp2_;
			_tmp2_ = self->priv->eof_count;
			self->priv->eof_count = _tmp2_ + 1;
			if (self->priv->eof_count > ((guint) 1)) {
				rygel_basic_management_test_finish_iteration (self);
			}
			result = FALSE;
			_g_free0 (line);
			return result;
		}
		_g_free0 (line);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = rygel_basic_management_test_get_method_type (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning (_ ("Failed to read standard output from %s: %s"), _tmp4_, _tmp6_);
		rygel_basic_management_test_finish_iteration (self);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp7_;
	}
	result = TRUE;
	return result;
}

static gboolean
rygel_basic_management_test_err_watch (RygelBasicManagementTest* self,
                                       GIOChannel* channel,
                                       GIOCondition condition)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	{
		gchar* line = NULL;
		GIOStatus status = 0;
		gchar* _tmp0_ = NULL;
		GIOStatus _tmp1_;
		_tmp1_ = g_io_channel_read_line (channel, &_tmp0_, NULL, NULL, &_inner_error_);
		_g_free0 (line);
		line = _tmp0_;
		status = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (line);
			goto __catch2_g_error;
		}
		if (line != NULL) {
			rygel_basic_management_test_handle_error (self, line);
		}
		if (status == G_IO_STATUS_EOF) {
			guint _tmp2_;
			_tmp2_ = self->priv->eof_count;
			self->priv->eof_count = _tmp2_ + 1;
			if (self->priv->eof_count > ((guint) 1)) {
				rygel_basic_management_test_finish_iteration (self);
			}
			result = FALSE;
			_g_free0 (line);
			return result;
		}
		_g_free0 (line);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = rygel_basic_management_test_get_method_type (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning (_ ("Failed to read error output from %s: %s"), _tmp4_, _tmp6_);
		rygel_basic_management_test_finish_iteration (self);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp7_;
	}
	result = TRUE;
	return result;
}

gboolean
rygel_basic_management_test_is_active (RygelBasicManagementTest* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	RygelBasicManagementTestExecutionState _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_execution_state;
	if (_tmp1_ == RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED) {
		_tmp0_ = TRUE;
	} else {
		RygelBasicManagementTestExecutionState _tmp2_;
		_tmp2_ = self->priv->_execution_state;
		_tmp0_ = _tmp2_ == RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS;
	}
	result = _tmp0_;
	return result;
}

static void
rygel_basic_management_test_real_run_data_free (gpointer _data)
{
	RygelBasicManagementTestRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelBasicManagementTestRunData, _data_);
}

static void
rygel_basic_management_test_real_run_async_ready_wrapper (GObject *source_object,
                                                          GAsyncResult *res,
                                                          void *user_data)
{
	RygelBasicManagementTestRunData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_basic_management_test_real_run (RygelBasicManagementTest* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	RygelBasicManagementTestRunData* _data_;
	RygelBasicManagementTest* _tmp0_;
	_data_ = g_slice_new0 (RygelBasicManagementTestRunData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_basic_management_test_real_run_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_basic_management_test_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_basic_management_test_real_run_co (_data_);
}

static void
rygel_basic_management_test_real_run_finish (RygelBasicManagementTest* self,
                                             GAsyncResult* _res_)
{
	RygelBasicManagementTestRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_rygel_basic_management_test_real_run_co_gsource_func (gpointer self)
{
	gboolean result;
	result = rygel_basic_management_test_real_run_co (self);
	return result;
}

static gboolean
rygel_basic_management_test_real_run_co (RygelBasicManagementTestRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_execution_state;
	if (_data_->_tmp0_ != RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED) {
		g_debug ("rygel-basic-management-test.vala:243: Not running test: already starte" \
"d");
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp3_ = g_cancellable_new ();
		_data_->_tmp4_ = _data_->_tmp3_;
		rygel_state_machine_set_cancellable ((RygelStateMachine*) _data_->self, _data_->_tmp4_);
		_g_object_unref0 (_data_->_tmp4_);
	}
	rygel_basic_management_test_set_execution_state (_data_->self, RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS);
	_data_->self->priv->current_iteration = (guint) 0;
	(_data_->self->priv->async_callback_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->async_callback_target_destroy_notify (_data_->self->priv->async_callback_target), NULL);
	_data_->self->priv->async_callback = NULL;
	_data_->self->priv->async_callback_target = NULL;
	_data_->self->priv->async_callback_target_destroy_notify = NULL;
	_data_->self->priv->async_callback = _rygel_basic_management_test_real_run_co_gsource_func;
	_data_->self->priv->async_callback_target = _data_;
	_data_->self->priv->async_callback_target_destroy_notify = NULL;
	rygel_basic_management_test_run_iteration (_data_->self);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
rygel_basic_management_test_run (RygelBasicManagementTest* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS (self)->run (self, _callback_, _user_data_);
}

void
rygel_basic_management_test_run_finish (RygelBasicManagementTest* self,
                                        GAsyncResult* _res_)
{
	RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS (self)->run_finish (self, _res_);
}

RygelBasicManagementTest*
rygel_basic_management_test_construct (GType object_type)
{
	RygelBasicManagementTest * self = NULL;
	self = (RygelBasicManagementTest*) g_object_new (object_type, NULL);
	return self;
}

static GCancellable*
rygel_basic_management_test_real_get_cancellable (RygelStateMachine* base)
{
	GCancellable* result;
	RygelBasicManagementTest* self;
	GCancellable* _tmp0_;
	self = (RygelBasicManagementTest*) base;
	_tmp0_ = self->_cancellable;
	result = _tmp0_;
	return result;
}

static void
_rygel_basic_management_test_cancellable___lambda4_ (RygelBasicManagementTest* self)
{
	RygelBasicManagementTestExecutionState _tmp0_;
	_tmp0_ = self->priv->_execution_state;
	if (_tmp0_ == RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS) {
		killpg ((pid_t) self->priv->child_pid, (gint) SIGTERM);
		rygel_basic_management_test_set_execution_state (self, RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_CANCELED);
	}
}

static void
__rygel_basic_management_test_cancellable___lambda4__g_cancellable_cancelled (GCancellable* _sender,
                                                                              gpointer self)
{
	_rygel_basic_management_test_cancellable___lambda4_ ((RygelBasicManagementTest*) self);
}

static void
rygel_basic_management_test_real_set_cancellable (RygelStateMachine* base,
                                                  GCancellable* value)
{
	RygelBasicManagementTest* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelBasicManagementTest*) base;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->_cancellable);
	self->_cancellable = _tmp0_;
	_tmp1_ = self->_cancellable;
	g_signal_connect_object (_tmp1_, "cancelled", (GCallback) __rygel_basic_management_test_cancellable___lambda4__g_cancellable_cancelled, self, 0);
	g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_properties[RYGEL_BASIC_MANAGEMENT_TEST_CANCELLABLE_PROPERTY]);
}

RygelBasicManagementTestExecutionState
rygel_basic_management_test_get_execution_state (RygelBasicManagementTest* self)
{
	RygelBasicManagementTestExecutionState result;
	RygelBasicManagementTestExecutionState _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_execution_state;
	result = _tmp0_;
	return result;
}

void
rygel_basic_management_test_set_execution_state (RygelBasicManagementTest* self,
                                                 RygelBasicManagementTestExecutionState value)
{
	g_return_if_fail (self != NULL);
	if (rygel_basic_management_test_get_execution_state (self) != value) {
		self->priv->_execution_state = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_properties[RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_PROPERTY]);
	}
}

const gchar*
rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS (self)->get_method_type (self);
}

const gchar*
rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS (self)->get_results_type (self);
}

static void
rygel_basic_management_test_class_init (RygelBasicManagementTestClass * klass)
{
	rygel_basic_management_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelBasicManagementTest_private_offset);
	((RygelBasicManagementTestClass *) klass)->init_iteration = (void (*) (RygelBasicManagementTest*)) rygel_basic_management_test_real_init_iteration;
	((RygelBasicManagementTestClass *) klass)->handle_output = (void (*) (RygelBasicManagementTest*, const gchar*)) rygel_basic_management_test_real_handle_output;
	((RygelBasicManagementTestClass *) klass)->handle_error = (void (*) (RygelBasicManagementTest*, const gchar*)) rygel_basic_management_test_real_handle_error;
	((RygelBasicManagementTestClass *) klass)->finish_iteration = (gboolean (*) (RygelBasicManagementTest*)) rygel_basic_management_test_real_finish_iteration;
	((RygelBasicManagementTestClass *) klass)->run = (void (*) (RygelBasicManagementTest*, GAsyncReadyCallback, gpointer)) rygel_basic_management_test_real_run;
	((RygelBasicManagementTestClass *) klass)->run_finish = (void (*) (RygelBasicManagementTest*, GAsyncResult*)) rygel_basic_management_test_real_run_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_basic_management_test_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_basic_management_test_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_basic_management_test_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_CANCELLABLE_PROPERTY, rygel_basic_management_test_properties[RYGEL_BASIC_MANAGEMENT_TEST_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_PROPERTY, rygel_basic_management_test_properties[RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_PROPERTY] = g_param_spec_enum ("execution-state", "execution-state", "execution-state", RYGEL_BASIC_MANAGEMENT_TEST_TYPE_EXECUTION_STATE, RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_METHOD_TYPE_PROPERTY, rygel_basic_management_test_properties[RYGEL_BASIC_MANAGEMENT_TEST_METHOD_TYPE_PROPERTY] = g_param_spec_string ("method-type", "method-type", "method-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_RESULTS_TYPE_PROPERTY, rygel_basic_management_test_properties[RYGEL_BASIC_MANAGEMENT_TEST_RESULTS_TYPE_PROPERTY] = g_param_spec_string ("results-type", "results-type", "results-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rygel_basic_management_test_rygel_state_machine_interface_init (RygelStateMachineIface * iface)
{
	rygel_basic_management_test_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*) (RygelStateMachine*, GAsyncReadyCallback, gpointer)) rygel_basic_management_test_run;
	iface->run_finish = (void (*) (RygelStateMachine*, GAsyncResult*)) rygel_basic_management_test_run_finish;
	iface->get_cancellable = rygel_basic_management_test_real_get_cancellable;
	iface->set_cancellable = rygel_basic_management_test_real_set_cancellable;
}

static void
rygel_basic_management_test_instance_init (RygelBasicManagementTest * self)
{
	self->priv = rygel_basic_management_test_get_instance_private (self);
	self->priv->_execution_state = RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED;
	self->flags = G_SPAWN_SEARCH_PATH | G_SPAWN_LEAVE_DESCRIPTORS_OPEN;
}

static void
rygel_basic_management_test_finalize (GObject * obj)
{
	RygelBasicManagementTest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest);
	_g_object_unref0 (self->_cancellable);
	_g_free0 (self->id);
	self->command = (_vala_array_free (self->command, self->command_length1, (GDestroyNotify) g_free), NULL);
	(self->priv->async_callback_target_destroy_notify == NULL) ? NULL : (self->priv->async_callback_target_destroy_notify (self->priv->async_callback_target), NULL);
	self->priv->async_callback = NULL;
	self->priv->async_callback_target = NULL;
	self->priv->async_callback_target_destroy_notify = NULL;
	G_OBJECT_CLASS (rygel_basic_management_test_parent_class)->finalize (obj);
}

GType
rygel_basic_management_test_get_type (void)
{
	static volatile gsize rygel_basic_management_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBasicManagementTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_basic_management_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBasicManagementTest), 0, (GInstanceInitFunc) rygel_basic_management_test_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_basic_management_test_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_basic_management_test_type_id;
		rygel_basic_management_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelBasicManagementTest", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (rygel_basic_management_test_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		RygelBasicManagementTest_private_offset = g_type_add_instance_private (rygel_basic_management_test_type_id, sizeof (RygelBasicManagementTestPrivate));
		g_once_init_leave (&rygel_basic_management_test_type_id__volatile, rygel_basic_management_test_type_id);
	}
	return rygel_basic_management_test_type_id__volatile;
}

static void
_vala_rygel_basic_management_test_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	RygelBasicManagementTest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_TEST_CANCELLABLE_PROPERTY:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_PROPERTY:
		g_value_set_enum (value, rygel_basic_management_test_get_execution_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_basic_management_test_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	RygelBasicManagementTest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_TEST_CANCELLABLE_PROPERTY:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_PROPERTY:
		rygel_basic_management_test_set_execution_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

