/* rygel-external-item-factory.c generated by valac 0.42.2, the Vala compiler
 * generated from rygel-external-item-factory.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_EXTERNAL_TYPE_ITEM_FACTORY (rygel_external_item_factory_get_type ())
#define RYGEL_EXTERNAL_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactory))
#define RYGEL_EXTERNAL_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))

typedef struct _RygelExternalItemFactory RygelExternalItemFactory;
typedef struct _RygelExternalItemFactoryClass RygelExternalItemFactoryClass;
typedef struct _RygelExternalItemFactoryPrivate RygelExternalItemFactoryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_external_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_item_factory_unref (var), NULL)))

#define RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER (rygel_external_dummy_container_get_type ())
#define RYGEL_EXTERNAL_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainer))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))

typedef struct _RygelExternalDummyContainer RygelExternalDummyContainer;
typedef struct _RygelExternalDummyContainerClass RygelExternalDummyContainerClass;
typedef struct _RygelExternalItemFactoryCreateData RygelExternalItemFactoryCreateData;

#define RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY (rygel_external_album_art_factory_get_type ())
#define RYGEL_EXTERNAL_ALBUM_ART_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY, RygelExternalAlbumArtFactory))
#define RYGEL_EXTERNAL_ALBUM_ART_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY, RygelExternalAlbumArtFactoryClass))
#define RYGEL_EXTERNAL_IS_ALBUM_ART_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY))
#define RYGEL_EXTERNAL_IS_ALBUM_ART_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY))
#define RYGEL_EXTERNAL_ALBUM_ART_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ALBUM_ART_FACTORY, RygelExternalAlbumArtFactoryClass))

typedef struct _RygelExternalAlbumArtFactory RygelExternalAlbumArtFactory;
typedef struct _RygelExternalAlbumArtFactoryClass RygelExternalAlbumArtFactoryClass;
#define _rygel_external_album_art_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_album_art_factory_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelExternalItemFactorySetMusicMetadataData RygelExternalItemFactorySetMusicMetadataData;

#define RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY (rygel_external_thumbnail_factory_get_type ())
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY, RygelExternalThumbnailFactory))
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY, RygelExternalThumbnailFactoryClass))
#define RYGEL_EXTERNAL_IS_THUMBNAIL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY))
#define RYGEL_EXTERNAL_IS_THUMBNAIL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY))
#define RYGEL_EXTERNAL_THUMBNAIL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_THUMBNAIL_FACTORY, RygelExternalThumbnailFactoryClass))

typedef struct _RygelExternalThumbnailFactory RygelExternalThumbnailFactory;
typedef struct _RygelExternalThumbnailFactoryClass RygelExternalThumbnailFactoryClass;
#define _rygel_external_thumbnail_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_thumbnail_factory_unref (var), NULL)))
typedef struct _RygelExternalItemFactorySetVisualMetadataData RygelExternalItemFactorySetVisualMetadataData;
typedef struct _RygelExternalItemFactorySetVideoMetadataData RygelExternalItemFactorySetVideoMetadataData;
typedef struct _RygelExternalParamSpecItemFactory RygelExternalParamSpecItemFactory;

struct _RygelExternalItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelExternalItemFactoryPrivate * priv;
};

struct _RygelExternalItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelExternalItemFactory *self);
};

struct _RygelExternalItemFactoryCreateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelExternalItemFactory* self;
	gchar* id;
	gchar* type;
	gchar* title;
	GHashTable* props;
	gchar* service_name;
	RygelMediaContainer* parent;
	RygelMediaFileItem* result;
	RygelMediaFileItem* item;
	gboolean _tmp0_;
	RygelMusicItem* _tmp1_;
	RygelMediaFileItem* _tmp2_;
	RygelAudioItem* _tmp3_;
	RygelMediaFileItem* _tmp4_;
	RygelVideoItem* _tmp5_;
	RygelMediaFileItem* _tmp6_;
	RygelImageItem* _tmp7_;
	RygelMediaFileItem* _tmp8_;
	RygelMediaFileItem* _tmp9_;
	RygelMediaFileItem* _tmp10_;
	RygelMediaFileItem* _tmp11_;
	GError * _inner_error_;
};

struct _RygelExternalItemFactorySetMusicMetadataData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelExternalItemFactory* self;
	RygelMusicItem* music;
	GHashTable* props;
	gchar* service_name;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GVariant* value;
	gconstpointer _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	RygelExternalAlbumArtFactory* cover_factory;
	RygelExternalAlbumArtFactory* _tmp9_;
	RygelThumbnail* _tmp10_;
	RygelExternalAlbumArtFactory* _tmp11_;
	GVariant* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	RygelThumbnail* _tmp15_;
	RygelThumbnail* _tmp16_;
	GError * _inner_error_;
};

struct _RygelExternalItemFactorySetVisualMetadataData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelExternalItemFactory* self;
	RygelVisualItem* visual;
	GHashTable* props;
	gchar* service_name;
	GVariant* value;
	gconstpointer _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	RygelExternalThumbnailFactory* factory;
	RygelExternalThumbnailFactory* _tmp3_;
	RygelThumbnail* thumbnail;
	RygelExternalThumbnailFactory* _tmp4_;
	GVariant* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	RygelThumbnail* _tmp8_;
	RygelThumbnail* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	RygelThumbnail* _tmp12_;
	GError * _inner_error_;
};

struct _RygelExternalItemFactorySetVideoMetadataData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelExternalItemFactory* self;
	RygelVideoItem* video;
	GHashTable* props;
	gchar* service_name;
	GError * _inner_error_;
};

struct _RygelExternalParamSpecItemFactory {
	GParamSpec parent_instance;
};


static gpointer rygel_external_item_factory_parent_class = NULL;

gpointer rygel_external_item_factory_ref (gpointer instance);
void rygel_external_item_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_item_factory (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
void rygel_external_value_set_item_factory (GValue* value,
                                            gpointer v_object);
void rygel_external_value_take_item_factory (GValue* value,
                                             gpointer v_object);
gpointer rygel_external_value_get_item_factory (const GValue* value);
GType rygel_external_item_factory_get_type (void) G_GNUC_CONST;
static void rygel_external_item_factory_create_data_free (gpointer _data);
static void rygel_external_item_factory_create_async_ready_wrapper (GObject *source_object,
                                                             GAsyncResult *res,
                                                             void *user_data);
void rygel_external_item_factory_create (RygelExternalItemFactory* self,
                                         const gchar* id,
                                         const gchar* type,
                                         const gchar* title,
                                         GHashTable* props,
                                         const gchar* service_name,
                                         RygelMediaContainer* parent,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
RygelMediaFileItem* rygel_external_item_factory_create_finish (RygelExternalItemFactory* self,
                                                               GAsyncResult* _res_,
                                                               GError** error);
static gboolean rygel_external_item_factory_create_co (RygelExternalItemFactoryCreateData* _data_);
static void rygel_external_item_factory_set_music_metadata (RygelExternalItemFactory* self,
                                                     RygelMusicItem* music,
                                                     GHashTable* props,
                                                     const gchar* service_name,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void rygel_external_item_factory_set_music_metadata_finish (RygelExternalItemFactory* self,
                                                            GAsyncResult* _res_,
                                                            GError** error);
static void rygel_external_item_factory_create_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void rygel_external_item_factory_set_audio_metadata (RygelExternalItemFactory* self,
                                                     RygelAudioItem* audio,
                                                     GHashTable* props,
                                                     const gchar* service_name,
                                                     GError** error);
static void rygel_external_item_factory_set_video_metadata (RygelExternalItemFactory* self,
                                                     RygelVideoItem* video,
                                                     GHashTable* props,
                                                     const gchar* service_name,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void rygel_external_item_factory_set_video_metadata_finish (RygelExternalItemFactory* self,
                                                            GAsyncResult* _res_,
                                                            GError** error);
static void rygel_external_item_factory_set_visual_metadata (RygelExternalItemFactory* self,
                                                      RygelVisualItem* visual,
                                                      GHashTable* props,
                                                      const gchar* service_name,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void rygel_external_item_factory_set_visual_metadata_finish (RygelExternalItemFactory* self,
                                                             GAsyncResult* _res_,
                                                             GError** error);
static void rygel_external_item_factory_set_generic_metadata (RygelExternalItemFactory* self,
                                                       RygelMediaFileItem* item,
                                                       GHashTable* props,
                                                       const gchar* service_name);
GType rygel_external_dummy_container_get_type (void) G_GNUC_CONST;
static void rygel_external_item_factory_set_music_metadata_data_free (gpointer _data);
static void rygel_external_item_factory_set_music_metadata_async_ready_wrapper (GObject *source_object,
                                                                         GAsyncResult *res,
                                                                         void *user_data);
static gboolean rygel_external_item_factory_set_music_metadata_co (RygelExternalItemFactorySetMusicMetadataData* _data_);
static gchar* rygel_external_item_factory_get_string (RygelExternalItemFactory* self,
                                               GHashTable* props,
                                               const gchar* prop);
static gint rygel_external_item_factory_get_int (RygelExternalItemFactory* self,
                                          GHashTable* props,
                                          const gchar* prop);
gpointer rygel_external_album_art_factory_ref (gpointer instance);
void rygel_external_album_art_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_album_art_factory (const gchar* name,
                                                         const gchar* nick,
                                                         const gchar* blurb,
                                                         GType object_type,
                                                         GParamFlags flags);
void rygel_external_value_set_album_art_factory (GValue* value,
                                                 gpointer v_object);
void rygel_external_value_take_album_art_factory (GValue* value,
                                                  gpointer v_object);
gpointer rygel_external_value_get_album_art_factory (const GValue* value);
GType rygel_external_album_art_factory_get_type (void) G_GNUC_CONST;
RygelExternalAlbumArtFactory* rygel_external_album_art_factory_new (void);
RygelExternalAlbumArtFactory* rygel_external_album_art_factory_construct (GType object_type);
void rygel_external_album_art_factory_create (RygelExternalAlbumArtFactory* self,
                                              const gchar* service_name,
                                              const gchar* object_path,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
RygelThumbnail* rygel_external_album_art_factory_create_finish (RygelExternalAlbumArtFactory* self,
                                                                GAsyncResult* _res_,
                                                                GError** error);
static gchar* _variant_get13 (GVariant* value);
static void rygel_external_item_factory_set_music_metadata_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void rygel_external_item_factory_set_visual_metadata_data_free (gpointer _data);
static void rygel_external_item_factory_set_visual_metadata_async_ready_wrapper (GObject *source_object,
                                                                          GAsyncResult *res,
                                                                          void *user_data);
static gboolean rygel_external_item_factory_set_visual_metadata_co (RygelExternalItemFactorySetVisualMetadataData* _data_);
gpointer rygel_external_thumbnail_factory_ref (gpointer instance);
void rygel_external_thumbnail_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_thumbnail_factory (const gchar* name,
                                                         const gchar* nick,
                                                         const gchar* blurb,
                                                         GType object_type,
                                                         GParamFlags flags);
void rygel_external_value_set_thumbnail_factory (GValue* value,
                                                 gpointer v_object);
void rygel_external_value_take_thumbnail_factory (GValue* value,
                                                  gpointer v_object);
gpointer rygel_external_value_get_thumbnail_factory (const GValue* value);
GType rygel_external_thumbnail_factory_get_type (void) G_GNUC_CONST;
RygelExternalThumbnailFactory* rygel_external_thumbnail_factory_new (void);
RygelExternalThumbnailFactory* rygel_external_thumbnail_factory_construct (GType object_type);
void rygel_external_thumbnail_factory_create (RygelExternalThumbnailFactory* self,
                                              const gchar* service_name,
                                              const gchar* object_path,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
RygelThumbnail* rygel_external_thumbnail_factory_create_finish (RygelExternalThumbnailFactory* self,
                                                                GAsyncResult* _res_,
                                                                GError** error);
static gchar* _variant_get14 (GVariant* value);
static void rygel_external_item_factory_set_visual_metadata_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void rygel_external_item_factory_set_video_metadata_data_free (gpointer _data);
static void rygel_external_item_factory_set_video_metadata_async_ready_wrapper (GObject *source_object,
                                                                         GAsyncResult *res,
                                                                         void *user_data);
static gboolean rygel_external_item_factory_set_video_metadata_co (RygelExternalItemFactorySetVideoMetadataData* _data_);
static void rygel_external_item_factory_set_video_metadata_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
gchar* rygel_external_get_mandatory_string_value (GHashTable* props,
                                                  const gchar* key,
                                                  const gchar* _default_,
                                                  const gchar* service_name);
gchar** rygel_external_get_mandatory_string_list_value (GHashTable* props,
                                                        const gchar* key,
                                                        gchar** _default_,
                                                        int _default__length1,
                                                        const gchar* service_name,
                                                        int* result_length1);
static gint64 _variant_get15 (GVariant* value);
static gchar* _variant_get16 (GVariant* value);
static gint _variant_get17 (GVariant* value);
RygelExternalItemFactory* rygel_external_item_factory_new (void);
RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type);
static void rygel_external_item_factory_finalize (RygelExternalItemFactory * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static void
rygel_external_item_factory_create_data_free (gpointer _data)
{
	RygelExternalItemFactoryCreateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_free0 (_data_->type);
	_g_free0 (_data_->title);
	_g_hash_table_unref0 (_data_->props);
	_g_free0 (_data_->service_name);
	_g_object_unref0 (_data_->parent);
	_g_object_unref0 (_data_->result);
	_rygel_external_item_factory_unref0 (_data_->self);
	g_slice_free (RygelExternalItemFactoryCreateData, _data_);
}


static void
rygel_external_item_factory_create_async_ready_wrapper (GObject *source_object,
                                                        GAsyncResult *res,
                                                        void *user_data)
{
	RygelExternalItemFactoryCreateData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer
_rygel_external_item_factory_ref0 (gpointer self)
{
	return self ? rygel_external_item_factory_ref (self) : NULL;
}


static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
rygel_external_item_factory_create (RygelExternalItemFactory* self,
                                    const gchar* id,
                                    const gchar* type,
                                    const gchar* title,
                                    GHashTable* props,
                                    const gchar* service_name,
                                    RygelMediaContainer* parent,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	RygelExternalItemFactoryCreateData* _data_;
	RygelExternalItemFactory* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	RygelMediaContainer* _tmp6_;
	_data_ = g_slice_new0 (RygelExternalItemFactoryCreateData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, NULL, rygel_external_item_factory_create_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_external_item_factory_create_data_free);
	_tmp0_ = _rygel_external_item_factory_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = g_strdup (type);
	_g_free0 (_data_->type);
	_data_->type = _tmp2_;
	_tmp3_ = g_strdup (title);
	_g_free0 (_data_->title);
	_data_->title = _tmp3_;
	_tmp4_ = _g_hash_table_ref0 (props);
	_g_hash_table_unref0 (_data_->props);
	_data_->props = _tmp4_;
	_tmp5_ = g_strdup (service_name);
	_g_free0 (_data_->service_name);
	_data_->service_name = _tmp5_;
	_tmp6_ = _g_object_ref0 (parent);
	_g_object_unref0 (_data_->parent);
	_data_->parent = _tmp6_;
	rygel_external_item_factory_create_co (_data_);
}


RygelMediaFileItem*
rygel_external_item_factory_create_finish (RygelExternalItemFactory* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	RygelMediaFileItem* result;
	RygelExternalItemFactoryCreateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void
rygel_external_item_factory_create_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	RygelExternalItemFactoryCreateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_external_item_factory_create_co (_data_);
}


static gboolean
rygel_external_item_factory_create_co (RygelExternalItemFactoryCreateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (g_str_has_prefix (_data_->type, "music")) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp0_ = g_str_has_prefix (_data_->type, "audio.music");
	}
	if (_data_->_tmp0_) {
		_data_->_tmp1_ = rygel_music_item_new (_data_->id, _data_->parent, _data_->title, RYGEL_MUSIC_ITEM_UPNP_CLASS);
		_g_object_unref0 (_data_->item);
		_data_->item = (RygelMediaFileItem*) _data_->_tmp1_;
		_data_->_tmp2_ = _data_->item;
		_data_->_state_ = 1;
		rygel_external_item_factory_set_music_metadata (_data_->self, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp2_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _data_->_tmp2_) : NULL, _data_->props, _data_->service_name, rygel_external_item_factory_create_ready, _data_);
		return FALSE;
		_state_1:
		rygel_external_item_factory_set_music_metadata_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				_g_object_unref0 (_data_->item);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->item);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	} else {
		if (g_str_has_prefix (_data_->type, "audio")) {
			_data_->_tmp3_ = rygel_audio_item_new (_data_->id, _data_->parent, _data_->title, RYGEL_AUDIO_ITEM_UPNP_CLASS);
			_g_object_unref0 (_data_->item);
			_data_->item = (RygelMediaFileItem*) _data_->_tmp3_;
			_data_->_tmp4_ = _data_->item;
			rygel_external_item_factory_set_audio_metadata (_data_->self, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp4_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _data_->_tmp4_) : NULL, _data_->props, _data_->service_name, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error_);
					_g_object_unref0 (_data_->item);
					g_object_unref (_data_->_async_result);
					return FALSE;
				} else {
					_g_object_unref0 (_data_->item);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
		} else {
			if (g_str_has_prefix (_data_->type, "video")) {
				_data_->_tmp5_ = rygel_video_item_new (_data_->id, _data_->parent, _data_->title, RYGEL_VIDEO_ITEM_UPNP_CLASS);
				_g_object_unref0 (_data_->item);
				_data_->item = (RygelMediaFileItem*) _data_->_tmp5_;
				_data_->_tmp6_ = _data_->item;
				_data_->_state_ = 2;
				rygel_external_item_factory_set_video_metadata (_data_->self, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp6_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _data_->_tmp6_) : NULL, _data_->props, _data_->service_name, rygel_external_item_factory_create_ready, _data_);
				return FALSE;
				_state_2:
				rygel_external_item_factory_set_video_metadata_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						_g_object_unref0 (_data_->item);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						_g_object_unref0 (_data_->item);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
			} else {
				_data_->_tmp7_ = rygel_image_item_new (_data_->id, _data_->parent, _data_->title, RYGEL_IMAGE_ITEM_UPNP_CLASS);
				_g_object_unref0 (_data_->item);
				_data_->item = (RygelMediaFileItem*) _data_->_tmp7_;
				_data_->_tmp8_ = _data_->item;
				_data_->_state_ = 3;
				rygel_external_item_factory_set_visual_metadata (_data_->self, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp8_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _data_->_tmp8_) : NULL, _data_->props, _data_->service_name, rygel_external_item_factory_create_ready, _data_);
				return FALSE;
				_state_3:
				rygel_external_item_factory_set_visual_metadata_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						_g_object_unref0 (_data_->item);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						_g_object_unref0 (_data_->item);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
			}
		}
	}
	_data_->_tmp9_ = _data_->item;
	rygel_external_item_factory_set_generic_metadata (_data_->self, _data_->_tmp9_, _data_->props, _data_->service_name);
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->parent, RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER)) {
		_data_->_tmp10_ = _data_->item;
		rygel_media_object_set_parent_ref ((RygelMediaObject*) _data_->_tmp10_, _data_->parent);
	}
	_data_->_tmp11_ = _data_->item;
	_data_->_state_ = 4;
	rygel_media_file_item_add_engine_resources (_data_->_tmp11_, rygel_external_item_factory_create_ready, _data_);
	return FALSE;
	_state_4:
	rygel_media_file_item_add_engine_resources_finish (_data_->_tmp11_, _data_->_res_);
	_data_->result = _data_->item;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
rygel_external_item_factory_set_music_metadata_data_free (gpointer _data)
{
	RygelExternalItemFactorySetMusicMetadataData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->music);
	_g_hash_table_unref0 (_data_->props);
	_g_free0 (_data_->service_name);
	_rygel_external_item_factory_unref0 (_data_->self);
	g_slice_free (RygelExternalItemFactorySetMusicMetadataData, _data_);
}


static void
rygel_external_item_factory_set_music_metadata_async_ready_wrapper (GObject *source_object,
                                                                    GAsyncResult *res,
                                                                    void *user_data)
{
	RygelExternalItemFactorySetMusicMetadataData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
rygel_external_item_factory_set_music_metadata (RygelExternalItemFactory* self,
                                                RygelMusicItem* music,
                                                GHashTable* props,
                                                const gchar* service_name,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	RygelExternalItemFactorySetMusicMetadataData* _data_;
	RygelExternalItemFactory* _tmp0_;
	RygelMusicItem* _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	_data_ = g_slice_new0 (RygelExternalItemFactorySetMusicMetadataData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, NULL, rygel_external_item_factory_set_music_metadata_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_external_item_factory_set_music_metadata_data_free);
	_tmp0_ = _rygel_external_item_factory_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (music);
	_g_object_unref0 (_data_->music);
	_data_->music = _tmp1_;
	_tmp2_ = _g_hash_table_ref0 (props);
	_g_hash_table_unref0 (_data_->props);
	_data_->props = _tmp2_;
	_tmp3_ = g_strdup (service_name);
	_g_free0 (_data_->service_name);
	_data_->service_name = _tmp3_;
	rygel_external_item_factory_set_music_metadata_co (_data_);
}


static void
rygel_external_item_factory_set_music_metadata_finish (RygelExternalItemFactory* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	RygelExternalItemFactorySetMusicMetadataData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}


static gchar*
_variant_get13 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}


static void
rygel_external_item_factory_set_music_metadata_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	RygelExternalItemFactorySetMusicMetadataData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_external_item_factory_set_music_metadata_co (_data_);
}


static gboolean
rygel_external_item_factory_set_music_metadata_co (RygelExternalItemFactorySetMusicMetadataData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_external_item_factory_get_string (_data_->self, _data_->props, "Artist");
	_data_->_tmp1_ = _data_->_tmp0_;
	rygel_media_object_set_artist ((RygelMediaObject*) _data_->music, _data_->_tmp1_);
	_g_free0 (_data_->_tmp1_);
	_data_->_tmp2_ = rygel_external_item_factory_get_string (_data_->self, _data_->props, "Album");
	_data_->_tmp3_ = _data_->_tmp2_;
	rygel_audio_item_set_album ((RygelAudioItem*) _data_->music, _data_->_tmp3_);
	_g_free0 (_data_->_tmp3_);
	_data_->_tmp4_ = rygel_external_item_factory_get_string (_data_->self, _data_->props, "Genre");
	_data_->_tmp5_ = _data_->_tmp4_;
	rygel_media_object_set_genre ((RygelMediaObject*) _data_->music, _data_->_tmp5_);
	_g_free0 (_data_->_tmp5_);
	rygel_music_item_set_track_number (_data_->music, rygel_external_item_factory_get_int (_data_->self, _data_->props, "TrackNumber"));
	_data_->_tmp6_ = g_hash_table_lookup (_data_->props, "AlbumArt");
	_data_->_tmp7_ = _g_variant_ref0 ((GVariant*) _data_->_tmp6_);
	_data_->value = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->value;
	if (_data_->_tmp8_ != NULL) {
		_data_->_tmp9_ = rygel_external_album_art_factory_new ();
		_data_->cover_factory = _data_->_tmp9_;
		_data_->_tmp11_ = _data_->cover_factory;
		_data_->_tmp12_ = _data_->value;
		_data_->_tmp13_ = _variant_get13 (_data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_state_ = 1;
		rygel_external_album_art_factory_create (_data_->_tmp11_, _data_->service_name, _data_->_tmp14_, rygel_external_item_factory_set_music_metadata_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp15_ = rygel_external_album_art_factory_create_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_g_free0 (_data_->_tmp14_);
		_data_->_tmp10_ = _data_->_tmp16_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				_rygel_external_album_art_factory_unref0 (_data_->cover_factory);
				_g_variant_unref0 (_data_->value);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_rygel_external_album_art_factory_unref0 (_data_->cover_factory);
				_g_variant_unref0 (_data_->value);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		rygel_music_item_set_album_art (_data_->music, _data_->_tmp10_);
		_rygel_icon_info_unref0 (_data_->_tmp10_);
		_rygel_external_album_art_factory_unref0 (_data_->cover_factory);
	}
	rygel_external_item_factory_set_audio_metadata (_data_->self, (RygelAudioItem*) _data_->music, _data_->props, _data_->service_name, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_variant_unref0 (_data_->value);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_variant_unref0 (_data_->value);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_variant_unref0 (_data_->value);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
rygel_external_item_factory_set_audio_metadata (RygelExternalItemFactory* self,
                                                RygelAudioItem* audio,
                                                GHashTable* props,
                                                const gchar* service_name,
                                                GError** error)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (audio != NULL);
	g_return_if_fail (props != NULL);
	g_return_if_fail (service_name != NULL);
	rygel_audio_item_set_duration (audio, (glong) rygel_external_item_factory_get_int (self, props, "Duration"));
	rygel_audio_item_set_bitrate (audio, rygel_external_item_factory_get_int (self, props, "Bitrate"));
	rygel_audio_item_set_sample_freq (audio, rygel_external_item_factory_get_int (self, props, "SampleRate"));
	rygel_audio_item_set_bits_per_sample (audio, rygel_external_item_factory_get_int (self, props, "BitsPerSample"));
}


static void
rygel_external_item_factory_set_visual_metadata_data_free (gpointer _data)
{
	RygelExternalItemFactorySetVisualMetadataData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->visual);
	_g_hash_table_unref0 (_data_->props);
	_g_free0 (_data_->service_name);
	_rygel_external_item_factory_unref0 (_data_->self);
	g_slice_free (RygelExternalItemFactorySetVisualMetadataData, _data_);
}


static void
rygel_external_item_factory_set_visual_metadata_async_ready_wrapper (GObject *source_object,
                                                                     GAsyncResult *res,
                                                                     void *user_data)
{
	RygelExternalItemFactorySetVisualMetadataData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
rygel_external_item_factory_set_visual_metadata (RygelExternalItemFactory* self,
                                                 RygelVisualItem* visual,
                                                 GHashTable* props,
                                                 const gchar* service_name,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	RygelExternalItemFactorySetVisualMetadataData* _data_;
	RygelExternalItemFactory* _tmp0_;
	RygelVisualItem* _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	_data_ = g_slice_new0 (RygelExternalItemFactorySetVisualMetadataData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, NULL, rygel_external_item_factory_set_visual_metadata_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_external_item_factory_set_visual_metadata_data_free);
	_tmp0_ = _rygel_external_item_factory_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (visual);
	_g_object_unref0 (_data_->visual);
	_data_->visual = _tmp1_;
	_tmp2_ = _g_hash_table_ref0 (props);
	_g_hash_table_unref0 (_data_->props);
	_data_->props = _tmp2_;
	_tmp3_ = g_strdup (service_name);
	_g_free0 (_data_->service_name);
	_data_->service_name = _tmp3_;
	rygel_external_item_factory_set_visual_metadata_co (_data_);
}


static void
rygel_external_item_factory_set_visual_metadata_finish (RygelExternalItemFactory* self,
                                                        GAsyncResult* _res_,
                                                        GError** error)
{
	RygelExternalItemFactorySetVisualMetadataData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static gchar*
_variant_get14 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}


static void
rygel_external_item_factory_set_visual_metadata_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	RygelExternalItemFactorySetVisualMetadataData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_external_item_factory_set_visual_metadata_co (_data_);
}


static gboolean
rygel_external_item_factory_set_visual_metadata_co (RygelExternalItemFactorySetVisualMetadataData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	rygel_visual_item_set_width (_data_->visual, rygel_external_item_factory_get_int (_data_->self, _data_->props, "Width"));
	rygel_visual_item_set_height (_data_->visual, rygel_external_item_factory_get_int (_data_->self, _data_->props, "Height"));
	rygel_visual_item_set_color_depth (_data_->visual, rygel_external_item_factory_get_int (_data_->self, _data_->props, "ColorDepth"));
	_data_->_tmp0_ = g_hash_table_lookup (_data_->props, "Thumbnail");
	_data_->_tmp1_ = _g_variant_ref0 ((GVariant*) _data_->_tmp0_);
	_data_->value = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->value;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = rygel_external_thumbnail_factory_new ();
		_data_->factory = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->factory;
		_data_->_tmp5_ = _data_->value;
		_data_->_tmp6_ = _variant_get14 (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_state_ = 1;
		rygel_external_thumbnail_factory_create (_data_->_tmp4_, _data_->_tmp7_, _data_->service_name, rygel_external_item_factory_set_visual_metadata_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = rygel_external_thumbnail_factory_create_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_g_free0 (_data_->_tmp7_);
		_data_->thumbnail = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				_rygel_external_thumbnail_factory_unref0 (_data_->factory);
				_g_variant_unref0 (_data_->value);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_rygel_external_thumbnail_factory_unref0 (_data_->factory);
				_g_variant_unref0 (_data_->value);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp10_ = rygel_visual_item_get_thumbnails (_data_->visual);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = _data_->thumbnail;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp11_, _data_->_tmp12_);
		_rygel_icon_info_unref0 (_data_->thumbnail);
		_rygel_external_thumbnail_factory_unref0 (_data_->factory);
	}
	_g_variant_unref0 (_data_->value);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
rygel_external_item_factory_set_video_metadata_data_free (gpointer _data)
{
	RygelExternalItemFactorySetVideoMetadataData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->video);
	_g_hash_table_unref0 (_data_->props);
	_g_free0 (_data_->service_name);
	_rygel_external_item_factory_unref0 (_data_->self);
	g_slice_free (RygelExternalItemFactorySetVideoMetadataData, _data_);
}


static void
rygel_external_item_factory_set_video_metadata_async_ready_wrapper (GObject *source_object,
                                                                    GAsyncResult *res,
                                                                    void *user_data)
{
	RygelExternalItemFactorySetVideoMetadataData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
rygel_external_item_factory_set_video_metadata (RygelExternalItemFactory* self,
                                                RygelVideoItem* video,
                                                GHashTable* props,
                                                const gchar* service_name,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	RygelExternalItemFactorySetVideoMetadataData* _data_;
	RygelExternalItemFactory* _tmp0_;
	RygelVideoItem* _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	_data_ = g_slice_new0 (RygelExternalItemFactorySetVideoMetadataData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, NULL, rygel_external_item_factory_set_video_metadata_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_external_item_factory_set_video_metadata_data_free);
	_tmp0_ = _rygel_external_item_factory_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (video);
	_g_object_unref0 (_data_->video);
	_data_->video = _tmp1_;
	_tmp2_ = _g_hash_table_ref0 (props);
	_g_hash_table_unref0 (_data_->props);
	_data_->props = _tmp2_;
	_tmp3_ = g_strdup (service_name);
	_g_free0 (_data_->service_name);
	_data_->service_name = _tmp3_;
	rygel_external_item_factory_set_video_metadata_co (_data_);
}


static void
rygel_external_item_factory_set_video_metadata_finish (RygelExternalItemFactory* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	RygelExternalItemFactorySetVideoMetadataData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static void
rygel_external_item_factory_set_video_metadata_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	RygelExternalItemFactorySetVideoMetadataData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_external_item_factory_set_video_metadata_co (_data_);
}


static gboolean
rygel_external_item_factory_set_video_metadata_co (RygelExternalItemFactorySetVideoMetadataData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	rygel_external_item_factory_set_visual_metadata (_data_->self, (RygelVisualItem*) _data_->video, _data_->props, _data_->service_name, rygel_external_item_factory_set_video_metadata_ready, _data_);
	return FALSE;
	_state_1:
	rygel_external_item_factory_set_visual_metadata_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	rygel_external_item_factory_set_audio_metadata (_data_->self, (RygelAudioItem*) _data_->video, _data_->props, _data_->service_name, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gint64
_variant_get15 (GVariant* value)
{
	return g_variant_get_int64 (value);
}


static void
rygel_external_item_factory_set_generic_metadata (RygelExternalItemFactory* self,
                                                  RygelMediaFileItem* item,
                                                  GHashTable* props,
                                                  const gchar* service_name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** uris = NULL;
	gint _tmp2_;
	gchar** _tmp3_;
	gint uris_length1;
	gint _uris_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GVariant* value = NULL;
	gconstpointer _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (props != NULL);
	g_return_if_fail (service_name != NULL);
	_tmp0_ = rygel_external_get_mandatory_string_value (props, "MIMEType", "image/jpeg", service_name);
	_tmp1_ = _tmp0_;
	rygel_media_file_item_set_mime_type (item, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp3_ = rygel_external_get_mandatory_string_list_value (props, "URLs", NULL, 0, service_name, &_tmp2_);
	uris = _tmp3_;
	uris_length1 = _tmp2_;
	_uris_size_ = uris_length1;
	_tmp4_ = uris;
	_tmp4__length1 = uris_length1;
	if (_tmp4_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					gchar** _tmp7_;
					gint _tmp7__length1;
					gint _tmp8_;
					const gchar* _tmp9_;
					gchar** _tmp10_;
					gint _tmp10__length1;
					gint _tmp11_;
					const gchar* _tmp12_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = uris;
					_tmp7__length1 = uris_length1;
					_tmp8_ = i;
					_tmp9_ = _tmp7_[_tmp8_];
					if (!(_tmp9_ != NULL)) {
						break;
					}
					_tmp10_ = uris;
					_tmp10__length1 = uris_length1;
					_tmp11_ = i;
					_tmp12_ = _tmp10_[_tmp11_];
					rygel_media_object_add_uri ((RygelMediaObject*) item, _tmp12_);
				}
			}
		}
	}
	_tmp13_ = rygel_external_item_factory_get_string (self, props, "DLNAProfile");
	_tmp14_ = _tmp13_;
	rygel_media_file_item_set_dlna_profile (item, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = g_hash_table_lookup (props, "Size");
	_tmp16_ = _g_variant_ref0 ((GVariant*) _tmp15_);
	value = _tmp16_;
	_tmp17_ = value;
	if (_tmp17_ != NULL) {
		GVariant* _tmp18_;
		gint64 _tmp19_;
		_tmp18_ = value;
		_tmp19_ = _variant_get15 (_tmp18_);
		rygel_media_file_item_set_size (item, _tmp19_);
	}
	_tmp20_ = rygel_external_item_factory_get_string (self, props, "Date");
	_tmp21_ = _tmp20_;
	rygel_media_object_set_date ((RygelMediaObject*) item, _tmp21_);
	_g_free0 (_tmp21_);
	_g_variant_unref0 (value);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
}


static gchar*
_variant_get16 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}


static gchar*
rygel_external_item_factory_get_string (RygelExternalItemFactory* self,
                                        GHashTable* props,
                                        const gchar* prop)
{
	gchar* result = NULL;
	GVariant* value = NULL;
	gconstpointer _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (props != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (props, prop);
	_tmp1_ = _g_variant_ref0 ((GVariant*) _tmp0_);
	value = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ != NULL) {
		GVariant* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = value;
		_tmp4_ = _variant_get16 (_tmp3_);
		result = _tmp4_;
		_g_variant_unref0 (value);
		return result;
	} else {
		result = NULL;
		_g_variant_unref0 (value);
		return result;
	}
	_g_variant_unref0 (value);
}


static gint
_variant_get17 (GVariant* value)
{
	return g_variant_get_int32 (value);
}


static gint
rygel_external_item_factory_get_int (RygelExternalItemFactory* self,
                                     GHashTable* props,
                                     const gchar* prop)
{
	gint result = 0;
	GVariant* value = NULL;
	gconstpointer _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (props != NULL, 0);
	g_return_val_if_fail (prop != NULL, 0);
	_tmp0_ = g_hash_table_lookup (props, prop);
	_tmp1_ = _g_variant_ref0 ((GVariant*) _tmp0_);
	value = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ != NULL) {
		GVariant* _tmp3_;
		gint _tmp4_;
		_tmp3_ = value;
		_tmp4_ = _variant_get17 (_tmp3_);
		result = _tmp4_;
		_g_variant_unref0 (value);
		return result;
	} else {
		result = -1;
		_g_variant_unref0 (value);
		return result;
	}
	_g_variant_unref0 (value);
}


RygelExternalItemFactory*
rygel_external_item_factory_construct (GType object_type)
{
	RygelExternalItemFactory* self = NULL;
	self = (RygelExternalItemFactory*) g_type_create_instance (object_type);
	return self;
}


RygelExternalItemFactory*
rygel_external_item_factory_new (void)
{
	return rygel_external_item_factory_construct (RYGEL_EXTERNAL_TYPE_ITEM_FACTORY);
}


static void
rygel_external_value_item_factory_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
rygel_external_value_item_factory_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rygel_external_item_factory_unref (value->data[0].v_pointer);
	}
}


static void
rygel_external_value_item_factory_copy_value (const GValue* src_value,
                                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_external_item_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
rygel_external_value_item_factory_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
rygel_external_value_item_factory_collect_value (GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RygelExternalItemFactory * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_external_item_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
rygel_external_value_item_factory_lcopy_value (const GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	RygelExternalItemFactory ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_external_item_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
rygel_external_param_spec_item_factory (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags)
{
	RygelExternalParamSpecItemFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
rygel_external_value_get_item_factory (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void
rygel_external_value_set_item_factory (GValue* value,
                                       gpointer v_object)
{
	RygelExternalItemFactory * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_external_item_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_item_factory_unref (old);
	}
}


void
rygel_external_value_take_item_factory (GValue* value,
                                        gpointer v_object)
{
	RygelExternalItemFactory * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_item_factory_unref (old);
	}
}


static void
rygel_external_item_factory_class_init (RygelExternalItemFactoryClass * klass)
{
	rygel_external_item_factory_parent_class = g_type_class_peek_parent (klass);
	((RygelExternalItemFactoryClass *) klass)->finalize = rygel_external_item_factory_finalize;
}


static void
rygel_external_item_factory_instance_init (RygelExternalItemFactory * self)
{
	self->ref_count = 1;
}


static void
rygel_external_item_factory_finalize (RygelExternalItemFactory * obj)
{
	RygelExternalItemFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactory);
	g_signal_handlers_destroy (self);
}


/**
 * Creates item for external plugins.
 */
GType
rygel_external_item_factory_get_type (void)
{
	static volatile gsize rygel_external_item_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_item_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_external_value_item_factory_init, rygel_external_value_item_factory_free_value, rygel_external_value_item_factory_copy_value, rygel_external_value_item_factory_peek_pointer, "p", rygel_external_value_item_factory_collect_value, "p", rygel_external_value_item_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalItemFactory), 0, (GInstanceInitFunc) rygel_external_item_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_external_item_factory_type_id;
		rygel_external_item_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelExternalItemFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_external_item_factory_type_id__volatile, rygel_external_item_factory_type_id);
	}
	return rygel_external_item_factory_type_id__volatile;
}


gpointer
rygel_external_item_factory_ref (gpointer instance)
{
	RygelExternalItemFactory * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
rygel_external_item_factory_unref (gpointer instance)
{
	RygelExternalItemFactory * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



