/* rygel-thumbnailer.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-thumbnailer.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010-2011 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_TYPE_THUMBNAILER (rygel_thumbnailer_get_type ())
#define RYGEL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailer))
#define RYGEL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))
#define RYGEL_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))

typedef struct _RygelThumbnailer RygelThumbnailer;
typedef struct _RygelThumbnailerClass RygelThumbnailerClass;
typedef struct _RygelThumbnailerPrivate RygelThumbnailerPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_DBUS_THUMBNAILER (rygel_dbus_thumbnailer_get_type ())
#define RYGEL_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailer))
#define RYGEL_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailerClass))
#define RYGEL_IS_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_THUMBNAILER))
#define RYGEL_IS_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DBUS_THUMBNAILER))
#define RYGEL_DBUS_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailerClass))

typedef struct _RygelDbusThumbnailer RygelDbusThumbnailer;
typedef struct _RygelDbusThumbnailerClass RygelDbusThumbnailerClass;
enum  {
	RYGEL_THUMBNAILER_0_PROPERTY,
	RYGEL_THUMBNAILER_NUM_PROPERTIES
};
static GParamSpec* rygel_thumbnailer_properties[RYGEL_THUMBNAILER_NUM_PROPERTIES];
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

typedef enum  {
	THUMBNAILER_ERROR_NO_DIR,
	THUMBNAILER_ERROR_NO_THUMBNAIL
} ThumbnailerError;
#define THUMBNAILER_ERROR thumbnailer_error_quark ()
struct _RygelThumbnailer {
	GObject parent_instance;
	RygelThumbnailerPrivate * priv;
};

struct _RygelThumbnailerClass {
	GObjectClass parent_class;
};

struct _RygelThumbnailerPrivate {
	RygelThumbnail* template;
	gchar* extension;
	RygelDbusThumbnailer* thumbler;
};

struct _RygelThumbnail {
	RygelIconInfo parent_instance;
	RygelThumbnailPrivate * priv;
	gchar* dlna_profile;
};

struct _RygelThumbnailClass {
	RygelIconInfoClass parent_class;
	RygelMediaResource* (*get_resource) (RygelThumbnail* self, const gchar* protocol, gint index);
};


static gpointer rygel_thumbnailer_parent_class = NULL;
static RygelThumbnailer* rygel_thumbnailer_thumbnailer;
static RygelThumbnailer* rygel_thumbnailer_thumbnailer = NULL;
static gboolean rygel_thumbnailer_first_time;
static gboolean rygel_thumbnailer_first_time = TRUE;

GQuark thumbnailer_error_quark (void);
GType rygel_thumbnailer_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_dbus_thumbnailer_get_type (void) G_GNUC_CONST;
#define RYGEL_THUMBNAILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerPrivate))
static RygelThumbnailer* rygel_thumbnailer_new (GError** error);
static RygelThumbnailer* rygel_thumbnailer_construct (GType object_type,
                                               GError** error);
RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type,
                                     const gchar* dlna_profile,
                                     const gchar* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type,
                                           const gchar* mime_type,
                                           const gchar* dlna_profile,
                                           const gchar* file_extension);
RygelDbusThumbnailer* rygel_dbus_thumbnailer_new (const gchar* flavor,
                                                  GError** error);
RygelDbusThumbnailer* rygel_dbus_thumbnailer_construct (GType object_type,
                                                        const gchar* flavor,
                                                        GError** error);
static void rygel_thumbnailer_on_dbus_thumbnailer_ready (RygelThumbnailer* self,
                                                  gboolean available);
static void _rygel_thumbnailer_on_dbus_thumbnailer_ready_rygel_dbus_thumbnailer_ready (RygelDbusThumbnailer* _sender,
                                                                                gboolean available,
                                                                                gpointer self);
RygelThumbnailer* rygel_thumbnailer_get_default (void);
RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self,
                                                 const gchar* uri,
                                                 const gchar* mime_type,
                                                 GError** error);
void rygel_dbus_thumbnailer_queue_thumbnail_task (RygelDbusThumbnailer* self,
                                                  const gchar* uri,
                                                  const gchar* mime);
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
static void rygel_thumbnailer_finalize (GObject * obj);


GQuark
thumbnailer_error_quark (void)
{
	return g_quark_from_static_string ("thumbnailer_error-quark");
}


static void
_rygel_thumbnailer_on_dbus_thumbnailer_ready_rygel_dbus_thumbnailer_ready (RygelDbusThumbnailer* _sender,
                                                                           gboolean available,
                                                                           gpointer self)
{
	rygel_thumbnailer_on_dbus_thumbnailer_ready ((RygelThumbnailer*) self, available);
}


static RygelThumbnailer*
rygel_thumbnailer_construct (GType object_type,
                             GError** error)
{
	RygelThumbnailer * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelThumbnail* _tmp1_;
	RygelThumbnail* _tmp2_;
	RygelThumbnail* _tmp3_;
	RygelThumbnail* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (RygelThumbnailer*) g_object_new (object_type, NULL);
	_tmp0_ = rygel_thumbnail_new ("image/png", "PNG_TN", "png");
	_rygel_icon_info_unref0 (self->priv->template);
	self->priv->template = _tmp0_;
	_tmp1_ = self->priv->template;
	((RygelIconInfo*) _tmp1_)->width = 128;
	_tmp2_ = self->priv->template;
	((RygelIconInfo*) _tmp2_)->height = 128;
	_tmp3_ = self->priv->template;
	((RygelIconInfo*) _tmp3_)->depth = 24;
	_tmp4_ = self->priv->template;
	_tmp5_ = ((RygelIconInfo*) _tmp4_)->file_extension;
	_tmp6_ = g_strconcat (".", _tmp5_, NULL);
	_g_free0 (self->priv->extension);
	self->priv->extension = _tmp6_;
	{
		RygelDbusThumbnailer* _tmp7_ = NULL;
		RygelDbusThumbnailer* _tmp8_;
		RygelDbusThumbnailer* _tmp9_;
		RygelDbusThumbnailer* _tmp10_;
		_tmp8_ = rygel_dbus_thumbnailer_new ("normal", &_inner_error_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch81_g_error;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (self->priv->thumbler);
		self->priv->thumbler = _tmp9_;
		_tmp10_ = self->priv->thumbler;
		g_signal_connect_object (_tmp10_, "ready", (GCallback) _rygel_thumbnailer_on_dbus_thumbnailer_ready_rygel_dbus_thumbnailer_ready, self, 0);
		_g_object_unref0 (_tmp7_);
	}
	goto __finally81;
	__catch81_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally81:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == THUMBNAILER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


static RygelThumbnailer*
rygel_thumbnailer_new (GError** error)
{
	return rygel_thumbnailer_construct (RYGEL_TYPE_THUMBNAILER, error);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


RygelThumbnailer*
rygel_thumbnailer_get_default (void)
{
	RygelThumbnailer* result = NULL;
	gboolean _tmp0_;
	RygelThumbnailer* _tmp6_;
	RygelThumbnailer* _tmp7_;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_thumbnailer_first_time;
	if (_tmp0_) {
		{
			RygelThumbnailer* _tmp1_ = NULL;
			RygelThumbnailer* _tmp2_;
			RygelThumbnailer* _tmp3_;
			_tmp2_ = rygel_thumbnailer_new (&_inner_error_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == THUMBNAILER_ERROR) {
					goto __catch82_thumbnailer_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (rygel_thumbnailer_thumbnailer);
			rygel_thumbnailer_thumbnailer = _tmp3_;
			_g_object_unref0 (_tmp1_);
		}
		goto __finally82;
		__catch82_thumbnailer_error:
		{
			GError* err = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = err;
			_tmp5_ = _tmp4_->message;
			g_warning (_ ("No thumbnailer available: %s"), _tmp5_);
			_g_error_free0 (err);
		}
		__finally82:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		rygel_thumbnailer_first_time = FALSE;
	}
	_tmp6_ = rygel_thumbnailer_thumbnailer;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


RygelThumbnail*
rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self,
                                 const gchar* uri,
                                 const gchar* mime_type,
                                 GError** error)
{
	RygelThumbnail* result = NULL;
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* info = NULL;
	GFile* _tmp3_;
	GFileInfo* _tmp4_;
	gchar* path = NULL;
	GFileInfo* _tmp5_;
	gchar* _tmp6_;
	gboolean failed = FALSE;
	GFileInfo* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	RygelDbusThumbnailer* _tmp12_;
	const gchar* _tmp16_;
	const gchar* _tmp18_;
	GFile* _tmp19_;
	GFileInfo* _tmp20_ = NULL;
	GFile* _tmp21_;
	GFileInfo* _tmp22_;
	GFileInfo* _tmp23_;
	GFileInfo* _tmp24_;
	RygelThumbnail* thumbnail = NULL;
	RygelThumbnail* _tmp26_;
	const gchar* _tmp27_;
	RygelThumbnail* _tmp28_;
	const gchar* _tmp29_;
	RygelThumbnail* _tmp30_;
	const gchar* _tmp31_;
	RygelThumbnail* _tmp32_;
	RygelThumbnail* _tmp33_;
	RygelThumbnail* _tmp34_;
	gint _tmp35_;
	RygelThumbnail* _tmp36_;
	RygelThumbnail* _tmp37_;
	gint _tmp38_;
	RygelThumbnail* _tmp39_;
	RygelThumbnail* _tmp40_;
	gint _tmp41_;
	gchar* _tmp42_ = NULL;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	RygelThumbnail* _tmp45_;
	gchar* _tmp46_;
	RygelThumbnail* _tmp47_;
	GFileInfo* _tmp48_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	file = _tmp0_;
	_tmp1_ = file;
	if (!g_file_is_native (_tmp1_)) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _ ("Thumbnailing not supported"));
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp3_ = file;
	_tmp4_ = g_file_query_info (_tmp3_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH "," G_FILE_ATTRIBUTE_THUMBNAILING_FAILED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp5_ = info;
	_tmp6_ = g_file_info_get_attribute_as_string (_tmp5_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
	path = _tmp6_;
	_tmp7_ = info;
	failed = g_file_info_get_attribute_boolean (_tmp7_, G_FILE_ATTRIBUTE_THUMBNAILING_FAILED);
	_tmp8_ = failed;
	if (_tmp8_) {
		GError* _tmp9_;
		_tmp9_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _ ("No thumbnail available"));
		_inner_error_ = _tmp9_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp12_ = self->priv->thumbler;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		_tmp13_ = path;
		_tmp11_ = _tmp13_ == NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		_tmp10_ = mime_type != NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		RygelDbusThumbnailer* _tmp14_;
		GError* _tmp15_;
		_tmp14_ = self->priv->thumbler;
		rygel_dbus_thumbnailer_queue_thumbnail_task (_tmp14_, uri, mime_type);
		_tmp15_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _ ("No thumbnail available. Generation requested."));
		_inner_error_ = _tmp15_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp16_ = path;
	if (_tmp16_ == NULL) {
		GError* _tmp17_;
		_tmp17_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _ ("No thumbnail available"));
		_inner_error_ = _tmp17_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp18_ = path;
	_tmp19_ = g_file_new_for_path (_tmp18_);
	_g_object_unref0 (file);
	file = _tmp19_;
	_tmp21_ = file;
	_tmp22_ = g_file_query_info (_tmp21_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	_tmp20_ = _tmp22_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp23_ = _tmp20_;
	_tmp20_ = NULL;
	_g_object_unref0 (info);
	info = _tmp23_;
	_tmp24_ = info;
	if (!g_file_info_get_attribute_boolean (_tmp24_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
		GError* _tmp25_;
		_tmp25_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _ ("No thumbnail available"));
		_inner_error_ = _tmp25_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp20_);
		_g_free0 (path);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp26_ = self->priv->template;
	_tmp27_ = ((RygelIconInfo*) _tmp26_)->mime_type;
	_tmp28_ = self->priv->template;
	_tmp29_ = _tmp28_->dlna_profile;
	_tmp30_ = self->priv->template;
	_tmp31_ = ((RygelIconInfo*) _tmp30_)->file_extension;
	_tmp32_ = rygel_thumbnail_new (_tmp27_, _tmp29_, _tmp31_);
	thumbnail = _tmp32_;
	_tmp33_ = thumbnail;
	_tmp34_ = self->priv->template;
	_tmp35_ = ((RygelIconInfo*) _tmp34_)->width;
	((RygelIconInfo*) _tmp33_)->width = _tmp35_;
	_tmp36_ = thumbnail;
	_tmp37_ = self->priv->template;
	_tmp38_ = ((RygelIconInfo*) _tmp37_)->height;
	((RygelIconInfo*) _tmp36_)->height = _tmp38_;
	_tmp39_ = thumbnail;
	_tmp40_ = self->priv->template;
	_tmp41_ = ((RygelIconInfo*) _tmp40_)->depth;
	((RygelIconInfo*) _tmp39_)->depth = _tmp41_;
	_tmp43_ = path;
	_tmp44_ = g_filename_to_uri (_tmp43_, NULL, &_inner_error_);
	_tmp42_ = _tmp44_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_rygel_icon_info_unref0 (thumbnail);
		_g_object_unref0 (_tmp20_);
		_g_free0 (path);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp45_ = thumbnail;
	_tmp46_ = _tmp42_;
	_tmp42_ = NULL;
	_g_free0 (((RygelIconInfo*) _tmp45_)->uri);
	((RygelIconInfo*) _tmp45_)->uri = _tmp46_;
	_tmp47_ = thumbnail;
	_tmp48_ = info;
	((RygelIconInfo*) _tmp47_)->size = (gint64) g_file_info_get_attribute_uint64 (_tmp48_, G_FILE_ATTRIBUTE_STANDARD_SIZE);
	result = thumbnail;
	_g_free0 (_tmp42_);
	_g_object_unref0 (_tmp20_);
	_g_free0 (path);
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	return result;
}


static void
rygel_thumbnailer_on_dbus_thumbnailer_ready (RygelThumbnailer* self,
                                             gboolean available)
{
	g_return_if_fail (self != NULL);
	if (!available) {
		_g_object_unref0 (self->priv->thumbler);
		self->priv->thumbler = NULL;
		g_message ("rygel-thumbnailer.vala:132: %s", _ ("No D-Bus thumbnailer available"));
	}
}


static void
rygel_thumbnailer_class_init (RygelThumbnailerClass * klass)
{
	rygel_thumbnailer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelThumbnailerPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_thumbnailer_finalize;
}


static void
rygel_thumbnailer_instance_init (RygelThumbnailer * self)
{
	self->priv = RYGEL_THUMBNAILER_GET_PRIVATE (self);
	self->priv->thumbler = NULL;
}


static void
rygel_thumbnailer_finalize (GObject * obj)
{
	RygelThumbnailer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_THUMBNAILER, RygelThumbnailer);
	_rygel_icon_info_unref0 (self->priv->template);
	_g_free0 (self->priv->extension);
	_g_object_unref0 (self->priv->thumbler);
	G_OBJECT_CLASS (rygel_thumbnailer_parent_class)->finalize (obj);
}


/**
 * Provides thumbnails for images and videos.
 */
GType
rygel_thumbnailer_get_type (void)
{
	static volatile gsize rygel_thumbnailer_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnailer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnailer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnailer), 0, (GInstanceInitFunc) rygel_thumbnailer_instance_init, NULL };
		GType rygel_thumbnailer_type_id;
		rygel_thumbnailer_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnailer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnailer_type_id__volatile, rygel_thumbnailer_type_id);
	}
	return rygel_thumbnailer_type_id__volatile;
}



