/* rygel-media-export-item-factory.c generated by valac 0.32.0.15-114e9, the Vala compiler
 * generated from rygel-media-export-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2012,2013 Intel Corporation.
 * Copyright (C) 2015 Jens Georg
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *         Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <gio/gio.h>

#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))

typedef enum  {
	RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_DESERIALIZATION,
	RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_MISMATCH
} RygelMediaExportItemFactoryItemFactoryError;
#define RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR rygel_media_export_item_factory_item_factory_error_quark ()
struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};



GQuark rygel_media_export_item_factory_item_factory_error_quark (void);
gboolean rygel_media_export_item_factory_check_variant_type (GVariant* v, const gchar* typestring, GError** error);
RygelMediaObject* rygel_media_export_item_factory_create (RygelMediaContainer* parent, GVariantDict* vd);
#define RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS "UPnPClass"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ID "Id"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE "Title"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_URI "Uri"
GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);
RygelMediaContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self, const gchar* id, const gchar* title, guint child_count, const gchar* uri);
RygelMediaFileItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self, RygelMediaContainer* parent, const gchar* id, const gchar* title, const gchar* upnp_class);
gint64 rygel_media_export_item_factory_get_int64 (GVariantDict* vd, const gchar* key);
gint32 rygel_media_export_item_factory_get_int32 (GVariantDict* vd, const gchar* key);
RygelMediaObject* rygel_media_export_item_factory_create_from_variant (RygelMediaContainer* parent, GFile* file, GVariant* v, GError** error);
#define RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE "MimeType"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_SIZE "Size"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_MODIFIED "MTime"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DLNA_PROFILE "DLNAProfile"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DATE "Date"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DURATION "Duration"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_BITRATE "AudioBitrate"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_CHANNELS "AudioChannels"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_RATE "AudioRate"
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ARTIST "Artist"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ALBUM "Album"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_GENRE "Genre"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_TRACK_NUMBER "TrackNumber"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VOLUME_NUMBER "VolumeNumber"
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_WIDTH "VideoWidth"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_HEIGHT "VideoHeight"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_DEPTH "VideoDepth"
void rygel_media_export_item_factory_apply_meta_data (RygelMediaFileItem* item, GVariant* v, GError** error);
void rygel_media_export_item_factory_apply_video_info (RygelMediaFileItem* item, GVariant* v, GError** error);
void rygel_media_export_item_factory_apply_audio_info (RygelMediaFileItem* item, GVariant* v, GError** error);
void rygel_media_export_item_factory_apply_info (RygelMediaFileItem* item, GVariant* v, GError** error);
void rygel_media_export_item_factory_apply_dlna_profile (RygelMediaFileItem* item, GVariant* v, GError** error);
void rygel_media_export_item_factory_apply_file_info (RygelMediaObject* object, GVariant* v, GError** error);


GQuark rygel_media_export_item_factory_item_factory_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_item_factory_item_factory_error-quark");
}


gboolean rygel_media_export_item_factory_check_variant_type (GVariant* v, const gchar* typestring, GError** error) {
	gboolean result = FALSE;
	GVariant* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GVariantType* _tmp2_ = NULL;
	GVariantType* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (v != NULL, FALSE);
	g_return_val_if_fail (typestring != NULL, FALSE);
	_tmp0_ = v;
	_tmp1_ = typestring;
	_tmp2_ = g_variant_type_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_is_of_type (_tmp0_, _tmp3_);
	_tmp5_ = !_tmp4_;
	_g_variant_type_free0 (_tmp3_);
	if (_tmp5_) {
		gchar* msg = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GVariant* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		_tmp6_ = g_strdup ("Variant type mismatch, expected %s, got %s");
		msg = _tmp6_;
		_tmp7_ = msg;
		_tmp8_ = v;
		_tmp9_ = g_variant_get_type_string (_tmp8_);
		_tmp10_ = typestring;
		_tmp11_ = g_error_new (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR, RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_DESERIALIZATION, _tmp7_, _tmp9_, _tmp10_);
		_inner_error_ = _tmp11_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return FALSE;
	}
	result = TRUE;
	return result;
}


RygelMediaObject* rygel_media_export_item_factory_create (RygelMediaContainer* parent, GVariantDict* vd) {
	RygelMediaObject* result = NULL;
	GVariantType* expected = NULL;
	RygelMediaObject* object = NULL;
	GVariant* upnp_class = NULL;
	GVariantDict* _tmp0_ = NULL;
	const GVariantType* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* id = NULL;
	GVariantDict* _tmp3_ = NULL;
	const GVariantType* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* title = NULL;
	GVariantDict* _tmp6_ = NULL;
	const GVariantType* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	GVariant* uri = NULL;
	GVariantDict* _tmp9_ = NULL;
	const GVariantType* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	RygelMediaExportObjectFactory* factory = NULL;
	RygelMediaExportObjectFactory* _tmp12_ = NULL;
	GVariant* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	RygelMediaObject* _tmp33_ = NULL;
	GVariant* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (vd != NULL, NULL);
	expected = NULL;
	object = NULL;
	_tmp0_ = vd;
	_tmp1_ = expected;
	_tmp2_ = g_variant_dict_lookup_value (_tmp0_, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, _tmp1_);
	upnp_class = _tmp2_;
	_tmp3_ = vd;
	_tmp4_ = expected;
	_tmp5_ = g_variant_dict_lookup_value (_tmp3_, RYGEL_MEDIA_EXPORT_SERIALIZER_ID, _tmp4_);
	id = _tmp5_;
	_tmp6_ = vd;
	_tmp7_ = expected;
	_tmp8_ = g_variant_dict_lookup_value (_tmp6_, RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE, _tmp7_);
	title = _tmp8_;
	_tmp9_ = vd;
	_tmp10_ = expected;
	_tmp11_ = g_variant_dict_lookup_value (_tmp9_, RYGEL_MEDIA_EXPORT_SERIALIZER_URI, _tmp10_);
	uri = _tmp11_;
	_tmp12_ = rygel_media_export_object_factory_new ();
	factory = _tmp12_;
	_tmp13_ = upnp_class;
	_tmp14_ = g_variant_get_string (_tmp13_, NULL);
	_tmp15_ = g_str_has_prefix (_tmp14_, RYGEL_MEDIA_CONTAINER_UPNP_CLASS);
	if (_tmp15_) {
		RygelMediaExportObjectFactory* _tmp16_ = NULL;
		GVariant* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		GVariant* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GVariant* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		RygelMediaContainer* _tmp23_ = NULL;
		_tmp16_ = factory;
		_tmp17_ = id;
		_tmp18_ = g_variant_get_string (_tmp17_, NULL);
		_tmp19_ = title;
		_tmp20_ = g_variant_get_string (_tmp19_, NULL);
		_tmp21_ = uri;
		_tmp22_ = g_variant_get_string (_tmp21_, NULL);
		_tmp23_ = rygel_media_export_object_factory_get_container (_tmp16_, _tmp18_, _tmp20_, (guint) 0, _tmp22_);
		_g_object_unref0 (object);
		object = (RygelMediaObject*) _tmp23_;
	} else {
		RygelMediaExportObjectFactory* _tmp24_ = NULL;
		RygelMediaContainer* _tmp25_ = NULL;
		GVariant* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		GVariant* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		GVariant* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		RygelMediaFileItem* _tmp32_ = NULL;
		_tmp24_ = factory;
		_tmp25_ = parent;
		_tmp26_ = id;
		_tmp27_ = g_variant_get_string (_tmp26_, NULL);
		_tmp28_ = title;
		_tmp29_ = g_variant_get_string (_tmp28_, NULL);
		_tmp30_ = upnp_class;
		_tmp31_ = g_variant_get_string (_tmp30_, NULL);
		_tmp32_ = rygel_media_export_object_factory_get_item (_tmp24_, _tmp25_, _tmp27_, _tmp29_, _tmp31_);
		_g_object_unref0 (object);
		object = (RygelMediaObject*) _tmp32_;
	}
	_tmp33_ = object;
	_tmp34_ = uri;
	_tmp35_ = g_variant_get_string (_tmp34_, NULL);
	rygel_media_object_add_uri (_tmp33_, _tmp35_);
	result = object;
	_g_object_unref0 (factory);
	_g_variant_unref0 (uri);
	_g_variant_unref0 (title);
	_g_variant_unref0 (id);
	_g_variant_unref0 (upnp_class);
	_g_variant_type_free0 (expected);
	return result;
}


gint64 rygel_media_export_item_factory_get_int64 (GVariantDict* vd, const gchar* key) {
	gint64 result = 0LL;
	GVariant* val = NULL;
	GVariantDict* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const GVariantType* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	g_return_val_if_fail (vd != NULL, 0LL);
	g_return_val_if_fail (key != NULL, 0LL);
	_tmp0_ = vd;
	_tmp1_ = key;
	_tmp2_ = G_VARIANT_TYPE_UINT64;
	_tmp3_ = g_variant_dict_lookup_value (_tmp0_, _tmp1_, _tmp2_);
	val = _tmp3_;
	_tmp4_ = val;
	if (_tmp4_ != NULL) {
		GVariant* _tmp5_ = NULL;
		guint64 _tmp6_ = 0ULL;
		_tmp5_ = val;
		_tmp6_ = g_variant_get_uint64 (_tmp5_);
		result = (gint64) _tmp6_;
		_g_variant_unref0 (val);
		return result;
	}
	result = (gint64) -1;
	_g_variant_unref0 (val);
	return result;
}


gint32 rygel_media_export_item_factory_get_int32 (GVariantDict* vd, const gchar* key) {
	gint32 result = 0;
	GVariant* val = NULL;
	GVariantDict* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const GVariantType* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	g_return_val_if_fail (vd != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp0_ = vd;
	_tmp1_ = key;
	_tmp2_ = G_VARIANT_TYPE_INT32;
	_tmp3_ = g_variant_dict_lookup_value (_tmp0_, _tmp1_, _tmp2_);
	val = _tmp3_;
	_tmp4_ = val;
	if (_tmp4_ != NULL) {
		GVariant* _tmp5_ = NULL;
		gint32 _tmp6_ = 0;
		_tmp5_ = val;
		_tmp6_ = g_variant_get_int32 (_tmp5_);
		result = _tmp6_;
		_g_variant_unref0 (val);
		return result;
	}
	result = (gint32) -1;
	_g_variant_unref0 (val);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaObject* rygel_media_export_item_factory_create_from_variant (RygelMediaContainer* parent, GFile* file, GVariant* v, GError** error) {
	RygelMediaObject* result = NULL;
	GVariantType* expected = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantDict* vd = NULL;
	GVariant* _tmp2_ = NULL;
	GVariantDict* _tmp3_ = NULL;
	GVariant* upnp_class = NULL;
	GVariantDict* _tmp4_ = NULL;
	const GVariantType* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	RygelMediaObject* object = NULL;
	RygelMediaContainer* _tmp8_ = NULL;
	GVariantDict* _tmp9_ = NULL;
	RygelMediaObject* _tmp10_ = NULL;
	RygelMediaObject* _tmp11_ = NULL;
	RygelMediaFileItem* item = NULL;
	RygelMediaObject* _tmp12_ = NULL;
	RygelMediaFileItem* _tmp13_ = NULL;
	GVariant* val = NULL;
	GVariantDict* _tmp14_ = NULL;
	const GVariantType* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	RygelMediaFileItem* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	RygelMediaFileItem* _tmp20_ = NULL;
	GVariantDict* _tmp21_ = NULL;
	gint64 _tmp22_ = 0LL;
	GVariantDict* _tmp23_ = NULL;
	const GVariantType* _tmp24_ = NULL;
	GVariant* _tmp25_ = NULL;
	RygelMediaFileItem* _tmp26_ = NULL;
	GVariant* _tmp27_ = NULL;
	guint64 _tmp28_ = 0ULL;
	GVariantDict* _tmp29_ = NULL;
	const GVariantType* _tmp30_ = NULL;
	GVariant* _tmp31_ = NULL;
	GVariant* _tmp32_ = NULL;
	GVariantDict* _tmp36_ = NULL;
	const GVariantType* _tmp37_ = NULL;
	GVariant* _tmp38_ = NULL;
	GVariant* _tmp39_ = NULL;
	RygelMediaFileItem* _tmp43_ = NULL;
	RygelMediaFileItem* _tmp88_ = NULL;
	RygelMediaFileItem* _tmp100_ = NULL;
	RygelMediaObject* _tmp101_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	expected = NULL;
	_tmp0_ = v;
	if (_tmp0_ == NULL) {
		result = NULL;
		_g_variant_type_free0 (expected);
		return result;
	}
	_tmp1_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp1_, "a{sv}", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_variant_type_free0 (expected);
		return NULL;
	}
	_tmp2_ = v;
	_tmp3_ = g_variant_dict_new (_tmp2_);
	vd = _tmp3_;
	_tmp4_ = vd;
	_tmp5_ = expected;
	_tmp6_ = g_variant_dict_lookup_value (_tmp4_, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, _tmp5_);
	upnp_class = _tmp6_;
	_tmp7_ = upnp_class;
	if (_tmp7_ == NULL) {
		g_debug ("rygel-media-export-item-factory.vala:115: Did not find a UPnP class fo" \
"r item, ignoring");
		result = NULL;
		_g_variant_unref0 (upnp_class);
		_g_variant_dict_unref0 (vd);
		_g_variant_type_free0 (expected);
		return result;
	}
	_tmp8_ = parent;
	_tmp9_ = vd;
	_tmp10_ = rygel_media_export_item_factory_create (_tmp8_, _tmp9_);
	object = _tmp10_;
	_tmp11_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_MEDIA_CONTAINER)) {
		result = object;
		_g_variant_unref0 (upnp_class);
		_g_variant_dict_unref0 (vd);
		_g_variant_type_free0 (expected);
		return result;
	}
	_tmp12_ = object;
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp12_) : NULL);
	item = _tmp13_;
	_tmp14_ = vd;
	_tmp15_ = expected;
	_tmp16_ = g_variant_dict_lookup_value (_tmp14_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, _tmp15_);
	val = _tmp16_;
	_tmp17_ = item;
	_tmp18_ = val;
	_tmp19_ = g_variant_get_string (_tmp18_, NULL);
	rygel_media_file_item_set_mime_type (_tmp17_, _tmp19_);
	_tmp20_ = item;
	_tmp21_ = vd;
	_tmp22_ = rygel_media_export_item_factory_get_int64 (_tmp21_, RYGEL_MEDIA_EXPORT_SERIALIZER_SIZE);
	rygel_media_file_item_set_size (_tmp20_, _tmp22_);
	_tmp23_ = vd;
	_tmp24_ = expected;
	_tmp25_ = g_variant_dict_lookup_value (_tmp23_, RYGEL_MEDIA_EXPORT_SERIALIZER_MODIFIED, _tmp24_);
	_g_variant_unref0 (val);
	val = _tmp25_;
	_tmp26_ = item;
	_tmp27_ = val;
	_tmp28_ = g_variant_get_uint64 (_tmp27_);
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp26_, _tmp28_);
	_tmp29_ = vd;
	_tmp30_ = expected;
	_tmp31_ = g_variant_dict_lookup_value (_tmp29_, RYGEL_MEDIA_EXPORT_SERIALIZER_DLNA_PROFILE, _tmp30_);
	_g_variant_unref0 (val);
	val = _tmp31_;
	_tmp32_ = val;
	if (_tmp32_ != NULL) {
		RygelMediaFileItem* _tmp33_ = NULL;
		GVariant* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		_tmp33_ = item;
		_tmp34_ = val;
		_tmp35_ = g_variant_get_string (_tmp34_, NULL);
		rygel_media_file_item_set_dlna_profile (_tmp33_, _tmp35_);
	}
	_tmp36_ = vd;
	_tmp37_ = expected;
	_tmp38_ = g_variant_dict_lookup_value (_tmp36_, RYGEL_MEDIA_EXPORT_SERIALIZER_DATE, _tmp37_);
	_g_variant_unref0 (val);
	val = _tmp38_;
	_tmp39_ = val;
	if (_tmp39_ != NULL) {
		RygelMediaFileItem* _tmp40_ = NULL;
		GVariant* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		_tmp40_ = item;
		_tmp41_ = val;
		_tmp42_ = g_variant_get_string (_tmp41_, NULL);
		rygel_media_object_set_date ((RygelMediaObject*) _tmp40_, _tmp42_);
	}
	_tmp43_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelAudioItem* audio_item = NULL;
		RygelMediaFileItem* _tmp44_ = NULL;
		RygelAudioItem* _tmp45_ = NULL;
		RygelAudioItem* _tmp46_ = NULL;
		GVariantDict* _tmp47_ = NULL;
		gint32 _tmp48_ = 0;
		RygelAudioItem* _tmp49_ = NULL;
		GVariantDict* _tmp50_ = NULL;
		gint32 _tmp51_ = 0;
		RygelAudioItem* _tmp52_ = NULL;
		GVariantDict* _tmp53_ = NULL;
		gint32 _tmp54_ = 0;
		RygelAudioItem* _tmp55_ = NULL;
		GVariantDict* _tmp56_ = NULL;
		gint32 _tmp57_ = 0;
		RygelMediaFileItem* _tmp58_ = NULL;
		_tmp44_ = item;
		_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp44_) : NULL);
		audio_item = _tmp45_;
		_tmp46_ = audio_item;
		_tmp47_ = vd;
		_tmp48_ = rygel_media_export_item_factory_get_int32 (_tmp47_, RYGEL_MEDIA_EXPORT_SERIALIZER_DURATION);
		rygel_audio_item_set_duration (_tmp46_, (glong) _tmp48_);
		_tmp49_ = audio_item;
		_tmp50_ = vd;
		_tmp51_ = rygel_media_export_item_factory_get_int32 (_tmp50_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_BITRATE);
		rygel_audio_item_set_bitrate (_tmp49_, (gint) _tmp51_);
		_tmp52_ = audio_item;
		_tmp53_ = vd;
		_tmp54_ = rygel_media_export_item_factory_get_int32 (_tmp53_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_CHANNELS);
		rygel_audio_item_set_channels (_tmp52_, (gint) _tmp54_);
		_tmp55_ = audio_item;
		_tmp56_ = vd;
		_tmp57_ = rygel_media_export_item_factory_get_int32 (_tmp56_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_RATE);
		rygel_audio_item_set_sample_freq (_tmp55_, (gint) _tmp57_);
		_tmp58_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp58_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaFileItem* _tmp59_ = NULL;
			RygelMediaExportMusicItem* _tmp60_ = NULL;
			GVariantDict* _tmp61_ = NULL;
			const GVariantType* _tmp62_ = NULL;
			GVariant* _tmp63_ = NULL;
			GVariant* _tmp64_ = NULL;
			GVariantDict* _tmp68_ = NULL;
			const GVariantType* _tmp69_ = NULL;
			GVariant* _tmp70_ = NULL;
			GVariant* _tmp71_ = NULL;
			GVariantDict* _tmp75_ = NULL;
			const GVariantType* _tmp76_ = NULL;
			GVariant* _tmp77_ = NULL;
			GVariant* _tmp78_ = NULL;
			RygelMediaExportMusicItem* _tmp82_ = NULL;
			GVariantDict* _tmp83_ = NULL;
			gint32 _tmp84_ = 0;
			RygelMediaExportMusicItem* _tmp85_ = NULL;
			GVariantDict* _tmp86_ = NULL;
			gint32 _tmp87_ = 0;
			_tmp59_ = item;
			_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp59_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp59_) : NULL);
			music_item = _tmp60_;
			_tmp61_ = vd;
			_tmp62_ = expected;
			_tmp63_ = g_variant_dict_lookup_value (_tmp61_, RYGEL_MEDIA_EXPORT_SERIALIZER_ARTIST, _tmp62_);
			_g_variant_unref0 (val);
			val = _tmp63_;
			_tmp64_ = val;
			if (_tmp64_ != NULL) {
				RygelMediaExportMusicItem* _tmp65_ = NULL;
				GVariant* _tmp66_ = NULL;
				const gchar* _tmp67_ = NULL;
				_tmp65_ = music_item;
				_tmp66_ = val;
				_tmp67_ = g_variant_get_string (_tmp66_, NULL);
				rygel_media_object_set_artist ((RygelMediaObject*) _tmp65_, _tmp67_);
			}
			_tmp68_ = vd;
			_tmp69_ = expected;
			_tmp70_ = g_variant_dict_lookup_value (_tmp68_, RYGEL_MEDIA_EXPORT_SERIALIZER_ALBUM, _tmp69_);
			_g_variant_unref0 (val);
			val = _tmp70_;
			_tmp71_ = val;
			if (_tmp71_ != NULL) {
				RygelMediaExportMusicItem* _tmp72_ = NULL;
				GVariant* _tmp73_ = NULL;
				const gchar* _tmp74_ = NULL;
				_tmp72_ = music_item;
				_tmp73_ = val;
				_tmp74_ = g_variant_get_string (_tmp73_, NULL);
				rygel_audio_item_set_album ((RygelAudioItem*) _tmp72_, _tmp74_);
			}
			_tmp75_ = vd;
			_tmp76_ = expected;
			_tmp77_ = g_variant_dict_lookup_value (_tmp75_, RYGEL_MEDIA_EXPORT_SERIALIZER_GENRE, _tmp76_);
			_g_variant_unref0 (val);
			val = _tmp77_;
			_tmp78_ = val;
			if (_tmp78_ != NULL) {
				RygelMediaExportMusicItem* _tmp79_ = NULL;
				GVariant* _tmp80_ = NULL;
				const gchar* _tmp81_ = NULL;
				_tmp79_ = music_item;
				_tmp80_ = val;
				_tmp81_ = g_variant_get_string (_tmp80_, NULL);
				rygel_media_object_set_genre ((RygelMediaObject*) _tmp79_, _tmp81_);
			}
			_tmp82_ = music_item;
			_tmp83_ = vd;
			_tmp84_ = rygel_media_export_item_factory_get_int32 (_tmp83_, RYGEL_MEDIA_EXPORT_SERIALIZER_TRACK_NUMBER);
			rygel_music_item_set_track_number ((RygelMusicItem*) _tmp82_, (gint) _tmp84_);
			_tmp85_ = music_item;
			_tmp86_ = vd;
			_tmp87_ = rygel_media_export_item_factory_get_int32 (_tmp86_, RYGEL_MEDIA_EXPORT_SERIALIZER_VOLUME_NUMBER);
			_tmp85_->disc = (gint) _tmp87_;
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	_tmp88_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp88_, RYGEL_TYPE_VISUAL_ITEM)) {
		RygelVisualItem* visual_item = NULL;
		RygelMediaFileItem* _tmp89_ = NULL;
		RygelVisualItem* _tmp90_ = NULL;
		RygelVisualItem* _tmp91_ = NULL;
		GVariantDict* _tmp92_ = NULL;
		gint32 _tmp93_ = 0;
		RygelVisualItem* _tmp94_ = NULL;
		GVariantDict* _tmp95_ = NULL;
		gint32 _tmp96_ = 0;
		RygelVisualItem* _tmp97_ = NULL;
		GVariantDict* _tmp98_ = NULL;
		gint32 _tmp99_ = 0;
		_tmp89_ = item;
		_tmp90_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp89_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp89_) : NULL);
		visual_item = _tmp90_;
		_tmp91_ = visual_item;
		_tmp92_ = vd;
		_tmp93_ = rygel_media_export_item_factory_get_int32 (_tmp92_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_WIDTH);
		rygel_visual_item_set_width (_tmp91_, (gint) _tmp93_);
		_tmp94_ = visual_item;
		_tmp95_ = vd;
		_tmp96_ = rygel_media_export_item_factory_get_int32 (_tmp95_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_HEIGHT);
		rygel_visual_item_set_height (_tmp94_, (gint) _tmp96_);
		_tmp97_ = visual_item;
		_tmp98_ = vd;
		_tmp99_ = rygel_media_export_item_factory_get_int32 (_tmp98_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_DEPTH);
		rygel_visual_item_set_color_depth (_tmp97_, (gint) _tmp99_);
		_g_object_unref0 (visual_item);
	}
	_tmp100_ = item;
	_tmp101_ = _g_object_ref0 ((RygelMediaObject*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp100_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp100_) : NULL));
	result = _tmp101_;
	_g_variant_unref0 (val);
	_g_object_unref0 (item);
	_g_object_unref0 (object);
	_g_variant_unref0 (upnp_class);
	_g_variant_dict_unref0 (vd);
	_g_variant_type_free0 (expected);
	return result;
}


void rygel_media_export_item_factory_apply_meta_data (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantIter* _tmp2_ = NULL;
	GVariant* val = NULL;
	GVariantIter* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	RygelMediaFileItem* _tmp12_ = NULL;
	GVariantIter* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	gchar* album = NULL;
	gchar* _tmp21_ = NULL;
	GVariantIter* _tmp22_ = NULL;
	GVariant* _tmp23_ = NULL;
	GVariant* _tmp24_ = NULL;
	GVariant* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	GVariant* _tmp27_ = NULL;
	RygelMediaFileItem* _tmp30_ = NULL;
	gint32 disc = 0;
	GVariantIter* _tmp31_ = NULL;
	GVariant* _tmp32_ = NULL;
	GVariant* _tmp33_ = NULL;
	gint32 _tmp34_ = 0;
	gint32 _tmp35_ = 0;
	RygelMediaFileItem* _tmp36_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(msmsmsiii)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	it = _tmp2_;
	_tmp3_ = it;
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_get_maybe (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp5_);
	val = _tmp7_;
	_tmp9_ = val;
	if (_tmp9_ == NULL) {
		_g_free0 (_tmp8_);
		_tmp8_ = NULL;
	} else {
		GVariant* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp10_ = val;
		_tmp11_ = g_variant_dup_string (_tmp10_, NULL);
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp11_;
	}
	_tmp12_ = item;
	rygel_media_object_set_artist ((RygelMediaObject*) _tmp12_, _tmp8_);
	_tmp13_ = it;
	_tmp14_ = g_variant_iter_next_value (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_variant_get_maybe (_tmp15_);
	_g_variant_unref0 (val);
	val = _tmp16_;
	_g_variant_unref0 (_tmp15_);
	_tmp18_ = val;
	if (_tmp18_ == NULL) {
		_g_free0 (_tmp17_);
		_tmp17_ = NULL;
	} else {
		GVariant* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp19_ = val;
		_tmp20_ = g_variant_dup_string (_tmp19_, NULL);
		_g_free0 (_tmp17_);
		_tmp17_ = _tmp20_;
	}
	_tmp21_ = g_strdup (_tmp17_);
	album = _tmp21_;
	_tmp22_ = it;
	_tmp23_ = g_variant_iter_next_value (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_variant_get_maybe (_tmp24_);
	_g_variant_unref0 (val);
	val = _tmp25_;
	_g_variant_unref0 (_tmp24_);
	_tmp27_ = val;
	if (_tmp27_ == NULL) {
		_g_free0 (_tmp26_);
		_tmp26_ = NULL;
	} else {
		GVariant* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		_tmp28_ = val;
		_tmp29_ = g_variant_dup_string (_tmp28_, NULL);
		_g_free0 (_tmp26_);
		_tmp26_ = _tmp29_;
	}
	_tmp30_ = item;
	rygel_media_object_set_genre ((RygelMediaObject*) _tmp30_, _tmp26_);
	_tmp31_ = it;
	_tmp32_ = g_variant_iter_next_value (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_variant_get_int32 (_tmp33_);
	_tmp35_ = _tmp34_;
	_g_variant_unref0 (_tmp33_);
	disc = _tmp35_;
	_tmp36_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelAudioItem* audio_item = NULL;
		RygelMediaFileItem* _tmp37_ = NULL;
		RygelAudioItem* _tmp38_ = NULL;
		gint32 track_number = 0;
		GVariantIter* _tmp39_ = NULL;
		GVariant* _tmp40_ = NULL;
		GVariant* _tmp41_ = NULL;
		gint32 _tmp42_ = 0;
		gint32 _tmp43_ = 0;
		RygelAudioItem* _tmp44_ = NULL;
		GVariantIter* _tmp45_ = NULL;
		GVariant* _tmp46_ = NULL;
		GVariant* _tmp47_ = NULL;
		gint32 _tmp48_ = 0;
		RygelAudioItem* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		RygelMediaFileItem* _tmp51_ = NULL;
		_tmp37_ = item;
		_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp37_) : NULL);
		audio_item = _tmp38_;
		_tmp39_ = it;
		_tmp40_ = g_variant_iter_next_value (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_variant_get_int32 (_tmp41_);
		_tmp43_ = _tmp42_;
		_g_variant_unref0 (_tmp41_);
		track_number = _tmp43_;
		_tmp44_ = audio_item;
		_tmp45_ = it;
		_tmp46_ = g_variant_iter_next_value (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_variant_get_int32 (_tmp47_);
		rygel_audio_item_set_bitrate (_tmp44_, (gint) _tmp48_);
		_g_variant_unref0 (_tmp47_);
		_tmp49_ = audio_item;
		_tmp50_ = album;
		rygel_audio_item_set_album (_tmp49_, _tmp50_);
		_tmp51_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaFileItem* _tmp52_ = NULL;
			RygelMediaExportMusicItem* _tmp53_ = NULL;
			RygelMediaExportMusicItem* _tmp54_ = NULL;
			gint32 _tmp55_ = 0;
			RygelMediaExportMusicItem* _tmp56_ = NULL;
			gint32 _tmp57_ = 0;
			_tmp52_ = item;
			_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp52_) : NULL);
			music_item = _tmp53_;
			_tmp54_ = music_item;
			_tmp55_ = disc;
			_tmp54_->disc = (gint) _tmp55_;
			_tmp56_ = music_item;
			_tmp57_ = track_number;
			rygel_music_item_set_track_number ((RygelMusicItem*) _tmp56_, (gint) _tmp57_);
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	_g_free0 (_tmp26_);
	_g_free0 (album);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp8_);
	_g_variant_unref0 (val);
	_g_variant_iter_free0 (it);
}


void rygel_media_export_item_factory_apply_video_info (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	RygelMediaFileItem* _tmp1_ = NULL;
	RygelVisualItem* visual_item = NULL;
	RygelMediaFileItem* _tmp5_ = NULL;
	RygelVisualItem* _tmp6_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp7_ = NULL;
	GVariantIter* _tmp8_ = NULL;
	RygelVisualItem* _tmp9_ = NULL;
	GVariantIter* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	gint32 _tmp13_ = 0;
	RygelVisualItem* _tmp14_ = NULL;
	GVariantIter* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	gint32 _tmp18_ = 0;
	RygelVisualItem* _tmp19_ = NULL;
	GVariantIter* _tmp20_ = NULL;
	GVariant* _tmp21_ = NULL;
	GVariant* _tmp22_ = NULL;
	gint32 _tmp23_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(iii)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = item;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_VISUAL_ITEM)) {
		gchar* msg = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp2_ = g_strdup ("UPnP class does not match supplied meta data");
		msg = _tmp2_;
		_tmp3_ = msg;
		_tmp4_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR, RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_MISMATCH, _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return;
	}
	_tmp5_ = item;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp5_) : NULL);
	visual_item = _tmp6_;
	_tmp7_ = v;
	_tmp8_ = g_variant_iter_new (_tmp7_);
	it = _tmp8_;
	_tmp9_ = visual_item;
	_tmp10_ = it;
	_tmp11_ = g_variant_iter_next_value (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_get_int32 (_tmp12_);
	rygel_visual_item_set_width (_tmp9_, (gint) _tmp13_);
	_g_variant_unref0 (_tmp12_);
	_tmp14_ = visual_item;
	_tmp15_ = it;
	_tmp16_ = g_variant_iter_next_value (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_variant_get_int32 (_tmp17_);
	rygel_visual_item_set_height (_tmp14_, (gint) _tmp18_);
	_g_variant_unref0 (_tmp17_);
	_tmp19_ = visual_item;
	_tmp20_ = it;
	_tmp21_ = g_variant_iter_next_value (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_variant_get_int32 (_tmp22_);
	rygel_visual_item_set_color_depth (_tmp19_, (gint) _tmp23_);
	_g_variant_unref0 (_tmp22_);
	_g_variant_iter_free0 (it);
	_g_object_unref0 (visual_item);
}


void rygel_media_export_item_factory_apply_audio_info (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	RygelMediaFileItem* _tmp1_ = NULL;
	RygelAudioItem* audio_item = NULL;
	RygelMediaFileItem* _tmp5_ = NULL;
	RygelAudioItem* _tmp6_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp7_ = NULL;
	GVariantIter* _tmp8_ = NULL;
	RygelAudioItem* _tmp9_ = NULL;
	GVariantIter* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	gint32 _tmp13_ = 0;
	RygelAudioItem* _tmp14_ = NULL;
	GVariantIter* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	gint32 _tmp18_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(ii)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = item;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_AUDIO_ITEM)) {
		gchar* msg = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp2_ = g_strdup ("UPnP class does not match supplied meta data");
		msg = _tmp2_;
		_tmp3_ = msg;
		_tmp4_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR, RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_MISMATCH, _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return;
	}
	_tmp5_ = item;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp5_) : NULL);
	audio_item = _tmp6_;
	_tmp7_ = v;
	_tmp8_ = g_variant_iter_new (_tmp7_);
	it = _tmp8_;
	_tmp9_ = audio_item;
	_tmp10_ = it;
	_tmp11_ = g_variant_iter_next_value (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_get_int32 (_tmp12_);
	rygel_audio_item_set_channels (_tmp9_, (gint) _tmp13_);
	_g_variant_unref0 (_tmp12_);
	_tmp14_ = audio_item;
	_tmp15_ = it;
	_tmp16_ = g_variant_iter_next_value (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_variant_get_int32 (_tmp17_);
	rygel_audio_item_set_sample_freq (_tmp14_, (gint) _tmp18_);
	_g_variant_unref0 (_tmp17_);
	_g_variant_iter_free0 (it);
	_g_object_unref0 (audio_item);
}


void rygel_media_export_item_factory_apply_info (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantIter* _tmp2_ = NULL;
	GVariant* val = NULL;
	GVariantIter* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	GVariantIter* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	RygelMediaFileItem* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(msmsi)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	it = _tmp2_;
	_tmp3_ = it;
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_get_maybe (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp5_);
	val = _tmp7_;
	_tmp8_ = val;
	if (_tmp8_ != NULL) {
		RygelMediaFileItem* _tmp9_ = NULL;
		GVariant* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp9_ = item;
		_tmp10_ = val;
		_tmp11_ = g_variant_dup_string (_tmp10_, NULL);
		_tmp12_ = _tmp11_;
		rygel_media_object_set_title ((RygelMediaObject*) _tmp9_, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = it;
	_tmp14_ = g_variant_iter_next_value (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_variant_get_maybe (_tmp15_);
	_g_variant_unref0 (val);
	val = _tmp16_;
	_g_variant_unref0 (_tmp15_);
	_tmp17_ = val;
	if (_tmp17_ != NULL) {
		RygelMediaFileItem* _tmp18_ = NULL;
		GVariant* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp18_ = item;
		_tmp19_ = val;
		_tmp20_ = g_variant_dup_string (_tmp19_, NULL);
		_tmp21_ = _tmp20_;
		rygel_media_object_set_date ((RygelMediaObject*) _tmp18_, _tmp21_);
		_g_free0 (_tmp21_);
	}
	_tmp22_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelMediaFileItem* _tmp23_ = NULL;
		GVariantIter* _tmp24_ = NULL;
		GVariant* _tmp25_ = NULL;
		GVariant* _tmp26_ = NULL;
		gint32 _tmp27_ = 0;
		_tmp23_ = item;
		_tmp24_ = it;
		_tmp25_ = g_variant_iter_next_value (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_variant_get_int32 (_tmp26_);
		rygel_audio_item_set_duration (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp23_) : NULL, (glong) _tmp27_);
		_g_variant_unref0 (_tmp26_);
	}
	_g_variant_unref0 (val);
	_g_variant_iter_free0 (it);
}


void rygel_media_export_item_factory_apply_dlna_profile (RygelMediaFileItem* item, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantIter* _tmp2_ = NULL;
	RygelMediaFileItem* _tmp3_ = NULL;
	GVariantIter* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	RygelMediaFileItem* _tmp9_ = NULL;
	GVariantIter* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(ss)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	it = _tmp2_;
	_tmp3_ = item;
	_tmp4_ = it;
	_tmp5_ = g_variant_iter_next_value (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_dup_string (_tmp6_, NULL);
	_tmp8_ = _tmp7_;
	rygel_media_file_item_set_dlna_profile (_tmp3_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_variant_unref0 (_tmp6_);
	_tmp9_ = item;
	_tmp10_ = it;
	_tmp11_ = g_variant_iter_next_value (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_dup_string (_tmp12_, NULL);
	_tmp14_ = _tmp13_;
	rygel_media_file_item_set_mime_type (_tmp9_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_variant_unref0 (_tmp12_);
	_g_variant_iter_free0 (it);
}


void rygel_media_export_item_factory_apply_file_info (RygelMediaObject* object, GVariant* v, GError** error) {
	GVariant* _tmp0_ = NULL;
	GVariantIter* it = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantIter* _tmp2_ = NULL;
	GVariant* display_name = NULL;
	GVariantIter* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	RygelMediaObject* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	RygelMediaObject* _tmp16_ = NULL;
	GVariantIter* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	GVariant* _tmp19_ = NULL;
	guint64 _tmp20_ = 0ULL;
	RygelMediaObject* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (object != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	rygel_media_export_item_factory_check_variant_type (_tmp0_, "(stst)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	it = _tmp2_;
	_tmp3_ = it;
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
	display_name = _tmp4_;
	_tmp6_ = object;
	_tmp7_ = rygel_media_object_get_title (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		RygelMediaObject* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp9_ = object;
		_tmp10_ = rygel_media_object_get_title (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = g_strcmp0 (_tmp11_, "") == 0;
	}
	if (_tmp5_) {
		RygelMediaObject* _tmp12_ = NULL;
		GVariant* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp12_ = object;
		_tmp13_ = display_name;
		_tmp14_ = g_variant_dup_string (_tmp13_, NULL);
		_tmp15_ = _tmp14_;
		rygel_media_object_set_title (_tmp12_, _tmp15_);
		_g_free0 (_tmp15_);
	}
	_tmp16_ = object;
	_tmp17_ = it;
	_tmp18_ = g_variant_iter_next_value (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_variant_get_uint64 (_tmp19_);
	rygel_media_object_set_modified (_tmp16_, (guint64) ((gint64) _tmp20_));
	_g_variant_unref0 (_tmp19_);
	_tmp21_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		RygelMediaFileItem* item = NULL;
		RygelMediaObject* _tmp22_ = NULL;
		RygelMediaFileItem* _tmp23_ = NULL;
		GVariant* mime = NULL;
		GVariantIter* _tmp24_ = NULL;
		GVariant* _tmp25_ = NULL;
		RygelMediaFileItem* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		RygelMediaFileItem* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		RygelMediaFileItem* _tmp43_ = NULL;
		GVariantIter* _tmp44_ = NULL;
		GVariant* _tmp45_ = NULL;
		GVariant* _tmp46_ = NULL;
		guint64 _tmp47_ = 0ULL;
		_tmp22_ = object;
		_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp22_) : NULL);
		item = _tmp23_;
		_tmp24_ = it;
		_tmp25_ = g_variant_iter_next_value (_tmp24_);
		mime = _tmp25_;
		_tmp26_ = item;
		_tmp27_ = rygel_media_file_item_get_mime_type (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ == NULL) {
			RygelMediaFileItem* _tmp29_ = NULL;
			GVariant* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			_tmp29_ = item;
			_tmp30_ = mime;
			_tmp31_ = g_variant_dup_string (_tmp30_, NULL);
			_tmp32_ = _tmp31_;
			rygel_media_file_item_set_mime_type (_tmp29_, _tmp32_);
			_g_free0 (_tmp32_);
		}
		_tmp33_ = item;
		_tmp34_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_ == NULL) {
			GTimeVal tv = {0};
			RygelMediaFileItem* _tmp36_ = NULL;
			guint64 _tmp37_ = 0ULL;
			guint64 _tmp38_ = 0ULL;
			GTimeVal _tmp39_ = {0};
			RygelMediaFileItem* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			_tmp36_ = item;
			_tmp37_ = rygel_media_object_get_modified ((RygelMediaObject*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_.tv_sec = (glong) _tmp38_;
			_tmp39_.tv_usec = (glong) 0;
			tv = _tmp39_;
			_tmp40_ = item;
			_tmp41_ = g_time_val_to_iso8601 (&tv);
			_tmp42_ = _tmp41_;
			rygel_media_object_set_date ((RygelMediaObject*) _tmp40_, _tmp42_);
			_g_free0 (_tmp42_);
		}
		_tmp43_ = item;
		_tmp44_ = it;
		_tmp45_ = g_variant_iter_next_value (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = g_variant_get_uint64 (_tmp46_);
		rygel_media_file_item_set_size (_tmp43_, (gint64) _tmp47_);
		_g_variant_unref0 (_tmp46_);
		_g_variant_unref0 (mime);
		_g_object_unref0 (item);
	}
	_g_variant_unref0 (display_name);
	_g_variant_iter_free0 (it);
}



