/* rygel-cmdline-config.c generated by valac 0.30.0, the Vala compiler
 * generated from rygel-cmdline-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2014 Jens Georg <mail@jensge.org>
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *                    <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gee.h>


#define RYGEL_TYPE_CMDLINE_CONFIG (rygel_cmdline_config_get_type ())
#define RYGEL_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfig))
#define RYGEL_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))
#define RYGEL_IS_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_IS_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_CMDLINE_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))

typedef struct _RygelCmdlineConfig RygelCmdlineConfig;
typedef struct _RygelCmdlineConfigClass RygelCmdlineConfigClass;
typedef struct _RygelCmdlineConfigPrivate RygelCmdlineConfigPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

typedef enum  {
	RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY
} RygelCmdlineConfigError;
#define RYGEL_CMDLINE_CONFIG_ERROR rygel_cmdline_config_error_quark ()
struct _RygelCmdlineConfig {
	GObject parent_instance;
	RygelCmdlineConfigPrivate * priv;
};

struct _RygelCmdlineConfigClass {
	GObjectClass parent_class;
};


static gpointer rygel_cmdline_config_parent_class = NULL;
static gchar** rygel_cmdline_config_ifaces;
static gchar** rygel_cmdline_config_ifaces = NULL;
static gint rygel_cmdline_config_port;
static gint rygel_cmdline_config_port = 0;
static gboolean rygel_cmdline_config_no_transcoding;
static gboolean rygel_cmdline_config_no_transcoding = FALSE;
static gboolean rygel_cmdline_config_disallow_upload;
static gboolean rygel_cmdline_config_disallow_upload = FALSE;
static gboolean rygel_cmdline_config_disallow_deletion;
static gboolean rygel_cmdline_config_disallow_deletion = FALSE;
static gchar* rygel_cmdline_config_log_levels;
static gchar* rygel_cmdline_config_log_levels = NULL;
static gchar* rygel_cmdline_config_plugin_path;
static gchar* rygel_cmdline_config_plugin_path = NULL;
static gchar* rygel_cmdline_config_engine_path;
static gchar* rygel_cmdline_config_engine_path = NULL;
static gboolean rygel_cmdline_config_version;
static gboolean rygel_cmdline_config_version = FALSE;
static gchar* rygel_cmdline_config_config_file;
static gchar* rygel_cmdline_config_config_file = NULL;
static gboolean rygel_cmdline_config_shutdown;
static gboolean rygel_cmdline_config_shutdown = FALSE;
static gboolean rygel_cmdline_config_replace;
static gboolean rygel_cmdline_config_replace = FALSE;
static gchar** rygel_cmdline_config_disabled_plugins;
static gchar** rygel_cmdline_config_disabled_plugins = NULL;
static gchar** rygel_cmdline_config_plugin_titles;
static gchar** rygel_cmdline_config_plugin_titles = NULL;
static gchar** rygel_cmdline_config_plugin_options;
static gchar** rygel_cmdline_config_plugin_options = NULL;
static RygelCmdlineConfig* rygel_cmdline_config_config;
static RygelCmdlineConfig* rygel_cmdline_config_config = NULL;
static RygelConfigurationIface* rygel_cmdline_config_rygel_configuration_parent_iface = NULL;

GQuark rygel_cmdline_config_error_quark (void);
GType rygel_cmdline_config_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_CMDLINE_CONFIG_DUMMY_PROPERTY
};
RygelCmdlineConfig* rygel_cmdline_config_get_default (void);
RygelCmdlineConfig* rygel_cmdline_config_new (void);
RygelCmdlineConfig* rygel_cmdline_config_construct (GType object_type);
void rygel_cmdline_config_parse_args (gchar*** args, int* args_length1, GError** error);
static gchar* rygel_cmdline_config_real_get_interface (RygelConfiguration* base, GError** error);
static gchar** rygel_cmdline_config_real_get_interfaces (RygelConfiguration* base, GError** error);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gint rygel_cmdline_config_real_get_port (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_transcoding (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_allow_upload (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_allow_deletion (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_log_levels (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_plugin_path (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_engine_path (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_media_engine (RygelConfiguration* base, GError** error);
static gboolean rygel_cmdline_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error);
static gchar* rygel_cmdline_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error);
gchar* rygel_cmdline_config_get_config_file (RygelCmdlineConfig* self, GError** error);
static gchar* rygel_cmdline_config_real_get_video_upload_folder (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_music_upload_folder (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_picture_upload_folder (RygelConfiguration* base, GError** error);
static gchar* rygel_cmdline_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static GeeArrayList* rygel_cmdline_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gint rygel_cmdline_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static GeeArrayList* rygel_cmdline_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gboolean rygel_cmdline_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static void rygel_cmdline_config_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry RYGEL_CMDLINE_CONFIG_OPTIONS[16] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_version, "Display version number", NULL}, {"network-interface", 'n', 0, G_OPTION_ARG_STRING_ARRAY, &rygel_cmdline_config_ifaces, "Network Interfaces", "INTERFACE"}, {"port", 'p', 0, G_OPTION_ARG_INT, &rygel_cmdline_config_port, "Port", "PORT"}, {"disable-transcoding", 't', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_no_transcoding, "Disable transcoding", NULL}, {"disallow-upload", 'U', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_disallow_upload, "Disallow upload", NULL}, {"disallow-deletion", 'D', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_disallow_deletion, "Disallow deletion", NULL}, {"log-level", 'g', 0, G_OPTION_ARG_STRING, &rygel_cmdline_config_log_levels, "Comma-separated list of domain:level pairs. See rygel(1) for details"}, {"plugin-path", 'u', 0, G_OPTION_ARG_STRING, &rygel_cmdline_config_plugin_path, "Plugin Path", "PLUGIN_PATH"}, {"engine-path", 'e', 0, G_OPTION_ARG_STRING, &rygel_cmdline_config_engine_path, "Engine Path", "ENGINE_PATH"}, {"disable-plugin", 'd', 0, G_OPTION_ARG_STRING_ARRAY, &rygel_cmdline_config_disabled_plugins, "Disable plugin", "PluginName"}, {"title", 'i', 0, G_OPTION_ARG_STRING_ARRAY, &rygel_cmdline_config_plugin_titles, "Set plugin titles", "PluginName:TITLE"}, {"plugin-option", 'o', 0, G_OPTION_ARG_STRING_ARRAY, &rygel_cmdline_config_plugin_options, "Set plugin options", "PluginName:OPTION:VALUE1[,VALUE2,..]"}, {"config", 'c', 0, G_OPTION_ARG_FILENAME, &rygel_cmdline_config_config_file, "Use configuration file instead of user configuration", "FILE"}, {"shutdown", 's', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_shutdown, "Shut down remote Rygel reference", NULL}, {"replace", 'r', 0, G_OPTION_ARG_NONE, &rygel_cmdline_config_replace, "Replace currently running instance of Rygel", NULL}, {NULL}};

GQuark rygel_cmdline_config_error_quark (void) {
	return g_quark_from_static_string ("rygel_cmdline_config_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelCmdlineConfig* rygel_cmdline_config_get_default (void) {
	RygelCmdlineConfig* result = NULL;
	RygelCmdlineConfig* _tmp0_ = NULL;
	RygelCmdlineConfig* _tmp2_ = NULL;
	RygelCmdlineConfig* _tmp3_ = NULL;
	_tmp0_ = rygel_cmdline_config_config;
	if (_tmp0_ == NULL) {
		RygelCmdlineConfig* _tmp1_ = NULL;
		_tmp1_ = rygel_cmdline_config_new ();
		_g_object_unref0 (rygel_cmdline_config_config);
		rygel_cmdline_config_config = _tmp1_;
	}
	_tmp2_ = rygel_cmdline_config_config;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


void rygel_cmdline_config_parse_args (gchar*** args, int* args_length1, GError** error) {
	gchar* parameter_string = NULL;
	gchar* _tmp0_ = NULL;
	GOptionContext* opt_context = NULL;
	const gchar* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionContext* _tmp4_ = NULL;
	GOptionContext* _tmp5_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_strdup ("- " PACKAGE_NAME);
	parameter_string = _tmp0_;
	_tmp1_ = parameter_string;
	_tmp2_ = g_option_context_new (_tmp1_);
	opt_context = _tmp2_;
	_tmp3_ = opt_context;
	g_option_context_set_help_enabled (_tmp3_, TRUE);
	_tmp4_ = opt_context;
	g_option_context_set_ignore_unknown_options (_tmp4_, TRUE);
	_tmp5_ = opt_context;
	g_option_context_add_main_entries (_tmp5_, RYGEL_CMDLINE_CONFIG_OPTIONS, NULL);
	{
		GOptionContext* _tmp6_ = NULL;
		_tmp6_ = opt_context;
		g_option_context_parse (_tmp6_, args_length1, args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE)) {
				goto __catch13_g_option_error_bad_value;
			}
			goto __finally13;
		}
	}
	goto __finally13;
	__catch13_g_option_error_bad_value:
	{
		GError* err = NULL;
		FILE* _tmp7_ = NULL;
		GOptionContext* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = stdout;
		_tmp8_ = opt_context;
		_tmp9_ = g_option_context_get_help (_tmp8_, TRUE, NULL);
		_tmp10_ = _tmp9_;
		fprintf (_tmp7_, "%s", _tmp10_);
		_g_free0 (_tmp10_);
		_tmp11_ = g_error_new_literal (RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY, "");
		_inner_error_ = _tmp11_;
		_g_error_free0 (err);
		goto __finally13;
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == RYGEL_CMDLINE_CONFIG_ERROR) || (_inner_error_->domain == G_OPTION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_option_context_free0 (opt_context);
			_g_free0 (parameter_string);
			return;
		} else {
			_g_option_context_free0 (opt_context);
			_g_free0 (parameter_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp12_ = rygel_cmdline_config_version;
	if (_tmp12_) {
		FILE* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		_tmp13_ = stdout;
		fprintf (_tmp13_, "%s\n", PACKAGE_STRING);
		_tmp14_ = g_error_new_literal (RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY, "");
		_inner_error_ = _tmp14_;
		if ((_inner_error_->domain == RYGEL_CMDLINE_CONFIG_ERROR) || (_inner_error_->domain == G_OPTION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_option_context_free0 (opt_context);
			_g_free0 (parameter_string);
			return;
		} else {
			_g_option_context_free0 (opt_context);
			_g_free0 (parameter_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp16_ = rygel_cmdline_config_shutdown;
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		gboolean _tmp17_ = FALSE;
		_tmp17_ = rygel_cmdline_config_replace;
		_tmp15_ = _tmp17_;
	}
	if (_tmp15_) {
		gboolean _tmp24_ = FALSE;
		{
			const gchar* _tmp18_ = NULL;
			RygelDBusInterface* rygel = NULL;
			RygelDBusInterface* _tmp19_ = NULL;
			RygelDBusInterface* _tmp20_ = NULL;
			_tmp18_ = _ ("Shutting down remote Rygel instance\n");
			g_print ("%s", _tmp18_);
			_tmp19_ = g_initable_new (RYGEL_TYPE_DBUS_INTERFACE_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", RYGEL_DBUS_INTERFACE_SERVICE_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_DBUS_INTERFACE_OBJECT_PATH, "g-interface-name", "org.gnome.Rygel1", "g-interface-info", g_type_get_qdata (RYGEL_TYPE_DBUS_INTERFACE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
			rygel = (RygelDBusInterface*) _tmp19_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch14_g_error;
			}
			_tmp20_ = rygel;
			rygel_dbus_interface_shutdown (_tmp20_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (rygel);
				goto __catch14_g_error;
			}
			_g_object_unref0 (rygel);
		}
		goto __finally14;
		__catch14_g_error:
		{
			GError* _error_ = NULL;
			const gchar* _tmp21_ = NULL;
			GError* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp21_ = _ ("Failed to shut down other Rygel instance: %s");
			_tmp22_ = _error_;
			_tmp23_ = _tmp22_->message;
			g_warning (_tmp21_, _tmp23_);
			_g_error_free0 (_error_);
		}
		__finally14:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if ((_inner_error_->domain == RYGEL_CMDLINE_CONFIG_ERROR) || (_inner_error_->domain == G_OPTION_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_option_context_free0 (opt_context);
				_g_free0 (parameter_string);
				return;
			} else {
				_g_option_context_free0 (opt_context);
				_g_free0 (parameter_string);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp24_ = rygel_cmdline_config_shutdown;
		if (_tmp24_) {
			GError* _tmp25_ = NULL;
			_tmp25_ = g_error_new_literal (RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY, "");
			_inner_error_ = _tmp25_;
			if ((_inner_error_->domain == RYGEL_CMDLINE_CONFIG_ERROR) || (_inner_error_->domain == G_OPTION_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_option_context_free0 (opt_context);
				_g_free0 (parameter_string);
				return;
			} else {
				_g_option_context_free0 (opt_context);
				_g_free0 (parameter_string);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_option_context_free0 (opt_context);
	_g_free0 (parameter_string);
}


static gchar* rygel_cmdline_config_real_get_interface (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = rygel_cmdline_config_ifaces;
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_ifaces);
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = _ ("No value available");
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = rygel_cmdline_config_ifaces;
	_tmp3__length1 = _vala_array_length (rygel_cmdline_config_ifaces);
	_tmp4_ = _tmp3_[0];
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_cmdline_config_real_get_interfaces (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = rygel_cmdline_config_ifaces;
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_ifaces);
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = _ ("No value available");
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = rygel_cmdline_config_ifaces;
	_tmp3__length1 = _vala_array_length (rygel_cmdline_config_ifaces);
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	result = _tmp4_;
	return result;
}


static gint rygel_cmdline_config_real_get_port (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = rygel_cmdline_config_port;
	if (_tmp0_ <= 0) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = _ ("No value available");
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	_tmp3_ = rygel_cmdline_config_port;
	result = _tmp3_;
	return result;
}


static gboolean rygel_cmdline_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = rygel_cmdline_config_no_transcoding;
	if (!_tmp0_) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = _ ("No value available");
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean rygel_cmdline_config_real_get_allow_upload (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = rygel_cmdline_config_disallow_upload;
	if (!_tmp0_) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = _ ("No value available");
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean rygel_cmdline_config_real_get_allow_deletion (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = rygel_cmdline_config_disallow_deletion;
	if (!_tmp0_) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = _ ("No value available");
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	} else {
		result = FALSE;
		return result;
	}
}


static gchar* rygel_cmdline_config_real_get_log_levels (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = rygel_cmdline_config_log_levels;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = _ ("No value available");
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = rygel_cmdline_config_log_levels;
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	return result;
}


static gchar* rygel_cmdline_config_real_get_plugin_path (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = rygel_cmdline_config_plugin_path;
	if (_tmp0_ == NULL) {
		GError* _tmp1_ = NULL;
		_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp2_ = rygel_cmdline_config_plugin_path;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* rygel_cmdline_config_real_get_engine_path (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = rygel_cmdline_config_engine_path;
	if (_tmp0_ == NULL) {
		GError* _tmp1_ = NULL;
		_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp2_ = rygel_cmdline_config_plugin_path;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* rygel_cmdline_config_real_get_media_engine (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	GError* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
	_inner_error_ = _tmp0_;
	g_propagate_error (error, _inner_error_);
	return NULL;
	return result;
}


static gboolean rygel_cmdline_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean disabled = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	disabled = FALSE;
	_tmp0_ = rygel_cmdline_config_disabled_plugins;
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_disabled_plugins);
	{
		gchar** plugin_collection = NULL;
		gint plugin_collection_length1 = 0;
		gint _plugin_collection_size_ = 0;
		gint plugin_it = 0;
		plugin_collection = _tmp0_;
		plugin_collection_length1 = _tmp0__length1;
		for (plugin_it = 0; plugin_it < _tmp0__length1; plugin_it = plugin_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* plugin = NULL;
			_tmp1_ = g_strdup (plugin_collection[plugin_it]);
			plugin = _tmp1_;
			{
				const gchar* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				_tmp2_ = plugin;
				_tmp3_ = section;
				if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
					disabled = TRUE;
					_g_free0 (plugin);
					break;
				}
				_g_free0 (plugin);
			}
		}
	}
	_tmp4_ = disabled;
	if (_tmp4_) {
		result = FALSE;
		return result;
	} else {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("No value available");
		_tmp6_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
}


static gchar* rygel_cmdline_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	gchar* title = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	title = NULL;
	_tmp0_ = rygel_cmdline_config_plugin_titles;
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_plugin_titles);
	{
		gchar** plugin_title_collection = NULL;
		gint plugin_title_collection_length1 = 0;
		gint _plugin_title_collection_size_ = 0;
		gint plugin_title_it = 0;
		plugin_title_collection = _tmp0_;
		plugin_title_collection_length1 = _tmp0__length1;
		for (plugin_title_it = 0; plugin_title_it < _tmp0__length1; plugin_title_it = plugin_title_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* plugin_title = NULL;
			_tmp1_ = g_strdup (plugin_title_collection[plugin_title_it]);
			plugin_title = _tmp1_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gchar** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				const gchar* _tmp8_ = NULL;
				_tmp2_ = plugin_title;
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 2);
				tokens = _tmp4_;
				tokens_length1 = _vala_array_length (_tmp3_);
				_tokens_size_ = tokens_length1;
				_tmp7_ = tokens;
				_tmp7__length1 = tokens_length1;
				_tmp8_ = _tmp7_[0];
				if (_tmp8_ != NULL) {
					gchar** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					const gchar* _tmp10_ = NULL;
					_tmp9_ = tokens;
					_tmp9__length1 = tokens_length1;
					_tmp10_ = _tmp9_[1];
					_tmp6_ = _tmp10_ != NULL;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					const gchar* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					_tmp11_ = tokens;
					_tmp11__length1 = tokens_length1;
					_tmp12_ = _tmp11_[0];
					_tmp13_ = section;
					_tmp5_ = g_strcmp0 (_tmp12_, _tmp13_) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					gchar** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					const gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					_tmp14_ = tokens;
					_tmp14__length1 = tokens_length1;
					_tmp15_ = _tmp14_[1];
					_tmp16_ = g_strdup (_tmp15_);
					_g_free0 (title);
					title = _tmp16_;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (plugin_title);
					break;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (plugin_title);
			}
		}
	}
	_tmp17_ = title;
	if (_tmp17_ != NULL) {
		result = title;
		return result;
	} else {
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_ = NULL;
		_tmp18_ = _ ("No value available");
		_tmp19_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp18_);
		_inner_error_ = _tmp19_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (title);
		return NULL;
	}
	_g_free0 (title);
}


gchar* rygel_cmdline_config_get_config_file (RygelCmdlineConfig* self, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_cmdline_config_config_file;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = _ ("No value available");
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = rygel_cmdline_config_config_file;
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	return result;
}


static gchar* rygel_cmdline_config_real_get_video_upload_folder (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GError* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = _ ("No value available");
	_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
	_inner_error_ = _tmp1_;
	g_propagate_error (error, _inner_error_);
	return NULL;
	return result;
}


static gchar* rygel_cmdline_config_real_get_music_upload_folder (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GError* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = _ ("No value available");
	_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
	_inner_error_ = _tmp1_;
	g_propagate_error (error, _inner_error_);
	return NULL;
	return result;
}


static gchar* rygel_cmdline_config_real_get_picture_upload_folder (RygelConfiguration* base, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GError* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = _ ("No value available");
	_tmp1_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp0_);
	_inner_error_ = _tmp1_;
	g_propagate_error (error, _inner_error_);
	return NULL;
	return result;
}


static gchar* rygel_cmdline_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelCmdlineConfig * self;
	gchar* result = NULL;
	gchar* value = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	value = NULL;
	_tmp0_ = rygel_cmdline_config_plugin_options;
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp0_;
		option_collection_length1 = _tmp0__length1;
		for (option_it = 0; option_it < _tmp0__length1; option_it = option_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* option = NULL;
			_tmp1_ = g_strdup (option_collection[option_it]);
			option = _tmp1_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				const gchar* _tmp10_ = NULL;
				_tmp2_ = option;
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 3);
				tokens = _tmp4_;
				tokens_length1 = _vala_array_length (_tmp3_);
				_tokens_size_ = tokens_length1;
				_tmp9_ = tokens;
				_tmp9__length1 = tokens_length1;
				_tmp10_ = _tmp9_[0];
				if (_tmp10_ != NULL) {
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					const gchar* _tmp12_ = NULL;
					_tmp11_ = tokens;
					_tmp11__length1 = tokens_length1;
					_tmp12_ = _tmp11_[1];
					_tmp8_ = _tmp12_ != NULL;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					gchar** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					const gchar* _tmp14_ = NULL;
					_tmp13_ = tokens;
					_tmp13__length1 = tokens_length1;
					_tmp14_ = _tmp13_[2];
					_tmp7_ = _tmp14_ != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					_tmp15_ = tokens;
					_tmp15__length1 = tokens_length1;
					_tmp16_ = _tmp15_[0];
					_tmp17_ = section;
					_tmp6_ = g_strcmp0 (_tmp16_, _tmp17_) == 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					gchar** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					_tmp18_ = tokens;
					_tmp18__length1 = tokens_length1;
					_tmp19_ = _tmp18_[1];
					_tmp20_ = key;
					_tmp5_ = g_strcmp0 (_tmp19_, _tmp20_) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					_tmp21_ = tokens;
					_tmp21__length1 = tokens_length1;
					_tmp22_ = _tmp21_[2];
					_tmp23_ = g_strdup (_tmp22_);
					_g_free0 (value);
					value = _tmp23_;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
					break;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
	_tmp24_ = value;
	if (_tmp24_ != NULL) {
		result = value;
		return result;
	} else {
		const gchar* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		_tmp25_ = _ ("No value available");
		_tmp26_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp25_);
		_inner_error_ = _tmp26_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (value);
		return NULL;
	}
	_g_free0 (value);
}


static GeeArrayList* rygel_cmdline_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelCmdlineConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* value = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GeeArrayList* _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	value = NULL;
	_tmp0_ = rygel_cmdline_config_plugin_options;
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp0_;
		option_collection_length1 = _tmp0__length1;
		for (option_it = 0; option_it < _tmp0__length1; option_it = option_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* option = NULL;
			_tmp1_ = g_strdup (option_collection[option_it]);
			option = _tmp1_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				const gchar* _tmp10_ = NULL;
				_tmp2_ = option;
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 3);
				tokens = _tmp4_;
				tokens_length1 = _vala_array_length (_tmp3_);
				_tokens_size_ = tokens_length1;
				_tmp9_ = tokens;
				_tmp9__length1 = tokens_length1;
				_tmp10_ = _tmp9_[0];
				if (_tmp10_ != NULL) {
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					const gchar* _tmp12_ = NULL;
					_tmp11_ = tokens;
					_tmp11__length1 = tokens_length1;
					_tmp12_ = _tmp11_[1];
					_tmp8_ = _tmp12_ != NULL;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					gchar** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					const gchar* _tmp14_ = NULL;
					_tmp13_ = tokens;
					_tmp13__length1 = tokens_length1;
					_tmp14_ = _tmp13_[2];
					_tmp7_ = _tmp14_ != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					_tmp15_ = tokens;
					_tmp15__length1 = tokens_length1;
					_tmp16_ = _tmp15_[0];
					_tmp17_ = section;
					_tmp6_ = g_strcmp0 (_tmp16_, _tmp17_) == 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					gchar** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					_tmp18_ = tokens;
					_tmp18__length1 = tokens_length1;
					_tmp19_ = _tmp18_[1];
					_tmp20_ = key;
					_tmp5_ = g_strcmp0 (_tmp19_, _tmp20_) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					GeeArrayList* _tmp21_ = NULL;
					gchar** _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					const gchar* _tmp23_ = NULL;
					gchar** _tmp24_ = NULL;
					gchar** _tmp25_ = NULL;
					_tmp21_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
					_g_object_unref0 (value);
					value = _tmp21_;
					_tmp22_ = tokens;
					_tmp22__length1 = tokens_length1;
					_tmp23_ = _tmp22_[2];
					_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, ",", -1);
					{
						gchar** val_token_collection = NULL;
						gint val_token_collection_length1 = 0;
						gint _val_token_collection_size_ = 0;
						gint val_token_it = 0;
						val_token_collection = _tmp25_;
						val_token_collection_length1 = _vala_array_length (_tmp24_);
						for (val_token_it = 0; val_token_it < _vala_array_length (_tmp24_); val_token_it = val_token_it + 1) {
							gchar* _tmp26_ = NULL;
							gchar* val_token = NULL;
							_tmp26_ = g_strdup (val_token_collection[val_token_it]);
							val_token = _tmp26_;
							{
								GeeArrayList* _tmp27_ = NULL;
								const gchar* _tmp28_ = NULL;
								_tmp27_ = value;
								_tmp28_ = val_token;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
								_g_free0 (val_token);
							}
						}
						val_token_collection = (_vala_array_free (val_token_collection, val_token_collection_length1, (GDestroyNotify) g_free), NULL);
					}
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
					break;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
	_tmp29_ = value;
	if (_tmp29_ != NULL) {
		result = value;
		return result;
	} else {
		const gchar* _tmp30_ = NULL;
		GError* _tmp31_ = NULL;
		_tmp30_ = _ ("No value available");
		_tmp31_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp30_);
		_inner_error_ = _tmp31_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (value);
		return NULL;
	}
	_g_object_unref0 (value);
}


static gint rygel_cmdline_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error) {
	RygelCmdlineConfig * self;
	gint result = 0;
	gint value = 0;
	gboolean value_set = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean _tmp29_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	value = 0;
	value_set = FALSE;
	_tmp0_ = rygel_cmdline_config_plugin_options;
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp0_;
		option_collection_length1 = _tmp0__length1;
		for (option_it = 0; option_it < _tmp0__length1; option_it = option_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* option = NULL;
			_tmp1_ = g_strdup (option_collection[option_it]);
			option = _tmp1_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				const gchar* _tmp10_ = NULL;
				_tmp2_ = option;
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 3);
				tokens = _tmp4_;
				tokens_length1 = _vala_array_length (_tmp3_);
				_tokens_size_ = tokens_length1;
				_tmp9_ = tokens;
				_tmp9__length1 = tokens_length1;
				_tmp10_ = _tmp9_[0];
				if (_tmp10_ != NULL) {
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					const gchar* _tmp12_ = NULL;
					_tmp11_ = tokens;
					_tmp11__length1 = tokens_length1;
					_tmp12_ = _tmp11_[1];
					_tmp8_ = _tmp12_ != NULL;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					gchar** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					const gchar* _tmp14_ = NULL;
					_tmp13_ = tokens;
					_tmp13__length1 = tokens_length1;
					_tmp14_ = _tmp13_[2];
					_tmp7_ = _tmp14_ != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					_tmp15_ = tokens;
					_tmp15__length1 = tokens_length1;
					_tmp16_ = _tmp15_[0];
					_tmp17_ = section;
					_tmp6_ = g_strcmp0 (_tmp16_, _tmp17_) == 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					gchar** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					_tmp18_ = tokens;
					_tmp18__length1 = tokens_length1;
					_tmp19_ = _tmp18_[1];
					_tmp20_ = key;
					_tmp5_ = g_strcmp0 (_tmp19_, _tmp20_) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					const gchar* _tmp22_ = NULL;
					gint _tmp23_ = 0;
					gboolean _tmp24_ = FALSE;
					gint _tmp25_ = 0;
					gint _tmp26_ = 0;
					_tmp21_ = tokens;
					_tmp21__length1 = tokens_length1;
					_tmp22_ = _tmp21_[2];
					_tmp23_ = atoi (_tmp22_);
					value = _tmp23_;
					_tmp25_ = value;
					_tmp26_ = min;
					if (_tmp25_ >= _tmp26_) {
						gint _tmp27_ = 0;
						gint _tmp28_ = 0;
						_tmp27_ = value;
						_tmp28_ = max;
						_tmp24_ = _tmp27_ <= _tmp28_;
					} else {
						_tmp24_ = FALSE;
					}
					if (_tmp24_) {
						value_set = TRUE;
					}
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
					break;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
	_tmp29_ = value_set;
	if (_tmp29_) {
		result = value;
		return result;
	} else {
		const gchar* _tmp30_ = NULL;
		GError* _tmp31_ = NULL;
		_tmp30_ = _ ("No value available");
		_tmp31_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp30_);
		_inner_error_ = _tmp31_;
		g_propagate_error (error, _inner_error_);
		return 0;
	}
}


static GeeArrayList* rygel_cmdline_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelCmdlineConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* value = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GeeArrayList* _tmp30_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	value = NULL;
	_tmp0_ = rygel_cmdline_config_plugin_options;
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp0_;
		option_collection_length1 = _tmp0__length1;
		for (option_it = 0; option_it < _tmp0__length1; option_it = option_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* option = NULL;
			_tmp1_ = g_strdup (option_collection[option_it]);
			option = _tmp1_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				const gchar* _tmp10_ = NULL;
				_tmp2_ = option;
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 3);
				tokens = _tmp4_;
				tokens_length1 = _vala_array_length (_tmp3_);
				_tokens_size_ = tokens_length1;
				_tmp9_ = tokens;
				_tmp9__length1 = tokens_length1;
				_tmp10_ = _tmp9_[0];
				if (_tmp10_ != NULL) {
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					const gchar* _tmp12_ = NULL;
					_tmp11_ = tokens;
					_tmp11__length1 = tokens_length1;
					_tmp12_ = _tmp11_[1];
					_tmp8_ = _tmp12_ != NULL;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					gchar** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					const gchar* _tmp14_ = NULL;
					_tmp13_ = tokens;
					_tmp13__length1 = tokens_length1;
					_tmp14_ = _tmp13_[2];
					_tmp7_ = _tmp14_ != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					_tmp15_ = tokens;
					_tmp15__length1 = tokens_length1;
					_tmp16_ = _tmp15_[0];
					_tmp17_ = section;
					_tmp6_ = g_strcmp0 (_tmp16_, _tmp17_) == 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					gchar** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					_tmp18_ = tokens;
					_tmp18__length1 = tokens_length1;
					_tmp19_ = _tmp18_[1];
					_tmp20_ = key;
					_tmp5_ = g_strcmp0 (_tmp19_, _tmp20_) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					GeeArrayList* _tmp21_ = NULL;
					gchar** _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					const gchar* _tmp23_ = NULL;
					gchar** _tmp24_ = NULL;
					gchar** _tmp25_ = NULL;
					_tmp21_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
					_g_object_unref0 (value);
					value = _tmp21_;
					_tmp22_ = tokens;
					_tmp22__length1 = tokens_length1;
					_tmp23_ = _tmp22_[2];
					_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, ",", -1);
					{
						gchar** val_token_collection = NULL;
						gint val_token_collection_length1 = 0;
						gint _val_token_collection_size_ = 0;
						gint val_token_it = 0;
						val_token_collection = _tmp25_;
						val_token_collection_length1 = _vala_array_length (_tmp24_);
						for (val_token_it = 0; val_token_it < _vala_array_length (_tmp24_); val_token_it = val_token_it + 1) {
							gchar* _tmp26_ = NULL;
							gchar* val_token = NULL;
							_tmp26_ = g_strdup (val_token_collection[val_token_it]);
							val_token = _tmp26_;
							{
								GeeArrayList* _tmp27_ = NULL;
								const gchar* _tmp28_ = NULL;
								gint _tmp29_ = 0;
								_tmp27_ = value;
								_tmp28_ = val_token;
								_tmp29_ = atoi (_tmp28_);
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, (gpointer) ((gintptr) _tmp29_));
								_g_free0 (val_token);
							}
						}
						val_token_collection = (_vala_array_free (val_token_collection, val_token_collection_length1, (GDestroyNotify) g_free), NULL);
					}
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
					break;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
	_tmp30_ = value;
	if (_tmp30_ != NULL) {
		result = value;
		return result;
	} else {
		const gchar* _tmp31_ = NULL;
		GError* _tmp32_ = NULL;
		_tmp31_ = _ ("No value available");
		_tmp32_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp31_);
		_inner_error_ = _tmp32_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (value);
		return NULL;
	}
	_g_object_unref0 (value);
}


static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean rygel_cmdline_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelCmdlineConfig * self;
	gboolean result = FALSE;
	gboolean value = FALSE;
	gboolean value_set = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean _tmp24_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	value = FALSE;
	value_set = FALSE;
	_tmp0_ = rygel_cmdline_config_plugin_options;
	_tmp0__length1 = _vala_array_length (rygel_cmdline_config_plugin_options);
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp0_;
		option_collection_length1 = _tmp0__length1;
		for (option_it = 0; option_it < _tmp0__length1; option_it = option_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* option = NULL;
			_tmp1_ = g_strdup (option_collection[option_it]);
			option = _tmp1_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp2_ = NULL;
				gchar** _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				const gchar* _tmp10_ = NULL;
				_tmp2_ = option;
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 3);
				tokens = _tmp4_;
				tokens_length1 = _vala_array_length (_tmp3_);
				_tokens_size_ = tokens_length1;
				_tmp9_ = tokens;
				_tmp9__length1 = tokens_length1;
				_tmp10_ = _tmp9_[0];
				if (_tmp10_ != NULL) {
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					const gchar* _tmp12_ = NULL;
					_tmp11_ = tokens;
					_tmp11__length1 = tokens_length1;
					_tmp12_ = _tmp11_[1];
					_tmp8_ = _tmp12_ != NULL;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					gchar** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					const gchar* _tmp14_ = NULL;
					_tmp13_ = tokens;
					_tmp13__length1 = tokens_length1;
					_tmp14_ = _tmp13_[2];
					_tmp7_ = _tmp14_ != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					_tmp15_ = tokens;
					_tmp15__length1 = tokens_length1;
					_tmp16_ = _tmp15_[0];
					_tmp17_ = section;
					_tmp6_ = g_strcmp0 (_tmp16_, _tmp17_) == 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					gchar** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					_tmp18_ = tokens;
					_tmp18__length1 = tokens_length1;
					_tmp19_ = _tmp18_[1];
					_tmp20_ = key;
					_tmp5_ = g_strcmp0 (_tmp19_, _tmp20_) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					const gchar* _tmp22_ = NULL;
					gboolean _tmp23_ = FALSE;
					_tmp21_ = tokens;
					_tmp21__length1 = tokens_length1;
					_tmp22_ = _tmp21_[2];
					_tmp23_ = bool_parse (_tmp22_);
					value = _tmp23_;
					value_set = TRUE;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
					break;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
	_tmp24_ = value_set;
	if (_tmp24_) {
		result = value;
		return result;
	} else {
		const gchar* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		_tmp25_ = _ ("No value available");
		_tmp26_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp25_);
		_inner_error_ = _tmp26_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
}


RygelCmdlineConfig* rygel_cmdline_config_construct (GType object_type) {
	RygelCmdlineConfig * self = NULL;
	self = (RygelCmdlineConfig*) g_object_new (object_type, NULL);
	return self;
}


RygelCmdlineConfig* rygel_cmdline_config_new (void) {
	return rygel_cmdline_config_construct (RYGEL_TYPE_CMDLINE_CONFIG);
}


static void rygel_cmdline_config_class_init (RygelCmdlineConfigClass * klass) {
	rygel_cmdline_config_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_cmdline_config_finalize;
}


static void rygel_cmdline_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
	rygel_cmdline_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_interface = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_interface;
	iface->get_interfaces = (gchar** (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_interfaces;
	iface->get_port = (gint (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_port;
	iface->get_transcoding = (gboolean (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_transcoding;
	iface->get_allow_upload = (gboolean (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_allow_upload;
	iface->get_allow_deletion = (gboolean (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_allow_deletion;
	iface->get_log_levels = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_log_levels;
	iface->get_plugin_path = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_plugin_path;
	iface->get_engine_path = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_engine_path;
	iface->get_media_engine = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_media_engine;
	iface->get_enabled = (gboolean (*)(RygelConfiguration*, const gchar*, GError**)) rygel_cmdline_config_real_get_enabled;
	iface->get_title = (gchar* (*)(RygelConfiguration*, const gchar*, GError**)) rygel_cmdline_config_real_get_title;
	iface->get_video_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_video_upload_folder;
	iface->get_music_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_music_upload_folder;
	iface->get_picture_upload_folder = (gchar* (*)(RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_picture_upload_folder;
	iface->get_string = (gchar* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_cmdline_config_real_get_string;
	iface->get_string_list = (GeeArrayList* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_cmdline_config_real_get_string_list;
	iface->get_int = (gint (*)(RygelConfiguration*, const gchar*, const gchar*, gint, gint, GError**)) rygel_cmdline_config_real_get_int;
	iface->get_int_list = (GeeArrayList* (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_cmdline_config_real_get_int_list;
	iface->get_bool = (gboolean (*)(RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_cmdline_config_real_get_bool;
}


static void rygel_cmdline_config_instance_init (RygelCmdlineConfig * self) {
}


static void rygel_cmdline_config_finalize (GObject* obj) {
	RygelCmdlineConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfig);
	G_OBJECT_CLASS (rygel_cmdline_config_parent_class)->finalize (obj);
}


/**
 * Manages configuration from Commandline arguments.
 */
GType rygel_cmdline_config_get_type (void) {
	static volatile gsize rygel_cmdline_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_cmdline_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelCmdlineConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_cmdline_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelCmdlineConfig), 0, (GInstanceInitFunc) rygel_cmdline_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_cmdline_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_cmdline_config_type_id;
		rygel_cmdline_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelCmdlineConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_cmdline_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_cmdline_config_type_id__volatile, rygel_cmdline_config_type_id);
	}
	return rygel_cmdline_config_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



