/* rygel-media-export-info-serializer.c generated by valac 0.30.0, the Vala compiler
 * generated from rygel-media-export-info-serializer.vala, do not modify */

/*
 * Copyright (C) 2015 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <libmediaart/mediaart.h>
#include <gio/gio.h>
#include <gst/pbutils/pbutils.h>
#include <libgupnp-dlna/gupnp-dlna.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <gst/tag/tag.h>


#define RYGEL_TYPE_INFO_SERIALIZER (rygel_info_serializer_get_type ())
#define RYGEL_INFO_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_INFO_SERIALIZER, RygelInfoSerializer))
#define RYGEL_INFO_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_INFO_SERIALIZER, RygelInfoSerializerClass))
#define RYGEL_IS_INFO_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_INFO_SERIALIZER))
#define RYGEL_IS_INFO_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_INFO_SERIALIZER))
#define RYGEL_INFO_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_INFO_SERIALIZER, RygelInfoSerializerClass))

typedef struct _RygelInfoSerializer RygelInfoSerializer;
typedef struct _RygelInfoSerializerClass RygelInfoSerializerClass;
typedef struct _RygelInfoSerializerPrivate RygelInfoSerializerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _gst_date_time_unref0(var) ((var == NULL) ? NULL : (var = (gst_date_time_unref (var), NULL)))
#define _gst_tag_list_unref0(var) ((var == NULL) ? NULL : (var = (gst_tag_list_unref (var), NULL)))
#define _gst_sample_unref0(var) ((var == NULL) ? NULL : (var = (gst_sample_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	INFO_SERIALIZER_ERROR_INVALID_STREAM,
	INFO_SERIALIZER_ERROR_BAD_MIME
} InfoSerializerError;
#define INFO_SERIALIZER_ERROR info_serializer_error_quark ()
struct _RygelInfoSerializer {
	GObject parent_instance;
	RygelInfoSerializerPrivate * priv;
};

struct _RygelInfoSerializerClass {
	GObjectClass parent_class;
};

struct _RygelInfoSerializerPrivate {
	MediaArtProcess* _media_art;
};


static gpointer rygel_info_serializer_parent_class = NULL;

GQuark info_serializer_error_quark (void);
GType rygel_info_serializer_get_type (void) G_GNUC_CONST;
#define RYGEL_INFO_SERIALIZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_INFO_SERIALIZER, RygelInfoSerializerPrivate))
enum  {
	RYGEL_INFO_SERIALIZER_DUMMY_PROPERTY,
	RYGEL_INFO_SERIALIZER_MEDIA_ART
};
RygelInfoSerializer* rygel_info_serializer_new (MediaArtProcess* media_art);
RygelInfoSerializer* rygel_info_serializer_construct (GType object_type, MediaArtProcess* media_art);
GVariant* rygel_info_serializer_serialize (RygelInfoSerializer* self, GFile* file, GFileInfo* file_info, GstDiscovererInfo* info, GUPnPDLNAProfile* dlna_profile, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define UPNP_CLASS_PHOTO "object.item.imageItem.photo"
#define UPNP_CLASS_VIDEO "object.item.videoItem"
#define UPNP_CLASS_MUSIC "object.item.audioItem.musicTrack"
static GVariant* rygel_info_serializer_serialize_file_info (RygelInfoSerializer* self, GFileInfo* info);
static GVariant* rygel_info_serializer_serialize_dlna_profile (RygelInfoSerializer* self, GUPnPDLNAProfile* profile);
static GVariant* rygel_info_serializer_serialize_info (RygelInfoSerializer* self, GstDiscovererInfo* info);
static GVariant* rygel_info_serializer_serialize_audio_info (RygelInfoSerializer* self, GstDiscovererAudioInfo* info);
static GVariant* rygel_info_serializer_serialize_video_info (RygelInfoSerializer* self, GstDiscovererVideoInfo* info);
static GVariant* rygel_info_serializer_serialize_meta_data (RygelInfoSerializer* self, GFile* file, GstDiscovererAudioInfo* info);
#define UPNP_CLASS_PLAYLIST "object.item.playlistItem"
#define UPNP_CLASS_PLAYLIST_CONTAINER_DVD "object.container.playlistContainer.DVD"
MediaArtProcess* rygel_info_serializer_get_media_art (RygelInfoSerializer* self);
void rygel_info_serializer_set_media_art (RygelInfoSerializer* self, MediaArtProcess* value);
static void rygel_info_serializer_finalize (GObject* obj);
static void _vala_rygel_info_serializer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_info_serializer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark info_serializer_error_quark (void) {
	return g_quark_from_static_string ("info_serializer_error-quark");
}


RygelInfoSerializer* rygel_info_serializer_construct (GType object_type, MediaArtProcess* media_art) {
	RygelInfoSerializer * self = NULL;
	MediaArtProcess* _tmp0_ = NULL;
	_tmp0_ = media_art;
	self = (RygelInfoSerializer*) g_object_new (object_type, "media-art", _tmp0_, NULL);
	return self;
}


RygelInfoSerializer* rygel_info_serializer_new (MediaArtProcess* media_art) {
	return rygel_info_serializer_construct (RYGEL_TYPE_INFO_SERIALIZER, media_art);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GVariant* rygel_info_serializer_serialize (RygelInfoSerializer* self, GFile* file, GFileInfo* file_info, GstDiscovererInfo* info, GUPnPDLNAProfile* dlna_profile, GError** error) {
	GVariant* result = NULL;
	GstDiscovererInfo* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = info;
	if (_tmp0_ != NULL) {
		gchar* upnp_class = NULL;
		GList* audio_streams = NULL;
		GstDiscovererInfo* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
		GList* video_streams = NULL;
		GstDiscovererInfo* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		GList* _tmp6_ = NULL;
		gboolean _tmp12_ = FALSE;
		GList* _tmp13_ = NULL;
		GstDiscovererAudioInfo* _tmp22_ = NULL;
		GList* _tmp23_ = NULL;
		GstDiscovererVideoInfo* _tmp26_ = NULL;
		GList* _tmp27_ = NULL;
		GstDiscovererAudioInfo* _tmp30_ = NULL;
		GList* _tmp31_ = NULL;
		const gchar* _tmp34_ = NULL;
		GFileInfo* _tmp35_ = NULL;
		GVariant* _tmp36_ = NULL;
		GVariant* _tmp37_ = NULL;
		GUPnPDLNAProfile* _tmp38_ = NULL;
		GVariant* _tmp39_ = NULL;
		GVariant* _tmp40_ = NULL;
		GstDiscovererInfo* _tmp41_ = NULL;
		GVariant* _tmp42_ = NULL;
		GVariant* _tmp43_ = NULL;
		GVariant* _tmp44_ = NULL;
		GVariant* _tmp45_ = NULL;
		GVariant* _tmp46_ = NULL;
		GVariant* _tmp47_ = NULL;
		GFile* _tmp48_ = NULL;
		GVariant* _tmp49_ = NULL;
		GVariant* _tmp50_ = NULL;
		GVariant* _tmp51_ = NULL;
		GVariant* _tmp52_ = NULL;
		upnp_class = NULL;
		_tmp1_ = info;
		_tmp2_ = gst_discoverer_info_get_audio_streams (_tmp1_);
		audio_streams = (GList*) _tmp2_;
		_tmp3_ = info;
		_tmp4_ = gst_discoverer_info_get_video_streams (_tmp3_);
		video_streams = (GList*) _tmp4_;
		_tmp6_ = audio_streams;
		if (_tmp6_ == NULL) {
			GList* _tmp7_ = NULL;
			_tmp7_ = video_streams;
			_tmp5_ = _tmp7_ == NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GFile* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
			_tmp8_ = file;
			_tmp9_ = g_file_get_uri (_tmp8_);
			_tmp10_ = _tmp9_;
			g_debug ("%s had neither audio nor video/picture " "streams. Ignoring.", _tmp10_);
			_g_free0 (_tmp10_);
			_tmp11_ = g_error_new_literal (INFO_SERIALIZER_ERROR, INFO_SERIALIZER_ERROR_INVALID_STREAM, "No stream information");
			_inner_error_ = _tmp11_;
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (video_streams);
			__g_list_free__g_object_unref0_0 (audio_streams);
			_g_free0 (upnp_class);
			return NULL;
		}
		_tmp13_ = audio_streams;
		if (_tmp13_ == NULL) {
			GList* _tmp14_ = NULL;
			gconstpointer _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			_tmp14_ = video_streams;
			_tmp15_ = _tmp14_->data;
			_tmp16_ = gst_discoverer_video_info_is_image ((GstDiscovererVideoInfo*) _tmp15_);
			_tmp12_ = _tmp16_;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gchar* _tmp17_ = NULL;
			_tmp17_ = g_strdup (UPNP_CLASS_PHOTO);
			_g_free0 (upnp_class);
			upnp_class = _tmp17_;
		} else {
			GList* _tmp18_ = NULL;
			_tmp18_ = video_streams;
			if (_tmp18_ != NULL) {
				gchar* _tmp19_ = NULL;
				_tmp19_ = g_strdup (UPNP_CLASS_VIDEO);
				_g_free0 (upnp_class);
				upnp_class = _tmp19_;
			} else {
				GList* _tmp20_ = NULL;
				_tmp20_ = audio_streams;
				if (_tmp20_ != NULL) {
					gchar* _tmp21_ = NULL;
					_tmp21_ = g_strdup (UPNP_CLASS_MUSIC);
					_g_free0 (upnp_class);
					upnp_class = _tmp21_;
				} else {
				}
			}
		}
		_tmp23_ = audio_streams;
		if (_tmp23_ != NULL) {
			GList* _tmp24_ = NULL;
			gconstpointer _tmp25_ = NULL;
			_tmp24_ = audio_streams;
			_tmp25_ = _tmp24_->data;
			_tmp22_ = (GstDiscovererAudioInfo*) _tmp25_;
		} else {
			_tmp22_ = NULL;
		}
		_tmp27_ = video_streams;
		if (_tmp27_ != NULL) {
			GList* _tmp28_ = NULL;
			gconstpointer _tmp29_ = NULL;
			_tmp28_ = video_streams;
			_tmp29_ = _tmp28_->data;
			_tmp26_ = (GstDiscovererVideoInfo*) _tmp29_;
		} else {
			_tmp26_ = NULL;
		}
		_tmp31_ = audio_streams;
		if (_tmp31_ != NULL) {
			GList* _tmp32_ = NULL;
			gconstpointer _tmp33_ = NULL;
			_tmp32_ = audio_streams;
			_tmp33_ = _tmp32_->data;
			_tmp30_ = (GstDiscovererAudioInfo*) _tmp33_;
		} else {
			_tmp30_ = NULL;
		}
		_tmp34_ = upnp_class;
		_tmp35_ = file_info;
		_tmp36_ = rygel_info_serializer_serialize_file_info (self, _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = dlna_profile;
		_tmp39_ = rygel_info_serializer_serialize_dlna_profile (self, _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = info;
		_tmp42_ = rygel_info_serializer_serialize_info (self, _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = rygel_info_serializer_serialize_audio_info (self, _tmp22_);
		_tmp45_ = _tmp44_;
		_tmp46_ = rygel_info_serializer_serialize_video_info (self, _tmp26_);
		_tmp47_ = _tmp46_;
		_tmp48_ = file;
		_tmp49_ = rygel_info_serializer_serialize_meta_data (self, _tmp48_, _tmp30_);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_variant_new ("(smvmvmvmvmvmv)", _tmp34_, _tmp37_, _tmp40_, _tmp43_, _tmp45_, _tmp47_, _tmp50_, NULL);
		g_variant_ref_sink (_tmp51_);
		_tmp52_ = _tmp51_;
		_g_variant_unref0 (_tmp50_);
		_g_variant_unref0 (_tmp47_);
		_g_variant_unref0 (_tmp45_);
		_g_variant_unref0 (_tmp43_);
		_g_variant_unref0 (_tmp40_);
		_g_variant_unref0 (_tmp37_);
		result = _tmp52_;
		__g_list_free__g_object_unref0_0 (video_streams);
		__g_list_free__g_object_unref0_0 (audio_streams);
		_g_free0 (upnp_class);
		return result;
	} else {
		gchar* upnp_class = NULL;
		gchar* mime = NULL;
		GFileInfo* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		gboolean _tmp57_ = FALSE;
		const gchar* _tmp78_ = NULL;
		GFileInfo* _tmp79_ = NULL;
		GVariant* _tmp80_ = NULL;
		GVariant* _tmp81_ = NULL;
		GVariant* _tmp82_ = NULL;
		GVariant* _tmp83_ = NULL;
		upnp_class = NULL;
		_tmp53_ = file_info;
		_tmp54_ = g_file_info_get_content_type (_tmp53_);
		_tmp55_ = g_content_type_get_mime_type (_tmp54_);
		mime = _tmp55_;
		_tmp56_ = mime;
		_tmp57_ = g_str_has_prefix (_tmp56_, "video/");
		if (_tmp57_) {
			gchar* _tmp58_ = NULL;
			_tmp58_ = g_strdup (UPNP_CLASS_VIDEO);
			_g_free0 (upnp_class);
			upnp_class = _tmp58_;
		} else {
			const gchar* _tmp59_ = NULL;
			gboolean _tmp60_ = FALSE;
			_tmp59_ = mime;
			_tmp60_ = g_str_has_prefix (_tmp59_, "image/");
			if (_tmp60_) {
				gchar* _tmp61_ = NULL;
				_tmp61_ = g_strdup (UPNP_CLASS_PHOTO);
				_g_free0 (upnp_class);
				upnp_class = _tmp61_;
			} else {
				gboolean _tmp62_ = FALSE;
				const gchar* _tmp63_ = NULL;
				gboolean _tmp64_ = FALSE;
				_tmp63_ = mime;
				_tmp64_ = g_str_has_prefix (_tmp63_, "audio/");
				if (_tmp64_) {
					_tmp62_ = TRUE;
				} else {
					const gchar* _tmp65_ = NULL;
					_tmp65_ = mime;
					_tmp62_ = g_strcmp0 (_tmp65_, "application/ogg") == 0;
				}
				if (_tmp62_) {
					gchar* _tmp66_ = NULL;
					_tmp66_ = g_strdup (UPNP_CLASS_MUSIC);
					_g_free0 (upnp_class);
					upnp_class = _tmp66_;
				} else {
					const gchar* _tmp67_ = NULL;
					gboolean _tmp68_ = FALSE;
					_tmp67_ = mime;
					_tmp68_ = g_str_has_suffix (_tmp67_, "/xml");
					if (_tmp68_) {
						gchar* _tmp69_ = NULL;
						_tmp69_ = g_strdup (UPNP_CLASS_PLAYLIST);
						_g_free0 (upnp_class);
						upnp_class = _tmp69_;
					} else {
						const gchar* _tmp70_ = NULL;
						_tmp70_ = mime;
						if (g_strcmp0 (_tmp70_, "application/x-cd-image") == 0) {
							gchar* _tmp71_ = NULL;
							_tmp71_ = g_strdup (UPNP_CLASS_PLAYLIST_CONTAINER_DVD);
							_g_free0 (upnp_class);
							upnp_class = _tmp71_;
						} else {
							const gchar* _tmp72_ = NULL;
							GFile* _tmp73_ = NULL;
							gchar* _tmp74_ = NULL;
							gchar* _tmp75_ = NULL;
							const gchar* _tmp76_ = NULL;
							GError* _tmp77_ = NULL;
							_tmp72_ = mime;
							_tmp73_ = file;
							_tmp74_ = g_file_get_uri (_tmp73_);
							_tmp75_ = _tmp74_;
							g_debug ("rygel-media-export-info-serializer.vala:93: Unsupported content-type %" \
"s, skipping %s…", _tmp72_, _tmp75_);
							_g_free0 (_tmp75_);
							_tmp76_ = mime;
							_tmp77_ = g_error_new (INFO_SERIALIZER_ERROR, INFO_SERIALIZER_ERROR_BAD_MIME, "Not supported: %s", _tmp76_);
							_inner_error_ = _tmp77_;
							g_propagate_error (error, _inner_error_);
							_g_free0 (mime);
							_g_free0 (upnp_class);
							return NULL;
						}
					}
				}
			}
		}
		_tmp78_ = upnp_class;
		_tmp79_ = file_info;
		_tmp80_ = rygel_info_serializer_serialize_file_info (self, _tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = g_variant_new ("(smvmvmvmvmvmv)", _tmp78_, _tmp81_, NULL, NULL, NULL, NULL, NULL, NULL);
		g_variant_ref_sink (_tmp82_);
		_tmp83_ = _tmp82_;
		_g_variant_unref0 (_tmp81_);
		result = _tmp83_;
		_g_free0 (mime);
		_g_free0 (upnp_class);
		return result;
	}
}


static GVariant* rygel_info_serializer_serialize_file_info (RygelInfoSerializer* self, GFileInfo* info) {
	GVariant* result = NULL;
	GFileInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
	guint64 _tmp7_ = 0ULL;
	GFileInfo* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_display_name (_tmp0_);
	_tmp2_ = info;
	_tmp3_ = g_file_info_get_content_type (_tmp2_);
	_tmp4_ = g_content_type_get_mime_type (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = info;
	_tmp7_ = g_file_info_get_attribute_uint64 (_tmp6_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	_tmp8_ = info;
	_tmp9_ = g_file_info_get_size (_tmp8_);
	_tmp10_ = g_variant_new ("(sstt)", _tmp1_, _tmp5_, _tmp7_, _tmp9_, NULL);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp5_);
	result = _tmp11_;
	return result;
}


static GVariant* rygel_info_serializer_serialize_dlna_profile (RygelInfoSerializer* self, GUPnPDLNAProfile* profile) {
	GVariant* result = NULL;
	GUPnPDLNAProfile* _tmp0_ = NULL;
	GUPnPDLNAProfile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GUPnPDLNAProfile* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = profile;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = profile;
	_tmp2_ = gupnp_dlna_profile_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = profile;
	_tmp5_ = gupnp_dlna_profile_get_mime (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_new ("(ss)", _tmp3_, _tmp6_, NULL);
	g_variant_ref_sink (_tmp7_);
	result = _tmp7_;
	return result;
}


static gpointer _gst_tag_list_ref0 (gpointer self) {
	return self ? gst_tag_list_ref (self) : NULL;
}


static GVariant* rygel_info_serializer_serialize_info (RygelInfoSerializer* self, GstDiscovererInfo* info) {
	GVariant* result = NULL;
	glong duration = 0L;
	GstDiscovererInfo* _tmp0_ = NULL;
	GstClockTime _tmp1_ = 0ULL;
	GstTagList* tags = NULL;
	GstDiscovererInfo* _tmp4_ = NULL;
	GstTagList* _tmp5_ = NULL;
	GstTagList* _tmp6_ = NULL;
	gchar* title = NULL;
	GstTagList* _tmp7_ = NULL;
	gchar* date = NULL;
	GstDateTime* dt = NULL;
	gboolean _tmp10_ = FALSE;
	GstTagList* _tmp11_ = NULL;
	const gchar* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	glong _tmp37_ = 0L;
	GVariant* _tmp38_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	duration = (glong) -1;
	_tmp0_ = info;
	_tmp1_ = gst_discoverer_info_get_duration (_tmp0_);
	if (_tmp1_ > ((GstClockTime) 0)) {
		GstDiscovererInfo* _tmp2_ = NULL;
		GstClockTime _tmp3_ = 0ULL;
		_tmp2_ = info;
		_tmp3_ = gst_discoverer_info_get_duration (_tmp2_);
		duration = (glong) (_tmp3_ / GST_SECOND);
	}
	_tmp4_ = info;
	_tmp5_ = gst_discoverer_info_get_tags (_tmp4_);
	_tmp6_ = _gst_tag_list_ref0 (_tmp5_);
	tags = _tmp6_;
	title = NULL;
	_tmp7_ = tags;
	if (_tmp7_ != NULL) {
		GstTagList* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp8_ = tags;
		gst_tag_list_get_string (_tmp8_, GST_TAG_TITLE, &_tmp9_);
		_g_free0 (title);
		title = _tmp9_;
	}
	date = NULL;
	dt = NULL;
	_tmp11_ = tags;
	if (_tmp11_ != NULL) {
		GstTagList* _tmp12_ = NULL;
		GstDateTime* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp12_ = tags;
		_tmp14_ = gst_tag_list_get_date_time (_tmp12_, GST_TAG_DATE_TIME, &_tmp13_);
		_gst_date_time_unref0 (dt);
		dt = _tmp13_;
		_tmp10_ = _tmp14_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		gboolean _tmp15_ = FALSE;
		GstDateTime* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp16_ = dt;
		_tmp17_ = gst_date_time_has_day (_tmp16_);
		if (!_tmp17_) {
			_tmp15_ = TRUE;
		} else {
			GstDateTime* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			_tmp18_ = dt;
			_tmp19_ = gst_date_time_has_month (_tmp18_);
			_tmp15_ = !_tmp19_;
		}
		if (_tmp15_) {
			gint _tmp20_ = 0;
			GstDateTime* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			gint _tmp25_ = 0;
			GstDateTime* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
			GstDateTime* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			gchar* _tmp32_ = NULL;
			_tmp21_ = dt;
			_tmp22_ = gst_date_time_has_month (_tmp21_);
			if (_tmp22_) {
				GstDateTime* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				_tmp23_ = dt;
				_tmp24_ = gst_date_time_get_month (_tmp23_);
				_tmp20_ = _tmp24_;
			} else {
				_tmp20_ = 1;
			}
			_tmp26_ = dt;
			_tmp27_ = gst_date_time_has_day (_tmp26_);
			if (_tmp27_) {
				GstDateTime* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				_tmp28_ = dt;
				_tmp29_ = gst_date_time_get_day (_tmp28_);
				_tmp25_ = _tmp29_;
			} else {
				_tmp25_ = 1;
			}
			_tmp30_ = dt;
			_tmp31_ = gst_date_time_get_year (_tmp30_);
			_tmp32_ = g_strdup_printf ("%d-%02d-%02d", _tmp31_, _tmp20_, _tmp25_);
			_g_free0 (date);
			date = _tmp32_;
		} else {
			GstDateTime* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			_tmp33_ = dt;
			_tmp34_ = gst_date_time_to_iso8601_string (_tmp33_);
			_g_free0 (date);
			date = _tmp34_;
		}
	}
	_tmp35_ = title;
	_tmp36_ = date;
	_tmp37_ = duration;
	_tmp38_ = g_variant_new ("(msmsi)", _tmp35_, _tmp36_, _tmp37_, NULL);
	g_variant_ref_sink (_tmp38_);
	result = _tmp38_;
	_gst_date_time_unref0 (dt);
	_g_free0 (date);
	_g_free0 (title);
	_gst_tag_list_unref0 (tags);
	return result;
}


static GVariant* rygel_info_serializer_serialize_video_info (RygelInfoSerializer* self, GstDiscovererVideoInfo* info) {
	GVariant* result = NULL;
	GstDiscovererVideoInfo* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GstDiscovererVideoInfo* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GstDiscovererVideoInfo* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	GstDiscovererVideoInfo* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	GVariant* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = info;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = info;
	_tmp3_ = gst_discoverer_video_info_get_depth (_tmp2_);
	if (_tmp3_ > ((guint) 0)) {
		GstDiscovererVideoInfo* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		_tmp4_ = info;
		_tmp5_ = gst_discoverer_video_info_get_depth (_tmp4_);
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = (guint) -1;
	}
	_tmp6_ = info;
	_tmp7_ = gst_discoverer_video_info_get_width (_tmp6_);
	_tmp8_ = info;
	_tmp9_ = gst_discoverer_video_info_get_height (_tmp8_);
	_tmp10_ = g_variant_new ("(iii)", (gint) _tmp7_, (gint) _tmp9_, _tmp1_, NULL);
	g_variant_ref_sink (_tmp10_);
	result = _tmp10_;
	return result;
}


static GVariant* rygel_info_serializer_serialize_audio_info (RygelInfoSerializer* self, GstDiscovererAudioInfo* info) {
	GVariant* result = NULL;
	GstDiscovererAudioInfo* _tmp0_ = NULL;
	GstDiscovererAudioInfo* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GstDiscovererAudioInfo* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	GVariant* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = info;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = info;
	_tmp2_ = gst_discoverer_audio_info_get_channels (_tmp1_);
	_tmp3_ = info;
	_tmp4_ = gst_discoverer_audio_info_get_sample_rate (_tmp3_);
	_tmp5_ = g_variant_new ("(ii)", (gint) _tmp2_, (gint) _tmp4_, NULL);
	g_variant_ref_sink (_tmp5_);
	result = _tmp5_;
	return result;
}


static GVariant* rygel_info_serializer_serialize_meta_data (RygelInfoSerializer* self, GFile* file, GstDiscovererAudioInfo* info) {
	GVariant* result = NULL;
	GstDiscovererAudioInfo* _tmp0_ = NULL;
	GstTagList* tags = NULL;
	GstDiscovererAudioInfo* _tmp1_ = NULL;
	GstTagList* _tmp2_ = NULL;
	GstTagList* _tmp3_ = NULL;
	GstTagList* _tmp4_ = NULL;
	gchar* artist = NULL;
	GstTagList* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* album = NULL;
	GstTagList* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* genre = NULL;
	GstTagList* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	guint volume = 0U;
	GstTagList* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	guint track = 0U;
	GstTagList* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	guint bitrate = 0U;
	GstTagList* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	GstSample* sample = NULL;
	GstTagList* _tmp17_ = NULL;
	GstSample* _tmp18_ = NULL;
	GstSample* _tmp19_ = NULL;
	GstSample* _tmp22_ = NULL;
	const gchar* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	guint _tmp63_ = 0U;
	guint _tmp64_ = 0U;
	guint _tmp65_ = 0U;
	GVariant* _tmp66_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = info;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = info;
	_tmp2_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp1_);
	_tmp3_ = _gst_tag_list_ref0 (_tmp2_);
	tags = _tmp3_;
	_tmp4_ = tags;
	if (_tmp4_ == NULL) {
		result = NULL;
		_gst_tag_list_unref0 (tags);
		return result;
	}
	artist = NULL;
	_tmp5_ = tags;
	gst_tag_list_get_string (_tmp5_, GST_TAG_ARTIST, &_tmp6_);
	_g_free0 (artist);
	artist = _tmp6_;
	album = NULL;
	_tmp7_ = tags;
	gst_tag_list_get_string (_tmp7_, GST_TAG_ALBUM, &_tmp8_);
	_g_free0 (album);
	album = _tmp8_;
	genre = NULL;
	_tmp9_ = tags;
	gst_tag_list_get_string (_tmp9_, GST_TAG_GENRE, &_tmp10_);
	_g_free0 (genre);
	genre = _tmp10_;
	volume = G_MAXUINT;
	_tmp11_ = tags;
	gst_tag_list_get_uint (_tmp11_, GST_TAG_ALBUM_VOLUME_NUMBER, &_tmp12_);
	volume = _tmp12_;
	track = G_MAXUINT;
	_tmp13_ = tags;
	gst_tag_list_get_uint (_tmp13_, GST_TAG_TRACK_NUMBER, &_tmp14_);
	track = _tmp14_;
	bitrate = G_MAXUINT;
	_tmp15_ = tags;
	gst_tag_list_get_uint (_tmp15_, GST_TAG_BITRATE, &_tmp16_);
	bitrate = _tmp16_;
	_tmp17_ = tags;
	gst_tag_list_get_sample (_tmp17_, GST_TAG_IMAGE, &_tmp18_);
	_gst_sample_unref0 (sample);
	sample = _tmp18_;
	_tmp19_ = sample;
	if (_tmp19_ == NULL) {
		GstTagList* _tmp20_ = NULL;
		GstSample* _tmp21_ = NULL;
		_tmp20_ = tags;
		gst_tag_list_get_sample (_tmp20_, GST_TAG_PREVIEW_IMAGE, &_tmp21_);
		_gst_sample_unref0 (sample);
		sample = _tmp21_;
	}
	_tmp22_ = sample;
	if (_tmp22_ == NULL) {
		{
			gboolean _tmp23_ = FALSE;
			const gchar* _tmp24_ = NULL;
			_tmp24_ = artist;
			if (_tmp24_ != NULL) {
				_tmp23_ = TRUE;
			} else {
				const gchar* _tmp25_ = NULL;
				_tmp25_ = album;
				_tmp23_ = _tmp25_ != NULL;
			}
			if (_tmp23_) {
				MediaArtProcess* _tmp26_ = NULL;
				GFile* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				_tmp26_ = self->priv->_media_art;
				_tmp27_ = file;
				_tmp28_ = artist;
				_tmp29_ = album;
				media_art_process_file (_tmp26_, MEDIA_ART_ALBUM, MEDIA_ART_PROCESS_FLAGS_NONE, _tmp27_, _tmp28_, _tmp29_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch10_g_error;
				}
			}
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp30_ = _error_;
			_tmp31_ = _tmp30_->message;
			g_debug ("rygel-media-export-info-serializer.vala:231: Failed to add external me" \
"dia art: %s", _tmp31_);
			_g_error_free0 (_error_);
		}
		__finally10:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_gst_sample_unref0 (sample);
			_g_free0 (genre);
			_g_free0 (album);
			_g_free0 (artist);
			_gst_tag_list_unref0 (tags);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	} else {
		GstStructure* structure = NULL;
		GstSample* _tmp32_ = NULL;
		GstCaps* _tmp33_ = NULL;
		GstStructure* _tmp34_ = NULL;
		gint image_type = 0;
		GstStructure* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		gboolean _tmp37_ = FALSE;
		gint _tmp38_ = 0;
		_tmp32_ = sample;
		_tmp33_ = gst_sample_get_caps (_tmp32_);
		_tmp34_ = gst_caps_get_structure (_tmp33_, (guint) 0);
		structure = _tmp34_;
		_tmp35_ = structure;
		gst_structure_get_enum (_tmp35_, "image-type", gst_tag_image_type_get_type (), &_tmp36_);
		image_type = _tmp36_;
		_tmp38_ = image_type;
		if (_tmp38_ == ((gint) GST_TAG_IMAGE_TYPE_UNDEFINED)) {
			_tmp37_ = TRUE;
		} else {
			gint _tmp39_ = 0;
			_tmp39_ = image_type;
			_tmp37_ = _tmp39_ == ((gint) GST_TAG_IMAGE_TYPE_FRONT_COVER);
		}
		if (_tmp37_) {
			GstMapInfo map_info = {0};
			GstSample* _tmp40_ = NULL;
			GstBuffer* _tmp41_ = NULL;
			GstMapInfo _tmp42_ = {0};
			guint8* data = NULL;
			GstMapInfo _tmp43_ = {0};
			guint8* _tmp44_ = NULL;
			gint _tmp44__length1 = 0;
			gint data_length1 = 0;
			gint _data_size_ = 0;
			GstMapInfo _tmp45_ = {0};
			gsize _tmp46_ = 0UL;
			gint _tmp47_ = 0;
			GstSample* _tmp57_ = NULL;
			GstBuffer* _tmp58_ = NULL;
			GstMapInfo _tmp59_ = {0};
			_tmp40_ = sample;
			_tmp41_ = gst_sample_get_buffer (_tmp40_);
			gst_buffer_map (_tmp41_, &_tmp42_, GST_MAP_READ);
			map_info = _tmp42_;
			_tmp43_ = map_info;
			_tmp44_ = _tmp43_.data;
			_tmp44__length1 = (gint) _tmp43_.size;
			data = _tmp44_;
			data_length1 = _tmp44__length1;
			_data_size_ = data_length1;
			_tmp45_ = map_info;
			_tmp46_ = _tmp45_.size;
			data_length1 = (gint) _tmp46_;
			_tmp47_ = data_length1;
			{
				MediaArtProcess* _tmp48_ = NULL;
				GFile* _tmp49_ = NULL;
				guint8* _tmp50_ = NULL;
				gint _tmp50__length1 = 0;
				GstStructure* _tmp51_ = NULL;
				const gchar* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				const gchar* _tmp54_ = NULL;
				_tmp48_ = self->priv->_media_art;
				_tmp49_ = file;
				_tmp50_ = data;
				_tmp50__length1 = data_length1;
				_tmp51_ = structure;
				_tmp52_ = gst_structure_get_name (_tmp51_);
				_tmp53_ = artist;
				_tmp54_ = album;
				media_art_process_buffer (_tmp48_, MEDIA_ART_ALBUM, MEDIA_ART_PROCESS_FLAGS_NONE, _tmp49_, _tmp50_, (gsize) _tmp50__length1, _tmp52_, _tmp53_, _tmp54_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch11_g_error;
				}
			}
			goto __finally11;
			__catch11_g_error:
			{
				GError* _error_ = NULL;
				GError* _tmp55_ = NULL;
				const gchar* _tmp56_ = NULL;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				_tmp55_ = _error_;
				_tmp56_ = _tmp55_->message;
				g_debug ("rygel-media-export-info-serializer.vala:257: Failed to add media art t" \
"o cache: %s", _tmp56_);
				_g_error_free0 (_error_);
			}
			__finally11:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_gst_sample_unref0 (sample);
				_g_free0 (genre);
				_g_free0 (album);
				_g_free0 (artist);
				_gst_tag_list_unref0 (tags);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp57_ = sample;
			_tmp58_ = gst_sample_get_buffer (_tmp57_);
			_tmp59_ = map_info;
			gst_buffer_unmap (_tmp58_, &_tmp59_);
		}
	}
	_tmp60_ = artist;
	_tmp61_ = album;
	_tmp62_ = genre;
	_tmp63_ = volume;
	_tmp64_ = track;
	_tmp65_ = bitrate;
	_tmp66_ = g_variant_new ("(msmsmsiii)", _tmp60_, _tmp61_, _tmp62_, _tmp63_, _tmp64_, ((gint) _tmp65_) / 8, NULL);
	g_variant_ref_sink (_tmp66_);
	result = _tmp66_;
	_gst_sample_unref0 (sample);
	_g_free0 (genre);
	_g_free0 (album);
	_g_free0 (artist);
	_gst_tag_list_unref0 (tags);
	return result;
}


MediaArtProcess* rygel_info_serializer_get_media_art (RygelInfoSerializer* self) {
	MediaArtProcess* result;
	MediaArtProcess* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_media_art;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_info_serializer_set_media_art (RygelInfoSerializer* self, MediaArtProcess* value) {
	MediaArtProcess* _tmp0_ = NULL;
	MediaArtProcess* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_media_art);
	self->priv->_media_art = _tmp1_;
	g_object_notify ((GObject *) self, "media-art");
}


static void rygel_info_serializer_class_init (RygelInfoSerializerClass * klass) {
	rygel_info_serializer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelInfoSerializerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_info_serializer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_info_serializer_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_info_serializer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_INFO_SERIALIZER_MEDIA_ART, g_param_spec_object ("media-art", "media-art", "media-art", media_art_process_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void rygel_info_serializer_instance_init (RygelInfoSerializer * self) {
	self->priv = RYGEL_INFO_SERIALIZER_GET_PRIVATE (self);
}


static void rygel_info_serializer_finalize (GObject* obj) {
	RygelInfoSerializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_INFO_SERIALIZER, RygelInfoSerializer);
	_g_object_unref0 (self->priv->_media_art);
	G_OBJECT_CLASS (rygel_info_serializer_parent_class)->finalize (obj);
}


GType rygel_info_serializer_get_type (void) {
	static volatile gsize rygel_info_serializer_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_info_serializer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelInfoSerializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_info_serializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelInfoSerializer), 0, (GInstanceInitFunc) rygel_info_serializer_instance_init, NULL };
		GType rygel_info_serializer_type_id;
		rygel_info_serializer_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelInfoSerializer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_info_serializer_type_id__volatile, rygel_info_serializer_type_id);
	}
	return rygel_info_serializer_type_id__volatile;
}


static void _vala_rygel_info_serializer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelInfoSerializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_INFO_SERIALIZER, RygelInfoSerializer);
	switch (property_id) {
		case RYGEL_INFO_SERIALIZER_MEDIA_ART:
		g_value_set_object (value, rygel_info_serializer_get_media_art (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_info_serializer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelInfoSerializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_INFO_SERIALIZER, RygelInfoSerializer);
	switch (property_id) {
		case RYGEL_INFO_SERIALIZER_MEDIA_ART:
		rygel_info_serializer_set_media_art (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



