/* rygel-media-export-dvd-parser.c generated by valac 0.30.0, the Vala compiler
 * generated from rygel-media-export-dvd-parser.vala, do not modify */

/*
 * Copyright (C) 2013,2015 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_DVD_PARSER (rygel_dvd_parser_get_type ())
#define RYGEL_DVD_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DVD_PARSER, RygelDVDParser))
#define RYGEL_DVD_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DVD_PARSER, RygelDVDParserClass))
#define RYGEL_IS_DVD_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DVD_PARSER))
#define RYGEL_IS_DVD_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DVD_PARSER))
#define RYGEL_DVD_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DVD_PARSER, RygelDVDParserClass))

typedef struct _RygelDVDParser RygelDVDParser;
typedef struct _RygelDVDParserClass RygelDVDParserClass;
typedef struct _RygelDVDParserPrivate RygelDVDParserPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelDvdParserRunData RygelDvdParserRunData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelDvdParserGetInformationData RygelDvdParserGetInformationData;

typedef enum  {
	DVD_PARSER_ERROR_GENERAL,
	DVD_PARSER_ERROR_NOT_AVAILABLE
} DVDParserError;
#define DVD_PARSER_ERROR dvd_parser_error_quark ()
struct _RygelDVDParser {
	GObject parent_instance;
	RygelDVDParserPrivate * priv;
};

struct _RygelDVDParserClass {
	GObjectClass parent_class;
};

struct _RygelDVDParserPrivate {
	GFile* _file;
	GFile* cache_file;
};

struct _RygelDvdParserRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelDVDParser* self;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_;
};

struct _RygelDvdParserGetInformationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelDVDParser* self;
	xmlDoc* result;
	GFile* _tmp0_;
	gboolean _tmp1_;
	GSubprocessLauncher* launcher;
	GSubprocessLauncher* _tmp2_;
	GSubprocessLauncher* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** args;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gint args_length1;
	gint _args_size_;
	GSubprocess* process;
	GSubprocessLauncher* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GSubprocess* _tmp17_;
	GSubprocess* _tmp18_;
	gboolean _tmp19_;
	GSubprocess* _tmp20_;
	gboolean _tmp21_;
	GSubprocess* _tmp22_;
	gint _tmp23_;
	GFile* _tmp24_;
	GError* _error_;
	GError* _tmp25_;
	const gchar* _tmp26_;
	GError* _tmp27_;
	GFile* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	xmlDoc* _tmp31_;
	xmlDoc* _tmp32_;
	GError * _inner_error_;
};


static gpointer rygel_dvd_parser_parent_class = NULL;
static gchar* rygel_dvd_parser_lsdvd_binary_path;
static gchar* rygel_dvd_parser_lsdvd_binary_path = NULL;

GQuark dvd_parser_error_quark (void);
GType rygel_dvd_parser_get_type (void) G_GNUC_CONST;
#define RYGEL_DVD_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DVD_PARSER, RygelDVDParserPrivate))
enum  {
	RYGEL_DVD_PARSER_DUMMY_PROPERTY,
	RYGEL_DVD_PARSER_FILE
};
RygelDVDParser* rygel_dvd_parser_new (GFile* file);
RygelDVDParser* rygel_dvd_parser_construct (GType object_type, GFile* file);
gchar* rygel_dvd_parser_get_cache_path (const gchar* image_path);
static void rygel_dvd_parser_real_constructed (GObject* base);
GFile* rygel_dvd_parser_get_file (RygelDVDParser* self);
static void rygel_dvd_parser_run_data_free (gpointer _data);
void rygel_dvd_parser_run (RygelDVDParser* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_dvd_parser_run_finish (RygelDVDParser* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_dvd_parser_run_co (RygelDvdParserRunData* _data_);
void rygel_dvd_parser_get_information (RygelDVDParser* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
xmlDoc* rygel_dvd_parser_get_information_finish (RygelDVDParser* self, GAsyncResult* _res_, GError** error);
static void rygel_dvd_parser_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_dvd_parser_get_information_data_free (gpointer _data);
static gboolean rygel_dvd_parser_get_information_co (RygelDvdParserGetInformationData* _data_);
static void rygel_dvd_parser_get_information_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_dvd_parser_set_file (RygelDVDParser* self, GFile* value);
static void rygel_dvd_parser_finalize (GObject* obj);
static void _vala_rygel_dvd_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_dvd_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark dvd_parser_error_quark (void) {
	return g_quark_from_static_string ("dvd_parser_error-quark");
}


RygelDVDParser* rygel_dvd_parser_construct (GType object_type, GFile* file) {
	RygelDVDParser * self = NULL;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = file;
	self = (RygelDVDParser*) g_object_new (object_type, "file", _tmp0_, NULL);
	return self;
}


RygelDVDParser* rygel_dvd_parser_new (GFile* file) {
	return rygel_dvd_parser_construct (RYGEL_TYPE_DVD_PARSER, file);
}


gchar* rygel_dvd_parser_get_cache_path (const gchar* image_path) {
	gchar* result = NULL;
	const gchar* user_cache = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* id = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* cache_folder = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (image_path != NULL, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	user_cache = _tmp0_;
	_tmp1_ = image_path;
	_tmp2_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp1_, (gsize) -1);
	id = _tmp2_;
	_tmp3_ = g_build_filename (user_cache, "rygel", "dvd-content", NULL);
	cache_folder = _tmp3_;
	g_mkdir_with_parents (cache_folder, 0700);
	_tmp4_ = g_build_filename (cache_folder, id, NULL);
	result = _tmp4_;
	_g_free0 (cache_folder);
	_g_free0 (id);
	return result;
}


static void rygel_dvd_parser_real_constructed (GObject* base) {
	RygelDVDParser * self;
	gchar* path = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	self = (RygelDVDParser*) base;
	_tmp0_ = self->priv->_file;
	_tmp1_ = g_file_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = rygel_dvd_parser_get_cache_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	path = _tmp4_;
	_tmp5_ = g_file_new_for_path (path);
	_g_object_unref0 (self->priv->cache_file);
	self->priv->cache_file = _tmp5_;
	_g_free0 (path);
}


static void rygel_dvd_parser_run_data_free (gpointer _data) {
	RygelDvdParserRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelDvdParserRunData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_dvd_parser_run (RygelDVDParser* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelDvdParserRunData* _data_;
	RygelDVDParser* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelDvdParserRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_dvd_parser_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_dvd_parser_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_dvd_parser_run_co (_data_);
}


void rygel_dvd_parser_run_finish (RygelDVDParser* self, GAsyncResult* _res_, GError** error) {
	RygelDvdParserRunData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_dvd_parser_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelDvdParserRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_dvd_parser_run_co (_data_);
}


static gboolean rygel_dvd_parser_run_co (RygelDvdParserRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = rygel_dvd_parser_lsdvd_binary_path;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = g_error_new_literal (DVD_PARSER_ERROR, DVD_PARSER_ERROR_NOT_AVAILABLE, "No DVD extractor found");
		_data_->_inner_error_ = _data_->_tmp1_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 1;
	rygel_dvd_parser_get_information (_data_->self, rygel_dvd_parser_run_ready, _data_);
	return FALSE;
	_state_1:
	rygel_dvd_parser_get_information_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_dvd_parser_get_information_data_free (gpointer _data) {
	RygelDvdParserGetInformationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelDvdParserGetInformationData, _data_);
}


void rygel_dvd_parser_get_information (RygelDVDParser* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelDvdParserGetInformationData* _data_;
	RygelDVDParser* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelDvdParserGetInformationData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_dvd_parser_get_information);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_dvd_parser_get_information_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_dvd_parser_get_information_co (_data_);
}


xmlDoc* rygel_dvd_parser_get_information_finish (RygelDVDParser* self, GAsyncResult* _res_, GError** error) {
	xmlDoc* result;
	RygelDvdParserGetInformationData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_dvd_parser_get_information_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelDvdParserGetInformationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_dvd_parser_get_information_co (_data_);
}


static gboolean rygel_dvd_parser_get_information_co (RygelDvdParserGetInformationData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->cache_file;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = g_file_query_exists (_data_->_tmp0_, NULL);
	if (!_data_->_tmp1_) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = g_subprocess_launcher_new (G_SUBPROCESS_FLAGS_STDERR_SILENCE);
		_data_->launcher = _data_->_tmp2_;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->launcher;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->self->priv->cache_file;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_file_get_path (_data_->_tmp4_);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp5_;
		g_subprocess_launcher_set_stdout_file_path (_data_->_tmp3_, _data_->_tmp6_);
		_g_free0 (_data_->_tmp6_);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = rygel_dvd_parser_lsdvd_binary_path;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_strdup ("-Ox");
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_strdup ("-x");
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = g_strdup ("-q");
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->self->priv->_file;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = g_file_get_path (_data_->_tmp12_);
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = g_new0 (gchar*, 6 + 1);
		_data_->_tmp14_[0] = _data_->_tmp8_;
		_data_->_tmp14_[1] = _data_->_tmp9_;
		_data_->_tmp14_[2] = _data_->_tmp10_;
		_data_->_tmp14_[3] = _data_->_tmp11_;
		_data_->_tmp14_[4] = _data_->_tmp13_;
		_data_->_tmp14_[5] = NULL;
		_data_->args_length1 = 0;
		_data_->_args_size_ = 0;
		_data_->args = _data_->_tmp14_;
		_data_->args_length1 = 6;
		_data_->_args_size_ = _data_->args_length1;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->launcher;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16__length1 = 0;
		_data_->_tmp16_ = _data_->args;
		_data_->_tmp16__length1 = _data_->args_length1;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_subprocess_launcher_spawnv (_data_->_tmp15_, _data_->_tmp16_, &_data_->_inner_error_);
		_data_->process = _data_->_tmp17_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->launcher);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->process;
		_data_->_state_ = 1;
		g_subprocess_wait_async (_data_->_tmp18_, NULL, rygel_dvd_parser_get_information_ready, _data_);
		return FALSE;
		_state_1:
		g_subprocess_wait_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->process);
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->launcher);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->process;
		_data_->_tmp21_ = FALSE;
		_data_->_tmp21_ = g_subprocess_get_if_exited (_data_->_tmp20_);
		if (_data_->_tmp21_) {
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _data_->process;
			_data_->_tmp23_ = 0;
			_data_->_tmp23_ = g_subprocess_get_exit_status (_data_->_tmp22_);
			_data_->_tmp19_ = _data_->_tmp23_ == 0;
		} else {
			_data_->_tmp19_ = FALSE;
		}
		if (!_data_->_tmp19_) {
			{
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = _data_->self->priv->cache_file;
				g_file_delete (_data_->_tmp24_, NULL, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					goto __catch12_g_error;
				}
			}
			goto __finally12;
			__catch12_g_error:
			{
				_data_->_error_ = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp25_ = NULL;
				_data_->_tmp25_ = _data_->_error_;
				_data_->_tmp26_ = NULL;
				_data_->_tmp26_ = _data_->_tmp25_->message;
				g_debug ("rygel-media-export-dvd-parser.vala:93: Failed to delete cache file: %s", _data_->_tmp26_);
				_g_error_free0 (_data_->_error_);
			}
			__finally12:
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->process);
				_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (_data_->launcher);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = g_error_new_literal (DVD_PARSER_ERROR, DVD_PARSER_ERROR_GENERAL, "lsdvd did die or file is not a DVD");
			_data_->_inner_error_ = _data_->_tmp27_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->process);
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->launcher);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->process);
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->launcher);
	}
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->self->priv->cache_file;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = g_file_get_path (_data_->_tmp28_);
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->_tmp29_;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = xmlReadFile (_data_->_tmp30_, NULL, (gint) (XML_PARSE_NOERROR | XML_PARSE_NOWARNING));
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->_tmp31_;
	_g_free0 (_data_->_tmp30_);
	_data_->result = _data_->_tmp32_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


GFile* rygel_dvd_parser_get_file (RygelDVDParser* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}


static void rygel_dvd_parser_set_file (RygelDVDParser* self, GFile* value) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp1_;
	g_object_notify ((GObject *) self, "file");
}


static void rygel_dvd_parser_class_init (RygelDVDParserClass * klass) {
	gchar* path = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	rygel_dvd_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelDVDParserPrivate));
	((GObjectClass *) klass)->constructed = rygel_dvd_parser_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_dvd_parser_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_dvd_parser_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_dvd_parser_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DVD_PARSER_FILE, g_param_spec_object ("file", "file", "file", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_find_program_in_path ("lsdvd");
	path = _tmp0_;
	_tmp1_ = path;
	if (_tmp1_ == NULL) {
		gchar* msg = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = _ ("Failed to find lsdvd binary in path. DVD extraction will not be availa" \
"ble");
		_tmp3_ = g_strdup (_tmp2_);
		msg = _tmp3_;
		_tmp4_ = msg;
		g_warning ("rygel-media-export-dvd-parser.vala:43: %s", _tmp4_);
		_g_free0 (msg);
	}
	_tmp5_ = path;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (rygel_dvd_parser_lsdvd_binary_path);
	rygel_dvd_parser_lsdvd_binary_path = _tmp6_;
	_g_free0 (path);
}


static void rygel_dvd_parser_instance_init (RygelDVDParser * self) {
	self->priv = RYGEL_DVD_PARSER_GET_PRIVATE (self);
}


static void rygel_dvd_parser_finalize (GObject* obj) {
	RygelDVDParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DVD_PARSER, RygelDVDParser);
	_g_object_unref0 (self->priv->_file);
	_g_object_unref0 (self->priv->cache_file);
	G_OBJECT_CLASS (rygel_dvd_parser_parent_class)->finalize (obj);
}


GType rygel_dvd_parser_get_type (void) {
	static volatile gsize rygel_dvd_parser_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_dvd_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDVDParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dvd_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDVDParser), 0, (GInstanceInitFunc) rygel_dvd_parser_instance_init, NULL };
		GType rygel_dvd_parser_type_id;
		rygel_dvd_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelDVDParser", &g_define_type_info, 0);
		g_once_init_leave (&rygel_dvd_parser_type_id__volatile, rygel_dvd_parser_type_id);
	}
	return rygel_dvd_parser_type_id__volatile;
}


static void _vala_rygel_dvd_parser_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelDVDParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DVD_PARSER, RygelDVDParser);
	switch (property_id) {
		case RYGEL_DVD_PARSER_FILE:
		g_value_set_object (value, rygel_dvd_parser_get_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_dvd_parser_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelDVDParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DVD_PARSER, RygelDVDParser);
	switch (property_id) {
		case RYGEL_DVD_PARSER_FILE:
		rygel_dvd_parser_set_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



