/* rygel-simple-media-engine.c generated by valac 0.30.0, the Vala compiler
 * generated from rygel-simple-media-engine.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_SIMPLE_MEDIA_ENGINE (rygel_simple_media_engine_get_type ())
#define RYGEL_SIMPLE_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SIMPLE_MEDIA_ENGINE, RygelSimpleMediaEngine))
#define RYGEL_SIMPLE_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SIMPLE_MEDIA_ENGINE, RygelSimpleMediaEngineClass))
#define RYGEL_IS_SIMPLE_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SIMPLE_MEDIA_ENGINE))
#define RYGEL_IS_SIMPLE_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SIMPLE_MEDIA_ENGINE))
#define RYGEL_SIMPLE_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SIMPLE_MEDIA_ENGINE, RygelSimpleMediaEngineClass))

typedef struct _RygelSimpleMediaEngine RygelSimpleMediaEngine;
typedef struct _RygelSimpleMediaEngineClass RygelSimpleMediaEngineClass;
typedef struct _RygelSimpleMediaEnginePrivate RygelSimpleMediaEnginePrivate;

#define RYGEL_TYPE_SIMPLE_DATA_SOURCE (rygel_simple_data_source_get_type ())
#define RYGEL_SIMPLE_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSource))
#define RYGEL_SIMPLE_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourceClass))
#define RYGEL_IS_SIMPLE_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE))
#define RYGEL_IS_SIMPLE_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SIMPLE_DATA_SOURCE))
#define RYGEL_SIMPLE_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourceClass))

typedef struct _RygelSimpleDataSource RygelSimpleDataSource;
typedef struct _RygelSimpleDataSourceClass RygelSimpleDataSourceClass;
#define __g_list_free__rygel_dlna_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__rygel_dlna_profile_unref0_ (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelSimpleMediaEngineGetResourcesForItemData RygelSimpleMediaEngineGetResourcesForItemData;

struct _RygelSimpleMediaEngine {
	RygelMediaEngine parent_instance;
	RygelSimpleMediaEnginePrivate * priv;
};

struct _RygelSimpleMediaEngineClass {
	RygelMediaEngineClass parent_class;
};

struct _RygelSimpleMediaEnginePrivate {
	GList* profiles;
	GThreadPool* pool;
};

struct _RygelSimpleMediaEngineGetResourcesForItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleMediaEngine* self;
	RygelMediaObject* object;
	GeeList* result;
	RygelMediaObject* _tmp0_;
	const gchar* _tmp1_;
	RygelMediaFileItem* item;
	RygelMediaObject* _tmp2_;
	RygelMediaFileItem* _tmp3_;
	gchar* source_uri;
	RygelMediaFileItem* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GeeArrayList* resources;
	GeeArrayList* _tmp11_;
	RygelMediaResource* primary_res;
	RygelMediaFileItem* _tmp12_;
	RygelMediaResource* _tmp13_;
	RygelMediaResource* _tmp14_;
	RygelMediaResource* _tmp15_;
	RygelMediaResource* _tmp16_;
	GUPnPDLNAFlags _tmp17_;
	GUPnPDLNAFlags _tmp18_;
	RygelMediaResource* http_res;
	RygelMediaResource* _tmp19_;
	RygelMediaResource* _tmp20_;
	RygelMediaResource* _tmp21_;
	GeeArrayList* _tmp22_;
	RygelMediaResource* _tmp23_;
	GeeArrayList* _tmp24_;
	RygelMediaResource* _tmp25_;
};


static gpointer rygel_simple_media_engine_parent_class = NULL;

GType rygel_simple_media_engine_get_type (void) G_GNUC_CONST;
GType rygel_simple_data_source_get_type (void) G_GNUC_CONST;
#define RYGEL_SIMPLE_MEDIA_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SIMPLE_MEDIA_ENGINE, RygelSimpleMediaEnginePrivate))
enum  {
	RYGEL_SIMPLE_MEDIA_ENGINE_DUMMY_PROPERTY
};
static void _rygel_dlna_profile_unref0_ (gpointer var);
static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self);
static void rygel_simple_media_engine_real_constructed (GObject* base);
void rygel_simple_data_source_pool_func (RygelSimpleDataSource* data);
static void _rygel_simple_data_source_pool_func_gfunc (gpointer data, gpointer self);
static GList* rygel_simple_media_engine_real_get_dlna_profiles (RygelMediaEngine* base);
static void rygel_simple_media_engine_real_get_resources_for_item_data_free (gpointer _data);
static void rygel_simple_media_engine_real_get_resources_for_item (RygelMediaEngine* base, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_simple_media_engine_real_get_resources_for_item_co (RygelSimpleMediaEngineGetResourcesForItemData* _data_);
static RygelDataSource* rygel_simple_media_engine_real_create_data_source_for_resource (RygelMediaEngine* base, RygelMediaObject* object, RygelMediaResource* resource, GError** error);
RygelSimpleDataSource* rygel_simple_data_source_new (GThreadPool* pool, const gchar* uri);
RygelSimpleDataSource* rygel_simple_data_source_construct (GType object_type, GThreadPool* pool, const gchar* uri);
static RygelDataSource* rygel_simple_media_engine_real_create_data_source_for_uri (RygelMediaEngine* base, const gchar* uri, GError** error);
RygelSimpleMediaEngine* rygel_simple_media_engine_new (void);
RygelSimpleMediaEngine* rygel_simple_media_engine_construct (GType object_type);
static void rygel_simple_media_engine_finalize (GObject* obj);
RygelMediaEngine* module_get_instance (void);


static void _rygel_dlna_profile_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL));
}


static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _rygel_dlna_profile_unref0_, NULL);
	g_list_free (self);
}


static void _rygel_simple_data_source_pool_func_gfunc (gpointer data, gpointer self) {
	rygel_simple_data_source_pool_func ((RygelSimpleDataSource*) data);
}


static void rygel_simple_media_engine_real_constructed (GObject* base) {
	RygelSimpleMediaEngine * self;
	GError * _inner_error_ = NULL;
	self = (RygelSimpleMediaEngine*) base;
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->profiles);
	self->priv->profiles = NULL;
	{
		GThreadPool* _tmp0_ = NULL;
		GThreadPool* _tmp1_ = NULL;
		GThreadPool* _tmp2_ = NULL;
		_tmp1_ = g_thread_pool_new (_rygel_simple_data_source_pool_func_gfunc, NULL, 10, TRUE, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_thread_pool_free0 (self->priv->pool);
		self->priv->pool = _tmp2_;
		_g_thread_pool_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_debug ("rygel-simple-media-engine.vala:46: Failed to create pool");
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static GList* rygel_simple_media_engine_real_get_dlna_profiles (RygelMediaEngine* base) {
	RygelSimpleMediaEngine * self;
	GList* result = NULL;
	GList* _tmp0_ = NULL;
	self = (RygelSimpleMediaEngine*) base;
	_tmp0_ = self->priv->profiles;
	result = _tmp0_;
	return result;
}


static void rygel_simple_media_engine_real_get_resources_for_item_data_free (gpointer _data) {
	RygelSimpleMediaEngineGetResourcesForItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->object);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSimpleMediaEngineGetResourcesForItemData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_simple_media_engine_real_get_resources_for_item (RygelMediaEngine* base, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleMediaEngine * self;
	RygelSimpleMediaEngineGetResourcesForItemData* _data_;
	RygelSimpleMediaEngine* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaObject* _tmp2_ = NULL;
	self = (RygelSimpleMediaEngine*) base;
	_data_ = g_slice_new0 (RygelSimpleMediaEngineGetResourcesForItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_media_engine_real_get_resources_for_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_media_engine_real_get_resources_for_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = object;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->object);
	_data_->object = _tmp2_;
	rygel_simple_media_engine_real_get_resources_for_item_co (_data_);
}


static GeeList* rygel_simple_media_engine_real_get_resources_for_item_finish (RygelMediaEngine* base, GAsyncResult* _res_) {
	GeeList* result;
	RygelSimpleMediaEngineGetResourcesForItemData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean rygel_simple_media_engine_real_get_resources_for_item_co (RygelSimpleMediaEngineGetResourcesForItemData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->object;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _ ("Can only process file-based MediaObjects (MediaFileItems)");
		g_warning ("rygel-simple-media-engine.vala:57: %s", _data_->_tmp1_);
		_data_->result = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->object;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp2_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp2_) : NULL);
	_data_->item = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->item;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _data_->_tmp4_);
	_data_->source_uri = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->source_uri;
	_data_->_tmp7_ = FALSE;
	_data_->_tmp7_ = g_str_has_prefix (_data_->_tmp6_, "file://");
	if (!_data_->_tmp7_) {
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _ ("Can't process non-file URI %s");
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->source_uri;
		g_warning (_data_->_tmp8_, _data_->_tmp9_);
	}
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->source_uri;
	g_debug ("rygel-simple-media-engine.vala:70: get_resources_for_item (%s)", _data_->_tmp10_);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = gee_array_list_new (RYGEL_TYPE_MEDIA_RESOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_data_->resources = _data_->_tmp11_;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->item;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = rygel_media_file_item_get_primary_resource (_data_->_tmp12_);
	_data_->primary_res = _data_->_tmp13_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->primary_res;
	rygel_media_resource_set_dlna_operation (_data_->_tmp14_, GUPNP_DLNA_OPERATION_RANGE);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->primary_res;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->primary_res;
	_data_->_tmp17_ = 0;
	_data_->_tmp17_ = rygel_media_resource_get_dlna_flags (_data_->_tmp16_);
	_data_->_tmp18_ = 0;
	_data_->_tmp18_ = _data_->_tmp17_;
	rygel_media_resource_set_dlna_flags (_data_->_tmp16_, _data_->_tmp18_ | GUPNP_DLNA_FLAGS_CONNECTION_STALL);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->primary_res;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = rygel_media_resource_new_from_resource ("primary_http", _data_->_tmp19_);
	_data_->http_res = _data_->_tmp20_;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->http_res;
	rygel_media_resource_set_uri (_data_->_tmp21_, "");
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->resources;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->http_res;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp22_, _data_->_tmp23_);
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->resources;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->primary_res;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp24_, _data_->_tmp25_);
	_data_->result = (GeeList*) _data_->resources;
	_g_object_unref0 (_data_->http_res);
	_g_object_unref0 (_data_->primary_res);
	_g_free0 (_data_->source_uri);
	_g_object_unref0 (_data_->item);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->http_res);
	_g_object_unref0 (_data_->primary_res);
	_g_object_unref0 (_data_->resources);
	_g_free0 (_data_->source_uri);
	_g_object_unref0 (_data_->item);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static RygelDataSource* rygel_simple_media_engine_real_create_data_source_for_resource (RygelMediaEngine* base, RygelMediaObject* object, RygelMediaResource* resource, GError** error) {
	RygelSimpleMediaEngine * self;
	RygelDataSource* result = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	GThreadPool* _tmp2_ = NULL;
	RygelMediaObject* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	RygelSimpleDataSource* _tmp6_ = NULL;
	RygelDataSource* _tmp7_ = NULL;
	self = (RygelSimpleMediaEngine*) base;
	g_return_val_if_fail (object != NULL, NULL);
	g_return_val_if_fail (resource != NULL, NULL);
	_tmp0_ = object;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("Can only process file-based MediaObjects (MediaFileItems)");
		g_warning ("rygel-simple-media-engine.vala:96: %s", _tmp1_);
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->pool;
	_tmp3_ = object;
	_tmp4_ = rygel_media_object_get_primary_uri (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = rygel_simple_data_source_new (_tmp2_, _tmp5_);
	_tmp7_ = (RygelDataSource*) _tmp6_;
	_g_free0 (_tmp5_);
	result = _tmp7_;
	return result;
}


static RygelDataSource* rygel_simple_media_engine_real_create_data_source_for_uri (RygelMediaEngine* base, const gchar* uri, GError** error) {
	RygelSimpleMediaEngine * self;
	RygelDataSource* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	GThreadPool* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	RygelSimpleDataSource* _tmp5_ = NULL;
	self = (RygelSimpleMediaEngine*) base;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = g_str_has_prefix (_tmp0_, "file://");
	if (!_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = uri;
	g_debug ("rygel-simple-media-engine.vala:110: creating data source for %s", _tmp2_);
	_tmp3_ = self->priv->pool;
	_tmp4_ = uri;
	_tmp5_ = rygel_simple_data_source_new (_tmp3_, _tmp4_);
	result = (RygelDataSource*) _tmp5_;
	return result;
}


RygelSimpleMediaEngine* rygel_simple_media_engine_construct (GType object_type) {
	RygelSimpleMediaEngine * self = NULL;
	self = (RygelSimpleMediaEngine*) rygel_media_engine_construct (object_type);
	return self;
}


RygelSimpleMediaEngine* rygel_simple_media_engine_new (void) {
	return rygel_simple_media_engine_construct (RYGEL_TYPE_SIMPLE_MEDIA_ENGINE);
}


static void rygel_simple_media_engine_class_init (RygelSimpleMediaEngineClass * klass) {
	rygel_simple_media_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelSimpleMediaEnginePrivate));
	((GObjectClass *) klass)->constructed = rygel_simple_media_engine_real_constructed;
	((RygelMediaEngineClass *) klass)->get_dlna_profiles = rygel_simple_media_engine_real_get_dlna_profiles;
	((RygelMediaEngineClass *) klass)->get_resources_for_item = rygel_simple_media_engine_real_get_resources_for_item;
	((RygelMediaEngineClass *) klass)->get_resources_for_item_finish = rygel_simple_media_engine_real_get_resources_for_item_finish;
	((RygelMediaEngineClass *) klass)->create_data_source_for_resource = rygel_simple_media_engine_real_create_data_source_for_resource;
	((RygelMediaEngineClass *) klass)->create_data_source_for_uri = rygel_simple_media_engine_real_create_data_source_for_uri;
	G_OBJECT_CLASS (klass)->finalize = rygel_simple_media_engine_finalize;
}


static void rygel_simple_media_engine_instance_init (RygelSimpleMediaEngine * self) {
	self->priv = RYGEL_SIMPLE_MEDIA_ENGINE_GET_PRIVATE (self);
}


static void rygel_simple_media_engine_finalize (GObject* obj) {
	RygelSimpleMediaEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SIMPLE_MEDIA_ENGINE, RygelSimpleMediaEngine);
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->profiles);
	_g_thread_pool_free0 (self->priv->pool);
	G_OBJECT_CLASS (rygel_simple_media_engine_parent_class)->finalize (obj);
}


/**
 * The simple media engine does not use GStreamer or any other
 * multimedia framework. Therefore its capabilities are limited.
 *
 * It does not support transcoding - get_resources() returns null.
 * Also, its RygelSimpleDataSource does not support time-base seeking.
 */
GType rygel_simple_media_engine_get_type (void) {
	static volatile gsize rygel_simple_media_engine_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_simple_media_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSimpleMediaEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_simple_media_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSimpleMediaEngine), 0, (GInstanceInitFunc) rygel_simple_media_engine_instance_init, NULL };
		GType rygel_simple_media_engine_type_id;
		rygel_simple_media_engine_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ENGINE, "RygelSimpleMediaEngine", &g_define_type_info, 0);
		g_once_init_leave (&rygel_simple_media_engine_type_id__volatile, rygel_simple_media_engine_type_id);
	}
	return rygel_simple_media_engine_type_id__volatile;
}


RygelMediaEngine* module_get_instance (void) {
	RygelMediaEngine* result = NULL;
	RygelSimpleMediaEngine* _tmp0_ = NULL;
	_tmp0_ = rygel_simple_media_engine_new ();
	result = (RygelMediaEngine*) _tmp0_;
	return result;
}



