/* rygel-video-transcoder.c generated by valac 0.30.0, the Vala compiler
 * generated from rygel-video-transcoder.vala, do not modify */

/*
 * Copyright (C) 2011 Nokia Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Prasanna Modem <prasanna@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_GST_TRANSCODER (rygel_gst_transcoder_get_type ())
#define RYGEL_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder))
#define RYGEL_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))
#define RYGEL_IS_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_IS_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_GST_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))

typedef struct _RygelGstTranscoder RygelGstTranscoder;
typedef struct _RygelGstTranscoderClass RygelGstTranscoderClass;
typedef struct _RygelGstTranscoderPrivate RygelGstTranscoderPrivate;

#define RYGEL_TYPE_AUDIO_TRANSCODER (rygel_audio_transcoder_get_type ())
#define RYGEL_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder))
#define RYGEL_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))
#define RYGEL_IS_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_IS_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_AUDIO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))

typedef struct _RygelAudioTranscoder RygelAudioTranscoder;
typedef struct _RygelAudioTranscoderClass RygelAudioTranscoderClass;
typedef struct _RygelAudioTranscoderPrivate RygelAudioTranscoderPrivate;

#define RYGEL_TYPE_VIDEO_TRANSCODER (rygel_video_transcoder_get_type ())
#define RYGEL_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder))
#define RYGEL_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))
#define RYGEL_IS_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_IS_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_VIDEO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))

typedef struct _RygelVideoTranscoder RygelVideoTranscoder;
typedef struct _RygelVideoTranscoderClass RygelVideoTranscoderClass;
typedef struct _RygelVideoTranscoderPrivate RygelVideoTranscoderPrivate;
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelGstTranscoder {
	GObject parent_instance;
	RygelGstTranscoderPrivate * priv;
};

struct _RygelGstTranscoderClass {
	GObjectClass parent_class;
	RygelMediaResource* (*get_resource_for_item) (RygelGstTranscoder* self, RygelMediaFileItem* item);
	guint (*get_distance) (RygelGstTranscoder* self, RygelMediaFileItem* item);
	GstEncodingProfile* (*get_encoding_profile) (RygelGstTranscoder* self);
};

struct _RygelAudioTranscoder {
	RygelGstTranscoder parent_instance;
	RygelAudioTranscoderPrivate * priv;
	gint audio_bitrate;
	GstCaps* container_format;
	GstCaps* audio_codec_format;
};

struct _RygelAudioTranscoderClass {
	RygelGstTranscoderClass parent_class;
};

struct _RygelVideoTranscoder {
	RygelAudioTranscoder parent_instance;
	RygelVideoTranscoderPrivate * priv;
};

struct _RygelVideoTranscoderClass {
	RygelAudioTranscoderClass parent_class;
};

struct _RygelVideoTranscoderPrivate {
	gint video_bitrate;
	GstCaps* video_codec_format;
	GstCaps* video_restrictions;
};


static gpointer rygel_video_transcoder_parent_class = NULL;

GType rygel_gst_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_audio_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_video_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_VIDEO_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderPrivate))
enum  {
	RYGEL_VIDEO_TRANSCODER_DUMMY_PROPERTY
};
RygelVideoTranscoder* rygel_video_transcoder_construct (GType object_type, const gchar* name, const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, gint video_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* video_codec_caps, const gchar* extension, const gchar* restrictions);
RygelAudioTranscoder* rygel_audio_transcoder_construct_with_class (GType object_type, const gchar* name, const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* extension);
static guint rygel_video_transcoder_real_get_distance (RygelGstTranscoder* base, RygelMediaFileItem* item);
static GstEncodingProfile* rygel_video_transcoder_real_get_encoding_profile (RygelGstTranscoder* base);
GstEncodingProfile* rygel_gst_transcoder_get_encoding_profile (RygelGstTranscoder* self);
const gchar* rygel_gst_transcoder_get_preset (RygelGstTranscoder* self);
static RygelMediaResource* rygel_video_transcoder_real_get_resource_for_item (RygelGstTranscoder* base, RygelMediaFileItem* item);
RygelMediaResource* rygel_gst_transcoder_get_resource_for_item (RygelGstTranscoder* self, RygelMediaFileItem* item);
static void rygel_video_transcoder_finalize (GObject* obj);


RygelVideoTranscoder* rygel_video_transcoder_construct (GType object_type, const gchar* name, const gchar* content_type, const gchar* dlna_profile, gint audio_bitrate, gint video_bitrate, const gchar* container_caps, const gchar* audio_codec_caps, const gchar* video_codec_caps, const gchar* extension, const gchar* restrictions) {
	RygelVideoTranscoder * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	GstCaps* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (content_type != NULL, NULL);
	g_return_val_if_fail (dlna_profile != NULL, NULL);
	g_return_val_if_fail (container_caps != NULL, NULL);
	g_return_val_if_fail (audio_codec_caps != NULL, NULL);
	g_return_val_if_fail (video_codec_caps != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = content_type;
	_tmp2_ = dlna_profile;
	_tmp3_ = audio_bitrate;
	_tmp4_ = container_caps;
	_tmp5_ = audio_codec_caps;
	_tmp6_ = extension;
	self = (RygelVideoTranscoder*) rygel_audio_transcoder_construct_with_class (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	_tmp7_ = video_bitrate;
	self->priv->video_bitrate = _tmp7_;
	_tmp8_ = video_codec_caps;
	_tmp9_ = gst_caps_from_string (_tmp8_);
	_gst_caps_unref0 (self->priv->video_codec_format);
	self->priv->video_codec_format = _tmp9_;
	_tmp10_ = restrictions;
	if (_tmp10_ != NULL) {
		const gchar* _tmp11_ = NULL;
		GstCaps* _tmp12_ = NULL;
		_tmp11_ = restrictions;
		_tmp12_ = gst_caps_from_string (_tmp11_);
		_gst_caps_unref0 (self->priv->video_restrictions);
		self->priv->video_restrictions = _tmp12_;
	}
	return self;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static guint rygel_video_transcoder_real_get_distance (RygelGstTranscoder* base, RygelMediaFileItem* item) {
	RygelVideoTranscoder * self;
	guint result = 0U;
	RygelMediaFileItem* _tmp0_ = NULL;
	RygelVideoItem* video_item = NULL;
	RygelMediaFileItem* _tmp1_ = NULL;
	RygelVideoItem* _tmp2_ = NULL;
	guint distance = 0U;
	RygelVideoItem* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	self = (RygelVideoTranscoder*) base;
	g_return_val_if_fail (item != NULL, 0U);
	_tmp0_ = item;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_VIDEO_ITEM)) {
		result = G_MAXUINT;
		return result;
	}
	_tmp1_ = item;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp1_) : NULL);
	video_item = _tmp2_;
	distance = 0;
	_tmp3_ = video_item;
	_tmp4_ = rygel_audio_item_get_bitrate ((RygelAudioItem*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		guint _tmp6_ = 0U;
		RygelVideoItem* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp6_ = distance;
		_tmp7_ = video_item;
		_tmp8_ = rygel_audio_item_get_bitrate ((RygelAudioItem*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->video_bitrate;
		_tmp11_ = abs (_tmp9_ - _tmp10_);
		distance = _tmp6_ + _tmp11_;
	}
	result = distance;
	_g_object_unref0 (video_item);
	return result;
}


static GstEncodingProfile* rygel_video_transcoder_real_get_encoding_profile (RygelGstTranscoder* base) {
	RygelVideoTranscoder * self;
	GstEncodingProfile* result = NULL;
	GstEncodingContainerProfile* enc_container_profile = NULL;
	GstEncodingProfile* _tmp0_ = NULL;
	GstEncodingContainerProfile* _tmp1_ = NULL;
	GstEncodingVideoProfile* enc_video_profile = NULL;
	GstCaps* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GstCaps* _tmp5_ = NULL;
	GstEncodingVideoProfile* _tmp6_ = NULL;
	GstEncodingProfile* _tmp7_ = NULL;
	self = (RygelVideoTranscoder*) base;
	_tmp0_ = RYGEL_GST_TRANSCODER_CLASS (rygel_video_transcoder_parent_class)->get_encoding_profile ((RygelGstTranscoder*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder));
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gst_encoding_container_profile_get_type ()) ? ((GstEncodingContainerProfile*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	enc_container_profile = _tmp1_;
	_tmp2_ = self->priv->video_codec_format;
	_tmp3_ = rygel_gst_transcoder_get_preset ((RygelGstTranscoder*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->video_restrictions;
	_tmp6_ = gst_encoding_video_profile_new (_tmp2_, _tmp4_, _tmp5_, (guint) 1);
	enc_video_profile = _tmp6_;
	gst_encoding_profile_set_name ((GstEncodingProfile*) enc_video_profile, "video");
	_tmp7_ = _g_object_ref0 ((GstEncodingProfile*) enc_video_profile);
	gst_encoding_container_profile_add_profile (enc_container_profile, _tmp7_);
	result = (GstEncodingProfile*) enc_container_profile;
	_g_object_unref0 (enc_video_profile);
	return result;
}


static RygelMediaResource* rygel_video_transcoder_real_get_resource_for_item (RygelGstTranscoder* base, RygelMediaFileItem* item) {
	RygelVideoTranscoder * self;
	RygelMediaResource* result = NULL;
	RygelMediaResource* resource = NULL;
	RygelMediaFileItem* _tmp0_ = NULL;
	RygelMediaResource* _tmp1_ = NULL;
	RygelMediaResource* _tmp2_ = NULL;
	RygelVideoItem* video_item = NULL;
	RygelMediaFileItem* _tmp3_ = NULL;
	RygelVideoItem* _tmp4_ = NULL;
	RygelMediaResource* _tmp5_ = NULL;
	RygelVideoItem* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	RygelMediaResource* _tmp9_ = NULL;
	RygelVideoItem* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	RygelMediaResource* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	self = (RygelVideoTranscoder*) base;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = RYGEL_GST_TRANSCODER_CLASS (rygel_video_transcoder_parent_class)->get_resource_for_item ((RygelGstTranscoder*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder), _tmp0_);
	resource = _tmp1_;
	_tmp2_ = resource;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (resource);
		return result;
	}
	_tmp3_ = item;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp3_) : NULL);
	video_item = _tmp4_;
	_tmp5_ = resource;
	_tmp6_ = video_item;
	_tmp7_ = rygel_visual_item_get_width ((RygelVisualItem*) _tmp6_);
	_tmp8_ = _tmp7_;
	rygel_media_resource_set_width (_tmp5_, _tmp8_);
	_tmp9_ = resource;
	_tmp10_ = video_item;
	_tmp11_ = rygel_visual_item_get_height ((RygelVisualItem*) _tmp10_);
	_tmp12_ = _tmp11_;
	rygel_media_resource_set_height (_tmp9_, _tmp12_);
	_tmp13_ = resource;
	_tmp14_ = self->priv->video_bitrate;
	_tmp15_ = ((RygelAudioTranscoder*) self)->audio_bitrate;
	rygel_media_resource_set_bitrate (_tmp13_, ((_tmp14_ + _tmp15_) * 1000) / 8);
	result = resource;
	_g_object_unref0 (video_item);
	return result;
}


static void rygel_video_transcoder_class_init (RygelVideoTranscoderClass * klass) {
	rygel_video_transcoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelVideoTranscoderPrivate));
	((RygelGstTranscoderClass *) klass)->get_distance = rygel_video_transcoder_real_get_distance;
	((RygelGstTranscoderClass *) klass)->get_encoding_profile = rygel_video_transcoder_real_get_encoding_profile;
	((RygelGstTranscoderClass *) klass)->get_resource_for_item = rygel_video_transcoder_real_get_resource_for_item;
	G_OBJECT_CLASS (klass)->finalize = rygel_video_transcoder_finalize;
}


static void rygel_video_transcoder_instance_init (RygelVideoTranscoder * self) {
	self->priv = RYGEL_VIDEO_TRANSCODER_GET_PRIVATE (self);
	self->priv->video_restrictions = NULL;
}


static void rygel_video_transcoder_finalize (GObject* obj) {
	RygelVideoTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder);
	_gst_caps_unref0 (self->priv->video_codec_format);
	_gst_caps_unref0 (self->priv->video_restrictions);
	G_OBJECT_CLASS (rygel_video_transcoder_parent_class)->finalize (obj);
}


/**
 * Base class for all transcoders that handle video.
 */
GType rygel_video_transcoder_get_type (void) {
	static volatile gsize rygel_video_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoTranscoder), 0, (GInstanceInitFunc) rygel_video_transcoder_instance_init, NULL };
		GType rygel_video_transcoder_type_id;
		rygel_video_transcoder_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_TRANSCODER, "RygelVideoTranscoder", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_video_transcoder_type_id__volatile, rygel_video_transcoder_type_id);
	}
	return rygel_video_transcoder_type_id__volatile;
}



