/* rygel-visual-item.c generated by valac 0.27.1.26-9b1a5, the Vala compiler
 * generated from rygel-visual-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_THUMBNAILER (rygel_thumbnailer_get_type ())
#define RYGEL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailer))
#define RYGEL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))
#define RYGEL_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))

typedef struct _RygelThumbnailer RygelThumbnailer;
typedef struct _RygelThumbnailerClass RygelThumbnailerClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};



GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self, const gchar* uri);
GType rygel_thumbnailer_get_type (void) G_GNUC_CONST;
RygelThumbnailer* rygel_thumbnailer_get_default (void);
RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const gchar* uri, const gchar* mime_type, GError** error);
const gchar* rygel_media_file_item_get_mime_type (RygelMediaFileItem* self);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
void rygel_visual_item_set_visual_resource_properties (RygelVisualItem* self, RygelMediaResource* res);
gint rygel_visual_item_get_width (RygelVisualItem* self);
void rygel_media_resource_set_width (RygelMediaResource* self, gint value);
gint rygel_visual_item_get_height (RygelVisualItem* self);
void rygel_media_resource_set_height (RygelMediaResource* self, gint value);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
void rygel_media_resource_set_color_depth (RygelMediaResource* self, gint value);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self, RygelHTTPServer* http_server);
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self, const gchar* uri, GError** error);
RygelMediaResource* rygel_thumbnail_get_resource (RygelThumbnail* self, const gchar* protocol, gint index);
void rygel_media_resource_set_uri (RygelMediaResource* self, const gchar* value);
GeeList* rygel_media_object_get_resource_list (RygelMediaObject* self);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri);
gchar* rygel_http_server_get_protocol (RygelHTTPServer* self);
gchar* rygel_http_server_create_uri_for_object (RygelHTTPServer* self, RygelMediaObject* object, gint thumbnail_index, gint subtitle_index, const gchar* resource_name);
void rygel_visual_item_set_width (RygelVisualItem* self, gint value);
void rygel_visual_item_set_height (RygelVisualItem* self, gint value);
void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value);


void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self, const gchar* uri) {
	RygelThumbnailer* thumbnailer = NULL;
	RygelThumbnailer* _tmp0_ = NULL;
	RygelThumbnailer* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (uri != NULL);
	_tmp0_ = rygel_thumbnailer_get_default ();
	thumbnailer = _tmp0_;
	_tmp1_ = thumbnailer;
	if (_tmp1_ != NULL) {
		{
			RygelThumbnail* thumb = NULL;
			RygelThumbnailer* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			RygelThumbnail* _tmp6_ = NULL;
			GeeArrayList* _tmp7_ = NULL;
			GeeArrayList* _tmp8_ = NULL;
			RygelThumbnail* _tmp9_ = NULL;
			_tmp2_ = thumbnailer;
			_tmp3_ = uri;
			_tmp4_ = rygel_media_file_item_get_mime_type ((RygelMediaFileItem*) self);
			_tmp5_ = _tmp4_;
			_tmp6_ = rygel_thumbnailer_get_thumbnail (_tmp2_, _tmp3_, _tmp5_, &_inner_error_);
			thumb = _tmp6_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch21_g_error;
			}
			_tmp7_ = rygel_visual_item_get_thumbnails (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = thumb;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
			_rygel_icon_info_unref0 (thumb);
		}
		goto __finally21;
		__catch21_g_error:
		{
			GError* err = NULL;
			GError* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp10_ = err;
			_tmp11_ = _tmp10_->message;
			g_debug ("rygel-visual-item.vala:69: Failed to get thumbnail: %s", _tmp11_);
			_g_error_free0 (err);
		}
		__finally21:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (thumbnailer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (thumbnailer);
}


void rygel_visual_item_set_visual_resource_properties (RygelVisualItem* self, RygelMediaResource* res) {
	RygelMediaResource* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	RygelMediaResource* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	RygelMediaResource* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	_tmp1_ = rygel_visual_item_get_width (self);
	_tmp2_ = _tmp1_;
	rygel_media_resource_set_width (_tmp0_, _tmp2_);
	_tmp3_ = res;
	_tmp4_ = rygel_visual_item_get_height (self);
	_tmp5_ = _tmp4_;
	rygel_media_resource_set_height (_tmp3_, _tmp5_);
	_tmp6_ = res;
	_tmp7_ = rygel_visual_item_get_color_depth (self);
	_tmp8_ = _tmp7_;
	rygel_media_resource_set_color_depth (_tmp6_, _tmp8_);
}


void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self, RygelHTTPServer* http_server) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (http_server != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GeeArrayList* _tmp3_ = NULL;
				GeeArrayList* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = rygel_visual_item_get_thumbnails (self);
				_tmp4_ = _tmp3_;
				_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp2_ < _tmp6_)) {
					break;
				}
				_tmp7_ = rygel_media_file_item_get_place_holder ((RygelMediaFileItem*) self);
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					RygelThumbnail* thumbnail = NULL;
					GeeArrayList* _tmp9_ = NULL;
					GeeArrayList* _tmp10_ = NULL;
					gint _tmp11_ = 0;
					gpointer _tmp12_ = NULL;
					gchar* protocol = NULL;
					RygelMediaResource* thumb_res = NULL;
					RygelThumbnail* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					gint _tmp22_ = 0;
					RygelMediaResource* _tmp23_ = NULL;
					RygelMediaResource* _tmp24_ = NULL;
					RygelThumbnail* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					GeeList* _tmp27_ = NULL;
					GeeList* _tmp28_ = NULL;
					RygelMediaResource* _tmp29_ = NULL;
					RygelHTTPServer* _tmp30_ = NULL;
					RygelThumbnail* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					gboolean _tmp33_ = FALSE;
					_tmp9_ = rygel_visual_item_get_thumbnails (self);
					_tmp10_ = _tmp9_;
					_tmp11_ = i;
					_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
					thumbnail = (RygelThumbnail*) _tmp12_;
					{
						gchar* _tmp13_ = NULL;
						RygelThumbnail* _tmp14_ = NULL;
						const gchar* _tmp15_ = NULL;
						gchar* _tmp16_ = NULL;
						gchar* _tmp17_ = NULL;
						_tmp14_ = thumbnail;
						_tmp15_ = ((RygelIconInfo*) _tmp14_)->uri;
						_tmp16_ = rygel_media_object_get_protocol_for_uri ((RygelMediaObject*) self, _tmp15_, &_inner_error_);
						_tmp13_ = _tmp16_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							goto __catch22_g_error;
						}
						_tmp17_ = _tmp13_;
						_tmp13_ = NULL;
						_g_free0 (protocol);
						protocol = _tmp17_;
						_g_free0 (_tmp13_);
					}
					goto __finally22;
					__catch22_g_error:
					{
						GError* e = NULL;
						RygelThumbnail* _tmp18_ = NULL;
						const gchar* _tmp19_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp18_ = thumbnail;
						_tmp19_ = ((RygelIconInfo*) _tmp18_)->uri;
						g_message ("rygel-visual-item.vala:90: Could not determine protocol for URI %s", _tmp19_);
						_g_error_free0 (e);
						_g_free0 (protocol);
						_rygel_icon_info_unref0 (thumbnail);
						continue;
					}
					__finally22:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (protocol);
						_rygel_icon_info_unref0 (thumbnail);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp20_ = thumbnail;
					_tmp21_ = protocol;
					_tmp22_ = i;
					_tmp23_ = rygel_thumbnail_get_resource (_tmp20_, _tmp21_, _tmp22_);
					thumb_res = _tmp23_;
					_tmp24_ = thumb_res;
					_tmp25_ = thumbnail;
					_tmp26_ = ((RygelIconInfo*) _tmp25_)->uri;
					rygel_media_resource_set_uri (_tmp24_, _tmp26_);
					_tmp27_ = rygel_media_object_get_resource_list ((RygelMediaObject*) self);
					_tmp28_ = _tmp27_;
					_tmp29_ = thumb_res;
					gee_collection_add ((GeeCollection*) _tmp28_, _tmp29_);
					_g_object_unref0 (_tmp28_);
					_tmp30_ = http_server;
					_tmp31_ = thumbnail;
					_tmp32_ = ((RygelIconInfo*) _tmp31_)->uri;
					_tmp33_ = rygel_http_server_need_proxy (_tmp30_, _tmp32_);
					if (_tmp33_) {
						RygelMediaResource* http_thumb_res = NULL;
						RygelThumbnail* _tmp34_ = NULL;
						RygelHTTPServer* _tmp35_ = NULL;
						gchar* _tmp36_ = NULL;
						gchar* _tmp37_ = NULL;
						gint _tmp38_ = 0;
						RygelMediaResource* _tmp39_ = NULL;
						RygelMediaResource* _tmp40_ = NULL;
						gint index = 0;
						GeeArrayList* _tmp41_ = NULL;
						GeeArrayList* _tmp42_ = NULL;
						RygelThumbnail* _tmp43_ = NULL;
						gint _tmp44_ = 0;
						RygelMediaResource* _tmp45_ = NULL;
						RygelHTTPServer* _tmp46_ = NULL;
						gint _tmp47_ = 0;
						gchar* _tmp48_ = NULL;
						gchar* _tmp49_ = NULL;
						GeeList* _tmp50_ = NULL;
						GeeList* _tmp51_ = NULL;
						RygelMediaResource* _tmp52_ = NULL;
						_tmp34_ = thumbnail;
						_tmp35_ = http_server;
						_tmp36_ = rygel_http_server_get_protocol (_tmp35_);
						_tmp37_ = _tmp36_;
						_tmp38_ = i;
						_tmp39_ = rygel_thumbnail_get_resource (_tmp34_, _tmp37_, _tmp38_);
						_tmp40_ = _tmp39_;
						_g_free0 (_tmp37_);
						http_thumb_res = _tmp40_;
						_tmp41_ = rygel_visual_item_get_thumbnails (self);
						_tmp42_ = _tmp41_;
						_tmp43_ = thumbnail;
						_tmp44_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp42_, _tmp43_);
						index = _tmp44_;
						_tmp45_ = http_thumb_res;
						_tmp46_ = http_server;
						_tmp47_ = index;
						_tmp48_ = rygel_http_server_create_uri_for_object (_tmp46_, (RygelMediaObject*) self, _tmp47_, -1, NULL);
						_tmp49_ = _tmp48_;
						rygel_media_resource_set_uri (_tmp45_, _tmp49_);
						_g_free0 (_tmp49_);
						_tmp50_ = rygel_media_object_get_resource_list ((RygelMediaObject*) self);
						_tmp51_ = _tmp50_;
						_tmp52_ = http_thumb_res;
						gee_collection_add ((GeeCollection*) _tmp51_, _tmp52_);
						_g_object_unref0 (_tmp51_);
						_g_object_unref0 (http_thumb_res);
					}
					_g_object_unref0 (thumb_res);
					_g_free0 (protocol);
					_rygel_icon_info_unref0 (thumbnail);
				}
			}
		}
	}
}


gint rygel_visual_item_get_width (RygelVisualItem* self) {
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_width (self);
}


void rygel_visual_item_set_width (RygelVisualItem* self, gint value) {
	g_return_if_fail (self != NULL);
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_width (self, value);
}


gint rygel_visual_item_get_height (RygelVisualItem* self) {
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_height (self);
}


void rygel_visual_item_set_height (RygelVisualItem* self, gint value) {
	g_return_if_fail (self != NULL);
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_height (self, value);
}


gint rygel_visual_item_get_color_depth (RygelVisualItem* self) {
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_color_depth (self);
}


void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value) {
	g_return_if_fail (self != NULL);
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_color_depth (self, value);
}


GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_thumbnails (self);
}


void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value) {
	g_return_if_fail (self != NULL);
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_thumbnails (self, value);
}


static void rygel_visual_item_base_init (RygelVisualItemIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		     * The width of the source content (this.uri) in pixels.
		     * A value of -1 means that the width is unknown
		     */
		g_object_interface_install_property (iface, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		     * The height of the source content (this.uri) in pixels.
		     * A value of -1 means that the height is unknown
		     */
		g_object_interface_install_property (iface, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		     * The number of bits per pixel in the video or image resource (this.uri).
		     * A value of -1 means that the color depth is unknown
		     */
		g_object_interface_install_property (iface, g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		     * Thumbnail pictures to represent the video or image resource.
		     */
		g_object_interface_install_property (iface, g_param_spec_object ("thumbnails", "thumbnails", "thumbnails", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * An interface representing visual properties of an item stored in a file.
 */
GType rygel_visual_item_get_type (void) {
	static volatile gsize rygel_visual_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_visual_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVisualItemIface), (GBaseInitFunc) rygel_visual_item_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_visual_item_type_id;
		rygel_visual_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelVisualItem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_visual_item_type_id, RYGEL_TYPE_MEDIA_FILE_ITEM);
		g_once_init_leave (&rygel_visual_item_type_id__volatile, rygel_visual_item_type_id);
	}
	return rygel_visual_item_type_id__volatile;
}



