/* rygel-gst-utils.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-gst-utils.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <glib/gi18n-lib.h>
#include <gst/pbutils/pbutils.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_GST_UTILS (rygel_gst_utils_get_type ())
#define RYGEL_GST_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_UTILS, RygelGstUtils))
#define RYGEL_GST_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_UTILS, RygelGstUtilsClass))
#define RYGEL_IS_GST_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_UTILS))
#define RYGEL_IS_GST_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_UTILS))
#define RYGEL_GST_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_UTILS, RygelGstUtilsClass))

typedef struct _RygelGstUtils RygelGstUtils;
typedef struct _RygelGstUtilsClass RygelGstUtilsClass;
typedef struct _RygelGstUtilsPrivate RygelGstUtilsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelParamSpecGstUtils RygelParamSpecGstUtils;

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()
struct _RygelGstUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelGstUtilsPrivate * priv;
};

struct _RygelGstUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (RygelGstUtils *self);
};

struct _RygelParamSpecGstUtils {
	GParamSpec parent_instance;
};


static gpointer rygel_gst_utils_parent_class = NULL;

GQuark rygel_gst_error_quark (void);
gpointer rygel_gst_utils_ref (gpointer instance);
void rygel_gst_utils_unref (gpointer instance);
GParamSpec* rygel_param_spec_gst_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_gst_utils (GValue* value, gpointer v_object);
void rygel_value_take_gst_utils (GValue* value, gpointer v_object);
gpointer rygel_value_get_gst_utils (const GValue* value);
GType rygel_gst_utils_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_GST_UTILS_DUMMY_PROPERTY
};
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri);
static inline void _dynamic_set_blocksize5 (GstElement* obj, glong value);
static inline void _dynamic_set_tcp_timeout6 (GstElement* obj, gint64 value);
void rygel_gst_utils_dump_encoding_profile (GstEncodingProfile* profile, gint indent);
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
static gboolean rygel_gst_utils_need_rtp_depayloader (GstCaps* caps);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
RygelGstUtils* rygel_gst_utils_construct (GType object_type);
static void rygel_gst_utils_finalize (RygelGstUtils* obj);


GQuark rygel_gst_error_quark (void) {
	return g_quark_from_static_string ("rygel_gst_error-quark");
}


GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error) {
	GstElement* result = NULL;
	GstElement* element = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 33 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_return_val_if_fail (factoryname != NULL, NULL);
#line 36 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp0_ = factoryname;
#line 36 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp1_ = name;
#line 36 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp2_ = gst_element_factory_make (_tmp0_, _tmp1_);
#line 36 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (_tmp2_ != NULL) {
#line 36 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		g_object_ref_sink (_tmp2_);
#line 128 "rygel-gst-utils.c"
	}
#line 36 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	element = _tmp2_;
#line 37 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp3_ = element;
#line 37 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (_tmp3_ == NULL) {
#line 136 "rygel-gst-utils.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp4_ = _ ("Required element %s missing");
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp5_ = factoryname;
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp6_ = g_error_new (RYGEL_GST_ERROR, RYGEL_GST_ERROR_MISSING_PLUGIN, _tmp4_, _tmp5_);
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_inner_error_ = _tmp6_;
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		g_propagate_error (error, _inner_error_);
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_g_object_unref0 (element);
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		return NULL;
#line 154 "rygel-gst-utils.c"
	}
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	result = element;
#line 43 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	return result;
#line 160 "rygel-gst-utils.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 173 "rygel-gst-utils.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 204 "rygel-gst-utils.c"
				goto __catch3_g_regex_error;
			}
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 213 "rygel-gst-utils.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 229 "rygel-gst-utils.c"
				goto __catch3_g_regex_error;
			}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 240 "rygel-gst-utils.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 254 "rygel-gst-utils.c"
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 268 "rygel-gst-utils.c"
	}
	__finally3:
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return NULL;
#line 279 "rygel-gst-utils.c"
	}
}


static inline void _dynamic_set_blocksize5 (GstElement* obj, glong value) {
#line 61 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_object_set (obj, "blocksize", value, NULL);
#line 287 "rygel-gst-utils.c"
}


static inline void _dynamic_set_tcp_timeout6 (GstElement* obj, gint64 value) {
#line 67 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_object_set (obj, "tcp-timeout", value, NULL);
#line 294 "rygel-gst-utils.c"
}


GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri) {
	GstElement* result = NULL;
	GError * _inner_error_ = NULL;
#line 46 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 303 "rygel-gst-utils.c"
	{
		GstElement* src = NULL;
		const gchar* _tmp0_ = NULL;
		gboolean _tmp1_ = FALSE;
		GstElement* _tmp12_ = NULL;
		GObjectClass* _tmp13_ = NULL;
		GParamSpec* _tmp14_ = NULL;
		GstElement* _tmp16_ = NULL;
		GObjectClass* _tmp17_ = NULL;
		GParamSpec* _tmp18_ = NULL;
#line 50 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp0_ = uri;
#line 50 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp1_ = g_str_has_prefix (_tmp0_, "gst-launch://");
#line 50 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		if (_tmp1_) {
#line 320 "rygel-gst-utils.c"
			gchar* description = NULL;
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			GstElement* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			GstElement* _tmp6_ = NULL;
			GstElement* _tmp7_ = NULL;
#line 51 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp2_ = uri;
#line 51 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp3_ = string_replace (_tmp2_, "gst-launch://", "");
#line 51 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			description = _tmp3_;
#line 53 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp5_ = description;
#line 53 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp6_ = gst_parse_bin_from_description_full (_tmp5_, TRUE, NULL, GST_PARSE_FLAG_NONE, &_inner_error_);
#line 53 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			g_object_ref_sink (_tmp6_);
#line 53 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp4_ = _tmp6_;
#line 53 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 53 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
				_g_free0 (description);
#line 53 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
				_g_object_unref0 (src);
#line 348 "rygel-gst-utils.c"
				goto __catch2_g_error;
			}
#line 53 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp7_ = _tmp4_;
#line 53 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp4_ = NULL;
#line 53 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			g_object_ref_sink (_tmp7_);
#line 53 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_g_object_unref0 (src);
#line 53 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			src = _tmp7_;
#line 50 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_g_object_unref0 (_tmp4_);
#line 50 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_g_free0 (description);
#line 365 "rygel-gst-utils.c"
		} else {
			GstElement* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			GstElement* _tmp10_ = NULL;
			GstElement* _tmp11_ = NULL;
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp9_ = uri;
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp10_ = gst_element_make_from_uri (GST_URI_SRC, _tmp9_, NULL, &_inner_error_);
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			g_object_ref_sink (_tmp10_);
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp8_ = _tmp10_;
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
				_g_object_unref0 (src);
#line 383 "rygel-gst-utils.c"
				goto __catch2_g_error;
			}
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp11_ = _tmp8_;
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp8_ = NULL;
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			g_object_ref_sink (_tmp11_);
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_g_object_unref0 (src);
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			src = _tmp11_;
#line 50 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_g_object_unref0 (_tmp8_);
#line 398 "rygel-gst-utils.c"
		}
#line 58 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp12_ = src;
#line 58 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp13_ = G_OBJECT_GET_CLASS ((GObject*) _tmp12_);
#line 58 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp14_ = g_object_class_find_property (_tmp13_, "blocksize");
#line 58 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		if (_tmp14_ != NULL) {
#line 408 "rygel-gst-utils.c"
			GstElement* _tmp15_ = NULL;
#line 61 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp15_ = src;
#line 61 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_dynamic_set_blocksize5 (_tmp15_, (glong) 65536);
#line 414 "rygel-gst-utils.c"
		}
#line 64 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp16_ = src;
#line 64 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp17_ = G_OBJECT_GET_CLASS ((GObject*) _tmp16_);
#line 64 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp18_ = g_object_class_find_property (_tmp17_, "tcp-timeout");
#line 64 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		if (_tmp18_ != NULL) {
#line 424 "rygel-gst-utils.c"
			GstElement* _tmp19_ = NULL;
#line 67 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp19_ = src;
#line 67 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_dynamic_set_tcp_timeout6 (_tmp19_, (gint64) 60000000);
#line 430 "rygel-gst-utils.c"
		}
#line 70 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		result = src;
#line 70 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		return result;
#line 436 "rygel-gst-utils.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_error_ = _inner_error_;
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_inner_error_ = NULL;
#line 72 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		result = NULL;
#line 72 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_g_error_free0 (_error_);
#line 72 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		return result;
#line 452 "rygel-gst-utils.c"
	}
	__finally2:
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_clear_error (&_inner_error_);
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	return NULL;
#line 461 "rygel-gst-utils.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	return self ? g_object_ref (self) : NULL;
#line 468 "rygel-gst-utils.c"
}


void rygel_gst_utils_dump_encoding_profile (GstEncodingProfile* profile, gint indent) {
	gchar* indent_s = NULL;
	gint _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GstEncodingProfile* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GstEncodingProfile* _tmp10_ = NULL;
	GstCaps* _tmp11_ = NULL;
	GstCaps* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GstEncodingProfile* _tmp15_ = NULL;
	GstCaps* _tmp16_ = NULL;
	GstCaps* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GstEncodingProfile* _tmp27_ = NULL;
#line 76 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_return_if_fail (profile != NULL);
#line 78 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp0_ = indent;
#line 78 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp1_ = g_strnfill ((gsize) _tmp0_, ' ');
#line 78 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	indent_s = _tmp1_;
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp2_ = indent_s;
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp3_ = g_strconcat (_tmp2_, "%s:", NULL);
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp4_ = _tmp3_;
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp5_ = profile;
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp6_ = gst_encoding_profile_get_name (_tmp5_);
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_debug (_tmp4_, _tmp6_);
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_g_free0 (_tmp4_);
#line 80 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp7_ = indent_s;
#line 80 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp8_ = g_strconcat (_tmp7_, "  Format: %s", NULL);
#line 80 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp9_ = _tmp8_;
#line 80 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp10_ = profile;
#line 80 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp11_ = gst_encoding_profile_get_format (_tmp10_);
#line 80 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp12_ = _tmp11_;
#line 80 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp13_ = gst_caps_to_string (_tmp12_);
#line 80 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp14_ = _tmp13_;
#line 80 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_debug (_tmp9_, _tmp14_);
#line 80 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_g_free0 (_tmp14_);
#line 80 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_gst_caps_unref0 (_tmp12_);
#line 80 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_g_free0 (_tmp9_);
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp15_ = profile;
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp16_ = gst_encoding_profile_get_restriction (_tmp15_);
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp17_ = _tmp16_;
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp18_ = _tmp17_ != NULL;
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_gst_caps_unref0 (_tmp17_);
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (_tmp18_) {
#line 552 "rygel-gst-utils.c"
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		GstEncodingProfile* _tmp22_ = NULL;
		GstCaps* _tmp23_ = NULL;
		GstCaps* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp19_ = indent_s;
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp20_ = g_strconcat (_tmp19_, "  Restriction: %s", NULL);
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp21_ = _tmp20_;
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp22_ = profile;
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp23_ = gst_encoding_profile_get_restriction (_tmp22_);
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp24_ = _tmp23_;
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp25_ = gst_caps_to_string (_tmp24_);
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp26_ = _tmp25_;
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		g_debug (_tmp21_, _tmp26_);
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_g_free0 (_tmp26_);
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_gst_caps_unref0 (_tmp24_);
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_g_free0 (_tmp21_);
#line 585 "rygel-gst-utils.c"
	}
#line 86 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp27_ = profile;
#line 86 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, gst_encoding_container_profile_get_type ())) {
#line 591 "rygel-gst-utils.c"
		GstEncodingContainerProfile* container = NULL;
		GstEncodingProfile* _tmp28_ = NULL;
		GstEncodingContainerProfile* _tmp29_ = NULL;
		GstEncodingContainerProfile* _tmp30_ = NULL;
		GList* _tmp31_ = NULL;
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp28_ = profile;
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, gst_encoding_container_profile_get_type ()) ? ((GstEncodingContainerProfile*) _tmp28_) : NULL);
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		container = _tmp29_;
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp30_ = container;
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp31_ = gst_encoding_container_profile_get_profiles (_tmp30_);
#line 607 "rygel-gst-utils.c"
		{
			GList* subprofile_collection = NULL;
			GList* subprofile_it = NULL;
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			subprofile_collection = _tmp31_;
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			for (subprofile_it = subprofile_collection; subprofile_it != NULL; subprofile_it = subprofile_it->next) {
#line 615 "rygel-gst-utils.c"
				GstEncodingProfile* _tmp32_ = NULL;
				GstEncodingProfile* subprofile = NULL;
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
				_tmp32_ = _g_object_ref0 ((GstEncodingProfile*) subprofile_it->data);
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
				subprofile = _tmp32_;
#line 622 "rygel-gst-utils.c"
				{
					GstEncodingProfile* _tmp33_ = NULL;
					gint _tmp34_ = 0;
#line 89 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
					_tmp33_ = subprofile;
#line 89 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
					_tmp34_ = indent;
#line 89 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
					rygel_gst_utils_dump_encoding_profile (_tmp33_, _tmp34_ + 4);
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
					_g_object_unref0 (subprofile);
#line 634 "rygel-gst-utils.c"
				}
			}
		}
#line 86 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_g_object_unref0 (container);
#line 640 "rygel-gst-utils.c"
	}
#line 76 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_g_free0 (indent_s);
#line 644 "rygel-gst-utils.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 651 "rygel-gst-utils.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_list_free (self);
#line 660 "rygel-gst-utils.c"
}


GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps) {
	GstElement* result = NULL;
	GstCaps* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GList* features = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GstCaps* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	gconstpointer _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
#line 94 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_return_val_if_fail (caps != NULL, NULL);
#line 95 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp0_ = caps;
#line 95 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp1_ = rygel_gst_utils_need_rtp_depayloader (_tmp0_);
#line 95 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (!_tmp1_) {
#line 96 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		result = NULL;
#line 96 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		return result;
#line 691 "rygel-gst-utils.c"
	}
#line 99 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp2_ = gst_element_factory_list_get_elements ((GstElementFactoryListType) GST_ELEMENT_FACTORY_TYPE_DEPAYLOADER, GST_RANK_NONE);
#line 99 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	features = _tmp2_;
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp3_ = features;
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp4_ = caps;
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp5_ = gst_element_factory_list_filter (_tmp3_, _tmp4_, GST_PAD_SINK, FALSE);
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	__g_list_free__g_object_unref0_0 (features);
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	features = _tmp5_;
#line 106 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp6_ = features;
#line 106 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (_tmp6_ == NULL) {
#line 107 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		result = NULL;
#line 107 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		__g_list_free__g_object_unref0_0 (features);
#line 107 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		return result;
#line 717 "rygel-gst-utils.c"
	}
#line 112 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp7_ = features;
#line 112 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp8_ = _tmp7_->data;
#line 112 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp9_ = gst_object_get_name ((GstObject*) ((GstElementFactory*) _tmp8_));
#line 112 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp10_ = _tmp9_;
#line 112 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp11_ = g_strcmp0 (_tmp10_, "rtpdepay") == 0;
#line 112 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_g_free0 (_tmp10_);
#line 112 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (_tmp11_) {
#line 733 "rygel-gst-utils.c"
		GList* _tmp12_ = NULL;
		GList* _tmp13_ = NULL;
#line 113 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp12_ = features;
#line 113 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp13_ = _tmp12_->next;
#line 113 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		if (_tmp13_ != NULL) {
#line 742 "rygel-gst-utils.c"
			GList* _tmp14_ = NULL;
			GList* _tmp15_ = NULL;
			gconstpointer _tmp16_ = NULL;
			GstElement* _tmp17_ = NULL;
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp14_ = features;
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp15_ = _tmp14_->next;
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp16_ = _tmp15_->data;
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			_tmp17_ = gst_element_factory_create ((GstElementFactory*) _tmp16_, NULL);
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			if (_tmp17_ != NULL) {
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
				g_object_ref_sink (_tmp17_);
#line 759 "rygel-gst-utils.c"
			}
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			result = _tmp17_;
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			__g_list_free__g_object_unref0_0 (features);
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			return result;
#line 767 "rygel-gst-utils.c"
		}
#line 117 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		result = NULL;
#line 117 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		__g_list_free__g_object_unref0_0 (features);
#line 117 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		return result;
#line 775 "rygel-gst-utils.c"
	} else {
		GList* _tmp18_ = NULL;
		gconstpointer _tmp19_ = NULL;
		GstElement* _tmp20_ = NULL;
#line 119 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp18_ = features;
#line 119 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp19_ = _tmp18_->data;
#line 119 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		_tmp20_ = gst_element_factory_create ((GstElementFactory*) _tmp19_, NULL);
#line 119 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		if (_tmp20_ != NULL) {
#line 119 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			g_object_ref_sink (_tmp20_);
#line 790 "rygel-gst-utils.c"
		}
#line 119 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		result = _tmp20_;
#line 119 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		__g_list_free__g_object_unref0_0 (features);
#line 119 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		return result;
#line 798 "rygel-gst-utils.c"
	}
#line 94 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	__g_list_free__g_object_unref0_0 (features);
#line 802 "rygel-gst-utils.c"
}


static gboolean rygel_gst_utils_need_rtp_depayloader (GstCaps* caps) {
	gboolean result = FALSE;
	GstStructure* structure = NULL;
	GstCaps* _tmp0_ = NULL;
	GstStructure* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 123 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_return_val_if_fail (caps != NULL, FALSE);
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp0_ = caps;
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp1_ = gst_caps_get_structure (_tmp0_, (guint) 0);
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	structure = _tmp1_;
#line 126 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	_tmp2_ = gst_structure_get_name (structure);
#line 126 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	result = g_strcmp0 (_tmp2_, "application/x-rtp") == 0;
#line 126 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	return result;
#line 826 "rygel-gst-utils.c"
}


RygelGstUtils* rygel_gst_utils_construct (GType object_type) {
	RygelGstUtils* self = NULL;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	self = (RygelGstUtils*) g_type_create_instance (object_type);
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	return self;
#line 836 "rygel-gst-utils.c"
}


static void rygel_value_gst_utils_init (GValue* value) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	value->data[0].v_pointer = NULL;
#line 843 "rygel-gst-utils.c"
}


static void rygel_value_gst_utils_free_value (GValue* value) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (value->data[0].v_pointer) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		rygel_gst_utils_unref (value->data[0].v_pointer);
#line 852 "rygel-gst-utils.c"
	}
}


static void rygel_value_gst_utils_copy_value (const GValue* src_value, GValue* dest_value) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (src_value->data[0].v_pointer) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		dest_value->data[0].v_pointer = rygel_gst_utils_ref (src_value->data[0].v_pointer);
#line 862 "rygel-gst-utils.c"
	} else {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 866 "rygel-gst-utils.c"
	}
}


static gpointer rygel_value_gst_utils_peek_pointer (const GValue* value) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	return value->data[0].v_pointer;
#line 874 "rygel-gst-utils.c"
}


static gchar* rygel_value_gst_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (collect_values[0].v_pointer) {
#line 881 "rygel-gst-utils.c"
		RygelGstUtils* object;
		object = collect_values[0].v_pointer;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 888 "rygel-gst-utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 892 "rygel-gst-utils.c"
		}
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		value->data[0].v_pointer = rygel_gst_utils_ref (object);
#line 896 "rygel-gst-utils.c"
	} else {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		value->data[0].v_pointer = NULL;
#line 900 "rygel-gst-utils.c"
	}
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	return NULL;
#line 904 "rygel-gst-utils.c"
}


static gchar* rygel_value_gst_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelGstUtils** object_p;
	object_p = collect_values[0].v_pointer;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (!object_p) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 915 "rygel-gst-utils.c"
	}
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (!value->data[0].v_pointer) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		*object_p = NULL;
#line 921 "rygel-gst-utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		*object_p = value->data[0].v_pointer;
#line 925 "rygel-gst-utils.c"
	} else {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		*object_p = rygel_gst_utils_ref (value->data[0].v_pointer);
#line 929 "rygel-gst-utils.c"
	}
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	return NULL;
#line 933 "rygel-gst-utils.c"
}


GParamSpec* rygel_param_spec_gst_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecGstUtils* spec;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_GST_UTILS), NULL);
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	return G_PARAM_SPEC (spec);
#line 947 "rygel-gst-utils.c"
}


gpointer rygel_value_get_gst_utils (const GValue* value) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS), NULL);
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	return value->data[0].v_pointer;
#line 956 "rygel-gst-utils.c"
}


void rygel_value_set_gst_utils (GValue* value, gpointer v_object) {
	RygelGstUtils* old;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS));
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	old = value->data[0].v_pointer;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (v_object) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_GST_UTILS));
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		value->data[0].v_pointer = v_object;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		rygel_gst_utils_ref (value->data[0].v_pointer);
#line 976 "rygel-gst-utils.c"
	} else {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		value->data[0].v_pointer = NULL;
#line 980 "rygel-gst-utils.c"
	}
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (old) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		rygel_gst_utils_unref (old);
#line 986 "rygel-gst-utils.c"
	}
}


void rygel_value_take_gst_utils (GValue* value, gpointer v_object) {
	RygelGstUtils* old;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_GST_UTILS));
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	old = value->data[0].v_pointer;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (v_object) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_GST_UTILS));
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		value->data[0].v_pointer = v_object;
#line 1005 "rygel-gst-utils.c"
	} else {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		value->data[0].v_pointer = NULL;
#line 1009 "rygel-gst-utils.c"
	}
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (old) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		rygel_gst_utils_unref (old);
#line 1015 "rygel-gst-utils.c"
	}
}


static void rygel_gst_utils_class_init (RygelGstUtilsClass * klass) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	rygel_gst_utils_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	((RygelGstUtilsClass *) klass)->finalize = rygel_gst_utils_finalize;
#line 1025 "rygel-gst-utils.c"
}


static void rygel_gst_utils_instance_init (RygelGstUtils * self) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	self->ref_count = 1;
#line 1032 "rygel-gst-utils.c"
}


static void rygel_gst_utils_finalize (RygelGstUtils* obj) {
	RygelGstUtils * self;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_UTILS, RygelGstUtils);
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_signal_handlers_destroy (self);
#line 1042 "rygel-gst-utils.c"
}


GType rygel_gst_utils_get_type (void) {
	static volatile gsize rygel_gst_utils_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_gst_utils_init, rygel_value_gst_utils_free_value, rygel_value_gst_utils_copy_value, rygel_value_gst_utils_peek_pointer, "p", rygel_value_gst_utils_collect_value, "p", rygel_value_gst_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstUtils), 0, (GInstanceInitFunc) rygel_gst_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_gst_utils_type_id;
		rygel_gst_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelGstUtils", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_gst_utils_type_id__volatile, rygel_gst_utils_type_id);
	}
	return rygel_gst_utils_type_id__volatile;
}


gpointer rygel_gst_utils_ref (gpointer instance) {
	RygelGstUtils* self;
	self = instance;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	return instance;
#line 1067 "rygel-gst-utils.c"
}


void rygel_gst_utils_unref (gpointer instance) {
	RygelGstUtils* self;
	self = instance;
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		RYGEL_GST_UTILS_GET_CLASS (self)->finalize (self);
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1080 "rygel-gst-utils.c"
	}
}



