/* rygel-writable-container.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-writable-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010-2012 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelWritableContainerAddReferenceData RygelWritableContainerAddReferenceData;

typedef enum  {
	RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED = 602
} RygelWritableContainerError;
#define RYGEL_WRITABLE_CONTAINER_ERROR rygel_writable_container_error_quark ()
struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaFileItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_container) (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_reference) (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*add_reference_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_container) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelWritableContainerAddReferenceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelWritableContainer* self;
	RygelMediaObject* object;
	GCancellable* cancellable;
	gchar* result;
	GError* _tmp0_;
	GError * _inner_error_;
};



GQuark rygel_writable_container_error_quark (void);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
gboolean rygel_writable_container_can_create (RygelWritableContainer* self, const gchar* upnp_class);
GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self);
void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaFileItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
void rygel_writable_container_add_container (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_container_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_writable_container_real_add_reference_data_free (gpointer _data);
static void rygel_writable_container_real_add_reference (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_reference (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* rygel_writable_container_add_reference_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_writable_container_real_add_reference_co (RygelWritableContainerAddReferenceData* _data_);
void rygel_writable_container_remove_item (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_remove_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
void rygel_writable_container_remove_container (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_remove_container_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
#define RYGEL_WRITABLE_CONTAINER_WRITABLE_SCHEME "rygel-writable://"
void rygel_writable_container_set_create_classes (RygelWritableContainer* self, GeeArrayList* value);


GQuark rygel_writable_container_error_quark (void) {
	return g_quark_from_static_string ("rygel_writable_container_error-quark");
}


/**
     * Check if this container can contain an item with the given upnp class,
     * meaning that rygel_writable_container_add_item() should succeed.
     *
     * @param upnp_class The upnp class of an item to check
     *
     * @return true if it can, false, if not.
     */
gboolean rygel_writable_container_can_create (RygelWritableContainer* self, const gchar* upnp_class) {
	gboolean result = FALSE;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	g_return_val_if_fail (upnp_class != NULL, FALSE);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_tmp0_ = rygel_writable_container_get_create_classes (self);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_tmp1_ = _tmp0_;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_tmp2_ = upnp_class;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_tmp3_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp1_, _tmp2_);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	result = _tmp3_;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	return result;
#line 183 "rygel-writable-container.c"
}


void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaFileItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->add_item (self, item, cancellable, _callback_, _user_data_);
#line 190 "rygel-writable-container.c"
}


void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->add_item_finish (self, _res_, error);
#line 197 "rygel-writable-container.c"
}


void rygel_writable_container_add_container (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->add_container (self, container, cancellable, _callback_, _user_data_);
#line 204 "rygel-writable-container.c"
}


void rygel_writable_container_add_container_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->add_container_finish (self, _res_, error);
#line 211 "rygel-writable-container.c"
}


static void rygel_writable_container_real_add_reference_data_free (gpointer _data) {
	RygelWritableContainerAddReferenceData* _data_;
	_data_ = _data;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_g_object_unref0 (_data_->object);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_g_free0 (_data_->result);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_g_object_unref0 (_data_->self);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	g_slice_free (RygelWritableContainerAddReferenceData, _data_);
#line 228 "rygel-writable-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 235 "rygel-writable-container.c"
}


static void rygel_writable_container_real_add_reference (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelWritableContainerAddReferenceData* _data_;
	RygelWritableContainer* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaObject* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_data_ = g_slice_new0 (RygelWritableContainerAddReferenceData);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_writable_container_real_add_reference);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_writable_container_real_add_reference_data_free);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_data_->self = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_tmp1_ = object;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_g_object_unref0 (_data_->object);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_data_->object = _tmp2_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_tmp3_ = cancellable;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_data_->cancellable = _tmp4_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	rygel_writable_container_real_add_reference_co (_data_);
#line 274 "rygel-writable-container.c"
}


static gchar* rygel_writable_container_real_add_reference_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	RygelWritableContainerAddReferenceData* _data_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
		return NULL;
#line 285 "rygel-writable-container.c"
	}
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	result = _data_->result;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_data_->result = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	return result;
#line 295 "rygel-writable-container.c"
}


/**
     * Add a reference to an object.
     * @param object The source object to add a reference to.
     * @param cancellable optional cancellable for this operation
     * @return the id of the newly created reference
     **/
static gboolean rygel_writable_container_real_add_reference_co (RygelWritableContainerAddReferenceData* _data_) {
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	switch (_data_->_state_) {
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
		case 0:
#line 310 "rygel-writable-container.c"
		goto _state_0;
		default:
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
		g_assert_not_reached ();
#line 315 "rygel-writable-container.c"
	}
	_state_0:
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_data_->_tmp0_ = NULL;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_data_->_tmp0_ = g_error_new_literal (RYGEL_WRITABLE_CONTAINER_ERROR, RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED, "Cannot create references here");
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	_data_->_inner_error_ = _data_->_tmp0_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	g_error_free (_data_->_inner_error_);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	if (_data_->_state_ == 0) {
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 332 "rygel-writable-container.c"
	} else {
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 336 "rygel-writable-container.c"
	}
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	g_object_unref (_data_->_async_result);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	return FALSE;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	if (_data_->_state_ == 0) {
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 346 "rygel-writable-container.c"
	} else {
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 350 "rygel-writable-container.c"
	}
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	g_object_unref (_data_->_async_result);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	return FALSE;
#line 356 "rygel-writable-container.c"
}


void rygel_writable_container_add_reference (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->add_reference (self, object, cancellable, _callback_, _user_data_);
#line 363 "rygel-writable-container.c"
}


gchar* rygel_writable_container_add_reference_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	return RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->add_reference_finish (self, _res_, error);
#line 370 "rygel-writable-container.c"
}


void rygel_writable_container_remove_item (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->remove_item (self, id, cancellable, _callback_, _user_data_);
#line 377 "rygel-writable-container.c"
}


void rygel_writable_container_remove_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->remove_item_finish (self, _res_, error);
#line 384 "rygel-writable-container.c"
}


void rygel_writable_container_remove_container (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->remove_container (self, id, cancellable, _callback_, _user_data_);
#line 391 "rygel-writable-container.c"
}


void rygel_writable_container_remove_container_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->remove_container_finish (self, _res_, error);
#line 398 "rygel-writable-container.c"
}


GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	return RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->get_create_classes (self);
#line 407 "rygel-writable-container.c"
}


void rygel_writable_container_set_create_classes (RygelWritableContainer* self, GeeArrayList* value) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	g_return_if_fail (self != NULL);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	RYGEL_WRITABLE_CONTAINER_GET_INTERFACE (self)->set_create_classes (self, value);
#line 416 "rygel-writable-container.c"
}


static void rygel_writable_container_base_init (RygelWritableContainerIface * iface) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	static gboolean initialized = FALSE;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
	if (!initialized) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
		initialized = TRUE;
#line 427 "rygel-writable-container.c"
		/**
		     * The list of upnp classes that can be added to this container.
		     *
		     * See rygel_writable_container_add_item().
		     *
		     * This corresponds to the UPnP ContentDirectory's createClass properties.
		     */
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("create-classes", "create-classes", "create-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
		iface->add_reference = rygel_writable_container_real_add_reference;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-writable-container.vala"
		iface->add_reference_finish = rygel_writable_container_real_add_reference_finish;
#line 441 "rygel-writable-container.c"
	}
}


/**
 * This interface should be implemented by 'writable' containers - ones that allow
 * adding (via upload), removal and editing of items directly under them.
 * Currently, only addition and removal are supported.
 *
 * In addition to implementing this interface, a writable container must also:
 *
 *  # Provide one URI that points to a writable folder on a GIO-supported filesystem.
 *  # Monitor not only its own URI but also that of its child items, though the latter is implied in the former if you use GIO for monitoring.
 */
GType rygel_writable_container_get_type (void) {
	static volatile gsize rygel_writable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_writable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelWritableContainerIface), (GBaseInitFunc) rygel_writable_container_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_writable_container_type_id;
		rygel_writable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelWritableContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_writable_container_type_id, RYGEL_TYPE_MEDIA_CONTAINER);
		g_once_init_leave (&rygel_writable_container_type_id__volatile, rygel_writable_container_type_id);
	}
	return rygel_writable_container_type_id__volatile;
}



