/* rygel-import-resource.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-import-resource.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define RYGEL_TYPE_TRANSFER_STATUS (rygel_transfer_status_get_type ())

#define RYGEL_TYPE_IMPORT_RESOURCE (rygel_import_resource_get_type ())
#define RYGEL_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource))
#define RYGEL_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))
#define RYGEL_IS_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IS_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IMPORT_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))

typedef struct _RygelImportResource RygelImportResource;
typedef struct _RygelImportResourceClass RygelImportResourceClass;
typedef struct _RygelImportResourcePrivate RygelImportResourcePrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_OBJECT_REMOVAL_QUEUE (rygel_object_removal_queue_get_type ())
#define RYGEL_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueue))
#define RYGEL_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_OBJECT_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))

typedef struct _RygelObjectRemovalQueue RygelObjectRemovalQueue;
typedef struct _RygelObjectRemovalQueueClass RygelObjectRemovalQueueClass;
typedef struct _RygelImportResourceRunData RygelImportResourceRunData;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;
typedef struct _RygelImportResourceFetchItemData RygelImportResourceFetchItemData;

typedef enum  {
	RYGEL_TRANSFER_STATUS_COMPLETED,
	RYGEL_TRANSFER_STATUS_ERROR,
	RYGEL_TRANSFER_STATUS_IN_PROGRESS,
	RYGEL_TRANSFER_STATUS_STOPPED
} RygelTransferStatus;

struct _RygelImportResource {
	GObject parent_instance;
	RygelImportResourcePrivate * priv;
	gchar* source_uri;
	gchar* destination_uri;
	guint32 transfer_id;
	RygelTransferStatus status;
	gint64 bytes_copied;
	gint64 bytes_total;
};

struct _RygelImportResourceClass {
	GObjectClass parent_class;
};

struct _RygelImportResourcePrivate {
	RygelMediaFileItem* item;
	SoupSession* session;
	GCancellable* _cancellable;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GUPnPServiceAction* action;
	GSourceFunc run_callback;
	gpointer run_callback_target;
	GDestroyNotify run_callback_target_destroy_notify;
	GFileOutputStream* output_stream;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelImportResourceRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelImportResource* self;
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	GUPnPServiceAction* _tmp5_;
	guint32 _tmp6_;
	RygelMediaFileItem* _tmp7_;
	RygelMediaFileItem* _tmp8_;
	RygelMediaFileItem* _tmp9_;
	GError* _error_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GUPnPServiceAction* _tmp14_;
	GError* _tmp15_;
	gint _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	RygelObjectRemovalQueue* queue;
	RygelObjectRemovalQueue* _tmp19_;
	RygelObjectRemovalQueue* _tmp20_;
	RygelMediaFileItem* _tmp21_;
	GFile* source_file;
	RygelMediaFileItem* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GFile* _tmp25_;
	GFile* _tmp26_;
	GFileOutputStream* _tmp27_;
	GFile* _tmp28_;
	GCancellable* _tmp29_;
	GCancellable* _tmp30_;
	GFileOutputStream* _tmp31_;
	GFileOutputStream* _tmp32_;
	SoupMessage* message;
	const gchar* _tmp33_;
	SoupMessage* _tmp34_;
	SoupMessage* _tmp35_;
	SoupMessage* _tmp36_;
	SoupMessage* _tmp37_;
	SoupMessage* _tmp38_;
	SoupMessage* _tmp39_;
	SoupMessageBody* _tmp40_;
	SoupSession* _tmp41_;
	SoupMessage* _tmp42_;
	SoupMessage* _tmp43_;
	const gchar* _tmp44_;
	RygelMediaFileItem* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GError* err;
	GError* _tmp48_;
	const gchar* _tmp49_;
	RygelObjectRemovalQueue* _tmp50_;
	RygelMediaFileItem* _tmp51_;
	GCancellable* _tmp52_;
	GCancellable* _tmp53_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaFileItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_container) (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_reference) (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*add_reference_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_container) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelImportResourceFetchItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelImportResource* self;
	RygelMediaFileItem* result;
	RygelHTTPItemURI* uri;
	RygelHTTPItemURI* _tmp0_;
	const gchar* _tmp1_;
	RygelHTTPServer* _tmp2_;
	RygelHTTPItemURI* _tmp3_;
	RygelHTTPItemURI* _tmp4_;
	GError* _error_;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	RygelMediaObject* media_object;
	RygelMediaContainer* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	RygelMediaObject* _tmp11_;
	gchar* msg;
	gboolean _tmp12_;
	gboolean _tmp13_;
	RygelMediaObject* _tmp14_;
	RygelMediaObject* _tmp15_;
	RygelMediaObject* _tmp16_;
	RygelMediaContainer* _tmp17_;
	RygelMediaContainer* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	RygelMediaObject* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	const gchar* _tmp25_;
	RygelMediaObject* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	RygelMediaObject* _tmp30_;
	GeeList* _tmp31_;
	GeeList* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	GError* _tmp38_;
	RygelMediaObject* _tmp39_;
	RygelMediaFileItem* _tmp40_;
	GError * _inner_error_;
};


static gpointer rygel_import_resource_parent_class = NULL;
static guint32 rygel_import_resource_last_transfer_id;
static guint32 rygel_import_resource_last_transfer_id = (guint32) 0;
static RygelStateMachineIface* rygel_import_resource_rygel_state_machine_parent_iface = NULL;

GType rygel_transfer_status_get_type (void) G_GNUC_CONST;
GType rygel_import_resource_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_IMPORT_RESOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourcePrivate))
enum  {
	RYGEL_IMPORT_RESOURCE_DUMMY_PROPERTY,
	RYGEL_IMPORT_RESOURCE_STATUS_AS_STRING,
	RYGEL_IMPORT_RESOURCE_CANCELLABLE
};
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
RygelImportResource* rygel_import_resource_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelImportResource* rygel_import_resource_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void __lambda10_ (RygelImportResource* self);
static void ___lambda10__g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void rygel_import_resource_real_run_data_free (gpointer _data);
static void rygel_import_resource_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_import_resource_real_run_co (RygelImportResourceRunData* _data_);
GQuark rygel_content_directory_error_quark (void);
static void rygel_import_resource_fetch_item (RygelImportResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaFileItem* rygel_import_resource_fetch_item_finish (RygelImportResource* self, GAsyncResult* _res_, GError** error);
static void rygel_import_resource_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_object_removal_queue_get_type (void) G_GNUC_CONST;
RygelObjectRemovalQueue* rygel_object_removal_queue_get_default (void);
gboolean rygel_object_removal_queue_dequeue (RygelObjectRemovalQueue* self, RygelMediaObject* object);
gchar* rygel_media_object_get_primary_uri (RygelMediaObject* self);
static void rygel_import_resource_got_chunk_cb (RygelImportResource* self, SoupMessage* message, SoupBuffer* buffer);
static void _rygel_import_resource_got_chunk_cb_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void rygel_import_resource_got_body_cb (RygelImportResource* self, SoupMessage* message);
static void _rygel_import_resource_got_body_cb_soup_message_got_body (SoupMessage* _sender, gpointer self);
static void rygel_import_resource_got_headers_cb (RygelImportResource* self, SoupMessage* message);
static void _rygel_import_resource_got_headers_cb_soup_message_got_headers (SoupMessage* _sender, gpointer self);
static void rygel_import_resource_finished_cb (RygelImportResource* self, SoupMessage* message);
static void _rygel_import_resource_finished_cb_soup_message_finished (SoupMessage* _sender, gpointer self);
static gboolean _rygel_import_resource_real_run_co_gsource_func (gpointer self);
void rygel_object_removal_queue_remove_now (RygelObjectRemovalQueue* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_object_removal_queue_remove_now_finish (RygelObjectRemovalQueue* self, GAsyncResult* _res_);
static void rygel_import_resource_fetch_item_data_free (gpointer _data);
static gboolean rygel_import_resource_fetch_item_co (RygelImportResourceFetchItemData* _data_);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GQuark rygel_http_request_error_quark (void);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
const gchar* rygel_http_item_uri_get_item_id (RygelHTTPItemURI* self);
static void rygel_import_resource_fetch_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
GeeList* rygel_media_object_get_uris (RygelMediaObject* self);
static void rygel_import_resource_handle_transfer_error (RygelImportResource* self, SoupMessage* message);
const gchar* rygel_import_resource_get_status_as_string (RygelImportResource* self);
static void rygel_import_resource_finalize (GObject* obj);
static void _vala_rygel_import_resource_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_import_resource_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType rygel_transfer_status_get_type (void) {
	static volatile gsize rygel_transfer_status_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transfer_status_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_TRANSFER_STATUS_COMPLETED, "RYGEL_TRANSFER_STATUS_COMPLETED", "completed"}, {RYGEL_TRANSFER_STATUS_ERROR, "RYGEL_TRANSFER_STATUS_ERROR", "error"}, {RYGEL_TRANSFER_STATUS_IN_PROGRESS, "RYGEL_TRANSFER_STATUS_IN_PROGRESS", "in-progress"}, {RYGEL_TRANSFER_STATUS_STOPPED, "RYGEL_TRANSFER_STATUS_STOPPED", "stopped"}, {0, NULL, NULL}};
		GType rygel_transfer_status_type_id;
		rygel_transfer_status_type_id = g_enum_register_static ("RygelTransferStatus", values);
		g_once_init_leave (&rygel_transfer_status_type_id__volatile, rygel_transfer_status_type_id);
	}
	return rygel_transfer_status_type_id__volatile;
}


static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self) {
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_boxed_free (gupnp_service_action_get_type (), self);
#line 447 "rygel-import-resource.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	return self ? g_object_ref (self) : NULL;
#line 454 "rygel-import-resource.c"
}


static void __lambda10_ (RygelImportResource* self) {
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp1_ = _tmp0_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_cancellable_cancel (_tmp1_);
#line 467 "rygel-import-resource.c"
}


static void ___lambda10__g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	__lambda10_ ((RygelImportResource*) self);
#line 474 "rygel-import-resource.c"
}


RygelImportResource* rygel_import_resource_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelImportResource * self = NULL;
	RygelContentDirectory* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	RygelContentDirectory* _tmp3_ = NULL;
	RygelHTTPServer* _tmp4_ = NULL;
	RygelHTTPServer* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GUPnPServiceAction* _tmp8_ = NULL;
	guint32 _tmp9_ = 0U;
	guint32 _tmp10_ = 0U;
	SoupSession* _tmp11_ = NULL;
	RygelContentDirectory* _tmp12_ = NULL;
	GCancellable* _tmp13_ = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self = (RygelImportResource*) g_object_new (object_type, NULL);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp0_ = content_dir;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp1_ = _tmp0_->root_container;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (self->priv->root_container);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->priv->root_container = _tmp2_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp3_ = content_dir;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp4_ = _tmp3_->http_server;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (self->priv->http_server);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->priv->http_server = _tmp5_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp6_ = g_cancellable_new ();
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp7_ = _tmp6_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp7_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (_tmp7_);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp8_ = action;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	action = NULL;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	__vala_GUPnPServiceAction_free0 (self->priv->action);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->priv->action = _tmp8_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp9_ = rygel_import_resource_last_transfer_id;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	rygel_import_resource_last_transfer_id = _tmp9_ + 1;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp10_ = rygel_import_resource_last_transfer_id;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->transfer_id = _tmp10_;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->bytes_copied = (gint64) 0;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->bytes_total = (gint64) 0;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->status = RYGEL_TRANSFER_STATUS_IN_PROGRESS;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp11_ = soup_session_new ();
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (self->priv->session);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->priv->session = _tmp11_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp12_ = content_dir;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp13_ = _tmp12_->cancellable;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_signal_connect_object (_tmp13_, "cancelled", (GCallback) ___lambda10__g_cancellable_cancelled, self, 0);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	__vala_GUPnPServiceAction_free0 (action);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	return self;
#line 566 "rygel-import-resource.c"
}


RygelImportResource* rygel_import_resource_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	return rygel_import_resource_construct (RYGEL_TYPE_IMPORT_RESOURCE, content_dir, action);
#line 573 "rygel-import-resource.c"
}


static void rygel_import_resource_real_run_data_free (gpointer _data) {
	RygelImportResourceRunData* _data_;
	_data_ = _data;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (_data_->self);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_slice_free (RygelImportResourceRunData, _data_);
#line 584 "rygel-import-resource.c"
}


static void rygel_import_resource_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelImportResource * self;
	RygelImportResourceRunData* _data_;
	RygelImportResource* _tmp0_ = NULL;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self = (RygelImportResource*) base;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_ = g_slice_new0 (RygelImportResourceRunData);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_import_resource_real_run);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_import_resource_real_run_data_free);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->self = _tmp0_;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	rygel_import_resource_real_run_co (_data_);
#line 606 "rygel-import-resource.c"
}


static void rygel_import_resource_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelImportResourceRunData* _data_;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 614 "rygel-import-resource.c"
}


static void rygel_import_resource_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelImportResourceRunData* _data_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_ = _user_data_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_source_object_ = source_object;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_res_ = _res_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	rygel_import_resource_real_run_co (_data_);
#line 628 "rygel-import-resource.c"
}


static void _rygel_import_resource_got_chunk_cb_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	rygel_import_resource_got_chunk_cb ((RygelImportResource*) self, _sender, chunk);
#line 635 "rygel-import-resource.c"
}


static void _rygel_import_resource_got_body_cb_soup_message_got_body (SoupMessage* _sender, gpointer self) {
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	rygel_import_resource_got_body_cb ((RygelImportResource*) self, _sender);
#line 642 "rygel-import-resource.c"
}


static void _rygel_import_resource_got_headers_cb_soup_message_got_headers (SoupMessage* _sender, gpointer self) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	rygel_import_resource_got_headers_cb ((RygelImportResource*) self, _sender);
#line 649 "rygel-import-resource.c"
}


static void _rygel_import_resource_finished_cb_soup_message_finished (SoupMessage* _sender, gpointer self) {
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	rygel_import_resource_finished_cb ((RygelImportResource*) self, _sender);
#line 656 "rygel-import-resource.c"
}


static gboolean _rygel_import_resource_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_import_resource_real_run_co (self);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	return result;
#line 665 "rygel-import-resource.c"
}


static gboolean rygel_import_resource_real_run_co (RygelImportResourceRunData* _data_) {
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	switch (_data_->_state_) {
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		case 0:
#line 674 "rygel-import-resource.c"
		goto _state_0;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		case 1:
#line 678 "rygel-import-resource.c"
		goto _state_1;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		case 2:
#line 682 "rygel-import-resource.c"
		goto _state_2;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		case 3:
#line 686 "rygel-import-resource.c"
		goto _state_3;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		case 4:
#line 690 "rygel-import-resource.c"
		goto _state_4;
		default:
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_assert_not_reached ();
#line 695 "rygel-import-resource.c"
	}
	_state_0:
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp0_ = NULL;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp0_ = _data_->self->priv->action;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	gupnp_service_action_get (_data_->_tmp0_, "SourceURI", G_TYPE_STRING, &_data_->self->source_uri, "DestinationURI", G_TYPE_STRING, &_data_->self->destination_uri, NULL);
#line 704 "rygel-import-resource.c"
	{
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp1_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp1_ = _data_->self->source_uri;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (_data_->_tmp1_ == NULL) {
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp2_ = NULL;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp2_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "Must provide source URI");
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_inner_error_ = _data_->_tmp2_;
#line 718 "rygel-import-resource.c"
			goto __catch53_g_error;
		}
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp3_ = NULL;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp3_ = _data_->self->destination_uri;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (_data_->_tmp3_ == NULL) {
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp4_ = NULL;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp4_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE, "Must provide destination URI");
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_inner_error_ = _data_->_tmp4_;
#line 733 "rygel-import-resource.c"
			goto __catch53_g_error;
		}
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp5_ = NULL;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp5_ = _data_->self->priv->action;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp6_ = 0U;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp6_ = _data_->self->transfer_id;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		gupnp_service_action_set (_data_->_tmp5_, "TransferID", G_TYPE_UINT, _data_->_tmp6_, NULL);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_state_ = 1;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		rygel_import_resource_fetch_item (_data_->self, rygel_import_resource_run_ready, _data_);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return FALSE;
#line 752 "rygel-import-resource.c"
		_state_1:
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp8_ = NULL;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp8_ = rygel_import_resource_fetch_item_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp7_ = _data_->_tmp8_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 762 "rygel-import-resource.c"
			goto __catch53_g_error;
		}
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp9_ = NULL;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp9_ = _data_->_tmp7_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp7_ = NULL;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_object_unref0 (_data_->self->priv->item);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->self->priv->item = _data_->_tmp9_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_object_unref0 (_data_->_tmp7_);
#line 777 "rygel-import-resource.c"
	}
	goto __finally53;
	__catch53_g_error:
	{
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_inner_error_ = NULL;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp10_ = NULL;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp10_ = _ ("Failed to get original URI for '%s': %s");
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp11_ = NULL;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp11_ = _data_->self->destination_uri;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp12_ = NULL;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp12_ = _data_->_error_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp13_ = NULL;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp13_ = _data_->_tmp12_->message;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_warning (_data_->_tmp10_, _data_->_tmp11_, _data_->_tmp13_);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp14_ = NULL;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp14_ = _data_->self->priv->action;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp15_ = NULL;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp15_ = _data_->_error_;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp16_ = 0;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp16_ = _data_->_tmp15_->code;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp17_ = NULL;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp17_ = _data_->_error_;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp18_ = NULL;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp18_ = _data_->_tmp17_->message;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		gupnp_service_action_return_error (_data_->_tmp14_, (guint) _data_->_tmp16_, _data_->_tmp18_);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->self->status = RYGEL_TRANSFER_STATUS_ERROR;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_error_free0 (_data_->_error_);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (_data_->_state_ == 0) {
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 836 "rygel-import-resource.c"
		} else {
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 840 "rygel-import-resource.c"
		}
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_object_unref (_data_->_async_result);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return FALSE;
#line 846 "rygel-import-resource.c"
	}
	__finally53:
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_clear_error (&_data_->_inner_error_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return FALSE;
#line 857 "rygel-import-resource.c"
	}
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp19_ = NULL;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp19_ = rygel_object_removal_queue_get_default ();
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->queue = _data_->_tmp19_;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp20_ = NULL;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp20_ = _data_->queue;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp21_ = NULL;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp21_ = _data_->self->priv->item;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	rygel_object_removal_queue_dequeue (_data_->_tmp20_, (RygelMediaObject*) _data_->_tmp21_);
#line 875 "rygel-import-resource.c"
	{
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp22_ = NULL;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp22_ = _data_->self->priv->item;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp23_ = NULL;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp23_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _data_->_tmp22_);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp24_ = NULL;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp24_ = _data_->_tmp23_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp25_ = NULL;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp25_ = g_file_new_for_uri (_data_->_tmp24_);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp26_ = NULL;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp26_ = _data_->_tmp25_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_free0 (_data_->_tmp24_);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->source_file = _data_->_tmp26_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp28_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp28_ = _data_->source_file;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp29_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp29_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp30_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp30_ = _data_->_tmp29_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_state_ = 2;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_file_replace_async (_data_->_tmp28_, NULL, FALSE, G_FILE_CREATE_PRIVATE, G_PRIORITY_DEFAULT, _data_->_tmp30_, rygel_import_resource_run_ready, _data_);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return FALSE;
#line 919 "rygel-import-resource.c"
		_state_2:
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp31_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp31_ = g_file_replace_finish (_data_->_tmp28_, _data_->_res_, &_data_->_inner_error_);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp27_ = _data_->_tmp31_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_g_object_unref0 (_data_->source_file);
#line 931 "rygel-import-resource.c"
			goto __catch54_g_error;
		}
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp32_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp32_ = _data_->_tmp27_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp27_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_object_unref0 (_data_->self->priv->output_stream);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->self->priv->output_stream = _data_->_tmp32_;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp33_ = NULL;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp33_ = _data_->self->source_uri;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp34_ = NULL;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp34_ = soup_message_new ("GET", _data_->_tmp33_);
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->message = _data_->_tmp34_;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp35_ = NULL;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp35_ = _data_->message;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_signal_connect_object (_data_->_tmp35_, "got-chunk", (GCallback) _rygel_import_resource_got_chunk_cb_soup_message_got_chunk, _data_->self, 0);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp36_ = NULL;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp36_ = _data_->message;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_signal_connect_object (_data_->_tmp36_, "got-body", (GCallback) _rygel_import_resource_got_body_cb_soup_message_got_body, _data_->self, 0);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp37_ = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp37_ = _data_->message;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_signal_connect_object (_data_->_tmp37_, "got-headers", (GCallback) _rygel_import_resource_got_headers_cb_soup_message_got_headers, _data_->self, 0);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp38_ = NULL;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp38_ = _data_->message;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_signal_connect_object (_data_->_tmp38_, "finished", (GCallback) _rygel_import_resource_finished_cb_soup_message_finished, _data_->self, 0);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp39_ = NULL;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp39_ = _data_->message;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp40_ = NULL;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp40_ = _data_->_tmp39_->response_body;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		soup_message_body_set_accumulate (_data_->_tmp40_, FALSE);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		(_data_->self->priv->run_callback_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->run_callback_target_destroy_notify (_data_->self->priv->run_callback_target), NULL);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->self->priv->run_callback = NULL;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->self->priv->run_callback_target = NULL;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->self->priv->run_callback_target_destroy_notify = NULL;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->self->priv->run_callback = _rygel_import_resource_real_run_co_gsource_func;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->self->priv->run_callback_target = _data_;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->self->priv->run_callback_target_destroy_notify = NULL;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp41_ = NULL;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp41_ = _data_->self->priv->session;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp42_ = NULL;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp42_ = _data_->message;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp43_ = NULL;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp43_ = _g_object_ref0 (_data_->_tmp42_);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		soup_session_queue_message (_data_->_tmp41_, _data_->_tmp43_, NULL, NULL);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp44_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp44_ = _data_->self->source_uri;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp45_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp45_ = _data_->self->priv->item;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp46_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp46_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _data_->_tmp45_);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp47_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp47_ = _data_->_tmp46_;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_debug ("rygel-import-resource.vala:155: Importing resource from %s to %s", _data_->_tmp44_, _data_->_tmp47_);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_free0 (_data_->_tmp47_);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_state_ = 3;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return FALSE;
#line 1040 "rygel-import-resource.c"
		_state_3:
		;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_object_unref0 (_data_->message);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_object_unref0 (_data_->_tmp27_);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_object_unref0 (_data_->source_file);
#line 1049 "rygel-import-resource.c"
	}
	goto __finally54;
	__catch54_g_error:
	{
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->err = _data_->_inner_error_;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_inner_error_ = NULL;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp48_ = NULL;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp48_ = _data_->err;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp49_ = NULL;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp49_ = _data_->_tmp48_->message;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_warning ("rygel-import-resource.vala:161: %s", _data_->_tmp49_);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->self->status = RYGEL_TRANSFER_STATUS_ERROR;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp50_ = NULL;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp50_ = _data_->queue;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp51_ = NULL;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp51_ = _data_->self->priv->item;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp52_ = NULL;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp52_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp53_ = NULL;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp53_ = _data_->_tmp52_;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_state_ = 4;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		rygel_object_removal_queue_remove_now (_data_->_tmp50_, (RygelMediaObject*) _data_->_tmp51_, _data_->_tmp53_, rygel_import_resource_run_ready, _data_);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return FALSE;
#line 1092 "rygel-import-resource.c"
		_state_4:
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		rygel_object_removal_queue_remove_now_finish (_data_->_tmp50_, _data_->_res_);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_error_free0 (_data_->err);
#line 1098 "rygel-import-resource.c"
	}
	__finally54:
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_object_unref0 (_data_->queue);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_clear_error (&_data_->_inner_error_);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return FALSE;
#line 1111 "rygel-import-resource.c"
	}
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (_data_->queue);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (_data_->_state_ == 0) {
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1121 "rygel-import-resource.c"
	} else {
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1125 "rygel-import-resource.c"
	}
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_object_unref (_data_->_async_result);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	return FALSE;
#line 1131 "rygel-import-resource.c"
}


static void rygel_import_resource_fetch_item_data_free (gpointer _data) {
	RygelImportResourceFetchItemData* _data_;
	_data_ = _data;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (_data_->result);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (_data_->self);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_slice_free (RygelImportResourceFetchItemData, _data_);
#line 1144 "rygel-import-resource.c"
}


static void rygel_import_resource_fetch_item (RygelImportResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelImportResourceFetchItemData* _data_;
	RygelImportResource* _tmp0_ = NULL;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_ = g_slice_new0 (RygelImportResourceFetchItemData);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_import_resource_fetch_item);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_import_resource_fetch_item_data_free);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->self = _tmp0_;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	rygel_import_resource_fetch_item_co (_data_);
#line 1163 "rygel-import-resource.c"
}


static RygelMediaFileItem* rygel_import_resource_fetch_item_finish (RygelImportResource* self, GAsyncResult* _res_, GError** error) {
	RygelMediaFileItem* result;
	RygelImportResourceFetchItemData* _data_;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return NULL;
#line 1174 "rygel-import-resource.c"
	}
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	result = _data_->result;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->result = NULL;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	return result;
#line 1184 "rygel-import-resource.c"
}


static void rygel_import_resource_fetch_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelImportResourceFetchItemData* _data_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_ = _user_data_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_source_object_ = source_object;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_res_ = _res_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	rygel_import_resource_fetch_item_co (_data_);
#line 1198 "rygel-import-resource.c"
}


static gboolean rygel_import_resource_fetch_item_co (RygelImportResourceFetchItemData* _data_) {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	switch (_data_->_state_) {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		case 0:
#line 1207 "rygel-import-resource.c"
		goto _state_0;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		case 1:
#line 1211 "rygel-import-resource.c"
		goto _state_1;
		default:
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_assert_not_reached ();
#line 1216 "rygel-import-resource.c"
	}
	_state_0:
	{
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp1_ = NULL;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp1_ = _data_->self->destination_uri;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp2_ = NULL;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp2_ = _data_->self->priv->http_server;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp3_ = NULL;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp3_ = rygel_http_item_uri_new_from_string (_data_->_tmp1_, _data_->_tmp2_, &_data_->_inner_error_);
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp0_ = _data_->_tmp3_;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1236 "rygel-import-resource.c"
			goto __catch55_g_error;
		}
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp4_ = NULL;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp4_ = _data_->_tmp0_;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp0_ = NULL;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_object_unref0 (_data_->uri);
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->uri = _data_->_tmp4_;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_object_unref0 (_data_->_tmp0_);
#line 1251 "rygel-import-resource.c"
	}
	goto __finally55;
	__catch55_g_error:
	{
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_inner_error_ = NULL;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp5_ = NULL;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp5_ = _data_->_error_;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp6_ = NULL;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp6_ = _data_->_tmp5_->message;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp7_ = NULL;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp7_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE, _data_->_tmp6_);
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_inner_error_ = _data_->_tmp7_;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_error_free0 (_data_->_error_);
#line 1276 "rygel-import-resource.c"
		goto __finally55;
	}
	__finally55:
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_error_free (_data_->_inner_error_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_object_unref0 (_data_->uri);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (_data_->_state_ == 0) {
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1292 "rygel-import-resource.c"
		} else {
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1296 "rygel-import-resource.c"
		}
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_object_unref (_data_->_async_result);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return FALSE;
#line 1302 "rygel-import-resource.c"
	}
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp8_ = NULL;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp8_ = _data_->self->priv->root_container;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp9_ = NULL;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp9_ = rygel_http_item_uri_get_item_id (_data_->uri);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp10_ = NULL;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp10_ = _data_->_tmp9_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_state_ = 1;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	rygel_media_container_find_object (_data_->_tmp8_, _data_->_tmp10_, NULL, rygel_import_resource_fetch_item_ready, _data_);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	return FALSE;
#line 1322 "rygel-import-resource.c"
	_state_1:
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp11_ = NULL;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp11_ = rygel_media_container_find_object_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error_);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->media_object = _data_->_tmp11_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_error_free (_data_->_inner_error_);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_object_unref0 (_data_->uri);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (_data_->_state_ == 0) {
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1342 "rygel-import-resource.c"
		} else {
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1346 "rygel-import-resource.c"
		}
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_object_unref (_data_->_async_result);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return FALSE;
#line 1352 "rygel-import-resource.c"
	}
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->msg = NULL;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp14_ = NULL;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp14_ = _data_->media_object;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (_data_->_tmp14_ == NULL) {
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp13_ = TRUE;
#line 1364 "rygel-import-resource.c"
	} else {
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp15_ = NULL;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp15_ = _data_->media_object;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp13_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp15_, RYGEL_TYPE_MEDIA_FILE_ITEM);
#line 1372 "rygel-import-resource.c"
	}
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (_data_->_tmp13_) {
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp12_ = TRUE;
#line 1378 "rygel-import-resource.c"
	} else {
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp16_ = NULL;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp16_ = _data_->media_object;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp17_ = NULL;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp17_ = rygel_media_object_get_parent (_data_->_tmp16_);
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp18_ = NULL;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp18_ = _data_->_tmp17_;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp12_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp18_, RYGEL_TYPE_WRITABLE_CONTAINER);
#line 1394 "rygel-import-resource.c"
	}
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (_data_->_tmp12_) {
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp19_ = NULL;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp19_ = _ ("URI '%s' invalid for importing contents to");
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp20_ = NULL;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp20_ = _data_->self->destination_uri;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp21_ = NULL;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp21_ = g_strdup_printf (_data_->_tmp19_, _data_->_tmp20_);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_free0 (_data_->msg);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->msg = _data_->_tmp21_;
#line 1414 "rygel-import-resource.c"
	} else {
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp22_ = NULL;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp22_ = _data_->media_object;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp23_ = FALSE;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp23_ = rygel_media_file_item_get_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp22_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp22_) : NULL);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp24_ = FALSE;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp24_ = _data_->_tmp23_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (!_data_->_tmp24_) {
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp25_ = NULL;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp25_ = _ ("Pushing data to non-empty item '%s' not allowed");
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp26_ = NULL;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp26_ = _data_->media_object;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp27_ = NULL;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp27_ = rygel_media_object_get_id (_data_->_tmp26_);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp28_ = NULL;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp28_ = _data_->_tmp27_;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp29_ = NULL;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp29_ = g_strdup_printf (_data_->_tmp25_, _data_->_tmp28_);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_g_free0 (_data_->msg);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->msg = _data_->_tmp29_;
#line 1454 "rygel-import-resource.c"
		} else {
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp30_ = NULL;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp30_ = _data_->media_object;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp31_ = NULL;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp31_ = rygel_media_object_get_uris (_data_->_tmp30_);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp32_ = NULL;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp32_ = _data_->_tmp31_;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp33_ = FALSE;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp33_ = gee_collection_get_is_empty ((GeeCollection*) _data_->_tmp32_);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp34_ = FALSE;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp34_ = _data_->_tmp33_;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp35_ = FALSE;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_data_->_tmp35_ = _data_->_tmp34_;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_g_object_unref0 (_data_->_tmp32_);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			if (_data_->_tmp35_) {
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
				g_assert_not_reached ();
#line 1486 "rygel-import-resource.c"
			}
		}
	}
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp36_ = NULL;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp36_ = _data_->msg;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (_data_->_tmp36_ != NULL) {
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp37_ = NULL;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp37_ = _data_->msg;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp38_ = NULL;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_tmp38_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _data_->_tmp37_);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_data_->_inner_error_ = _data_->_tmp38_;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_error_free (_data_->_inner_error_);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_free0 (_data_->msg);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_object_unref0 (_data_->media_object);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_object_unref0 (_data_->uri);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (_data_->_state_ == 0) {
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1520 "rygel-import-resource.c"
		} else {
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1524 "rygel-import-resource.c"
		}
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_object_unref (_data_->_async_result);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return FALSE;
#line 1530 "rygel-import-resource.c"
	}
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp39_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp39_ = _data_->media_object;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp40_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp39_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp39_) : NULL);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_data_->result = _data_->_tmp40_;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_free0 (_data_->msg);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (_data_->media_object);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (_data_->uri);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (_data_->_state_ == 0) {
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1552 "rygel-import-resource.c"
	} else {
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1556 "rygel-import-resource.c"
	}
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_object_unref (_data_->_async_result);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	return FALSE;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_free0 (_data_->msg);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (_data_->media_object);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (_data_->uri);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (_data_->_state_ == 0) {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1572 "rygel-import-resource.c"
	} else {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1576 "rygel-import-resource.c"
	}
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_object_unref (_data_->_async_result);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	return FALSE;
#line 1582 "rygel-import-resource.c"
}


static void rygel_import_resource_got_headers_cb (RygelImportResource* self, SoupMessage* message) {
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gboolean _tmp3_ = FALSE;
	SoupMessage* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_return_if_fail (self != NULL);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_return_if_fail (message != NULL);
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp0_ = message;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp1_ = _tmp0_->response_headers;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp2_ = soup_message_headers_get_content_length (_tmp1_);
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->bytes_total = _tmp2_;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp4_ = message;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_object_get (_tmp4_, "status-code", &_tmp5_, NULL);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp6_ = _tmp5_;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (_tmp6_ >= ((guint) 200)) {
#line 1614 "rygel-import-resource.c"
		SoupMessage* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp7_ = message;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_object_get (_tmp7_, "status-code", &_tmp8_, NULL);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp9_ = _tmp8_;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp3_ = _tmp9_ <= ((guint) 299);
#line 1626 "rygel-import-resource.c"
	} else {
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp3_ = FALSE;
#line 1630 "rygel-import-resource.c"
	}
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (_tmp3_) {
#line 1634 "rygel-import-resource.c"
		GUPnPServiceAction* _tmp10_ = NULL;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp10_ = self->priv->action;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		gupnp_service_action_return (_tmp10_);
#line 1640 "rygel-import-resource.c"
	} else {
		SoupMessage* _tmp11_ = NULL;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp11_ = message;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		rygel_import_resource_handle_transfer_error (self, _tmp11_);
#line 1647 "rygel-import-resource.c"
	}
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	__vala_GUPnPServiceAction_free0 (self->priv->action);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->priv->action = NULL;
#line 1653 "rygel-import-resource.c"
}


static void rygel_import_resource_got_chunk_cb (RygelImportResource* self, SoupMessage* message, SoupBuffer* buffer) {
	gint64 _tmp0_ = 0LL;
	SoupBuffer* _tmp1_ = NULL;
	gsize _tmp2_ = 0UL;
	GError * _inner_error_ = NULL;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_return_if_fail (self != NULL);
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_return_if_fail (message != NULL);
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_return_if_fail (buffer != NULL);
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp0_ = self->bytes_copied;
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp1_ = buffer;
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp2_ = _tmp1_->length;
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->bytes_copied = _tmp0_ + _tmp2_;
#line 1676 "rygel-import-resource.c"
	{
		gsize bytes_written = 0UL;
		GFileOutputStream* _tmp3_ = NULL;
		SoupBuffer* _tmp4_ = NULL;
		guint8* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		GCancellable* _tmp6_ = NULL;
		GCancellable* _tmp7_ = NULL;
		gsize _tmp8_ = 0UL;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp3_ = self->priv->output_stream;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp4_ = buffer;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp5_ = _tmp4_->data;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp5__length1 = (gint) _tmp4_->length;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp6_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp7_ = _tmp6_;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp3_, _tmp5_, (gsize) _tmp5__length1, &_tmp8_, _tmp7_, &_inner_error_);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		bytes_written = _tmp8_;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1704 "rygel-import-resource.c"
			goto __catch56_g_error;
		}
	}
	goto __finally56;
	__catch56_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		SoupSession* _tmp12_ = NULL;
		SoupMessage* _tmp13_ = NULL;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_error_ = _inner_error_;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_inner_error_ = NULL;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp9_ = _error_;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp10_ = _tmp9_->message;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_warning ("rygel-import-resource.vala:222: %s", _tmp10_);
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp11_ = _error_;
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (g_error_matches (_tmp11_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			self->status = RYGEL_TRANSFER_STATUS_STOPPED;
#line 1733 "rygel-import-resource.c"
		} else {
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			self->status = RYGEL_TRANSFER_STATUS_ERROR;
#line 1737 "rygel-import-resource.c"
		}
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp12_ = self->priv->session;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp13_ = message;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		soup_session_cancel_message (_tmp12_, _tmp13_, (guint) SOUP_STATUS_CANCELLED);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_error_free0 (_error_);
#line 1747 "rygel-import-resource.c"
	}
	__finally56:
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_clear_error (&_inner_error_);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return;
#line 1758 "rygel-import-resource.c"
	}
}


static void rygel_import_resource_got_body_cb (RygelImportResource* self, SoupMessage* message) {
	gint64 _tmp0_ = 0LL;
	GError * _inner_error_ = NULL;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_return_if_fail (self != NULL);
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_return_if_fail (message != NULL);
#line 233 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp0_ = self->bytes_total;
#line 233 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (_tmp0_ == ((gint64) 0)) {
#line 1774 "rygel-import-resource.c"
		gint64 _tmp1_ = 0LL;
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp1_ = self->bytes_copied;
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		self->bytes_total = _tmp1_;
#line 1780 "rygel-import-resource.c"
	} else {
		gint64 _tmp2_ = 0LL;
		gint64 _tmp3_ = 0LL;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp2_ = self->bytes_total;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp3_ = self->bytes_copied;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (_tmp2_ != _tmp3_) {
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			self->status = RYGEL_TRANSFER_STATUS_ERROR;
#line 238 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			return;
#line 1794 "rygel-import-resource.c"
		}
	}
	{
		GFileOutputStream* _tmp4_ = NULL;
		GCancellable* _tmp5_ = NULL;
		GCancellable* _tmp6_ = NULL;
		RygelTransferStatus _tmp7_ = 0;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp4_ = self->priv->output_stream;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp5_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp6_ = _tmp5_;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_output_stream_close ((GOutputStream*) _tmp4_, _tmp6_, &_inner_error_);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1812 "rygel-import-resource.c"
			goto __catch57_g_error;
		}
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp7_ = self->status;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (_tmp7_ == RYGEL_TRANSFER_STATUS_IN_PROGRESS) {
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			self->status = RYGEL_TRANSFER_STATUS_COMPLETED;
#line 1821 "rygel-import-resource.c"
		}
	}
	goto __finally57;
	__catch57_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_error_ = _inner_error_;
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_inner_error_ = NULL;
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp8_ = _error_;
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp9_ = _tmp8_->message;
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_warning ("rygel-import-resource.vala:247: %s", _tmp9_);
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		self->status = RYGEL_TRANSFER_STATUS_ERROR;
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_error_free0 (_error_);
#line 1844 "rygel-import-resource.c"
	}
	__finally57:
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_clear_error (&_inner_error_);
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return;
#line 1855 "rygel-import-resource.c"
	}
}


static void rygel_import_resource_finished_cb (RygelImportResource* self, SoupMessage* message) {
	RygelTransferStatus _tmp0_ = 0;
	GSourceFunc _tmp9_ = NULL;
	void* _tmp9__target = NULL;
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_return_if_fail (self != NULL);
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_return_if_fail (message != NULL);
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp0_ = self->status;
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (_tmp0_ == RYGEL_TRANSFER_STATUS_IN_PROGRESS) {
#line 1872 "rygel-import-resource.c"
		gboolean _tmp1_ = FALSE;
		SoupMessage* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp2_ = message;
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_object_get (_tmp2_, "status-code", &_tmp3_, NULL);
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp4_ = _tmp3_;
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (_tmp4_ >= ((guint) 200)) {
#line 1885 "rygel-import-resource.c"
			SoupMessage* _tmp5_ = NULL;
			guint _tmp6_ = 0U;
			guint _tmp7_ = 0U;
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_tmp5_ = message;
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			g_object_get (_tmp5_, "status-code", &_tmp6_, NULL);
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_tmp7_ = _tmp6_;
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_tmp1_ = _tmp7_ <= ((guint) 299);
#line 1897 "rygel-import-resource.c"
		} else {
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_tmp1_ = FALSE;
#line 1901 "rygel-import-resource.c"
		}
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (!_tmp1_) {
#line 1905 "rygel-import-resource.c"
			SoupMessage* _tmp8_ = NULL;
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_tmp8_ = message;
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			rygel_import_resource_handle_transfer_error (self, _tmp8_);
#line 1911 "rygel-import-resource.c"
		}
	}
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp9_ = self->priv->run_callback;
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp9__target = self->priv->run_callback_target;
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp9_ (_tmp9__target);
#line 1920 "rygel-import-resource.c"
}


static void rygel_import_resource_handle_transfer_error (RygelImportResource* self, SoupMessage* message) {
	gchar* phrase = NULL;
	SoupMessage* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GUPnPServiceAction* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	SoupMessage* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
	guint _tmp23_ = 0U;
	GError * _inner_error_ = NULL;
#line 262 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_return_if_fail (self != NULL);
#line 262 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_return_if_fail (message != NULL);
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->status = RYGEL_TRANSFER_STATUS_ERROR;
#line 1946 "rygel-import-resource.c"
	{
		GFileOutputStream* _tmp0_ = NULL;
		GCancellable* _tmp1_ = NULL;
		GCancellable* _tmp2_ = NULL;
		GFile* file = NULL;
		RygelMediaFileItem* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		GCancellable* _tmp9_ = NULL;
		GCancellable* _tmp10_ = NULL;
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp0_ = self->priv->output_stream;
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp2_ = _tmp1_;
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_output_stream_close ((GOutputStream*) _tmp0_, _tmp2_, &_inner_error_);
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1970 "rygel-import-resource.c"
			goto __catch58_g_error;
		}
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp3_ = self->priv->item;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp4_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _tmp3_);
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp5_ = _tmp4_;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp6_ = g_file_new_for_uri (_tmp5_);
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp7_ = _tmp6_;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_free0 (_tmp5_);
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		file = _tmp7_;
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp8_ = file;
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp9_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp10_ = _tmp9_;
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_file_delete (_tmp8_, _tmp10_, &_inner_error_);
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			_g_object_unref0 (file);
#line 1999 "rygel-import-resource.c"
			goto __catch58_g_error;
		}
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_object_unref0 (file);
#line 2004 "rygel-import-resource.c"
	}
	goto __finally58;
	__catch58_g_error:
	{
		GError* _error_ = NULL;
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_error_ = _inner_error_;
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_inner_error_ = NULL;
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_error_free0 (_error_);
#line 2016 "rygel-import-resource.c"
	}
	__finally58:
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_clear_error (&_inner_error_);
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return;
#line 2027 "rygel-import-resource.c"
	}
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp11_ = message;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_object_get (_tmp11_, "status-code", &_tmp12_, NULL);
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp13_ = _tmp12_;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp14_ = soup_status_get_phrase (_tmp13_);
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp15_ = g_strdup (_tmp14_);
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	phrase = _tmp15_;
#line 271 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp16_ = _ ("Failed to import file from %s: %s");
#line 271 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp17_ = self->source_uri;
#line 271 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp18_ = phrase;
#line 271 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_warning (_tmp16_, _tmp17_, _tmp18_);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp19_ = self->priv->action;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (_tmp19_ == NULL) {
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_g_free0 (phrase);
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		return;
#line 2057 "rygel-import-resource.c"
	}
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp21_ = message;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_object_get (_tmp21_, "status-code", &_tmp22_, NULL);
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp23_ = _tmp22_;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (_tmp23_ == ((guint) SOUP_STATUS_NOT_FOUND)) {
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp20_ = TRUE;
#line 2069 "rygel-import-resource.c"
	} else {
		SoupMessage* _tmp24_ = NULL;
		guint _tmp25_ = 0U;
		guint _tmp26_ = 0U;
#line 280 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp24_ = message;
#line 280 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_object_get (_tmp24_, "status-code", &_tmp25_, NULL);
#line 280 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp26_ = _tmp25_;
#line 280 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp20_ = _tmp26_ < ((guint) 100);
#line 2082 "rygel-import-resource.c"
	}
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	if (_tmp20_) {
#line 2086 "rygel-import-resource.c"
		GUPnPServiceAction* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
#line 281 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp27_ = self->priv->action;
#line 281 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp28_ = phrase;
#line 281 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		gupnp_service_action_return_error (_tmp27_, (guint) 714, _tmp28_);
#line 2095 "rygel-import-resource.c"
	} else {
		GUPnPServiceAction* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
#line 283 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp29_ = self->priv->action;
#line 283 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		_tmp30_ = phrase;
#line 283 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		gupnp_service_action_return_error (_tmp29_, (guint) 715, _tmp30_);
#line 2105 "rygel-import-resource.c"
	}
#line 262 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_free0 (phrase);
#line 2109 "rygel-import-resource.c"
}


const gchar* rygel_import_resource_get_status_as_string (RygelImportResource* self) {
	const gchar* result;
	RygelTransferStatus _tmp0_ = 0;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp0_ = self->status;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	switch (_tmp0_) {
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		case RYGEL_TRANSFER_STATUS_COMPLETED:
#line 2124 "rygel-import-resource.c"
		{
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			result = "COMPLETED";
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			return result;
#line 2130 "rygel-import-resource.c"
		}
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		case RYGEL_TRANSFER_STATUS_ERROR:
#line 2134 "rygel-import-resource.c"
		{
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			result = "ERROR";
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			return result;
#line 2140 "rygel-import-resource.c"
		}
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		case RYGEL_TRANSFER_STATUS_IN_PROGRESS:
#line 2144 "rygel-import-resource.c"
		{
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			result = "IN_PROGRESS";
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			return result;
#line 2150 "rygel-import-resource.c"
		}
		default:
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		case RYGEL_TRANSFER_STATUS_STOPPED:
#line 2155 "rygel-import-resource.c"
		{
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			result = "STOPPED";
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
			return result;
#line 2161 "rygel-import-resource.c"
		}
	}
}


static GCancellable* rygel_import_resource_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelImportResource* self;
	GCancellable* _tmp0_ = NULL;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self = (RygelImportResource*) base;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp0_ = self->priv->_cancellable;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	result = _tmp0_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	return result;
#line 2179 "rygel-import-resource.c"
}


static void rygel_import_resource_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelImportResource* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self = (RygelImportResource*) base;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp0_ = value;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->priv->_cancellable = _tmp1_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 2199 "rygel-import-resource.c"
}


static void rygel_import_resource_class_init (RygelImportResourceClass * klass) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	rygel_import_resource_parent_class = g_type_class_peek_parent (klass);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_type_class_add_private (klass, sizeof (RygelImportResourcePrivate));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_import_resource_get_property;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_import_resource_set_property;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_import_resource_finalize;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMPORT_RESOURCE_STATUS_AS_STRING, g_param_spec_string ("status-as-string", "status-as-string", "status-as-string", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMPORT_RESOURCE_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2218 "rygel-import-resource.c"
}


static void rygel_import_resource_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	rygel_import_resource_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_import_resource_real_run;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	iface->run_finish = rygel_import_resource_real_run_finish;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	iface->get_cancellable = rygel_import_resource_real_get_cancellable;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	iface->set_cancellable = rygel_import_resource_real_set_cancellable;
#line 2233 "rygel-import-resource.c"
}


static void rygel_import_resource_instance_init (RygelImportResource * self) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->priv = RYGEL_IMPORT_RESOURCE_GET_PRIVATE (self);
#line 2240 "rygel-import-resource.c"
}


static void rygel_import_resource_finalize (GObject* obj) {
	RygelImportResource * self;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_free0 (self->source_uri);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_free0 (self->destination_uri);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (self->priv->item);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (self->priv->session);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (self->priv->http_server);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (self->priv->root_container);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	__vala_GUPnPServiceAction_free0 (self->priv->action);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	(self->priv->run_callback_target_destroy_notify == NULL) ? NULL : (self->priv->run_callback_target_destroy_notify (self->priv->run_callback_target), NULL);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->priv->run_callback = NULL;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->priv->run_callback_target = NULL;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	self->priv->run_callback_target_destroy_notify = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	_g_object_unref0 (self->priv->output_stream);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	G_OBJECT_CLASS (rygel_import_resource_parent_class)->finalize (obj);
#line 2276 "rygel-import-resource.c"
}


/**
 * Responsible for handling ImportResource action.
 */
GType rygel_import_resource_get_type (void) {
	static volatile gsize rygel_import_resource_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_import_resource_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelImportResourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_import_resource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelImportResource), 0, (GInstanceInitFunc) rygel_import_resource_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_import_resource_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_import_resource_type_id;
		rygel_import_resource_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelImportResource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_import_resource_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_import_resource_type_id__volatile, rygel_import_resource_type_id);
	}
	return rygel_import_resource_type_id__volatile;
}


static void _vala_rygel_import_resource_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelImportResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	switch (property_id) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		case RYGEL_IMPORT_RESOURCE_STATUS_AS_STRING:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_value_set_string (value, rygel_import_resource_get_status_as_string (self));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		break;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		case RYGEL_IMPORT_RESOURCE_CANCELLABLE:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		break;
#line 2314 "rygel-import-resource.c"
		default:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		break;
#line 2320 "rygel-import-resource.c"
	}
}


static void _vala_rygel_import_resource_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelImportResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
	switch (property_id) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		case RYGEL_IMPORT_RESOURCE_CANCELLABLE:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		break;
#line 2336 "rygel-import-resource.c"
		default:
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-import-resource.vala"
		break;
#line 2342 "rygel-import-resource.c"
	}
}



