/* rygel-http-thumbnail-handler.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-http-thumbnail-handler.vala, do not modify */

/*
 * Copyright (C) 2008, 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER (rygel_http_thumbnail_handler_get_type ())
#define RYGEL_HTTP_THUMBNAIL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandler))
#define RYGEL_HTTP_THUMBNAIL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandlerClass))
#define RYGEL_IS_HTTP_THUMBNAIL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER))
#define RYGEL_IS_HTTP_THUMBNAIL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER))
#define RYGEL_HTTP_THUMBNAIL_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandlerClass))

typedef struct _RygelHTTPThumbnailHandler RygelHTTPThumbnailHandler;
typedef struct _RygelHTTPThumbnailHandlerClass RygelHTTPThumbnailHandlerClass;
typedef struct _RygelHTTPThumbnailHandlerPrivate RygelHTTPThumbnailHandlerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gchar* (*get_default_transfer_mode) (RygelHTTPGetHandler* self);
	gboolean (*supports_transfer_mode) (RygelHTTPGetHandler* self, const gchar* mode);
	gint64 (*get_resource_size) (RygelHTTPGetHandler* self);
	gint64 (*get_resource_duration) (RygelHTTPGetHandler* self);
	gboolean (*supports_byte_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_time_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_playspeed) (RygelHTTPGetHandler* self);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPThumbnailHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPThumbnailHandlerPrivate * priv;
};

struct _RygelHTTPThumbnailHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPThumbnailHandlerPrivate {
	RygelMediaFileItem* media_item;
	gint thumbnail_index;
	RygelThumbnail* thumbnail;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};


static gpointer rygel_http_thumbnail_handler_parent_class = NULL;

GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_http_thumbnail_handler_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_THUMBNAIL_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandlerPrivate))
enum  {
	RYGEL_HTTP_THUMBNAIL_HANDLER_DUMMY_PROPERTY
};
RygelHTTPThumbnailHandler* rygel_http_thumbnail_handler_new (RygelMediaFileItem* media_item, gint thumbnail_index, GCancellable* cancellable, GError** error);
RygelHTTPThumbnailHandler* rygel_http_thumbnail_handler_construct (GType object_type, RygelMediaFileItem* media_item, gint thumbnail_index, GCancellable* cancellable, GError** error);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
void rygel_http_get_handler_set_cancellable (RygelHTTPGetHandler* self, GCancellable* value);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
RygelThumbnail* rygel_music_item_get_album_art (RygelMusicItem* self);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
static gboolean rygel_http_thumbnail_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base, const gchar* mode);
#define RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_STREAMING "Streaming"
static void rygel_http_thumbnail_handler_real_add_response_headers (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
RygelMediaResource* rygel_thumbnail_get_resource (RygelThumbnail* self, const gchar* protocol, gint index);
gchar* rygel_http_server_get_protocol (RygelHTTPServer* self);
GUPnPProtocolInfo* rygel_media_resource_get_protocol_info (RygelMediaResource* self, GHashTable* replacements);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
static RygelHTTPResponse* rygel_http_thumbnail_handler_real_render_body (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error);
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
RygelMediaEngine* rygel_media_engine_get_default (void);
RygelDataSource* rygel_media_engine_create_data_source_for_uri (RygelMediaEngine* self, const gchar* uri, GError** error);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
static gint64 rygel_http_thumbnail_handler_real_get_resource_size (RygelHTTPGetHandler* base);
static gboolean rygel_http_thumbnail_handler_real_supports_byte_seek (RygelHTTPGetHandler* base);
static void rygel_http_thumbnail_handler_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	return self ? g_object_ref (self) : NULL;
#line 395 "rygel-http-thumbnail-handler.c"
}


static gpointer _rygel_icon_info_ref0 (gpointer self) {
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	return self ? rygel_icon_info_ref (self) : NULL;
#line 402 "rygel-http-thumbnail-handler.c"
}


RygelHTTPThumbnailHandler* rygel_http_thumbnail_handler_construct (GType object_type, RygelMediaFileItem* media_item, gint thumbnail_index, GCancellable* cancellable, GError** error) {
	RygelHTTPThumbnailHandler * self = NULL;
	RygelMediaFileItem* _tmp0_ = NULL;
	RygelMediaFileItem* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GCancellable* _tmp3_ = NULL;
	RygelMediaFileItem* _tmp4_ = NULL;
	RygelThumbnail* _tmp25_ = NULL;
	GError * _inner_error_ = NULL;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	g_return_val_if_fail (media_item != NULL, NULL);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	self = (RygelHTTPThumbnailHandler*) rygel_http_get_handler_construct (object_type);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp0_ = media_item;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_g_object_unref0 (self->priv->media_item);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	self->priv->media_item = _tmp1_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp2_ = thumbnail_index;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	self->priv->thumbnail_index = _tmp2_;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp3_ = cancellable;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	rygel_http_get_handler_set_cancellable ((RygelHTTPGetHandler*) self, _tmp3_);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp4_ = media_item;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MUSIC_ITEM)) {
#line 439 "rygel-http-thumbnail-handler.c"
		RygelMusicItem* music_item = NULL;
		RygelMediaFileItem* _tmp5_ = NULL;
		RygelMusicItem* _tmp6_ = NULL;
		RygelMusicItem* _tmp7_ = NULL;
		RygelThumbnail* _tmp8_ = NULL;
		RygelThumbnail* _tmp9_ = NULL;
		RygelThumbnail* _tmp10_ = NULL;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp5_ = media_item;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp5_) : NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		music_item = _tmp6_;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp7_ = music_item;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp8_ = rygel_music_item_get_album_art (_tmp7_);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp9_ = _tmp8_;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp10_ = _rygel_icon_info_ref0 (_tmp9_);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_rygel_icon_info_unref0 (self->priv->thumbnail);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		self->priv->thumbnail = _tmp10_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_g_object_unref0 (music_item);
#line 467 "rygel-http-thumbnail-handler.c"
	} else {
		RygelMediaFileItem* _tmp11_ = NULL;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp11_ = media_item;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_VISUAL_ITEM)) {
#line 474 "rygel-http-thumbnail-handler.c"
			RygelVisualItem* visual_item = NULL;
			RygelMediaFileItem* _tmp12_ = NULL;
			RygelVisualItem* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			RygelVisualItem* _tmp15_ = NULL;
			GeeArrayList* _tmp16_ = NULL;
			GeeArrayList* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_tmp12_ = media_item;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp12_) : NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			visual_item = _tmp13_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_tmp14_ = thumbnail_index;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_tmp15_ = visual_item;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_tmp16_ = rygel_visual_item_get_thumbnails (_tmp15_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_tmp17_ = _tmp16_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_tmp18_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp17_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_tmp19_ = _tmp18_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			if (_tmp14_ < _tmp19_) {
#line 504 "rygel-http-thumbnail-handler.c"
				RygelVisualItem* _tmp20_ = NULL;
				GeeArrayList* _tmp21_ = NULL;
				GeeArrayList* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				gpointer _tmp24_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
				_tmp20_ = visual_item;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
				_tmp21_ = rygel_visual_item_get_thumbnails (_tmp20_);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
				_tmp22_ = _tmp21_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
				_tmp23_ = thumbnail_index;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
				_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _tmp23_);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
				_rygel_icon_info_unref0 (self->priv->thumbnail);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
				self->priv->thumbnail = (RygelThumbnail*) _tmp24_;
#line 524 "rygel-http-thumbnail-handler.c"
			}
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_g_object_unref0 (visual_item);
#line 528 "rygel-http-thumbnail-handler.c"
		}
	}
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp25_ = self->priv->thumbnail;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	if (_tmp25_ == NULL) {
#line 535 "rygel-http-thumbnail-handler.c"
		gint _tmp26_ = 0;
		RygelMediaFileItem* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		GError* _tmp30_ = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp26_ = thumbnail_index;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp27_ = media_item;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp28_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp27_);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp29_ = _tmp28_;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp30_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "Thumbnail index %d not found for item '%s", _tmp26_, _tmp29_);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_inner_error_ = _tmp30_;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			g_propagate_error (error, _inner_error_);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_g_object_unref0 (self);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			return NULL;
#line 561 "rygel-http-thumbnail-handler.c"
		} else {
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			g_clear_error (&_inner_error_);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			return NULL;
#line 569 "rygel-http-thumbnail-handler.c"
		}
	}
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	return self;
#line 574 "rygel-http-thumbnail-handler.c"
}


RygelHTTPThumbnailHandler* rygel_http_thumbnail_handler_new (RygelMediaFileItem* media_item, gint thumbnail_index, GCancellable* cancellable, GError** error) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	return rygel_http_thumbnail_handler_construct (RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, media_item, thumbnail_index, cancellable, error);
#line 581 "rygel-http-thumbnail-handler.c"
}


static gboolean rygel_http_thumbnail_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base, const gchar* mode) {
	RygelHTTPThumbnailHandler * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	self = (RygelHTTPThumbnailHandler*) base;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	g_return_val_if_fail (mode != NULL, FALSE);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp0_ = mode;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	result = g_strcmp0 (_tmp0_, RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_STREAMING) != 0;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	return result;
#line 599 "rygel-http-thumbnail-handler.c"
}


static void rygel_http_thumbnail_handler_real_add_response_headers (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error) {
	RygelHTTPThumbnailHandler * self;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	RygelThumbnail* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	RygelMediaResource* res = NULL;
	RygelThumbnail* _tmp5_ = NULL;
	RygelHTTPGet* _tmp6_ = NULL;
	RygelHTTPServer* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	RygelMediaResource* _tmp11_ = NULL;
	RygelMediaResource* _tmp12_ = NULL;
	gchar* protocol_info = NULL;
	GUPnPProtocolInfo* _tmp13_ = NULL;
	GUPnPProtocolInfo* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar** pi_fields = NULL;
	gchar** _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint pi_fields_length1 = 0;
	gint _pi_fields_size_ = 0;
	RygelHTTPGet* _tmp19_ = NULL;
	SoupMessage* _tmp20_ = NULL;
	SoupMessageHeaders* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	RygelHTTPGet* _tmp23_ = NULL;
	GError * _inner_error_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	self = (RygelHTTPThumbnailHandler*) base;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	g_return_if_fail (request != NULL);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp0_ = request;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp2_ = _tmp1_->response_headers;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp3_ = self->priv->thumbnail;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp4_ = ((RygelIconInfo*) _tmp3_)->mime_type;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	soup_message_headers_append (_tmp2_, "Content-Type", _tmp4_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp5_ = self->priv->thumbnail;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp6_ = request;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp7_ = ((RygelHTTPRequest*) _tmp6_)->http_server;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp8_ = rygel_http_server_get_protocol (_tmp7_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp9_ = _tmp8_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp10_ = self->priv->thumbnail_index;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp11_ = rygel_thumbnail_get_resource (_tmp5_, _tmp9_, _tmp10_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp12_ = _tmp11_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_g_free0 (_tmp9_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	res = _tmp12_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp13_ = rygel_media_resource_get_protocol_info (res, NULL);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp14_ = _tmp13_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp15_ = gupnp_protocol_info_to_string (_tmp14_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp16_ = _tmp15_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_g_object_unref0 (_tmp14_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	protocol_info = _tmp16_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp18_ = _tmp17_ = g_strsplit (protocol_info, ":", 4);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	pi_fields = _tmp18_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	pi_fields_length1 = _vala_array_length (_tmp17_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_pi_fields_size_ = pi_fields_length1;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp19_ = request;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp20_ = ((RygelHTTPRequest*) _tmp19_)->msg;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp21_ = _tmp20_->response_headers;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp22_ = pi_fields[3];
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	soup_message_headers_append (_tmp21_, "contentFeatures.dlna.org", _tmp22_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp23_ = request;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	RYGEL_HTTP_GET_HANDLER_CLASS (rygel_http_thumbnail_handler_parent_class)->add_response_headers (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler), _tmp23_, &_inner_error_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			g_propagate_error (error, _inner_error_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_g_free0 (protocol_info);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_g_object_unref0 (res);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			return;
#line 719 "rygel-http-thumbnail-handler.c"
		} else {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_g_free0 (protocol_info);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_g_object_unref0 (res);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			g_clear_error (&_inner_error_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			return;
#line 733 "rygel-http-thumbnail-handler.c"
		}
	}
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_g_free0 (protocol_info);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_g_object_unref0 (res);
#line 742 "rygel-http-thumbnail-handler.c"
}


static RygelHTTPResponse* rygel_http_thumbnail_handler_real_render_body (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error) {
	RygelHTTPThumbnailHandler * self;
	RygelHTTPResponse* result = NULL;
	RygelDataSource* src = NULL;
	GError * _inner_error_ = NULL;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	self = (RygelHTTPThumbnailHandler*) base;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 755 "rygel-http-thumbnail-handler.c"
	{
		RygelMediaEngine* engine = NULL;
		RygelMediaEngine* _tmp0_ = NULL;
		RygelDataSource* _tmp1_ = NULL;
		RygelMediaEngine* _tmp2_ = NULL;
		RygelThumbnail* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		RygelDataSource* _tmp5_ = NULL;
		RygelDataSource* _tmp6_ = NULL;
		RygelHTTPResponse* _tmp7_ = NULL;
		RygelHTTPGet* _tmp8_ = NULL;
		RygelDataSource* _tmp9_ = NULL;
		RygelHTTPResponse* _tmp10_ = NULL;
		RygelHTTPResponse* _tmp11_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp0_ = rygel_media_engine_get_default ();
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		engine = _tmp0_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp2_ = engine;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp3_ = self->priv->thumbnail;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp4_ = ((RygelIconInfo*) _tmp3_)->uri;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp5_ = rygel_media_engine_create_data_source_for_uri (_tmp2_, _tmp4_, &_inner_error_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp1_ = _tmp5_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_g_object_unref0 (engine);
#line 788 "rygel-http-thumbnail-handler.c"
			goto __catch40_g_error;
		}
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp6_ = _tmp1_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp1_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_g_object_unref0 (src);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		src = _tmp6_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp8_ = request;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp9_ = src;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp10_ = rygel_http_response_new (_tmp8_, (RygelHTTPGetHandler*) self, _tmp9_, &_inner_error_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp7_ = _tmp10_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_g_object_unref0 (_tmp1_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
			_g_object_unref0 (engine);
#line 813 "rygel-http-thumbnail-handler.c"
			goto __catch40_g_error;
		}
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp11_ = _tmp7_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp7_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		result = _tmp11_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_g_object_unref0 (_tmp7_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_g_object_unref0 (_tmp1_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_g_object_unref0 (engine);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_g_object_unref0 (src);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		return result;
#line 832 "rygel-http-thumbnail-handler.c"
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		err = _inner_error_;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_inner_error_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp12_ = err;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp13_ = _tmp12_->message;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_tmp14_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp13_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_inner_error_ = _tmp14_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_g_error_free0 (err);
#line 855 "rygel-http-thumbnail-handler.c"
		goto __finally40;
	}
	__finally40:
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		g_propagate_error (error, _inner_error_);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_g_object_unref0 (src);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		return NULL;
#line 867 "rygel-http-thumbnail-handler.c"
	} else {
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		_g_object_unref0 (src);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		g_clear_error (&_inner_error_);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
		return NULL;
#line 877 "rygel-http-thumbnail-handler.c"
	}
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_g_object_unref0 (src);
#line 881 "rygel-http-thumbnail-handler.c"
}


static gint64 rygel_http_thumbnail_handler_real_get_resource_size (RygelHTTPGetHandler* base) {
	RygelHTTPThumbnailHandler * self;
	gint64 result = 0LL;
	RygelThumbnail* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	self = (RygelHTTPThumbnailHandler*) base;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp0_ = self->priv->thumbnail;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_tmp1_ = ((RygelIconInfo*) _tmp0_)->size;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	result = _tmp1_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	return result;
#line 900 "rygel-http-thumbnail-handler.c"
}


static gboolean rygel_http_thumbnail_handler_real_supports_byte_seek (RygelHTTPGetHandler* base) {
	RygelHTTPThumbnailHandler * self;
	gboolean result = FALSE;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	self = (RygelHTTPThumbnailHandler*) base;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	result = TRUE;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	return result;
#line 913 "rygel-http-thumbnail-handler.c"
}


static void rygel_http_thumbnail_handler_class_init (RygelHTTPThumbnailHandlerClass * klass) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	rygel_http_thumbnail_handler_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPThumbnailHandlerPrivate));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->supports_transfer_mode = rygel_http_thumbnail_handler_real_supports_transfer_mode;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->add_response_headers = rygel_http_thumbnail_handler_real_add_response_headers;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->render_body = rygel_http_thumbnail_handler_real_render_body;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->get_resource_size = rygel_http_thumbnail_handler_real_get_resource_size;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->supports_byte_seek = rygel_http_thumbnail_handler_real_supports_byte_seek;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_thumbnail_handler_finalize;
#line 934 "rygel-http-thumbnail-handler.c"
}


static void rygel_http_thumbnail_handler_instance_init (RygelHTTPThumbnailHandler * self) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	self->priv = RYGEL_HTTP_THUMBNAIL_HANDLER_GET_PRIVATE (self);
#line 941 "rygel-http-thumbnail-handler.c"
}


static void rygel_http_thumbnail_handler_finalize (GObject* obj) {
	RygelHTTPThumbnailHandler * self;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandler);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_g_object_unref0 (self->priv->media_item);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	_rygel_icon_info_unref0 (self->priv->thumbnail);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-thumbnail-handler.vala"
	G_OBJECT_CLASS (rygel_http_thumbnail_handler_parent_class)->finalize (obj);
#line 955 "rygel-http-thumbnail-handler.c"
}


GType rygel_http_thumbnail_handler_get_type (void) {
	static volatile gsize rygel_http_thumbnail_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_thumbnail_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPThumbnailHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_thumbnail_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPThumbnailHandler), 0, (GInstanceInitFunc) rygel_http_thumbnail_handler_instance_init, NULL };
		GType rygel_http_thumbnail_handler_type_id;
		rygel_http_thumbnail_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPThumbnailHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_thumbnail_handler_type_id__volatile, rygel_http_thumbnail_handler_type_id);
	}
	return rygel_http_thumbnail_handler_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



