/* rygel-log-handler.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-log-handler.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())

#define RYGEL_TYPE_LOG_HANDLER (rygel_log_handler_get_type ())
#define RYGEL_LOG_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOG_HANDLER, RygelLogHandler))
#define RYGEL_LOG_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerClass))
#define RYGEL_IS_LOG_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOG_HANDLER))
#define RYGEL_IS_LOG_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOG_HANDLER))
#define RYGEL_LOG_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerClass))

typedef struct _RygelLogHandler RygelLogHandler;
typedef struct _RygelLogHandlerClass RygelLogHandlerClass;
typedef struct _RygelLogHandlerPrivate RygelLogHandlerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelLogHandler {
	GObject parent_instance;
	RygelLogHandlerPrivate * priv;
};

struct _RygelLogHandlerClass {
	GObjectClass parent_class;
};

struct _RygelLogHandlerPrivate {
	GeeHashMap* log_level_hash;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};


static gpointer rygel_log_handler_parent_class = NULL;
static RygelLogHandler* rygel_log_handler_log_handler;
static RygelLogHandler* rygel_log_handler_log_handler = NULL;

GType rygel_log_level_get_type (void) G_GNUC_CONST;
GType rygel_log_handler_get_type (void) G_GNUC_CONST;
#define RYGEL_LOG_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerPrivate))
enum  {
	RYGEL_LOG_HANDLER_DUMMY_PROPERTY
};
#define RYGEL_LOG_HANDLER_DEFAULT_LEVELS "*:4"
#define RYGEL_LOG_HANDLER_DEFAULT_FLAGS ((((G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR) | G_LOG_LEVEL_MESSAGE) | G_LOG_LEVEL_INFO)
RygelLogHandler* rygel_log_handler_get_default (void);
static RygelLogHandler* rygel_log_handler_new (void);
static RygelLogHandler* rygel_log_handler_construct (GType object_type);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gchar* rygel_configuration_get_log_levels (RygelConfiguration* self, GError** error);
static GLogLevelFlags rygel_log_handler_log_level_to_flags (RygelLogHandler* self, RygelLogLevel level);
static void rygel_log_handler_log_func (RygelLogHandler* self, const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message);
static void _rygel_log_handler_log_func_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void rygel_log_handler_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType rygel_log_level_get_type (void) {
	static volatile gsize rygel_log_level_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_log_level_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_LOG_LEVEL_INVALID, "RYGEL_LOG_LEVEL_INVALID", "invalid"}, {RYGEL_LOG_LEVEL_CRITICAL, "RYGEL_LOG_LEVEL_CRITICAL", "critical"}, {RYGEL_LOG_LEVEL_ERROR, "RYGEL_LOG_LEVEL_ERROR", "error"}, {RYGEL_LOG_LEVEL_WARNING, "RYGEL_LOG_LEVEL_WARNING", "warning"}, {RYGEL_LOG_LEVEL_INFO, "RYGEL_LOG_LEVEL_INFO", "info"}, {RYGEL_LOG_LEVEL_DEFAULT, "RYGEL_LOG_LEVEL_DEFAULT", "default"}, {RYGEL_LOG_LEVEL_DEBUG, "RYGEL_LOG_LEVEL_DEBUG", "debug"}, {0, NULL, NULL}};
		GType rygel_log_level_type_id;
		rygel_log_level_type_id = g_enum_register_static ("RygelLogLevel", values);
		g_once_init_leave (&rygel_log_level_type_id__volatile, rygel_log_level_type_id);
	}
	return rygel_log_level_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	return self ? g_object_ref (self) : NULL;
#line 162 "rygel-log-handler.c"
}


RygelLogHandler* rygel_log_handler_get_default (void) {
	RygelLogHandler* result = NULL;
	RygelLogHandler* _tmp0_ = NULL;
	RygelLogHandler* _tmp2_ = NULL;
	RygelLogHandler* _tmp3_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_tmp0_ = rygel_log_handler_log_handler;
#line 49 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	if (_tmp0_ == NULL) {
#line 175 "rygel-log-handler.c"
		RygelLogHandler* _tmp1_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp1_ = rygel_log_handler_new ();
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_g_object_unref0 (rygel_log_handler_log_handler);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		rygel_log_handler_log_handler = _tmp1_;
#line 183 "rygel-log-handler.c"
	}
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_tmp2_ = rygel_log_handler_log_handler;
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	result = _tmp3_;
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	return result;
#line 193 "rygel-log-handler.c"
}


static void _rygel_log_handler_log_func_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	rygel_log_handler_log_func ((RygelLogHandler*) self, log_domain, log_levels, message);
#line 200 "rygel-log-handler.c"
}


static RygelLogHandler* rygel_log_handler_construct (GType object_type) {
	RygelLogHandler * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp1_ = NULL;
	gchar* log_levels = NULL;
	const gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	self = (RygelLogHandler*) g_object_new (object_type, NULL);
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_g_object_unref0 (self->priv->log_level_hash);
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	self->priv->log_level_hash = _tmp0_;
#line 60 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_tmp1_ = rygel_meta_config_get_default ();
#line 60 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	config = _tmp1_;
#line 226 "rygel-log-handler.c"
	{
		gchar* _tmp2_ = NULL;
		RygelMetaConfig* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp3_ = config;
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp4_ = rygel_configuration_get_log_levels ((RygelConfiguration*) _tmp3_, &_inner_error_);
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp2_ = _tmp4_;
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 240 "rygel-log-handler.c"
			goto __catch16_g_error;
		}
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp5_ = _tmp2_;
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp2_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_g_free0 (log_levels);
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		log_levels = _tmp5_;
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_g_free0 (_tmp2_);
#line 253 "rygel-log-handler.c"
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* err = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		err = _inner_error_;
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_inner_error_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp6_ = g_strdup (RYGEL_LOG_HANDLER_DEFAULT_LEVELS);
#line 66 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_g_free0 (log_levels);
#line 66 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		log_levels = _tmp6_;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp7_ = _ ("Failed to get log level from configuration: %s");
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp8_ = err;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp9_ = _tmp8_->message;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		g_warning (_tmp7_, _tmp9_);
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_g_error_free0 (err);
#line 283 "rygel-log-handler.c"
	}
	__finally16:
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_g_free0 (log_levels);
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_g_object_unref0 (config);
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		g_clear_error (&_inner_error_);
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		return NULL;
#line 298 "rygel-log-handler.c"
	}
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_tmp10_ = log_levels;
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, ",", 0);
#line 304 "rygel-log-handler.c"
	{
		gchar** pair_collection = NULL;
		gint pair_collection_length1 = 0;
		gint _pair_collection_size_ = 0;
		gint pair_it = 0;
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		pair_collection = _tmp12_;
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		pair_collection_length1 = _vala_array_length (_tmp11_);
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		for (pair_it = 0; pair_it < _vala_array_length (_tmp11_); pair_it = pair_it + 1) {
#line 316 "rygel-log-handler.c"
			gchar* _tmp13_ = NULL;
			gchar* pair = NULL;
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
			_tmp13_ = g_strdup (pair_collection[pair_it]);
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
			pair = _tmp13_;
#line 323 "rygel-log-handler.c"
			{
				gchar** tokens = NULL;
				const gchar* _tmp14_ = NULL;
				gchar** _tmp15_ = NULL;
				gchar** _tmp16_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gchar** _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				gchar* domain = NULL;
				RygelLogLevel level = 0;
				gchar** _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				GLogLevelFlags flags = 0;
				RygelLogLevel _tmp29_ = 0;
				GLogLevelFlags _tmp30_ = 0;
				GeeHashMap* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				GLogLevelFlags _tmp33_ = 0;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				_tmp14_ = pair;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, ":", 0);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				tokens = _tmp16_;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				tokens_length1 = _vala_array_length (_tmp15_);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				_tokens_size_ = tokens_length1;
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				_tmp17_ = tokens;
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				_tmp17__length1 = tokens_length1;
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				if (_tmp17__length1 < 1) {
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_g_free0 (pair);
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					break;
#line 365 "rygel-log-handler.c"
				}
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				_tmp18_ = tokens;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				_tmp18__length1 = tokens_length1;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				if (_tmp18__length1 == 1) {
#line 373 "rygel-log-handler.c"
					gchar** _tmp19_ = NULL;
					gint _tmp19__length1 = 0;
					const gchar* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					gchar* _tmp22_ = NULL;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_tmp19_ = tokens;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_tmp19__length1 = tokens_length1;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_tmp20_ = _tmp19_[0];
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_tmp21_ = atoi (_tmp20_);
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					level = (RygelLogLevel) _tmp21_;
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_tmp22_ = g_strdup ("*");
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_g_free0 (domain);
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					domain = _tmp22_;
#line 395 "rygel-log-handler.c"
				} else {
					gchar** _tmp23_ = NULL;
					gint _tmp23__length1 = 0;
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar** _tmp26_ = NULL;
					gint _tmp26__length1 = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_tmp23_ = tokens;
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_tmp23__length1 = tokens_length1;
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_tmp24_ = _tmp23_[0];
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_tmp25_ = g_strdup (_tmp24_);
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_g_free0 (domain);
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					domain = _tmp25_;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_tmp26_ = tokens;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_tmp26__length1 = tokens_length1;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_tmp27_ = _tmp26_[1];
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					_tmp28_ = atoi (_tmp27_);
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
					level = (RygelLogLevel) _tmp28_;
#line 427 "rygel-log-handler.c"
				}
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				_tmp29_ = level;
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				_tmp30_ = rygel_log_handler_log_level_to_flags (self, _tmp29_);
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				flags = _tmp30_;
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				_tmp31_ = self->priv->log_level_hash;
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				_tmp32_ = domain;
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				_tmp33_ = flags;
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, _tmp32_, (gpointer) ((gintptr) _tmp33_));
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				_g_free0 (domain);
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
				_g_free0 (pair);
#line 449 "rygel-log-handler.c"
			}
		}
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		pair_collection = (_vala_array_free (pair_collection, pair_collection_length1, (GDestroyNotify) g_free), NULL);
#line 454 "rygel-log-handler.c"
	}
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	g_log_set_default_handler (_rygel_log_handler_log_func_glog_func, self);
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_g_free0 (log_levels);
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_g_object_unref0 (config);
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	return self;
#line 464 "rygel-log-handler.c"
}


static RygelLogHandler* rygel_log_handler_new (void) {
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	return rygel_log_handler_construct (RYGEL_TYPE_LOG_HANDLER);
#line 471 "rygel-log-handler.c"
}


static void rygel_log_handler_log_func (RygelLogHandler* self, const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message) {
	GLogLevelFlags flags = 0;
	const gchar* _tmp0_ = NULL;
	GLogLevelFlags _tmp4_ = 0;
	GLogLevelFlags _tmp7_ = 0;
	GLogLevelFlags _tmp8_ = 0;
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	g_return_if_fail (self != NULL);
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	g_return_if_fail (message != NULL);
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	flags = 0;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_tmp0_ = log_domain;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	if (_tmp0_ != NULL) {
#line 491 "rygel-log-handler.c"
		GeeHashMap* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gpointer _tmp3_ = NULL;
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp1_ = self->priv->log_level_hash;
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp2_ = log_domain;
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		flags = (GLogLevelFlags) ((gintptr) _tmp3_);
#line 503 "rygel-log-handler.c"
	}
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_tmp4_ = flags;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	if (_tmp4_ == 0) {
#line 509 "rygel-log-handler.c"
		GeeHashMap* _tmp5_ = NULL;
		gpointer _tmp6_ = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp5_ = self->priv->log_level_hash;
#line 107 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, "*");
#line 107 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		flags = (GLogLevelFlags) ((gintptr) _tmp6_);
#line 518 "rygel-log-handler.c"
	}
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_tmp7_ = log_levels;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_tmp8_ = flags;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	if ((_tmp8_ & _tmp7_) == _tmp7_) {
#line 526 "rygel-log-handler.c"
		GLogFunc _tmp9_ = NULL;
		void* _tmp9__target = NULL;
		const gchar* _tmp10_ = NULL;
		GLogLevelFlags _tmp11_ = 0;
		const gchar* _tmp12_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp9_ = g_log_default_handler;
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp9__target = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp10_ = log_domain;
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp11_ = log_levels;
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp12_ = message;
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		_tmp9_ (_tmp10_, _tmp11_, _tmp12_, _tmp9__target);
#line 544 "rygel-log-handler.c"
	}
}


static GLogLevelFlags rygel_log_handler_log_level_to_flags (RygelLogHandler* self, RygelLogLevel level) {
	GLogLevelFlags result = 0;
	GLogLevelFlags flags = 0;
	RygelLogLevel _tmp0_ = 0;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 117 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	flags = RYGEL_LOG_HANDLER_DEFAULT_FLAGS;
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_tmp0_ = level;
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	switch (_tmp0_) {
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		case RYGEL_LOG_LEVEL_CRITICAL:
#line 563 "rygel-log-handler.c"
		{
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
			flags = G_LOG_LEVEL_CRITICAL;
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
			break;
#line 569 "rygel-log-handler.c"
		}
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		case RYGEL_LOG_LEVEL_ERROR:
#line 573 "rygel-log-handler.c"
		{
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
			flags = G_LOG_LEVEL_CRITICAL | G_LOG_LEVEL_ERROR;
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
			break;
#line 579 "rygel-log-handler.c"
		}
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		case RYGEL_LOG_LEVEL_WARNING:
#line 583 "rygel-log-handler.c"
		{
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
			flags = (G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
			break;
#line 589 "rygel-log-handler.c"
		}
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		case RYGEL_LOG_LEVEL_INFO:
#line 593 "rygel-log-handler.c"
		{
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
			flags = (((G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR) | G_LOG_LEVEL_MESSAGE) | G_LOG_LEVEL_INFO;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
			break;
#line 599 "rygel-log-handler.c"
		}
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
		case RYGEL_LOG_LEVEL_DEBUG:
#line 603 "rygel-log-handler.c"
		{
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
			flags = ((((G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR) | G_LOG_LEVEL_MESSAGE) | G_LOG_LEVEL_INFO) | G_LOG_LEVEL_DEBUG;
#line 146 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
			break;
#line 609 "rygel-log-handler.c"
		}
		default:
		{
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
			flags = RYGEL_LOG_HANDLER_DEFAULT_FLAGS;
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
			break;
#line 617 "rygel-log-handler.c"
		}
	}
#line 152 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	result = flags;
#line 152 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	return result;
#line 624 "rygel-log-handler.c"
}


static void rygel_log_handler_class_init (RygelLogHandlerClass * klass) {
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	rygel_log_handler_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	g_type_class_add_private (klass, sizeof (RygelLogHandlerPrivate));
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_log_handler_finalize;
#line 635 "rygel-log-handler.c"
}


static void rygel_log_handler_instance_init (RygelLogHandler * self) {
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	self->priv = RYGEL_LOG_HANDLER_GET_PRIVATE (self);
#line 642 "rygel-log-handler.c"
}


static void rygel_log_handler_finalize (GObject* obj) {
	RygelLogHandler * self;
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_LOG_HANDLER, RygelLogHandler);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	_g_object_unref0 (self->priv->log_level_hash);
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-log-handler.vala"
	G_OBJECT_CLASS (rygel_log_handler_parent_class)->finalize (obj);
#line 654 "rygel-log-handler.c"
}


GType rygel_log_handler_get_type (void) {
	static volatile gsize rygel_log_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_log_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelLogHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_log_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLogHandler), 0, (GInstanceInitFunc) rygel_log_handler_instance_init, NULL };
		GType rygel_log_handler_type_id;
		rygel_log_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelLogHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_log_handler_type_id__volatile, rygel_log_handler_type_id);
	}
	return rygel_log_handler_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



