/* rygel-http-get.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-http-get.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *         Parthiban Balasubramanian <P.Balasubramanian-contractor@cablelabs.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER (rygel_http_media_resource_handler_get_type ())
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandler))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))

typedef struct _RygelHTTPMediaResourceHandler RygelHTTPMediaResourceHandler;
typedef struct _RygelHTTPMediaResourceHandlerClass RygelHTTPMediaResourceHandlerClass;

#define RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER (rygel_http_thumbnail_handler_get_type ())
#define RYGEL_HTTP_THUMBNAIL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandler))
#define RYGEL_HTTP_THUMBNAIL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandlerClass))
#define RYGEL_IS_HTTP_THUMBNAIL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER))
#define RYGEL_IS_HTTP_THUMBNAIL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER))
#define RYGEL_HTTP_THUMBNAIL_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandlerClass))

typedef struct _RygelHTTPThumbnailHandler RygelHTTPThumbnailHandler;
typedef struct _RygelHTTPThumbnailHandlerClass RygelHTTPThumbnailHandlerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;

#define RYGEL_TYPE_HTTP_SUBTITLE_HANDLER (rygel_http_subtitle_handler_get_type ())
#define RYGEL_HTTP_SUBTITLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandler))
#define RYGEL_HTTP_SUBTITLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandlerClass))
#define RYGEL_IS_HTTP_SUBTITLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER))
#define RYGEL_IS_HTTP_SUBTITLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER))
#define RYGEL_HTTP_SUBTITLE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandlerClass))

typedef struct _RygelHTTPSubtitleHandler RygelHTTPSubtitleHandler;
typedef struct _RygelHTTPSubtitleHandlerClass RygelHTTPSubtitleHandlerClass;
typedef struct _RygelHttpGetHandleData RygelHttpGetHandleData;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelHttpGetFindItemData RygelHttpGetFindItemData;

#define RYGEL_TYPE_PLAY_SPEED (rygel_play_speed_get_type ())
#define RYGEL_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeed))
#define RYGEL_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))
#define RYGEL_IS_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_IS_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_PLAY_SPEED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))

typedef struct _RygelPlaySpeed RygelPlaySpeed;
typedef struct _RygelPlaySpeedClass RygelPlaySpeedClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST (rygel_dtcp_cleartext_request_get_type ())
#define RYGEL_DTCP_CLEARTEXT_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest))
#define RYGEL_DTCP_CLEARTEXT_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestClass))
#define RYGEL_IS_DTCP_CLEARTEXT_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST))
#define RYGEL_IS_DTCP_CLEARTEXT_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST))
#define RYGEL_DTCP_CLEARTEXT_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestClass))

typedef struct _RygelDTCPCleartextRequest RygelDTCPCleartextRequest;
typedef struct _RygelDTCPCleartextRequestClass RygelDTCPCleartextRequestClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST (rygel_http_byte_seek_request_get_type ())
#define RYGEL_HTTP_BYTE_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest))
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestClass))
#define RYGEL_IS_HTTP_BYTE_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST))
#define RYGEL_IS_HTTP_BYTE_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST))
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestClass))

typedef struct _RygelHTTPByteSeekRequest RygelHTTPByteSeekRequest;
typedef struct _RygelHTTPByteSeekRequestClass RygelHTTPByteSeekRequestClass;

#define RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST (rygel_http_time_seek_request_get_type ())
#define RYGEL_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequest))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))

typedef struct _RygelHTTPTimeSeekRequest RygelHTTPTimeSeekRequest;
typedef struct _RygelHTTPTimeSeekRequestClass RygelHTTPTimeSeekRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelHttpGetHandleItemRequestData RygelHttpGetHandleItemRequestData;

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelHTTPSeekRequest* seek;
	RygelPlaySpeedRequest* speed_request;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHttpGetHandleData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	gboolean _tmp0_;
	SoupMessage* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	SoupMessage* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GError* _tmp11_;
	gchar* cf_header;
	gchar* _tmp12_;
	gchar* cf_val;
	SoupMessage* _tmp13_;
	SoupMessageHeaders* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	GError* _tmp25_;
	GError* _tmp26_;
	RygelHTTPItemURI* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	RygelHTTPMediaResourceHandler* _tmp30_;
	RygelMediaObject* _tmp31_;
	RygelHTTPItemURI* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GCancellable* _tmp35_;
	GCancellable* _tmp36_;
	RygelHTTPMediaResourceHandler* _tmp37_;
	RygelHTTPMediaResourceHandler* _tmp38_;
	RygelHTTPItemURI* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	RygelHTTPThumbnailHandler* _tmp42_;
	RygelMediaObject* _tmp43_;
	RygelHTTPItemURI* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	GCancellable* _tmp47_;
	GCancellable* _tmp48_;
	RygelHTTPThumbnailHandler* _tmp49_;
	RygelHTTPThumbnailHandler* _tmp50_;
	RygelHTTPItemURI* _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	RygelHTTPSubtitleHandler* _tmp54_;
	RygelMediaObject* _tmp55_;
	RygelHTTPItemURI* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	GCancellable* _tmp59_;
	GCancellable* _tmp60_;
	RygelHTTPSubtitleHandler* _tmp61_;
	RygelHTTPSubtitleHandler* _tmp62_;
	RygelHTTPItemURI* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	GError* _tmp66_;
	GError* _tmp67_;
	gchar* transfer_mode;
	SoupMessage* _tmp68_;
	SoupMessageHeaders* _tmp69_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
	const gchar* _tmp72_;
	RygelHTTPGetHandler* _tmp73_;
	gchar* _tmp74_;
	RygelHTTPGetHandler* _tmp75_;
	const gchar* _tmp76_;
	gboolean _tmp77_;
	const gchar* _tmp78_;
	RygelHTTPItemURI* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	GError* _tmp82_;
	GError* _tmp83_;
	GError * _inner_error_;
};

struct _RygelHttpGetFindItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	RygelMediaObject* _tmp0_;
	gboolean _tmp1_;
	RygelMediaObject* _tmp2_;
	RygelMediaObject* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	RygelMediaObject* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	RygelClientHacks* _tmp11_;
	RygelClientHacks* _tmp12_;
	RygelMediaObject* _tmp13_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT,
	RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT
} RygelPlaySpeedError;
#define RYGEL_PLAY_SPEED_ERROR rygel_play_speed_error_quark ()
typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()
struct _RygelHttpGetHandleItemRequestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	gboolean supports_time_seek;
	gboolean _tmp0_;
	gboolean requested_time_seek;
	gboolean _tmp1_;
	gboolean supports_byte_seek;
	gboolean _tmp2_;
	gboolean requested_byte_seek;
	gboolean _tmp3_;
	gboolean supports_cleartext_seek;
	gboolean _tmp4_;
	gboolean requested_cleartext_seek;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	RygelHTTPItemURI* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	gboolean _tmp15_;
	RygelHTTPItemURI* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError* _tmp21_;
	GError* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	RygelHTTPItemURI* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GError* _tmp30_;
	GError* _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	RygelHTTPItemURI* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GError* _tmp39_;
	GError* _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	RygelPlaySpeedRequest* _tmp46_;
	RygelPlaySpeedRequest* _tmp47_;
	RygelPlaySpeedRequest* _tmp48_;
	RygelPlaySpeedRequest* _tmp49_;
	RygelPlaySpeed* _tmp50_;
	RygelPlaySpeed* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	RygelPlaySpeedRequest* _tmp54_;
	RygelPlaySpeed* _tmp55_;
	RygelPlaySpeed* _tmp56_;
	gboolean _tmp57_;
	GError* _error_;
	SoupServer* _tmp58_;
	SoupMessage* _tmp59_;
	GError* _tmp60_;
	GError* _tmp61_;
	const gchar* _tmp62_;
	GError* _tmp63_;
	GError* _tmp64_;
	const gchar* _tmp65_;
	GError* _tmp66_;
	GError* _tmp67_;
	GError* _tmp68_;
	const gchar* _tmp69_;
	gboolean _tmp70_;
	gboolean _tmp71_;
	gboolean _tmp72_;
	RygelDTCPCleartextRequest* cleartext_seek;
	RygelDTCPCleartextRequest* _tmp73_;
	RygelDTCPCleartextRequest* _tmp74_;
	gint64 _tmp75_;
	gint64 _tmp76_;
	RygelDTCPCleartextRequest* _tmp77_;
	gint64 _tmp78_;
	gint64 _tmp79_;
	RygelDTCPCleartextRequest* _tmp80_;
	RygelHTTPSeekRequest* _tmp81_;
	gboolean _tmp82_;
	gboolean _tmp83_;
	gboolean _tmp84_;
	RygelHTTPByteSeekRequest* byte_seek;
	RygelHTTPByteSeekRequest* _tmp85_;
	RygelHTTPByteSeekRequest* _tmp86_;
	gint64 _tmp87_;
	gint64 _tmp88_;
	RygelHTTPByteSeekRequest* _tmp89_;
	gint64 _tmp90_;
	gint64 _tmp91_;
	RygelHTTPByteSeekRequest* _tmp92_;
	RygelHTTPSeekRequest* _tmp93_;
	gboolean _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp96_;
	RygelPlaySpeed* _tmp97_;
	RygelPlaySpeedRequest* _tmp98_;
	RygelPlaySpeedRequest* _tmp99_;
	RygelPlaySpeed* _tmp100_;
	RygelPlaySpeed* _tmp101_;
	RygelHTTPTimeSeekRequest* time_seek;
	RygelHTTPTimeSeekRequest* _tmp102_;
	RygelHTTPTimeSeekRequest* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	RygelHTTPTimeSeekRequest* _tmp108_;
	RygelHTTPSeekRequest* _tmp109_;
	GError* _vala1__error_;
	GError* _tmp110_;
	const gchar* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	SoupServer* _tmp114_;
	SoupMessage* _tmp115_;
	GError* _tmp116_;
	gint _tmp117_;
	GError* _tmp118_;
	const gchar* _tmp119_;
	RygelHTTPGetHandler* _tmp120_;
	RygelHTTPResponse* response;
	RygelHTTPGetHandler* _tmp121_;
	RygelHTTPResponse* _tmp122_;
	GeeList* responses;
	RygelHTTPResponse* _tmp123_;
	GeeList* _tmp124_;
	GeeList* _tmp125_;
	GeeList* _response_elem_list;
	GeeList* _tmp126_;
	GeeList* _tmp127_;
	gint _response_elem_size;
	GeeList* _tmp128_;
	gint _tmp129_;
	gint _tmp130_;
	gint _response_elem_index;
	gint _tmp131_;
	gint _tmp132_;
	gint _tmp133_;
	RygelHTTPResponseElement* response_elem;
	GeeList* _tmp134_;
	gint _tmp135_;
	gpointer _tmp136_;
	RygelHTTPResponseElement* _tmp137_;
	GError* _vala2__error_;
	GError* _tmp138_;
	const gchar* _tmp139_;
	gchar* _tmp140_;
	gchar* _tmp141_;
	SoupServer* _tmp142_;
	SoupMessage* _tmp143_;
	GError* _tmp144_;
	gint _tmp145_;
	GError* _tmp146_;
	const gchar* _tmp147_;
	gint64 response_size;
	SoupMessage* _tmp148_;
	SoupMessageHeaders* _tmp149_;
	gint64 _tmp150_;
	gint64 _tmp151_;
	SoupMessage* _tmp152_;
	SoupMessageHeaders* _tmp153_;
	gint64 _tmp154_;
	gint64 _tmp155_;
	gchar* _tmp156_;
	gchar* _tmp157_;
	gchar* _tmp158_;
	gchar* _tmp159_;
	RygelHTTPGetHandler* _tmp160_;
	gint64 _tmp161_;
	gint64 _tmp162_;
	SoupMessage* _tmp163_;
	SoupMessageHeaders* _tmp164_;
	gint64 _tmp165_;
	gint64 _tmp166_;
	gchar* _tmp167_;
	gchar* _tmp168_;
	gchar* _tmp169_;
	gchar* _tmp170_;
	SoupEncoding response_body_encoding;
	gboolean _tmp171_;
	RygelPlaySpeedRequest* _tmp172_;
	SoupMessage* _tmp173_;
	SoupHTTPVersion _tmp174_;
	gint64 _tmp175_;
	SoupMessage* _tmp176_;
	SoupHTTPVersion _tmp177_;
	SoupMessage* _tmp178_;
	SoupMessageHeaders* _tmp179_;
	SoupEncoding _tmp180_;
	gboolean supports_playspeed;
	gboolean _tmp181_;
	gboolean _tmp182_;
	gboolean _tmp183_;
	gboolean _tmp184_;
	SoupMessage* _tmp185_;
	SoupHTTPVersion _tmp186_;
	GString* vary_header;
	SoupMessage* _tmp187_;
	SoupMessageHeaders* _tmp188_;
	const gchar* _tmp189_;
	GString* _tmp190_;
	gboolean _tmp191_;
	GString* _tmp192_;
	gssize _tmp193_;
	GString* _tmp194_;
	GString* _tmp195_;
	gboolean _tmp196_;
	GString* _tmp197_;
	gssize _tmp198_;
	GString* _tmp199_;
	GString* _tmp200_;
	SoupMessage* _tmp201_;
	SoupMessageHeaders* _tmp202_;
	GString* _tmp203_;
	const gchar* _tmp204_;
	gint response_code;
	SoupMessage* _tmp205_;
	SoupMessageHeaders* _tmp206_;
	const gchar* _tmp207_;
	SoupMessage* _tmp208_;
	gint _tmp209_;
	SoupMessage* _tmp210_;
	SoupHTTPVersion _tmp211_;
	SoupMessage* _tmp212_;
	SoupMessage* _tmp213_;
	SoupMessageHeaders* _tmp214_;
	SoupMessage* _tmp215_;
	SoupMessageHeaders* _tmp216_;
	SoupMessage* _tmp217_;
	gchar* _tmp218_;
	gchar* _tmp219_;
	gchar* _tmp220_;
	gboolean _tmp221_;
	SoupServer* _tmp222_;
	SoupMessage* _tmp223_;
	RygelHTTPResponse* _tmp224_;
	GError * _inner_error_;
};


static gpointer rygel_http_get_parent_class = NULL;

GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_TRANSFER_MODE_HEADER "transferMode.dlna.org"
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
static void rygel_http_get_real_handle_data_free (gpointer _data);
static void rygel_http_get_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_get_real_handle_co (RygelHttpGetHandleData* _data_);
GQuark rygel_http_request_error_quark (void);
const gchar* rygel_http_item_uri_get_resource_name (RygelHTTPItemURI* self);
GType rygel_http_media_resource_handler_get_type (void) G_GNUC_CONST;
RygelHTTPMediaResourceHandler* rygel_http_media_resource_handler_new (RygelMediaObject* media_object, const gchar* media_resource_name, GCancellable* cancellable, GError** error);
RygelHTTPMediaResourceHandler* rygel_http_media_resource_handler_construct (GType object_type, RygelMediaObject* media_object, const gchar* media_resource_name, GCancellable* cancellable, GError** error);
gint rygel_http_item_uri_get_thumbnail_index (RygelHTTPItemURI* self);
GType rygel_http_thumbnail_handler_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
RygelHTTPThumbnailHandler* rygel_http_thumbnail_handler_new (RygelMediaFileItem* media_item, gint thumbnail_index, GCancellable* cancellable, GError** error);
RygelHTTPThumbnailHandler* rygel_http_thumbnail_handler_construct (GType object_type, RygelMediaFileItem* media_item, gint thumbnail_index, GCancellable* cancellable, GError** error);
gint rygel_http_item_uri_get_subtitle_index (RygelHTTPItemURI* self);
GType rygel_http_subtitle_handler_get_type (void) G_GNUC_CONST;
RygelHTTPSubtitleHandler* rygel_http_subtitle_handler_new (RygelMediaFileItem* media_item, gint subtitle_index, GCancellable* cancellable, GError** error);
RygelHTTPSubtitleHandler* rygel_http_subtitle_handler_construct (GType object_type, RygelMediaFileItem* media_item, gint subtitle_index, GCancellable* cancellable, GError** error);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
gchar* rygel_http_get_handler_get_default_transfer_mode (RygelHTTPGetHandler* self);
gboolean rygel_http_get_handler_supports_transfer_mode (RygelHTTPGetHandler* self, const gchar* mode);
static void rygel_http_get_handle_item_request (RygelHTTPGet* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_handle_item_request_finish (RygelHTTPGet* self, GAsyncResult* _res_, GError** error);
static void rygel_http_get_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_get_real_find_item_data_free (gpointer _data);
static void rygel_http_get_real_find_item (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_get_real_find_item_co (RygelHttpGetFindItemData* _data_);
void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
static void rygel_http_get_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
void rygel_client_hacks_apply (RygelClientHacks* self, RygelMediaObject* object);
static void rygel_http_get_handle_item_request_data_free (gpointer _data);
static gboolean rygel_http_get_handle_item_request_co (RygelHttpGetHandleItemRequestData* _data_);
gboolean rygel_http_time_seek_request_supported (RygelHTTPGet* request);
gboolean rygel_http_time_seek_request_requested (RygelHTTPGet* request);
gboolean rygel_http_byte_seek_request_supported (RygelHTTPGet* request);
gboolean rygel_http_byte_seek_request_requested (RygelHTTPGet* request);
gboolean rygel_dtcp_cleartext_request_supported (RygelHTTPGet* request);
gboolean rygel_dtcp_cleartext_request_requested (RygelHTTPGet* request);
gboolean rygel_play_speed_request_requested (RygelHTTPGet* request);
GQuark rygel_play_speed_error_quark (void);
RygelPlaySpeedRequest* rygel_play_speed_request_new_from_request (RygelHTTPGet* request, GError** error);
RygelPlaySpeedRequest* rygel_play_speed_request_construct_from_request (GType object_type, RygelHTTPGet* request, GError** error);
gpointer rygel_play_speed_ref (gpointer instance);
void rygel_play_speed_unref (gpointer instance);
GParamSpec* rygel_param_spec_play_speed (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_play_speed (GValue* value, gpointer v_object);
void rygel_value_take_play_speed (GValue* value, gpointer v_object);
gpointer rygel_value_get_play_speed (const GValue* value);
GType rygel_play_speed_get_type (void) G_GNUC_CONST;
RygelPlaySpeed* rygel_play_speed_request_get_speed (RygelPlaySpeedRequest* self);
gchar* rygel_play_speed_to_string (RygelPlaySpeed* self);
gboolean rygel_play_speed_is_normal_rate (RygelPlaySpeed* self);
void rygel_http_request_end (RygelHTTPRequest* self, guint status, const gchar* reason);
GType rygel_dtcp_cleartext_request_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_request_error_quark (void);
RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_new (RygelHTTPGet* request, GError** error);
RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_construct (GType object_type, RygelHTTPGet* request, GError** error);
gint64 rygel_dtcp_cleartext_request_get_start_byte (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_end_byte (RygelDTCPCleartextRequest* self);
GType rygel_http_byte_seek_request_get_type (void) G_GNUC_CONST;
RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_construct (GType object_type, RygelHTTPGet* request, GError** error);
gint64 rygel_http_byte_seek_request_get_start_byte (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_end_byte (RygelHTTPByteSeekRequest* self);
GType rygel_http_time_seek_request_get_type (void) G_GNUC_CONST;
RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_new (RygelHTTPGet* request, RygelPlaySpeed* speed, GError** error);
RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_construct (GType object_type, RygelHTTPGet* request, RygelPlaySpeed* speed, GError** error);
gchar* rygel_http_time_seek_request_to_string (RygelHTTPTimeSeekRequest* self);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GeeList* rygel_http_response_preroll (RygelHTTPResponse* self, GError** error);
void rygel_http_response_element_add_response_headers (RygelHTTPResponseElement* self, RygelHTTPRequest* request);
gint64 rygel_http_get_handler_get_resource_size (RygelHTTPGetHandler* self);
gboolean rygel_play_speed_request_supported (RygelHTTPGet* request);
#define RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER "TimeSeekRange.dlna.org"
#define RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER "PlaySpeed.dlna.org"
static void __lambda9_ (RygelHTTPGet* self, const gchar* name, const gchar* value);
static void ___lambda9__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self);
static void rygel_http_get_handle_item_request_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_get_finalize (GObject* obj);


RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPGet * self = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	SoupServer* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
	g_return_val_if_fail (http_server != NULL, NULL);
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = http_server;
	_tmp1_ = server;
	_tmp2_ = msg;
	self = (RygelHTTPGet*) rygel_http_request_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, http_server, server, msg);
}


static void rygel_http_get_real_handle_data_free (gpointer _data) {
	RygelHttpGetHandleData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpGetHandleData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_http_get_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPGet * self;
	RygelHttpGetHandleData* _data_;
	RygelHTTPGet* _tmp0_ = NULL;
	self = (RygelHTTPGet*) base;
	_data_ = g_slice_new0 (RygelHttpGetHandleData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_real_handle);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_real_handle_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_get_real_handle_co (_data_);
}


static void rygel_http_get_real_handle_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpGetHandleData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_get_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetHandleData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_get_real_handle_co (_data_);
}


static gboolean rygel_http_get_real_handle_co (RygelHttpGetHandleData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp2_ = NULL;
	g_object_get (_data_->_tmp1_, "method", &_data_->_tmp2_, NULL);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = FALSE;
	_data_->_tmp5_ = g_strcmp0 (_data_->_tmp4_, "HEAD") == 0;
	_g_free0 (_data_->_tmp4_);
	if (_data_->_tmp5_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp7_ = NULL;
		g_object_get (_data_->_tmp6_, "method", &_data_->_tmp7_, NULL);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp0_ = g_strcmp0 (_data_->_tmp9_, "GET") == 0;
		_g_free0 (_data_->_tmp9_);
	}
	if (!_data_->_tmp0_) {
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _ ("Invalid Request (only GET and HEAD supported)");
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _data_->_tmp10_);
		_data_->_inner_error_ = _data_->_tmp11_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_strdup ("getcontentFeatures.dlna.org");
		_data_->cf_header = _data_->_tmp12_;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_tmp13_->request_headers;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->cf_header;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = soup_message_headers_get_one (_data_->_tmp14_, _data_->_tmp15_);
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_strdup (_data_->_tmp16_);
		_data_->cf_val = _data_->_tmp17_;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->cf_val;
		if (_data_->_tmp19_ != NULL) {
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->cf_val;
			_data_->_tmp18_ = g_strcmp0 (_data_->_tmp20_, "1") != 0;
		} else {
			_data_->_tmp18_ = FALSE;
		}
		if (_data_->_tmp18_) {
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->cf_header;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = g_strconcat (_data_->_tmp21_, " must be 1", NULL);
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->_tmp22_;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _ (_data_->_tmp23_);
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _data_->_tmp24_);
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->_tmp25_;
			_g_free0 (_data_->_tmp23_);
			_data_->_inner_error_ = _data_->_tmp26_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->cf_val);
			_g_free0 (_data_->cf_header);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_free0 (_data_->cf_val);
		_g_free0 (_data_->cf_header);
	}
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = ((RygelHTTPRequest*) _data_->self)->uri;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = rygel_http_item_uri_get_resource_name (_data_->_tmp27_);
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->_tmp28_;
	if (_data_->_tmp29_ != NULL) {
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = ((RygelHTTPRequest*) _data_->self)->object;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = ((RygelHTTPRequest*) _data_->self)->uri;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = rygel_http_item_uri_get_resource_name (_data_->_tmp32_);
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = _data_->_tmp33_;
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _data_->_tmp35_;
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = rygel_http_media_resource_handler_new (_data_->_tmp31_, _data_->_tmp34_, _data_->_tmp36_, &_data_->_inner_error_);
		_data_->_tmp30_ = _data_->_tmp37_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = _data_->_tmp30_;
		_data_->_tmp30_ = NULL;
		_g_object_unref0 (_data_->self->handler);
		_data_->self->handler = (RygelHTTPGetHandler*) _data_->_tmp38_;
		_g_object_unref0 (_data_->_tmp30_);
	} else {
		_data_->_tmp39_ = NULL;
		_data_->_tmp39_ = ((RygelHTTPRequest*) _data_->self)->uri;
		_data_->_tmp40_ = 0;
		_data_->_tmp40_ = rygel_http_item_uri_get_thumbnail_index (_data_->_tmp39_);
		_data_->_tmp41_ = 0;
		_data_->_tmp41_ = _data_->_tmp40_;
		if (_data_->_tmp41_ >= 0) {
			_data_->_tmp43_ = NULL;
			_data_->_tmp43_ = ((RygelHTTPRequest*) _data_->self)->object;
			_data_->_tmp44_ = NULL;
			_data_->_tmp44_ = ((RygelHTTPRequest*) _data_->self)->uri;
			_data_->_tmp45_ = 0;
			_data_->_tmp45_ = rygel_http_item_uri_get_thumbnail_index (_data_->_tmp44_);
			_data_->_tmp46_ = 0;
			_data_->_tmp46_ = _data_->_tmp45_;
			_data_->_tmp47_ = NULL;
			_data_->_tmp47_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp48_ = NULL;
			_data_->_tmp48_ = _data_->_tmp47_;
			_data_->_tmp49_ = NULL;
			_data_->_tmp49_ = rygel_http_thumbnail_handler_new (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp43_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp43_) : NULL, _data_->_tmp46_, _data_->_tmp48_, &_data_->_inner_error_);
			_data_->_tmp42_ = _data_->_tmp49_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp50_ = NULL;
			_data_->_tmp50_ = _data_->_tmp42_;
			_data_->_tmp42_ = NULL;
			_g_object_unref0 (_data_->self->handler);
			_data_->self->handler = (RygelHTTPGetHandler*) _data_->_tmp50_;
			_g_object_unref0 (_data_->_tmp42_);
		} else {
			_data_->_tmp51_ = NULL;
			_data_->_tmp51_ = ((RygelHTTPRequest*) _data_->self)->uri;
			_data_->_tmp52_ = 0;
			_data_->_tmp52_ = rygel_http_item_uri_get_subtitle_index (_data_->_tmp51_);
			_data_->_tmp53_ = 0;
			_data_->_tmp53_ = _data_->_tmp52_;
			if (_data_->_tmp53_ >= 0) {
				_data_->_tmp55_ = NULL;
				_data_->_tmp55_ = ((RygelHTTPRequest*) _data_->self)->object;
				_data_->_tmp56_ = NULL;
				_data_->_tmp56_ = ((RygelHTTPRequest*) _data_->self)->uri;
				_data_->_tmp57_ = 0;
				_data_->_tmp57_ = rygel_http_item_uri_get_subtitle_index (_data_->_tmp56_);
				_data_->_tmp58_ = 0;
				_data_->_tmp58_ = _data_->_tmp57_;
				_data_->_tmp59_ = NULL;
				_data_->_tmp59_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
				_data_->_tmp60_ = NULL;
				_data_->_tmp60_ = _data_->_tmp59_;
				_data_->_tmp61_ = NULL;
				_data_->_tmp61_ = rygel_http_subtitle_handler_new (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp55_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp55_) : NULL, _data_->_tmp58_, _data_->_tmp60_, &_data_->_inner_error_);
				_data_->_tmp54_ = _data_->_tmp61_;
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp62_ = NULL;
				_data_->_tmp62_ = _data_->_tmp54_;
				_data_->_tmp54_ = NULL;
				_g_object_unref0 (_data_->self->handler);
				_data_->self->handler = (RygelHTTPGetHandler*) _data_->_tmp62_;
				_g_object_unref0 (_data_->_tmp54_);
			} else {
				_data_->_tmp63_ = NULL;
				_data_->_tmp63_ = ((RygelHTTPRequest*) _data_->self)->uri;
				_data_->_tmp64_ = NULL;
				_data_->_tmp64_ = rygel_http_item_uri_to_string (_data_->_tmp63_);
				_data_->_tmp65_ = NULL;
				_data_->_tmp65_ = _data_->_tmp64_;
				_data_->_tmp66_ = NULL;
				_data_->_tmp66_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No handler found for '%s'", _data_->_tmp65_);
				_data_->_tmp67_ = NULL;
				_data_->_tmp67_ = _data_->_tmp66_;
				_g_free0 (_data_->_tmp65_);
				_data_->_inner_error_ = _data_->_tmp67_;
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	{
		_data_->_tmp68_ = NULL;
		_data_->_tmp68_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp69_ = NULL;
		_data_->_tmp69_ = _data_->_tmp68_->request_headers;
		_data_->_tmp70_ = NULL;
		_data_->_tmp70_ = soup_message_headers_get_one (_data_->_tmp69_, RYGEL_HTTP_GET_TRANSFER_MODE_HEADER);
		_data_->_tmp71_ = NULL;
		_data_->_tmp71_ = g_strdup (_data_->_tmp70_);
		_data_->transfer_mode = _data_->_tmp71_;
		_data_->_tmp72_ = NULL;
		_data_->_tmp72_ = _data_->transfer_mode;
		if (_data_->_tmp72_ == NULL) {
			_data_->_tmp73_ = NULL;
			_data_->_tmp73_ = _data_->self->handler;
			_data_->_tmp74_ = NULL;
			_data_->_tmp74_ = rygel_http_get_handler_get_default_transfer_mode (_data_->_tmp73_);
			_g_free0 (_data_->transfer_mode);
			_data_->transfer_mode = _data_->_tmp74_;
		}
		_data_->_tmp75_ = NULL;
		_data_->_tmp75_ = _data_->self->handler;
		_data_->_tmp76_ = NULL;
		_data_->_tmp76_ = _data_->transfer_mode;
		_data_->_tmp77_ = FALSE;
		_data_->_tmp77_ = rygel_http_get_handler_supports_transfer_mode (_data_->_tmp75_, _data_->_tmp76_);
		if (!_data_->_tmp77_) {
			_data_->_tmp78_ = NULL;
			_data_->_tmp78_ = _data_->transfer_mode;
			_data_->_tmp79_ = NULL;
			_data_->_tmp79_ = ((RygelHTTPRequest*) _data_->self)->uri;
			_data_->_tmp80_ = NULL;
			_data_->_tmp80_ = rygel_http_item_uri_to_string (_data_->_tmp79_);
			_data_->_tmp81_ = NULL;
			_data_->_tmp81_ = _data_->_tmp80_;
			_data_->_tmp82_ = NULL;
			_data_->_tmp82_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, "%s transfer mode not supported for '%s'", _data_->_tmp78_, _data_->_tmp81_);
			_data_->_tmp83_ = NULL;
			_data_->_tmp83_ = _data_->_tmp82_;
			_g_free0 (_data_->_tmp81_);
			_data_->_inner_error_ = _data_->_tmp83_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->transfer_mode);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_free0 (_data_->transfer_mode);
	}
	_data_->_state_ = 1;
	rygel_http_get_handle_item_request (_data_->self, rygel_http_get_handle_ready, _data_);
	return FALSE;
	_state_1:
	rygel_http_get_handle_item_request_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_http_get_real_find_item_data_free (gpointer _data) {
	RygelHttpGetFindItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpGetFindItemData, _data_);
}


static void rygel_http_get_real_find_item (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPGet * self;
	RygelHttpGetFindItemData* _data_;
	RygelHTTPGet* _tmp0_ = NULL;
	self = (RygelHTTPGet*) base;
	_data_ = g_slice_new0 (RygelHttpGetFindItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_real_find_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_real_find_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_get_real_find_item_co (_data_);
}


static void rygel_http_get_real_find_item_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpGetFindItemData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_get_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetFindItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_get_real_find_item_co (_data_);
}


static gboolean rygel_http_get_real_find_item_co (RygelHttpGetFindItemData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	RYGEL_HTTP_REQUEST_CLASS (rygel_http_get_parent_class)->find_item (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest), rygel_http_get_find_item_ready, _data_);
	return FALSE;
	_state_1:
	RYGEL_HTTP_REQUEST_CLASS (rygel_http_get_parent_class)->find_item_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest), _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = ((RygelHTTPRequest*) _data_->self)->object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, RYGEL_TYPE_MEDIA_CONTAINER)) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = ((RygelHTTPRequest*) _data_->self)->object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp2_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = ((RygelHTTPRequest*) _data_->self)->object;
		_data_->_tmp4_ = FALSE;
		_data_->_tmp4_ = rygel_media_file_item_get_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp3_) : NULL);
		_data_->_tmp5_ = FALSE;
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp1_ = _data_->_tmp5_;
	} else {
		_data_->_tmp1_ = FALSE;
	}
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = G_UNLIKELY (_data_->_tmp1_);
	if (_data_->_tmp6_) {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = ((RygelHTTPRequest*) _data_->self)->object;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = rygel_media_object_get_id (_data_->_tmp7_);
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "Item '%s' is empty", _data_->_tmp9_);
		_data_->_inner_error_ = _data_->_tmp10_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = ((RygelHTTPRequest*) _data_->self)->hack;
	if (_data_->_tmp11_ != NULL) {
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = ((RygelHTTPRequest*) _data_->self)->hack;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = ((RygelHTTPRequest*) _data_->self)->object;
		rygel_client_hacks_apply (_data_->_tmp12_, _data_->_tmp13_);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_http_get_handle_item_request_data_free (gpointer _data) {
	RygelHttpGetHandleItemRequestData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpGetHandleItemRequestData, _data_);
}


static void rygel_http_get_handle_item_request (RygelHTTPGet* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpGetHandleItemRequestData* _data_;
	RygelHTTPGet* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelHttpGetHandleItemRequestData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_handle_item_request);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_handle_item_request_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_get_handle_item_request_co (_data_);
}


static void rygel_http_get_handle_item_request_finish (RygelHTTPGet* self, GAsyncResult* _res_, GError** error) {
	RygelHttpGetHandleItemRequestData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void __lambda9_ (RygelHTTPGet* self, const gchar* name, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = name;
	_tmp1_ = value;
	g_debug ("rygel-http-get.vala:323: %s : %s", _tmp0_, _tmp1_);
}


static void ___lambda9__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self) {
	__lambda9_ ((RygelHTTPGet*) self, name, value);
}


static void rygel_http_get_handle_item_request_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetHandleItemRequestData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_get_handle_item_request_co (_data_);
}


static gboolean rygel_http_get_handle_item_request_co (RygelHttpGetHandleItemRequestData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = rygel_http_time_seek_request_supported (_data_->self);
	_data_->supports_time_seek = _data_->_tmp0_;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = rygel_http_time_seek_request_requested (_data_->self);
	_data_->requested_time_seek = _data_->_tmp1_;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = rygel_http_byte_seek_request_supported (_data_->self);
	_data_->supports_byte_seek = _data_->_tmp2_;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = rygel_http_byte_seek_request_requested (_data_->self);
	_data_->requested_byte_seek = _data_->_tmp3_;
	_data_->_tmp4_ = FALSE;
	_data_->_tmp4_ = rygel_dtcp_cleartext_request_supported (_data_->self);
	_data_->supports_cleartext_seek = _data_->_tmp4_;
	_data_->_tmp5_ = FALSE;
	_data_->_tmp5_ = rygel_dtcp_cleartext_request_requested (_data_->self);
	_data_->requested_cleartext_seek = _data_->_tmp5_;
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = _data_->requested_cleartext_seek;
	if (_data_->_tmp6_) {
		_data_->_tmp7_ = FALSE;
		_data_->_tmp7_ = _data_->supports_cleartext_seek;
		if (!_data_->_tmp7_) {
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = ((RygelHTTPRequest*) _data_->self)->uri;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = rygel_http_item_uri_to_string (_data_->_tmp8_);
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = g_strconcat ("Cleartext seek not supported for ", _data_->_tmp10_, NULL);
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->_tmp11_;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, _data_->_tmp12_);
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->_tmp13_;
			_g_free0 (_data_->_tmp12_);
			_g_free0 (_data_->_tmp10_);
			_data_->_inner_error_ = _data_->_tmp14_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp15_ = FALSE;
		_data_->_tmp15_ = _data_->requested_byte_seek;
		if (_data_->_tmp15_) {
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = ((RygelHTTPRequest*) _data_->self)->uri;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = rygel_http_item_uri_to_string (_data_->_tmp16_);
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = g_strconcat ("Both Cleartext and Range seek requested ", _data_->_tmp18_, NULL);
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->_tmp19_;
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, _data_->_tmp20_);
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _data_->_tmp21_;
			_g_free0 (_data_->_tmp20_);
			_g_free0 (_data_->_tmp18_);
			_data_->_inner_error_ = _data_->_tmp22_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_tmp23_ = FALSE;
		_data_->_tmp23_ = _data_->requested_byte_seek;
		if (_data_->_tmp23_) {
			_data_->_tmp24_ = FALSE;
			_data_->_tmp24_ = _data_->supports_byte_seek;
			if (!_data_->_tmp24_) {
				_data_->_tmp25_ = NULL;
				_data_->_tmp25_ = ((RygelHTTPRequest*) _data_->self)->uri;
				_data_->_tmp26_ = NULL;
				_data_->_tmp26_ = rygel_http_item_uri_to_string (_data_->_tmp25_);
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = _data_->_tmp26_;
				_data_->_tmp28_ = NULL;
				_data_->_tmp28_ = g_strconcat ("Byte seek not supported for ", _data_->_tmp27_, NULL);
				_data_->_tmp29_ = NULL;
				_data_->_tmp29_ = _data_->_tmp28_;
				_data_->_tmp30_ = NULL;
				_data_->_tmp30_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, _data_->_tmp29_);
				_data_->_tmp31_ = NULL;
				_data_->_tmp31_ = _data_->_tmp30_;
				_g_free0 (_data_->_tmp29_);
				_g_free0 (_data_->_tmp27_);
				_data_->_inner_error_ = _data_->_tmp31_;
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		} else {
			_data_->_tmp32_ = FALSE;
			_data_->_tmp32_ = _data_->requested_time_seek;
			if (_data_->_tmp32_) {
				_data_->_tmp33_ = FALSE;
				_data_->_tmp33_ = _data_->supports_time_seek;
				if (!_data_->_tmp33_) {
					_data_->_tmp34_ = NULL;
					_data_->_tmp34_ = ((RygelHTTPRequest*) _data_->self)->uri;
					_data_->_tmp35_ = NULL;
					_data_->_tmp35_ = rygel_http_item_uri_to_string (_data_->_tmp34_);
					_data_->_tmp36_ = NULL;
					_data_->_tmp36_ = _data_->_tmp35_;
					_data_->_tmp37_ = NULL;
					_data_->_tmp37_ = g_strconcat ("Time seek not supported for ", _data_->_tmp36_, NULL);
					_data_->_tmp38_ = NULL;
					_data_->_tmp38_ = _data_->_tmp37_;
					_data_->_tmp39_ = NULL;
					_data_->_tmp39_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, _data_->_tmp38_);
					_data_->_tmp40_ = NULL;
					_data_->_tmp40_ = _data_->_tmp39_;
					_g_free0 (_data_->_tmp38_);
					_g_free0 (_data_->_tmp36_);
					_data_->_inner_error_ = _data_->_tmp40_;
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
		}
	}
	{
		_data_->_tmp43_ = FALSE;
		_data_->_tmp43_ = _data_->requested_byte_seek;
		if (_data_->_tmp43_) {
			_data_->_tmp42_ = TRUE;
		} else {
			_data_->_tmp44_ = FALSE;
			_data_->_tmp44_ = _data_->requested_cleartext_seek;
			_data_->_tmp42_ = _data_->_tmp44_;
		}
		if (!_data_->_tmp42_) {
			_data_->_tmp45_ = FALSE;
			_data_->_tmp45_ = rygel_play_speed_request_requested (_data_->self);
			_data_->_tmp41_ = _data_->_tmp45_;
		} else {
			_data_->_tmp41_ = FALSE;
		}
		if (_data_->_tmp41_) {
			_data_->_tmp47_ = NULL;
			_data_->_tmp47_ = rygel_play_speed_request_new_from_request (_data_->self, &_data_->_inner_error_);
			_data_->_tmp46_ = _data_->_tmp47_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				if (_data_->_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
					goto __catch37_rygel_play_speed_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
			_data_->_tmp48_ = NULL;
			_data_->_tmp48_ = _data_->_tmp46_;
			_data_->_tmp46_ = NULL;
			_g_object_unref0 (_data_->self->speed_request);
			_data_->self->speed_request = _data_->_tmp48_;
			_data_->_tmp49_ = NULL;
			_data_->_tmp49_ = _data_->self->speed_request;
			_data_->_tmp50_ = NULL;
			_data_->_tmp50_ = rygel_play_speed_request_get_speed (_data_->_tmp49_);
			_data_->_tmp51_ = NULL;
			_data_->_tmp51_ = _data_->_tmp50_;
			_data_->_tmp52_ = NULL;
			_data_->_tmp52_ = rygel_play_speed_to_string (_data_->_tmp51_);
			_data_->_tmp53_ = NULL;
			_data_->_tmp53_ = _data_->_tmp52_;
			g_debug ("rygel-http-get.vala:156: Processing playspeed %s", _data_->_tmp53_);
			_g_free0 (_data_->_tmp53_);
			_data_->_tmp54_ = NULL;
			_data_->_tmp54_ = _data_->self->speed_request;
			_data_->_tmp55_ = NULL;
			_data_->_tmp55_ = rygel_play_speed_request_get_speed (_data_->_tmp54_);
			_data_->_tmp56_ = NULL;
			_data_->_tmp56_ = _data_->_tmp55_;
			_data_->_tmp57_ = FALSE;
			_data_->_tmp57_ = rygel_play_speed_is_normal_rate (_data_->_tmp56_);
			if (_data_->_tmp57_) {
				_g_object_unref0 (_data_->self->speed_request);
				_data_->self->speed_request = NULL;
			}
			_g_object_unref0 (_data_->_tmp46_);
		} else {
			_g_object_unref0 (_data_->self->speed_request);
			_data_->self->speed_request = NULL;
		}
	}
	goto __finally37;
	__catch37_rygel_play_speed_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp58_ = NULL;
		_data_->_tmp58_ = ((RygelHTTPRequest*) _data_->self)->server;
		_data_->_tmp59_ = NULL;
		_data_->_tmp59_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_server_unpause_message (_data_->_tmp58_, _data_->_tmp59_);
		_data_->_tmp60_ = NULL;
		_data_->_tmp60_ = _data_->_error_;
		if (g_error_matches (_data_->_tmp60_, RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT)) {
			_data_->_tmp61_ = NULL;
			_data_->_tmp61_ = _data_->_error_;
			_data_->_tmp62_ = NULL;
			_data_->_tmp62_ = _data_->_tmp61_->message;
			rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_BAD_REQUEST, _data_->_tmp62_);
		} else {
			_data_->_tmp63_ = NULL;
			_data_->_tmp63_ = _data_->_error_;
			if (g_error_matches (_data_->_tmp63_, RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT)) {
				_data_->_tmp64_ = NULL;
				_data_->_tmp64_ = _data_->_error_;
				_data_->_tmp65_ = NULL;
				_data_->_tmp65_ = _data_->_tmp64_->message;
				rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_NOT_ACCEPTABLE, _data_->_tmp65_);
			} else {
				_data_->_tmp66_ = NULL;
				_data_->_tmp66_ = _data_->_error_;
				_data_->_tmp67_ = NULL;
				_data_->_tmp67_ = _g_error_copy0 (_data_->_tmp66_);
				_data_->_inner_error_ = _data_->_tmp67_;
				_g_error_free0 (_data_->_error_);
				goto __finally37;
			}
		}
		_data_->_tmp68_ = NULL;
		_data_->_tmp68_ = _data_->_error_;
		_data_->_tmp69_ = NULL;
		_data_->_tmp69_ = _data_->_tmp68_->message;
		g_debug ("rygel-http-get.vala:175: Error processing PlaySpeed: %s", _data_->_tmp69_);
		_g_error_free0 (_data_->_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally37:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp71_ = FALSE;
		_data_->_tmp71_ = _data_->supports_cleartext_seek;
		if (_data_->_tmp71_) {
			_data_->_tmp72_ = FALSE;
			_data_->_tmp72_ = _data_->requested_cleartext_seek;
			_data_->_tmp70_ = _data_->_tmp72_;
		} else {
			_data_->_tmp70_ = FALSE;
		}
		if (_data_->_tmp70_) {
			_data_->_tmp73_ = NULL;
			_data_->_tmp73_ = rygel_dtcp_cleartext_request_new (_data_->self, &_data_->_inner_error_);
			_data_->cleartext_seek = _data_->_tmp73_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				if (_data_->_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
					goto __catch38_rygel_http_seek_request_error;
				}
				goto __finally38;
			}
			_data_->_tmp74_ = NULL;
			_data_->_tmp74_ = _data_->cleartext_seek;
			_data_->_tmp75_ = 0LL;
			_data_->_tmp75_ = rygel_dtcp_cleartext_request_get_start_byte (_data_->_tmp74_);
			_data_->_tmp76_ = 0LL;
			_data_->_tmp76_ = _data_->_tmp75_;
			_data_->_tmp77_ = NULL;
			_data_->_tmp77_ = _data_->cleartext_seek;
			_data_->_tmp78_ = 0LL;
			_data_->_tmp78_ = rygel_dtcp_cleartext_request_get_end_byte (_data_->_tmp77_);
			_data_->_tmp79_ = 0LL;
			_data_->_tmp79_ = _data_->_tmp78_;
			g_debug ("rygel-http-get.vala:182: Processing DTCP cleartext byte range request " \
"(bytes %lld to %lld)", _data_->_tmp76_, _data_->_tmp79_);
			_data_->_tmp80_ = NULL;
			_data_->_tmp80_ = _data_->cleartext_seek;
			_data_->_tmp81_ = NULL;
			_data_->_tmp81_ = _g_object_ref0 ((RygelHTTPSeekRequest*) _data_->_tmp80_);
			_g_object_unref0 (_data_->self->seek);
			_data_->self->seek = _data_->_tmp81_;
			_g_object_unref0 (_data_->cleartext_seek);
		} else {
			_data_->_tmp83_ = FALSE;
			_data_->_tmp83_ = _data_->supports_byte_seek;
			if (_data_->_tmp83_) {
				_data_->_tmp84_ = FALSE;
				_data_->_tmp84_ = _data_->requested_byte_seek;
				_data_->_tmp82_ = _data_->_tmp84_;
			} else {
				_data_->_tmp82_ = FALSE;
			}
			if (_data_->_tmp82_) {
				_data_->_tmp85_ = NULL;
				_data_->_tmp85_ = rygel_http_byte_seek_request_new (_data_->self, &_data_->_inner_error_);
				_data_->byte_seek = _data_->_tmp85_;
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if (_data_->_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
						goto __catch38_rygel_http_seek_request_error;
					}
					goto __finally38;
				}
				_data_->_tmp86_ = NULL;
				_data_->_tmp86_ = _data_->byte_seek;
				_data_->_tmp87_ = 0LL;
				_data_->_tmp87_ = rygel_http_byte_seek_request_get_start_byte (_data_->_tmp86_);
				_data_->_tmp88_ = 0LL;
				_data_->_tmp88_ = _data_->_tmp87_;
				_data_->_tmp89_ = NULL;
				_data_->_tmp89_ = _data_->byte_seek;
				_data_->_tmp90_ = 0LL;
				_data_->_tmp90_ = rygel_http_byte_seek_request_get_end_byte (_data_->_tmp89_);
				_data_->_tmp91_ = 0LL;
				_data_->_tmp91_ = _data_->_tmp90_;
				g_debug ("rygel-http-get.vala:187: Processing byte range request (bytes %lld to " \
"%lld)", _data_->_tmp88_, _data_->_tmp91_);
				_data_->_tmp92_ = NULL;
				_data_->_tmp92_ = _data_->byte_seek;
				_data_->_tmp93_ = NULL;
				_data_->_tmp93_ = _g_object_ref0 ((RygelHTTPSeekRequest*) _data_->_tmp92_);
				_g_object_unref0 (_data_->self->seek);
				_data_->self->seek = _data_->_tmp93_;
				_g_object_unref0 (_data_->byte_seek);
			} else {
				_data_->_tmp95_ = FALSE;
				_data_->_tmp95_ = _data_->supports_time_seek;
				if (_data_->_tmp95_) {
					_data_->_tmp96_ = FALSE;
					_data_->_tmp96_ = _data_->requested_time_seek;
					_data_->_tmp94_ = _data_->_tmp96_;
				} else {
					_data_->_tmp94_ = FALSE;
				}
				if (_data_->_tmp94_) {
					_data_->_tmp98_ = NULL;
					_data_->_tmp98_ = _data_->self->speed_request;
					if (_data_->_tmp98_ == NULL) {
						_data_->_tmp97_ = NULL;
					} else {
						_data_->_tmp99_ = NULL;
						_data_->_tmp99_ = _data_->self->speed_request;
						_data_->_tmp100_ = NULL;
						_data_->_tmp100_ = rygel_play_speed_request_get_speed (_data_->_tmp99_);
						_data_->_tmp101_ = NULL;
						_data_->_tmp101_ = _data_->_tmp100_;
						_data_->_tmp97_ = _data_->_tmp101_;
					}
					_data_->_tmp102_ = NULL;
					_data_->_tmp102_ = rygel_http_time_seek_request_new (_data_->self, _data_->_tmp97_, &_data_->_inner_error_);
					_data_->time_seek = _data_->_tmp102_;
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						if (_data_->_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
							goto __catch38_rygel_http_seek_request_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						return FALSE;
					}
					_data_->_tmp103_ = NULL;
					_data_->_tmp103_ = _data_->time_seek;
					_data_->_tmp104_ = NULL;
					_data_->_tmp104_ = rygel_http_time_seek_request_to_string (_data_->_tmp103_);
					_data_->_tmp105_ = NULL;
					_data_->_tmp105_ = _data_->_tmp104_;
					_data_->_tmp106_ = NULL;
					_data_->_tmp106_ = g_strconcat ("Processing ", _data_->_tmp105_, NULL);
					_data_->_tmp107_ = NULL;
					_data_->_tmp107_ = _data_->_tmp106_;
					g_debug ("rygel-http-get.vala:194: %s", _data_->_tmp107_);
					_g_free0 (_data_->_tmp107_);
					_g_free0 (_data_->_tmp105_);
					_data_->_tmp108_ = NULL;
					_data_->_tmp108_ = _data_->time_seek;
					_data_->_tmp109_ = NULL;
					_data_->_tmp109_ = _g_object_ref0 ((RygelHTTPSeekRequest*) _data_->_tmp108_);
					_g_object_unref0 (_data_->self->seek);
					_data_->self->seek = _data_->_tmp109_;
					_g_object_unref0 (_data_->time_seek);
				} else {
					_g_object_unref0 (_data_->self->seek);
					_data_->self->seek = NULL;
				}
			}
		}
	}
	goto __finally38;
	__catch38_rygel_http_seek_request_error:
	{
		_data_->_vala1__error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp110_ = NULL;
		_data_->_tmp110_ = _data_->_vala1__error_;
		_data_->_tmp111_ = NULL;
		_data_->_tmp111_ = _data_->_tmp110_->message;
		_data_->_tmp112_ = NULL;
		_data_->_tmp112_ = g_strconcat ("Caught HTTPSeekRequestError: ", _data_->_tmp111_, NULL);
		_data_->_tmp113_ = NULL;
		_data_->_tmp113_ = _data_->_tmp112_;
		g_warning ("rygel-http-get.vala:200: %s", _data_->_tmp113_);
		_g_free0 (_data_->_tmp113_);
		_data_->_tmp114_ = NULL;
		_data_->_tmp114_ = ((RygelHTTPRequest*) _data_->self)->server;
		_data_->_tmp115_ = NULL;
		_data_->_tmp115_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_server_unpause_message (_data_->_tmp114_, _data_->_tmp115_);
		_data_->_tmp116_ = NULL;
		_data_->_tmp116_ = _data_->_vala1__error_;
		_data_->_tmp117_ = 0;
		_data_->_tmp117_ = _data_->_tmp116_->code;
		_data_->_tmp118_ = NULL;
		_data_->_tmp118_ = _data_->_vala1__error_;
		_data_->_tmp119_ = NULL;
		_data_->_tmp119_ = _data_->_tmp118_->message;
		rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) _data_->_tmp117_, _data_->_tmp119_);
		_g_error_free0 (_data_->_vala1__error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally38:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp120_ = NULL;
	_data_->_tmp120_ = _data_->self->handler;
	rygel_http_get_handler_add_response_headers (_data_->_tmp120_, _data_->self, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp121_ = NULL;
	_data_->_tmp121_ = _data_->self->handler;
	_data_->_tmp122_ = NULL;
	_data_->_tmp122_ = rygel_http_get_handler_render_body (_data_->_tmp121_, _data_->self, &_data_->_inner_error_);
	_data_->response = _data_->_tmp122_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp123_ = NULL;
		_data_->_tmp123_ = _data_->response;
		_data_->_tmp124_ = NULL;
		_data_->_tmp124_ = rygel_http_response_preroll (_data_->_tmp123_, &_data_->_inner_error_);
		_data_->responses = _data_->_tmp124_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
				goto __catch39_rygel_http_seek_request_error;
			}
			goto __finally39;
		}
		_data_->_tmp125_ = NULL;
		_data_->_tmp125_ = _data_->responses;
		if (_data_->_tmp125_ != NULL) {
			{
				_data_->_tmp126_ = NULL;
				_data_->_tmp126_ = _data_->responses;
				_data_->_tmp127_ = NULL;
				_data_->_tmp127_ = _g_object_ref0 (_data_->_tmp126_);
				_data_->_response_elem_list = _data_->_tmp127_;
				_data_->_tmp128_ = NULL;
				_data_->_tmp128_ = _data_->_response_elem_list;
				_data_->_tmp129_ = 0;
				_data_->_tmp129_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp128_);
				_data_->_tmp130_ = 0;
				_data_->_tmp130_ = _data_->_tmp129_;
				_data_->_response_elem_size = _data_->_tmp130_;
				_data_->_response_elem_index = -1;
				while (TRUE) {
					_data_->_tmp131_ = 0;
					_data_->_tmp131_ = _data_->_response_elem_index;
					_data_->_response_elem_index = _data_->_tmp131_ + 1;
					_data_->_tmp132_ = 0;
					_data_->_tmp132_ = _data_->_response_elem_index;
					_data_->_tmp133_ = 0;
					_data_->_tmp133_ = _data_->_response_elem_size;
					if (!(_data_->_tmp132_ < _data_->_tmp133_)) {
						break;
					}
					_data_->_tmp134_ = NULL;
					_data_->_tmp134_ = _data_->_response_elem_list;
					_data_->_tmp135_ = 0;
					_data_->_tmp135_ = _data_->_response_elem_index;
					_data_->_tmp136_ = NULL;
					_data_->_tmp136_ = gee_list_get (_data_->_tmp134_, _data_->_tmp135_);
					_data_->response_elem = (RygelHTTPResponseElement*) _data_->_tmp136_;
					_data_->_tmp137_ = NULL;
					_data_->_tmp137_ = _data_->response_elem;
					rygel_http_response_element_add_response_headers (_data_->_tmp137_, (RygelHTTPRequest*) _data_->self);
					_g_object_unref0 (_data_->response_elem);
				}
				_g_object_unref0 (_data_->_response_elem_list);
			}
		}
		_g_object_unref0 (_data_->responses);
	}
	goto __finally39;
	__catch39_rygel_http_seek_request_error:
	{
		_data_->_vala2__error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp138_ = NULL;
		_data_->_tmp138_ = _data_->_vala2__error_;
		_data_->_tmp139_ = NULL;
		_data_->_tmp139_ = _data_->_tmp138_->message;
		_data_->_tmp140_ = NULL;
		_data_->_tmp140_ = g_strconcat ("Caught HTTPSeekRequestError on preroll: ", _data_->_tmp139_, NULL);
		_data_->_tmp141_ = NULL;
		_data_->_tmp141_ = _data_->_tmp140_;
		g_warning ("rygel-http-get.vala:222: %s", _data_->_tmp141_);
		_g_free0 (_data_->_tmp141_);
		_data_->_tmp142_ = NULL;
		_data_->_tmp142_ = ((RygelHTTPRequest*) _data_->self)->server;
		_data_->_tmp143_ = NULL;
		_data_->_tmp143_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_server_unpause_message (_data_->_tmp142_, _data_->_tmp143_);
		_data_->_tmp144_ = NULL;
		_data_->_tmp144_ = _data_->_vala2__error_;
		_data_->_tmp145_ = 0;
		_data_->_tmp145_ = _data_->_tmp144_->code;
		_data_->_tmp146_ = NULL;
		_data_->_tmp146_ = _data_->_vala2__error_;
		_data_->_tmp147_ = NULL;
		_data_->_tmp147_ = _data_->_tmp146_->message;
		rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) _data_->_tmp145_, _data_->_tmp147_);
		_g_error_free0 (_data_->_vala2__error_);
		_g_object_unref0 (_data_->response);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally39:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->response);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp148_ = NULL;
		_data_->_tmp148_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp149_ = NULL;
		_data_->_tmp149_ = _data_->_tmp148_->response_headers;
		_data_->_tmp150_ = 0LL;
		_data_->_tmp150_ = soup_message_headers_get_content_length (_data_->_tmp149_);
		_data_->response_size = _data_->_tmp150_;
		_data_->_tmp151_ = 0LL;
		_data_->_tmp151_ = _data_->response_size;
		if (_data_->_tmp151_ > ((gint64) 0)) {
			_data_->_tmp152_ = NULL;
			_data_->_tmp152_ = ((RygelHTTPRequest*) _data_->self)->msg;
			_data_->_tmp153_ = NULL;
			_data_->_tmp153_ = _data_->_tmp152_->response_headers;
			_data_->_tmp154_ = 0LL;
			_data_->_tmp154_ = _data_->response_size;
			soup_message_headers_set_content_length (_data_->_tmp153_, _data_->_tmp154_);
			_data_->_tmp155_ = 0LL;
			_data_->_tmp155_ = _data_->response_size;
			_data_->_tmp156_ = NULL;
			_data_->_tmp156_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp155_);
			_data_->_tmp157_ = NULL;
			_data_->_tmp157_ = _data_->_tmp156_;
			_data_->_tmp158_ = NULL;
			_data_->_tmp158_ = g_strconcat ("Response size set via response element: size ", _data_->_tmp157_, NULL);
			_data_->_tmp159_ = NULL;
			_data_->_tmp159_ = _data_->_tmp158_;
			g_debug ("rygel-http-get.vala:236: %s", _data_->_tmp159_);
			_g_free0 (_data_->_tmp159_);
			_g_free0 (_data_->_tmp157_);
		} else {
			_data_->_tmp160_ = NULL;
			_data_->_tmp160_ = _data_->self->handler;
			_data_->_tmp161_ = 0LL;
			_data_->_tmp161_ = rygel_http_get_handler_get_resource_size (_data_->_tmp160_);
			_data_->response_size = _data_->_tmp161_;
			_data_->_tmp162_ = 0LL;
			_data_->_tmp162_ = _data_->response_size;
			if (_data_->_tmp162_ > ((gint64) 0)) {
				_data_->_tmp163_ = NULL;
				_data_->_tmp163_ = ((RygelHTTPRequest*) _data_->self)->msg;
				_data_->_tmp164_ = NULL;
				_data_->_tmp164_ = _data_->_tmp163_->response_headers;
				_data_->_tmp165_ = 0LL;
				_data_->_tmp165_ = _data_->response_size;
				soup_message_headers_set_content_length (_data_->_tmp164_, _data_->_tmp165_);
				_data_->_tmp166_ = 0LL;
				_data_->_tmp166_ = _data_->response_size;
				_data_->_tmp167_ = NULL;
				_data_->_tmp167_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp166_);
				_data_->_tmp168_ = NULL;
				_data_->_tmp168_ = _data_->_tmp167_;
				_data_->_tmp169_ = NULL;
				_data_->_tmp169_ = g_strconcat ("Response size set via response element: size ", _data_->_tmp168_, NULL);
				_data_->_tmp170_ = NULL;
				_data_->_tmp170_ = _data_->_tmp169_;
				g_debug ("rygel-http-get.vala:242: %s", _data_->_tmp170_);
				_g_free0 (_data_->_tmp170_);
				_g_free0 (_data_->_tmp168_);
			} else {
				g_debug ("rygel-http-get.vala:245: Response size unknown");
			}
		}
	}
	{
		_data_->_tmp172_ = NULL;
		_data_->_tmp172_ = _data_->self->speed_request;
		if (_data_->_tmp172_ != NULL) {
			_data_->_tmp173_ = NULL;
			_data_->_tmp173_ = ((RygelHTTPRequest*) _data_->self)->msg;
			_data_->_tmp174_ = 0;
			_data_->_tmp174_ = soup_message_get_http_version (_data_->_tmp173_);
			_data_->_tmp171_ = _data_->_tmp174_ != SOUP_HTTP_1_0;
		} else {
			_data_->_tmp171_ = FALSE;
		}
		if (_data_->_tmp171_) {
			_data_->response_body_encoding = SOUP_ENCODING_CHUNKED;
			g_debug ("rygel-http-get.vala:260: Response encoding set to CHUNKED");
		} else {
			_data_->_tmp175_ = 0LL;
			_data_->_tmp175_ = _data_->response_size;
			if (_data_->_tmp175_ > ((gint64) 0)) {
				_data_->response_body_encoding = SOUP_ENCODING_CONTENT_LENGTH;
				g_debug ("rygel-http-get.vala:264: Response encoding set to CONTENT-LENGTH");
			} else {
				_data_->_tmp176_ = NULL;
				_data_->_tmp176_ = ((RygelHTTPRequest*) _data_->self)->msg;
				_data_->_tmp177_ = 0;
				_data_->_tmp177_ = soup_message_get_http_version (_data_->_tmp176_);
				if (_data_->_tmp177_ == SOUP_HTTP_1_0) {
					_data_->response_body_encoding = SOUP_ENCODING_EOF;
					g_debug ("rygel-http-get.vala:269: Response encoding set to EOF");
				} else {
					_data_->response_body_encoding = SOUP_ENCODING_CHUNKED;
					g_debug ("rygel-http-get.vala:272: Response encoding set to CHUNKED");
				}
			}
		}
		_data_->_tmp178_ = NULL;
		_data_->_tmp178_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp179_ = NULL;
		_data_->_tmp179_ = _data_->_tmp178_->response_headers;
		_data_->_tmp180_ = 0;
		_data_->_tmp180_ = _data_->response_body_encoding;
		soup_message_headers_set_encoding (_data_->_tmp179_, _data_->_tmp180_);
	}
	{
		_data_->_tmp181_ = FALSE;
		_data_->_tmp181_ = rygel_play_speed_request_supported (_data_->self);
		_data_->supports_playspeed = _data_->_tmp181_;
		_data_->_tmp183_ = FALSE;
		_data_->_tmp183_ = _data_->supports_time_seek;
		if (_data_->_tmp183_) {
			_data_->_tmp182_ = TRUE;
		} else {
			_data_->_tmp184_ = FALSE;
			_data_->_tmp184_ = _data_->supports_playspeed;
			_data_->_tmp182_ = _data_->_tmp184_;
		}
		if (_data_->_tmp182_) {
			_data_->_tmp185_ = NULL;
			_data_->_tmp185_ = ((RygelHTTPRequest*) _data_->self)->msg;
			_data_->_tmp186_ = 0;
			_data_->_tmp186_ = soup_message_get_http_version (_data_->_tmp185_);
			if (_data_->_tmp186_ != SOUP_HTTP_1_0) {
				_data_->_tmp187_ = NULL;
				_data_->_tmp187_ = ((RygelHTTPRequest*) _data_->self)->msg;
				_data_->_tmp188_ = NULL;
				_data_->_tmp188_ = _data_->_tmp187_->response_headers;
				_data_->_tmp189_ = NULL;
				_data_->_tmp189_ = soup_message_headers_get_list (_data_->_tmp188_, "Vary");
				_data_->_tmp190_ = NULL;
				_data_->_tmp190_ = g_string_new (_data_->_tmp189_);
				_data_->vary_header = _data_->_tmp190_;
				_data_->_tmp191_ = FALSE;
				_data_->_tmp191_ = _data_->supports_time_seek;
				if (_data_->_tmp191_) {
					_data_->_tmp192_ = NULL;
					_data_->_tmp192_ = _data_->vary_header;
					_data_->_tmp193_ = 0L;
					_data_->_tmp193_ = _data_->_tmp192_->len;
					if (_data_->_tmp193_ > ((gssize) 0)) {
						_data_->_tmp194_ = NULL;
						_data_->_tmp194_ = _data_->vary_header;
						g_string_append (_data_->_tmp194_, ",");
					}
					_data_->_tmp195_ = NULL;
					_data_->_tmp195_ = _data_->vary_header;
					g_string_append (_data_->_tmp195_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
				}
				_data_->_tmp196_ = FALSE;
				_data_->_tmp196_ = _data_->supports_playspeed;
				if (_data_->_tmp196_) {
					_data_->_tmp197_ = NULL;
					_data_->_tmp197_ = _data_->vary_header;
					_data_->_tmp198_ = 0L;
					_data_->_tmp198_ = _data_->_tmp197_->len;
					if (_data_->_tmp198_ > ((gssize) 0)) {
						_data_->_tmp199_ = NULL;
						_data_->_tmp199_ = _data_->vary_header;
						g_string_append (_data_->_tmp199_, ",");
					}
					_data_->_tmp200_ = NULL;
					_data_->_tmp200_ = _data_->vary_header;
					g_string_append (_data_->_tmp200_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER);
				}
				_data_->_tmp201_ = NULL;
				_data_->_tmp201_ = ((RygelHTTPRequest*) _data_->self)->msg;
				_data_->_tmp202_ = NULL;
				_data_->_tmp202_ = _data_->_tmp201_->response_headers;
				_data_->_tmp203_ = NULL;
				_data_->_tmp203_ = _data_->vary_header;
				_data_->_tmp204_ = NULL;
				_data_->_tmp204_ = _data_->_tmp203_->str;
				soup_message_headers_replace (_data_->_tmp202_, "Vary", _data_->_tmp204_);
				_g_string_free0 (_data_->vary_header);
			}
		}
	}
	{
		_data_->_tmp205_ = NULL;
		_data_->_tmp205_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp206_ = NULL;
		_data_->_tmp206_ = _data_->_tmp205_->response_headers;
		_data_->_tmp207_ = NULL;
		_data_->_tmp207_ = soup_message_headers_get_one (_data_->_tmp206_, "Content-Range");
		if (_data_->_tmp207_ != NULL) {
			_data_->response_code = (gint) SOUP_STATUS_PARTIAL_CONTENT;
		} else {
			_data_->response_code = (gint) SOUP_STATUS_OK;
		}
		_data_->_tmp208_ = NULL;
		_data_->_tmp208_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp209_ = 0;
		_data_->_tmp209_ = _data_->response_code;
		soup_message_set_status (_data_->_tmp208_, (guint) _data_->_tmp209_);
	}
	_data_->_tmp210_ = NULL;
	_data_->_tmp210_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp211_ = 0;
	_data_->_tmp211_ = soup_message_get_http_version (_data_->_tmp210_);
	if (_data_->_tmp211_ == SOUP_HTTP_1_0) {
		_data_->_tmp212_ = NULL;
		_data_->_tmp212_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_message_set_http_version (_data_->_tmp212_, SOUP_HTTP_1_1);
		_data_->_tmp213_ = NULL;
		_data_->_tmp213_ = ((RygelHTTPRequest*) _data_->self)->msg;
		_data_->_tmp214_ = NULL;
		_data_->_tmp214_ = _data_->_tmp213_->response_headers;
		soup_message_headers_append (_data_->_tmp214_, "Connection", "close");
	}
	g_debug ("rygel-http-get.vala:321: Following HTTP headers appended to response:");
	_data_->_tmp215_ = NULL;
	_data_->_tmp215_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp216_ = NULL;
	_data_->_tmp216_ = _data_->_tmp215_->response_headers;
	soup_message_headers_foreach (_data_->_tmp216_, ___lambda9__soup_message_headers_foreach_func, _data_->self);
	_data_->_tmp217_ = NULL;
	_data_->_tmp217_ = ((RygelHTTPRequest*) _data_->self)->msg;
	_data_->_tmp218_ = NULL;
	g_object_get (_data_->_tmp217_, "method", &_data_->_tmp218_, NULL);
	_data_->_tmp219_ = NULL;
	_data_->_tmp219_ = _data_->_tmp218_;
	_data_->_tmp220_ = NULL;
	_data_->_tmp220_ = _data_->_tmp219_;
	_data_->_tmp221_ = FALSE;
	_data_->_tmp221_ = g_strcmp0 (_data_->_tmp220_, "HEAD") == 0;
	_g_free0 (_data_->_tmp220_);
	if (_data_->_tmp221_) {
		_data_->_tmp222_ = NULL;
		_data_->_tmp222_ = ((RygelHTTPRequest*) _data_->self)->server;
		_data_->_tmp223_ = NULL;
		_data_->_tmp223_ = ((RygelHTTPRequest*) _data_->self)->msg;
		soup_server_unpause_message (_data_->_tmp222_, _data_->_tmp223_);
		_g_object_unref0 (_data_->response);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp224_ = NULL;
	_data_->_tmp224_ = _data_->response;
	_data_->_state_ = 1;
	rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp224_, rygel_http_get_handle_item_request_ready, _data_);
	return FALSE;
	_state_1:
	rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp224_, _data_->_res_);
	rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_NONE, NULL);
	_g_object_unref0 (_data_->response);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
	((RygelHTTPRequestClass *) klass)->handle = rygel_http_get_real_handle;
	((RygelHTTPRequestClass *) klass)->handle_finish = rygel_http_get_real_handle_finish;
	((RygelHTTPRequestClass *) klass)->find_item = rygel_http_get_real_find_item;
	((RygelHTTPRequestClass *) klass)->find_item_finish = rygel_http_get_real_find_item_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET, RygelHTTPGet);
	_g_object_unref0 (self->seek);
	_g_object_unref0 (self->speed_request);
	_g_object_unref0 (self->handler);
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
}


/**
 * Responsible for handling HTTP GET & HEAD client requests.
 */
GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (RYGEL_TYPE_HTTP_REQUEST, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}



