/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-test-item.h"
#include <libgupnp-av/gupnp-av.h>




enum  {
	RYGEL_TEST_ITEM_DUMMY_PROPERTY
};
#define RYGEL_TEST_ITEM_TEST_AUTHOR "Zeeshan Ali (Khattak)"
static GstElement* rygel_test_item_real_create_gst_source (RygelTestItem* self, GError** error);
static gpointer rygel_test_item_parent_class = NULL;



RygelTestItem* rygel_test_item_construct (GType object_type, const char* id, const char* parent_id, const char* title, const char* mime, const char* upnp_class, RygelHTTPServer* http_server) {
	RygelTestItem* self;
	char* _tmp1;
	const char* _tmp0;
	char* _tmp2;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent_id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	self = (RygelTestItem*) rygel_media_item_construct (object_type, id, parent_id, title, upnp_class, http_server);
	_tmp1 = NULL;
	_tmp0 = NULL;
	((RygelMediaItem*) self)->res.mime_type = (_tmp1 = (_tmp0 = mime, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), ((RygelMediaItem*) self)->res.mime_type = (g_free (((RygelMediaItem*) self)->res.mime_type), NULL), _tmp1);
	_tmp2 = NULL;
	((RygelMediaItem*) self)->author = (_tmp2 = g_strdup (RYGEL_TEST_ITEM_TEST_AUTHOR), ((RygelMediaItem*) self)->author = (g_free (((RygelMediaItem*) self)->author), NULL), _tmp2);
	return self;
}


RygelTestItem* rygel_test_item_new (const char* id, const char* parent_id, const char* title, const char* mime, const char* upnp_class, RygelHTTPServer* http_server) {
	return rygel_test_item_construct (RYGEL_TYPE_TEST_ITEM, id, parent_id, title, mime, upnp_class, http_server);
}


static GstElement* rygel_test_item_real_create_gst_source (RygelTestItem* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `rygel_test_item_create_gst_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GstElement* rygel_test_item_create_gst_source (RygelTestItem* self, GError** error) {
	return RYGEL_TEST_ITEM_GET_CLASS (self)->create_gst_source (self, error);
}


static void rygel_test_item_class_init (RygelTestItemClass * klass) {
	rygel_test_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TEST_ITEM_CLASS (klass)->create_gst_source = rygel_test_item_real_create_gst_source;
}


static void rygel_test_item_instance_init (RygelTestItem * self) {
}


GType rygel_test_item_get_type (void) {
	static GType rygel_test_item_type_id = 0;
	if (rygel_test_item_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTestItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_test_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTestItem), 0, (GInstanceInitFunc) rygel_test_item_instance_init, NULL };
		rygel_test_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelTestItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return rygel_test_item_type_id;
}




