/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __RYGEL_TRACKER_ROOT_CONTAINER_H__
#define __RYGEL_TRACKER_ROOT_CONTAINER_H__

#include <glib.h>
#include <glib-object.h>
#include <rygel-media-container.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee/list.h>
#include <rygel-media-object.h>

G_BEGIN_DECLS


#define RYGEL_TYPE_TRACKER_ROOT_CONTAINER (rygel_tracker_root_container_get_type ())
#define RYGEL_TRACKER_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_ROOT_CONTAINER, RygelTrackerRootContainer))
#define RYGEL_TRACKER_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_ROOT_CONTAINER, RygelTrackerRootContainerClass))
#define RYGEL_IS_TRACKER_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_ROOT_CONTAINER))
#define RYGEL_IS_TRACKER_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_ROOT_CONTAINER))
#define RYGEL_TRACKER_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_ROOT_CONTAINER, RygelTrackerRootContainerClass))

typedef struct _RygelTrackerRootContainer RygelTrackerRootContainer;
typedef struct _RygelTrackerRootContainerClass RygelTrackerRootContainerClass;
typedef struct _RygelTrackerRootContainerPrivate RygelTrackerRootContainerPrivate;

/**
 * Represents the root container for Tracker media content hierarchy.
 */
struct _RygelTrackerRootContainer {
	RygelMediaContainer parent_instance;
	RygelTrackerRootContainerPrivate * priv;
};

struct _RygelTrackerRootContainerClass {
	RygelMediaContainerClass parent_class;
};


RygelTrackerRootContainer* rygel_tracker_root_container_construct (GType object_type, const char* title);
RygelTrackerRootContainer* rygel_tracker_root_container_new (const char* title);
GType rygel_tracker_root_container_get_type (void);


G_END_DECLS

#endif
