/* rygel-thumbnailer.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-thumbnailer.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_THUMBNAILER (rygel_thumbnailer_get_type ())
#define RYGEL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailer))
#define RYGEL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))
#define RYGEL_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))

typedef struct _RygelThumbnailer RygelThumbnailer;
typedef struct _RygelThumbnailerClass RygelThumbnailerClass;
typedef struct _RygelThumbnailerPrivate RygelThumbnailerPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_DBUS_THUMBNAILER (rygel_dbus_thumbnailer_get_type ())
#define RYGEL_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailer))
#define RYGEL_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailerClass))
#define RYGEL_IS_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_THUMBNAILER))
#define RYGEL_IS_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DBUS_THUMBNAILER))
#define RYGEL_DBUS_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailerClass))

typedef struct _RygelDbusThumbnailer RygelDbusThumbnailer;
typedef struct _RygelDbusThumbnailerClass RygelDbusThumbnailerClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;

typedef enum  {
	THUMBNAILER_ERROR_NO_DIR,
	THUMBNAILER_ERROR_NO_THUMBNAIL
} ThumbnailerError;
#define THUMBNAILER_ERROR thumbnailer_error_quark ()
struct _RygelThumbnailer {
	GObject parent_instance;
	RygelThumbnailerPrivate * priv;
};

struct _RygelThumbnailerClass {
	GObjectClass parent_class;
};

struct _RygelThumbnailerPrivate {
	RygelThumbnail* template;
	gchar* extension;
	RygelDbusThumbnailer* thumbler;
};

struct _RygelThumbnail {
	RygelIconInfo parent_instance;
	RygelThumbnailPrivate * priv;
	gchar* dlna_profile;
};

struct _RygelThumbnailClass {
	RygelIconInfoClass parent_class;
	GUPnPDIDLLiteResource* (*add_resource) (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const gchar* protocol);
};


static gpointer rygel_thumbnailer_parent_class = NULL;
static RygelThumbnailer* rygel_thumbnailer_thumbnailer;
static RygelThumbnailer* rygel_thumbnailer_thumbnailer = NULL;
static gboolean rygel_thumbnailer_first_time;
static gboolean rygel_thumbnailer_first_time = TRUE;

GQuark thumbnailer_error_quark (void);
GType rygel_thumbnailer_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_dbus_thumbnailer_get_type (void) G_GNUC_CONST;
#define RYGEL_THUMBNAILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerPrivate))
enum  {
	RYGEL_THUMBNAILER_DUMMY_PROPERTY
};
static RygelThumbnailer* rygel_thumbnailer_new (GError** error);
static RygelThumbnailer* rygel_thumbnailer_construct (GType object_type, GError** error);
RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelDbusThumbnailer* rygel_dbus_thumbnailer_new (const gchar* flavor, GError** error);
RygelDbusThumbnailer* rygel_dbus_thumbnailer_construct (GType object_type, const gchar* flavor, GError** error);
static void rygel_thumbnailer_on_dbus_thumbnailer_ready (RygelThumbnailer* self, gboolean available);
static void _rygel_thumbnailer_on_dbus_thumbnailer_ready_rygel_dbus_thumbnailer_ready (RygelDbusThumbnailer* _sender, gboolean available, gpointer self);
RygelThumbnailer* rygel_thumbnailer_get_default (void);
RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const gchar* uri, const gchar* mime_type, GError** error);
void rygel_dbus_thumbnailer_queue_thumbnail_task (RygelDbusThumbnailer* self, const gchar* uri, const gchar* mime);
static void rygel_thumbnailer_finalize (GObject* obj);


GQuark thumbnailer_error_quark (void) {
	return g_quark_from_static_string ("thumbnailer_error-quark");
}


static void _rygel_thumbnailer_on_dbus_thumbnailer_ready_rygel_dbus_thumbnailer_ready (RygelDbusThumbnailer* _sender, gboolean available, gpointer self) {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	rygel_thumbnailer_on_dbus_thumbnailer_ready (self, available);
#line 141 "rygel-thumbnailer.c"
}


static RygelThumbnailer* rygel_thumbnailer_construct (GType object_type, GError** error) {
	RygelThumbnailer * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelThumbnail* _tmp1_;
	RygelThumbnail* _tmp2_;
	RygelThumbnail* _tmp3_;
	RygelThumbnail* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GError * _inner_error_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	self = (RygelThumbnailer*) g_object_new (object_type, NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp0_ = rygel_thumbnail_new ("image/png", "PNG_TN", "png");
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_rygel_icon_info_unref0 (self->priv->template);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	self->priv->template = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp1_ = self->priv->template;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp1_)->width = 128;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp2_ = self->priv->template;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp2_)->height = 128;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp3_ = self->priv->template;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp3_)->depth = 32;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp4_ = self->priv->template;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp5_ = ((RygelIconInfo*) _tmp4_)->file_extension;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp6_ = g_strconcat (".", _tmp5_, NULL);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_free0 (self->priv->extension);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	self->priv->extension = _tmp6_;
#line 185 "rygel-thumbnailer.c"
	{
		RygelDbusThumbnailer* _tmp7_;
		RygelDbusThumbnailer* _tmp8_;
		RygelDbusThumbnailer* _tmp9_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp7_ = rygel_dbus_thumbnailer_new ("normal", &_inner_error_);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp8_ = _tmp7_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		if (_inner_error_ != NULL) {
#line 196 "rygel-thumbnailer.c"
			goto __catch48_g_error;
		}
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (self->priv->thumbler);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		self->priv->thumbler = _tmp8_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp9_ = self->priv->thumbler;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_signal_connect_object (_tmp9_, "ready", (GCallback) _rygel_thumbnailer_on_dbus_thumbnailer_ready_rygel_dbus_thumbnailer_ready, self, 0);
#line 207 "rygel-thumbnailer.c"
	}
	goto __finally48;
	__catch48_g_error:
	{
		GError* _error_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_error_ = _inner_error_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_inner_error_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_error_free0 (_error_);
#line 219 "rygel-thumbnailer.c"
	}
	__finally48:
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_inner_error_ != NULL) {
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		if (_inner_error_->domain == THUMBNAILER_ERROR) {
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			g_propagate_error (error, _inner_error_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_g_object_unref0 (self);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			return NULL;
#line 232 "rygel-thumbnailer.c"
		} else {
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			g_clear_error (&_inner_error_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			return NULL;
#line 240 "rygel-thumbnailer.c"
		}
	}
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	return self;
#line 245 "rygel-thumbnailer.c"
}


static RygelThumbnailer* rygel_thumbnailer_new (GError** error) {
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	return rygel_thumbnailer_construct (RYGEL_TYPE_THUMBNAILER, error);
#line 252 "rygel-thumbnailer.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	return self ? g_object_ref (self) : NULL;
#line 259 "rygel-thumbnailer.c"
}


RygelThumbnailer* rygel_thumbnailer_get_default (void) {
	RygelThumbnailer* result = NULL;
	gboolean _tmp0_;
	RygelThumbnailer* _tmp6_;
	RygelThumbnailer* _tmp7_;
	GError * _inner_error_ = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp0_ = rygel_thumbnailer_first_time;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_tmp0_) {
#line 273 "rygel-thumbnailer.c"
		{
			RygelThumbnailer* _tmp1_;
			RygelThumbnailer* _tmp2_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_tmp1_ = rygel_thumbnailer_new (&_inner_error_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_tmp2_ = _tmp1_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			if (_inner_error_ != NULL) {
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
				if (_inner_error_->domain == THUMBNAILER_ERROR) {
#line 285 "rygel-thumbnailer.c"
					goto __catch49_thumbnailer_error;
				}
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
				g_clear_error (&_inner_error_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
				return NULL;
#line 294 "rygel-thumbnailer.c"
			}
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_g_object_unref0 (rygel_thumbnailer_thumbnailer);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			rygel_thumbnailer_thumbnailer = _tmp2_;
#line 300 "rygel-thumbnailer.c"
		}
		goto __finally49;
		__catch49_thumbnailer_error:
		{
			GError* err = NULL;
			const gchar* _tmp3_ = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			err = _inner_error_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_inner_error_ = NULL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_tmp3_ = _ ("No thumbnailer available: %s");
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_tmp4_ = err;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_tmp5_ = _tmp4_->message;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			g_warning (_tmp3_, _tmp5_);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_g_error_free0 (err);
#line 323 "rygel-thumbnailer.c"
		}
		__finally49:
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		if (_inner_error_ != NULL) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			g_clear_error (&_inner_error_);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			return NULL;
#line 334 "rygel-thumbnailer.c"
		}
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		rygel_thumbnailer_first_time = FALSE;
#line 338 "rygel-thumbnailer.c"
	}
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp6_ = rygel_thumbnailer_thumbnailer;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	result = _tmp7_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	return result;
#line 348 "rygel-thumbnailer.c"
}


RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const gchar* uri, const gchar* mime_type, GError** error) {
	RygelThumbnail* result = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFile* _tmp2_;
	GFileInfo* _tmp3_ = NULL;
	GFileInfo* info;
	GFileInfo* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* path;
	GFileInfo* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean failed;
	gboolean _tmp8_;
	gboolean _tmp11_ = FALSE;
	RygelDbusThumbnailer* _tmp12_;
	gboolean _tmp14_;
	const gchar* _tmp20_;
	const gchar* _tmp23_;
	GFile* _tmp24_ = NULL;
	GFile* _tmp25_;
	GFileInfo* _tmp26_ = NULL;
	GFileInfo* _tmp27_;
	GFileInfo* _tmp28_;
	gboolean _tmp29_ = FALSE;
	RygelThumbnail* _tmp32_;
	const gchar* _tmp33_;
	RygelThumbnail* _tmp34_;
	const gchar* _tmp35_;
	RygelThumbnail* _tmp36_;
	const gchar* _tmp37_;
	RygelThumbnail* _tmp38_;
	RygelThumbnail* thumbnail;
	RygelThumbnail* _tmp39_;
	RygelThumbnail* _tmp40_;
	gint _tmp41_;
	RygelThumbnail* _tmp42_;
	RygelThumbnail* _tmp43_;
	gint _tmp44_;
	RygelThumbnail* _tmp45_;
	RygelThumbnail* _tmp46_;
	gint _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_;
	RygelThumbnail* _tmp51_;
	RygelThumbnail* _tmp52_;
	GFileInfo* _tmp53_;
	guint64 _tmp54_ = 0ULL;
	GError * _inner_error_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp0_ = uri;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp1_ = g_file_new_for_uri (_tmp0_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	file = _tmp1_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp2_ = file;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp3_ = g_file_query_info (_tmp2_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH "," G_FILE_ATTRIBUTE_THUMBNAILING_FAILED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	info = _tmp3_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_inner_error_ != NULL) {
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 429 "rygel-thumbnailer.c"
	}
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp4_ = info;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp5_ = g_file_info_get_attribute_as_string (_tmp4_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	path = _tmp5_;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp6_ = info;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp7_ = g_file_info_get_attribute_boolean (_tmp6_, G_FILE_ATTRIBUTE_THUMBNAILING_FAILED);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	failed = _tmp7_;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp8_ = failed;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_tmp8_) {
#line 447 "rygel-thumbnailer.c"
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp9_ = _ ("No thumbnail available");
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp10_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _tmp9_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_inner_error_ = _tmp10_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (info);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 466 "rygel-thumbnailer.c"
	}
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp12_ = self->priv->thumbler;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_tmp12_ != NULL) {
#line 472 "rygel-thumbnailer.c"
		const gchar* _tmp13_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp13_ = path;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp11_ = _tmp13_ == NULL;
#line 478 "rygel-thumbnailer.c"
	} else {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp11_ = FALSE;
#line 482 "rygel-thumbnailer.c"
	}
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp14_ = _tmp11_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_tmp14_) {
#line 488 "rygel-thumbnailer.c"
		RygelDbusThumbnailer* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp15_ = self->priv->thumbler;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp16_ = uri;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp17_ = mime_type;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		rygel_dbus_thumbnailer_queue_thumbnail_task (_tmp15_, _tmp16_, _tmp17_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp18_ = _ ("No thumbnail available");
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp19_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _tmp18_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_inner_error_ = _tmp19_;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (info);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 518 "rygel-thumbnailer.c"
	}
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp20_ = path;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_tmp20_ == NULL) {
#line 524 "rygel-thumbnailer.c"
		const gchar* _tmp21_ = NULL;
		GError* _tmp22_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp21_ = _ ("No thumbnail available");
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp22_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _tmp21_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_inner_error_ = _tmp22_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (info);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 543 "rygel-thumbnailer.c"
	}
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp23_ = path;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp24_ = g_file_new_for_path (_tmp23_);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_object_unref0 (file);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	file = _tmp24_;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp25_ = file;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp26_ = g_file_query_info (_tmp25_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp27_ = _tmp26_;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_inner_error_ != NULL) {
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (info);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 571 "rygel-thumbnailer.c"
	}
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_object_unref0 (info);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	info = _tmp27_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp28_ = info;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp29_ = g_file_info_get_attribute_boolean (_tmp28_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (!_tmp29_) {
#line 583 "rygel-thumbnailer.c"
		const gchar* _tmp30_ = NULL;
		GError* _tmp31_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp30_ = _ ("No thumbnail available");
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp31_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _tmp30_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_inner_error_ = _tmp31_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (info);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 602 "rygel-thumbnailer.c"
	}
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp32_ = self->priv->template;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp33_ = ((RygelIconInfo*) _tmp32_)->mime_type;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp34_ = self->priv->template;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp35_ = _tmp34_->dlna_profile;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp36_ = self->priv->template;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp37_ = ((RygelIconInfo*) _tmp36_)->file_extension;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp38_ = rygel_thumbnail_new (_tmp33_, _tmp35_, _tmp37_);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	thumbnail = _tmp38_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp39_ = thumbnail;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp40_ = self->priv->template;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp41_ = ((RygelIconInfo*) _tmp40_)->width;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp39_)->width = _tmp41_;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp42_ = thumbnail;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp43_ = self->priv->template;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp44_ = ((RygelIconInfo*) _tmp43_)->height;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp42_)->height = _tmp44_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp45_ = thumbnail;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp46_ = self->priv->template;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp47_ = ((RygelIconInfo*) _tmp46_)->depth;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp45_)->depth = _tmp47_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp48_ = path;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp49_ = g_filename_to_uri (_tmp48_, NULL, &_inner_error_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp50_ = _tmp49_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_inner_error_ != NULL) {
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_rygel_icon_info_unref0 (thumbnail);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (info);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 664 "rygel-thumbnailer.c"
	}
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp51_ = thumbnail;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_free0 (((RygelIconInfo*) _tmp51_)->uri);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp51_)->uri = _tmp50_;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp52_ = thumbnail;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp53_ = info;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp54_ = g_file_info_get_attribute_uint64 (_tmp53_, G_FILE_ATTRIBUTE_STANDARD_SIZE);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp52_)->size = (gint64) _tmp54_;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	result = thumbnail;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_free0 (path);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_object_unref0 (info);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_object_unref0 (file);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	return result;
#line 690 "rygel-thumbnailer.c"
}


static void rygel_thumbnailer_on_dbus_thumbnailer_ready (RygelThumbnailer* self, gboolean available) {
	gboolean _tmp0_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	g_return_if_fail (self != NULL);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp0_ = available;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (!_tmp0_) {
#line 702 "rygel-thumbnailer.c"
		const gchar* _tmp1_ = NULL;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (self->priv->thumbler);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		self->priv->thumbler = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp1_ = _ ("No D-Bus thumbnailer available");
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_message ("rygel-thumbnailer.vala:126: %s", _tmp1_);
#line 712 "rygel-thumbnailer.c"
	}
}


static void rygel_thumbnailer_class_init (RygelThumbnailerClass * klass) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	rygel_thumbnailer_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	g_type_class_add_private (klass, sizeof (RygelThumbnailerPrivate));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_thumbnailer_finalize;
#line 724 "rygel-thumbnailer.c"
}


static void rygel_thumbnailer_instance_init (RygelThumbnailer * self) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	self->priv = RYGEL_THUMBNAILER_GET_PRIVATE (self);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	self->priv->thumbler = NULL;
#line 733 "rygel-thumbnailer.c"
}


static void rygel_thumbnailer_finalize (GObject* obj) {
	RygelThumbnailer * self;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_THUMBNAILER, RygelThumbnailer);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_rygel_icon_info_unref0 (self->priv->template);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_free0 (self->priv->extension);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_object_unref0 (self->priv->thumbler);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	G_OBJECT_CLASS (rygel_thumbnailer_parent_class)->finalize (obj);
#line 749 "rygel-thumbnailer.c"
}


/**
 * Provides thumbnails for images and vidoes.
 */
GType rygel_thumbnailer_get_type (void) {
	static volatile gsize rygel_thumbnailer_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnailer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnailer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnailer), 0, (GInstanceInitFunc) rygel_thumbnailer_instance_init, NULL };
		GType rygel_thumbnailer_type_id;
		rygel_thumbnailer_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnailer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnailer_type_id__volatile, rygel_thumbnailer_type_id);
	}
	return rygel_thumbnailer_type_id__volatile;
}



