/* rygel-media-item.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-media-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gst/gst.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_MEDIA_ITEM_ERROR_BAD_URI
} RygelMediaItemError;
#define RYGEL_MEDIA_ITEM_ERROR rygel_media_item_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelMediaItemPrivate {
	gint64 _size;
	gboolean _place_holder;
	gchar* _description;
};

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};


static gpointer rygel_media_item_parent_class = NULL;

GQuark rygel_media_item_error_quark (void);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemPrivate))
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY,
	RYGEL_MEDIA_ITEM_SIZE,
	RYGEL_MEDIA_ITEM_PLACE_HOLDER,
	RYGEL_MEDIA_ITEM_DESCRIPTION,
	RYGEL_MEDIA_ITEM_OCM_FLAGS
};
RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value);
GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self, const gchar* host_ip);
static GstElement* rygel_media_item_real_create_stream_source (RygelMediaItem* self, const gchar* host_ip);
GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri);
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
gint64 rygel_media_item_get_size (RygelMediaItem* self);
static gboolean rygel_media_item_real_streamable (RygelMediaItem* self);
void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri);
static void rygel_media_item_real_add_uri (RygelMediaItem* self, const gchar* uri);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2);
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
static GUPnPDIDLLiteResource* rygel_media_item_real_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
static gint rygel_media_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property);
static gint rygel_media_item_compare_by_date (RygelMediaItem* self, RygelMediaItem* item);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_media_item_get_description (RygelMediaItem* self);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_media_item_real_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error);
static void rygel_media_item_real_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static gint rygel_media_item_compare_long (RygelMediaItem* self, glong a, glong b);
void rygel_media_item_set_size (RygelMediaItem* self, gint64 value);
void rygel_media_item_set_place_holder (RygelMediaItem* self, gboolean value);
void rygel_media_item_set_description (RygelMediaItem* self, const gchar* value);
static void rygel_media_item_finalize (GObject* obj);
static void _vala_rygel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_media_item_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_item_error-quark");
}


RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelMediaItem * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelMediaContainer* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = id;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (((RygelMediaObject*) self)->id);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	((RygelMediaObject*) self)->id = _tmp1_;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = parent;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	((RygelMediaObject*) self)->parent = _tmp2_;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = title;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	rygel_media_object_set_title ((RygelMediaObject*) self, _tmp3_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp4_ = upnp_class;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (((RygelMediaObject*) self)->upnp_class);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	((RygelMediaObject*) self)->upnp_class = _tmp5_;
#line 295 "rygel-media-item.c"
	{
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp6_ = g_regex_escape_string ("@ADDRESS@", -1);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp7_ = _tmp6_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp8_ = g_regex_new (_tmp7_, 0, 0, &_inner_error_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp9_ = _tmp8_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_free0 (_tmp7_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp10_ = _tmp9_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_inner_error_ != NULL) {
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 318 "rygel-media-item.c"
				goto __catch7_g_regex_error;
			}
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_clear_error (&_inner_error_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return NULL;
#line 327 "rygel-media-item.c"
		}
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_regex_unref0 (self->address_regex);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		self->address_regex = _tmp10_;
#line 333 "rygel-media-item.c"
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* err = NULL;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		err = _inner_error_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_inner_error_ = NULL;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_assert_not_reached ();
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_error_free0 (err);
#line 347 "rygel-media-item.c"
	}
	__finally7:
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_inner_error_ != NULL) {
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_clear_error (&_inner_error_);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return NULL;
#line 358 "rygel-media-item.c"
	}
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return self;
#line 362 "rygel-media-item.c"
}


static GstElement* rygel_media_item_real_create_stream_source (RygelMediaItem* self, const gchar* host_ip) {
	GstElement* result = NULL;
	GstElement* src;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	src = NULL;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = ((RygelMediaObject*) self)->uris;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = _tmp1_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp2_ != 0) {
#line 383 "rygel-media-item.c"
		GeeArrayList* _tmp3_;
		gpointer _tmp4_ = NULL;
		gchar* translated_uri;
		const gchar* _tmp5_;
		const gchar* _tmp14_;
		GstElement* _tmp15_ = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp3_ = ((RygelMediaObject*) self)->uris;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		translated_uri = (gchar*) _tmp4_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp5_ = host_ip;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_tmp5_ != NULL) {
#line 400 "rygel-media-item.c"
			{
				GRegex* _tmp6_;
				GeeArrayList* _tmp7_;
				gpointer _tmp8_ = NULL;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* _tmp13_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp6_ = self->address_regex;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp7_ = ((RygelMediaObject*) self)->uris;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, 0);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp9_ = (gchar*) _tmp8_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp10_ = host_ip;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp11_ = g_regex_replace_literal (_tmp6_, _tmp9_, (gssize) (-1), 0, _tmp10_, 0, &_inner_error_);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp12_ = _tmp11_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_free0 (_tmp9_);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp13_ = _tmp12_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				if (_inner_error_ != NULL) {
#line 430 "rygel-media-item.c"
					goto __catch8_g_error;
				}
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_free0 (translated_uri);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				translated_uri = _tmp13_;
#line 437 "rygel-media-item.c"
			}
			goto __finally8;
			__catch8_g_error:
			{
				GError* _error_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_error_ = _inner_error_;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_inner_error_ = NULL;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				g_assert_not_reached ();
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_error_free0 (_error_);
#line 451 "rygel-media-item.c"
			}
			__finally8:
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (_inner_error_ != NULL) {
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_free0 (translated_uri);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_gst_object_unref0 (src);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				g_clear_error (&_inner_error_);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				return NULL;
#line 466 "rygel-media-item.c"
			}
		}
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp14_ = translated_uri;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp15_ = rygel_gst_utils_create_source_for_uri (_tmp14_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_gst_object_unref0 (src);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		src = _tmp15_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_free0 (translated_uri);
#line 479 "rygel-media-item.c"
	}
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = src;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 485 "rygel-media-item.c"
}


GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self, const gchar* host_ip) {
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->create_stream_source (self, host_ip);
#line 494 "rygel-media-item.c"
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = rygel_media_item_streamable (self);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp1_) {
#line 509 "rygel-media-item.c"
		gint64 _tmp2_;
		gint64 _tmp3_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp2_ = rygel_media_item_get_size (self);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp3_ = _tmp2_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp0_ = _tmp3_ <= ((gint64) 0);
#line 518 "rygel-media-item.c"
	} else {
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp0_ = FALSE;
#line 522 "rygel-media-item.c"
	}
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp4_ = _tmp0_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp4_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 530 "rygel-media-item.c"
}


static gboolean rygel_media_item_real_streamable (RygelMediaItem* self) {
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_media_item_streamable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return FALSE;
#line 539 "rygel-media-item.c"
}


gboolean rygel_media_item_streamable (RygelMediaItem* self) {
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->streamable (self);
#line 548 "rygel-media-item.c"
}


static void rygel_media_item_real_add_uri (RygelMediaItem* self, const gchar* uri) {
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (uri != NULL);
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = ((RygelMediaObject*) self)->uris;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = uri;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 563 "rygel-media-item.c"
}


void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri) {
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_uri (self, uri);
#line 572 "rygel-media-item.c"
}


gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2) {
	gint result = 0;
	RygelTranscoder* _tmp0_;
	guint _tmp1_ = 0U;
	RygelTranscoder* _tmp2_;
	guint _tmp3_ = 0U;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (transcoder1 != NULL, 0);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (transcoder2 != NULL, 0);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = transcoder1;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = rygel_transcoder_get_distance (_tmp0_, self);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = transcoder2;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = rygel_transcoder_get_distance (_tmp2_, self);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = ((gint) _tmp1_) - ((gint) _tmp3_);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 600 "rygel-media-item.c"
}


static GUPnPDIDLLiteResource* rygel_media_item_real_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteItem* _tmp0_;
	GUPnPDIDLLiteResource* _tmp1_ = NULL;
	GUPnPDIDLLiteResource* res;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gboolean _tmp12_;
	GUPnPDIDLLiteResource* _tmp15_;
	gint64 _tmp16_;
	gint64 _tmp17_;
	GUPnPDIDLLiteResource* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GUPnPProtocolInfo* _tmp21_ = NULL;
	GUPnPProtocolInfo* _tmp22_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = didl_item;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) _tmp0_);
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	res = _tmp1_;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = uri;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp3_ != NULL) {
#line 637 "rygel-media-item.c"
		gboolean _tmp4_;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp4_ = self->priv->_place_holder;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp2_ = !_tmp4_;
#line 643 "rygel-media-item.c"
	} else {
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp2_ = FALSE;
#line 647 "rygel-media-item.c"
	}
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp5_ = _tmp2_;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp5_) {
#line 653 "rygel-media-item.c"
		GUPnPDIDLLiteResource* _tmp6_;
		const gchar* _tmp7_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp6_ = res;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp7_ = uri;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_resource_set_uri (_tmp6_, _tmp7_);
#line 662 "rygel-media-item.c"
	} else {
		GUPnPDIDLLiteResource* _tmp8_;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp8_ = res;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_resource_set_uri (_tmp8_, "");
#line 669 "rygel-media-item.c"
	}
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp10_ = import_uri;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp10_ != NULL) {
#line 675 "rygel-media-item.c"
		gboolean _tmp11_;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp11_ = self->priv->_place_holder;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp9_ = _tmp11_;
#line 681 "rygel-media-item.c"
	} else {
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp9_ = FALSE;
#line 685 "rygel-media-item.c"
	}
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp12_ = _tmp9_;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp12_) {
#line 691 "rygel-media-item.c"
		GUPnPDIDLLiteResource* _tmp13_;
		const gchar* _tmp14_;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp13_ = res;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp14_ = import_uri;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_resource_set_import_uri (_tmp13_, _tmp14_);
#line 700 "rygel-media-item.c"
	}
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp15_ = res;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp16_ = rygel_media_item_get_size (self);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp17_ = _tmp16_;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_didl_lite_resource_set_size64 (_tmp15_, _tmp17_);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp18_ = res;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp19_ = uri;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp20_ = protocol;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp21_ = rygel_media_item_get_protocol_info (self, _tmp19_, _tmp20_);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp22_ = _tmp21_;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_didl_lite_resource_set_protocol_info (_tmp18_, _tmp22_);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_object_unref0 (_tmp22_);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = res;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 728 "rygel-media-item.c"
}


GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_resource (self, didl_item, uri, protocol, import_uri, error);
#line 737 "rygel-media-item.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return self ? g_object_ref (self) : NULL;
#line 744 "rygel-media-item.c"
}


static gint rygel_media_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property) {
	RygelMediaItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaItem* _tmp2_;
	RygelMediaItem* item;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	static GQuark _tmp5_label0 = 0;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = (RygelMediaItem*) base;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = media_object;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_ITEM)) {
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		result = 1;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return result;
#line 774 "rygel-media-item.c"
	}
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = media_object;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp1_) : NULL);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	item = _tmp2_;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = property;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp4_ = _tmp3_;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("dc:date")))) {
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		switch (0) {
#line 792 "rygel-media-item.c"
			default:
			{
				RygelMediaItem* _tmp7_;
				gint _tmp8_ = 0;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp7_ = item;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp8_ = rygel_media_item_compare_by_date (self, _tmp7_);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				result = _tmp8_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_object_unref0 (item);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				return result;
#line 807 "rygel-media-item.c"
			}
		}
	} else {
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		switch (0) {
#line 813 "rygel-media-item.c"
			default:
			{
				RygelMediaItem* _tmp9_;
				const gchar* _tmp10_;
				gint _tmp11_ = 0;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp9_ = item;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp10_ = property;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp11_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->compare_by_property (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject), (RygelMediaObject*) _tmp9_, _tmp10_);
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				result = _tmp11_;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_object_unref0 (item);
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				return result;
#line 831 "rygel-media-item.c"
			}
		}
	}
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_object_unref0 (item);
#line 837 "rygel-media-item.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 844 "rygel-media-item.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_list_free (self);
#line 853 "rygel-media-item.c"
}


static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
	RygelMediaItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteWriter* _tmp0_;
	GUPnPDIDLLiteItem* _tmp1_ = NULL;
	GUPnPDIDLLiteItem* didl_item;
	GUPnPDIDLLiteItem* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	RygelMediaContainer* _tmp7_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GUPnPDIDLLiteItem* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GUPnPDIDLLiteItem* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp27_;
	RygelHTTPServer* _tmp30_;
	GUPnPDIDLLiteItem* _tmp31_;
	gboolean _tmp32_;
	GError * _inner_error_ = NULL;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = (RygelMediaItem*) base;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (writer != NULL, NULL);
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = writer;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = gupnp_didl_lite_writer_add_item (_tmp0_);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	didl_item = _tmp1_;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = didl_item;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = ((RygelMediaObject*) self)->id;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) _tmp2_, _tmp3_);
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp4_ = ((RygelMediaObject*) self)->ref_id;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp4_ != NULL) {
#line 902 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp5_;
		const gchar* _tmp6_;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp5_ = didl_item;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp6_ = ((RygelMediaObject*) self)->ref_id;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_item_set_ref_id (_tmp5_, _tmp6_);
#line 911 "rygel-media-item.c"
	}
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp7_ = ((RygelMediaObject*) self)->parent;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp7_ != NULL) {
#line 917 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp8_;
		RygelMediaContainer* _tmp9_;
		const gchar* _tmp10_;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp8_ = didl_item;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp9_ = ((RygelMediaObject*) self)->parent;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp10_ = ((RygelMediaObject*) _tmp9_)->id;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp8_, _tmp10_);
#line 929 "rygel-media-item.c"
	} else {
		GUPnPDIDLLiteItem* _tmp11_;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp11_ = didl_item;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp11_, "0");
#line 936 "rygel-media-item.c"
	}
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp12_ = rygel_media_object_get_restricted ((RygelMediaObject*) self);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp13_ = _tmp12_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp13_) {
#line 944 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp14_;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp14_ = didl_item;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp14_, TRUE);
#line 950 "rygel-media-item.c"
	} else {
		GUPnPDIDLLiteItem* _tmp15_;
		GUPnPDIDLLiteItem* _tmp16_;
		GUPnPOCMFlags _tmp17_;
		GUPnPOCMFlags _tmp18_;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp15_ = didl_item;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp15_, FALSE);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp16_ = didl_item;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp17_ = rygel_media_object_get_ocm_flags ((RygelMediaObject*) self);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp18_ = _tmp17_;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_dlna_managed ((GUPnPDIDLLiteObject*) _tmp16_, _tmp18_);
#line 968 "rygel-media-item.c"
	}
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp19_ = didl_item;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp20_ = rygel_media_object_get_title ((RygelMediaObject*) self);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp21_ = _tmp20_;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) _tmp19_, _tmp21_);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp22_ = didl_item;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp23_ = ((RygelMediaObject*) self)->upnp_class;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _tmp22_, _tmp23_);
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp24_ = self->date;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp24_ != NULL) {
#line 988 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp25_;
		const gchar* _tmp26_;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp25_ = didl_item;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp26_ = self->date;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_date ((GUPnPDIDLLiteObject*) _tmp25_, _tmp26_);
#line 997 "rygel-media-item.c"
	}
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp27_ = self->priv->_description;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp27_ != NULL) {
#line 1003 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp28_;
		const gchar* _tmp29_;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp28_ = didl_item;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp29_ = self->priv->_description;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_description ((GUPnPDIDLLiteObject*) _tmp28_, _tmp29_);
#line 1012 "rygel-media-item.c"
	}
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp30_ = http_server;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp31_ = didl_item;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	rygel_media_item_add_proxy_resources (self, _tmp30_, _tmp31_, &_inner_error_);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_inner_error_ != NULL) {
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_propagate_error (error, _inner_error_);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_object_unref0 (didl_item);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return NULL;
#line 1028 "rygel-media-item.c"
	}
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp32_ = self->priv->_place_holder;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (!_tmp32_) {
#line 1034 "rygel-media-item.c"
		RygelHTTPServer* _tmp33_;
		GUPnPContext* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* host_ip;
		gboolean internal_allowed = FALSE;
		gboolean _tmp38_ = FALSE;
		RygelHTTPServer* _tmp39_;
		GUPnPContext* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		gboolean _tmp44_;
		GUPnPDIDLLiteItem* _tmp45_;
		gboolean _tmp46_;
		GUPnPDIDLLiteItem* _tmp47_;
		GList* _tmp48_ = NULL;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp33_ = http_server;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp34_ = _tmp33_->context;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp35_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp34_);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp36_ = _tmp35_;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		host_ip = _tmp37_;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp39_ = http_server;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp40_ = _tmp39_->context;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp41_ = gssdp_client_get_interface ((GSSDPClient*) _tmp40_);
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp42_ = _tmp41_;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (g_strcmp0 (_tmp42_, "lo") == 0) {
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp38_ = TRUE;
#line 1076 "rygel-media-item.c"
		} else {
			const gchar* _tmp43_;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp43_ = host_ip;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp38_ = g_strcmp0 (_tmp43_, "127.0.0.1") == 0;
#line 1083 "rygel-media-item.c"
		}
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp44_ = _tmp38_;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		internal_allowed = _tmp44_;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp45_ = didl_item;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp46_ = internal_allowed;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_add_resources (self, _tmp45_, _tmp46_, &_inner_error_);
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_inner_error_ != NULL) {
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_propagate_error (error, _inner_error_);
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (host_ip);
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_object_unref0 (didl_item);
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return NULL;
#line 1105 "rygel-media-item.c"
		}
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp47_ = didl_item;
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp48_ = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) _tmp47_);
#line 1111 "rygel-media-item.c"
		{
			GList* res_collection = NULL;
			GList* res_it = NULL;
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			res_collection = _tmp48_;
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			for (res_it = res_collection; res_it != NULL; res_it = res_it->next) {
#line 1119 "rygel-media-item.c"
				GUPnPDIDLLiteResource* _tmp49_;
				GUPnPDIDLLiteResource* res = NULL;
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp49_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) res_it->data);
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				res = _tmp49_;
#line 1126 "rygel-media-item.c"
				{
					GRegex* _tmp50_;
					GUPnPDIDLLiteResource* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp53_;
					const gchar* _tmp54_;
					gchar* _tmp55_ = NULL;
					gchar* _tmp56_;
					GUPnPDIDLLiteResource* _tmp57_;
					gchar* _tmp58_;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp50_ = self->address_regex;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp51_ = res;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp52_ = gupnp_didl_lite_resource_get_uri (_tmp51_);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp53_ = _tmp52_;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp54_ = host_ip;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp55_ = g_regex_replace_literal (_tmp50_, _tmp53_, (gssize) (-1), 0, _tmp54_, 0, &_inner_error_);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp56_ = _tmp55_;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					if (_inner_error_ != NULL) {
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
						g_propagate_error (error, _inner_error_);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
						_g_object_unref0 (res);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
						__g_list_free__g_object_unref0_0 (res_collection);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
						_g_free0 (host_ip);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
						_g_object_unref0 (didl_item);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
						return NULL;
#line 1165 "rygel-media-item.c"
					}
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp57_ = res;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_tmp58_ = _tmp56_;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					gupnp_didl_lite_resource_set_uri (_tmp57_, _tmp58_);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_g_free0 (_tmp58_);
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_g_object_unref0 (res);
#line 1177 "rygel-media-item.c"
				}
			}
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			__g_list_free__g_object_unref0_0 (res_collection);
#line 1182 "rygel-media-item.c"
		}
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_free0 (host_ip);
#line 1186 "rygel-media-item.c"
	}
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = (GUPnPDIDLLiteObject*) didl_item;
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 1192 "rygel-media-item.c"
}


static void rygel_media_item_real_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	RygelHTTPServer* _tmp0_;
	GUPnPDIDLLiteItem* _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (server != NULL);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = server;
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = didl_item;
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	rygel_http_server_add_proxy_resource (_tmp0_, _tmp1_, self, &_inner_error_);
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_inner_error_ != NULL) {
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_propagate_error (error, _inner_error_);
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return;
#line 1217 "rygel-media-item.c"
	}
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = self->priv->_place_holder;
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (!_tmp2_) {
#line 1223 "rygel-media-item.c"
		RygelHTTPServer* _tmp3_;
		GUPnPDIDLLiteItem* _tmp4_;
#line 250 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp3_ = server;
#line 250 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp4_ = didl_item;
#line 250 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_transcode_manager_add_resources ((RygelTranscodeManager*) _tmp3_, _tmp4_, self, &_inner_error_);
#line 250 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_inner_error_ != NULL) {
#line 250 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_propagate_error (error, _inner_error_);
#line 250 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return;
#line 1238 "rygel-media-item.c"
		}
	}
}


void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_proxy_resources (self, server, didl_item, error);
#line 1249 "rygel-media-item.c"
}


static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol) {
	GUPnPProtocolInfo* result = NULL;
	GUPnPProtocolInfo* _tmp0_;
	GUPnPProtocolInfo* protocol_info;
	GUPnPProtocolInfo* _tmp1_;
	const gchar* _tmp2_;
	GUPnPProtocolInfo* _tmp3_;
	const gchar* _tmp4_;
	GUPnPProtocolInfo* _tmp5_;
	const gchar* _tmp6_;
	GUPnPProtocolInfo* _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	gboolean _tmp11_ = FALSE;
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = gupnp_protocol_info_new ();
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	protocol_info = _tmp0_;
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = protocol_info;
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = self->mime_type;
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_protocol_info_set_mime_type (_tmp1_, _tmp2_);
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = protocol_info;
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp4_ = self->dlna_profile;
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_protocol_info_set_dlna_profile (_tmp3_, _tmp4_);
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp5_ = protocol_info;
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp6_ = protocol;
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_protocol_info_set_protocol (_tmp5_, _tmp6_);
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp7_ = protocol_info;
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_protocol_info_set_dlna_flags (_tmp7_, (GUPNP_DLNA_FLAGS_DLNA_V15 | GUPNP_DLNA_FLAGS_CONNECTION_STALL) | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE);
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp8_ = rygel_media_item_get_size (self);
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp9_ = _tmp8_;
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp9_ > ((gint64) 0)) {
#line 1301 "rygel-media-item.c"
		GUPnPProtocolInfo* _tmp10_;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp10_ = protocol_info;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_operation (_tmp10_, GUPNP_DLNA_OPERATION_RANGE);
#line 1307 "rygel-media-item.c"
	}
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp11_ = rygel_media_item_streamable (self);
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp11_) {
#line 1313 "rygel-media-item.c"
		GUPnPProtocolInfo* _tmp12_;
		GUPnPProtocolInfo* _tmp13_;
		GUPnPDLNAFlags _tmp14_;
		GUPnPDLNAFlags _tmp15_;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp12_ = protocol_info;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp13_ = protocol_info;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp14_ = gupnp_protocol_info_get_dlna_flags (_tmp13_);
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp15_ = _tmp14_;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_flags (_tmp13_, _tmp15_ | GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
#line 1328 "rygel-media-item.c"
	}
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = protocol_info;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 1334 "rygel-media-item.c"
}


GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol) {
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->get_protocol_info (self, uri, protocol);
#line 1343 "rygel-media-item.c"
}


gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* scheme;
	const gchar* _tmp2_;
	const gchar* _tmp6_;
	GError * _inner_error_ = NULL;
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 277 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = uri;
#line 277 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = g_uri_parse_scheme (_tmp0_);
#line 277 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	scheme = _tmp1_;
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = scheme;
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp2_ == NULL) {
#line 1369 "rygel-media-item.c"
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		GError* _tmp5_;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp3_ = _ ("Bad URI: %s");
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp4_ = uri;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp5_ = g_error_new (RYGEL_MEDIA_ITEM_ERROR, RYGEL_MEDIA_ITEM_ERROR_BAD_URI, _tmp3_, _tmp4_);
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_inner_error_ = _tmp5_;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_propagate_error (error, _inner_error_);
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_free0 (scheme);
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return NULL;
#line 1387 "rygel-media-item.c"
	}
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp6_ = scheme;
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (g_strcmp0 (_tmp6_, "http") == 0) {
#line 1393 "rygel-media-item.c"
		gchar* _tmp7_;
#line 283 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp7_ = g_strdup ("http-get");
#line 283 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		result = _tmp7_;
#line 283 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_free0 (scheme);
#line 283 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return result;
#line 1403 "rygel-media-item.c"
	} else {
		const gchar* _tmp8_;
#line 284 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp8_ = scheme;
#line 284 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (g_strcmp0 (_tmp8_, "file") == 0) {
#line 1410 "rygel-media-item.c"
			gchar* _tmp9_;
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp9_ = g_strdup ("internal");
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			result = _tmp9_;
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (scheme);
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return result;
#line 1420 "rygel-media-item.c"
		} else {
			const gchar* _tmp10_;
#line 286 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp10_ = scheme;
#line 286 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (g_strcmp0 (_tmp10_, "rtsp") == 0) {
#line 1427 "rygel-media-item.c"
				gchar* _tmp11_;
#line 288 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp11_ = g_strdup ("rtsp-rtp-udp");
#line 288 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				result = _tmp11_;
#line 288 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_free0 (scheme);
#line 288 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				return result;
#line 1437 "rygel-media-item.c"
			} else {
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
#line 291 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp12_ = _ ("Failed to probe protocol for URI %s. Assuming '%s'");
#line 291 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp13_ = uri;
#line 291 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp14_ = scheme;
#line 291 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				g_warning (_tmp12_, _tmp13_, _tmp14_);
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				result = scheme;
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				return result;
#line 1454 "rygel-media-item.c"
			}
		}
	}
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (scheme);
#line 1460 "rygel-media-item.c"
}


static void rygel_media_item_real_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	GError * _inner_error_ = NULL;
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 1468 "rygel-media-item.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _uri_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _uri_size;
		gint _uri_index;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp0_ = ((RygelMediaObject*) self)->uris;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_uri_list = _tmp1_;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp2_ = _uri_list;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp4_ = _tmp3_;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_uri_size = _tmp4_;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_uri_index = -1;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		while (TRUE) {
#line 1496 "rygel-media-item.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* uri;
			const gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* protocol;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			gboolean _tmp16_;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp5_ = _uri_index;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_uri_index = _tmp5_ + 1;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp6_ = _uri_index;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp7_ = _uri_size;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				break;
#line 1522 "rygel-media-item.c"
			}
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp8_ = _uri_list;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp9_ = _uri_index;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			uri = (gchar*) _tmp10_;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp11_ = uri;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp12_ = rygel_media_item_get_protocol_for_uri (self, _tmp11_, &_inner_error_);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			protocol = _tmp12_;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (_inner_error_ != NULL) {
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				g_propagate_error (error, _inner_error_);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_free0 (uri);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_object_unref0 (_uri_list);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				return;
#line 1548 "rygel-media-item.c"
			}
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp14_ = allow_internal;
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (_tmp14_) {
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp13_ = TRUE;
#line 1556 "rygel-media-item.c"
			} else {
				const gchar* _tmp15_;
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp15_ = protocol;
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp13_ = g_strcmp0 (_tmp15_, "internal") != 0;
#line 1563 "rygel-media-item.c"
			}
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp16_ = _tmp13_;
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (_tmp16_) {
#line 1569 "rygel-media-item.c"
				GUPnPDIDLLiteItem* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				GUPnPDIDLLiteResource* _tmp20_ = NULL;
				GUPnPDIDLLiteResource* _tmp21_;
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp17_ = didl_item;
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp18_ = uri;
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp19_ = protocol;
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp20_ = rygel_media_item_add_resource (self, _tmp17_, _tmp18_, _tmp19_, NULL, &_inner_error_);
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp21_ = _tmp20_;
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_object_unref0 (_tmp21_);
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				if (_inner_error_ != NULL) {
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					g_propagate_error (error, _inner_error_);
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_g_free0 (protocol);
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_g_free0 (uri);
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					_g_object_unref0 (_uri_list);
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
					return;
#line 1599 "rygel-media-item.c"
				}
			}
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (protocol);
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (uri);
#line 1606 "rygel-media-item.c"
		}
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_object_unref0 (_uri_list);
#line 1610 "rygel-media-item.c"
	}
}


void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_resources (self, didl_item, allow_internal, error);
#line 1620 "rygel-media-item.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 1224 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1224 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1225 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1225 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1225 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1225 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	return result;
#line 1640 "rygel-media-item.c"
}


static gint rygel_media_item_compare_by_date (RygelMediaItem* self, RygelMediaItem* item) {
	gint result = 0;
	const gchar* _tmp0_;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (item != NULL, 0);
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->date;
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp0_ == NULL) {
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		result = -1;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return result;
#line 1659 "rygel-media-item.c"
	} else {
		RygelMediaItem* _tmp1_;
		const gchar* _tmp2_;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp1_ = item;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp2_ = _tmp1_->date;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_tmp2_ == NULL) {
#line 315 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			result = 1;
#line 315 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return result;
#line 1673 "rygel-media-item.c"
		} else {
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* our_date;
			RygelMediaItem* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* other_date;
			const gchar* _tmp8_;
			gboolean _tmp9_ = FALSE;
			const gchar* _tmp12_;
			gboolean _tmp13_ = FALSE;
			GTimeVal tv1 = {0};
			const gchar* _tmp16_;
			gboolean _tmp17_ = FALSE;
			GTimeVal tv2 = {0};
			RygelMediaItem* _tmp18_;
			const gchar* _tmp19_;
			gboolean _tmp20_ = FALSE;
			GTimeVal _tmp21_;
			glong _tmp22_;
			GTimeVal _tmp23_;
			glong _tmp24_;
			gint _tmp25_ = 0;
			gint ret;
			gint _tmp26_;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp3_ = self->date;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp4_ = g_strdup (_tmp3_);
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			our_date = _tmp4_;
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp5_ = item;
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp6_ = _tmp5_->date;
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			other_date = _tmp7_;
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp8_ = our_date;
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp9_ = string_contains (_tmp8_, "T");
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (!_tmp9_) {
#line 1720 "rygel-media-item.c"
				const gchar* _tmp10_;
				gchar* _tmp11_;
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp10_ = our_date;
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp11_ = g_strconcat (_tmp10_, "T00:00:00Z", NULL);
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_free0 (our_date);
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				our_date = _tmp11_;
#line 1731 "rygel-media-item.c"
			}
#line 324 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp12_ = other_date;
#line 324 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp13_ = string_contains (_tmp12_, "T");
#line 324 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (!_tmp13_) {
#line 1739 "rygel-media-item.c"
				const gchar* _tmp14_;
				gchar* _tmp15_;
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp14_ = other_date;
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp15_ = g_strconcat (_tmp14_, "T00:00:00Z", NULL);
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_g_free0 (other_date);
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				other_date = _tmp15_;
#line 1750 "rygel-media-item.c"
			}
#line 328 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_get_current_time (&tv1);
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp16_ = self->date;
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp17_ = g_time_val_from_iso8601 (_tmp16_, &tv1);
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_vala_assert (_tmp17_, "tv1.from_iso8601 (this.date)");
#line 331 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			g_get_current_time (&tv2);
#line 332 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp18_ = item;
#line 332 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp19_ = _tmp18_->date;
#line 332 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp20_ = g_time_val_from_iso8601 (_tmp19_, &tv2);
#line 332 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_vala_assert (_tmp20_, "tv2.from_iso8601 (item.date)");
#line 334 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp21_ = tv1;
#line 334 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp22_ = _tmp21_.tv_sec;
#line 334 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp23_ = tv2;
#line 334 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp24_ = _tmp23_.tv_sec;
#line 334 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp25_ = rygel_media_item_compare_long (self, _tmp22_, _tmp24_);
#line 334 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			ret = _tmp25_;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_tmp26_ = ret;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			if (_tmp26_ == 0) {
#line 1786 "rygel-media-item.c"
				GTimeVal _tmp27_;
				glong _tmp28_;
				GTimeVal _tmp29_;
				glong _tmp30_;
				gint _tmp31_ = 0;
#line 336 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp27_ = tv1;
#line 336 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp28_ = _tmp27_.tv_usec;
#line 336 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp29_ = tv2;
#line 336 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp30_ = _tmp29_.tv_usec;
#line 336 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				_tmp31_ = rygel_media_item_compare_long (self, _tmp28_, _tmp30_);
#line 336 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
				ret = _tmp31_;
#line 1804 "rygel-media-item.c"
			}
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			result = ret;
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (other_date);
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			_g_free0 (our_date);
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return result;
#line 1814 "rygel-media-item.c"
		}
	}
}


static gint rygel_media_item_compare_long (RygelMediaItem* self, glong a, glong b) {
	gint result = 0;
	glong _tmp0_;
	glong _tmp1_;
#line 343 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 344 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = a;
#line 344 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = b;
#line 344 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp0_ < _tmp1_) {
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		result = -1;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return result;
#line 1836 "rygel-media-item.c"
	} else {
		glong _tmp2_;
		glong _tmp3_;
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp2_ = a;
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp3_ = b;
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_tmp2_ > _tmp3_) {
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			result = 1;
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return result;
#line 1850 "rygel-media-item.c"
		} else {
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			result = 0;
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
			return result;
#line 1856 "rygel-media-item.c"
		}
	}
}


gint64 rygel_media_item_get_size (RygelMediaItem* self) {
	gint64 result;
	gint64 _tmp0_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->priv->_size;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp0_;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 1873 "rygel-media-item.c"
}


void rygel_media_item_set_size (RygelMediaItem* self, gint64 value) {
	gint64 _tmp0_;
	gint64 _tmp1_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = value;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp0_ == ((gint64) 0)) {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_set_place_holder (self, TRUE);
#line 1888 "rygel-media-item.c"
	}
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = value;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_size = _tmp1_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_notify ((GObject *) self, "size");
#line 1896 "rygel-media-item.c"
}


gboolean rygel_media_item_get_place_holder (RygelMediaItem* self) {
	gboolean result;
	gboolean _tmp0_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->priv->_place_holder;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp0_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 1911 "rygel-media-item.c"
}


void rygel_media_item_set_place_holder (RygelMediaItem* self, gboolean value) {
	gboolean _tmp0_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = value;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_place_holder = _tmp0_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_notify ((GObject *) self, "place-holder");
#line 1925 "rygel-media-item.c"
}


const gchar* rygel_media_item_get_description (RygelMediaItem* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->priv->_description;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp0_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 1940 "rygel-media-item.c"
}


void rygel_media_item_set_description (RygelMediaItem* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = value;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->priv->_description);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_description = _tmp1_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_notify ((GObject *) self, "description");
#line 1959 "rygel-media-item.c"
}


static GUPnPOCMFlags rygel_media_item_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaItem* self;
	gboolean _tmp0_;
	RygelMetaConfig* _tmp1_ = NULL;
	RygelMetaConfig* config;
	gboolean allow_deletion;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = (RygelMediaItem*) base;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->priv->_place_holder;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp0_) {
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		result = GUPNP_OCM_FLAGS_DESTROYABLE;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return result;
#line 1982 "rygel-media-item.c"
	}
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = rygel_meta_config_get_default ();
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	config = _tmp1_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	allow_deletion = TRUE;
#line 1990 "rygel-media-item.c"
	{
		RygelMetaConfig* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp2_ = config;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp3_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp2_, &_inner_error_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp4_ = _tmp3_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		if (_inner_error_ != NULL) {
#line 2003 "rygel-media-item.c"
			goto __catch9_g_error;
		}
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		allow_deletion = _tmp4_;
#line 2008 "rygel-media-item.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* _error_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_error_ = _inner_error_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_inner_error_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_error_free0 (_error_);
#line 2020 "rygel-media-item.c"
	}
	__finally9:
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_inner_error_ != NULL) {
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_object_unref0 (config);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_clear_error (&_inner_error_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return 0;
#line 2033 "rygel-media-item.c"
	}
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp5_ = allow_deletion;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp5_) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		result = GUPNP_OCM_FLAGS_DESTROYABLE;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_object_unref0 (config);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return result;
#line 2045 "rygel-media-item.c"
	} else {
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		result = GUPNP_OCM_FLAGS_NONE;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_object_unref0 (config);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		return result;
#line 2053 "rygel-media-item.c"
	}
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_object_unref0 (config);
#line 2057 "rygel-media-item.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaItemPrivate));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->create_stream_source = rygel_media_item_real_create_stream_source;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->streamable = rygel_media_item_real_streamable;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_uri = rygel_media_item_real_add_uri;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resource = rygel_media_item_real_add_resource;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_media_item_real_compare_by_property;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_item_real_serialize;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_media_item_real_add_proxy_resources;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->get_protocol_info = rygel_media_item_real_get_protocol_info;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_media_item_real_add_resources;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_item_real_get_ocm_flags;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_item_get_property;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_item_set_property;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_SIZE, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_PLACE_HOLDER, g_param_spec_boolean ("place-holder", "place-holder", "place-holder", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_OCM_FLAGS, g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", GUPNP_TYPE_OCM_FLAGS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2100 "rygel-media-item.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv = RYGEL_MEDIA_ITEM_GET_PRIVATE (self);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_size = (gint64) (-1);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_place_holder = FALSE;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_description = NULL;
#line 2113 "rygel-media-item.c"
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->date);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->mime_type);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->dlna_profile);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->priv->_description);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_regex_unref0 (self->address_regex);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
#line 2133 "rygel-media-item.c"
}


/**
 * Represents a media (Music, Video and Image) item.
 */
GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


static void _vala_rygel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	switch (property_id) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_SIZE:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_value_set_int64 (value, rygel_media_item_get_size (self));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_PLACE_HOLDER:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_value_set_boolean (value, rygel_media_item_get_place_holder (self));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_DESCRIPTION:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_value_set_string (value, rygel_media_item_get_description (self));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_OCM_FLAGS:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_value_set_flags (value, rygel_media_object_get_ocm_flags ((RygelMediaObject*) self));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 2181 "rygel-media-item.c"
		default:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 2187 "rygel-media-item.c"
	}
}


static void _vala_rygel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	switch (property_id) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_SIZE:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_set_size (self, g_value_get_int64 (value));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_PLACE_HOLDER:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_set_place_holder (self, g_value_get_boolean (value));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_DESCRIPTION:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_set_description (self, g_value_get_string (value));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 2215 "rygel-media-item.c"
		default:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 2221 "rygel-media-item.c"
	}
}



