/* rygel-tracker-music-item-factory.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-tracker-music-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008-2012 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *          Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gee.h>
#include <rygel-core.h>


#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;

#define RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY (rygel_tracker_music_item_factory_get_type ())
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY, RygelTrackerMusicItemFactory))
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY, RygelTrackerMusicItemFactoryClass))
#define RYGEL_TRACKER_IS_MUSIC_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_MUSIC_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY))
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY, RygelTrackerMusicItemFactoryClass))

typedef struct _RygelTrackerMusicItemFactory RygelTrackerMusicItemFactory;
typedef struct _RygelTrackerMusicItemFactoryClass RygelTrackerMusicItemFactoryClass;
typedef struct _RygelTrackerMusicItemFactoryPrivate RygelTrackerMusicItemFactoryPrivate;

#define RYGEL_TRACKER_ITEM_FACTORY_TYPE_METADATA (rygel_tracker_item_factory_metadata_get_type ())

#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_TYPE_MUSIC_METADATA (rygel_tracker_music_item_factory_music_metadata_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* category_iri;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
};

struct _RygelTrackerMusicItemFactory {
	RygelTrackerItemFactory parent_instance;
	RygelTrackerMusicItemFactoryPrivate * priv;
};

struct _RygelTrackerMusicItemFactoryClass {
	RygelTrackerItemFactoryClass parent_class;
};

typedef enum  {
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_TRACKER_ID,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_URL,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_PLACE_HOLDER,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_FILE_NAME,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_MIME,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY
} RygelTrackerItemFactoryMetadata;

typedef enum  {
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION = RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY
} RygelTrackerMusicItemFactoryMusicMetadata;


static gpointer rygel_tracker_music_item_factory_parent_class = NULL;

gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
GType rygel_tracker_music_item_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_DUMMY_PROPERTY
};
GType rygel_tracker_item_factory_metadata_get_type (void) G_GNUC_CONST;
static GType rygel_tracker_music_item_factory_music_metadata_get_type (void) G_GNUC_UNUSED;
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CATEGORY "nmm:MusicPiece"
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CATEGORY_IRI "http://www.tracker-project.org/" "temp/nmm#MusicPiece"
RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_new (void);
RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_construct (GType object_type);
RygelTrackerItemFactory* rygel_tracker_item_factory_construct (GType object_type, const gchar* category, const gchar* category_iri, const gchar* upnp_class, const gchar* upload_dir);
static RygelMediaItem* rygel_tracker_music_item_factory_real_create (RygelTrackerItemFactory* base, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
void rygel_tracker_item_factory_set_metadata (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
static void rygel_tracker_music_item_factory_real_set_metadata (RygelTrackerItemFactory* base, RygelMediaItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
void rygel_tracker_item_factory_set_ref_id (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* prefix);


static GType rygel_tracker_music_item_factory_music_metadata_get_type (void) {
	static volatile gsize rygel_tracker_music_item_factory_music_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_music_item_factory_music_metadata_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION", "duration"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM", "audio-album"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST", "audio-artist"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM", "audio-track-num"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE", "audio-genre"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE", "sample-rate"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS", "channels"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE", "bits-per-sample"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE", "bitrate"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY", "last-key"}, {0, NULL, NULL}};
		GType rygel_tracker_music_item_factory_music_metadata_type_id;
		rygel_tracker_music_item_factory_music_metadata_type_id = g_enum_register_static ("RygelTrackerMusicItemFactoryMusicMetadata", values);
		g_once_init_leave (&rygel_tracker_music_item_factory_music_metadata_type_id__volatile, rygel_tracker_music_item_factory_music_metadata_type_id);
	}
	return rygel_tracker_music_item_factory_music_metadata_type_id__volatile;
}


RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_construct (GType object_type) {
	RygelTrackerMusicItemFactory* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* upload_folder;
	const gchar* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	_tmp1_ = g_strdup (_tmp0_);
	upload_folder = _tmp1_;
	{
		RygelMetaConfig* _tmp2_ = NULL;
		RygelMetaConfig* config;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp2_ = rygel_meta_config_get_default ();
		config = _tmp2_;
		_tmp3_ = rygel_configuration_get_music_upload_folder ((RygelConfiguration*) config, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (config);
			goto __catch12_g_error;
		}
		_g_free0 (upload_folder);
		upload_folder = _tmp4_;
		_g_object_unref0 (config);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_free0 (upload_folder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp5_ = upload_folder;
	self = (RygelTrackerMusicItemFactory*) rygel_tracker_item_factory_construct (object_type, RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CATEGORY, RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CATEGORY_IRI, RYGEL_MUSIC_ITEM_UPNP_CLASS, _tmp5_);
	_tmp6_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, "res@duration");
	_tmp7_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, "upnp:album");
	_tmp8_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, "upnp:artist");
	_tmp9_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, "upnp:originalTrackNumber");
	_tmp10_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, "upnp:genre");
	_tmp11_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, "sampleRate");
	_tmp12_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, "upnp:nrAudioChannels");
	_tmp13_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, "upnp:bitsPerSample");
	_tmp14_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, "upnp:bitrate");
	_g_free0 (upload_folder);
	return self;
}


RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_new (void) {
	return rygel_tracker_music_item_factory_construct (RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY);
}


static RygelMediaItem* rygel_tracker_music_item_factory_real_create (RygelTrackerItemFactory* base, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error) {
	RygelTrackerMusicItemFactory * self;
	RygelMediaItem* result = NULL;
	const gchar* _tmp0_;
	RygelTrackerSearchContainer* _tmp1_;
	RygelMusicItem* _tmp2_;
	RygelMusicItem* item;
	const gchar* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (RygelTrackerMusicItemFactory*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (metadata != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = rygel_music_item_new (_tmp0_, (RygelMediaContainer*) _tmp1_, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
	item = _tmp2_;
	_tmp3_ = uri;
	_tmp4_ = metadata;
	rygel_tracker_item_factory_set_metadata ((RygelTrackerItemFactory*) self, (RygelMediaItem*) item, _tmp3_, _tmp4_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (item);
		return NULL;
	}
	result = (RygelMediaItem*) item;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_tracker_music_item_factory_real_set_metadata (RygelTrackerItemFactory* base, RygelMediaItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error) {
	RygelTrackerMusicItemFactory * self;
	RygelMediaItem* _tmp0_;
	const gchar* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	RygelMediaItem* _tmp3_;
	RygelMediaItem* _tmp4_;
	RygelMusicItem* _tmp5_;
	RygelMusicItem* music;
	gboolean _tmp6_ = FALSE;
	TrackerSparqlCursor* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp11_;
	TrackerSparqlCursor* _tmp15_;
	gboolean _tmp16_ = FALSE;
	TrackerSparqlCursor* _tmp20_;
	gboolean _tmp21_ = FALSE;
	TrackerSparqlCursor* _tmp25_;
	gboolean _tmp26_ = FALSE;
	TrackerSparqlCursor* _tmp30_;
	gboolean _tmp31_ = FALSE;
	TrackerSparqlCursor* _tmp35_;
	gboolean _tmp36_ = FALSE;
	TrackerSparqlCursor* _tmp40_;
	gboolean _tmp41_ = FALSE;
	TrackerSparqlCursor* _tmp46_;
	gboolean _tmp47_ = FALSE;
	TrackerSparqlCursor* _tmp52_;
	gboolean _tmp53_ = FALSE;
	RygelMusicItem* _tmp58_;
	GError * _inner_error_ = NULL;
	self = (RygelTrackerMusicItemFactory*) base;
	g_return_if_fail (item != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = item;
	_tmp1_ = uri;
	_tmp2_ = metadata;
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (rygel_tracker_music_item_factory_parent_class)->set_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory), _tmp0_, _tmp1_, _tmp2_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = item;
	rygel_tracker_item_factory_set_ref_id ((RygelTrackerItemFactory*) self, _tmp3_, "AllMusic");
	_tmp4_ = item;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp4_) : NULL);
	music = _tmp5_;
	_tmp7_ = metadata;
	_tmp8_ = tracker_sparql_cursor_is_bound (_tmp7_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION);
	if (_tmp8_) {
		TrackerSparqlCursor* _tmp9_;
		const gchar* _tmp10_ = NULL;
		_tmp9_ = metadata;
		_tmp10_ = tracker_sparql_cursor_get_string (_tmp9_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION, NULL);
		_tmp6_ = g_strcmp0 (_tmp10_, "0") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		RygelMusicItem* _tmp12_;
		TrackerSparqlCursor* _tmp13_;
		gint64 _tmp14_ = 0LL;
		_tmp12_ = music;
		_tmp13_ = metadata;
		_tmp14_ = tracker_sparql_cursor_get_integer (_tmp13_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION);
		((RygelAudioItem*) _tmp12_)->duration = (glong) _tmp14_;
	}
	_tmp15_ = metadata;
	_tmp16_ = tracker_sparql_cursor_is_bound (_tmp15_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE);
	if (_tmp16_) {
		RygelMusicItem* _tmp17_;
		TrackerSparqlCursor* _tmp18_;
		gint64 _tmp19_ = 0LL;
		_tmp17_ = music;
		_tmp18_ = metadata;
		_tmp19_ = tracker_sparql_cursor_get_integer (_tmp18_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE);
		((RygelAudioItem*) _tmp17_)->sample_freq = (gint) _tmp19_;
	}
	_tmp20_ = metadata;
	_tmp21_ = tracker_sparql_cursor_is_bound (_tmp20_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS);
	if (_tmp21_) {
		RygelMusicItem* _tmp22_;
		TrackerSparqlCursor* _tmp23_;
		gint64 _tmp24_ = 0LL;
		_tmp22_ = music;
		_tmp23_ = metadata;
		_tmp24_ = tracker_sparql_cursor_get_integer (_tmp23_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS);
		((RygelAudioItem*) _tmp22_)->channels = (gint) _tmp24_;
	}
	_tmp25_ = metadata;
	_tmp26_ = tracker_sparql_cursor_is_bound (_tmp25_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE);
	if (_tmp26_) {
		RygelMusicItem* _tmp27_;
		TrackerSparqlCursor* _tmp28_;
		gint64 _tmp29_ = 0LL;
		_tmp27_ = music;
		_tmp28_ = metadata;
		_tmp29_ = tracker_sparql_cursor_get_integer (_tmp28_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE);
		((RygelAudioItem*) _tmp27_)->bits_per_sample = (gint) _tmp29_;
	}
	_tmp30_ = metadata;
	_tmp31_ = tracker_sparql_cursor_is_bound (_tmp30_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE);
	if (_tmp31_) {
		RygelMusicItem* _tmp32_;
		TrackerSparqlCursor* _tmp33_;
		gint64 _tmp34_ = 0LL;
		_tmp32_ = music;
		_tmp33_ = metadata;
		_tmp34_ = tracker_sparql_cursor_get_integer (_tmp33_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE);
		((RygelAudioItem*) _tmp32_)->bitrate = ((gint) _tmp34_) / 8;
	}
	_tmp35_ = metadata;
	_tmp36_ = tracker_sparql_cursor_is_bound (_tmp35_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM);
	if (_tmp36_) {
		RygelMusicItem* _tmp37_;
		TrackerSparqlCursor* _tmp38_;
		gint64 _tmp39_ = 0LL;
		_tmp37_ = music;
		_tmp38_ = metadata;
		_tmp39_ = tracker_sparql_cursor_get_integer (_tmp38_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM);
		_tmp37_->track_number = (gint) _tmp39_;
	}
	_tmp40_ = metadata;
	_tmp41_ = tracker_sparql_cursor_is_bound (_tmp40_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST);
	if (_tmp41_) {
		RygelMusicItem* _tmp42_;
		TrackerSparqlCursor* _tmp43_;
		const gchar* _tmp44_ = NULL;
		gchar* _tmp45_;
		_tmp42_ = music;
		_tmp43_ = metadata;
		_tmp44_ = tracker_sparql_cursor_get_string (_tmp43_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST, NULL);
		_tmp45_ = g_strdup (_tmp44_);
		_g_free0 (_tmp42_->artist);
		_tmp42_->artist = _tmp45_;
	}
	_tmp46_ = metadata;
	_tmp47_ = tracker_sparql_cursor_is_bound (_tmp46_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM);
	if (_tmp47_) {
		RygelMusicItem* _tmp48_;
		TrackerSparqlCursor* _tmp49_;
		const gchar* _tmp50_ = NULL;
		gchar* _tmp51_;
		_tmp48_ = music;
		_tmp49_ = metadata;
		_tmp50_ = tracker_sparql_cursor_get_string (_tmp49_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM, NULL);
		_tmp51_ = g_strdup (_tmp50_);
		_g_free0 (_tmp48_->album);
		_tmp48_->album = _tmp51_;
	}
	_tmp52_ = metadata;
	_tmp53_ = tracker_sparql_cursor_is_bound (_tmp52_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE);
	if (_tmp53_) {
		RygelMusicItem* _tmp54_;
		TrackerSparqlCursor* _tmp55_;
		const gchar* _tmp56_ = NULL;
		gchar* _tmp57_;
		_tmp54_ = music;
		_tmp55_ = metadata;
		_tmp56_ = tracker_sparql_cursor_get_string (_tmp55_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE, NULL);
		_tmp57_ = g_strdup (_tmp56_);
		_g_free0 (_tmp54_->genre);
		_tmp54_->genre = _tmp57_;
	}
	_tmp58_ = music;
	rygel_music_item_lookup_album_art (_tmp58_);
	_g_object_unref0 (music);
}


static void rygel_tracker_music_item_factory_class_init (RygelTrackerMusicItemFactoryClass * klass) {
	rygel_tracker_music_item_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (klass)->create = rygel_tracker_music_item_factory_real_create;
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (klass)->set_metadata = rygel_tracker_music_item_factory_real_set_metadata;
}


static void rygel_tracker_music_item_factory_instance_init (RygelTrackerMusicItemFactory * self) {
}


/**
 * Tracker music item factory.
 */
GType rygel_tracker_music_item_factory_get_type (void) {
	static volatile gsize rygel_tracker_music_item_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_music_item_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerMusicItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_music_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerMusicItemFactory), 0, (GInstanceInitFunc) rygel_tracker_music_item_factory_instance_init, NULL };
		GType rygel_tracker_music_item_factory_type_id;
		rygel_tracker_music_item_factory_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_ITEM_FACTORY, "RygelTrackerMusicItemFactory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_music_item_factory_type_id__volatile, rygel_tracker_music_item_factory_type_id);
	}
	return rygel_tracker_music_item_factory_type_id__volatile;
}



