/* rygel-root-device-factory.c generated by valac 0.17.2.19-5f50d, the Vala compiler
 * generated from rygel-root-device-factory.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2007 OpenedHand Ltd.
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Authors: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                                <zeeshan.ali@nokia.com>
 *          Jorn Baayen <jorn@openedhand.com>
 *          Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <config.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <libgssdp/gssdp.h>
#include <gio/gio.h>
#include <uuid/uuid.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;
typedef struct _RygelRootDeviceFactoryPrivate RygelRootDeviceFactoryPrivate;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;
#define _rygel_root_device_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_root_device_factory_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define TYPE_DESCRIPTION_FILE (description_file_get_type ())
#define DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESCRIPTION_FILE, DescriptionFile))
#define DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESCRIPTION_FILE, DescriptionFileClass))
#define IS_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESCRIPTION_FILE))
#define IS_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESCRIPTION_FILE))
#define DESCRIPTION_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESCRIPTION_FILE, DescriptionFileClass))

typedef struct _DescriptionFile DescriptionFile;
typedef struct _DescriptionFileClass DescriptionFileClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
typedef struct _RygelParamSpecRootDeviceFactory RygelParamSpecRootDeviceFactory;

typedef enum  {
	ROOT_DEVICE_FACTORY_ERROR_XML_PARSE
} RootDeviceFactoryError;
#define ROOT_DEVICE_FACTORY_ERROR root_device_factory_error_quark ()
struct _RygelRootDeviceFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelRootDeviceFactoryPrivate * priv;
	GUPnPContext* context;
};

struct _RygelRootDeviceFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelRootDeviceFactory *self);
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_aac_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_avc_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelRootDeviceFactoryPrivate {
	RygelConfiguration* config;
	gchar* desc_dir;
};

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
	gchar* name;
	gchar* title;
	gchar* description;
	gchar* desc_path;
	GeeArrayList* resource_infos;
	GeeArrayList* icon_infos;
	GeeArrayList* default_icons;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
	void (*apply_hacks) (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
};

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

struct _RygelParamSpecRootDeviceFactory {
	GParamSpec parent_instance;
};


static gpointer rygel_root_device_factory_parent_class = NULL;

GQuark root_device_factory_error_quark (void);
gpointer rygel_root_device_factory_ref (gpointer instance);
void rygel_root_device_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_root_device_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_root_device_factory (GValue* value, gpointer v_object);
void rygel_value_take_root_device_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_root_device_factory (const GValue* value);
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
#define RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryPrivate))
enum  {
	RYGEL_ROOT_DEVICE_FACTORY_DUMMY_PROPERTY
};
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const gchar* dir_path, GError** error);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const gchar* desc_path, const gchar* template_path, GError** error);
RygelRootDevice* rygel_root_device_new (GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
RygelRootDevice* rygel_root_device_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
void rygel_plugin_apply_hacks (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
static GUPnPXMLDoc* rygel_root_device_factory_get_latest_doc (RygelRootDeviceFactory* self, const gchar* path1, const gchar* path2, GError** error);
static void rygel_root_device_factory_prepare_desc_for_plugin (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, RygelPlugin* plugin);
DescriptionFile* description_file_new_from_xml_document (GUPnPXMLDoc* doc);
DescriptionFile* description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc);
GType description_file_get_type (void) G_GNUC_CONST;
void description_file_save (DescriptionFile* self, const gchar* path, GError** error);
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
static void rygel_root_device_factory_set_friendly_name_and_udn (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* plugin_name, const gchar* plugin_title);
static void rygel_root_device_factory_set_dlnacap (RygelRootDeviceFactory* self, xmlNode* device_element);
static void rygel_root_device_factory_set_description (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* description);
static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin);
static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin);
gchar* rygel_configuration_get_title (RygelConfiguration* self, const gchar* section, GError** error);
static gchar* rygel_root_device_factory_generate_random_udn (RygelRootDeviceFactory* self);
gboolean rygel_configuration_get_allow_upload (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_allow_deletion (RygelConfiguration* self, GError** error);
static void rygel_root_device_factory_add_service_to_desc (RygelRootDeviceFactory* self, xmlNode* service_list_node, const gchar* plugin_name, RygelResourceInfo* resource_info);
static void rygel_root_device_factory_add_icon_to_desc (RygelRootDeviceFactory* self, xmlNode* icon_list_node, RygelIconInfo* icon_info, RygelPlugin* plugin);
static void rygel_root_device_factory_finalize (RygelRootDeviceFactory* obj);


GQuark root_device_factory_error_quark (void) {
	return g_quark_from_static_string ("root_device_factory_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error) {
	RygelRootDeviceFactory* self = NULL;
	RygelMetaConfig* _tmp0_ = NULL;
	GUPnPContext* _tmp1_;
	GUPnPContext* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* config_dir;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	self = (RygelRootDeviceFactory*) g_type_create_instance (object_type);
	_tmp0_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->config);
	self->priv->config = (RygelConfiguration*) _tmp0_;
	_tmp1_ = context;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->context);
	self->context = _tmp2_;
	_tmp3_ = g_get_user_config_dir ();
	_tmp4_ = g_strdup (_tmp3_);
	config_dir = _tmp4_;
	_tmp5_ = config_dir;
	rygel_root_device_factory_ensure_dir_exists (self, _tmp5_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (config_dir);
		_rygel_root_device_factory_unref0 (self);
		return NULL;
	}
	_tmp6_ = config_dir;
	_tmp7_ = g_get_application_name ();
	_tmp8_ = g_build_filename (_tmp6_, _tmp7_, NULL);
	_g_free0 (self->priv->desc_dir);
	self->priv->desc_dir = _tmp8_;
	_tmp9_ = self->priv->desc_dir;
	rygel_root_device_factory_ensure_dir_exists (self, _tmp9_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (config_dir);
		_rygel_root_device_factory_unref0 (self);
		return NULL;
	}
	_g_free0 (config_dir);
	return self;
}


RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error) {
	return rygel_root_device_factory_construct (RYGEL_TYPE_ROOT_DEVICE_FACTORY, context, error);
}


RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error) {
	RygelRootDevice* result = NULL;
	const gchar* _tmp0_;
	RygelPlugin* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* desc_path;
	RygelPlugin* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* template_path;
	RygelPlugin* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GUPnPXMLDoc* _tmp13_ = NULL;
	GUPnPXMLDoc* doc;
	GUPnPContext* _tmp14_;
	RygelPlugin* _tmp15_;
	GUPnPXMLDoc* _tmp16_;
	const gchar* _tmp17_;
	RygelRootDevice* _tmp18_;
	RygelRootDevice* device;
	RygelPlugin* _tmp19_;
	RygelRootDevice* _tmp20_;
	const gchar* _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	_tmp0_ = self->priv->desc_dir;
	_tmp1_ = plugin;
	_tmp2_ = _tmp1_->name;
	_tmp3_ = g_strconcat (_tmp2_, ".xml", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_build_filename (_tmp0_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	desc_path = _tmp6_;
	_tmp7_ = plugin;
	_tmp8_ = _tmp7_->desc_path;
	_tmp9_ = g_strdup (_tmp8_);
	template_path = _tmp9_;
	_tmp10_ = plugin;
	_tmp11_ = desc_path;
	_tmp12_ = template_path;
	_tmp13_ = rygel_root_device_factory_create_desc (self, _tmp10_, _tmp11_, _tmp12_, &_inner_error_);
	doc = _tmp13_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (template_path);
		_g_free0 (desc_path);
		return NULL;
	}
	_tmp14_ = self->context;
	_tmp15_ = plugin;
	_tmp16_ = doc;
	_tmp17_ = desc_path;
	_tmp18_ = rygel_root_device_new (_tmp14_, _tmp15_, _tmp16_, _tmp17_, DATA_DIR);
	device = _tmp18_;
	_tmp19_ = plugin;
	_tmp20_ = device;
	_tmp21_ = desc_path;
	rygel_plugin_apply_hacks (_tmp19_, _tmp20_, _tmp21_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (device);
		_g_object_unref0 (doc);
		_g_free0 (template_path);
		_g_free0 (desc_path);
		return NULL;
	}
	result = device;
	_g_object_unref0 (doc);
	_g_free0 (template_path);
	_g_free0 (desc_path);
	return result;
}


static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const gchar* desc_path, const gchar* template_path, GError** error) {
	GUPnPXMLDoc* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GUPnPXMLDoc* _tmp2_ = NULL;
	GUPnPXMLDoc* doc;
	GUPnPXMLDoc* _tmp3_;
	RygelPlugin* _tmp4_;
	GUPnPXMLDoc* _tmp5_;
	DescriptionFile* _tmp6_;
	DescriptionFile* file;
	DescriptionFile* _tmp7_;
	const gchar* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	g_return_val_if_fail (desc_path != NULL, NULL);
	g_return_val_if_fail (template_path != NULL, NULL);
	_tmp0_ = desc_path;
	_tmp1_ = template_path;
	_tmp2_ = rygel_root_device_factory_get_latest_doc (self, _tmp0_, _tmp1_, &_inner_error_);
	doc = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = doc;
	_tmp4_ = plugin;
	rygel_root_device_factory_prepare_desc_for_plugin (self, _tmp3_, _tmp4_);
	_tmp5_ = doc;
	_tmp6_ = description_file_new_from_xml_document (_tmp5_);
	file = _tmp6_;
	_tmp7_ = file;
	_tmp8_ = desc_path;
	description_file_save (_tmp7_, _tmp8_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		_g_object_unref0 (doc);
		return NULL;
	}
	result = doc;
	_g_object_unref0 (file);
	return result;
}


static void rygel_root_device_factory_prepare_desc_for_plugin (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, RygelPlugin* plugin) {
	xmlNode* device_element = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_ = NULL;
	xmlNode* _tmp3_;
	xmlNode* _tmp5_;
	RygelPlugin* _tmp6_;
	const gchar* _tmp7_;
	RygelPlugin* _tmp8_;
	const gchar* _tmp9_;
	xmlNode* _tmp10_;
	RygelPlugin* _tmp11_;
	const gchar* _tmp12_;
	xmlNode* _tmp16_;
	RygelPlugin* _tmp17_;
	xmlNode* _tmp18_;
	RygelPlugin* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", NULL, NULL);
	device_element = _tmp2_;
	_tmp3_ = device_element;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = _ ("XML node '%s' not found.");
		g_warning (_tmp4_, "/root/device");
		return;
	}
	_tmp5_ = device_element;
	_tmp6_ = plugin;
	_tmp7_ = _tmp6_->name;
	_tmp8_ = plugin;
	_tmp9_ = _tmp8_->title;
	rygel_root_device_factory_set_friendly_name_and_udn (self, _tmp5_, _tmp7_, _tmp9_);
	_tmp10_ = device_element;
	rygel_root_device_factory_set_dlnacap (self, _tmp10_);
	_tmp11_ = plugin;
	_tmp12_ = _tmp11_->description;
	if (_tmp12_ != NULL) {
		xmlNode* _tmp13_;
		RygelPlugin* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = device_element;
		_tmp14_ = plugin;
		_tmp15_ = _tmp14_->description;
		rygel_root_device_factory_set_description (self, _tmp13_, _tmp15_);
	}
	_tmp16_ = device_element;
	_tmp17_ = plugin;
	rygel_root_device_factory_add_icons_to_desc (self, _tmp16_, _tmp17_);
	_tmp18_ = device_element;
	_tmp19_ = plugin;
	rygel_root_device_factory_add_services_to_desc (self, _tmp18_, _tmp19_);
}


/**
     * Fills the description doc @doc with a friendly name, and UDN from gconf.
     * If these keys are not present in gconf, they are set with default values.
     */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void rygel_root_device_factory_set_friendly_name_and_udn (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* plugin_name, const gchar* plugin_title) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* element;
	xmlNode* _tmp2_;
	gchar* title = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	xmlNode* _tmp19_;
	const gchar* _tmp20_;
	xmlNode* _tmp21_;
	xmlNode* _tmp22_ = NULL;
	xmlNode* _tmp23_;
	xmlNode* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* udn;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_;
	gboolean _tmp30_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_name != NULL);
	g_return_if_fail (plugin_title != NULL);
	_tmp0_ = device_element;
	_tmp1_ = rygel_xml_utils_get_element (_tmp0_, "friendlyName", NULL, NULL);
	element = _tmp1_;
	_tmp2_ = element;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _ ("XML node '%s' not found.");
		g_warning (_tmp3_, "/root/device/friendlyName");
		return;
	}
	{
		RygelConfiguration* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp4_ = self->priv->config;
		_tmp5_ = plugin_name;
		_tmp6_ = rygel_configuration_get_title (_tmp4_, _tmp5_, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_g_free0 (title);
		title = _tmp7_;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = plugin_title;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (title);
		title = _tmp9_;
		_g_error_free0 (err);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (title);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = title;
	_tmp11_ = g_get_real_name ();
	_tmp12_ = string_replace (_tmp10_, "@REALNAME@", _tmp11_);
	_g_free0 (title);
	title = _tmp12_;
	_tmp13_ = title;
	_tmp14_ = g_get_user_name ();
	_tmp15_ = string_replace (_tmp13_, "@USERNAME@", _tmp14_);
	_g_free0 (title);
	title = _tmp15_;
	_tmp16_ = title;
	_tmp17_ = g_get_host_name ();
	_tmp18_ = string_replace (_tmp16_, "@HOSTNAME@", _tmp17_);
	_g_free0 (title);
	title = _tmp18_;
	_tmp19_ = element;
	_tmp20_ = title;
	xmlNodeSetContent (_tmp19_, _tmp20_);
	_tmp21_ = device_element;
	_tmp22_ = rygel_xml_utils_get_element (_tmp21_, "UDN", NULL);
	element = _tmp22_;
	_tmp23_ = element;
	if (_tmp23_ == NULL) {
		const gchar* _tmp24_ = NULL;
		_tmp24_ = _ ("XML node '%s' not found.");
		g_warning (_tmp24_, "/root/device/UDN");
		_g_free0 (title);
		return;
	}
	_tmp25_ = element;
	_tmp26_ = xmlNodeGetContent (_tmp25_);
	udn = _tmp26_;
	_tmp28_ = udn;
	if (_tmp28_ == NULL) {
		_tmp27_ = TRUE;
	} else {
		const gchar* _tmp29_;
		_tmp29_ = udn;
		_tmp27_ = g_strcmp0 (_tmp29_, "") == 0;
	}
	_tmp30_ = _tmp27_;
	if (_tmp30_) {
		gchar* _tmp31_ = NULL;
		xmlNode* _tmp32_;
		const gchar* _tmp33_;
		_tmp31_ = rygel_root_device_factory_generate_random_udn (self);
		_g_free0 (udn);
		udn = _tmp31_;
		_tmp32_ = element;
		_tmp33_ = udn;
		xmlNodeSetContent (_tmp32_, _tmp33_);
	}
	_g_free0 (udn);
	_g_free0 (title);
}


static void rygel_root_device_factory_set_dlnacap (RygelRootDeviceFactory* self, xmlNode* device_element) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* element;
	gchar* _tmp2_;
	gchar* content;
	gboolean allow_upload;
	gboolean allow_delete;
	gboolean _tmp9_;
	gboolean _tmp12_;
	xmlNode* _tmp15_;
	const gchar* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = device_element;
	_tmp1_ = rygel_xml_utils_get_element (_tmp0_, "X_DLNACAP", NULL, NULL);
	element = _tmp1_;
	_tmp2_ = g_strdup ("");
	content = _tmp2_;
	allow_upload = TRUE;
	allow_delete = FALSE;
	{
		RygelConfiguration* _tmp3_;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		RygelConfiguration* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		_tmp3_ = self->priv->config;
		_tmp4_ = rygel_configuration_get_allow_upload (_tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		allow_upload = _tmp5_;
		_tmp6_ = self->priv->config;
		_tmp7_ = rygel_configuration_get_allow_deletion (_tmp6_, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		allow_delete = _tmp8_;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp9_ = allow_upload;
	if (_tmp9_) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = content;
		_tmp11_ = g_strconcat (_tmp10_, "av-upload,image-upload,audio-upload", NULL);
		_g_free0 (content);
		content = _tmp11_;
	}
	_tmp12_ = allow_delete;
	if (_tmp12_) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = content;
		_tmp14_ = g_strconcat (_tmp13_, ",create-item-with-OCM-destroy-item", NULL);
		_g_free0 (content);
		content = _tmp14_;
	}
	_tmp15_ = element;
	_tmp16_ = content;
	xmlNodeSetContent (_tmp15_, _tmp16_);
	_g_free0 (content);
}


static void rygel_root_device_factory_set_description (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* description) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* element;
	xmlNode* _tmp2_;
	xmlNode* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (description != NULL);
	_tmp0_ = device_element;
	_tmp1_ = rygel_xml_utils_get_element (_tmp0_, "modelDescription", NULL, NULL);
	element = _tmp1_;
	_tmp2_ = element;
	if (_tmp2_ == NULL) {
		xmlNode* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = device_element;
		_tmp4_ = description;
		xmlNewChild (_tmp3_, NULL, "modelDescription", _tmp4_);
	}
	_tmp5_ = element;
	_tmp6_ = description;
	xmlNodeSetContent (_tmp5_, _tmp6_);
}


static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* service_list_node;
	xmlNode* _tmp2_;
	xmlNode* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = device_element;
	_tmp1_ = rygel_xml_utils_get_element (_tmp0_, "serviceList", NULL, NULL);
	service_list_node = _tmp1_;
	_tmp2_ = service_list_node;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _ ("XML node '%s' not found.");
		g_warning (_tmp3_, "/root/device/serviceList");
		return;
	}
	_tmp4_ = service_list_node;
	xmlNodeSetContent (_tmp4_, "");
	{
		RygelPlugin* _tmp5_;
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _resource_info_list;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _resource_info_size;
		gint _resource_info_index;
		_tmp5_ = plugin;
		_tmp6_ = _tmp5_->resource_infos;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_resource_info_list = _tmp7_;
		_tmp8_ = _resource_info_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_resource_info_size = _tmp10_;
		_resource_info_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GeeArrayList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_ = NULL;
			RygelResourceInfo* resource_info;
			RygelResourceInfo* _tmp17_;
			GType _tmp18_;
			gboolean _tmp19_ = FALSE;
			_tmp11_ = _resource_info_index;
			_resource_info_index = _tmp11_ + 1;
			_tmp12_ = _resource_info_index;
			_tmp13_ = _resource_info_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _resource_info_list;
			_tmp15_ = _resource_info_index;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
			resource_info = (RygelResourceInfo*) _tmp16_;
			_tmp17_ = resource_info;
			_tmp18_ = _tmp17_->type;
			_tmp19_ = g_type_is_a (_tmp18_, GUPNP_TYPE_SERVICE);
			if (_tmp19_) {
				xmlNode* _tmp20_;
				RygelPlugin* _tmp21_;
				const gchar* _tmp22_;
				RygelResourceInfo* _tmp23_;
				_tmp20_ = service_list_node;
				_tmp21_ = plugin;
				_tmp22_ = _tmp21_->name;
				_tmp23_ = resource_info;
				rygel_root_device_factory_add_service_to_desc (self, _tmp20_, _tmp22_, _tmp23_);
			}
			_rygel_resource_info_unref0 (resource_info);
		}
		_g_object_unref0 (_resource_info_list);
	}
}


static void rygel_root_device_factory_add_service_to_desc (RygelRootDeviceFactory* self, xmlNode* service_list_node, const gchar* plugin_name, RygelResourceInfo* resource_info) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* service_node;
	RygelResourceInfo* _tmp2_;
	const gchar* _tmp3_;
	RygelResourceInfo* _tmp4_;
	const gchar* _tmp5_;
	RygelResourceInfo* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* url;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	RygelResourceInfo* _tmp15_;
	GType _tmp16_;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	RygelResourceInfo* _tmp25_;
	GType _tmp26_;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_name != NULL);
	g_return_if_fail (resource_info != NULL);
	_tmp0_ = service_list_node;
	_tmp1_ = xmlNewChild (_tmp0_, NULL, "service", NULL);
	service_node = _tmp1_;
	_tmp2_ = resource_info;
	_tmp3_ = _tmp2_->upnp_type;
	xmlNewChild (service_node, NULL, "serviceType", _tmp3_);
	_tmp4_ = resource_info;
	_tmp5_ = _tmp4_->upnp_id;
	xmlNewChild (service_node, NULL, "serviceId", _tmp5_);
	_tmp6_ = resource_info;
	_tmp7_ = _tmp6_->description_path;
	_tmp8_ = g_strconcat ("/", _tmp7_, NULL);
	url = _tmp8_;
	_tmp9_ = url;
	xmlNewChild (service_node, NULL, "SCPDURL", _tmp9_);
	_tmp10_ = plugin_name;
	_tmp11_ = g_strconcat ("/Event/", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, "/", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = resource_info;
	_tmp16_ = _tmp15_->type;
	_tmp17_ = g_type_name (_tmp16_);
	_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
	_g_free0 (url);
	url = _tmp18_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp19_ = url;
	xmlNewChild (service_node, NULL, "eventSubURL", _tmp19_);
	_tmp20_ = plugin_name;
	_tmp21_ = g_strconcat ("/Control/", _tmp20_, NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat (_tmp22_, "/", NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = resource_info;
	_tmp26_ = _tmp25_->type;
	_tmp27_ = g_type_name (_tmp26_);
	_tmp28_ = g_strconcat (_tmp24_, _tmp27_, NULL);
	_g_free0 (url);
	url = _tmp28_;
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	_tmp29_ = url;
	xmlNewChild (service_node, NULL, "controlURL", _tmp29_);
	_g_free0 (url);
}


static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin) {
	RygelPlugin* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* icons;
	gboolean _tmp3_ = FALSE;
	GeeArrayList* _tmp4_;
	gboolean _tmp8_;
	xmlNode* _tmp14_;
	xmlNode* _tmp15_ = NULL;
	xmlNode* icon_list_node;
	xmlNode* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = plugin;
	_tmp1_ = _tmp0_->icon_infos;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	icons = _tmp2_;
	_tmp4_ = icons;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = icons;
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ == 0;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		RygelPlugin* _tmp9_;
		const gchar* _tmp10_;
		RygelPlugin* _tmp11_;
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		_tmp9_ = plugin;
		_tmp10_ = _tmp9_->name;
		g_debug ("rygel-root-device-factory.vala:252: No icon provided by plugin '%s'. U" \
"sing Rygel logo.", _tmp10_);
		_tmp11_ = plugin;
		_tmp12_ = _tmp11_->default_icons;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_g_object_unref0 (icons);
		icons = _tmp13_;
	}
	_tmp14_ = device_element;
	_tmp15_ = rygel_xml_utils_get_element (_tmp14_, "iconList", NULL, NULL);
	icon_list_node = _tmp15_;
	_tmp16_ = icon_list_node;
	if (_tmp16_ == NULL) {
		xmlNode* _tmp17_;
		xmlNode* _tmp18_ = NULL;
		_tmp17_ = device_element;
		_tmp18_ = xmlNewChild (_tmp17_, NULL, "iconList", NULL);
		icon_list_node = _tmp18_;
	} else {
		xmlNode* _tmp19_;
		_tmp19_ = icon_list_node;
		xmlNodeSetContent (_tmp19_, "");
	}
	{
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		GeeArrayList* _icon_list;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _icon_size;
		gint _icon_index;
		_tmp20_ = icons;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_icon_list = _tmp21_;
		_tmp22_ = _icon_list;
		_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_icon_size = _tmp24_;
		_icon_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			GeeArrayList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_ = NULL;
			RygelIconInfo* icon;
			xmlNode* _tmp31_;
			RygelIconInfo* _tmp32_;
			RygelPlugin* _tmp33_;
			_tmp25_ = _icon_index;
			_icon_index = _tmp25_ + 1;
			_tmp26_ = _icon_index;
			_tmp27_ = _icon_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _icon_list;
			_tmp29_ = _icon_index;
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
			icon = (RygelIconInfo*) _tmp30_;
			_tmp31_ = icon_list_node;
			_tmp32_ = icon;
			_tmp33_ = plugin;
			rygel_root_device_factory_add_icon_to_desc (self, _tmp31_, _tmp32_, _tmp33_);
			_rygel_icon_info_unref0 (icon);
		}
		_g_object_unref0 (_icon_list);
	}
	_g_object_unref0 (icons);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void rygel_root_device_factory_add_icon_to_desc (RygelRootDeviceFactory* self, xmlNode* icon_list_node, RygelIconInfo* icon_info, RygelPlugin* plugin) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* icon_node;
	RygelIconInfo* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* width;
	RygelIconInfo* _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* height;
	RygelIconInfo* _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* depth;
	xmlNode* _tmp11_;
	RygelIconInfo* _tmp12_;
	const gchar* _tmp13_;
	xmlNode* _tmp14_;
	const gchar* _tmp15_;
	xmlNode* _tmp16_;
	const gchar* _tmp17_;
	xmlNode* _tmp18_;
	const gchar* _tmp19_;
	RygelIconInfo* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* uri;
	const gchar* _tmp23_;
	gboolean _tmp24_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_info != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = icon_list_node;
	_tmp1_ = xmlNewChild (_tmp0_, NULL, "icon", NULL);
	icon_node = _tmp1_;
	_tmp2_ = icon_info;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	width = _tmp4_;
	_tmp5_ = icon_info;
	_tmp6_ = _tmp5_->height;
	_tmp7_ = g_strdup_printf ("%i", _tmp6_);
	height = _tmp7_;
	_tmp8_ = icon_info;
	_tmp9_ = _tmp8_->depth;
	_tmp10_ = g_strdup_printf ("%i", _tmp9_);
	depth = _tmp10_;
	_tmp11_ = icon_node;
	_tmp12_ = icon_info;
	_tmp13_ = _tmp12_->mime_type;
	xmlNewChild (_tmp11_, NULL, "mimetype", _tmp13_);
	_tmp14_ = icon_node;
	_tmp15_ = width;
	xmlNewChild (_tmp14_, NULL, "width", _tmp15_);
	_tmp16_ = icon_node;
	_tmp17_ = height;
	xmlNewChild (_tmp16_, NULL, "height", _tmp17_);
	_tmp18_ = icon_node;
	_tmp19_ = depth;
	xmlNewChild (_tmp18_, NULL, "depth", _tmp19_);
	_tmp20_ = icon_info;
	_tmp21_ = _tmp20_->uri;
	_tmp22_ = g_strdup (_tmp21_);
	uri = _tmp22_;
	_tmp23_ = uri;
	_tmp24_ = g_str_has_prefix (_tmp23_, "file://");
	if (_tmp24_) {
		RygelPlugin* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		RygelIconInfo* _tmp46_;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* remote_path;
		const gchar* _tmp50_;
		gchar* _tmp51_ = NULL;
		gchar* local_path;
		GUPnPContext* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		xmlNode* _tmp55_;
		const gchar* _tmp56_;
		_tmp25_ = plugin;
		_tmp26_ = _tmp25_->name;
		_tmp27_ = g_strconcat ("/", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strconcat (_tmp28_, "-", NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = width;
		_tmp32_ = g_strconcat (_tmp30_, _tmp31_, NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strconcat (_tmp33_, "x", NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = height;
		_tmp37_ = g_strconcat (_tmp35_, _tmp36_, NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat (_tmp38_, "x", NULL);
		_tmp40_ = _tmp39_;
		_tmp41_ = depth;
		_tmp42_ = g_strconcat (_tmp40_, _tmp41_, NULL);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strconcat (_tmp43_, ".", NULL);
		_tmp45_ = _tmp44_;
		_tmp46_ = icon_info;
		_tmp47_ = _tmp46_->file_extension;
		_tmp48_ = g_strconcat (_tmp45_, _tmp47_, NULL);
		_tmp49_ = _tmp48_;
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp38_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp33_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
		remote_path = _tmp49_;
		_tmp50_ = uri;
		_tmp51_ = string_substring (_tmp50_, (glong) 7, (glong) (-1));
		local_path = _tmp51_;
		_tmp52_ = self->context;
		_tmp53_ = local_path;
		_tmp54_ = remote_path;
		gupnp_context_host_path (_tmp52_, _tmp53_, _tmp54_);
		_tmp55_ = icon_node;
		_tmp56_ = remote_path;
		xmlNewChild (_tmp55_, NULL, "url", _tmp56_);
		_g_free0 (local_path);
		_g_free0 (remote_path);
	} else {
		const gchar* _tmp57_;
		GUPnPContext* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		gchar* _tmp61_ = NULL;
		xmlNode* _tmp62_;
		const gchar* _tmp63_;
		_tmp57_ = uri;
		_tmp58_ = self->context;
		_tmp59_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = string_replace (_tmp57_, "@ADDRESS@", _tmp60_);
		_g_free0 (uri);
		uri = _tmp61_;
		_tmp62_ = icon_node;
		_tmp63_ = uri;
		xmlNewChild (_tmp62_, NULL, "url", _tmp63_);
	}
	_g_free0 (uri);
	_g_free0 (depth);
	_g_free0 (height);
	_g_free0 (width);
}


static GUPnPXMLDoc* rygel_root_device_factory_get_latest_doc (RygelRootDeviceFactory* self, const gchar* path1, const gchar* path2, GError** error) {
	GUPnPXMLDoc* result = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp7_;
	GFileInfo* _tmp8_ = NULL;
	GFileInfo* info;
	GFileInfo* _tmp9_;
	guint64 _tmp10_ = 0ULL;
	guint64 mod1;
	const gchar* _tmp11_;
	GFile* _tmp12_ = NULL;
	GFile* _tmp13_;
	GFileInfo* _tmp14_ = NULL;
	GFileInfo* _tmp15_;
	GFileInfo* _tmp16_;
	guint64 _tmp17_ = 0ULL;
	guint64 mod2;
	guint64 _tmp18_;
	guint64 _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path1 != NULL, NULL);
	g_return_val_if_fail (path2 != NULL, NULL);
	_tmp0_ = path1;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (!_tmp3_) {
		const gchar* _tmp4_;
		GUPnPXMLDoc* _tmp5_;
		GUPnPXMLDoc* _tmp6_;
		_tmp4_ = path2;
		_tmp5_ = gupnp_xml_doc_new_from_path (_tmp4_, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			return NULL;
		}
		result = _tmp6_;
		_g_object_unref0 (file);
		return result;
	}
	_tmp7_ = file;
	_tmp8_ = g_file_query_info (_tmp7_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp8_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp9_ = info;
	_tmp10_ = g_file_info_get_attribute_uint64 (_tmp9_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	mod1 = _tmp10_;
	_tmp11_ = path2;
	_tmp12_ = g_file_new_for_path (_tmp11_);
	_g_object_unref0 (file);
	file = _tmp12_;
	_tmp13_ = file;
	_tmp14_ = g_file_query_info (_tmp13_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return NULL;
	}
	_g_object_unref0 (info);
	info = _tmp15_;
	_tmp16_ = info;
	_tmp17_ = g_file_info_get_attribute_uint64 (_tmp16_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	mod2 = _tmp17_;
	_tmp18_ = mod1;
	_tmp19_ = mod2;
	if (_tmp18_ > _tmp19_) {
		{
			const gchar* _tmp20_;
			GUPnPXMLDoc* _tmp21_;
			GUPnPXMLDoc* _tmp22_;
			_tmp20_ = path1;
			_tmp21_ = gupnp_xml_doc_new_from_path (_tmp20_, &_inner_error_);
			_tmp22_ = _tmp21_;
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
			}
			result = _tmp22_;
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return result;
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* _error_ = NULL;
			const gchar* _tmp23_;
			GUPnPXMLDoc* _tmp24_;
			GUPnPXMLDoc* _tmp25_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp23_ = path2;
			_tmp24_ = gupnp_xml_doc_new_from_path (_tmp23_, &_inner_error_);
			_tmp25_ = _tmp24_;
			if (_inner_error_ != NULL) {
				_g_error_free0 (_error_);
				goto __finally5;
			}
			result = _tmp25_;
			_g_error_free0 (_error_);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return result;
		}
		__finally5:
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return NULL;
	} else {
		const gchar* _tmp26_;
		GUPnPXMLDoc* _tmp27_;
		GUPnPXMLDoc* _tmp28_;
		_tmp26_ = path2;
		_tmp27_ = gupnp_xml_doc_new_from_path (_tmp26_, &_inner_error_);
		_tmp28_ = _tmp27_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return NULL;
		}
		result = _tmp28_;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_g_object_unref0 (info);
	_g_object_unref0 (file);
}


static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const gchar* dir_path, GError** error) {
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir_path != NULL);
	_tmp0_ = dir_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (!_tmp3_) {
		GFile* _tmp4_;
		_tmp4_ = file;
		g_file_make_directory (_tmp4_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			return;
		}
	}
	_g_object_unref0 (file);
}


static gchar* rygel_root_device_factory_generate_random_udn (RygelRootDeviceFactory* self) {
	gchar* result = NULL;
	guchar* _tmp0_ = NULL;
	guchar* udn;
	gint udn_length1;
	gint _udn_size_;
	guchar* _tmp1_ = NULL;
	guchar* id;
	gint id_length1;
	gint _id_size_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (guchar, 50);
	udn = _tmp0_;
	udn_length1 = 50;
	_udn_size_ = udn_length1;
	_tmp1_ = g_new0 (guchar, 16);
	id = _tmp1_;
	id_length1 = 16;
	_id_size_ = id_length1;
	uuid_generate (id);
	uuid_unparse (id, udn);
	_tmp2_ = g_strconcat ("uuid:", (const gchar*) udn, NULL);
	result = _tmp2_;
	id = (g_free (id), NULL);
	udn = (g_free (udn), NULL);
	return result;
}


static void rygel_value_root_device_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_root_device_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_root_device_factory_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_root_device_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_root_device_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_root_device_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_root_device_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelRootDeviceFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_root_device_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_root_device_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelRootDeviceFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_root_device_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_root_device_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecRootDeviceFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_ROOT_DEVICE_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_root_device_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_ROOT_DEVICE_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_root_device_factory (GValue* value, gpointer v_object) {
	RygelRootDeviceFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_root_device_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_root_device_factory_unref (old);
	}
}


void rygel_value_take_root_device_factory (GValue* value, gpointer v_object) {
	RygelRootDeviceFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_root_device_factory_unref (old);
	}
}


static void rygel_root_device_factory_class_init (RygelRootDeviceFactoryClass * klass) {
	rygel_root_device_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_ROOT_DEVICE_FACTORY_CLASS (klass)->finalize = rygel_root_device_factory_finalize;
	g_type_class_add_private (klass, sizeof (RygelRootDeviceFactoryPrivate));
}


static void rygel_root_device_factory_instance_init (RygelRootDeviceFactory * self) {
	self->priv = RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void rygel_root_device_factory_finalize (RygelRootDeviceFactory* obj) {
	RygelRootDeviceFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory);
	_g_object_unref0 (self->context);
	_g_object_unref0 (self->priv->config);
	_g_free0 (self->priv->desc_dir);
}


/**
 * Factory for RootDevice objects. Give it a plugin and it will create a
 * Root device for that.
 */
GType rygel_root_device_factory_get_type (void) {
	static volatile gsize rygel_root_device_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_root_device_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_root_device_factory_init, rygel_value_root_device_factory_free_value, rygel_value_root_device_factory_copy_value, rygel_value_root_device_factory_peek_pointer, "p", rygel_value_root_device_factory_collect_value, "p", rygel_value_root_device_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelRootDeviceFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_root_device_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRootDeviceFactory), 0, (GInstanceInitFunc) rygel_root_device_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_root_device_factory_type_id;
		rygel_root_device_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelRootDeviceFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_root_device_factory_type_id__volatile, rygel_root_device_factory_type_id);
	}
	return rygel_root_device_factory_type_id__volatile;
}


gpointer rygel_root_device_factory_ref (gpointer instance) {
	RygelRootDeviceFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_root_device_factory_unref (gpointer instance) {
	RygelRootDeviceFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



