/* rygel-searchable-container.c generated by valac 0.15.0.96-556a, the Vala compiler
 * generated from rygel-searchable-container.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _RygelSearchableContainerSimpleSearchData RygelSearchableContainerSimpleSearchData;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelSearchableContainerFindObjectData RygelSearchableContainerFindObjectData;
typedef struct _RygelSearchableContainerSearchInChildrenData RygelSearchableContainerSearchInChildrenData;

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	gint64 storage_used;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelSearchableContainerSimpleSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* _result_;
	gint _tmp1_;
	GCancellable* _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* children;
	guint limit;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	RygelMediaObjects* _tmp7_;
	RygelMediaObjects* _tmp8_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _child_size;
	gint _child_index;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	RygelMediaObjects* _tmp15_;
	gint _tmp16_;
	gpointer _tmp17_;
	RygelMediaObject* child;
	gboolean _tmp18_;
	RygelSearchExpression* _tmp19_;
	RygelSearchExpression* _tmp20_;
	RygelMediaObject* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	RygelMediaObjects* _tmp24_;
	RygelMediaObject* _tmp25_;
	gboolean _tmp26_;
	guint _tmp27_;
	RygelMediaObjects* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	guint _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	guint _tmp34_;
	RygelMediaObjects* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	guint _tmp38_;
	gboolean _tmp39_;
	guint _tmp40_;
	guint _tmp41_;
	guint _tmp42_;
	RygelMediaObjects* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	guint _tmp46_;
	guint child_limit;
	RygelSearchExpression* _tmp47_;
	RygelMediaObjects* _tmp48_;
	guint _tmp49_;
	GCancellable* _tmp50_;
	RygelMediaObjects* _tmp51_;
	RygelMediaObjects* child_results;
	RygelMediaObjects* _tmp52_;
	RygelMediaObjects* _tmp53_;
	guint _tmp54_;
	RygelMediaObjects* _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	guint _tmp58_;
	RygelMediaObjects* _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	RygelMediaObjects* _tmp62_;
	gboolean _tmp63_;
	RygelMediaObjects* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	gboolean _tmp67_;
	guint _tmp68_;
	guint _tmp69_;
	gboolean _tmp70_;
	gboolean _tmp71_;
	guint stop;
	gboolean _tmp72_;
	guint _tmp73_;
	guint _tmp74_;
	guint _tmp75_;
	RygelMediaObjects* _tmp76_;
	gint _tmp77_;
	gint _tmp78_;
	gboolean _tmp79_;
	guint _tmp80_;
	guint _tmp81_;
	RygelMediaObjects* _tmp82_;
	gint _tmp83_;
	gint _tmp84_;
	RygelMediaObjects* _tmp85_;
	guint _tmp86_;
	guint _tmp87_;
	GeeList* _tmp88_;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelSearchableContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelRelationalExpression* _tmp0_;
	RygelRelationalExpression* expression;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	guint total_matches;
	GCancellable* _tmp4_;
	guint _tmp5_;
	RygelMediaObjects* _tmp6_;
	RygelMediaObjects* results;
	gint _tmp7_;
	gint _tmp8_;
	gpointer _tmp9_;
	GError * _inner_error_;
};

struct _RygelSearchableContainerSearchInChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	RygelSearchExpression* expression;
	RygelMediaObjects* children;
	guint limit;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* _result_;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _child_size;
	gint _child_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	RygelMediaObjects* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	RygelMediaObject* child;
	RygelMediaObject* _tmp12_;
	RygelMediaObject* _tmp13_;
	RygelSearchableContainer* _tmp14_;
	RygelSearchableContainer* container;
	guint tmp;
	RygelSearchableContainer* _tmp15_;
	RygelSearchExpression* _tmp16_;
	guint _tmp17_;
	GCancellable* _tmp18_;
	guint _tmp19_;
	RygelMediaObjects* _tmp20_;
	RygelMediaObjects* child_result;
	RygelMediaObjects* _tmp21_;
	RygelMediaObjects* _tmp22_;
	gboolean _tmp23_;
	guint _tmp24_;
	RygelMediaObjects* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	guint _tmp28_;
	gboolean _tmp29_;
	GError * _inner_error_;
};



GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_searchable_container_simple_search_data_free (gpointer _data);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_);
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_search_expression_satisfied_by (RygelSearchExpression* self, RygelMediaObject* media_object);
static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, RygelSearchExpression* expression, RygelMediaObjects* children, guint limit, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_searchable_container_find_object_data_free (gpointer _data);
void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_searchable_container_search_in_children_data_free (gpointer _data);
static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_);
static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value);


void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search (self, expression, offset, max_count, cancellable, _callback_, _user_data_);
}


RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search_finish (self, _res_, total_matches, error);
}


static void rygel_searchable_container_simple_search_data_free (gpointer _data) {
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchableContainerSimpleSearchData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


void rygel_searchable_container_simple_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
	RygelSearchableContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	_data_ = g_slice_new0 (RygelSearchableContainerSimpleSearchData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_searchable_container_simple_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_simple_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
	_data_->expression = _tmp2_;
	_tmp3_ = offset;
	_data_->offset = _tmp3_;
	_tmp4_ = max_count;
	_data_->max_count = _tmp4_;
	_tmp5_ = cancellable;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_data_->cancellable = _tmp6_;
	rygel_searchable_container_simple_search_co (_data_);
}


RygelMediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelSearchableContainerSimpleSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Utility method that retrieves all children and recursively searches for
     * all media objects that satisfy the given search expression in this
     * container.
     *
     * @param expression the search expression or `null` for wildcard
     * @param offet zero-based index of the first object to return
     * @param max_count maximum number of objects to return
     * @param total_matches sets it to the actual number of objects that satisfy
     *                      the given search expression. If it is not possible
     *                      to compute this value (in a timely mannger), it is
     *                      set to '0'.
     * @param cancellable optional cancellable for this operation
     *
     * return A list of media objects.
     */
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_searchable_container_simple_search_co (_data_);
}


static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_media_objects_new ();
	_data_->_result_ = _data_->_tmp0_;
	_data_->_tmp1_ = ((RygelMediaContainer*) _data_->self)->child_count;
	_data_->_tmp2_ = _data_->cancellable;
	_data_->_state_ = 1;
	rygel_media_container_get_children ((RygelMediaContainer*) _data_->self, (guint) 0, (guint) _data_->_tmp1_, _data_->_tmp2_, rygel_searchable_container_simple_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rygel_media_container_get_children_finish ((RygelMediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->children = _data_->_tmp3_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->_result_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->max_count;
	if (_data_->_tmp4_ > ((guint) 0)) {
		_data_->_tmp5_ = _data_->offset;
		_data_->_tmp6_ = _data_->max_count;
		_data_->limit = _data_->_tmp5_ + _data_->_tmp6_;
	} else {
		_data_->limit = (guint) 0;
	}
	{
		_data_->_tmp7_ = _data_->children;
		_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
		_data_->_child_list = _data_->_tmp8_;
		_data_->_tmp9_ = _data_->_child_list;
		_data_->_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_child_size = _data_->_tmp11_;
		_data_->_child_index = -1;
		while (TRUE) {
			_data_->_tmp12_ = _data_->_child_index;
			_data_->_child_index = _data_->_tmp12_ + 1;
			_data_->_tmp13_ = _data_->_child_index;
			_data_->_tmp14_ = _data_->_child_size;
			if (!(_data_->_tmp13_ < _data_->_tmp14_)) {
				break;
			}
			_data_->_tmp15_ = _data_->_child_list;
			_data_->_tmp16_ = _data_->_child_index;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp15_, _data_->_tmp16_);
			_data_->child = (RygelMediaObject*) _data_->_tmp17_;
			_data_->_tmp19_ = _data_->expression;
			if (_data_->_tmp19_ == NULL) {
				_data_->_tmp18_ = TRUE;
			} else {
				_data_->_tmp20_ = _data_->expression;
				_data_->_tmp21_ = _data_->child;
				_data_->_tmp22_ = FALSE;
				_data_->_tmp22_ = rygel_search_expression_satisfied_by (_data_->_tmp20_, _data_->_tmp21_);
				_data_->_tmp18_ = _data_->_tmp22_;
			}
			_data_->_tmp23_ = _data_->_tmp18_;
			if (_data_->_tmp23_) {
				_data_->_tmp24_ = _data_->_result_;
				_data_->_tmp25_ = _data_->child;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp24_, _data_->_tmp25_);
			}
			_data_->_tmp27_ = _data_->limit;
			if (_data_->_tmp27_ > ((guint) 0)) {
				_data_->_tmp28_ = _data_->_result_;
				_data_->_tmp29_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp28_);
				_data_->_tmp30_ = _data_->_tmp29_;
				_data_->_tmp31_ = _data_->limit;
				_data_->_tmp26_ = ((guint) _data_->_tmp30_) >= _data_->_tmp31_;
			} else {
				_data_->_tmp26_ = FALSE;
			}
			_data_->_tmp32_ = _data_->_tmp26_;
			if (_data_->_tmp32_) {
				_g_object_unref0 (_data_->child);
				break;
			}
			_g_object_unref0 (_data_->child);
		}
		_g_object_unref0 (_data_->_child_list);
	}
	_data_->_tmp34_ = _data_->limit;
	if (_data_->_tmp34_ == ((guint) 0)) {
		_data_->_tmp33_ = TRUE;
	} else {
		_data_->_tmp35_ = _data_->_result_;
		_data_->_tmp36_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp35_);
		_data_->_tmp37_ = _data_->_tmp36_;
		_data_->_tmp38_ = _data_->limit;
		_data_->_tmp33_ = ((guint) _data_->_tmp37_) < _data_->_tmp38_;
	}
	_data_->_tmp39_ = _data_->_tmp33_;
	if (_data_->_tmp39_) {
		_data_->_tmp41_ = _data_->limit;
		if (_data_->_tmp41_ == ((guint) 0)) {
			_data_->_tmp40_ = (guint) 0;
		} else {
			_data_->_tmp42_ = _data_->limit;
			_data_->_tmp43_ = _data_->_result_;
			_data_->_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp43_);
			_data_->_tmp45_ = _data_->_tmp44_;
			_data_->_tmp40_ = _data_->_tmp42_ - _data_->_tmp45_;
		}
		_data_->_tmp46_ = _data_->_tmp40_;
		_data_->child_limit = _data_->_tmp46_;
		_data_->_tmp47_ = _data_->expression;
		_data_->_tmp48_ = _data_->children;
		_data_->_tmp49_ = _data_->child_limit;
		_data_->_tmp50_ = _data_->cancellable;
		_data_->_state_ = 2;
		rygel_searchable_container_search_in_children (_data_->self, _data_->_tmp47_, _data_->_tmp48_, _data_->_tmp49_, _data_->_tmp50_, rygel_searchable_container_simple_search_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp51_ = NULL;
		_data_->_tmp51_ = rygel_searchable_container_search_in_children_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->child_results = _data_->_tmp51_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->children);
			_g_object_unref0 (_data_->_result_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp52_ = _data_->_result_;
		_data_->_tmp53_ = _data_->child_results;
		gee_abstract_collection_add_all ((GeeAbstractCollection*) _data_->_tmp52_, (GeeCollection*) _data_->_tmp53_);
		_g_object_unref0 (_data_->child_results);
	}
	_data_->_tmp54_ = _data_->max_count;
	if (_data_->_tmp54_ > ((guint) 0)) {
		_data_->total_matches = (guint) 0;
	} else {
		_data_->_tmp55_ = _data_->_result_;
		_data_->_tmp56_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp55_);
		_data_->_tmp57_ = _data_->_tmp56_;
		_data_->total_matches = (guint) _data_->_tmp57_;
	}
	_data_->_tmp58_ = _data_->offset;
	_data_->_tmp59_ = _data_->_result_;
	_data_->_tmp60_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp59_);
	_data_->_tmp61_ = _data_->_tmp60_;
	if (_data_->_tmp58_ >= ((guint) _data_->_tmp61_)) {
		_data_->_tmp62_ = rygel_media_objects_new ();
		_data_->result = _data_->_tmp62_;
		_g_object_unref0 (_data_->children);
		_g_object_unref0 (_data_->_result_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp64_ = _data_->_result_;
	_data_->_tmp65_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp64_);
	_data_->_tmp66_ = _data_->_tmp65_;
	if (_data_->_tmp66_ > 0) {
		_data_->_tmp68_ = _data_->max_count;
		if (_data_->_tmp68_ > ((guint) 0)) {
			_data_->_tmp67_ = TRUE;
		} else {
			_data_->_tmp69_ = _data_->offset;
			_data_->_tmp67_ = _data_->_tmp69_ > ((guint) 0);
		}
		_data_->_tmp70_ = _data_->_tmp67_;
		_data_->_tmp63_ = _data_->_tmp70_;
	} else {
		_data_->_tmp63_ = FALSE;
	}
	_data_->_tmp71_ = _data_->_tmp63_;
	if (_data_->_tmp71_) {
		_data_->_tmp73_ = _data_->max_count;
		if (_data_->_tmp73_ != ((guint) 0)) {
			_data_->_tmp74_ = _data_->offset;
			_data_->_tmp75_ = _data_->max_count;
			_data_->_tmp76_ = _data_->_result_;
			_data_->_tmp77_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp76_);
			_data_->_tmp78_ = _data_->_tmp77_;
			_data_->_tmp72_ = (_data_->_tmp74_ + _data_->_tmp75_) <= ((guint) _data_->_tmp78_);
		} else {
			_data_->_tmp72_ = FALSE;
		}
		_data_->_tmp79_ = _data_->_tmp72_;
		if (_data_->_tmp79_) {
			_data_->_tmp80_ = _data_->offset;
			_data_->_tmp81_ = _data_->max_count;
			_data_->stop = _data_->_tmp80_ + _data_->_tmp81_;
		} else {
			_data_->_tmp82_ = _data_->_result_;
			_data_->_tmp83_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp82_);
			_data_->_tmp84_ = _data_->_tmp83_;
			_data_->stop = (guint) _data_->_tmp84_;
		}
		_data_->_tmp85_ = _data_->_result_;
		_data_->_tmp86_ = _data_->offset;
		_data_->_tmp87_ = _data_->stop;
		_data_->_tmp88_ = NULL;
		_data_->_tmp88_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp85_, (gint) _data_->_tmp86_, (gint) _data_->_tmp87_);
		_data_->result = RYGEL_IS_MEDIA_OBJECTS (_data_->_tmp88_) ? ((RygelMediaObjects*) _data_->_tmp88_) : NULL;
		_g_object_unref0 (_data_->children);
		_g_object_unref0 (_data_->_result_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_result_;
	_g_object_unref0 (_data_->children);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->children);
	_g_object_unref0 (_data_->_result_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_searchable_container_find_object_data_free (gpointer _data) {
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchableContainerFindObjectData, _data_);
}


void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
	RygelSearchableContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (RygelSearchableContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_searchable_container_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	rygel_searchable_container_find_object_co (_data_);
}


RygelMediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelSearchableContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Recursively searches for media object with the given id in this
     * container.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     * @param callback function to call when result is ready
     *
     * return the found media object.
     */
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_searchable_container_find_object_co (_data_);
}


static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_relational_expression_new ();
	_data_->expression = _data_->_tmp0_;
	((RygelSearchExpression*) _data_->expression)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_EQ);
	_data_->_tmp1_ = g_strdup ("@id");
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand1);
	((RygelSearchExpression*) _data_->expression)->operand1 = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->id;
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand2);
	((RygelSearchExpression*) _data_->expression)->operand2 = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->cancellable;
	_data_->_tmp5_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_search (_data_->self, (RygelSearchExpression*) _data_->expression, (guint) 0, (guint) 1, _data_->_tmp4_, rygel_searchable_container_find_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = rygel_searchable_container_search_finish (_data_->self, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
	_data_->total_matches = _data_->_tmp5_;
	_data_->results = _data_->_tmp6_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_rygel_search_expression_unref0 (_data_->expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->results);
	_data_->_tmp8_ = _data_->_tmp7_;
	if (_data_->_tmp8_ > 0) {
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _data_->results, 0);
		_data_->result = (RygelMediaObject*) _data_->_tmp9_;
		_g_object_unref0 (_data_->results);
		_rygel_search_expression_unref0 (_data_->expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->result = NULL;
		_g_object_unref0 (_data_->results);
		_rygel_search_expression_unref0 (_data_->expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->results);
	_rygel_search_expression_unref0 (_data_->expression);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_searchable_container_search_in_children_data_free (gpointer _data) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_object_unref0 (_data_->children);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSearchableContainerSearchInChildrenData, _data_);
}


static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, RygelSearchExpression* expression, RygelMediaObjects* children, guint limit, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	RygelSearchableContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* _tmp4_;
	guint _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	_data_ = g_slice_new0 (RygelSearchableContainerSearchInChildrenData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_searchable_container_search_in_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_search_in_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
	_data_->expression = _tmp2_;
	_tmp3_ = children;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->children = _tmp4_;
	_tmp5_ = limit;
	_data_->limit = _tmp5_;
	_tmp6_ = cancellable;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_data_->cancellable = _tmp7_;
	rygel_searchable_container_search_in_children_co (_data_);
}


static RygelMediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelSearchableContainerSearchInChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_searchable_container_search_in_children_co (_data_);
}


static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_media_objects_new ();
	_data_->_result_ = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->children;
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->_child_list = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->_child_list;
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_child_size = _data_->_tmp5_;
		_data_->_child_index = -1;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_child_index;
			_data_->_child_index = _data_->_tmp6_ + 1;
			_data_->_tmp7_ = _data_->_child_index;
			_data_->_tmp8_ = _data_->_child_size;
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
				break;
			}
			_data_->_tmp9_ = _data_->_child_list;
			_data_->_tmp10_ = _data_->_child_index;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
			_data_->child = (RygelMediaObject*) _data_->_tmp11_;
			_data_->_tmp12_ = _data_->child;
			if (RYGEL_IS_SEARCHABLE_CONTAINER (_data_->_tmp12_)) {
				_data_->_tmp13_ = _data_->child;
				_data_->_tmp14_ = _g_object_ref0 (RYGEL_IS_SEARCHABLE_CONTAINER (_data_->_tmp13_) ? ((RygelSearchableContainer*) _data_->_tmp13_) : NULL);
				_data_->container = _data_->_tmp14_;
				_data_->_tmp15_ = _data_->container;
				_data_->_tmp16_ = _data_->expression;
				_data_->_tmp17_ = _data_->limit;
				_data_->_tmp18_ = _data_->cancellable;
				_data_->_tmp19_ = 0U;
				_data_->_state_ = 1;
				rygel_searchable_container_search (_data_->_tmp15_, _data_->_tmp16_, (guint) 0, _data_->_tmp17_, _data_->_tmp18_, rygel_searchable_container_search_in_children_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp20_ = NULL;
				_data_->_tmp20_ = rygel_searchable_container_search_finish (_data_->_tmp15_, _data_->_res_, &_data_->_tmp19_, &_data_->_inner_error_);
				_data_->tmp = _data_->_tmp19_;
				_data_->child_result = _data_->_tmp20_;
				if (_data_->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					_g_object_unref0 (_data_->container);
					_g_object_unref0 (_data_->child);
					_g_object_unref0 (_data_->_child_list);
					_g_object_unref0 (_data_->_result_);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp21_ = _data_->_result_;
				_data_->_tmp22_ = _data_->child_result;
				gee_abstract_collection_add_all ((GeeAbstractCollection*) _data_->_tmp21_, (GeeCollection*) _data_->_tmp22_);
				_g_object_unref0 (_data_->child_result);
				_g_object_unref0 (_data_->container);
			}
			_data_->_tmp24_ = _data_->limit;
			if (_data_->_tmp24_ > ((guint) 0)) {
				_data_->_tmp25_ = _data_->_result_;
				_data_->_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp25_);
				_data_->_tmp27_ = _data_->_tmp26_;
				_data_->_tmp28_ = _data_->limit;
				_data_->_tmp23_ = ((guint) _data_->_tmp27_) >= _data_->_tmp28_;
			} else {
				_data_->_tmp23_ = FALSE;
			}
			_data_->_tmp29_ = _data_->_tmp23_;
			if (_data_->_tmp29_) {
				_g_object_unref0 (_data_->child);
				break;
			}
			_g_object_unref0 (_data_->child);
		}
		_g_object_unref0 (_data_->_child_list);
	}
	_data_->result = _data_->_result_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->_result_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container) {
	g_return_if_fail (didl_container != NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _search_class_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _search_class_size;
		gint _search_class_index;
		_tmp0_ = rygel_searchable_container_get_search_classes (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_search_class_list = _tmp2_;
		_tmp3_ = _search_class_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_search_class_size = _tmp5_;
		_search_class_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			gchar* search_class;
			GUPnPDIDLLiteContainer* _tmp12_;
			const gchar* _tmp13_;
			_tmp6_ = _search_class_index;
			_search_class_index = _tmp6_ + 1;
			_tmp7_ = _search_class_index;
			_tmp8_ = _search_class_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _search_class_list;
			_tmp10_ = _search_class_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			search_class = (gchar*) _tmp11_;
			_tmp12_ = didl_container;
			_tmp13_ = search_class;
			gupnp_didl_lite_container_add_search_class (_tmp12_, _tmp13_);
			_g_free0 (search_class);
		}
		_g_object_unref0 (_search_class_list);
	}
}


GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->get_search_classes (self);
}


void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value) {
	g_return_if_fail (self != NULL);
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->set_search_classes (self, value);
}


static void rygel_searchable_container_base_init (RygelSearchableContainerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


GType rygel_searchable_container_get_type (void) {
	static volatile gsize rygel_searchable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_searchable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchableContainerIface), (GBaseInitFunc) rygel_searchable_container_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_searchable_container_type_id;
		rygel_searchable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelSearchableContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_searchable_container_type_id, RYGEL_TYPE_MEDIA_CONTAINER);
		g_once_init_leave (&rygel_searchable_container_type_id__volatile, rygel_searchable_container_type_id);
	}
	return rygel_searchable_container_type_id__volatile;
}



