/* rygel-media-export-harvesting-task.c generated by valac 0.15.0.96-556a, the Vala compiler
 * generated from rygel-media-export-harvesting-task.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_queue_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__g_object_unref0_ (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskRunData RygelMediaExportHarvestingTaskRunData;

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER (rygel_media_export_dummy_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainer))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))

typedef struct _RygelMediaExportDummyContainer RygelMediaExportDummyContainer;
typedef struct _RygelMediaExportDummyContainerClass RygelMediaExportDummyContainerClass;
typedef struct _RygelNullContainerPrivate RygelNullContainerPrivate;
typedef struct _RygelMediaExportDummyContainerPrivate RygelMediaExportDummyContainerPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskEnumerateDirectoryData RygelMediaExportHarvestingTaskEnumerateDirectoryData;

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvestingTaskPrivate {
	RygelMediaExportMetadataExtractor* extractor;
	RygelMediaExportMediaCache* cache;
	GQueue* containers;
	GeeQueue* files;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GRegex* file_filter;
	gchar* flag;
	RygelMediaContainer* parent;
	GCancellable* _cancellable;
};

struct _RygelMediaExportHarvestingTaskRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportHarvestingTask* self;
	GFile* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GFileInfo* _tmp3_;
	GFileInfo* info;
	GFile* _tmp4_;
	RygelMediaContainer* _tmp5_;
	gboolean _tmp6_;
	GFileType _tmp7_;
	GQueue* _tmp8_;
	RygelMediaContainer* _tmp9_;
	RygelMediaContainer* _tmp10_;
	GError* _error_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelNullContainer {
	RygelMediaContainer parent_instance;
	RygelNullContainerPrivate * priv;
};

struct _RygelNullContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelMediaExportDummyContainer {
	RygelNullContainer parent_instance;
	RygelMediaExportDummyContainerPrivate * priv;
	GFile* file;
	GeeList* children;
};

struct _RygelMediaExportDummyContainerClass {
	RygelNullContainerClass parent_class;
};

struct _RygelMediaExportHarvestingTaskEnumerateDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportHarvestingTask* self;
	GQueue* _tmp0_;
	gconstpointer _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* directory;
	GFile* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GFileEnumerator* _tmp7_;
	GFileEnumerator* enumerator;
	GList* list;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GList* _tmp10_;
	gboolean _tmp11_;
	GFileEnumerator* _tmp12_;
	GCancellable* _tmp13_;
	GCancellable* _tmp14_;
	GList* _tmp15_;
	GList* _tmp16_;
	GFileEnumerator* _tmp17_;
	GCancellable* _tmp18_;
	GCancellable* _tmp19_;
	GError* err;
	const gchar* _tmp20_;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError * _inner_error_;
};


static gpointer rygel_media_export_harvesting_task_parent_class = NULL;
static RygelStateMachineIface* rygel_media_export_harvesting_task_rygel_state_machine_parent_iface = NULL;

GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE
};
static void _g_object_unref0_ (gpointer var);
static void _g_queue_free__g_object_unref0_ (GQueue* self);
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_BATCH_SIZE 256
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_STANDARD_SIZE
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
static void rygel_media_export_harvesting_task_on_extracted_cb (RygelMediaExportHarvestingTask* self, GFile* file, GUPnPDLNAInformation* dlna, const gchar* mime, guint64 size, guint64 mtime);
static void _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender, GFile* file, GUPnPDLNAInformation* info, const gchar* mime, guint64 size, guint64 mtime, gpointer self);
static void rygel_media_export_harvesting_task_on_extractor_error_cb (RygelMediaExportHarvestingTask* self, GFile* file, GError* _error_);
static void _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender, GFile* file, GError* err, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvesting_task_real_run_data_free (gpointer _data);
static void rygel_media_export_harvesting_task_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_harvesting_task_real_run_co (RygelMediaExportHarvestingTaskRunData* _data_);
static void rygel_media_export_harvesting_task_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_media_export_harvesting_task_process_file (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info, RygelMediaContainer* parent);
static gboolean rygel_media_export_harvesting_task_on_idle (RygelMediaExportHarvestingTask* self);
static gboolean _rygel_media_export_harvesting_task_on_idle_gsource_func (gpointer self);
static gboolean rygel_media_export_harvesting_task_push_if_changed_or_unknown (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info);
GQuark rygel_media_export_database_error_quark (void);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error);
void rygel_media_export_recursive_file_monitor_add (RygelMediaExportRecursiveFileMonitor* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_recursive_file_monitor_add_finish (RygelMediaExportRecursiveFileMonitor* self, GAsyncResult* _res_);
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_new (GFile* file, RygelMediaContainer* parent);
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_construct (GType object_type, GFile* file, RygelMediaContainer* parent);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dummy_container_get_type (void) G_GNUC_CONST;
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
static gboolean rygel_media_export_harvesting_task_process_children (RygelMediaExportHarvestingTask* self, GList* list);
void rygel_media_export_dummy_container_seen (RygelMediaExportDummyContainer* self, GFile* file);
static void rygel_media_export_harvesting_task_enumerate_directory_data_free (gpointer _data);
static void rygel_media_export_harvesting_task_enumerate_directory (RygelMediaExportHarvestingTask* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_export_harvesting_task_enumerate_directory_finish (RygelMediaExportHarvestingTask* self, GAsyncResult* _res_);
static gboolean rygel_media_export_harvesting_task_enumerate_directory_co (RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_);
static void rygel_media_export_harvesting_task_enumerate_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_media_export_harvesting_task_cleanup_database (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvesting_task_do_update (RygelMediaExportHarvestingTask* self);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file);
void rygel_media_export_media_cache_flag_object (RygelMediaExportMediaCache* self, GFile* file, const gchar* flag, GError** error);
RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, const gchar* mime, guint64 size, guint64 mtime);
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static void rygel_media_export_harvesting_task_finalize (GObject* obj);
static void _vala_rygel_media_export_harvesting_task_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_export_harvesting_task_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_queue_free__g_object_unref0_ (GQueue* self) {
	g_queue_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_queue_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender, GFile* file, GUPnPDLNAInformation* info, const gchar* mime, guint64 size, guint64 mtime, gpointer self) {
	rygel_media_export_harvesting_task_on_extracted_cb (self, file, info, mime, size, mtime);
}


static void _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender, GFile* file, GError* err, gpointer self) {
	rygel_media_export_harvesting_task_on_extractor_error_cb (self, file, err);
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag) {
	RygelMediaExportHarvestingTask * self = NULL;
	RygelMediaExportMetadataExtractor* _tmp0_;
	RygelMediaExportMetadataExtractor* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	RygelMediaContainer* _tmp4_;
	RygelMediaContainer* _tmp5_;
	RygelMediaExportMetadataExtractor* _tmp8_;
	RygelMediaExportMetadataExtractor* _tmp9_;
	GeeLinkedList* _tmp10_;
	GQueue* _tmp11_;
	RygelMediaExportRecursiveFileMonitor* _tmp12_;
	RygelMediaExportRecursiveFileMonitor* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GRegex* _tmp16_;
	GRegex* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (extractor != NULL, NULL);
	g_return_val_if_fail (monitor != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (RygelMediaExportHarvestingTask*) g_object_new (object_type, NULL);
	_tmp0_ = extractor;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->extractor);
	self->priv->extractor = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->origin);
	self->origin = _tmp3_;
	_tmp4_ = parent;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->parent);
	self->priv->parent = _tmp5_;
	{
		RygelMediaExportMediaCache* _tmp6_ = NULL;
		RygelMediaExportMediaCache* _tmp7_;
		_tmp6_ = rygel_media_export_media_cache_get_default (&_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch49_g_error;
		}
		_g_object_unref0 (self->priv->cache);
		self->priv->cache = _tmp7_;
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally49:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp8_ = self->priv->extractor;
	g_signal_connect_object (_tmp8_, "extraction-done", (GCallback) _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done, self, 0);
	_tmp9_ = self->priv->extractor;
	g_signal_connect_object (_tmp9_, "error", (GCallback) _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error, self, 0);
	_tmp10_ = gee_linked_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (self->priv->files);
	self->priv->files = (GeeQueue*) _tmp10_;
	_tmp11_ = g_queue_new ();
	__g_queue_free__g_object_unref0_0 (self->priv->containers);
	self->priv->containers = _tmp11_;
	_tmp12_ = monitor;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp13_;
	_tmp14_ = flag;
	_tmp15_ = g_strdup (_tmp14_);
	_g_free0 (self->priv->flag);
	self->priv->flag = _tmp15_;
	_tmp16_ = file_filter;
	_tmp17_ = _g_regex_ref0 (_tmp16_);
	_g_regex_unref0 (self->priv->file_filter);
	self->priv->file_filter = _tmp17_;
	return self;
}


RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag) {
	return rygel_media_export_harvesting_task_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, extractor, monitor, file_filter, file, parent, flag);
}


void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self) {
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_cancellable_new ();
	_tmp1_ = _tmp0_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp3_ = _tmp2_;
	g_cancellable_cancel (_tmp3_);
}


static void rygel_media_export_harvesting_task_real_run_data_free (gpointer _data) {
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportHarvestingTaskRunData, _data_);
}


static void rygel_media_export_harvesting_task_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportHarvestingTask * self;
	RygelMediaExportHarvestingTaskRunData* _data_;
	RygelMediaExportHarvestingTask* _tmp0_;
	self = (RygelMediaExportHarvestingTask*) base;
	_data_ = g_slice_new0 (RygelMediaExportHarvestingTaskRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_harvesting_task_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_harvesting_task_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_harvesting_task_real_run_co (_data_);
}


static void rygel_media_export_harvesting_task_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Extract all metainformation from a given file.
     *
     * What action will be taken depends on the arguments
     * * file is a simple file. Then only information of this
     *   file will be extracted
     * * file is a directory and recursive is false. The children
     *   of the directory (if not directories themselves) will be
     *   enqueued for extraction
     * * file is a directory and recursive is true. ++ All ++ children
     *   of the directory will be enqueued for extraction, even directories
     *
     * No matter how many children are contained within file's hierarchy,
     * only one event is sent when all the children are done.
     */
static void rygel_media_export_harvesting_task_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_harvesting_task_real_run_co (_data_);
}


static gboolean _rygel_media_export_harvesting_task_on_idle_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_media_export_harvesting_task_on_idle (self);
	return result;
}


static gboolean rygel_media_export_harvesting_task_real_run_co (RygelMediaExportHarvestingTaskRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->origin;
		_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp0_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp2_, rygel_media_export_harvesting_task_run_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_file_query_info_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
		_data_->info = _data_->_tmp3_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch50_g_error;
		}
		_data_->_tmp4_ = _data_->self->origin;
		_data_->_tmp5_ = _data_->self->priv->parent;
		_data_->_tmp6_ = FALSE;
		_data_->_tmp6_ = rygel_media_export_harvesting_task_process_file (_data_->self, _data_->_tmp4_, _data_->info, _data_->_tmp5_);
		if (_data_->_tmp6_) {
			_data_->_tmp7_ = 0;
			_data_->_tmp7_ = g_file_info_get_file_type (_data_->info);
			if (_data_->_tmp7_ != G_FILE_TYPE_DIRECTORY) {
				_data_->_tmp8_ = _data_->self->priv->containers;
				_data_->_tmp9_ = _data_->self->priv->parent;
				_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
				g_queue_push_tail (_data_->_tmp8_, _data_->_tmp10_);
			}
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_media_export_harvesting_task_on_idle_gsource_func, g_object_ref (_data_->self), g_object_unref);
		} else {
			g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
		}
		_g_object_unref0 (_data_->info);
	}
	goto __finally50;
	__catch50_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp11_ = _data_->_error_;
		if (!g_error_matches (_data_->_tmp11_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _ ("Failed to harvest file %s: %s");
			_data_->_tmp13_ = _data_->self->origin;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = g_file_get_uri (_data_->_tmp13_);
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp16_ = _data_->_error_;
			_data_->_tmp17_ = _data_->_tmp16_->message;
			g_warning (_data_->_tmp12_, _data_->_tmp15_, _data_->_tmp17_);
			_g_free0 (_data_->_tmp15_);
		} else {
			_data_->_tmp18_ = _data_->self->origin;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = g_file_get_uri (_data_->_tmp18_);
			_data_->_tmp20_ = _data_->_tmp19_;
			g_debug ("rygel-media-export-harvesting-task.vala:119: Harvesting of uri %s was " \
"cancelled", _data_->_tmp20_);
			_g_free0 (_data_->_tmp20_);
		}
		g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
		_g_error_free0 (_data_->_error_);
	}
	__finally50:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Add a file to the meta-data extraction queue.
     *
     * The file will only be added to the queue if one of the following
     * conditions is met:
     *   - The file is not in the cache
     *   - The current mtime of the file is larger than the cached
     *   - The size has changed
     * @param file to check
     * @param info FileInfo of the file to check
     * @return true, if the file has been queued, false otherwise.
     */
static gboolean rygel_media_export_harvesting_task_push_if_changed_or_unknown (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info) {
	gboolean result = FALSE;
	gint64 timestamp = 0LL;
	gint64 size = 0LL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	{
		RygelMediaExportMediaCache* _tmp0_;
		GFile* _tmp1_;
		gint64 _tmp2_ = 0LL;
		gint64 _tmp3_ = 0LL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		_tmp0_ = self->priv->cache;
		_tmp1_ = file;
		_tmp4_ = rygel_media_export_media_cache_exists (_tmp0_, _tmp1_, &_tmp2_, &_tmp3_, &_inner_error_);
		timestamp = _tmp2_;
		size = _tmp3_;
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch51_g_error;
		}
		if (_tmp5_) {
			GFileInfo* _tmp6_;
			guint64 _tmp7_ = 0ULL;
			gint64 mtime;
			gboolean _tmp8_ = FALSE;
			gint64 _tmp9_;
			gint64 _tmp10_;
			gboolean _tmp14_;
			_tmp6_ = info;
			_tmp7_ = g_file_info_get_attribute_uint64 (_tmp6_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
			mtime = (gint64) _tmp7_;
			_tmp9_ = mtime;
			_tmp10_ = timestamp;
			if (_tmp9_ > _tmp10_) {
				_tmp8_ = TRUE;
			} else {
				GFileInfo* _tmp11_;
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_;
				_tmp11_ = info;
				_tmp12_ = g_file_info_get_size (_tmp11_);
				_tmp13_ = size;
				_tmp8_ = _tmp12_ != _tmp13_;
			}
			_tmp14_ = _tmp8_;
			if (_tmp14_) {
				GeeQueue* _tmp15_;
				GFile* _tmp16_;
				_tmp15_ = self->priv->files;
				_tmp16_ = file;
				gee_queue_offer (_tmp15_, _tmp16_);
				result = TRUE;
				return result;
			}
		} else {
			GeeQueue* _tmp17_;
			GFile* _tmp18_;
			_tmp17_ = self->priv->files;
			_tmp18_ = file;
			gee_queue_offer (_tmp17_, _tmp18_);
			result = TRUE;
			return result;
		}
	}
	goto __finally51;
	__catch51_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = _ ("Failed to query database: %s");
		_tmp20_ = _error_;
		_tmp21_ = _tmp20_->message;
		g_warning (_tmp19_, _tmp21_);
		_g_error_free0 (_error_);
	}
	__finally51:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean rygel_media_export_harvesting_task_process_file (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info, RygelMediaContainer* parent) {
	gboolean result = FALSE;
	GFileInfo* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar _tmp2_ = '\0';
	GFileInfo* _tmp3_;
	GFileType _tmp4_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	g_return_val_if_fail (parent != NULL, FALSE);
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_name (_tmp0_);
	_tmp2_ = string_get (_tmp1_, (glong) 0);
	if (_tmp2_ == '.') {
		result = FALSE;
		return result;
	}
	_tmp3_ = info;
	_tmp4_ = g_file_info_get_file_type (_tmp3_);
	if (_tmp4_ == G_FILE_TYPE_DIRECTORY) {
		RygelMediaExportRecursiveFileMonitor* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		RygelMediaContainer* _tmp8_;
		RygelMediaExportDummyContainer* _tmp9_;
		RygelMediaExportDummyContainer* container;
		GQueue* _tmp10_;
		RygelMediaExportDummyContainer* _tmp11_;
		RygelMediaContainer* _tmp12_;
		_tmp5_ = self->priv->monitor;
		_tmp6_ = file;
		rygel_media_export_recursive_file_monitor_add (_tmp5_, _tmp6_, NULL, NULL);
		_tmp7_ = file;
		_tmp8_ = parent;
		_tmp9_ = rygel_media_export_dummy_container_new (_tmp7_, _tmp8_);
		container = _tmp9_;
		_tmp10_ = self->priv->containers;
		_tmp11_ = container;
		_tmp12_ = _g_object_ref0 ((RygelMediaContainer*) _tmp11_);
		g_queue_push_tail (_tmp10_, _tmp12_);
		{
			RygelMediaExportMediaCache* _tmp13_;
			RygelMediaExportDummyContainer* _tmp14_;
			_tmp13_ = self->priv->cache;
			_tmp14_ = container;
			rygel_media_export_media_cache_save_container (_tmp13_, (RygelMediaContainer*) _tmp14_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch52_g_error;
			}
		}
		goto __finally52;
		__catch52_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp15_ = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = _ ("Failed to update database: %s");
			_tmp16_ = err;
			_tmp17_ = _tmp16_->message;
			g_warning (_tmp15_, _tmp17_);
			result = FALSE;
			_g_error_free0 (err);
			_g_object_unref0 (container);
			return result;
		}
		__finally52:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (container);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		result = TRUE;
		_g_object_unref0 (container);
		return result;
	} else {
		gboolean _tmp18_ = FALSE;
		GRegex* _tmp19_;
		gboolean _tmp25_;
		GFile* _tmp26_;
		GFileInfo* _tmp27_;
		gboolean _tmp28_ = FALSE;
		_tmp19_ = self->priv->file_filter;
		if (_tmp19_ != NULL) {
			GRegex* _tmp20_;
			GFile* _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			gboolean _tmp24_ = FALSE;
			_tmp20_ = self->priv->file_filter;
			_tmp21_ = file;
			_tmp22_ = g_file_get_uri (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_regex_match (_tmp20_, _tmp23_, 0, NULL);
			_tmp18_ = !_tmp24_;
			_g_free0 (_tmp23_);
		} else {
			_tmp18_ = FALSE;
		}
		_tmp25_ = _tmp18_;
		if (_tmp25_) {
			result = FALSE;
			return result;
		}
		_tmp26_ = file;
		_tmp27_ = info;
		_tmp28_ = rygel_media_export_harvesting_task_push_if_changed_or_unknown (self, _tmp26_, _tmp27_);
		result = _tmp28_;
		return result;
	}
}


static gboolean rygel_media_export_harvesting_task_process_children (RygelMediaExportHarvestingTask* self, GList* list) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	gboolean _tmp5_;
	GQueue* _tmp6_;
	gconstpointer _tmp7_ = NULL;
	RygelMediaExportDummyContainer* _tmp8_;
	RygelMediaExportDummyContainer* container;
	GList* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = list;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GCancellable* _tmp2_;
		GCancellable* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_cancellable_is_cancelled (_tmp3_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->containers;
	_tmp7_ = g_queue_peek_head (_tmp6_);
	_tmp8_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER ((RygelMediaContainer*) _tmp7_) ? ((RygelMediaExportDummyContainer*) ((RygelMediaContainer*) _tmp7_)) : NULL);
	container = _tmp8_;
	_tmp9_ = list;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp9_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			GFileInfo* _tmp10_;
			GFileInfo* info = NULL;
			_tmp10_ = _g_object_ref0 ((GFileInfo*) info_it->data);
			info = _tmp10_;
			{
				RygelMediaExportDummyContainer* _tmp11_;
				GFile* _tmp12_;
				GFileInfo* _tmp13_;
				const gchar* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
				GFile* file;
				RygelMediaExportDummyContainer* _tmp16_;
				GFile* _tmp17_;
				GFile* _tmp18_;
				GFileInfo* _tmp19_;
				RygelMediaExportDummyContainer* _tmp20_;
				_tmp11_ = container;
				_tmp12_ = _tmp11_->file;
				_tmp13_ = info;
				_tmp14_ = g_file_info_get_name (_tmp13_);
				_tmp15_ = g_file_get_child (_tmp12_, _tmp14_);
				file = _tmp15_;
				_tmp16_ = container;
				_tmp17_ = file;
				rygel_media_export_dummy_container_seen (_tmp16_, _tmp17_);
				_tmp18_ = file;
				_tmp19_ = info;
				_tmp20_ = container;
				rygel_media_export_harvesting_task_process_file (self, _tmp18_, _tmp19_, (RygelMediaContainer*) _tmp20_);
				_g_object_unref0 (file);
				_g_object_unref0 (info);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (container);
	return result;
}


static void rygel_media_export_harvesting_task_enumerate_directory_data_free (gpointer _data) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportHarvestingTaskEnumerateDirectoryData, _data_);
}


static void rygel_media_export_harvesting_task_enumerate_directory (RygelMediaExportHarvestingTask* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	RygelMediaExportHarvestingTask* _tmp0_;
	_data_ = g_slice_new0 (RygelMediaExportHarvestingTaskEnumerateDirectoryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_harvesting_task_enumerate_directory);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_harvesting_task_enumerate_directory_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_harvesting_task_enumerate_directory_co (_data_);
}


static void rygel_media_export_harvesting_task_enumerate_directory_finish (RygelMediaExportHarvestingTask* self, GAsyncResult* _res_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_export_harvesting_task_enumerate_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_harvesting_task_enumerate_directory_co (_data_);
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean rygel_media_export_harvesting_task_enumerate_directory_co (RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->containers;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_queue_peek_head (_data_->_tmp0_);
	_data_->_tmp2_ = (RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER ((RygelMediaContainer*) _data_->_tmp1_) ? ((RygelMediaExportDummyContainer*) ((RygelMediaContainer*) _data_->_tmp1_)) : NULL)->file;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->directory = _data_->_tmp3_;
	{
		_data_->_tmp4_ = _data_->directory;
		_data_->_tmp5_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp4_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp6_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_file_enumerate_children_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
		_data_->enumerator = _data_->_tmp7_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch53_g_error;
		}
		_data_->list = NULL;
		{
			_data_->_tmp8_ = TRUE;
			while (TRUE) {
				_data_->_tmp9_ = _data_->_tmp8_;
				if (!_data_->_tmp9_) {
					_data_->_tmp10_ = _data_->list;
					_data_->_tmp11_ = FALSE;
					_data_->_tmp11_ = rygel_media_export_harvesting_task_process_children (_data_->self, _data_->_tmp10_);
					if (!_data_->_tmp11_) {
						break;
					}
				}
				_data_->_tmp8_ = FALSE;
				_data_->_tmp12_ = _data_->enumerator;
				_data_->_tmp13_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
				_data_->_tmp14_ = _data_->_tmp13_;
				_data_->_state_ = 2;
				g_file_enumerator_next_files_async (_data_->_tmp12_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_BATCH_SIZE, G_PRIORITY_DEFAULT, _data_->_tmp14_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = g_file_enumerator_next_files_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error_);
				_data_->_tmp16_ = _data_->_tmp15_;
				if (_data_->_inner_error_ != NULL) {
					__g_list_free__g_object_unref0_0 (_data_->list);
					_g_object_unref0 (_data_->enumerator);
					goto __catch53_g_error;
				}
				__g_list_free__g_object_unref0_0 (_data_->list);
				_data_->list = _data_->_tmp16_;
			}
		}
		_data_->_tmp17_ = _data_->enumerator;
		_data_->_tmp18_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_state_ = 3;
		g_file_enumerator_close_async (_data_->_tmp17_, G_PRIORITY_DEFAULT, _data_->_tmp19_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
		return FALSE;
		_state_3:
		g_file_enumerator_close_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			__g_list_free__g_object_unref0_0 (_data_->list);
			_g_object_unref0 (_data_->enumerator);
			goto __catch53_g_error;
		}
		__g_list_free__g_object_unref0_0 (_data_->list);
		_g_object_unref0 (_data_->enumerator);
	}
	goto __finally53;
	__catch53_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _ ("failed to enumerate folder: %s");
		_data_->_tmp21_ = _data_->err;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		g_warning (_data_->_tmp20_, _data_->_tmp22_);
		_g_error_free0 (_data_->err);
	}
	__finally53:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	rygel_media_export_harvesting_task_cleanup_database (_data_->self);
	rygel_media_export_harvesting_task_do_update (_data_->self);
	_g_object_unref0 (_data_->directory);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_export_harvesting_task_cleanup_database (RygelMediaExportHarvestingTask* self) {
	GQueue* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	RygelMediaExportDummyContainer* _tmp2_;
	RygelMediaExportDummyContainer* container;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->containers;
	_tmp1_ = g_queue_peek_head (_tmp0_);
	_tmp2_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER ((RygelMediaContainer*) _tmp1_) ? ((RygelMediaExportDummyContainer*) ((RygelMediaContainer*) _tmp1_)) : NULL);
	container = _tmp2_;
	{
		{
			RygelMediaExportDummyContainer* _tmp3_;
			GeeList* _tmp4_;
			GeeList* _tmp5_;
			GeeList* _child_list;
			GeeList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _child_size;
			gint _child_index;
			_tmp3_ = container;
			_tmp4_ = _tmp3_->children;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_child_list = _tmp5_;
			_tmp6_ = _child_list;
			_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_child_size = _tmp8_;
			_child_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				GeeList* _tmp12_;
				gint _tmp13_;
				gpointer _tmp14_ = NULL;
				gchar* child;
				RygelMediaExportMediaCache* _tmp15_;
				const gchar* _tmp16_;
				_tmp9_ = _child_index;
				_child_index = _tmp9_ + 1;
				_tmp10_ = _child_index;
				_tmp11_ = _child_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _child_list;
				_tmp13_ = _child_index;
				_tmp14_ = gee_list_get (_tmp12_, _tmp13_);
				child = (gchar*) _tmp14_;
				_tmp15_ = self->priv->cache;
				_tmp16_ = child;
				rygel_media_export_media_cache_remove_by_id (_tmp15_, _tmp16_, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (child);
					_g_object_unref0 (_child_list);
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch54_rygel_media_export_database_error;
					}
					_g_free0 (child);
					_g_object_unref0 (_child_list);
					_g_object_unref0 (container);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (child);
			}
			_g_object_unref0 (_child_list);
		}
	}
	goto __finally54;
	__catch54_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp17_ = NULL;
		RygelMediaExportDummyContainer* _tmp18_;
		const gchar* _tmp19_;
		GError* _tmp20_;
		const gchar* _tmp21_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = _ ("Failed to get children of container %s: %s");
		_tmp18_ = container;
		_tmp19_ = ((RygelMediaObject*) _tmp18_)->id;
		_tmp20_ = _error_;
		_tmp21_ = _tmp20_->message;
		g_warning (_tmp17_, _tmp19_, _tmp21_);
		_g_error_free0 (_error_);
	}
	__finally54:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (container);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (container);
}


static gboolean rygel_media_export_harvesting_task_on_idle (RygelMediaExportHarvestingTask* self) {
	gboolean result = FALSE;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeQueue* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_cancellable_is_cancelled (_tmp1_);
	if (_tmp2_) {
		g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->files;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		GeeQueue* _tmp6_;
		gpointer _tmp7_ = NULL;
		GFile* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		RygelMediaExportMetadataExtractor* _tmp11_;
		GeeQueue* _tmp12_;
		gpointer _tmp13_ = NULL;
		GFile* _tmp14_;
		_tmp6_ = self->priv->files;
		_tmp7_ = gee_queue_peek (_tmp6_);
		_tmp8_ = (GFile*) _tmp7_;
		_tmp9_ = g_file_get_uri (_tmp8_);
		_tmp10_ = _tmp9_;
		g_debug ("rygel-media-export-harvesting-task.vala:264: Scheduling file %s for me" \
"ta-data extraction…", _tmp10_);
		_g_free0 (_tmp10_);
		_g_object_unref0 (_tmp8_);
		_tmp11_ = self->priv->extractor;
		_tmp12_ = self->priv->files;
		_tmp13_ = gee_queue_peek (_tmp12_);
		_tmp14_ = (GFile*) _tmp13_;
		rygel_media_export_metadata_extractor_extract (_tmp11_, _tmp14_);
		_g_object_unref0 (_tmp14_);
	} else {
		GQueue* _tmp15_;
		guint _tmp16_ = 0U;
		_tmp15_ = self->priv->containers;
		_tmp16_ = g_queue_get_length (_tmp15_);
		if (_tmp16_ > ((guint) 0)) {
			rygel_media_export_harvesting_task_enumerate_directory (self, NULL, NULL);
		} else {
			const gchar* _tmp17_;
			RygelMediaContainer* _tmp21_;
			_tmp17_ = self->priv->flag;
			if (_tmp17_ != NULL) {
				{
					RygelMediaExportMediaCache* _tmp18_;
					GFile* _tmp19_;
					const gchar* _tmp20_;
					_tmp18_ = self->priv->cache;
					_tmp19_ = self->origin;
					_tmp20_ = self->priv->flag;
					rygel_media_export_media_cache_flag_object (_tmp18_, _tmp19_, _tmp20_, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch55_g_error;
					}
				}
				goto __finally55;
				__catch55_g_error:
				{
					GError* _error_ = NULL;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (_error_);
				}
				__finally55:
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			_tmp21_ = self->priv->parent;
			rygel_media_container_updated (_tmp21_);
			g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
		}
	}
	result = FALSE;
	return result;
}


static void rygel_media_export_harvesting_task_on_extracted_cb (RygelMediaExportHarvestingTask* self, GFile* file, GUPnPDLNAInformation* dlna, const gchar* mime, guint64 size, guint64 mtime) {
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeQueue* _tmp3_;
	gpointer _tmp4_ = NULL;
	GFile* entry;
	gboolean _tmp5_ = FALSE;
	GFile* _tmp6_;
	gboolean _tmp9_;
	RygelMediaItem* item = NULL;
	GUPnPDLNAInformation* _tmp10_;
	RygelMediaItem* _tmp26_;
	GeeQueue* _tmp32_;
	gpointer _tmp33_ = NULL;
	GFile* _tmp34_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (mime != NULL);
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_cancellable_is_cancelled (_tmp1_);
	if (_tmp2_) {
		g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	}
	_tmp3_ = self->priv->files;
	_tmp4_ = gee_queue_peek (_tmp3_);
	entry = (GFile*) _tmp4_;
	_tmp6_ = entry;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		GFile* _tmp7_;
		GFile* _tmp8_;
		_tmp7_ = file;
		_tmp8_ = entry;
		_tmp5_ = _tmp7_ != _tmp8_;
	}
	_tmp9_ = _tmp5_;
	if (_tmp9_) {
		_g_object_unref0 (entry);
		return;
	}
	_tmp10_ = dlna;
	if (_tmp10_ == NULL) {
		GQueue* _tmp11_;
		gconstpointer _tmp12_ = NULL;
		GFile* _tmp13_;
		const gchar* _tmp14_;
		guint64 _tmp15_;
		guint64 _tmp16_;
		RygelMediaItem* _tmp17_ = NULL;
		_tmp11_ = self->priv->containers;
		_tmp12_ = g_queue_peek_head (_tmp11_);
		_tmp13_ = file;
		_tmp14_ = mime;
		_tmp15_ = size;
		_tmp16_ = mtime;
		_tmp17_ = rygel_media_export_item_factory_create_simple ((RygelMediaContainer*) _tmp12_, _tmp13_, _tmp14_, _tmp15_, _tmp16_);
		_g_object_unref0 (item);
		item = _tmp17_;
	} else {
		GQueue* _tmp18_;
		gconstpointer _tmp19_ = NULL;
		GFile* _tmp20_;
		GUPnPDLNAInformation* _tmp21_;
		const gchar* _tmp22_;
		guint64 _tmp23_;
		guint64 _tmp24_;
		RygelMediaItem* _tmp25_ = NULL;
		_tmp18_ = self->priv->containers;
		_tmp19_ = g_queue_peek_head (_tmp18_);
		_tmp20_ = file;
		_tmp21_ = dlna;
		_tmp22_ = mime;
		_tmp23_ = size;
		_tmp24_ = mtime;
		_tmp25_ = rygel_media_export_item_factory_create_from_info ((RygelMediaContainer*) _tmp19_, _tmp20_, _tmp21_, _tmp22_, _tmp23_, _tmp24_);
		_g_object_unref0 (item);
		item = _tmp25_;
	}
	_tmp26_ = item;
	if (_tmp26_ != NULL) {
		RygelMediaItem* _tmp27_;
		GQueue* _tmp28_;
		gconstpointer _tmp29_ = NULL;
		_tmp27_ = item;
		_tmp28_ = self->priv->containers;
		_tmp29_ = g_queue_peek_head (_tmp28_);
		rygel_media_object_set_parent_ref ((RygelMediaObject*) _tmp27_, (RygelMediaContainer*) _tmp29_);
		{
			RygelMediaExportMediaCache* _tmp30_;
			RygelMediaItem* _tmp31_;
			_tmp30_ = self->priv->cache;
			_tmp31_ = item;
			rygel_media_export_media_cache_save_item (_tmp30_, _tmp31_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch56_g_error;
			}
		}
		goto __finally56;
		__catch56_g_error:
		{
			GError* _error_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (_error_);
		}
		__finally56:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (item);
			_g_object_unref0 (entry);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp32_ = self->priv->files;
	_tmp33_ = gee_queue_poll (_tmp32_);
	_tmp34_ = (GFile*) _tmp33_;
	_g_object_unref0 (_tmp34_);
	rygel_media_export_harvesting_task_do_update (self);
	_g_object_unref0 (item);
	_g_object_unref0 (entry);
}


static void rygel_media_export_harvesting_task_on_extractor_error_cb (RygelMediaExportHarvestingTask* self, GFile* file, GError* _error_) {
	GeeQueue* _tmp0_;
	gpointer _tmp1_ = NULL;
	GFile* entry;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_;
	gboolean _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GeeQueue* _tmp12_;
	gpointer _tmp13_ = NULL;
	GFile* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->files;
	_tmp1_ = gee_queue_peek (_tmp0_);
	entry = (GFile*) _tmp1_;
	_tmp3_ = entry;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp4_ = file;
		_tmp5_ = entry;
		_tmp2_ = _tmp4_ != _tmp5_;
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		_g_object_unref0 (entry);
		return;
	}
	_tmp7_ = file;
	_tmp8_ = g_file_get_uri (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _error_;
	_tmp11_ = _tmp10_->message;
	g_debug ("rygel-media-export-harvesting-task.vala:342: Skipping %s; extraction c" \
"ompletely failed: %s", _tmp9_, _tmp11_);
	_g_free0 (_tmp9_);
	_tmp12_ = self->priv->files;
	_tmp13_ = gee_queue_poll (_tmp12_);
	_tmp14_ = (GFile*) _tmp13_;
	_g_object_unref0 (_tmp14_);
	rygel_media_export_harvesting_task_do_update (self);
	_g_object_unref0 (entry);
}


/**
     * If all files of a container were processed, notify the container
     * about this and set the updating signal.
     * Reschedule the iteration and extraction
     */
static void rygel_media_export_harvesting_task_do_update (RygelMediaExportHarvestingTask* self) {
	gboolean _tmp0_ = FALSE;
	GeeQueue* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->files;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		GQueue* _tmp4_;
		guint _tmp5_ = 0U;
		_tmp4_ = self->priv->containers;
		_tmp5_ = g_queue_get_length (_tmp4_);
		_tmp0_ = _tmp5_ != ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		GQueue* _tmp7_;
		gconstpointer _tmp8_ = NULL;
		RygelMediaContainer* _tmp9_;
		RygelMediaContainer* container;
		GQueue* _tmp21_;
		gpointer _tmp22_ = NULL;
		RygelMediaContainer* _tmp23_;
		_tmp7_ = self->priv->containers;
		_tmp8_ = g_queue_peek_head (_tmp7_);
		_tmp9_ = _g_object_ref0 ((RygelMediaContainer*) _tmp8_);
		container = _tmp9_;
		{
			RygelMediaExportMediaCache* _tmp10_ = NULL;
			RygelMediaExportMediaCache* cache;
			RygelMediaExportMediaCache* _tmp11_;
			RygelMediaContainer* _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_ = 0;
			gint _tmp15_;
			_tmp10_ = rygel_media_export_media_cache_get_default (&_inner_error_);
			cache = _tmp10_;
			if (_inner_error_ != NULL) {
				goto __catch57_g_error;
			}
			_tmp11_ = cache;
			_tmp12_ = container;
			_tmp13_ = ((RygelMediaObject*) _tmp12_)->id;
			_tmp14_ = rygel_media_export_media_cache_get_child_count (_tmp11_, _tmp13_, &_inner_error_);
			_tmp15_ = _tmp14_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (cache);
				goto __catch57_g_error;
			}
			if (_tmp15_ > 0) {
				GQueue* _tmp16_;
				gconstpointer _tmp17_ = NULL;
				_tmp16_ = self->priv->containers;
				_tmp17_ = g_queue_peek_head (_tmp16_);
				rygel_media_container_updated ((RygelMediaContainer*) _tmp17_);
			} else {
				RygelMediaExportMediaCache* _tmp18_;
				RygelMediaContainer* _tmp19_;
				const gchar* _tmp20_;
				_tmp18_ = cache;
				_tmp19_ = container;
				_tmp20_ = ((RygelMediaObject*) _tmp19_)->id;
				rygel_media_export_media_cache_remove_by_id (_tmp18_, _tmp20_, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (cache);
					goto __catch57_g_error;
				}
			}
			_g_object_unref0 (cache);
		}
		goto __finally57;
		__catch57_g_error:
		{
			GError* _error_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (_error_);
		}
		__finally57:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (container);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp21_ = self->priv->containers;
		_tmp22_ = g_queue_pop_head (_tmp21_);
		_tmp23_ = (RygelMediaContainer*) _tmp22_;
		_g_object_unref0 (_tmp23_);
		_g_object_unref0 (container);
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_media_export_harvesting_task_on_idle_gsource_func, g_object_ref (self), g_object_unref);
}


static GCancellable* rygel_media_export_harvesting_task_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelMediaExportHarvestingTask* self;
	GCancellable* _tmp0_;
	self = (RygelMediaExportHarvestingTask*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static void rygel_media_export_harvesting_task_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelMediaExportHarvestingTask* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelMediaExportHarvestingTask*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_media_export_harvesting_task_class_init (RygelMediaExportHarvestingTaskClass * klass) {
	rygel_media_export_harvesting_task_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvestingTaskPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_harvesting_task_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_harvesting_task_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvesting_task_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE, "cancellable");
}


static void rygel_media_export_harvesting_task_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_media_export_harvesting_task_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_media_export_harvesting_task_real_run;
	iface->run_finish = rygel_media_export_harvesting_task_real_run_finish;
	iface->get_cancellable = rygel_media_export_harvesting_task_real_get_cancellable;
	iface->set_cancellable = rygel_media_export_harvesting_task_real_set_cancellable;
}


static void rygel_media_export_harvesting_task_instance_init (RygelMediaExportHarvestingTask * self) {
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_PRIVATE (self);
}


static void rygel_media_export_harvesting_task_finalize (GObject* obj) {
	RygelMediaExportHarvestingTask * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTING_TASK (obj);
	_g_object_unref0 (self->origin);
	_g_object_unref0 (self->priv->extractor);
	_g_object_unref0 (self->priv->cache);
	__g_queue_free__g_object_unref0_0 (self->priv->containers);
	_g_object_unref0 (self->priv->files);
	_g_object_unref0 (self->priv->monitor);
	_g_regex_unref0 (self->priv->file_filter);
	_g_free0 (self->priv->flag);
	_g_object_unref0 (self->priv->parent);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_media_export_harvesting_task_parent_class)->finalize (obj);
}


GType rygel_media_export_harvesting_task_get_type (void) {
	static volatile gsize rygel_media_export_harvesting_task_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvesting_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvestingTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvesting_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvestingTask), 0, (GInstanceInitFunc) rygel_media_export_harvesting_task_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_media_export_harvesting_task_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_export_harvesting_task_type_id;
		rygel_media_export_harvesting_task_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvestingTask", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_media_export_harvesting_task_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_media_export_harvesting_task_type_id__volatile, rygel_media_export_harvesting_task_type_id);
	}
	return rygel_media_export_harvesting_task_type_id__volatile;
}


static void _vala_rygel_media_export_harvesting_task_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvestingTask * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTING_TASK (object);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_export_harvesting_task_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvestingTask * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTING_TASK (object);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



